/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import * as tslib_1 from "tslib";
import * as Models from "./models";
import * as Mappers from "./models/mappers";
import * as operations from "./operations";
import { StorageClientContext } from "./storageClientContext";
var StorageClient = /** @class */ (function (_super) {
    tslib_1.__extends(StorageClient, _super);
    /**
     * Initializes a new instance of the StorageClient class.
     * @param url The URL of the service account, container, or blob that is the targe of the desired
     * operation.
     * @param [options] The parameter options
     */
    function StorageClient(url, options) {
        var _this = _super.call(this, url, options) || this;
        _this.service = new operations.Service(_this);
        _this.container = new operations.Container(_this);
        _this.directory = new operations.Directory(_this);
        _this.blob = new operations.Blob(_this);
        _this.pageBlob = new operations.PageBlob(_this);
        _this.appendBlob = new operations.AppendBlob(_this);
        _this.blockBlob = new operations.BlockBlob(_this);
        return _this;
    }
    return StorageClient;
}(StorageClientContext));
// Operation Specifications
export { StorageClient, StorageClientContext, Models as StorageModels, Mappers as StorageMappers };
export * from "./operations";
//# sourceMappingURL=storageClient.js.map