import * as tslib_1 from "tslib";
import { HttpHeaders } from "@azure/ms-rest-js";
import { HeaderConstants } from "../utils/constants";
import { CredentialPolicy } from "./CredentialPolicy";
/**
 * TokenCredentialPolicy is a policy used to sign HTTP request with a token.
 * Such as an OAuth bearer token.
 *
 * @export
 * @class TokenCredentialPolicy
 * @extends {CredentialPolicy}
 */
var TokenCredentialPolicy = /** @class */ (function (_super) {
    tslib_1.__extends(TokenCredentialPolicy, _super);
    /**
     * Creates an instance of TokenCredentialPolicy.
     * @param {RequestPolicy} nextPolicy
     * @param {RequestPolicyOptions} options
     * @param {TokenCredential} tokenCredential
     * @memberof TokenCredentialPolicy
     */
    function TokenCredentialPolicy(nextPolicy, options, tokenCredential) {
        var _this = _super.call(this, nextPolicy, options) || this;
        _this.tokenCredential = tokenCredential;
        _this.authorizationScheme = HeaderConstants.AUTHORIZATION_SCHEME;
        return _this;
    }
    /**
     * Sign request with token.
     *
     * @protected
     * @param {WebResource} request
     * @returns {WebResource}
     * @memberof TokenCredentialPolicy
     */
    TokenCredentialPolicy.prototype.signRequest = function (request) {
        if (!request.headers) {
            request.headers = new HttpHeaders();
        }
        request.headers.set(HeaderConstants.AUTHORIZATION, this.authorizationScheme + " " + this.tokenCredential.token);
        return request;
    };
    return TokenCredentialPolicy;
}(CredentialPolicy));
export { TokenCredentialPolicy };
//# sourceMappingURL=TokenCredentialPolicy.js.map