import * as tslib_1 from "tslib";
var MutexLockStatus;
(function (MutexLockStatus) {
    MutexLockStatus[MutexLockStatus["LOCKED"] = 0] = "LOCKED";
    MutexLockStatus[MutexLockStatus["UNLOCKED"] = 1] = "UNLOCKED";
})(MutexLockStatus || (MutexLockStatus = {}));
/**
 * An async mutex lock.
 *
 * @export
 * @class Mutex
 */
var Mutex = /** @class */ (function () {
    function Mutex() {
    }
    /**
     * Lock for a specific key. If the lock has been acquired by another customer, then
     * will wait until getting the lock.
     *
     * @static
     * @param {string} key lock key
     * @returns {Promise<void>}
     * @memberof Mutex
     */
    Mutex.lock = function (key) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve) {
                        if (_this.keys[key] === undefined || _this.keys[key] === MutexLockStatus.UNLOCKED) {
                            _this.keys[key] = MutexLockStatus.LOCKED;
                            resolve();
                        }
                        else {
                            _this.onUnlockEvent(key, function () {
                                _this.keys[key] = MutexLockStatus.LOCKED;
                                resolve();
                            });
                        }
                    })];
            });
        });
    };
    /**
     * Unlock a key.
     *
     * @static
     * @param {string} key
     * @returns {Promise<void>}
     * @memberof Mutex
     */
    Mutex.unlock = function (key) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve) {
                        if (_this.keys[key] === MutexLockStatus.LOCKED) {
                            _this.emitUnlockEvent(key);
                        }
                        delete _this.keys[key];
                        resolve();
                    })];
            });
        });
    };
    Mutex.onUnlockEvent = function (key, handler) {
        if (this.listeners[key] === undefined) {
            this.listeners[key] = [handler];
        }
        else {
            this.listeners[key].push(handler);
        }
    };
    Mutex.emitUnlockEvent = function (key) {
        var _this = this;
        if (this.listeners[key] !== undefined && this.listeners[key].length > 0) {
            var handler_1 = this.listeners[key].shift();
            setImmediate(function () {
                handler_1.call(_this);
            });
        }
    };
    Mutex.keys = {};
    Mutex.listeners = {};
    return Mutex;
}());
export { Mutex };
//# sourceMappingURL=Mutex.js.map