/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */

import * as msRest from "@azure/ms-rest-js";


export const KeyInfo: msRest.CompositeMapper = {
  serializedName: "KeyInfo",
  type: {
    name: "Composite",
    className: "KeyInfo",
    modelProperties: {
      start: {
        xmlName: "Start",
        required: true,
        serializedName: "Start",
        type: {
          name: "String"
        }
      },
      expiry: {
        xmlName: "Expiry",
        required: true,
        serializedName: "Expiry",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const UserDelegationKey: msRest.CompositeMapper = {
  serializedName: "UserDelegationKey",
  type: {
    name: "Composite",
    className: "UserDelegationKey",
    modelProperties: {
      signedOid: {
        xmlName: "SignedOid",
        required: true,
        serializedName: "SignedOid",
        type: {
          name: "String"
        }
      },
      signedTid: {
        xmlName: "SignedTid",
        required: true,
        serializedName: "SignedTid",
        type: {
          name: "String"
        }
      },
      signedStart: {
        xmlName: "SignedStart",
        required: true,
        serializedName: "SignedStart",
        type: {
          name: "String"
        }
      },
      signedExpiry: {
        xmlName: "SignedExpiry",
        required: true,
        serializedName: "SignedExpiry",
        type: {
          name: "String"
        }
      },
      signedService: {
        xmlName: "SignedService",
        required: true,
        serializedName: "SignedService",
        type: {
          name: "String"
        }
      },
      signedVersion: {
        xmlName: "SignedVersion",
        required: true,
        serializedName: "SignedVersion",
        type: {
          name: "String"
        }
      },
      value: {
        xmlName: "Value",
        required: true,
        serializedName: "Value",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const StorageError: msRest.CompositeMapper = {
  serializedName: "StorageError",
  type: {
    name: "Composite",
    className: "StorageError",
    modelProperties: {
      message: {
        xmlName: "Message",
        serializedName: "Message",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const DataLakeStorageErrorError: msRest.CompositeMapper = {
  serializedName: "DataLakeStorageError_error",
  type: {
    name: "Composite",
    className: "DataLakeStorageErrorError",
    modelProperties: {
      code: {
        xmlName: "Code",
        serializedName: "Code",
        type: {
          name: "String"
        }
      },
      message: {
        xmlName: "Message",
        serializedName: "Message",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const DataLakeStorageError: msRest.CompositeMapper = {
  serializedName: "DataLakeStorageError",
  type: {
    name: "Composite",
    className: "DataLakeStorageError",
    modelProperties: {
      error: {
        xmlName: "error",
        serializedName: "error",
        type: {
          name: "Composite",
          className: "DataLakeStorageErrorError"
        }
      }
    }
  }
};

export const AccessPolicy: msRest.CompositeMapper = {
  serializedName: "AccessPolicy",
  type: {
    name: "Composite",
    className: "AccessPolicy",
    modelProperties: {
      start: {
        xmlName: "Start",
        required: true,
        serializedName: "Start",
        type: {
          name: "String"
        }
      },
      expiry: {
        xmlName: "Expiry",
        required: true,
        serializedName: "Expiry",
        type: {
          name: "String"
        }
      },
      permission: {
        xmlName: "Permission",
        required: true,
        serializedName: "Permission",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobProperties: msRest.CompositeMapper = {
  xmlName: "Properties",
  serializedName: "BlobProperties",
  type: {
    name: "Composite",
    className: "BlobProperties",
    modelProperties: {
      creationTime: {
        xmlName: "Creation-Time",
        serializedName: "Creation-Time",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      lastModified: {
        xmlName: "Last-Modified",
        required: true,
        serializedName: "Last-Modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      etag: {
        xmlName: "Etag",
        required: true,
        serializedName: "Etag",
        type: {
          name: "String"
        }
      },
      contentLength: {
        xmlName: "Content-Length",
        serializedName: "Content-Length",
        type: {
          name: "Number"
        }
      },
      contentType: {
        xmlName: "Content-Type",
        serializedName: "Content-Type",
        type: {
          name: "String"
        }
      },
      contentEncoding: {
        xmlName: "Content-Encoding",
        serializedName: "Content-Encoding",
        type: {
          name: "String"
        }
      },
      contentLanguage: {
        xmlName: "Content-Language",
        serializedName: "Content-Language",
        type: {
          name: "String"
        }
      },
      contentMD5: {
        xmlName: "Content-MD5",
        serializedName: "Content-MD5",
        type: {
          name: "ByteArray"
        }
      },
      contentDisposition: {
        xmlName: "Content-Disposition",
        serializedName: "Content-Disposition",
        type: {
          name: "String"
        }
      },
      cacheControl: {
        xmlName: "Cache-Control",
        serializedName: "Cache-Control",
        type: {
          name: "String"
        }
      },
      blobSequenceNumber: {
        xmlName: "x-ms-blob-sequence-number",
        serializedName: "x-ms-blob-sequence-number",
        type: {
          name: "Number"
        }
      },
      blobType: {
        xmlName: "BlobType",
        serializedName: "BlobType",
        type: {
          name: "Enum",
          allowedValues: [
            "BlockBlob",
            "PageBlob",
            "AppendBlob"
          ]
        }
      },
      leaseStatus: {
        xmlName: "LeaseStatus",
        serializedName: "LeaseStatus",
        type: {
          name: "Enum",
          allowedValues: [
            "locked",
            "unlocked"
          ]
        }
      },
      leaseState: {
        xmlName: "LeaseState",
        serializedName: "LeaseState",
        type: {
          name: "Enum",
          allowedValues: [
            "available",
            "leased",
            "expired",
            "breaking",
            "broken"
          ]
        }
      },
      leaseDuration: {
        xmlName: "LeaseDuration",
        serializedName: "LeaseDuration",
        type: {
          name: "Enum",
          allowedValues: [
            "infinite",
            "fixed"
          ]
        }
      },
      copyId: {
        xmlName: "CopyId",
        serializedName: "CopyId",
        type: {
          name: "String"
        }
      },
      copyStatus: {
        xmlName: "CopyStatus",
        serializedName: "CopyStatus",
        type: {
          name: "Enum",
          allowedValues: [
            "pending",
            "success",
            "aborted",
            "failed"
          ]
        }
      },
      copySource: {
        xmlName: "CopySource",
        serializedName: "CopySource",
        type: {
          name: "String"
        }
      },
      copyProgress: {
        xmlName: "CopyProgress",
        serializedName: "CopyProgress",
        type: {
          name: "String"
        }
      },
      copyCompletionTime: {
        xmlName: "CopyCompletionTime",
        serializedName: "CopyCompletionTime",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      copyStatusDescription: {
        xmlName: "CopyStatusDescription",
        serializedName: "CopyStatusDescription",
        type: {
          name: "String"
        }
      },
      serverEncrypted: {
        xmlName: "ServerEncrypted",
        serializedName: "ServerEncrypted",
        type: {
          name: "Boolean"
        }
      },
      incrementalCopy: {
        xmlName: "IncrementalCopy",
        serializedName: "IncrementalCopy",
        type: {
          name: "Boolean"
        }
      },
      destinationSnapshot: {
        xmlName: "DestinationSnapshot",
        serializedName: "DestinationSnapshot",
        type: {
          name: "String"
        }
      },
      deletedTime: {
        xmlName: "DeletedTime",
        serializedName: "DeletedTime",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      remainingRetentionDays: {
        xmlName: "RemainingRetentionDays",
        serializedName: "RemainingRetentionDays",
        type: {
          name: "Number"
        }
      },
      accessTier: {
        xmlName: "AccessTier",
        serializedName: "AccessTier",
        type: {
          name: "String"
        }
      },
      accessTierInferred: {
        xmlName: "AccessTierInferred",
        serializedName: "AccessTierInferred",
        type: {
          name: "Boolean"
        }
      },
      archiveStatus: {
        xmlName: "ArchiveStatus",
        serializedName: "ArchiveStatus",
        type: {
          name: "String"
        }
      },
      customerProvidedKeySha256: {
        xmlName: "CustomerProvidedKeySha256",
        serializedName: "CustomerProvidedKeySha256",
        type: {
          name: "String"
        }
      },
      accessTierChangeTime: {
        xmlName: "AccessTierChangeTime",
        serializedName: "AccessTierChangeTime",
        type: {
          name: "DateTimeRfc1123"
        }
      }
    }
  }
};

export const BlobMetadata: msRest.CompositeMapper = {
  xmlName: "Metadata",
  serializedName: "BlobMetadata",
  type: {
    name: "Composite",
    className: "BlobMetadata",
    modelProperties: {
      encrypted: {
        xmlIsAttribute: true,
        xmlName: "Encrypted",
        serializedName: "Encrypted",
        type: {
          name: "String"
        }
      }
    },
    additionalProperties: {
      type: {
        name: "String"
      }
    }
  }
};

export const BlobItem: msRest.CompositeMapper = {
  xmlName: "Blob",
  serializedName: "BlobItem",
  type: {
    name: "Composite",
    className: "BlobItem",
    modelProperties: {
      name: {
        xmlName: "Name",
        required: true,
        serializedName: "Name",
        type: {
          name: "String"
        }
      },
      deleted: {
        xmlName: "Deleted",
        required: true,
        serializedName: "Deleted",
        type: {
          name: "Boolean"
        }
      },
      snapshot: {
        xmlName: "Snapshot",
        required: true,
        serializedName: "Snapshot",
        type: {
          name: "String"
        }
      },
      properties: {
        xmlName: "Properties",
        required: true,
        serializedName: "Properties",
        type: {
          name: "Composite",
          className: "BlobProperties"
        }
      },
      metadata: {
        xmlName: "Metadata",
        serializedName: "Metadata",
        type: {
          name: "Composite",
          className: "BlobMetadata",
          additionalProperties: {
            type: {
              name: "String"
            }
          }
        }
      }
    }
  }
};

export const BlobFlatListSegment: msRest.CompositeMapper = {
  xmlName: "Blobs",
  serializedName: "BlobFlatListSegment",
  type: {
    name: "Composite",
    className: "BlobFlatListSegment",
    modelProperties: {
      blobItems: {
        xmlName: "BlobItems",
        xmlElementName: "Blob",
        required: true,
        serializedName: "BlobItems",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "BlobItem"
            }
          }
        }
      }
    }
  }
};

export const ListBlobsFlatSegmentResponse: msRest.CompositeMapper = {
  xmlName: "EnumerationResults",
  serializedName: "ListBlobsFlatSegmentResponse",
  type: {
    name: "Composite",
    className: "ListBlobsFlatSegmentResponse",
    modelProperties: {
      serviceEndpoint: {
        xmlIsAttribute: true,
        xmlName: "ServiceEndpoint",
        required: true,
        serializedName: "ServiceEndpoint",
        type: {
          name: "String"
        }
      },
      containerName: {
        xmlIsAttribute: true,
        xmlName: "ContainerName",
        required: true,
        serializedName: "ContainerName",
        type: {
          name: "String"
        }
      },
      prefix: {
        xmlName: "Prefix",
        serializedName: "Prefix",
        type: {
          name: "String"
        }
      },
      marker: {
        xmlName: "Marker",
        serializedName: "Marker",
        type: {
          name: "String"
        }
      },
      maxResults: {
        xmlName: "MaxResults",
        serializedName: "MaxResults",
        type: {
          name: "Number"
        }
      },
      delimiter: {
        xmlName: "Delimiter",
        serializedName: "Delimiter",
        type: {
          name: "String"
        }
      },
      segment: {
        xmlName: "Blobs",
        required: true,
        serializedName: "Segment",
        type: {
          name: "Composite",
          className: "BlobFlatListSegment"
        }
      },
      nextMarker: {
        xmlName: "NextMarker",
        serializedName: "NextMarker",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobPrefix: msRest.CompositeMapper = {
  serializedName: "BlobPrefix",
  type: {
    name: "Composite",
    className: "BlobPrefix",
    modelProperties: {
      name: {
        xmlName: "Name",
        required: true,
        serializedName: "Name",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobHierarchyListSegment: msRest.CompositeMapper = {
  xmlName: "Blobs",
  serializedName: "BlobHierarchyListSegment",
  type: {
    name: "Composite",
    className: "BlobHierarchyListSegment",
    modelProperties: {
      blobPrefixes: {
        xmlName: "BlobPrefixes",
        xmlElementName: "BlobPrefix",
        serializedName: "BlobPrefixes",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "BlobPrefix"
            }
          }
        }
      },
      blobItems: {
        xmlName: "BlobItems",
        xmlElementName: "Blob",
        required: true,
        serializedName: "BlobItems",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "BlobItem"
            }
          }
        }
      }
    }
  }
};

export const ListBlobsHierarchySegmentResponse: msRest.CompositeMapper = {
  xmlName: "EnumerationResults",
  serializedName: "ListBlobsHierarchySegmentResponse",
  type: {
    name: "Composite",
    className: "ListBlobsHierarchySegmentResponse",
    modelProperties: {
      serviceEndpoint: {
        xmlIsAttribute: true,
        xmlName: "ServiceEndpoint",
        required: true,
        serializedName: "ServiceEndpoint",
        type: {
          name: "String"
        }
      },
      containerName: {
        xmlIsAttribute: true,
        xmlName: "ContainerName",
        required: true,
        serializedName: "ContainerName",
        type: {
          name: "String"
        }
      },
      prefix: {
        xmlName: "Prefix",
        serializedName: "Prefix",
        type: {
          name: "String"
        }
      },
      marker: {
        xmlName: "Marker",
        serializedName: "Marker",
        type: {
          name: "String"
        }
      },
      maxResults: {
        xmlName: "MaxResults",
        serializedName: "MaxResults",
        type: {
          name: "Number"
        }
      },
      delimiter: {
        xmlName: "Delimiter",
        serializedName: "Delimiter",
        type: {
          name: "String"
        }
      },
      segment: {
        xmlName: "Blobs",
        required: true,
        serializedName: "Segment",
        type: {
          name: "Composite",
          className: "BlobHierarchyListSegment"
        }
      },
      nextMarker: {
        xmlName: "NextMarker",
        serializedName: "NextMarker",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const Block: msRest.CompositeMapper = {
  serializedName: "Block",
  type: {
    name: "Composite",
    className: "Block",
    modelProperties: {
      name: {
        xmlName: "Name",
        required: true,
        serializedName: "Name",
        type: {
          name: "String"
        }
      },
      size: {
        xmlName: "Size",
        required: true,
        serializedName: "Size",
        type: {
          name: "Number"
        }
      }
    }
  }
};

export const BlockList: msRest.CompositeMapper = {
  serializedName: "BlockList",
  type: {
    name: "Composite",
    className: "BlockList",
    modelProperties: {
      committedBlocks: {
        xmlIsWrapped: true,
        xmlName: "CommittedBlocks",
        xmlElementName: "Block",
        serializedName: "CommittedBlocks",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "Block"
            }
          }
        }
      },
      uncommittedBlocks: {
        xmlIsWrapped: true,
        xmlName: "UncommittedBlocks",
        xmlElementName: "Block",
        serializedName: "UncommittedBlocks",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "Block"
            }
          }
        }
      }
    }
  }
};

export const BlockLookupList: msRest.CompositeMapper = {
  xmlName: "BlockList",
  serializedName: "BlockLookupList",
  type: {
    name: "Composite",
    className: "BlockLookupList",
    modelProperties: {
      committed: {
        xmlName: "Committed",
        xmlElementName: "Committed",
        serializedName: "Committed",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "String"
            }
          }
        }
      },
      uncommitted: {
        xmlName: "Uncommitted",
        xmlElementName: "Uncommitted",
        serializedName: "Uncommitted",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "String"
            }
          }
        }
      },
      latest: {
        xmlName: "Latest",
        xmlElementName: "Latest",
        serializedName: "Latest",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "String"
            }
          }
        }
      }
    }
  }
};

export const ContainerProperties: msRest.CompositeMapper = {
  serializedName: "ContainerProperties",
  type: {
    name: "Composite",
    className: "ContainerProperties",
    modelProperties: {
      lastModified: {
        xmlName: "Last-Modified",
        required: true,
        serializedName: "Last-Modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      etag: {
        xmlName: "Etag",
        required: true,
        serializedName: "Etag",
        type: {
          name: "String"
        }
      },
      leaseStatus: {
        xmlName: "LeaseStatus",
        serializedName: "LeaseStatus",
        type: {
          name: "Enum",
          allowedValues: [
            "locked",
            "unlocked"
          ]
        }
      },
      leaseState: {
        xmlName: "LeaseState",
        serializedName: "LeaseState",
        type: {
          name: "Enum",
          allowedValues: [
            "available",
            "leased",
            "expired",
            "breaking",
            "broken"
          ]
        }
      },
      leaseDuration: {
        xmlName: "LeaseDuration",
        serializedName: "LeaseDuration",
        type: {
          name: "Enum",
          allowedValues: [
            "infinite",
            "fixed"
          ]
        }
      },
      publicAccess: {
        xmlName: "PublicAccess",
        serializedName: "PublicAccess",
        type: {
          name: "String"
        }
      },
      hasImmutabilityPolicy: {
        xmlName: "HasImmutabilityPolicy",
        serializedName: "HasImmutabilityPolicy",
        type: {
          name: "Boolean"
        }
      },
      hasLegalHold: {
        xmlName: "HasLegalHold",
        serializedName: "HasLegalHold",
        type: {
          name: "Boolean"
        }
      }
    }
  }
};

export const ContainerItem: msRest.CompositeMapper = {
  xmlName: "Container",
  serializedName: "ContainerItem",
  type: {
    name: "Composite",
    className: "ContainerItem",
    modelProperties: {
      name: {
        xmlName: "Name",
        required: true,
        serializedName: "Name",
        type: {
          name: "String"
        }
      },
      properties: {
        xmlName: "Properties",
        required: true,
        serializedName: "Properties",
        type: {
          name: "Composite",
          className: "ContainerProperties"
        }
      },
      metadata: {
        xmlName: "Metadata",
        serializedName: "Metadata",
        type: {
          name: "Dictionary",
          value: {
            type: {
              name: "String"
            }
          }
        }
      }
    }
  }
};

export const ListContainersSegmentResponse: msRest.CompositeMapper = {
  xmlName: "EnumerationResults",
  serializedName: "ListContainersSegmentResponse",
  type: {
    name: "Composite",
    className: "ListContainersSegmentResponse",
    modelProperties: {
      serviceEndpoint: {
        xmlIsAttribute: true,
        xmlName: "ServiceEndpoint",
        required: true,
        serializedName: "ServiceEndpoint",
        type: {
          name: "String"
        }
      },
      prefix: {
        xmlName: "Prefix",
        serializedName: "Prefix",
        type: {
          name: "String"
        }
      },
      marker: {
        xmlName: "Marker",
        serializedName: "Marker",
        type: {
          name: "String"
        }
      },
      maxResults: {
        xmlName: "MaxResults",
        serializedName: "MaxResults",
        type: {
          name: "Number"
        }
      },
      containerItems: {
        xmlIsWrapped: true,
        xmlName: "Containers",
        xmlElementName: "Container",
        required: true,
        serializedName: "ContainerItems",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "ContainerItem"
            }
          }
        }
      },
      nextMarker: {
        xmlName: "NextMarker",
        serializedName: "NextMarker",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const CorsRule: msRest.CompositeMapper = {
  serializedName: "CorsRule",
  type: {
    name: "Composite",
    className: "CorsRule",
    modelProperties: {
      allowedOrigins: {
        xmlName: "AllowedOrigins",
        required: true,
        serializedName: "AllowedOrigins",
        type: {
          name: "String"
        }
      },
      allowedMethods: {
        xmlName: "AllowedMethods",
        required: true,
        serializedName: "AllowedMethods",
        type: {
          name: "String"
        }
      },
      allowedHeaders: {
        xmlName: "AllowedHeaders",
        required: true,
        serializedName: "AllowedHeaders",
        type: {
          name: "String"
        }
      },
      exposedHeaders: {
        xmlName: "ExposedHeaders",
        required: true,
        serializedName: "ExposedHeaders",
        type: {
          name: "String"
        }
      },
      maxAgeInSeconds: {
        xmlName: "MaxAgeInSeconds",
        required: true,
        serializedName: "MaxAgeInSeconds",
        constraints: {
          InclusiveMinimum: 0
        },
        type: {
          name: "Number"
        }
      }
    }
  }
};

export const GeoReplication: msRest.CompositeMapper = {
  serializedName: "GeoReplication",
  type: {
    name: "Composite",
    className: "GeoReplication",
    modelProperties: {
      status: {
        xmlName: "Status",
        required: true,
        serializedName: "Status",
        type: {
          name: "String"
        }
      },
      lastSyncTime: {
        xmlName: "LastSyncTime",
        required: true,
        serializedName: "LastSyncTime",
        type: {
          name: "DateTimeRfc1123"
        }
      }
    }
  }
};

export const RetentionPolicy: msRest.CompositeMapper = {
  serializedName: "RetentionPolicy",
  type: {
    name: "Composite",
    className: "RetentionPolicy",
    modelProperties: {
      enabled: {
        xmlName: "Enabled",
        required: true,
        serializedName: "Enabled",
        type: {
          name: "Boolean"
        }
      },
      days: {
        xmlName: "Days",
        serializedName: "Days",
        constraints: {
          InclusiveMinimum: 1
        },
        type: {
          name: "Number"
        }
      }
    }
  }
};

export const Logging: msRest.CompositeMapper = {
  serializedName: "Logging",
  type: {
    name: "Composite",
    className: "Logging",
    modelProperties: {
      version: {
        xmlName: "Version",
        required: true,
        serializedName: "Version",
        type: {
          name: "String"
        }
      },
      deleteProperty: {
        xmlName: "Delete",
        required: true,
        serializedName: "Delete",
        type: {
          name: "Boolean"
        }
      },
      read: {
        xmlName: "Read",
        required: true,
        serializedName: "Read",
        type: {
          name: "Boolean"
        }
      },
      write: {
        xmlName: "Write",
        required: true,
        serializedName: "Write",
        type: {
          name: "Boolean"
        }
      },
      retentionPolicy: {
        xmlName: "RetentionPolicy",
        required: true,
        serializedName: "RetentionPolicy",
        type: {
          name: "Composite",
          className: "RetentionPolicy"
        }
      }
    }
  }
};

export const Metrics: msRest.CompositeMapper = {
  serializedName: "Metrics",
  type: {
    name: "Composite",
    className: "Metrics",
    modelProperties: {
      version: {
        xmlName: "Version",
        serializedName: "Version",
        type: {
          name: "String"
        }
      },
      enabled: {
        xmlName: "Enabled",
        required: true,
        serializedName: "Enabled",
        type: {
          name: "Boolean"
        }
      },
      includeAPIs: {
        xmlName: "IncludeAPIs",
        serializedName: "IncludeAPIs",
        type: {
          name: "Boolean"
        }
      },
      retentionPolicy: {
        xmlName: "RetentionPolicy",
        serializedName: "RetentionPolicy",
        type: {
          name: "Composite",
          className: "RetentionPolicy"
        }
      }
    }
  }
};

export const PageRange: msRest.CompositeMapper = {
  serializedName: "PageRange",
  type: {
    name: "Composite",
    className: "PageRange",
    modelProperties: {
      start: {
        xmlName: "Start",
        required: true,
        serializedName: "Start",
        type: {
          name: "Number"
        }
      },
      end: {
        xmlName: "End",
        required: true,
        serializedName: "End",
        type: {
          name: "Number"
        }
      }
    }
  }
};

export const ClearRange: msRest.CompositeMapper = {
  serializedName: "ClearRange",
  type: {
    name: "Composite",
    className: "ClearRange",
    modelProperties: {
      start: {
        xmlName: "Start",
        required: true,
        serializedName: "Start",
        type: {
          name: "Number"
        }
      },
      end: {
        xmlName: "End",
        required: true,
        serializedName: "End",
        type: {
          name: "Number"
        }
      }
    }
  }
};

export const PageList: msRest.CompositeMapper = {
  serializedName: "PageList",
  type: {
    name: "Composite",
    className: "PageList",
    modelProperties: {
      pageRange: {
        xmlName: "PageRange",
        xmlElementName: "PageRange",
        serializedName: "PageRange",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "PageRange"
            }
          }
        }
      },
      clearRange: {
        xmlName: "ClearRange",
        xmlElementName: "ClearRange",
        serializedName: "ClearRange",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "ClearRange"
            }
          }
        }
      }
    }
  }
};

export const SignedIdentifier: msRest.CompositeMapper = {
  serializedName: "SignedIdentifier",
  type: {
    name: "Composite",
    className: "SignedIdentifier",
    modelProperties: {
      id: {
        xmlName: "Id",
        required: true,
        serializedName: "Id",
        type: {
          name: "String"
        }
      },
      accessPolicy: {
        xmlName: "AccessPolicy",
        required: true,
        serializedName: "AccessPolicy",
        type: {
          name: "Composite",
          className: "AccessPolicy"
        }
      }
    }
  }
};

export const StaticWebsite: msRest.CompositeMapper = {
  serializedName: "StaticWebsite",
  type: {
    name: "Composite",
    className: "StaticWebsite",
    modelProperties: {
      enabled: {
        xmlName: "Enabled",
        required: true,
        serializedName: "Enabled",
        type: {
          name: "Boolean"
        }
      },
      indexDocument: {
        xmlName: "IndexDocument",
        serializedName: "IndexDocument",
        type: {
          name: "String"
        }
      },
      errorDocument404Path: {
        xmlName: "ErrorDocument404Path",
        serializedName: "ErrorDocument404Path",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const StorageServiceProperties: msRest.CompositeMapper = {
  serializedName: "StorageServiceProperties",
  type: {
    name: "Composite",
    className: "StorageServiceProperties",
    modelProperties: {
      logging: {
        xmlName: "Logging",
        serializedName: "Logging",
        type: {
          name: "Composite",
          className: "Logging"
        }
      },
      hourMetrics: {
        xmlName: "HourMetrics",
        serializedName: "HourMetrics",
        type: {
          name: "Composite",
          className: "Metrics"
        }
      },
      minuteMetrics: {
        xmlName: "MinuteMetrics",
        serializedName: "MinuteMetrics",
        type: {
          name: "Composite",
          className: "Metrics"
        }
      },
      cors: {
        xmlIsWrapped: true,
        xmlName: "Cors",
        xmlElementName: "CorsRule",
        serializedName: "Cors",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "CorsRule"
            }
          }
        }
      },
      defaultServiceVersion: {
        xmlName: "DefaultServiceVersion",
        serializedName: "DefaultServiceVersion",
        type: {
          name: "String"
        }
      },
      deleteRetentionPolicy: {
        xmlName: "DeleteRetentionPolicy",
        serializedName: "DeleteRetentionPolicy",
        type: {
          name: "Composite",
          className: "RetentionPolicy"
        }
      },
      staticWebsite: {
        xmlName: "StaticWebsite",
        serializedName: "StaticWebsite",
        type: {
          name: "Composite",
          className: "StaticWebsite"
        }
      }
    }
  }
};

export const StorageServiceStats: msRest.CompositeMapper = {
  serializedName: "StorageServiceStats",
  type: {
    name: "Composite",
    className: "StorageServiceStats",
    modelProperties: {
      geoReplication: {
        xmlName: "GeoReplication",
        serializedName: "GeoReplication",
        type: {
          name: "Composite",
          className: "GeoReplication"
        }
      }
    }
  }
};

export const LeaseAccessConditions: msRest.CompositeMapper = {
  xmlName: "lease-access-conditions",
  type: {
    name: "Composite",
    className: "LeaseAccessConditions",
    modelProperties: {
      leaseId: {
        xmlName: "leaseId",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ModifiedAccessConditions: msRest.CompositeMapper = {
  xmlName: "modified-access-conditions",
  type: {
    name: "Composite",
    className: "ModifiedAccessConditions",
    modelProperties: {
      ifModifiedSince: {
        xmlName: "ifModifiedSince",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      ifUnmodifiedSince: {
        xmlName: "ifUnmodifiedSince",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      ifMatch: {
        xmlName: "ifMatch",
        type: {
          name: "String"
        }
      },
      ifNoneMatch: {
        xmlName: "ifNoneMatch",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const DirectoryHttpHeaders: msRest.CompositeMapper = {
  xmlName: "directory-http-headers",
  type: {
    name: "Composite",
    className: "DirectoryHttpHeaders",
    modelProperties: {
      cacheControl: {
        xmlName: "cacheControl",
        type: {
          name: "String"
        }
      },
      contentType: {
        xmlName: "contentType",
        type: {
          name: "String"
        }
      },
      contentEncoding: {
        xmlName: "contentEncoding",
        type: {
          name: "String"
        }
      },
      contentLanguage: {
        xmlName: "contentLanguage",
        type: {
          name: "String"
        }
      },
      contentDisposition: {
        xmlName: "contentDisposition",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const SourceModifiedAccessConditions: msRest.CompositeMapper = {
  xmlName: "source-modified-access-conditions",
  type: {
    name: "Composite",
    className: "SourceModifiedAccessConditions",
    modelProperties: {
      sourceIfModifiedSince: {
        xmlName: "sourceIfModifiedSince",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      sourceIfUnmodifiedSince: {
        xmlName: "sourceIfUnmodifiedSince",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      sourceIfMatch: {
        xmlName: "sourceIfMatch",
        type: {
          name: "String"
        }
      },
      sourceIfNoneMatch: {
        xmlName: "sourceIfNoneMatch",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const CpkInfo: msRest.CompositeMapper = {
  xmlName: "cpk-info",
  type: {
    name: "Composite",
    className: "CpkInfo",
    modelProperties: {
      encryptionKey: {
        xmlName: "encryptionKey",
        type: {
          name: "String"
        }
      },
      encryptionKeySha256: {
        xmlName: "encryptionKeySha256",
        type: {
          name: "String"
        }
      },
      encryptionAlgorithm: {
        xmlName: "encryptionAlgorithm",
        type: {
          name: "Enum",
          allowedValues: [
            "AES256"
          ]
        }
      }
    }
  }
};

export const BlobHTTPHeaders: msRest.CompositeMapper = {
  xmlName: "blob-HTTP-headers",
  type: {
    name: "Composite",
    className: "BlobHTTPHeaders",
    modelProperties: {
      blobCacheControl: {
        xmlName: "blobCacheControl",
        type: {
          name: "String"
        }
      },
      blobContentType: {
        xmlName: "blobContentType",
        type: {
          name: "String"
        }
      },
      blobContentMD5: {
        xmlName: "blobContentMD5",
        type: {
          name: "ByteArray"
        }
      },
      blobContentEncoding: {
        xmlName: "blobContentEncoding",
        type: {
          name: "String"
        }
      },
      blobContentLanguage: {
        xmlName: "blobContentLanguage",
        type: {
          name: "String"
        }
      },
      blobContentDisposition: {
        xmlName: "blobContentDisposition",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const SequenceNumberAccessConditions: msRest.CompositeMapper = {
  xmlName: "sequence-number-access-conditions",
  type: {
    name: "Composite",
    className: "SequenceNumberAccessConditions",
    modelProperties: {
      ifSequenceNumberLessThanOrEqualTo: {
        xmlName: "ifSequenceNumberLessThanOrEqualTo",
        type: {
          name: "Number"
        }
      },
      ifSequenceNumberLessThan: {
        xmlName: "ifSequenceNumberLessThan",
        type: {
          name: "Number"
        }
      },
      ifSequenceNumberEqualTo: {
        xmlName: "ifSequenceNumberEqualTo",
        type: {
          name: "Number"
        }
      }
    }
  }
};

export const AppendPositionAccessConditions: msRest.CompositeMapper = {
  xmlName: "append-position-access-conditions",
  type: {
    name: "Composite",
    className: "AppendPositionAccessConditions",
    modelProperties: {
      maxSize: {
        xmlName: "maxSize",
        type: {
          name: "Number"
        }
      },
      appendPosition: {
        xmlName: "appendPosition",
        type: {
          name: "Number"
        }
      }
    }
  }
};

export const ServiceSetPropertiesHeaders: msRest.CompositeMapper = {
  serializedName: "service-setproperties-headers",
  type: {
    name: "Composite",
    className: "ServiceSetPropertiesHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ServiceGetPropertiesHeaders: msRest.CompositeMapper = {
  serializedName: "service-getproperties-headers",
  type: {
    name: "Composite",
    className: "ServiceGetPropertiesHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ServiceGetStatisticsHeaders: msRest.CompositeMapper = {
  serializedName: "service-getstatistics-headers",
  type: {
    name: "Composite",
    className: "ServiceGetStatisticsHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ServiceListContainersSegmentHeaders: msRest.CompositeMapper = {
  serializedName: "service-listcontainerssegment-headers",
  type: {
    name: "Composite",
    className: "ServiceListContainersSegmentHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ServiceGetUserDelegationKeyHeaders: msRest.CompositeMapper = {
  serializedName: "service-getuserdelegationkey-headers",
  type: {
    name: "Composite",
    className: "ServiceGetUserDelegationKeyHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ServiceGetAccountInfoHeaders: msRest.CompositeMapper = {
  serializedName: "service-getaccountinfo-headers",
  type: {
    name: "Composite",
    className: "ServiceGetAccountInfoHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      skuName: {
        serializedName: "x-ms-sku-name",
        type: {
          name: "Enum",
          allowedValues: [
            "Standard_LRS",
            "Standard_GRS",
            "Standard_RAGRS",
            "Standard_ZRS",
            "Premium_LRS"
          ]
        }
      },
      accountKind: {
        serializedName: "x-ms-account-kind",
        type: {
          name: "Enum",
          allowedValues: [
            "Storage",
            "BlobStorage",
            "StorageV2"
          ]
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ServiceSubmitBatchHeaders: msRest.CompositeMapper = {
  serializedName: "service-submitbatch-headers",
  type: {
    name: "Composite",
    className: "ServiceSubmitBatchHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      contentType: {
        serializedName: "content-type",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerCreateHeaders: msRest.CompositeMapper = {
  serializedName: "container-create-headers",
  type: {
    name: "Composite",
    className: "ContainerCreateHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerGetPropertiesHeaders: msRest.CompositeMapper = {
  serializedName: "container-getproperties-headers",
  type: {
    name: "Composite",
    className: "ContainerGetPropertiesHeaders",
    modelProperties: {
      metadata: {
        serializedName: "x-ms-meta",
        type: {
          name: "Dictionary",
          value: {
            type: {
              name: "String"
            }
          }
        },
        headerCollectionPrefix: "x-ms-meta-"
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      leaseDuration: {
        serializedName: "x-ms-lease-duration",
        type: {
          name: "Enum",
          allowedValues: [
            "infinite",
            "fixed"
          ]
        }
      },
      leaseState: {
        serializedName: "x-ms-lease-state",
        type: {
          name: "Enum",
          allowedValues: [
            "available",
            "leased",
            "expired",
            "breaking",
            "broken"
          ]
        }
      },
      leaseStatus: {
        serializedName: "x-ms-lease-status",
        type: {
          name: "Enum",
          allowedValues: [
            "locked",
            "unlocked"
          ]
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      blobPublicAccess: {
        serializedName: "x-ms-blob-public-access",
        type: {
          name: "String"
        }
      },
      hasImmutabilityPolicy: {
        serializedName: "x-ms-has-immutability-policy",
        type: {
          name: "Boolean"
        }
      },
      hasLegalHold: {
        serializedName: "x-ms-has-legal-hold",
        type: {
          name: "Boolean"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerDeleteHeaders: msRest.CompositeMapper = {
  serializedName: "container-delete-headers",
  type: {
    name: "Composite",
    className: "ContainerDeleteHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerSetMetadataHeaders: msRest.CompositeMapper = {
  serializedName: "container-setmetadata-headers",
  type: {
    name: "Composite",
    className: "ContainerSetMetadataHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerGetAccessPolicyHeaders: msRest.CompositeMapper = {
  serializedName: "container-getaccesspolicy-headers",
  type: {
    name: "Composite",
    className: "ContainerGetAccessPolicyHeaders",
    modelProperties: {
      blobPublicAccess: {
        serializedName: "x-ms-blob-public-access",
        type: {
          name: "String"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerSetAccessPolicyHeaders: msRest.CompositeMapper = {
  serializedName: "container-setaccesspolicy-headers",
  type: {
    name: "Composite",
    className: "ContainerSetAccessPolicyHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerAcquireLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "container-acquirelease-headers",
  type: {
    name: "Composite",
    className: "ContainerAcquireLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      leaseId: {
        serializedName: "x-ms-lease-id",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerReleaseLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "container-releaselease-headers",
  type: {
    name: "Composite",
    className: "ContainerReleaseLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerRenewLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "container-renewlease-headers",
  type: {
    name: "Composite",
    className: "ContainerRenewLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      leaseId: {
        serializedName: "x-ms-lease-id",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerBreakLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "container-breaklease-headers",
  type: {
    name: "Composite",
    className: "ContainerBreakLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      leaseTime: {
        serializedName: "x-ms-lease-time",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerChangeLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "container-changelease-headers",
  type: {
    name: "Composite",
    className: "ContainerChangeLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      leaseId: {
        serializedName: "x-ms-lease-id",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerListBlobFlatSegmentHeaders: msRest.CompositeMapper = {
  serializedName: "container-listblobflatsegment-headers",
  type: {
    name: "Composite",
    className: "ContainerListBlobFlatSegmentHeaders",
    modelProperties: {
      contentType: {
        serializedName: "content-type",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerListBlobHierarchySegmentHeaders: msRest.CompositeMapper = {
  serializedName: "container-listblobhierarchysegment-headers",
  type: {
    name: "Composite",
    className: "ContainerListBlobHierarchySegmentHeaders",
    modelProperties: {
      contentType: {
        serializedName: "content-type",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ContainerGetAccountInfoHeaders: msRest.CompositeMapper = {
  serializedName: "container-getaccountinfo-headers",
  type: {
    name: "Composite",
    className: "ContainerGetAccountInfoHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      skuName: {
        serializedName: "x-ms-sku-name",
        type: {
          name: "Enum",
          allowedValues: [
            "Standard_LRS",
            "Standard_GRS",
            "Standard_RAGRS",
            "Standard_ZRS",
            "Premium_LRS"
          ]
        }
      },
      accountKind: {
        serializedName: "x-ms-account-kind",
        type: {
          name: "Enum",
          allowedValues: [
            "Storage",
            "BlobStorage",
            "StorageV2"
          ]
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const DirectoryCreateHeaders: msRest.CompositeMapper = {
  serializedName: "directory-create-headers",
  type: {
    name: "Composite",
    className: "DirectoryCreateHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      contentLength: {
        serializedName: "content-length",
        type: {
          name: "Number"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      }
    }
  }
};

export const DirectoryRenameHeaders: msRest.CompositeMapper = {
  serializedName: "directory-rename-headers",
  type: {
    name: "Composite",
    className: "DirectoryRenameHeaders",
    modelProperties: {
      marker: {
        serializedName: "x-ms-continuation",
        type: {
          name: "String"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      contentLength: {
        serializedName: "content-length",
        type: {
          name: "Number"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      }
    }
  }
};

export const DirectoryDeleteHeaders: msRest.CompositeMapper = {
  serializedName: "directory-delete-headers",
  type: {
    name: "Composite",
    className: "DirectoryDeleteHeaders",
    modelProperties: {
      marker: {
        serializedName: "x-ms-continuation",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      }
    }
  }
};

export const DirectorySetAccessControlHeaders: msRest.CompositeMapper = {
  serializedName: "directory-setaccesscontrol-headers",
  type: {
    name: "Composite",
    className: "DirectorySetAccessControlHeaders",
    modelProperties: {
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const DirectoryGetAccessControlHeaders: msRest.CompositeMapper = {
  serializedName: "directory-getaccesscontrol-headers",
  type: {
    name: "Composite",
    className: "DirectoryGetAccessControlHeaders",
    modelProperties: {
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      xMsOwner: {
        serializedName: "x-ms-owner",
        type: {
          name: "String"
        }
      },
      xMsGroup: {
        serializedName: "x-ms-group",
        type: {
          name: "String"
        }
      },
      xMsPermissions: {
        serializedName: "x-ms-permissions",
        type: {
          name: "String"
        }
      },
      xMsAcl: {
        serializedName: "x-ms-acl",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobDownloadHeaders: msRest.CompositeMapper = {
  serializedName: "blob-download-headers",
  type: {
    name: "Composite",
    className: "BlobDownloadHeaders",
    modelProperties: {
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      metadata: {
        serializedName: "x-ms-meta",
        type: {
          name: "Dictionary",
          value: {
            type: {
              name: "String"
            }
          }
        },
        headerCollectionPrefix: "x-ms-meta-"
      },
      contentLength: {
        serializedName: "content-length",
        type: {
          name: "Number"
        }
      },
      contentType: {
        serializedName: "content-type",
        type: {
          name: "String"
        }
      },
      contentRange: {
        serializedName: "content-range",
        type: {
          name: "String"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      contentEncoding: {
        serializedName: "content-encoding",
        type: {
          name: "String"
        }
      },
      cacheControl: {
        serializedName: "cache-control",
        type: {
          name: "String"
        }
      },
      contentDisposition: {
        serializedName: "content-disposition",
        type: {
          name: "String"
        }
      },
      contentLanguage: {
        serializedName: "content-language",
        type: {
          name: "String"
        }
      },
      blobSequenceNumber: {
        serializedName: "x-ms-blob-sequence-number",
        type: {
          name: "Number"
        }
      },
      blobType: {
        serializedName: "x-ms-blob-type",
        type: {
          name: "Enum",
          allowedValues: [
            "BlockBlob",
            "PageBlob",
            "AppendBlob"
          ]
        }
      },
      copyCompletionTime: {
        serializedName: "x-ms-copy-completion-time",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      copyStatusDescription: {
        serializedName: "x-ms-copy-status-description",
        type: {
          name: "String"
        }
      },
      copyId: {
        serializedName: "x-ms-copy-id",
        type: {
          name: "String"
        }
      },
      copyProgress: {
        serializedName: "x-ms-copy-progress",
        type: {
          name: "String"
        }
      },
      copySource: {
        serializedName: "x-ms-copy-source",
        type: {
          name: "String"
        }
      },
      copyStatus: {
        serializedName: "x-ms-copy-status",
        type: {
          name: "Enum",
          allowedValues: [
            "pending",
            "success",
            "aborted",
            "failed"
          ]
        }
      },
      leaseDuration: {
        serializedName: "x-ms-lease-duration",
        type: {
          name: "Enum",
          allowedValues: [
            "infinite",
            "fixed"
          ]
        }
      },
      leaseState: {
        serializedName: "x-ms-lease-state",
        type: {
          name: "Enum",
          allowedValues: [
            "available",
            "leased",
            "expired",
            "breaking",
            "broken"
          ]
        }
      },
      leaseStatus: {
        serializedName: "x-ms-lease-status",
        type: {
          name: "Enum",
          allowedValues: [
            "locked",
            "unlocked"
          ]
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      acceptRanges: {
        serializedName: "accept-ranges",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      blobCommittedBlockCount: {
        serializedName: "x-ms-blob-committed-block-count",
        type: {
          name: "Number"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      blobContentMD5: {
        serializedName: "x-ms-blob-content-md5",
        type: {
          name: "ByteArray"
        }
      },
      contentCrc64: {
        serializedName: "x-ms-content-crc64",
        type: {
          name: "ByteArray"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobGetPropertiesHeaders: msRest.CompositeMapper = {
  serializedName: "blob-getproperties-headers",
  type: {
    name: "Composite",
    className: "BlobGetPropertiesHeaders",
    modelProperties: {
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      creationTime: {
        serializedName: "x-ms-creation-time",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      metadata: {
        serializedName: "x-ms-meta",
        type: {
          name: "Dictionary",
          value: {
            type: {
              name: "String"
            }
          }
        },
        headerCollectionPrefix: "x-ms-meta-"
      },
      blobType: {
        serializedName: "x-ms-blob-type",
        type: {
          name: "Enum",
          allowedValues: [
            "BlockBlob",
            "PageBlob",
            "AppendBlob"
          ]
        }
      },
      copyCompletionTime: {
        serializedName: "x-ms-copy-completion-time",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      copyStatusDescription: {
        serializedName: "x-ms-copy-status-description",
        type: {
          name: "String"
        }
      },
      copyId: {
        serializedName: "x-ms-copy-id",
        type: {
          name: "String"
        }
      },
      copyProgress: {
        serializedName: "x-ms-copy-progress",
        type: {
          name: "String"
        }
      },
      copySource: {
        serializedName: "x-ms-copy-source",
        type: {
          name: "String"
        }
      },
      copyStatus: {
        serializedName: "x-ms-copy-status",
        type: {
          name: "Enum",
          allowedValues: [
            "pending",
            "success",
            "aborted",
            "failed"
          ]
        }
      },
      isIncrementalCopy: {
        serializedName: "x-ms-incremental-copy",
        type: {
          name: "Boolean"
        }
      },
      destinationSnapshot: {
        serializedName: "x-ms-copy-destination-snapshot",
        type: {
          name: "String"
        }
      },
      leaseDuration: {
        serializedName: "x-ms-lease-duration",
        type: {
          name: "Enum",
          allowedValues: [
            "infinite",
            "fixed"
          ]
        }
      },
      leaseState: {
        serializedName: "x-ms-lease-state",
        type: {
          name: "Enum",
          allowedValues: [
            "available",
            "leased",
            "expired",
            "breaking",
            "broken"
          ]
        }
      },
      leaseStatus: {
        serializedName: "x-ms-lease-status",
        type: {
          name: "Enum",
          allowedValues: [
            "locked",
            "unlocked"
          ]
        }
      },
      contentLength: {
        serializedName: "content-length",
        type: {
          name: "Number"
        }
      },
      contentType: {
        serializedName: "content-type",
        type: {
          name: "String"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      contentEncoding: {
        serializedName: "content-encoding",
        type: {
          name: "String"
        }
      },
      contentDisposition: {
        serializedName: "content-disposition",
        type: {
          name: "String"
        }
      },
      contentLanguage: {
        serializedName: "content-language",
        type: {
          name: "String"
        }
      },
      cacheControl: {
        serializedName: "cache-control",
        type: {
          name: "String"
        }
      },
      blobSequenceNumber: {
        serializedName: "x-ms-blob-sequence-number",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      acceptRanges: {
        serializedName: "accept-ranges",
        type: {
          name: "String"
        }
      },
      blobCommittedBlockCount: {
        serializedName: "x-ms-blob-committed-block-count",
        type: {
          name: "Number"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      accessTier: {
        serializedName: "x-ms-access-tier",
        type: {
          name: "String"
        }
      },
      accessTierInferred: {
        serializedName: "x-ms-access-tier-inferred",
        type: {
          name: "Boolean"
        }
      },
      archiveStatus: {
        serializedName: "x-ms-archive-status",
        type: {
          name: "String"
        }
      },
      accessTierChangeTime: {
        serializedName: "x-ms-access-tier-change-time",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobDeleteHeaders: msRest.CompositeMapper = {
  serializedName: "blob-delete-headers",
  type: {
    name: "Composite",
    className: "BlobDeleteHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobSetAccessControlHeaders: msRest.CompositeMapper = {
  serializedName: "blob-setaccesscontrol-headers",
  type: {
    name: "Composite",
    className: "BlobSetAccessControlHeaders",
    modelProperties: {
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobGetAccessControlHeaders: msRest.CompositeMapper = {
  serializedName: "blob-getaccesscontrol-headers",
  type: {
    name: "Composite",
    className: "BlobGetAccessControlHeaders",
    modelProperties: {
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      xMsOwner: {
        serializedName: "x-ms-owner",
        type: {
          name: "String"
        }
      },
      xMsGroup: {
        serializedName: "x-ms-group",
        type: {
          name: "String"
        }
      },
      xMsPermissions: {
        serializedName: "x-ms-permissions",
        type: {
          name: "String"
        }
      },
      xMsAcl: {
        serializedName: "x-ms-acl",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobRenameHeaders: msRest.CompositeMapper = {
  serializedName: "blob-rename-headers",
  type: {
    name: "Composite",
    className: "BlobRenameHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      contentLength: {
        serializedName: "content-length",
        type: {
          name: "Number"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      }
    }
  }
};

export const PageBlobCreateHeaders: msRest.CompositeMapper = {
  serializedName: "pageblob-create-headers",
  type: {
    name: "Composite",
    className: "PageBlobCreateHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const AppendBlobCreateHeaders: msRest.CompositeMapper = {
  serializedName: "appendblob-create-headers",
  type: {
    name: "Composite",
    className: "AppendBlobCreateHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlockBlobUploadHeaders: msRest.CompositeMapper = {
  serializedName: "blockblob-upload-headers",
  type: {
    name: "Composite",
    className: "BlockBlobUploadHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobUndeleteHeaders: msRest.CompositeMapper = {
  serializedName: "blob-undelete-headers",
  type: {
    name: "Composite",
    className: "BlobUndeleteHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobSetHTTPHeadersHeaders: msRest.CompositeMapper = {
  serializedName: "blob-sethttpheaders-headers",
  type: {
    name: "Composite",
    className: "BlobSetHTTPHeadersHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      blobSequenceNumber: {
        serializedName: "x-ms-blob-sequence-number",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobSetMetadataHeaders: msRest.CompositeMapper = {
  serializedName: "blob-setmetadata-headers",
  type: {
    name: "Composite",
    className: "BlobSetMetadataHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobAcquireLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "blob-acquirelease-headers",
  type: {
    name: "Composite",
    className: "BlobAcquireLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      leaseId: {
        serializedName: "x-ms-lease-id",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobReleaseLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "blob-releaselease-headers",
  type: {
    name: "Composite",
    className: "BlobReleaseLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobRenewLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "blob-renewlease-headers",
  type: {
    name: "Composite",
    className: "BlobRenewLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      leaseId: {
        serializedName: "x-ms-lease-id",
        type: {
          name: "String"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobChangeLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "blob-changelease-headers",
  type: {
    name: "Composite",
    className: "BlobChangeLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      leaseId: {
        serializedName: "x-ms-lease-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobBreakLeaseHeaders: msRest.CompositeMapper = {
  serializedName: "blob-breaklease-headers",
  type: {
    name: "Composite",
    className: "BlobBreakLeaseHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      leaseTime: {
        serializedName: "x-ms-lease-time",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobCreateSnapshotHeaders: msRest.CompositeMapper = {
  serializedName: "blob-createsnapshot-headers",
  type: {
    name: "Composite",
    className: "BlobCreateSnapshotHeaders",
    modelProperties: {
      snapshot: {
        serializedName: "x-ms-snapshot",
        type: {
          name: "String"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobStartCopyFromURLHeaders: msRest.CompositeMapper = {
  serializedName: "blob-startcopyfromurl-headers",
  type: {
    name: "Composite",
    className: "BlobStartCopyFromURLHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      copyId: {
        serializedName: "x-ms-copy-id",
        type: {
          name: "String"
        }
      },
      copyStatus: {
        serializedName: "x-ms-copy-status",
        type: {
          name: "Enum",
          allowedValues: [
            "pending",
            "success",
            "aborted",
            "failed"
          ]
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobCopyFromURLHeaders: msRest.CompositeMapper = {
  serializedName: "blob-copyfromurl-headers",
  type: {
    name: "Composite",
    className: "BlobCopyFromURLHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      copyId: {
        serializedName: "x-ms-copy-id",
        type: {
          name: "String"
        }
      },
      copyStatus: {
        serializedName: "x-ms-copy-status",
        type: {
          name: "Enum",
          allowedValues: [
            "success"
          ]
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobAbortCopyFromURLHeaders: msRest.CompositeMapper = {
  serializedName: "blob-abortcopyfromurl-headers",
  type: {
    name: "Composite",
    className: "BlobAbortCopyFromURLHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobSetTierHeaders: msRest.CompositeMapper = {
  serializedName: "blob-settier-headers",
  type: {
    name: "Composite",
    className: "BlobSetTierHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlobGetAccountInfoHeaders: msRest.CompositeMapper = {
  serializedName: "blob-getaccountinfo-headers",
  type: {
    name: "Composite",
    className: "BlobGetAccountInfoHeaders",
    modelProperties: {
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      skuName: {
        serializedName: "x-ms-sku-name",
        type: {
          name: "Enum",
          allowedValues: [
            "Standard_LRS",
            "Standard_GRS",
            "Standard_RAGRS",
            "Standard_ZRS",
            "Premium_LRS"
          ]
        }
      },
      accountKind: {
        serializedName: "x-ms-account-kind",
        type: {
          name: "Enum",
          allowedValues: [
            "Storage",
            "BlobStorage",
            "StorageV2"
          ]
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlockBlobStageBlockHeaders: msRest.CompositeMapper = {
  serializedName: "blockblob-stageblock-headers",
  type: {
    name: "Composite",
    className: "BlockBlobStageBlockHeaders",
    modelProperties: {
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      xMsContentCrc64: {
        serializedName: "x-ms-content-crc64",
        type: {
          name: "ByteArray"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlockBlobStageBlockFromURLHeaders: msRest.CompositeMapper = {
  serializedName: "blockblob-stageblockfromurl-headers",
  type: {
    name: "Composite",
    className: "BlockBlobStageBlockFromURLHeaders",
    modelProperties: {
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      xMsContentCrc64: {
        serializedName: "x-ms-content-crc64",
        type: {
          name: "ByteArray"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlockBlobCommitBlockListHeaders: msRest.CompositeMapper = {
  serializedName: "blockblob-commitblocklist-headers",
  type: {
    name: "Composite",
    className: "BlockBlobCommitBlockListHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      xMsContentCrc64: {
        serializedName: "x-ms-content-crc64",
        type: {
          name: "ByteArray"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const BlockBlobGetBlockListHeaders: msRest.CompositeMapper = {
  serializedName: "blockblob-getblocklist-headers",
  type: {
    name: "Composite",
    className: "BlockBlobGetBlockListHeaders",
    modelProperties: {
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      contentType: {
        serializedName: "content-type",
        type: {
          name: "String"
        }
      },
      blobContentLength: {
        serializedName: "x-ms-blob-content-length",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const PageBlobUploadPagesHeaders: msRest.CompositeMapper = {
  serializedName: "pageblob-uploadpages-headers",
  type: {
    name: "Composite",
    className: "PageBlobUploadPagesHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      xMsContentCrc64: {
        serializedName: "x-ms-content-crc64",
        type: {
          name: "ByteArray"
        }
      },
      blobSequenceNumber: {
        serializedName: "x-ms-blob-sequence-number",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const PageBlobClearPagesHeaders: msRest.CompositeMapper = {
  serializedName: "pageblob-clearpages-headers",
  type: {
    name: "Composite",
    className: "PageBlobClearPagesHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      xMsContentCrc64: {
        serializedName: "x-ms-content-crc64",
        type: {
          name: "ByteArray"
        }
      },
      blobSequenceNumber: {
        serializedName: "x-ms-blob-sequence-number",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const PageBlobUploadPagesFromURLHeaders: msRest.CompositeMapper = {
  serializedName: "pageblob-uploadpagesfromurl-headers",
  type: {
    name: "Composite",
    className: "PageBlobUploadPagesFromURLHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      xMsContentCrc64: {
        serializedName: "x-ms-content-crc64",
        type: {
          name: "ByteArray"
        }
      },
      blobSequenceNumber: {
        serializedName: "x-ms-blob-sequence-number",
        type: {
          name: "Number"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const PageBlobGetPageRangesHeaders: msRest.CompositeMapper = {
  serializedName: "pageblob-getpageranges-headers",
  type: {
    name: "Composite",
    className: "PageBlobGetPageRangesHeaders",
    modelProperties: {
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      blobContentLength: {
        serializedName: "x-ms-blob-content-length",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const PageBlobGetPageRangesDiffHeaders: msRest.CompositeMapper = {
  serializedName: "pageblob-getpagerangesdiff-headers",
  type: {
    name: "Composite",
    className: "PageBlobGetPageRangesDiffHeaders",
    modelProperties: {
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      blobContentLength: {
        serializedName: "x-ms-blob-content-length",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const PageBlobResizeHeaders: msRest.CompositeMapper = {
  serializedName: "pageblob-resize-headers",
  type: {
    name: "Composite",
    className: "PageBlobResizeHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      blobSequenceNumber: {
        serializedName: "x-ms-blob-sequence-number",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const PageBlobUpdateSequenceNumberHeaders: msRest.CompositeMapper = {
  serializedName: "pageblob-updatesequencenumber-headers",
  type: {
    name: "Composite",
    className: "PageBlobUpdateSequenceNumberHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      blobSequenceNumber: {
        serializedName: "x-ms-blob-sequence-number",
        type: {
          name: "Number"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const PageBlobCopyIncrementalHeaders: msRest.CompositeMapper = {
  serializedName: "pageblob-copyincremental-headers",
  type: {
    name: "Composite",
    className: "PageBlobCopyIncrementalHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      copyId: {
        serializedName: "x-ms-copy-id",
        type: {
          name: "String"
        }
      },
      copyStatus: {
        serializedName: "x-ms-copy-status",
        type: {
          name: "Enum",
          allowedValues: [
            "pending",
            "success",
            "aborted",
            "failed"
          ]
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const AppendBlobAppendBlockHeaders: msRest.CompositeMapper = {
  serializedName: "appendblob-appendblock-headers",
  type: {
    name: "Composite",
    className: "AppendBlobAppendBlockHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      xMsContentCrc64: {
        serializedName: "x-ms-content-crc64",
        type: {
          name: "ByteArray"
        }
      },
      clientRequestId: {
        serializedName: "x-ms-client-request-id",
        type: {
          name: "String"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      blobAppendOffset: {
        serializedName: "x-ms-blob-append-offset",
        type: {
          name: "String"
        }
      },
      blobCommittedBlockCount: {
        serializedName: "x-ms-blob-committed-block-count",
        type: {
          name: "Number"
        }
      },
      isServerEncrypted: {
        serializedName: "x-ms-request-server-encrypted",
        type: {
          name: "Boolean"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const AppendBlobAppendBlockFromUrlHeaders: msRest.CompositeMapper = {
  serializedName: "appendblob-appendblockfromurl-headers",
  type: {
    name: "Composite",
    className: "AppendBlobAppendBlockFromUrlHeaders",
    modelProperties: {
      eTag: {
        serializedName: "etag",
        type: {
          name: "String"
        }
      },
      lastModified: {
        serializedName: "last-modified",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      contentMD5: {
        serializedName: "content-md5",
        type: {
          name: "ByteArray"
        }
      },
      xMsContentCrc64: {
        serializedName: "x-ms-content-crc64",
        type: {
          name: "ByteArray"
        }
      },
      requestId: {
        serializedName: "x-ms-request-id",
        type: {
          name: "String"
        }
      },
      version: {
        serializedName: "x-ms-version",
        type: {
          name: "String"
        }
      },
      date: {
        serializedName: "date",
        type: {
          name: "DateTimeRfc1123"
        }
      },
      blobAppendOffset: {
        serializedName: "x-ms-blob-append-offset",
        type: {
          name: "String"
        }
      },
      blobCommittedBlockCount: {
        serializedName: "x-ms-blob-committed-block-count",
        type: {
          name: "Number"
        }
      },
      encryptionKeySha256: {
        serializedName: "x-ms-encryption-key-sha256",
        type: {
          name: "String"
        }
      },
      errorCode: {
        serializedName: "x-ms-error-code",
        type: {
          name: "String"
        }
      }
    }
  }
};
