/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import * as Mappers from "../models/blobMappers";
import * as Parameters from "../models/parameters";
import { StorageClientContext } from "../storageClientContext";

/** Class representing a Blob. */
export class Blob {
  private readonly client: StorageClientContext;

  /**
   * Create a Blob.
   * @param {StorageClientContext} client Reference to the service client.
   */
  constructor(client: StorageClientContext) {
    this.client = client;
  }

  /**
   * The Download operation reads or downloads a blob from the system, including its metadata and
   * properties. You can also call Download to read a snapshot.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobDownloadResponse>
   */
  download(options?: Models.BlobDownloadOptionalParams): Promise<Models.BlobDownloadResponse>;
  /**
   * @param callback The callback
   */
  download(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  download(options: Models.BlobDownloadOptionalParams, callback: msRest.ServiceCallback<void>): void;
  download(options?: Models.BlobDownloadOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobDownloadResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      downloadOperationSpec,
      callback) as Promise<Models.BlobDownloadResponse>;
  }

  /**
   * The Get Properties operation returns all user-defined metadata, standard HTTP properties, and
   * system properties for the blob. It does not return the content of the blob.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobGetPropertiesResponse>
   */
  getProperties(options?: Models.BlobGetPropertiesOptionalParams): Promise<Models.BlobGetPropertiesResponse>;
  /**
   * @param callback The callback
   */
  getProperties(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  getProperties(options: Models.BlobGetPropertiesOptionalParams, callback: msRest.ServiceCallback<void>): void;
  getProperties(options?: Models.BlobGetPropertiesOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobGetPropertiesResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      getPropertiesOperationSpec,
      callback) as Promise<Models.BlobGetPropertiesResponse>;
  }

  /**
   * If the storage account's soft delete feature is disabled then, when a blob is deleted, it is
   * permanently removed from the storage account. If the storage account's soft delete feature is
   * enabled, then, when a blob is deleted, it is marked for deletion and becomes inaccessible
   * immediately. However, the blob service retains the blob or snapshot for the number of days
   * specified by the DeleteRetentionPolicy section of [Storage service properties]
   * (Set-Blob-Service-Properties.md). After the specified number of days has passed, the blob's data
   * is permanently removed from the storage account. Note that you continue to be charged for the
   * soft-deleted blob's storage until it is permanently removed. Use the List Blobs API and specify
   * the "include=deleted" query parameter to discover which blobs and snapshots have been soft
   * deleted. You can then use the Undelete Blob API to restore a soft-deleted blob. All other
   * operations on a soft-deleted blob or snapshot causes the service to return an HTTP status code
   * of 404 (ResourceNotFound).
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobDeleteResponse>
   */
  deleteMethod(options?: Models.BlobDeleteMethodOptionalParams): Promise<Models.BlobDeleteResponse>;
  /**
   * @param callback The callback
   */
  deleteMethod(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  deleteMethod(options: Models.BlobDeleteMethodOptionalParams, callback: msRest.ServiceCallback<void>): void;
  deleteMethod(options?: Models.BlobDeleteMethodOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobDeleteResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      deleteMethodOperationSpec,
      callback) as Promise<Models.BlobDeleteResponse>;
  }

  /**
   * Set the owner, group, permissions, or access control list for a blob.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobSetAccessControlResponse>
   */
  setAccessControl(options?: Models.BlobSetAccessControlOptionalParams): Promise<Models.BlobSetAccessControlResponse>;
  /**
   * @param callback The callback
   */
  setAccessControl(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  setAccessControl(options: Models.BlobSetAccessControlOptionalParams, callback: msRest.ServiceCallback<void>): void;
  setAccessControl(options?: Models.BlobSetAccessControlOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobSetAccessControlResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      setAccessControlOperationSpec,
      callback) as Promise<Models.BlobSetAccessControlResponse>;
  }

  /**
   * Get the owner, group, permissions, or access control list for a blob.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobGetAccessControlResponse>
   */
  getAccessControl(options?: Models.BlobGetAccessControlOptionalParams): Promise<Models.BlobGetAccessControlResponse>;
  /**
   * @param callback The callback
   */
  getAccessControl(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  getAccessControl(options: Models.BlobGetAccessControlOptionalParams, callback: msRest.ServiceCallback<void>): void;
  getAccessControl(options?: Models.BlobGetAccessControlOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobGetAccessControlResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      getAccessControlOperationSpec,
      callback) as Promise<Models.BlobGetAccessControlResponse>;
  }

  /**
   * Rename a blob/file.  By default, the destination is overwritten and if the destination already
   * exists and has a lease the lease is broken.  This operation supports conditional HTTP requests.
   * For more information, see [Specifying Conditional Headers for Blob Service
   * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
   * To fail if the destination already exists, use a conditional request with If-None-Match: "*".
   * @param renameSource The file or directory to be renamed. The value must have the following
   * format: "/{filesysystem}/{path}".  If "x-ms-properties" is specified, the properties will
   * overwrite the existing properties; otherwise, the existing properties will be preserved.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobRenameResponse>
   */
  rename(renameSource: string, options?: Models.BlobRenameOptionalParams): Promise<Models.BlobRenameResponse>;
  /**
   * @param renameSource The file or directory to be renamed. The value must have the following
   * format: "/{filesysystem}/{path}".  If "x-ms-properties" is specified, the properties will
   * overwrite the existing properties; otherwise, the existing properties will be preserved.
   * @param callback The callback
   */
  rename(renameSource: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param renameSource The file or directory to be renamed. The value must have the following
   * format: "/{filesysystem}/{path}".  If "x-ms-properties" is specified, the properties will
   * overwrite the existing properties; otherwise, the existing properties will be preserved.
   * @param options The optional parameters
   * @param callback The callback
   */
  rename(renameSource: string, options: Models.BlobRenameOptionalParams, callback: msRest.ServiceCallback<void>): void;
  rename(renameSource: string, options?: Models.BlobRenameOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobRenameResponse> {
    return this.client.sendOperationRequest(
      {
        renameSource,
        options
      },
      renameOperationSpec,
      callback) as Promise<Models.BlobRenameResponse>;
  }

  /**
   * Undelete a blob that was previously soft deleted
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobUndeleteResponse>
   */
  undelete(options?: Models.BlobUndeleteOptionalParams): Promise<Models.BlobUndeleteResponse>;
  /**
   * @param callback The callback
   */
  undelete(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  undelete(options: Models.BlobUndeleteOptionalParams, callback: msRest.ServiceCallback<void>): void;
  undelete(options?: Models.BlobUndeleteOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobUndeleteResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      undeleteOperationSpec,
      callback) as Promise<Models.BlobUndeleteResponse>;
  }

  /**
   * The Set HTTP Headers operation sets system properties on the blob
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobSetHTTPHeadersResponse>
   */
  setHTTPHeaders(options?: Models.BlobSetHTTPHeadersOptionalParams): Promise<Models.BlobSetHTTPHeadersResponse>;
  /**
   * @param callback The callback
   */
  setHTTPHeaders(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  setHTTPHeaders(options: Models.BlobSetHTTPHeadersOptionalParams, callback: msRest.ServiceCallback<void>): void;
  setHTTPHeaders(options?: Models.BlobSetHTTPHeadersOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobSetHTTPHeadersResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      setHTTPHeadersOperationSpec,
      callback) as Promise<Models.BlobSetHTTPHeadersResponse>;
  }

  /**
   * The Set Blob Metadata operation sets user-defined metadata for the specified blob as one or more
   * name-value pairs
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobSetMetadataResponse>
   */
  setMetadata(options?: Models.BlobSetMetadataOptionalParams): Promise<Models.BlobSetMetadataResponse>;
  /**
   * @param callback The callback
   */
  setMetadata(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  setMetadata(options: Models.BlobSetMetadataOptionalParams, callback: msRest.ServiceCallback<void>): void;
  setMetadata(options?: Models.BlobSetMetadataOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobSetMetadataResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      setMetadataOperationSpec,
      callback) as Promise<Models.BlobSetMetadataResponse>;
  }

  /**
   * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
   * operations
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobAcquireLeaseResponse>
   */
  acquireLease(options?: Models.BlobAcquireLeaseOptionalParams): Promise<Models.BlobAcquireLeaseResponse>;
  /**
   * @param callback The callback
   */
  acquireLease(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  acquireLease(options: Models.BlobAcquireLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
  acquireLease(options?: Models.BlobAcquireLeaseOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobAcquireLeaseResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      acquireLeaseOperationSpec,
      callback) as Promise<Models.BlobAcquireLeaseResponse>;
  }

  /**
   * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
   * operations
   * @param leaseId Specifies the current lease ID on the resource.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobReleaseLeaseResponse>
   */
  releaseLease(leaseId: string, options?: Models.BlobReleaseLeaseOptionalParams): Promise<Models.BlobReleaseLeaseResponse>;
  /**
   * @param leaseId Specifies the current lease ID on the resource.
   * @param callback The callback
   */
  releaseLease(leaseId: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param leaseId Specifies the current lease ID on the resource.
   * @param options The optional parameters
   * @param callback The callback
   */
  releaseLease(leaseId: string, options: Models.BlobReleaseLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
  releaseLease(leaseId: string, options?: Models.BlobReleaseLeaseOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobReleaseLeaseResponse> {
    return this.client.sendOperationRequest(
      {
        leaseId,
        options
      },
      releaseLeaseOperationSpec,
      callback) as Promise<Models.BlobReleaseLeaseResponse>;
  }

  /**
   * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
   * operations
   * @param leaseId Specifies the current lease ID on the resource.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobRenewLeaseResponse>
   */
  renewLease(leaseId: string, options?: Models.BlobRenewLeaseOptionalParams): Promise<Models.BlobRenewLeaseResponse>;
  /**
   * @param leaseId Specifies the current lease ID on the resource.
   * @param callback The callback
   */
  renewLease(leaseId: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param leaseId Specifies the current lease ID on the resource.
   * @param options The optional parameters
   * @param callback The callback
   */
  renewLease(leaseId: string, options: Models.BlobRenewLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
  renewLease(leaseId: string, options?: Models.BlobRenewLeaseOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobRenewLeaseResponse> {
    return this.client.sendOperationRequest(
      {
        leaseId,
        options
      },
      renewLeaseOperationSpec,
      callback) as Promise<Models.BlobRenewLeaseResponse>;
  }

  /**
   * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
   * operations
   * @param leaseId Specifies the current lease ID on the resource.
   * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400
   * (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor
   * (String) for a list of valid GUID string formats.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobChangeLeaseResponse>
   */
  changeLease(leaseId: string, proposedLeaseId: string, options?: Models.BlobChangeLeaseOptionalParams): Promise<Models.BlobChangeLeaseResponse>;
  /**
   * @param leaseId Specifies the current lease ID on the resource.
   * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400
   * (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor
   * (String) for a list of valid GUID string formats.
   * @param callback The callback
   */
  changeLease(leaseId: string, proposedLeaseId: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param leaseId Specifies the current lease ID on the resource.
   * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400
   * (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor
   * (String) for a list of valid GUID string formats.
   * @param options The optional parameters
   * @param callback The callback
   */
  changeLease(leaseId: string, proposedLeaseId: string, options: Models.BlobChangeLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
  changeLease(leaseId: string, proposedLeaseId: string, options?: Models.BlobChangeLeaseOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobChangeLeaseResponse> {
    return this.client.sendOperationRequest(
      {
        leaseId,
        proposedLeaseId,
        options
      },
      changeLeaseOperationSpec,
      callback) as Promise<Models.BlobChangeLeaseResponse>;
  }

  /**
   * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
   * operations
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobBreakLeaseResponse>
   */
  breakLease(options?: Models.BlobBreakLeaseOptionalParams): Promise<Models.BlobBreakLeaseResponse>;
  /**
   * @param callback The callback
   */
  breakLease(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  breakLease(options: Models.BlobBreakLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
  breakLease(options?: Models.BlobBreakLeaseOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobBreakLeaseResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      breakLeaseOperationSpec,
      callback) as Promise<Models.BlobBreakLeaseResponse>;
  }

  /**
   * The Create Snapshot operation creates a read-only snapshot of a blob
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobCreateSnapshotResponse>
   */
  createSnapshot(options?: Models.BlobCreateSnapshotOptionalParams): Promise<Models.BlobCreateSnapshotResponse>;
  /**
   * @param callback The callback
   */
  createSnapshot(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  createSnapshot(options: Models.BlobCreateSnapshotOptionalParams, callback: msRest.ServiceCallback<void>): void;
  createSnapshot(options?: Models.BlobCreateSnapshotOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobCreateSnapshotResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      createSnapshotOperationSpec,
      callback) as Promise<Models.BlobCreateSnapshotResponse>;
  }

  /**
   * The Start Copy From URL operation copies a blob or an internet resource to a new blob.
   * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up
   * to 2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it
   * would appear in a request URI. The source blob must either be public or must be authenticated
   * via a shared access signature.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobStartCopyFromURLResponse>
   */
  startCopyFromURL(copySource: string, options?: Models.BlobStartCopyFromURLOptionalParams): Promise<Models.BlobStartCopyFromURLResponse>;
  /**
   * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up
   * to 2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it
   * would appear in a request URI. The source blob must either be public or must be authenticated
   * via a shared access signature.
   * @param callback The callback
   */
  startCopyFromURL(copySource: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up
   * to 2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it
   * would appear in a request URI. The source blob must either be public or must be authenticated
   * via a shared access signature.
   * @param options The optional parameters
   * @param callback The callback
   */
  startCopyFromURL(copySource: string, options: Models.BlobStartCopyFromURLOptionalParams, callback: msRest.ServiceCallback<void>): void;
  startCopyFromURL(copySource: string, options?: Models.BlobStartCopyFromURLOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobStartCopyFromURLResponse> {
    return this.client.sendOperationRequest(
      {
        copySource,
        options
      },
      startCopyFromURLOperationSpec,
      callback) as Promise<Models.BlobStartCopyFromURLResponse>;
  }

  /**
   * The Copy From URL operation copies a blob or an internet resource to a new blob. It will not
   * return a response until the copy is complete.
   * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up
   * to 2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it
   * would appear in a request URI. The source blob must either be public or must be authenticated
   * via a shared access signature.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobCopyFromURLResponse>
   */
  copyFromURL(copySource: string, options?: Models.BlobCopyFromURLOptionalParams): Promise<Models.BlobCopyFromURLResponse>;
  /**
   * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up
   * to 2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it
   * would appear in a request URI. The source blob must either be public or must be authenticated
   * via a shared access signature.
   * @param callback The callback
   */
  copyFromURL(copySource: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up
   * to 2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it
   * would appear in a request URI. The source blob must either be public or must be authenticated
   * via a shared access signature.
   * @param options The optional parameters
   * @param callback The callback
   */
  copyFromURL(copySource: string, options: Models.BlobCopyFromURLOptionalParams, callback: msRest.ServiceCallback<void>): void;
  copyFromURL(copySource: string, options?: Models.BlobCopyFromURLOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobCopyFromURLResponse> {
    return this.client.sendOperationRequest(
      {
        copySource,
        options
      },
      copyFromURLOperationSpec,
      callback) as Promise<Models.BlobCopyFromURLResponse>;
  }

  /**
   * The Abort Copy From URL operation aborts a pending Copy From URL operation, and leaves a
   * destination blob with zero length and full metadata.
   * @param copyId The copy identifier provided in the x-ms-copy-id header of the original Copy Blob
   * operation.
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobAbortCopyFromURLResponse>
   */
  abortCopyFromURL(copyId: string, options?: Models.BlobAbortCopyFromURLOptionalParams): Promise<Models.BlobAbortCopyFromURLResponse>;
  /**
   * @param copyId The copy identifier provided in the x-ms-copy-id header of the original Copy Blob
   * operation.
   * @param callback The callback
   */
  abortCopyFromURL(copyId: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param copyId The copy identifier provided in the x-ms-copy-id header of the original Copy Blob
   * operation.
   * @param options The optional parameters
   * @param callback The callback
   */
  abortCopyFromURL(copyId: string, options: Models.BlobAbortCopyFromURLOptionalParams, callback: msRest.ServiceCallback<void>): void;
  abortCopyFromURL(copyId: string, options?: Models.BlobAbortCopyFromURLOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobAbortCopyFromURLResponse> {
    return this.client.sendOperationRequest(
      {
        copyId,
        options
      },
      abortCopyFromURLOperationSpec,
      callback) as Promise<Models.BlobAbortCopyFromURLResponse>;
  }

  /**
   * The Set Tier operation sets the tier on a blob. The operation is allowed on a page blob in a
   * premium storage account and on a block blob in a blob storage account (locally redundant storage
   * only). A premium page blob's tier determines the allowed size, IOPS, and bandwidth of the blob.
   * A block blob's tier determines Hot/Cool/Archive storage type. This operation does not update the
   * blob's ETag.
   * @param tier Indicates the tier to be set on the blob. Possible values include: 'P4', 'P6',
   * 'P10', 'P15', 'P20', 'P30', 'P40', 'P50', 'P60', 'P70', 'P80', 'Hot', 'Cool', 'Archive'
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobSetTierResponse>
   */
  setTier(tier: Models.AccessTier, options?: Models.BlobSetTierOptionalParams): Promise<Models.BlobSetTierResponse>;
  /**
   * @param tier Indicates the tier to be set on the blob. Possible values include: 'P4', 'P6',
   * 'P10', 'P15', 'P20', 'P30', 'P40', 'P50', 'P60', 'P70', 'P80', 'Hot', 'Cool', 'Archive'
   * @param callback The callback
   */
  setTier(tier: Models.AccessTier, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param tier Indicates the tier to be set on the blob. Possible values include: 'P4', 'P6',
   * 'P10', 'P15', 'P20', 'P30', 'P40', 'P50', 'P60', 'P70', 'P80', 'Hot', 'Cool', 'Archive'
   * @param options The optional parameters
   * @param callback The callback
   */
  setTier(tier: Models.AccessTier, options: Models.BlobSetTierOptionalParams, callback: msRest.ServiceCallback<void>): void;
  setTier(tier: Models.AccessTier, options?: Models.BlobSetTierOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobSetTierResponse> {
    return this.client.sendOperationRequest(
      {
        tier,
        options
      },
      setTierOperationSpec,
      callback) as Promise<Models.BlobSetTierResponse>;
  }

  /**
   * Returns the sku name and account kind
   * @param [options] The optional parameters
   * @returns Promise<Models.BlobGetAccountInfoResponse>
   */
  getAccountInfo(options?: msRest.RequestOptionsBase): Promise<Models.BlobGetAccountInfoResponse>;
  /**
   * @param callback The callback
   */
  getAccountInfo(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  getAccountInfo(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
  getAccountInfo(options?: msRest.RequestOptionsBase | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.BlobGetAccountInfoResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      getAccountInfoOperationSpec,
      callback) as Promise<Models.BlobGetAccountInfoResponse>;
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers, true);
const downloadOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.snapshot,
    Parameters.timeout
  ],
  headerParameters: [
    Parameters.range0,
    Parameters.rangeGetContentMD5,
    Parameters.rangeGetContentCRC64,
    Parameters.version,
    Parameters.requestId,
    Parameters.leaseId0,
    Parameters.encryptionKey,
    Parameters.encryptionKeySha256,
    Parameters.encryptionAlgorithm,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    200: {
      bodyMapper: {
        serializedName: "parsedResponse",
        type: {
          name: "Stream"
        }
      },
      headersMapper: Mappers.BlobDownloadHeaders
    },
    206: {
      bodyMapper: {
        serializedName: "parsedResponse",
        type: {
          name: "Stream"
        }
      },
      headersMapper: Mappers.BlobDownloadHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const getPropertiesOperationSpec: msRest.OperationSpec = {
  httpMethod: "HEAD",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.snapshot,
    Parameters.timeout
  ],
  headerParameters: [
    Parameters.version,
    Parameters.requestId,
    Parameters.leaseId0,
    Parameters.encryptionKey,
    Parameters.encryptionKeySha256,
    Parameters.encryptionAlgorithm,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobGetPropertiesHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const deleteMethodOperationSpec: msRest.OperationSpec = {
  httpMethod: "DELETE",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.snapshot,
    Parameters.timeout
  ],
  headerParameters: [
    Parameters.deleteSnapshots,
    Parameters.version,
    Parameters.requestId,
    Parameters.leaseId0,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    202: {
      headersMapper: Mappers.BlobDeleteHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const setAccessControlOperationSpec: msRest.OperationSpec = {
  httpMethod: "PATCH",
  path: "{filesystem}/{path}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.action5
  ],
  headerParameters: [
    Parameters.owner,
    Parameters.group,
    Parameters.posixPermissions,
    Parameters.posixAcl,
    Parameters.requestId,
    Parameters.version,
    Parameters.leaseId0,
    Parameters.ifMatch,
    Parameters.ifNoneMatch,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobSetAccessControlHeaders
    },
    default: {
      bodyMapper: Mappers.DataLakeStorageError
    }
  },
  isXML: true,
  serializer
};

const getAccessControlOperationSpec: msRest.OperationSpec = {
  httpMethod: "HEAD",
  path: "{filesystem}/{path}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.upn,
    Parameters.action6
  ],
  headerParameters: [
    Parameters.requestId,
    Parameters.version,
    Parameters.leaseId0,
    Parameters.ifMatch,
    Parameters.ifNoneMatch,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobGetAccessControlHeaders
    },
    default: {
      bodyMapper: Mappers.DataLakeStorageError
    }
  },
  isXML: true,
  serializer
};

const renameOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{filesystem}/{path}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.pathRenameMode
  ],
  headerParameters: [
    Parameters.renameSource,
    Parameters.directoryProperties,
    Parameters.posixPermissions,
    Parameters.posixUmask,
    Parameters.sourceLeaseId,
    Parameters.version,
    Parameters.requestId,
    Parameters.cacheControl,
    Parameters.contentType,
    Parameters.contentEncoding,
    Parameters.contentLanguage,
    Parameters.contentDisposition,
    Parameters.leaseId0,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch,
    Parameters.sourceIfModifiedSince,
    Parameters.sourceIfUnmodifiedSince,
    Parameters.sourceIfMatch,
    Parameters.sourceIfNoneMatch
  ],
  responses: {
    201: {
      headersMapper: Mappers.BlobRenameHeaders
    },
    default: {
      bodyMapper: Mappers.DataLakeStorageError
    }
  },
  isXML: true,
  serializer
};

const undeleteOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp8
  ],
  headerParameters: [
    Parameters.version,
    Parameters.requestId
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobUndeleteHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const setHTTPHeadersOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp0
  ],
  headerParameters: [
    Parameters.version,
    Parameters.requestId,
    Parameters.blobCacheControl,
    Parameters.blobContentType,
    Parameters.blobContentMD5,
    Parameters.blobContentEncoding,
    Parameters.blobContentLanguage,
    Parameters.blobContentDisposition,
    Parameters.leaseId0,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobSetHTTPHeadersHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const setMetadataOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp5
  ],
  headerParameters: [
    Parameters.metadata,
    Parameters.version,
    Parameters.requestId,
    Parameters.leaseId0,
    Parameters.encryptionKey,
    Parameters.encryptionKeySha256,
    Parameters.encryptionAlgorithm,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobSetMetadataHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const acquireLeaseOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp7
  ],
  headerParameters: [
    Parameters.duration,
    Parameters.proposedLeaseId0,
    Parameters.version,
    Parameters.requestId,
    Parameters.action0,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    201: {
      headersMapper: Mappers.BlobAcquireLeaseHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const releaseLeaseOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp7
  ],
  headerParameters: [
    Parameters.leaseId1,
    Parameters.version,
    Parameters.requestId,
    Parameters.action1,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobReleaseLeaseHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const renewLeaseOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp7
  ],
  headerParameters: [
    Parameters.leaseId1,
    Parameters.version,
    Parameters.requestId,
    Parameters.action2,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobRenewLeaseHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const changeLeaseOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp7
  ],
  headerParameters: [
    Parameters.leaseId1,
    Parameters.proposedLeaseId1,
    Parameters.version,
    Parameters.requestId,
    Parameters.action4,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobChangeLeaseHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const breakLeaseOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp7
  ],
  headerParameters: [
    Parameters.breakPeriod,
    Parameters.version,
    Parameters.requestId,
    Parameters.action3,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    202: {
      headersMapper: Mappers.BlobBreakLeaseHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const createSnapshotOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp9
  ],
  headerParameters: [
    Parameters.metadata,
    Parameters.version,
    Parameters.requestId,
    Parameters.encryptionKey,
    Parameters.encryptionKeySha256,
    Parameters.encryptionAlgorithm,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch,
    Parameters.leaseId0
  ],
  responses: {
    201: {
      headersMapper: Mappers.BlobCreateSnapshotHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const startCopyFromURLOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout
  ],
  headerParameters: [
    Parameters.metadata,
    Parameters.tier0,
    Parameters.rehydratePriority,
    Parameters.copySource,
    Parameters.version,
    Parameters.requestId,
    Parameters.sourceIfModifiedSince,
    Parameters.sourceIfUnmodifiedSince,
    Parameters.sourceIfMatch,
    Parameters.sourceIfNoneMatch,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch,
    Parameters.leaseId0
  ],
  responses: {
    202: {
      headersMapper: Mappers.BlobStartCopyFromURLHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const copyFromURLOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout
  ],
  headerParameters: [
    Parameters.metadata,
    Parameters.tier0,
    Parameters.copySource,
    Parameters.version,
    Parameters.requestId,
    Parameters.xMsRequiresSync,
    Parameters.sourceIfModifiedSince,
    Parameters.sourceIfUnmodifiedSince,
    Parameters.sourceIfMatch,
    Parameters.sourceIfNoneMatch,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch,
    Parameters.leaseId0
  ],
  responses: {
    202: {
      headersMapper: Mappers.BlobCopyFromURLHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const abortCopyFromURLOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.copyId,
    Parameters.timeout,
    Parameters.comp10
  ],
  headerParameters: [
    Parameters.version,
    Parameters.requestId,
    Parameters.copyActionAbortConstant,
    Parameters.leaseId0
  ],
  responses: {
    204: {
      headersMapper: Mappers.BlobAbortCopyFromURLHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const setTierOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.comp11
  ],
  headerParameters: [
    Parameters.tier1,
    Parameters.rehydratePriority,
    Parameters.version,
    Parameters.requestId,
    Parameters.leaseId0
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobSetTierHeaders
    },
    202: {
      headersMapper: Mappers.BlobSetTierHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};

const getAccountInfoOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "{containerName}/{blob}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.restype1,
    Parameters.comp0
  ],
  headerParameters: [
    Parameters.version
  ],
  responses: {
    200: {
      headersMapper: Mappers.BlobGetAccountInfoHeaders
    },
    default: {
      bodyMapper: Mappers.StorageError
    }
  },
  isXML: true,
  serializer
};
