/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import * as Mappers from "../models/directoryMappers";
import * as Parameters from "../models/parameters";
import { StorageClientContext } from "../storageClientContext";

/** Class representing a Directory. */
export class Directory {
  private readonly client: StorageClientContext;

  /**
   * Create a Directory.
   * @param {StorageClientContext} client Reference to the service client.
   */
  constructor(client: StorageClientContext) {
    this.client = client;
  }

  /**
   * Create a directory. By default, the destination is overwritten and if the destination already
   * exists and has a lease the lease is broken. This operation supports conditional HTTP requests.
   * For more information, see [Specifying Conditional Headers for Blob Service
   * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
   * To fail if the destination already exists, use a conditional request with If-None-Match: "*".
   * @param [options] The optional parameters
   * @returns Promise<Models.DirectoryCreateResponse>
   */
  create(options?: Models.DirectoryCreateOptionalParams): Promise<Models.DirectoryCreateResponse>;
  /**
   * @param callback The callback
   */
  create(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  create(options: Models.DirectoryCreateOptionalParams, callback: msRest.ServiceCallback<void>): void;
  create(options?: Models.DirectoryCreateOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.DirectoryCreateResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      createOperationSpec,
      callback) as Promise<Models.DirectoryCreateResponse>;
  }

  /**
   * Rename a directory. By default, the destination is overwritten and if the destination already
   * exists and has a lease the lease is broken. This operation supports conditional HTTP requests.
   * For more information, see [Specifying Conditional Headers for Blob Service
   * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
   * To fail if the destination already exists, use a conditional request with If-None-Match: "*".
   * @param renameSource The file or directory to be renamed. The value must have the following
   * format: "/{filesysystem}/{path}".  If "x-ms-properties" is specified, the properties will
   * overwrite the existing properties; otherwise, the existing properties will be preserved.
   * @param [options] The optional parameters
   * @returns Promise<Models.DirectoryRenameResponse>
   */
  rename(renameSource: string, options?: Models.DirectoryRenameOptionalParams): Promise<Models.DirectoryRenameResponse>;
  /**
   * @param renameSource The file or directory to be renamed. The value must have the following
   * format: "/{filesysystem}/{path}".  If "x-ms-properties" is specified, the properties will
   * overwrite the existing properties; otherwise, the existing properties will be preserved.
   * @param callback The callback
   */
  rename(renameSource: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param renameSource The file or directory to be renamed. The value must have the following
   * format: "/{filesysystem}/{path}".  If "x-ms-properties" is specified, the properties will
   * overwrite the existing properties; otherwise, the existing properties will be preserved.
   * @param options The optional parameters
   * @param callback The callback
   */
  rename(renameSource: string, options: Models.DirectoryRenameOptionalParams, callback: msRest.ServiceCallback<void>): void;
  rename(renameSource: string, options?: Models.DirectoryRenameOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.DirectoryRenameResponse> {
    return this.client.sendOperationRequest(
      {
        renameSource,
        options
      },
      renameOperationSpec,
      callback) as Promise<Models.DirectoryRenameResponse>;
  }

  /**
   * Deletes the directory
   * @param recursiveDirectoryDelete If "true", all paths beneath the directory will be deleted. If
   * "false" and the directory is non-empty, an error occurs.
   * @param [options] The optional parameters
   * @returns Promise<Models.DirectoryDeleteResponse>
   */
  deleteMethod(recursiveDirectoryDelete: boolean, options?: Models.DirectoryDeleteMethodOptionalParams): Promise<Models.DirectoryDeleteResponse>;
  /**
   * @param recursiveDirectoryDelete If "true", all paths beneath the directory will be deleted. If
   * "false" and the directory is non-empty, an error occurs.
   * @param callback The callback
   */
  deleteMethod(recursiveDirectoryDelete: boolean, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param recursiveDirectoryDelete If "true", all paths beneath the directory will be deleted. If
   * "false" and the directory is non-empty, an error occurs.
   * @param options The optional parameters
   * @param callback The callback
   */
  deleteMethod(recursiveDirectoryDelete: boolean, options: Models.DirectoryDeleteMethodOptionalParams, callback: msRest.ServiceCallback<void>): void;
  deleteMethod(recursiveDirectoryDelete: boolean, options?: Models.DirectoryDeleteMethodOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.DirectoryDeleteResponse> {
    return this.client.sendOperationRequest(
      {
        recursiveDirectoryDelete,
        options
      },
      deleteMethodOperationSpec,
      callback) as Promise<Models.DirectoryDeleteResponse>;
  }

  /**
   * Set the owner, group, permissions, or access control list for a directory.
   * @param [options] The optional parameters
   * @returns Promise<Models.DirectorySetAccessControlResponse>
   */
  setAccessControl(options?: Models.DirectorySetAccessControlOptionalParams): Promise<Models.DirectorySetAccessControlResponse>;
  /**
   * @param callback The callback
   */
  setAccessControl(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  setAccessControl(options: Models.DirectorySetAccessControlOptionalParams, callback: msRest.ServiceCallback<void>): void;
  setAccessControl(options?: Models.DirectorySetAccessControlOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.DirectorySetAccessControlResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      setAccessControlOperationSpec,
      callback) as Promise<Models.DirectorySetAccessControlResponse>;
  }

  /**
   * Get the owner, group, permissions, or access control list for a directory.
   * @param [options] The optional parameters
   * @returns Promise<Models.DirectoryGetAccessControlResponse>
   */
  getAccessControl(options?: Models.DirectoryGetAccessControlOptionalParams): Promise<Models.DirectoryGetAccessControlResponse>;
  /**
   * @param callback The callback
   */
  getAccessControl(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  getAccessControl(options: Models.DirectoryGetAccessControlOptionalParams, callback: msRest.ServiceCallback<void>): void;
  getAccessControl(options?: Models.DirectoryGetAccessControlOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<Models.DirectoryGetAccessControlResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      getAccessControlOperationSpec,
      callback) as Promise<Models.DirectoryGetAccessControlResponse>;
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers, true);
const createOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{filesystem}/{path}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.resource
  ],
  headerParameters: [
    Parameters.directoryProperties,
    Parameters.posixPermissions,
    Parameters.posixUmask,
    Parameters.version,
    Parameters.requestId,
    Parameters.cacheControl,
    Parameters.contentType,
    Parameters.contentEncoding,
    Parameters.contentLanguage,
    Parameters.contentDisposition,
    Parameters.leaseId0,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    201: {
      headersMapper: Mappers.DirectoryCreateHeaders
    },
    default: {
      bodyMapper: Mappers.DataLakeStorageError
    }
  },
  isXML: true,
  serializer
};

const renameOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "{filesystem}/{path}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.marker1,
    Parameters.pathRenameMode
  ],
  headerParameters: [
    Parameters.renameSource,
    Parameters.directoryProperties,
    Parameters.posixPermissions,
    Parameters.posixUmask,
    Parameters.sourceLeaseId,
    Parameters.version,
    Parameters.requestId,
    Parameters.cacheControl,
    Parameters.contentType,
    Parameters.contentEncoding,
    Parameters.contentLanguage,
    Parameters.contentDisposition,
    Parameters.leaseId0,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch,
    Parameters.sourceIfModifiedSince,
    Parameters.sourceIfUnmodifiedSince,
    Parameters.sourceIfMatch,
    Parameters.sourceIfNoneMatch
  ],
  responses: {
    201: {
      headersMapper: Mappers.DirectoryRenameHeaders
    },
    default: {
      bodyMapper: Mappers.DataLakeStorageError
    }
  },
  isXML: true,
  serializer
};

const deleteMethodOperationSpec: msRest.OperationSpec = {
  httpMethod: "DELETE",
  path: "{filesystem}/{path}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.recursiveDirectoryDelete,
    Parameters.marker1
  ],
  headerParameters: [
    Parameters.version,
    Parameters.requestId,
    Parameters.leaseId0,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince,
    Parameters.ifMatch,
    Parameters.ifNoneMatch
  ],
  responses: {
    200: {
      headersMapper: Mappers.DirectoryDeleteHeaders
    },
    default: {
      bodyMapper: Mappers.DataLakeStorageError
    }
  },
  isXML: true,
  serializer
};

const setAccessControlOperationSpec: msRest.OperationSpec = {
  httpMethod: "PATCH",
  path: "{filesystem}/{path}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.action5
  ],
  headerParameters: [
    Parameters.owner,
    Parameters.group,
    Parameters.posixPermissions,
    Parameters.posixAcl,
    Parameters.requestId,
    Parameters.version,
    Parameters.leaseId0,
    Parameters.ifMatch,
    Parameters.ifNoneMatch,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince
  ],
  responses: {
    200: {
      headersMapper: Mappers.DirectorySetAccessControlHeaders
    },
    default: {
      bodyMapper: Mappers.DataLakeStorageError
    }
  },
  isXML: true,
  serializer
};

const getAccessControlOperationSpec: msRest.OperationSpec = {
  httpMethod: "HEAD",
  path: "{filesystem}/{path}",
  urlParameters: [
    Parameters.url
  ],
  queryParameters: [
    Parameters.timeout,
    Parameters.upn,
    Parameters.action6
  ],
  headerParameters: [
    Parameters.requestId,
    Parameters.version,
    Parameters.leaseId0,
    Parameters.ifMatch,
    Parameters.ifNoneMatch,
    Parameters.ifModifiedSince,
    Parameters.ifUnmodifiedSince
  ],
  responses: {
    200: {
      headersMapper: Mappers.DirectoryGetAccessControlHeaders
    },
    default: {
      bodyMapper: Mappers.DataLakeStorageError
    }
  },
  isXML: true,
  serializer
};
