import { RequestPolicy, RequestPolicyFactory, RequestPolicyOptions } from "@azure/ms-rest-js";
import { KeepAlivePolicy } from "./policies/KeepAlivePolicy";
/**
 * Interface of KeepAlivePolicy options.
 *
 * @export
 * @interface IKeepAliveOptions
 */
export interface IKeepAliveOptions {
    enable: boolean;
}
/**
 * KeepAlivePolicyFactory is a factory class helping generating KeepAlivePolicy objects.
 *
 * @export
 * @class KeepAlivePolicyFactory
 * @implements {RequestPolicyFactory}
 */
export declare class KeepAlivePolicyFactory implements RequestPolicyFactory {
    private readonly keepAliveOptions;
    /**
     * Creates an instance of KeepAlivePolicyFactory.
     *
     * @param {IKeepAliveOptions} [telemetry]
     * @memberof KeepAlivePolicyFactory
     */
    constructor(keepAliveOptions?: IKeepAliveOptions);
    create(nextPolicy: RequestPolicy, options: RequestPolicyOptions): KeepAlivePolicy;
}
//# sourceMappingURL=KeepAlivePolicyFactory.d.ts.map