import { BaseRequestPolicy, HttpClient as IHttpClient, HttpHeaders, HttpOperationResponse, HttpPipelineLogger as IHttpPipelineLogger, HttpPipelineLogLevel, HttpRequestBody, RequestPolicy, RequestPolicyFactory, RequestPolicyOptions, ServiceClientOptions, WebResource } from "@azure/ms-rest-js";
export { IHttpClient, IHttpPipelineLogger, HttpHeaders, HttpPipelineLogLevel, HttpRequestBody, HttpOperationResponse, WebResource, BaseRequestPolicy, RequestPolicyFactory, RequestPolicy, RequestPolicyOptions };
/**
 * Option interface for Pipeline constructor.
 *
 * @export
 * @interface IPipelineOptions
 */
export interface IPipelineOptions {
    logger?: IHttpPipelineLogger;
    HTTPClient?: IHttpClient;
}
/**
 * A Pipeline class containing HTTP request policies.
 * You can create a default Pipeline by calling StorageURL.newPipeline().
 * Or you can create a Pipeline with your own policies by the constructor of Pipeline.
 * Refer to StorageURL.newPipeline() and provided policies as reference before
 * implementing your customized Pipeline.
 *
 * @export
 * @class Pipeline
 */
export declare class Pipeline {
    readonly factories: RequestPolicyFactory[];
    readonly options: IPipelineOptions;
    /**
     * Creates an instance of Pipeline. Customize HTTPClient by implementing IHttpClient interface.
     *
     * @param {RequestPolicyFactory[]} factories
     * @param {IPipelineOptions} [options={}]
     * @memberof Pipeline
     */
    constructor(factories: RequestPolicyFactory[], options?: IPipelineOptions);
    /**
     * Transfer Pipeline object to ServiceClientOptions object which required by
     * ServiceClient constructor.
     *
     * @returns {ServiceClientOptions}
     * @memberof Pipeline
     */
    toServiceClientOptions(): ServiceClientOptions;
}
//# sourceMappingURL=Pipeline.d.ts.map