import { deserializationPolicy } from "@azure/ms-rest-js";
import { Credential } from "./credentials/Credential";
import { StorageClientContext } from "./generated/src/storageClientContext";
import { IKeepAliveOptions } from "./KeepAlivePolicyFactory";
import { IHttpClient, IHttpPipelineLogger, Pipeline } from "./Pipeline";
import { IRetryOptions } from "./RetryPolicyFactory";
import { ITelemetryOptions } from "./TelemetryPolicyFactory";
export { deserializationPolicy };
/**
 * Option interface for Pipeline.newPipeline method.
 *
 * @export
 * @interface INewPipelineOptions
 */
export interface INewPipelineOptions {
    /**
     * Telemetry configures the built-in telemetry policy behavior.
     *
     * @type {ITelemetryOptions}
     * @memberof INewPipelineOptions
     */
    telemetry?: ITelemetryOptions;
    /**
     * Retry options.
     *
     * @type {IRetryOptions}
     * @memberof INewPipelineOptions
     */
    retryOptions?: IRetryOptions;
    /**
     * Keep alive configurations. Default keep-alive is enabled.
     *
     * @type {IKeepAliveOptions}
     * @memberof INewPipelineOptions
     */
    keepAliveOptions?: IKeepAliveOptions;
    logger?: IHttpPipelineLogger;
    httpClient?: IHttpClient;
}
/**
 * A ServiceURL represents a based URL class for ServiceURL, ContainerURL and etc.
 *
 * @export
 * @class StorageURL
 */
export declare abstract class StorageURL {
    /**
     * A static method used to create a new Pipeline object with Credential provided.
     *
     * @static
     * @param {Credential} credential Such as AnonymousCredential, SharedKeyCredential or TokenCredential.
     * @param {INewPipelineOptions} [pipelineOptions] Optional. Options.
     * @returns {Pipeline} A new Pipeline object.
     * @memberof Pipeline
     */
    static newPipeline(credential: Credential, pipelineOptions?: INewPipelineOptions): Pipeline;
    /**
     * Request policy pipeline.
     *
     * @internal
     * @type {Pipeline}
     * @memberof StorageURL
     */
    readonly pipeline: Pipeline;
    /**
     * Encoded URL string value.
     *
     * @type {string}
     * @memberof StorageURL
     */
    readonly url: string;
    /**
     * Credential used for authentication and authorization.
     *
     * @type {string}
     * @memberof StorageURL
     */
    readonly credential: Credential;
    /**
     * StorageClient is a reference to protocol layer operations entry, which is
     * generated by AutoRest generator.
     *
     * @protected
     * @type {StorageClient}
     * @memberof StorageURL
     */
    protected readonly storageClientContext: StorageClientContext;
    /**
     * If the storage url is using https.
     * @param url
     * @param pipeline
     */
    protected readonly isHttps: boolean;
    /**
     * Creates an instance of StorageURL.
     * @param {string} url
     * @param {Pipeline} pipeline
     * @memberof StorageURL
     */
    protected constructor(url: string, pipeline: Pipeline);
}
//# sourceMappingURL=StorageURL.d.ts.map