import { RequestPolicy, RequestPolicyFactory, RequestPolicyOptions } from "@azure/ms-rest-js";
import { TelemetryPolicy } from "./policies/TelemetryPolicy";
/**
 * Interface of TelemetryPolicy options.
 *
 * @export
 * @interface ITelemetryOptions
 */
export interface ITelemetryOptions {
    value: string;
}
/**
 * TelemetryPolicyFactory is a factory class helping generating TelemetryPolicy objects.
 *
 * @export
 * @class TelemetryPolicyFactory
 * @implements {RequestPolicyFactory}
 */
export declare class TelemetryPolicyFactory implements RequestPolicyFactory {
    private telemetryString;
    /**
     * Creates an instance of TelemetryPolicyFactory.
     * @param {ITelemetryOptions} [telemetry]
     * @memberof TelemetryPolicyFactory
     */
    constructor(telemetry?: ITelemetryOptions);
    create(nextPolicy: RequestPolicy, options: RequestPolicyOptions): TelemetryPolicy;
}
//# sourceMappingURL=TelemetryPolicyFactory.d.ts.map