import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { StorageClientContext } from "../storageClientContext";
/** Class representing a Container. */
export declare class Container {
    private readonly client;
    /**
     * Create a Container.
     * @param {StorageClientContext} client Reference to the service client.
     */
    constructor(client: StorageClientContext);
    /**
     * creates a new container under the specified account. If the container with the same name already
     * exists, the operation fails
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerCreateResponse>
     */
    create(options?: Models.ContainerCreateOptionalParams): Promise<Models.ContainerCreateResponse>;
    /**
     * @param callback The callback
     */
    create(callback: msRest.ServiceCallback<void>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    create(options: Models.ContainerCreateOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * returns all user-defined metadata and system properties for the specified container. The data
     * returned does not include the container's list of blobs
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerGetPropertiesResponse>
     */
    getProperties(options?: Models.ContainerGetPropertiesOptionalParams): Promise<Models.ContainerGetPropertiesResponse>;
    /**
     * @param callback The callback
     */
    getProperties(callback: msRest.ServiceCallback<void>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    getProperties(options: Models.ContainerGetPropertiesOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * operation marks the specified container for deletion. The container and any blobs contained
     * within it are later deleted during garbage collection
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerDeleteResponse>
     */
    deleteMethod(options?: Models.ContainerDeleteMethodOptionalParams): Promise<Models.ContainerDeleteResponse>;
    /**
     * @param callback The callback
     */
    deleteMethod(callback: msRest.ServiceCallback<void>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    deleteMethod(options: Models.ContainerDeleteMethodOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerSetMetadataResponse>
     */
    setMetadata(options?: Models.ContainerSetMetadataOptionalParams): Promise<Models.ContainerSetMetadataResponse>;
    /**
     * @param callback The callback
     */
    setMetadata(callback: msRest.ServiceCallback<void>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    setMetadata(options: Models.ContainerSetMetadataOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * gets the permissions for the specified container. The permissions indicate whether container
     * data may be accessed publicly.
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerGetAccessPolicyResponse>
     */
    getAccessPolicy(options?: Models.ContainerGetAccessPolicyOptionalParams): Promise<Models.ContainerGetAccessPolicyResponse>;
    /**
     * @param callback The callback
     */
    getAccessPolicy(callback: msRest.ServiceCallback<Models.SignedIdentifier[]>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    getAccessPolicy(options: Models.ContainerGetAccessPolicyOptionalParams, callback: msRest.ServiceCallback<Models.SignedIdentifier[]>): void;
    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a
     * container may be accessed publicly.
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerSetAccessPolicyResponse>
     */
    setAccessPolicy(options?: Models.ContainerSetAccessPolicyOptionalParams): Promise<Models.ContainerSetAccessPolicyResponse>;
    /**
     * @param callback The callback
     */
    setAccessPolicy(callback: msRest.ServiceCallback<void>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    setAccessPolicy(options: Models.ContainerSetAccessPolicyOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration
     * can be 15 to 60 seconds, or can be infinite
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerAcquireLeaseResponse>
     */
    acquireLease(options?: Models.ContainerAcquireLeaseOptionalParams): Promise<Models.ContainerAcquireLeaseResponse>;
    /**
     * @param callback The callback
     */
    acquireLease(callback: msRest.ServiceCallback<void>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    acquireLease(options: Models.ContainerAcquireLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration
     * can be 15 to 60 seconds, or can be infinite
     * @param leaseId Specifies the current lease ID on the resource.
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerReleaseLeaseResponse>
     */
    releaseLease(leaseId: string, options?: Models.ContainerReleaseLeaseOptionalParams): Promise<Models.ContainerReleaseLeaseResponse>;
    /**
     * @param leaseId Specifies the current lease ID on the resource.
     * @param callback The callback
     */
    releaseLease(leaseId: string, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The optional parameters
     * @param callback The callback
     */
    releaseLease(leaseId: string, options: Models.ContainerReleaseLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration
     * can be 15 to 60 seconds, or can be infinite
     * @param leaseId Specifies the current lease ID on the resource.
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerRenewLeaseResponse>
     */
    renewLease(leaseId: string, options?: Models.ContainerRenewLeaseOptionalParams): Promise<Models.ContainerRenewLeaseResponse>;
    /**
     * @param leaseId Specifies the current lease ID on the resource.
     * @param callback The callback
     */
    renewLease(leaseId: string, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The optional parameters
     * @param callback The callback
     */
    renewLease(leaseId: string, options: Models.ContainerRenewLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration
     * can be 15 to 60 seconds, or can be infinite
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerBreakLeaseResponse>
     */
    breakLease(options?: Models.ContainerBreakLeaseOptionalParams): Promise<Models.ContainerBreakLeaseResponse>;
    /**
     * @param callback The callback
     */
    breakLease(callback: msRest.ServiceCallback<void>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    breakLease(options: Models.ContainerBreakLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration
     * can be 15 to 60 seconds, or can be infinite
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400
     * (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor
     * (String) for a list of valid GUID string formats.
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerChangeLeaseResponse>
     */
    changeLease(leaseId: string, proposedLeaseId: string, options?: Models.ContainerChangeLeaseOptionalParams): Promise<Models.ContainerChangeLeaseResponse>;
    /**
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400
     * (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor
     * (String) for a list of valid GUID string formats.
     * @param callback The callback
     */
    changeLease(leaseId: string, proposedLeaseId: string, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400
     * (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor
     * (String) for a list of valid GUID string formats.
     * @param options The optional parameters
     * @param callback The callback
     */
    changeLease(leaseId: string, proposedLeaseId: string, options: Models.ContainerChangeLeaseOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerListBlobFlatSegmentResponse>
     */
    listBlobFlatSegment(options?: Models.ContainerListBlobFlatSegmentOptionalParams): Promise<Models.ContainerListBlobFlatSegmentResponse>;
    /**
     * @param callback The callback
     */
    listBlobFlatSegment(callback: msRest.ServiceCallback<Models.ListBlobsFlatSegmentResponse>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    listBlobFlatSegment(options: Models.ContainerListBlobFlatSegmentOptionalParams, callback: msRest.ServiceCallback<Models.ListBlobsFlatSegmentResponse>): void;
    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix
     * element in the response body that acts as a placeholder for all blobs whose names begin with the
     * same substring up to the appearance of the delimiter character. The delimiter may be a single
     * character or a string.
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerListBlobHierarchySegmentResponse>
     */
    listBlobHierarchySegment(delimiter: string, options?: Models.ContainerListBlobHierarchySegmentOptionalParams): Promise<Models.ContainerListBlobHierarchySegmentResponse>;
    /**
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix
     * element in the response body that acts as a placeholder for all blobs whose names begin with the
     * same substring up to the appearance of the delimiter character. The delimiter may be a single
     * character or a string.
     * @param callback The callback
     */
    listBlobHierarchySegment(delimiter: string, callback: msRest.ServiceCallback<Models.ListBlobsHierarchySegmentResponse>): void;
    /**
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix
     * element in the response body that acts as a placeholder for all blobs whose names begin with the
     * same substring up to the appearance of the delimiter character. The delimiter may be a single
     * character or a string.
     * @param options The optional parameters
     * @param callback The callback
     */
    listBlobHierarchySegment(delimiter: string, options: Models.ContainerListBlobHierarchySegmentOptionalParams, callback: msRest.ServiceCallback<Models.ListBlobsHierarchySegmentResponse>): void;
    /**
     * Returns the sku name and account kind
     * @param [options] The optional parameters
     * @returns Promise<Models.ContainerGetAccountInfoResponse>
     */
    getAccountInfo(options?: msRest.RequestOptionsBase): Promise<Models.ContainerGetAccountInfoResponse>;
    /**
     * @param callback The callback
     */
    getAccountInfo(callback: msRest.ServiceCallback<void>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    getAccountInfo(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
}
//# sourceMappingURL=container.d.ts.map