import { Aborter } from "./Aborter";
import { BlockBlobURL } from "./BlockBlobURL";
import { BlobUploadCommonResponse, IUploadToBlockBlobOptions } from "./highlevel.common";
/**
 * ONLY AVAILABLE IN BROWSERS.
 *
 * Uploads a browser Blob/File/ArrayBuffer/ArrayBufferView object to block blob.
 *
 * When buffer length <= 256MB, this method will use 1 upload call to finish the upload.
 * Otherwise, this method will call stageBlock to upload blocks, and finally call commitBlockList
 * to commit the block list.
 *
 * @export
 * @param {Aborter} aborter Create a new Aborter instance with Aborter.none or Aborter.timeout(),
 *                          goto documents of Aborter for more examples about request cancellation
 * @param {Blob | ArrayBuffer | ArrayBufferView} browserData Blob, File, ArrayBuffer or ArrayBufferView
 * @param {BlockBlobURL} blockBlobURL
 * @param {IUploadToBlockBlobOptions} [options]
 * @returns {Promise<BlobUploadCommonResponse>}
 */
export declare function uploadBrowserDataToBlockBlob(aborter: Aborter, browserData: Blob | ArrayBuffer | ArrayBufferView, blockBlobURL: BlockBlobURL, options?: IUploadToBlockBlobOptions): Promise<BlobUploadCommonResponse>;
//# sourceMappingURL=highlevel.browser.d.ts.map