import { RequestPolicy, RequestPolicyOptions, WebResource } from "@azure/ms-rest-js";
import { TokenCredential } from "../credentials/TokenCredential";
import { CredentialPolicy } from "./CredentialPolicy";
/**
 * TokenCredentialPolicy is a policy used to sign HTTP request with a token.
 * Such as an OAuth bearer token.
 *
 * @export
 * @class TokenCredentialPolicy
 * @extends {CredentialPolicy}
 */
export declare class TokenCredentialPolicy extends CredentialPolicy {
    /**
     * The value of token.
     *
     * @type {TokenCredential}
     * @memberof TokenCredentialPolicy
     */
    readonly tokenCredential: TokenCredential;
    /**
     * Token authorization scheme, default header is "Bearer".
     *
     * @type {string}
     * @memberof TokenCredentialPolicy
     */
    readonly authorizationScheme: string;
    /**
     * Creates an instance of TokenCredentialPolicy.
     * @param {RequestPolicy} nextPolicy
     * @param {RequestPolicyOptions} options
     * @param {TokenCredential} tokenCredential
     * @memberof TokenCredentialPolicy
     */
    constructor(nextPolicy: RequestPolicy, options: RequestPolicyOptions, tokenCredential: TokenCredential);
    /**
     * Sign request with token.
     *
     * @protected
     * @param {WebResource} request
     * @returns {WebResource}
     * @memberof TokenCredentialPolicy
     */
    protected signRequest(request: WebResource): WebResource;
}
//# sourceMappingURL=TokenCredentialPolicy.d.ts.map