/* @flow */

"use strict";

exports.__esModule = true;
exports.ComprehensionBlock = ComprehensionBlock;
exports.ComprehensionExpression = ComprehensionExpression;

/*:: import type NodePrinter from "../node/printer";*/
function ComprehensionBlock(node /*: Object*/) {
  this.keyword("for");
  this.push("(");
  this.print(node.left, node);
  this.push(" of ");
  this.print(node.right, node);
  this.push(")");
}

function ComprehensionExpression(node /*: Object*/) {
  this.push(node.generator ? "(" : "[");

  this.printJoin(node.blocks, node, { separator: " " });
  this.space();

  if (node.filter) {
    this.keyword("if");
    this.push("(");
    this.print(node.filter, node);
    this.push(")");
    this.space();
  }

  this.print(node.body, node);

  this.push(node.generator ? ")" : "]");
}