'use strict';

var p = require('path');
var requireFromStringOfCode = require('require-from-string');
var objectToAST = require('./object-to-ast');

module.exports = {
  getReplacement,
  requireFromString
};

function requireFromString(_ref) {
  var stringToPreval = _ref.string,
      filename = _ref.fileOpts.filename,
      _ref$args = _ref.args,
      args = _ref$args === undefined ? [] : _ref$args;

  var mod = requireFromStringOfCode(String(stringToPreval), filename);
  mod = mod && mod.__esModule ? mod.default : mod;

  if (typeof mod === 'function') {
    mod = mod.apply(undefined, args);
  } else if (args.length) {
    throw new Error(`\`preval.require\`-ed module (${p.relative(process.cwd(), filename)}) cannot accept arguments because it does not export a function. You passed the arguments: ${args.join(', ')}`);
  }

  return mod;
}

function getReplacement(_ref2) {
  var string = _ref2.string,
      fileOpts = _ref2.fileOpts,
      args = _ref2.args,
      babel = _ref2.babel;

  var mod = requireFromString({ string, fileOpts, args, babel });
  return objectToAST(mod, { babel, fileOptions: fileOpts });
}