'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

module.exports = objectToAST;

function objectToAST(object, _ref) {
  var babel = _ref.babel,
      fileOptions = _ref.fileOptions;

  var stringified = stringify(object);
  var variableDeclarationNode = babel.template(`var x = ${stringified}`, _extends({
    preserveComments: true,
    placeholderPattern: false
  }, fileOptions.parserOpts, {
    sourceType: 'module'
  }))();
  return variableDeclarationNode.declarations[0].init;
}

function stringify(object) {
  var str = JSON.stringify(object, function (key, value) {
    if (typeof value === 'function') {
      return `__FUNCTION_START__${value.toString()}__FUNCTION_END__`;
    }
    return value;
  });
  if (str === undefined) {
    str = 'undefined';
  }
  return str.replace(/"__FUNCTION_START__(.*?)__FUNCTION_END__"/g, function (match, p1) {
    return p1.replace(/\\"/g, '"').replace(/\\n/g, '\n');
  });
}