'use strict';

var helperModuleImports = require('@babel/helper-module-imports');

const IMPORT = 'source-map-support/register';

function babelPluginSourceMapSupport () {
    return {
        visitor: {
            Program (path) {
                helperModuleImports.addSideEffect(path, IMPORT);
            }
        }
    }
}

module.exports = babelPluginSourceMapSupport;
