"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _pluginSyntaxJsx = _interopRequireDefault(require("@babel/plugin-syntax-jsx"));

var _pure = _interopRequireDefault(require("./visitors/pure"));

var _minify = _interopRequireDefault(require("./visitors/minify"));

var _displayNameAndId = _interopRequireDefault(require("./visitors/displayNameAndId"));

var _templateLiterals = _interopRequireDefault(require("./visitors/templateLiterals"));

var _assignStyledRequired = _interopRequireDefault(require("./visitors/assignStyledRequired"));

var _transpileCssProp = _interopRequireDefault(require("./visitors/transpileCssProp"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _default(_ref) {
  var t = _ref.types;
  return {
    inherits: _pluginSyntaxJsx.default,
    visitor: {
      // These visitors insert newly generated code and missing import/require statements
      Program: {
        enter(path, state) {
          state.required = false;
          state.items = [];
        },

        exit(path, state) {
          var _path$node$body;

          (_path$node$body = path.node.body).push.apply(_path$node$body, _toConsumableArray(state.items));
        }

      },

      JSXAttribute(path, state) {
        (0, _transpileCssProp.default)(t)(path, state);
      },

      CallExpression(path, state) {
        (0, _displayNameAndId.default)(t)(path, state);
        (0, _pure.default)(t)(path, state);
      },

      TaggedTemplateExpression(path, state) {
        (0, _minify.default)(t)(path, state);
        (0, _displayNameAndId.default)(t)(path, state);
        (0, _templateLiterals.default)(t)(path, state);
        (0, _pure.default)(t)(path, state);
      },

      VariableDeclarator(path, state) {
        (0, _assignStyledRequired.default)(t)(path, state);
      }

    }
  };
}