"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _options = require("../utils/options");

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var _default = function _default(t) {
  return function (path, state) {
    if (!(0, _options.useCssProp)(state)) return;
    if (path.node.name.name !== 'css') return; // Insert require('styled-components') if it doesn't exist yet

    var bindings = path.findParent(function (p) {
      return p.type === 'Program';
    }).scope.bindings;

    if (!state.required) {
      if (!bindings.styled) {
        state.items.push(t.variableDeclaration('var', [t.variableDeclarator(t.identifier('styled'), t.callExpression(t.identifier('require'), [t.stringLiteral('styled-components')]))]));
      }

      state.required = true;
    }

    var elem = path.parentPath;
    var id = path.scope.generateUidIdentifier('CSS' + elem.node.name.name.replace(/^([a-z])/, function (match, p1) {
      return p1.toUpperCase();
    }));
    var tag = elem.node.name.name;
    var styled = t.callExpression(t.identifier('styled'), [/^[a-z]/.test(tag) ? t.stringLiteral(tag) : t.identifier(tag)]);
    var css;

    if (t.isStringLiteral(path.node.value)) {
      css = t.templateLiteral([t.templateElement({
        raw: path.node.value.value
      }, true)], []);
    } else if (t.isJSXExpressionContainer(path.node.value)) {
      if (t.isTemplateLiteral(path.node.value.expression)) {
        css = path.node.value.expression;
      } else if (t.isTaggedTemplateExpression(path.node.value.expression) && path.node.value.expression.tag.name === 'css') {
        css = path.node.value.expression.quasi;
      } else {
        css = t.templateLiteral([t.templateElement({
          raw: ''
        }, false), t.templateElement({
          raw: ''
        }, true)], [path.node.value.expression]);
      }
    }

    if (!css) return;
    elem.node.attributes = elem.node.attributes.filter(function (attr) {
      return attr !== path.node;
    });
    elem.node.name.name = id.name;

    if (elem.parentPath.node.closingElement) {
      elem.parentPath.node.closingElement.name.name = id.name;
    }

    css.expressions = css.expressions.reduce(function (acc, ex) {
      if (Object.entries(bindings).some(function (_ref
      /*: any */
      ) {
        var _ref2 = _slicedToArray(_ref, 2),
            b = _ref2[1];

        return b.referencePaths.find(function (p) {
          return p.node === ex;
        });
      }) || t.isFunctionExpression(ex) || t.isArrowFunctionExpression(ex)) {
        acc.push(ex);
      } else {
        var name = path.scope.generateUidIdentifier(`_$p_`);
        var p = t.identifier('p');
        elem.node.attributes.push(t.jSXAttribute(t.jSXIdentifier(name.name), t.jSXExpressionContainer(ex)));
        acc.push(t.arrowFunctionExpression([p], t.memberExpression(p, name)));
      }

      return acc;
    }, []);
    state.items.push(t.variableDeclaration('var', [t.variableDeclarator(id, t.taggedTemplateExpression(styled, css))]));
  };
};

exports.default = _default;