"use strict";

exports.__esModule = true;
exports.filterStageFromList = exports.prettifyTargets = exports.prettifyVersion = exports.semverify = undefined;

var _semver = require("semver");

var _semver2 = _interopRequireDefault(_semver);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Convert version to a semver value.
// 2.5 -> 2.5.0; 1 -> 1.0.0;
var semverify = exports.semverify = function semverify(version) {
  if (typeof version === "string" && _semver2.default.valid(version)) {
    return version;
  }

  var split = version.toString().split(".");

  while (split.length < 3) {
    split.push("0");
  }

  return split.join(".");
};

var prettifyVersion = exports.prettifyVersion = function prettifyVersion(version) {
  if (typeof version !== "string") {
    return version;
  }

  var parts = [_semver2.default.major(version)];

  var minor = _semver2.default.minor(version);

  var patch = _semver2.default.patch(version);

  if (minor || patch) {
    parts.push(minor);
  }

  if (patch) {
    parts.push(patch);
  }

  return parts.join(".");
};

var prettifyTargets = exports.prettifyTargets = function prettifyTargets(targets) {
  return Object.keys(targets).reduce(function (results, target) {
    var value = targets[target];

    if (typeof value === "string") {
      value = prettifyVersion(value);
    }

    results[target] = value;
    return results;
  }, {});
};

var filterStageFromList = exports.filterStageFromList = function filterStageFromList(list, stageList) {
  return Object.keys(list).reduce(function (result, item) {
    if (!stageList[item]) {
      result[item] = list[item];
    }

    return result;
  }, {});
};