"use strict";

exports.__esModule = true;
exports.default = _default;

var _cloneDeep = _interopRequireDefault(require("lodash/cloneDeep"));

var _has = _interopRequireDefault(require("lodash/has"));

var _babelTraverse = _interopRequireDefault(require("babel-traverse"));

var babylon = _interopRequireWildcard(require("babylon"));

var _babelCodeFrame = require("babel-code-frame");

var t = _interopRequireWildcard(require("babel-types"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FROM_TEMPLATE = new Set();

function _default(firstArg) {
  for (var _len = arguments.length, rest = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    rest[_key - 1] = arguments[_key];
  }

  if (typeof firstArg === "string") {
    return factory.apply(void 0, [firstArg].concat(rest));
  } else {
    return template.apply(void 0, [firstArg].concat(rest));
  }
}

function template(partials) {
  if (!Array.isArray(partials)) {
    return templateApply.bind(undefined, partials);
  }

  for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    args[_key2 - 1] = arguments[_key2];
  }

  return templateApply.apply(void 0, [null, partials].concat(args));
}

function templateApply(opts, partials) {
  for (var _len3 = arguments.length, args = new Array(_len3 > 2 ? _len3 - 2 : 0), _key3 = 2; _key3 < _len3; _key3++) {
    args[_key3 - 2] = arguments[_key3];
  }

  if (partials.some(function (str) {
    return str.includes("$BABEL_TEMPLATE$");
  })) {
    throw new Error("Template contains illegal substring $BABEL_TEMPLATE$");
  }

  if (partials.length == 1) {
    return factory(partials[0], opts);
  }

  var replacementSet = new Set();
  var replacementMap = new Map();
  var replacementValueMap = new Map();
  var hasNonNumericReplacement = false;

  for (var _i = 0; _i < args.length; _i++) {
    var arg = args[_i];

    if (replacementMap.has(arg)) {
      continue;
    }

    if (typeof arg === "number") {
      replacementMap.set(arg, "$" + arg);
    } else if (typeof arg === "string") {
      var replacementBase = "$BABEL_TEMPLATE$$" + t.toIdentifier(arg);
      var replacement = replacementBase;

      for (var i = 2; replacementSet.has(replacement); i++) {
        replacement = "" + replacementBase + i;
      }

      replacementSet.add(replacement);
      replacementMap.set(arg, replacement);
      hasNonNumericReplacement = true;
    } else {
      var name = "$BABEL_TEMPLATE$VALUE$" + replacementValueMap.size;
      replacementMap.set(arg, name);
      replacementValueMap.set(name, arg);
      hasNonNumericReplacement = true;
    }
  }

  if (hasNonNumericReplacement && replacementMap.has(0)) {
    throw new Error("Template cannot have a '0' replacement and a named replacement at the same time");
  }

  var code = partials.reduce(function (acc, partial, i) {
    if (acc == null) {
      return partial;
    }

    var replacement = replacementMap.get(args[i - 1]);
    return "" + acc + replacement + partial;
  }, null);
  var func = factory(code, opts);
  return function () {
    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    if (hasNonNumericReplacement) {
      var argObj = args[0] || {};
      var converted = {};

      for (var _iterator = replacementMap, _isArray = Array.isArray(_iterator), _i2 = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
        var _ref2;

        if (_isArray) {
          if (_i2 >= _iterator.length) break;
          _ref2 = _iterator[_i2++];
        } else {
          _i2 = _iterator.next();
          if (_i2.done) break;
          _ref2 = _i2.value;
        }

        var _ref3 = _ref2;
        var _key5 = _ref3[0];
        var _replacement = _ref3[1];
        if (typeof _key5 === "number") continue;

        if (replacementValueMap.has(_replacement)) {
          converted[_replacement] = replacementValueMap.get(_replacement);
        } else {
          converted[_replacement] = argObj[_key5];
        }
      }

      args[0] = converted;
    }

    return func.apply(void 0, args);
  };
}

function factory(code, opts) {
  var stack;

  try {
    throw new Error();
  } catch (error) {
    if (error.stack) {
      stack = error.stack.split("\n").slice(2).join("\n");
    }
  }

  opts = Object.assign({
    allowReturnOutsideFunction: true,
    allowSuperOutsideMethod: true,
    preserveComments: false
  }, opts);

  var _getAst = function getAst() {
    var ast;

    try {
      ast = babylon.parse(code, opts);
      ast = _babelTraverse.default.removeProperties(ast, {
        preserveComments: opts.preserveComments
      });
    } catch (err) {
      var loc = err.loc;

      if (loc) {
        err.loc = null;
        err.message += "\n" + (0, _babelCodeFrame.codeFrameColumns)(code, {
          start: loc
        });
      }

      err.stack = err.stack + "\n    ==========================\n" + stack;
      throw err;
    }

    _getAst = function getAst() {
      return ast;
    };

    return ast;
  };

  return function () {
    for (var _len5 = arguments.length, args = new Array(_len5), _key6 = 0; _key6 < _len5; _key6++) {
      args[_key6] = arguments[_key6];
    }

    return useTemplate(_getAst(), args);
  };
}

function useTemplate(ast, nodes) {
  ast = (0, _cloneDeep.default)(ast);
  var _ast = ast,
      program = _ast.program;

  if (nodes.length) {
    _babelTraverse.default.cheap(ast, function (node) {
      FROM_TEMPLATE.add(node);
    });

    (0, _babelTraverse.default)(ast, templateVisitor, null, nodes);
    FROM_TEMPLATE.clear();
  }

  if (program.body.length > 1) {
    return program.body;
  } else {
    return program.body[0];
  }
}

var templateVisitor = {
  noScope: true,
  Identifier: function Identifier(path, args) {
    var _path = path,
        node = _path.node,
        parentPath = _path.parentPath;
    if (!FROM_TEMPLATE.has(node)) return path.skip();
    var replacement;

    if ((0, _has.default)(args[0], node.name)) {
      replacement = args[0][node.name];
    } else if (node.name[0] === "$") {
      var i = +node.name.slice(1);
      if (args[i]) replacement = args[i];
    }

    if (parentPath.isExpressionStatement()) {
      path = parentPath;
    }

    if (replacement === null) {
      path.remove();
    } else if (replacement) {
      path.replaceInline(replacement);
      path.skip();
    }
  },
  exit: function exit(_ref4) {
    var node = _ref4.node;

    if (!node.loc) {
      _babelTraverse.default.clearNode(node);
    }
  }
};