(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.Babel = {}));
}(this, (function (exports) { 'use strict';

  var babel = /*#__PURE__*/Object.freeze({
    __proto__: null,
    get version () { return version$3; },
    get types () { return t$p; },
    get DEFAULT_EXTENSIONS () { return DEFAULT_EXTENSIONS; },
    get OptionManager () { return OptionManager; },
    get Plugin () { return Plugin; },
    get File () { return File; },
    get buildExternalHelpers () { return babelBuildExternalHelpers; },
    get resolvePlugin () { return resolvePlugin; },
    get resolvePreset () { return resolvePreset; },
    get getEnv () { return getEnv; },
    get tokTypes () { return types$1; },
    get traverse () { return traverse; },
    get template () { return template$2; },
    get createConfigItem () { return createConfigItem; },
    get createConfigItemSync () { return createConfigItemSync; },
    get createConfigItemAsync () { return createConfigItemAsync; },
    get loadPartialConfig () { return loadPartialConfig; },
    get loadPartialConfigSync () { return loadPartialConfigSync; },
    get loadPartialConfigAsync () { return loadPartialConfigAsync; },
    get loadOptions () { return loadOptions; },
    get loadOptionsSync () { return loadOptionsSync; },
    get loadOptionsAsync () { return loadOptionsAsync; },
    get transform () { return transform$2; },
    get transformSync () { return transformSync; },
    get transformAsync () { return transformAsync; },
    get transformFile () { return transformFile; },
    get transformFileSync () { return transformFileSync; },
    get transformFileAsync () { return transformFileAsync; },
    get transformFromAst () { return transformFromAst$1; },
    get transformFromAstSync () { return transformFromAstSync; },
    get transformFromAstAsync () { return transformFromAstAsync; },
    get parse () { return parse$3; },
    get parseSync () { return parseSync; },
    get parseAsync () { return parseAsync; }
  });

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _taggedTemplateLiteralLoose(strings, raw) {
    if (!raw) {
      raw = strings.slice(0);
    }

    strings.raw = raw;
    return strings;
  }

  function _slicedToArray$2(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _iterableToArrayLimit(arr, i) {
    var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

    if (_i == null) return;
    var _arr = [];
    var _n = true;
    var _d = false;

    var _s, _e;

    try {
      for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _createForOfIteratorHelperLoose(o, allowArrayLike) {
    var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
    if (it) return (it = it.call(o)).next.bind(it);

    if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
      if (it) o = it;
      var i = 0;
      return function () {
        if (i >= o.length) return {
          done: true
        };
        return {
          done: false,
          value: o[i++]
        };
      };
    }

    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function shallowEqual(actual, expected) {
    var keys = Object.keys(expected);

    for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
      var key = _keys[_i];

      if (actual[key] !== expected[key]) {
        return false;
      }
    }

    return true;
  }

  function isArrayExpression$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ArrayExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isAssignmentExpression$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "AssignmentExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBinaryExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "BinaryExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isInterpreterDirective(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "InterpreterDirective") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDirective(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "Directive") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDirectiveLiteral(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DirectiveLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBlockStatement$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "BlockStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBreakStatement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "BreakStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isCallExpression$6(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "CallExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isCatchClause(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "CatchClause") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isConditionalExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ConditionalExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isContinueStatement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ContinueStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDebuggerStatement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DebuggerStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDoWhileStatement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DoWhileStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEmptyStatement$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EmptyStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExpressionStatement$4(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ExpressionStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFile$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "File") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isForInStatement$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ForInStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isForStatement$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ForStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFunctionDeclaration$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "FunctionDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFunctionExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "FunctionExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isIdentifier$g(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "Identifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isIfStatement$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "IfStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isLabeledStatement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "LabeledStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isStringLiteral$7(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "StringLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isNumericLiteral(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "NumericLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isNullLiteral$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "NullLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBooleanLiteral(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "BooleanLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isRegExpLiteral$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "RegExpLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isLogicalExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "LogicalExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isMemberExpression$8(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "MemberExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isNewExpression$4(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "NewExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isProgram$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "Program") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectExpression$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectMethod$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectMethod") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectProperty$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isRestElement$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "RestElement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isReturnStatement$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ReturnStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isSequenceExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "SequenceExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isParenthesizedExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ParenthesizedExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isSwitchCase(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "SwitchCase") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isSwitchStatement$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "SwitchStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isThisExpression$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ThisExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isThrowStatement$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ThrowStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTryStatement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TryStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isUnaryExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "UnaryExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isUpdateExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "UpdateExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isVariableDeclaration$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "VariableDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isVariableDeclarator$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "VariableDeclarator") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isWhileStatement$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "WhileStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isWithStatement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "WithStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isAssignmentPattern$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "AssignmentPattern") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isArrayPattern(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ArrayPattern") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isArrowFunctionExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ArrowFunctionExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isClassBody$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ClassBody") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isClassExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ClassExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isClassDeclaration$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ClassDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExportAllDeclaration$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ExportAllDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExportDefaultDeclaration$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ExportDefaultDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExportNamedDeclaration$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ExportNamedDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExportSpecifier(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ExportSpecifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isForOfStatement$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ForOfStatement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isImportDeclaration$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ImportDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isImportDefaultSpecifier$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ImportDefaultSpecifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isImportNamespaceSpecifier$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ImportNamespaceSpecifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isImportSpecifier$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ImportSpecifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isMetaProperty(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "MetaProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isClassMethod$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ClassMethod") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectPattern$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectPattern") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isSpreadElement$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "SpreadElement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isSuper$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "Super") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTaggedTemplateExpression$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TaggedTemplateExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTemplateElement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TemplateElement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTemplateLiteral$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TemplateLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isYieldExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "YieldExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isAwaitExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "AwaitExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isImport(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "Import") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBigIntLiteral(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "BigIntLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExportNamespaceSpecifier$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ExportNamespaceSpecifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isOptionalMemberExpression$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "OptionalMemberExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isOptionalCallExpression$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "OptionalCallExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isClassProperty(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ClassProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isClassPrivateProperty(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ClassPrivateProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isClassPrivateMethod(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ClassPrivateMethod") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isPrivateName$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "PrivateName") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isAnyTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "AnyTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isArrayTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ArrayTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBooleanTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "BooleanTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBooleanLiteralTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "BooleanLiteralTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isNullLiteralTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "NullLiteralTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isClassImplements(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ClassImplements") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareClass(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareClass") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareFunction(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareFunction") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareInterface(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareInterface") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareModule(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareModule") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareModuleExports(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareModuleExports") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareTypeAlias(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareTypeAlias") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareOpaqueType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareOpaqueType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareVariable(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareVariable") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareExportDeclaration$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareExportDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclareExportAllDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclareExportAllDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclaredPredicate(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DeclaredPredicate") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExistsTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ExistsTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFunctionTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "FunctionTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFunctionTypeParam(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "FunctionTypeParam") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isGenericTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "GenericTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isInferredPredicate(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "InferredPredicate") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isInterfaceExtends(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "InterfaceExtends") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isInterfaceDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "InterfaceDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isInterfaceTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "InterfaceTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isIntersectionTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "IntersectionTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isMixedTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "MixedTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEmptyTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EmptyTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isNullableTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "NullableTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isNumberLiteralTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "NumberLiteralTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isNumberTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "NumberTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectTypeInternalSlot(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectTypeInternalSlot") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectTypeCallProperty(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectTypeCallProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectTypeIndexer(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectTypeIndexer") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectTypeProperty(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectTypeProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectTypeSpreadProperty(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ObjectTypeSpreadProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isOpaqueType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "OpaqueType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isQualifiedTypeIdentifier(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "QualifiedTypeIdentifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isStringLiteralTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "StringLiteralTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isStringTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "StringTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isSymbolTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "SymbolTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isThisTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ThisTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTupleTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TupleTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTypeofTypeAnnotation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TypeofTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTypeAlias(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TypeAlias") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTypeAnnotation$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTypeCastExpression$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TypeCastExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTypeParameter(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TypeParameter") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTypeParameterDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TypeParameterDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTypeParameterInstantiation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TypeParameterInstantiation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isUnionTypeAnnotation$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "UnionTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isVariance(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "Variance") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isVoidTypeAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "VoidTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EnumDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumBooleanBody(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EnumBooleanBody") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumNumberBody(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EnumNumberBody") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumStringBody(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EnumStringBody") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumSymbolBody(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EnumSymbolBody") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumBooleanMember(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EnumBooleanMember") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumNumberMember(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EnumNumberMember") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumStringMember(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EnumStringMember") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumDefaultedMember(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "EnumDefaultedMember") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isIndexedAccessType$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "IndexedAccessType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isOptionalIndexedAccessType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "OptionalIndexedAccessType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXAttribute(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXAttribute") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXClosingElement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXClosingElement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXElement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXElement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXEmptyExpression(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXEmptyExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXExpressionContainer$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXExpressionContainer") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXSpreadChild(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXSpreadChild") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXIdentifier$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXIdentifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXMemberExpression$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXMemberExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXNamespacedName$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXNamespacedName") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXOpeningElement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXOpeningElement") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXSpreadAttribute$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXSpreadAttribute") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXText(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXText") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXFragment(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXFragment") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXOpeningFragment(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXOpeningFragment") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSXClosingFragment(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "JSXClosingFragment") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isNoop(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "Noop") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isPlaceholder$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "Placeholder") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isV8IntrinsicIdentifier(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "V8IntrinsicIdentifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isArgumentPlaceholder(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ArgumentPlaceholder") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBindExpression(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "BindExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isImportAttribute(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ImportAttribute") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDecorator(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "Decorator") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDoExpression(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DoExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExportDefaultSpecifier$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ExportDefaultSpecifier") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isRecordExpression(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "RecordExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTupleExpression(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TupleExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDecimalLiteral(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "DecimalLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isStaticBlock(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "StaticBlock") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isModuleExpression(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "ModuleExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTopicReference(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TopicReference") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isPipelineTopicExpression(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "PipelineTopicExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isPipelineBareFunction(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "PipelineBareFunction") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isPipelinePrimaryTopicReference(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "PipelinePrimaryTopicReference") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSParameterProperty(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSParameterProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSDeclareFunction(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSDeclareFunction") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSDeclareMethod(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSDeclareMethod") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSQualifiedName(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSQualifiedName") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSCallSignatureDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSCallSignatureDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSConstructSignatureDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSConstructSignatureDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSPropertySignature(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSPropertySignature") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSMethodSignature(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSMethodSignature") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSIndexSignature(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSIndexSignature") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSAnyKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSAnyKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSBooleanKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSBooleanKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSBigIntKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSBigIntKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSIntrinsicKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSIntrinsicKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSNeverKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSNeverKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSNullKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSNullKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSNumberKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSNumberKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSObjectKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSObjectKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSStringKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSStringKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSSymbolKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSSymbolKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSUndefinedKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSUndefinedKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSUnknownKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSUnknownKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSVoidKeyword(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSVoidKeyword") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSThisType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSThisType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSFunctionType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSFunctionType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSConstructorType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSConstructorType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeReference(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeReference") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypePredicate(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypePredicate") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeQuery(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeQuery") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeLiteral(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSArrayType$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSArrayType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTupleType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTupleType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSOptionalType$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSOptionalType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSRestType$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSRestType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSNamedTupleMember(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSNamedTupleMember") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSUnionType$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSUnionType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSIntersectionType$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSIntersectionType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSConditionalType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSConditionalType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSInferType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSInferType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSParenthesizedType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSParenthesizedType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeOperator(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeOperator") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSIndexedAccessType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSIndexedAccessType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSMappedType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSMappedType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSLiteralType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSLiteralType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSExpressionWithTypeArguments(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSExpressionWithTypeArguments") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSInterfaceDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSInterfaceDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSInterfaceBody(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSInterfaceBody") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeAliasDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeAliasDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSAsExpression$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSAsExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeAssertion$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeAssertion") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSEnumDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSEnumDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSEnumMember(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSEnumMember") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSModuleDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSModuleDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSModuleBlock(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSModuleBlock") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSImportType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSImportType") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSImportEqualsDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSImportEqualsDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSExternalModuleReference(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSExternalModuleReference") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSNonNullExpression$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSNonNullExpression") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSExportAssignment(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSExportAssignment") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSNamespaceExportDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSNamespaceExportDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeAnnotation$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeAnnotation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeParameterInstantiation(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeParameterInstantiation") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeParameterDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeParameterDeclaration") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeParameter(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "TSTypeParameter") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExpression$4(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ArrayExpression" === nodeType || "AssignmentExpression" === nodeType || "BinaryExpression" === nodeType || "CallExpression" === nodeType || "ConditionalExpression" === nodeType || "FunctionExpression" === nodeType || "Identifier" === nodeType || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "LogicalExpression" === nodeType || "MemberExpression" === nodeType || "NewExpression" === nodeType || "ObjectExpression" === nodeType || "SequenceExpression" === nodeType || "ParenthesizedExpression" === nodeType || "ThisExpression" === nodeType || "UnaryExpression" === nodeType || "UpdateExpression" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassExpression" === nodeType || "MetaProperty" === nodeType || "Super" === nodeType || "TaggedTemplateExpression" === nodeType || "TemplateLiteral" === nodeType || "YieldExpression" === nodeType || "AwaitExpression" === nodeType || "Import" === nodeType || "BigIntLiteral" === nodeType || "OptionalMemberExpression" === nodeType || "OptionalCallExpression" === nodeType || "TypeCastExpression" === nodeType || "JSXElement" === nodeType || "JSXFragment" === nodeType || "BindExpression" === nodeType || "DoExpression" === nodeType || "RecordExpression" === nodeType || "TupleExpression" === nodeType || "DecimalLiteral" === nodeType || "ModuleExpression" === nodeType || "TopicReference" === nodeType || "PipelineTopicExpression" === nodeType || "PipelineBareFunction" === nodeType || "PipelinePrimaryTopicReference" === nodeType || "TSAsExpression" === nodeType || "TSTypeAssertion" === nodeType || "TSNonNullExpression" === nodeType || nodeType === "Placeholder" && ("Expression" === node.expectedNode || "Identifier" === node.expectedNode || "StringLiteral" === node.expectedNode)) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBinary$3(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("BinaryExpression" === nodeType || "LogicalExpression" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isScopable(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("BlockStatement" === nodeType || "CatchClause" === nodeType || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "Program" === nodeType || "ObjectMethod" === nodeType || "SwitchStatement" === nodeType || "WhileStatement" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassExpression" === nodeType || "ClassDeclaration" === nodeType || "ForOfStatement" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType || "StaticBlock" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBlockParent(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("BlockStatement" === nodeType || "CatchClause" === nodeType || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "Program" === nodeType || "ObjectMethod" === nodeType || "SwitchStatement" === nodeType || "WhileStatement" === nodeType || "ArrowFunctionExpression" === nodeType || "ForOfStatement" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType || "StaticBlock" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isBlock(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("BlockStatement" === nodeType || "Program" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isStatement$7(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("BlockStatement" === nodeType || "BreakStatement" === nodeType || "ContinueStatement" === nodeType || "DebuggerStatement" === nodeType || "DoWhileStatement" === nodeType || "EmptyStatement" === nodeType || "ExpressionStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "IfStatement" === nodeType || "LabeledStatement" === nodeType || "ReturnStatement" === nodeType || "SwitchStatement" === nodeType || "ThrowStatement" === nodeType || "TryStatement" === nodeType || "VariableDeclaration" === nodeType || "WhileStatement" === nodeType || "WithStatement" === nodeType || "ClassDeclaration" === nodeType || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ForOfStatement" === nodeType || "ImportDeclaration" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType || "EnumDeclaration" === nodeType || "TSDeclareFunction" === nodeType || "TSInterfaceDeclaration" === nodeType || "TSTypeAliasDeclaration" === nodeType || "TSEnumDeclaration" === nodeType || "TSModuleDeclaration" === nodeType || "TSImportEqualsDeclaration" === nodeType || "TSExportAssignment" === nodeType || "TSNamespaceExportDeclaration" === nodeType || nodeType === "Placeholder" && ("Statement" === node.expectedNode || "Declaration" === node.expectedNode || "BlockStatement" === node.expectedNode)) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTerminatorless(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("BreakStatement" === nodeType || "ContinueStatement" === nodeType || "ReturnStatement" === nodeType || "ThrowStatement" === nodeType || "YieldExpression" === nodeType || "AwaitExpression" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isCompletionStatement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("BreakStatement" === nodeType || "ContinueStatement" === nodeType || "ReturnStatement" === nodeType || "ThrowStatement" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isConditional$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ConditionalExpression" === nodeType || "IfStatement" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isLoop$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "WhileStatement" === nodeType || "ForOfStatement" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isWhile(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("DoWhileStatement" === nodeType || "WhileStatement" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExpressionWrapper(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ExpressionStatement" === nodeType || "ParenthesizedExpression" === nodeType || "TypeCastExpression" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFor$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ForInStatement" === nodeType || "ForStatement" === nodeType || "ForOfStatement" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isForXStatement$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ForInStatement" === nodeType || "ForOfStatement" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFunction$4(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "ObjectMethod" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFunctionParent(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "ObjectMethod" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isPureish$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "ArrowFunctionExpression" === nodeType || "BigIntLiteral" === nodeType || "DecimalLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isDeclaration$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("FunctionDeclaration" === nodeType || "VariableDeclaration" === nodeType || "ClassDeclaration" === nodeType || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ImportDeclaration" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType || "EnumDeclaration" === nodeType || "TSDeclareFunction" === nodeType || "TSInterfaceDeclaration" === nodeType || "TSTypeAliasDeclaration" === nodeType || "TSEnumDeclaration" === nodeType || "TSModuleDeclaration" === nodeType || nodeType === "Placeholder" && "Declaration" === node.expectedNode) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isPatternLike(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("Identifier" === nodeType || "RestElement" === nodeType || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || nodeType === "Placeholder" && ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode)) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isLVal(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("Identifier" === nodeType || "MemberExpression" === nodeType || "RestElement" === nodeType || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || "TSParameterProperty" === nodeType || nodeType === "Placeholder" && ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode)) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSEntityName(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("Identifier" === nodeType || "TSQualifiedName" === nodeType || nodeType === "Placeholder" && "Identifier" === node.expectedNode) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isLiteral$7(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "TemplateLiteral" === nodeType || "BigIntLiteral" === nodeType || "DecimalLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isUserWhitespacable(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ObjectMethod" === nodeType || "ObjectProperty" === nodeType || "ObjectTypeInternalSlot" === nodeType || "ObjectTypeCallProperty" === nodeType || "ObjectTypeIndexer" === nodeType || "ObjectTypeProperty" === nodeType || "ObjectTypeSpreadProperty" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isMethod$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ObjectMethod" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isObjectMember(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ObjectMethod" === nodeType || "ObjectProperty" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isProperty$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ObjectProperty" === nodeType || "ClassProperty" === nodeType || "ClassPrivateProperty" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isUnaryLike$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("UnaryExpression" === nodeType || "SpreadElement" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isPattern(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || nodeType === "Placeholder" && "Pattern" === node.expectedNode) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isClass$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ClassExpression" === nodeType || "ClassDeclaration" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isModuleDeclaration$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ImportDeclaration" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isExportDeclaration$2(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isModuleSpecifier$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ExportSpecifier" === nodeType || "ImportDefaultSpecifier" === nodeType || "ImportNamespaceSpecifier" === nodeType || "ImportSpecifier" === nodeType || "ExportNamespaceSpecifier" === nodeType || "ExportDefaultSpecifier" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isPrivate(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("ClassPrivateProperty" === nodeType || "ClassPrivateMethod" === nodeType || "PrivateName" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFlow$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("AnyTypeAnnotation" === nodeType || "ArrayTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "BooleanLiteralTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "ClassImplements" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "DeclaredPredicate" === nodeType || "ExistsTypeAnnotation" === nodeType || "FunctionTypeAnnotation" === nodeType || "FunctionTypeParam" === nodeType || "GenericTypeAnnotation" === nodeType || "InferredPredicate" === nodeType || "InterfaceExtends" === nodeType || "InterfaceDeclaration" === nodeType || "InterfaceTypeAnnotation" === nodeType || "IntersectionTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NullableTypeAnnotation" === nodeType || "NumberLiteralTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "ObjectTypeAnnotation" === nodeType || "ObjectTypeInternalSlot" === nodeType || "ObjectTypeCallProperty" === nodeType || "ObjectTypeIndexer" === nodeType || "ObjectTypeProperty" === nodeType || "ObjectTypeSpreadProperty" === nodeType || "OpaqueType" === nodeType || "QualifiedTypeIdentifier" === nodeType || "StringLiteralTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "TupleTypeAnnotation" === nodeType || "TypeofTypeAnnotation" === nodeType || "TypeAlias" === nodeType || "TypeAnnotation" === nodeType || "TypeCastExpression" === nodeType || "TypeParameter" === nodeType || "TypeParameterDeclaration" === nodeType || "TypeParameterInstantiation" === nodeType || "UnionTypeAnnotation" === nodeType || "Variance" === nodeType || "VoidTypeAnnotation" === nodeType || "IndexedAccessType" === nodeType || "OptionalIndexedAccessType" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFlowType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("AnyTypeAnnotation" === nodeType || "ArrayTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "BooleanLiteralTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "ExistsTypeAnnotation" === nodeType || "FunctionTypeAnnotation" === nodeType || "GenericTypeAnnotation" === nodeType || "InterfaceTypeAnnotation" === nodeType || "IntersectionTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NullableTypeAnnotation" === nodeType || "NumberLiteralTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "ObjectTypeAnnotation" === nodeType || "StringLiteralTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "TupleTypeAnnotation" === nodeType || "TypeofTypeAnnotation" === nodeType || "UnionTypeAnnotation" === nodeType || "VoidTypeAnnotation" === nodeType || "IndexedAccessType" === nodeType || "OptionalIndexedAccessType" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFlowBaseAnnotation$1(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("AnyTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "VoidTypeAnnotation" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFlowDeclaration(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isFlowPredicate(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("DeclaredPredicate" === nodeType || "InferredPredicate" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumBody(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("EnumBooleanBody" === nodeType || "EnumNumberBody" === nodeType || "EnumStringBody" === nodeType || "EnumSymbolBody" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isEnumMember(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("EnumBooleanMember" === nodeType || "EnumNumberMember" === nodeType || "EnumStringMember" === nodeType || "EnumDefaultedMember" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isJSX(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("JSXAttribute" === nodeType || "JSXClosingElement" === nodeType || "JSXElement" === nodeType || "JSXEmptyExpression" === nodeType || "JSXExpressionContainer" === nodeType || "JSXSpreadChild" === nodeType || "JSXIdentifier" === nodeType || "JSXMemberExpression" === nodeType || "JSXNamespacedName" === nodeType || "JSXOpeningElement" === nodeType || "JSXSpreadAttribute" === nodeType || "JSXText" === nodeType || "JSXFragment" === nodeType || "JSXOpeningFragment" === nodeType || "JSXClosingFragment" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSTypeElement(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("TSCallSignatureDeclaration" === nodeType || "TSConstructSignatureDeclaration" === nodeType || "TSPropertySignature" === nodeType || "TSMethodSignature" === nodeType || "TSIndexSignature" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("TSAnyKeyword" === nodeType || "TSBooleanKeyword" === nodeType || "TSBigIntKeyword" === nodeType || "TSIntrinsicKeyword" === nodeType || "TSNeverKeyword" === nodeType || "TSNullKeyword" === nodeType || "TSNumberKeyword" === nodeType || "TSObjectKeyword" === nodeType || "TSStringKeyword" === nodeType || "TSSymbolKeyword" === nodeType || "TSUndefinedKeyword" === nodeType || "TSUnknownKeyword" === nodeType || "TSVoidKeyword" === nodeType || "TSThisType" === nodeType || "TSFunctionType" === nodeType || "TSConstructorType" === nodeType || "TSTypeReference" === nodeType || "TSTypePredicate" === nodeType || "TSTypeQuery" === nodeType || "TSTypeLiteral" === nodeType || "TSArrayType" === nodeType || "TSTupleType" === nodeType || "TSOptionalType" === nodeType || "TSRestType" === nodeType || "TSUnionType" === nodeType || "TSIntersectionType" === nodeType || "TSConditionalType" === nodeType || "TSInferType" === nodeType || "TSParenthesizedType" === nodeType || "TSTypeOperator" === nodeType || "TSIndexedAccessType" === nodeType || "TSMappedType" === nodeType || "TSLiteralType" === nodeType || "TSExpressionWithTypeArguments" === nodeType || "TSImportType" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isTSBaseType(node, opts) {
    if (!node) return false;
    var nodeType = node.type;

    if ("TSAnyKeyword" === nodeType || "TSBooleanKeyword" === nodeType || "TSBigIntKeyword" === nodeType || "TSIntrinsicKeyword" === nodeType || "TSNeverKeyword" === nodeType || "TSNullKeyword" === nodeType || "TSNumberKeyword" === nodeType || "TSObjectKeyword" === nodeType || "TSStringKeyword" === nodeType || "TSSymbolKeyword" === nodeType || "TSUndefinedKeyword" === nodeType || "TSUnknownKeyword" === nodeType || "TSVoidKeyword" === nodeType || "TSThisType" === nodeType || "TSLiteralType" === nodeType) {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isNumberLiteral(node, opts) {
    console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "NumberLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isRegexLiteral(node, opts) {
    console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "RegexLiteral") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isRestProperty(node, opts) {
    console.trace("The node type RestProperty has been renamed to RestElement");
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "RestProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }
  function isSpreadProperty(node, opts) {
    console.trace("The node type SpreadProperty has been renamed to SpreadElement");
    if (!node) return false;
    var nodeType = node.type;

    if (nodeType === "SpreadProperty") {
      if (typeof opts === "undefined") {
        return true;
      } else {
        return shallowEqual(node, opts);
      }
    }

    return false;
  }

  function matchesPattern$2(member, match, allowPartial) {
    if (!isMemberExpression$8(member)) return false;
    var parts = Array.isArray(match) ? match : match.split(".");
    var nodes = [];
    var node;

    for (node = member; isMemberExpression$8(node); node = node.object) {
      nodes.push(node.property);
    }

    nodes.push(node);
    if (nodes.length < parts.length) return false;
    if (!allowPartial && nodes.length > parts.length) return false;

    for (var i = 0, j = nodes.length - 1; i < parts.length; i++, j--) {
      var _node = nodes[j];
      var value = void 0;

      if (isIdentifier$g(_node)) {
        value = _node.name;
      } else if (isStringLiteral$7(_node)) {
        value = _node.value;
      } else if (isThisExpression$2(_node)) {
        value = "this";
      } else {
        return false;
      }

      if (parts[i] !== value) return false;
    }

    return true;
  }

  function buildMatchMemberExpression$1(match, allowPartial) {
    var parts = match.split(".");
    return function (member) {
      return matchesPattern$2(member, parts, allowPartial);
    };
  }

  var isReactComponent = buildMatchMemberExpression$1("React.Component");

  function isCompatTag$1(tagName) {
    return !!tagName && /^[a-z]/.test(tagName);
  }

  var fastProto = null;

  function FastObject(o) {
    if (fastProto !== null && typeof fastProto.property) {
      var result = fastProto;
      fastProto = FastObject.prototype = null;
      return result;
    }

    fastProto = FastObject.prototype = o == null ? Object.create(null) : o;
    return new FastObject();
  }

  FastObject();

  var toFastProperties = function toFastproperties(o) {
    return FastObject(o);
  };

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getAugmentedNamespace(n) {
  	if (n.__esModule) return n;
  	var a = Object.defineProperty({}, '__esModule', {value: true});
  	Object.keys(n).forEach(function (k) {
  		var d = Object.getOwnPropertyDescriptor(n, k);
  		Object.defineProperty(a, k, d.get ? d : {
  			enumerable: true,
  			get: function () {
  				return n[k];
  			}
  		});
  	});
  	return a;
  }

  function createCommonjsModule(fn, basedir, module) {
  	return module = {
  		path: basedir,
  		exports: {},
  		require: function (path, base) {
  			return commonjsRequire(path, (base === undefined || base === null) ? module.path : base);
  		}
  	}, fn(module, module.exports), module.exports;
  }

  const DYNAMIC_REQUIRE_LOADERS = Object.create(null);
  const DYNAMIC_REQUIRE_CACHE = Object.create(null);
  const DEFAULT_PARENT_MODULE = {
  	id: '<' + 'rollup>', exports: {}, parent: undefined, filename: null, loaded: false, children: [], paths: []
  };
  const CHECKED_EXTENSIONS = ['', '.js', '.json'];

  function normalize$2 (path) {
  	path = path.replace(/\\/g, '/');
  	const parts = path.split('/');
  	const slashed = parts[0] === '';
  	for (let i = 1; i < parts.length; i++) {
  		if (parts[i] === '.' || parts[i] === '') {
  			parts.splice(i--, 1);
  		}
  	}
  	for (let i = 1; i < parts.length; i++) {
  		if (parts[i] !== '..') continue;
  		if (i > 0 && parts[i - 1] !== '..' && parts[i - 1] !== '.') {
  			parts.splice(--i, 2);
  			i--;
  		}
  	}
  	path = parts.join('/');
  	if (slashed && path[0] !== '/')
  	  path = '/' + path;
  	else if (path.length === 0)
  	  path = '.';
  	return path;
  }

  function join$1 () {
  	if (arguments.length === 0)
  	  return '.';
  	let joined;
  	for (let i = 0; i < arguments.length; ++i) {
  	  let arg = arguments[i];
  	  if (arg.length > 0) {
  		if (joined === undefined)
  		  joined = arg;
  		else
  		  joined += '/' + arg;
  	  }
  	}
  	if (joined === undefined)
  	  return '.';

  	return joined;
  }

  function isPossibleNodeModulesPath (modulePath) {
  	let c0 = modulePath[0];
  	if (c0 === '/' || c0 === '\\') return false;
  	let c1 = modulePath[1], c2 = modulePath[2];
  	if ((c0 === '.' && (!c1 || c1 === '/' || c1 === '\\')) ||
  		(c0 === '.' && c1 === '.' && (!c2 || c2 === '/' || c2 === '\\'))) return false;
  	if (c1 === ':' && (c2 === '/' || c2 === '\\'))
  		return false;
  	return true;
  }

  function dirname$1 (path) {
    if (path.length === 0)
      return '.';

    let i = path.length - 1;
    while (i > 0) {
      const c = path.charCodeAt(i);
      if ((c === 47 || c === 92) && i !== path.length - 1)
        break;
      i--;
    }

    if (i > 0)
      return path.substr(0, i);

    if (path.chartCodeAt(0) === 47 || path.chartCodeAt(0) === 92)
      return path.charAt(0);

    return '.';
  }

  function commonjsResolveImpl (path, originalModuleDir, testCache) {
  	const shouldTryNodeModules = isPossibleNodeModulesPath(path);
  	path = normalize$2(path);
  	let relPath;
  	if (path[0] === '/') {
  		originalModuleDir = '/';
  	}
  	while (true) {
  		if (!shouldTryNodeModules) {
  			relPath = originalModuleDir ? normalize$2(originalModuleDir + '/' + path) : path;
  		} else if (originalModuleDir) {
  			relPath = normalize$2(originalModuleDir + '/node_modules/' + path);
  		} else {
  			relPath = normalize$2(join$1('node_modules', path));
  		}

  		if (relPath.endsWith('/..')) {
  			break; // Travelled too far up, avoid infinite loop
  		}

  		for (let extensionIndex = 0; extensionIndex < CHECKED_EXTENSIONS.length; extensionIndex++) {
  			const resolvedPath = relPath + CHECKED_EXTENSIONS[extensionIndex];
  			if (DYNAMIC_REQUIRE_CACHE[resolvedPath]) {
  				return resolvedPath;
  			}			if (DYNAMIC_REQUIRE_LOADERS[resolvedPath]) {
  				return resolvedPath;
  			}		}
  		if (!shouldTryNodeModules) break;
  		const nextDir = normalize$2(originalModuleDir + '/..');
  		if (nextDir === originalModuleDir) break;
  		originalModuleDir = nextDir;
  	}
  	return null;
  }

  function commonjsResolve (path, originalModuleDir) {
  	const resolvedPath = commonjsResolveImpl(path, originalModuleDir);
  	if (resolvedPath !== null) {
  		return resolvedPath;
  	}
  	return require.resolve(path);
  }

  function commonjsRequire (path, originalModuleDir) {
  	const resolvedPath = commonjsResolveImpl(path, originalModuleDir);
  	if (resolvedPath !== null) {
      let cachedModule = DYNAMIC_REQUIRE_CACHE[resolvedPath];
      if (cachedModule) return cachedModule.exports;
      const loader = DYNAMIC_REQUIRE_LOADERS[resolvedPath];
      if (loader) {
        DYNAMIC_REQUIRE_CACHE[resolvedPath] = cachedModule = {
          id: resolvedPath,
          filename: resolvedPath,
          path: dirname$1(resolvedPath),
          exports: {},
          parent: DEFAULT_PARENT_MODULE,
          loaded: false,
          children: [],
          paths: [],
          require: function (path, base) {
            return commonjsRequire(path, (base === undefined || base === null) ? cachedModule.path : base);
          }
        };
        try {
          loader.call(commonjsGlobal, cachedModule, cachedModule.exports);
        } catch (error) {
          delete DYNAMIC_REQUIRE_CACHE[resolvedPath];
          throw error;
        }
        cachedModule.loaded = true;
        return cachedModule.exports;
      }	}
  	return require(path);
  }

  commonjsRequire.cache = DYNAMIC_REQUIRE_CACHE;
  commonjsRequire.resolve = commonjsResolve;

  var browser$6 = createCommonjsModule(function (module) {
    var process = module.exports = {};
    var cachedSetTimeout;
    var cachedClearTimeout;

    function defaultSetTimout() {
      throw new Error('setTimeout has not been defined');
    }

    function defaultClearTimeout() {
      throw new Error('clearTimeout has not been defined');
    }

    (function () {
      try {
        if (typeof setTimeout === 'function') {
          cachedSetTimeout = setTimeout;
        } else {
          cachedSetTimeout = defaultSetTimout;
        }
      } catch (e) {
        cachedSetTimeout = defaultSetTimout;
      }

      try {
        if (typeof clearTimeout === 'function') {
          cachedClearTimeout = clearTimeout;
        } else {
          cachedClearTimeout = defaultClearTimeout;
        }
      } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
      }
    })();

    function runTimeout(fun) {
      if (cachedSetTimeout === setTimeout) {
        return setTimeout(fun, 0);
      }

      if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
      }

      try {
        return cachedSetTimeout(fun, 0);
      } catch (e) {
        try {
          return cachedSetTimeout.call(null, fun, 0);
        } catch (e) {
          return cachedSetTimeout.call(this, fun, 0);
        }
      }
    }

    function runClearTimeout(marker) {
      if (cachedClearTimeout === clearTimeout) {
        return clearTimeout(marker);
      }

      if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
      }

      try {
        return cachedClearTimeout(marker);
      } catch (e) {
        try {
          return cachedClearTimeout.call(null, marker);
        } catch (e) {
          return cachedClearTimeout.call(this, marker);
        }
      }
    }

    var queue = [];
    var draining = false;
    var currentQueue;
    var queueIndex = -1;

    function cleanUpNextTick() {
      if (!draining || !currentQueue) {
        return;
      }

      draining = false;

      if (currentQueue.length) {
        queue = currentQueue.concat(queue);
      } else {
        queueIndex = -1;
      }

      if (queue.length) {
        drainQueue();
      }
    }

    function drainQueue() {
      if (draining) {
        return;
      }

      var timeout = runTimeout(cleanUpNextTick);
      draining = true;
      var len = queue.length;

      while (len) {
        currentQueue = queue;
        queue = [];

        while (++queueIndex < len) {
          if (currentQueue) {
            currentQueue[queueIndex].run();
          }
        }

        queueIndex = -1;
        len = queue.length;
      }

      currentQueue = null;
      draining = false;
      runClearTimeout(timeout);
    }

    process.nextTick = function (fun) {
      var args = new Array(arguments.length - 1);

      if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
          args[i - 1] = arguments[i];
        }
      }

      queue.push(new Item(fun, args));

      if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
      }
    };

    function Item(fun, array) {
      this.fun = fun;
      this.array = array;
    }

    Item.prototype.run = function () {
      this.fun.apply(null, this.array);
    };

    process.title = 'browser';
    process.browser = true;
    process.env = {};
    process.argv = [];
    process.version = '';
    process.versions = {};

    function noop() {}

    process.on = noop;
    process.addListener = noop;
    process.once = noop;
    process.off = noop;
    process.removeListener = noop;
    process.removeAllListeners = noop;
    process.emit = noop;
    process.prependListener = noop;
    process.prependOnceListener = noop;

    process.listeners = function (name) {
      return [];
    };

    process.binding = function (name) {
      throw new Error('process.binding is not supported');
    };

    process.cwd = function () {
      return '/';
    };

    process.chdir = function (dir) {
      throw new Error('process.chdir is not supported');
    };

    process.umask = function () {
      return 0;
    };
  }, "/$$rollup_base$$/node_modules/process");

  function isType$2(nodeType, targetType) {
    if (nodeType === targetType) return true;
    if (ALIAS_KEYS[targetType]) return false;
    var aliases = FLIPPED_ALIAS_KEYS$3[targetType];

    if (aliases) {
      if (aliases[0] === nodeType) return true;

      for (var _iterator = _createForOfIteratorHelperLoose(aliases), _step; !(_step = _iterator()).done;) {
        var alias = _step.value;
        if (nodeType === alias) return true;
      }
    }

    return false;
  }

  function isPlaceholderType(placeholderType, targetType) {
    if (placeholderType === targetType) return true;
    var aliases = PLACEHOLDERS_ALIAS[placeholderType];

    if (aliases) {
      for (var _iterator = _createForOfIteratorHelperLoose(aliases), _step; !(_step = _iterator()).done;) {
        var alias = _step.value;
        if (targetType === alias) return true;
      }
    }

    return false;
  }

  function is$1(type, node, opts) {
    if (!node) return false;
    var matches = isType$2(node.type, type);

    if (!matches) {
      if (!opts && node.type === "Placeholder" && type in FLIPPED_ALIAS_KEYS$3) {
        return isPlaceholderType(node.expectedNode, type);
      }

      return false;
    }

    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  var nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u08A0-\u08B4\u08B6-\u08C7\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\u9FFC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7BF\uA7C2-\uA7CA\uA7F5-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
  var nonASCIIidentifierChars = "\u200C\u200D\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D3-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECD\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF\u1AC0\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DF9\u1DFB-\u1DFF\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F";
  var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
  var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
  nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
  var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 157, 310, 10, 21, 11, 7, 153, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 107, 20, 28, 22, 13, 52, 76, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 85, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 230, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 35, 56, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 190, 0, 80, 921, 103, 110, 18, 195, 2749, 1070, 4050, 582, 8634, 568, 8, 30, 114, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8952, 286, 50, 2, 18, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 2357, 44, 11, 6, 17, 0, 370, 43, 1301, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42717, 35, 4148, 12, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938];
  var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 154, 10, 176, 2, 54, 14, 32, 9, 16, 3, 46, 10, 54, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 161, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 19306, 9, 135, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 5319, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 262, 6, 10, 9, 419, 13, 1495, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];

  function isInAstralSet(code, set) {
    var pos = 0x10000;

    for (var i = 0, length = set.length; i < length; i += 2) {
      pos += set[i];
      if (pos > code) return false;
      pos += set[i + 1];
      if (pos >= code) return true;
    }

    return false;
  }

  function isIdentifierStart(code) {
    if (code < 65) return code === 36;
    if (code <= 90) return true;
    if (code < 97) return code === 95;
    if (code <= 122) return true;

    if (code <= 0xffff) {
      return code >= 0xaa && nonASCIIidentifierStart.test(String.fromCharCode(code));
    }

    return isInAstralSet(code, astralIdentifierStartCodes);
  }
  function isIdentifierChar(code) {
    if (code < 48) return code === 36;
    if (code < 58) return true;
    if (code < 65) return false;
    if (code <= 90) return true;
    if (code < 97) return code === 95;
    if (code <= 122) return true;

    if (code <= 0xffff) {
      return code >= 0xaa && nonASCIIidentifier.test(String.fromCharCode(code));
    }

    return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
  }
  function isIdentifierName(name) {
    var isFirst = true;

    for (var i = 0; i < name.length; i++) {
      var cp = name.charCodeAt(i);

      if ((cp & 0xfc00) === 0xd800 && i + 1 < name.length) {
        var trail = name.charCodeAt(++i);

        if ((trail & 0xfc00) === 0xdc00) {
          cp = 0x10000 + ((cp & 0x3ff) << 10) + (trail & 0x3ff);
        }
      }

      if (isFirst) {
        isFirst = false;

        if (!isIdentifierStart(cp)) {
          return false;
        }
      } else if (!isIdentifierChar(cp)) {
        return false;
      }
    }

    return !isFirst;
  }

  var reservedWords = {
    keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
    strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
    strictBind: ["eval", "arguments"]
  };
  var keywords$1 = new Set(reservedWords.keyword);
  var reservedWordsStrictSet = new Set(reservedWords.strict);
  var reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
  function isReservedWord(word, inModule) {
    return inModule && word === "await" || word === "enum";
  }
  function isStrictReservedWord(word, inModule) {
    return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
  }
  function isStrictBindOnlyReservedWord(word) {
    return reservedWordsStrictBindSet.has(word);
  }
  function isStrictBindReservedWord(word, inModule) {
    return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
  }
  function isKeyword(word) {
    return keywords$1.has(word);
  }

  function isValidIdentifier$1(name, reserved) {
    if (reserved === void 0) {
      reserved = true;
    }

    if (typeof name !== "string") return false;

    if (reserved) {
      if (isKeyword(name) || isStrictReservedWord(name, true)) {
        return false;
      }
    }

    return isIdentifierName(name);
  }

  var STATEMENT_OR_BLOCK_KEYS$1 = ["consequent", "body", "alternate"];
  var FLATTENABLE_KEYS = ["body", "expressions"];
  var FOR_INIT_KEYS = ["left", "init"];
  var COMMENT_KEYS = ["leadingComments", "trailingComments", "innerComments"];
  var LOGICAL_OPERATORS$2 = ["||", "&&", "??"];
  var UPDATE_OPERATORS = ["++", "--"];
  var BOOLEAN_NUMBER_BINARY_OPERATORS$1 = [">", "<", ">=", "<="];
  var EQUALITY_BINARY_OPERATORS = ["==", "===", "!=", "!=="];
  var COMPARISON_BINARY_OPERATORS = [].concat(EQUALITY_BINARY_OPERATORS, ["in", "instanceof"]);
  var BOOLEAN_BINARY_OPERATORS$1 = [].concat(_toConsumableArray(COMPARISON_BINARY_OPERATORS), BOOLEAN_NUMBER_BINARY_OPERATORS$1);
  var NUMBER_BINARY_OPERATORS$1 = ["-", "/", "%", "*", "**", "&", "|", ">>", ">>>", "<<", "^"];
  var BINARY_OPERATORS = ["+"].concat(NUMBER_BINARY_OPERATORS$1, _toConsumableArray(BOOLEAN_BINARY_OPERATORS$1));
  var ASSIGNMENT_OPERATORS = ["=", "+="].concat(_toConsumableArray(NUMBER_BINARY_OPERATORS$1.map(function (op) {
    return op + "=";
  })), _toConsumableArray(LOGICAL_OPERATORS$2.map(function (op) {
    return op + "=";
  })));
  var BOOLEAN_UNARY_OPERATORS$1 = ["delete", "!"];
  var NUMBER_UNARY_OPERATORS$1 = ["+", "-", "~"];
  var STRING_UNARY_OPERATORS$1 = ["typeof"];
  var UNARY_OPERATORS = ["void", "throw"].concat(BOOLEAN_UNARY_OPERATORS$1, NUMBER_UNARY_OPERATORS$1, STRING_UNARY_OPERATORS$1);
  var INHERIT_KEYS = {
    optional: ["typeAnnotation", "typeParameters", "returnType"],
    force: ["start", "loc", "end"]
  };
  var BLOCK_SCOPED_SYMBOL = Symbol["for"]("var used to be block scoped");
  var NOT_LOCAL_BINDING$2 = Symbol["for"]("should not be considered a local binding");

  function validate$6(node, key, val) {
    if (!node) return;
    var fields = NODE_FIELDS[node.type];
    if (!fields) return;
    var field = fields[key];
    validateField(node, key, val, field);
    validateChild(node, key, val);
  }
  function validateField(node, key, val, field) {
    if (!(field != null && field.validate)) return;
    if (field.optional && val == null) return;
    field.validate(node, key, val);
  }
  function validateChild(node, key, val) {
    if (val == null) return;
    var validate = NODE_PARENT_VALIDATIONS[val.type];
    if (!validate) return;
    validate(node, key, val);
  }

  var VISITOR_KEYS$6 = {};
  var ALIAS_KEYS = {};
  var FLIPPED_ALIAS_KEYS$3 = {};
  var NODE_FIELDS = {};
  var BUILDER_KEYS = {};
  var DEPRECATED_KEYS$1 = {};
  var NODE_PARENT_VALIDATIONS = {};

  function getType$2(val) {
    if (Array.isArray(val)) {
      return "array";
    } else if (val === null) {
      return "null";
    } else {
      return typeof val;
    }
  }

  function validate$5(validate) {
    return {
      validate: validate
    };
  }
  function typeIs(typeName) {
    return typeof typeName === "string" ? assertNodeType(typeName) : assertNodeType.apply(void 0, _toConsumableArray(typeName));
  }
  function validateType(typeName) {
    return validate$5(typeIs(typeName));
  }
  function validateOptional(validate) {
    return {
      validate: validate,
      optional: true
    };
  }
  function validateOptionalType(typeName) {
    return {
      validate: typeIs(typeName),
      optional: true
    };
  }
  function arrayOf(elementType) {
    return chain$1(assertValueType("array"), assertEach(elementType));
  }
  function arrayOfType(typeName) {
    return arrayOf(typeIs(typeName));
  }
  function validateArrayOfType(typeName) {
    return validate$5(arrayOfType(typeName));
  }
  function assertEach(callback) {
    function validator(node, key, val) {
      if (!Array.isArray(val)) return;

      for (var i = 0; i < val.length; i++) {
        var subkey = key + "[" + i + "]";
        var v = val[i];
        callback(node, subkey, v);
        if (browser$6.env.BABEL_TYPES_8_BREAKING) validateChild(node, subkey, v);
      }
    }

    validator.each = callback;
    return validator;
  }
  function assertOneOf() {
    for (var _len = arguments.length, values = new Array(_len), _key = 0; _key < _len; _key++) {
      values[_key] = arguments[_key];
    }

    function validate(node, key, val) {
      if (values.indexOf(val) < 0) {
        throw new TypeError("Property " + key + " expected value to be one of " + JSON.stringify(values) + " but got " + JSON.stringify(val));
      }
    }

    validate.oneOf = values;
    return validate;
  }
  function assertNodeType() {
    for (var _len2 = arguments.length, types = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      types[_key2] = arguments[_key2];
    }

    function validate(node, key, val) {
      for (var _iterator = _createForOfIteratorHelperLoose(types), _step; !(_step = _iterator()).done;) {
        var type = _step.value;

        if (is$1(type, val)) {
          validateChild(node, key, val);
          return;
        }
      }

      throw new TypeError("Property " + key + " of " + node.type + " expected node to be of a type " + JSON.stringify(types) + " but instead got " + JSON.stringify(val == null ? void 0 : val.type));
    }

    validate.oneOfNodeTypes = types;
    return validate;
  }
  function assertNodeOrValueType() {
    for (var _len3 = arguments.length, types = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      types[_key3] = arguments[_key3];
    }

    function validate(node, key, val) {
      for (var _iterator2 = _createForOfIteratorHelperLoose(types), _step2; !(_step2 = _iterator2()).done;) {
        var type = _step2.value;

        if (getType$2(val) === type || is$1(type, val)) {
          validateChild(node, key, val);
          return;
        }
      }

      throw new TypeError("Property " + key + " of " + node.type + " expected node to be of a type " + JSON.stringify(types) + " but instead got " + JSON.stringify(val == null ? void 0 : val.type));
    }

    validate.oneOfNodeOrValueTypes = types;
    return validate;
  }
  function assertValueType(type) {
    function validate(node, key, val) {
      var valid = getType$2(val) === type;

      if (!valid) {
        throw new TypeError("Property " + key + " expected type of " + type + " but got " + getType$2(val));
      }
    }

    validate.type = type;
    return validate;
  }
  function assertShape(shape) {
    function validate(node, key, val) {
      var errors = [];

      for (var _i = 0, _Object$keys = Object.keys(shape); _i < _Object$keys.length; _i++) {
        var property = _Object$keys[_i];

        try {
          validateField(node, property, val[property], shape[property]);
        } catch (error) {
          if (error instanceof TypeError) {
            errors.push(error.message);
            continue;
          }

          throw error;
        }
      }

      if (errors.length) {
        throw new TypeError("Property " + key + " of " + node.type + " expected to have the following:\n" + errors.join("\n"));
      }
    }

    validate.shapeOf = shape;
    return validate;
  }
  function assertOptionalChainStart() {
    function validate(node) {
      var _current2;

      var current = node;

      while (node) {
        var _current = current,
            type = _current.type;

        if (type === "OptionalCallExpression") {
          if (current.optional) return;
          current = current.callee;
          continue;
        }

        if (type === "OptionalMemberExpression") {
          if (current.optional) return;
          current = current.object;
          continue;
        }

        break;
      }

      throw new TypeError("Non-optional " + node.type + " must chain from an optional OptionalMemberExpression or OptionalCallExpression. Found chain from " + ((_current2 = current) == null ? void 0 : _current2.type));
    }

    return validate;
  }
  function chain$1() {
    for (var _len4 = arguments.length, fns = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      fns[_key4] = arguments[_key4];
    }

    function validate() {
      for (var _iterator3 = _createForOfIteratorHelperLoose(fns), _step3; !(_step3 = _iterator3()).done;) {
        var fn = _step3.value;
        fn.apply(void 0, arguments);
      }
    }

    validate.chainOf = fns;

    if (fns.length >= 2 && "type" in fns[0] && fns[0].type === "array" && !("each" in fns[1])) {
      throw new Error("An assertValueType(\"array\") validator can only be followed by an assertEach(...) validator.");
    }

    return validate;
  }
  var validTypeOpts = ["aliases", "builder", "deprecatedAlias", "fields", "inherits", "visitor", "validate"];
  var validFieldKeys = ["default", "optional", "validate"];
  function defineType(type, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var inherits = opts.inherits && store[opts.inherits] || {};
    var fields = opts.fields;

    if (!fields) {
      fields = {};

      if (inherits.fields) {
        var keys = Object.getOwnPropertyNames(inherits.fields);

        for (var _iterator4 = _createForOfIteratorHelperLoose(keys), _step4; !(_step4 = _iterator4()).done;) {
          var _key5 = _step4.value;
          var field = inherits.fields[_key5];
          var def = field["default"];

          if (Array.isArray(def) ? def.length > 0 : def && typeof def === "object") {
            throw new Error("field defaults can only be primitives or empty arrays currently");
          }

          fields[_key5] = {
            "default": Array.isArray(def) ? [] : def,
            optional: field.optional,
            validate: field.validate
          };
        }
      }
    }

    var visitor = opts.visitor || inherits.visitor || [];
    var aliases = opts.aliases || inherits.aliases || [];
    var builder = opts.builder || inherits.builder || opts.visitor || [];

    for (var _i2 = 0, _Object$keys2 = Object.keys(opts); _i2 < _Object$keys2.length; _i2++) {
      var k = _Object$keys2[_i2];

      if (validTypeOpts.indexOf(k) === -1) {
        throw new Error("Unknown type option \"" + k + "\" on " + type);
      }
    }

    if (opts.deprecatedAlias) {
      DEPRECATED_KEYS$1[opts.deprecatedAlias] = type;
    }

    for (var _iterator5 = _createForOfIteratorHelperLoose(visitor.concat(builder)), _step5; !(_step5 = _iterator5()).done;) {
      var _key7 = _step5.value;
      fields[_key7] = fields[_key7] || {};
    }

    for (var _i3 = 0, _Object$keys3 = Object.keys(fields); _i3 < _Object$keys3.length; _i3++) {
      var _key6 = _Object$keys3[_i3];
      var _field = fields[_key6];

      if (_field["default"] !== undefined && builder.indexOf(_key6) === -1) {
        _field.optional = true;
      }

      if (_field["default"] === undefined) {
        _field["default"] = null;
      } else if (!_field.validate && _field["default"] != null) {
        _field.validate = assertValueType(getType$2(_field["default"]));
      }

      for (var _i4 = 0, _Object$keys4 = Object.keys(_field); _i4 < _Object$keys4.length; _i4++) {
        var _k = _Object$keys4[_i4];

        if (validFieldKeys.indexOf(_k) === -1) {
          throw new Error("Unknown field key \"" + _k + "\" on " + type + "." + _key6);
        }
      }
    }

    VISITOR_KEYS$6[type] = opts.visitor = visitor;
    BUILDER_KEYS[type] = opts.builder = builder;
    NODE_FIELDS[type] = opts.fields = fields;
    ALIAS_KEYS[type] = opts.aliases = aliases;
    aliases.forEach(function (alias) {
      FLIPPED_ALIAS_KEYS$3[alias] = FLIPPED_ALIAS_KEYS$3[alias] || [];
      FLIPPED_ALIAS_KEYS$3[alias].push(type);
    });

    if (opts.validate) {
      NODE_PARENT_VALIDATIONS[type] = opts.validate;
    }

    store[type] = opts;
  }
  var store = {};

  defineType("ArrayExpression", {
    fields: {
      elements: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeOrValueType("null", "Expression", "SpreadElement"))),
        "default": !browser$6.env.BABEL_TYPES_8_BREAKING ? [] : undefined
      }
    },
    visitor: ["elements"],
    aliases: ["Expression"]
  });
  defineType("AssignmentExpression", {
    fields: {
      operator: {
        validate: function () {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) {
            return assertValueType("string");
          }

          var identifier = assertOneOf.apply(void 0, _toConsumableArray(ASSIGNMENT_OPERATORS));
          var pattern = assertOneOf("=");
          return function (node, key, val) {
            var validator = is$1("Pattern", node.left) ? pattern : identifier;
            validator(node, key, val);
          };
        }()
      },
      left: {
        validate: !browser$6.env.BABEL_TYPES_8_BREAKING ? assertNodeType("LVal") : assertNodeType("Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern")
      },
      right: {
        validate: assertNodeType("Expression")
      }
    },
    builder: ["operator", "left", "right"],
    visitor: ["left", "right"],
    aliases: ["Expression"]
  });
  defineType("BinaryExpression", {
    builder: ["operator", "left", "right"],
    fields: {
      operator: {
        validate: assertOneOf.apply(void 0, _toConsumableArray(BINARY_OPERATORS))
      },
      left: {
        validate: function () {
          var expression = assertNodeType("Expression");
          var inOp = assertNodeType("Expression", "PrivateName");

          var validator = function validator(node, key, val) {
            var validator = node.operator === "in" ? inOp : expression;
            validator(node, key, val);
          };

          validator.oneOfNodeTypes = ["Expression", "PrivateName"];
          return validator;
        }()
      },
      right: {
        validate: assertNodeType("Expression")
      }
    },
    visitor: ["left", "right"],
    aliases: ["Binary", "Expression"]
  });
  defineType("InterpreterDirective", {
    builder: ["value"],
    fields: {
      value: {
        validate: assertValueType("string")
      }
    }
  });
  defineType("Directive", {
    visitor: ["value"],
    fields: {
      value: {
        validate: assertNodeType("DirectiveLiteral")
      }
    }
  });
  defineType("DirectiveLiteral", {
    builder: ["value"],
    fields: {
      value: {
        validate: assertValueType("string")
      }
    }
  });
  defineType("BlockStatement", {
    builder: ["body", "directives"],
    visitor: ["directives", "body"],
    fields: {
      directives: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Directive"))),
        "default": []
      },
      body: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Statement")))
      }
    },
    aliases: ["Scopable", "BlockParent", "Block", "Statement"]
  });
  defineType("BreakStatement", {
    visitor: ["label"],
    fields: {
      label: {
        validate: assertNodeType("Identifier"),
        optional: true
      }
    },
    aliases: ["Statement", "Terminatorless", "CompletionStatement"]
  });
  defineType("CallExpression", {
    visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
    builder: ["callee", "arguments"],
    aliases: ["Expression"],
    fields: Object.assign({
      callee: {
        validate: assertNodeType("Expression", "V8IntrinsicIdentifier")
      },
      arguments: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Expression", "SpreadElement", "JSXNamespacedName", "ArgumentPlaceholder")))
      }
    }, !browser$6.env.BABEL_TYPES_8_BREAKING ? {
      optional: {
        validate: assertOneOf(true, false),
        optional: true
      }
    } : {}, {
      typeArguments: {
        validate: assertNodeType("TypeParameterInstantiation"),
        optional: true
      },
      typeParameters: {
        validate: assertNodeType("TSTypeParameterInstantiation"),
        optional: true
      }
    })
  });
  defineType("CatchClause", {
    visitor: ["param", "body"],
    fields: {
      param: {
        validate: assertNodeType("Identifier", "ArrayPattern", "ObjectPattern"),
        optional: true
      },
      body: {
        validate: assertNodeType("BlockStatement")
      }
    },
    aliases: ["Scopable", "BlockParent"]
  });
  defineType("ConditionalExpression", {
    visitor: ["test", "consequent", "alternate"],
    fields: {
      test: {
        validate: assertNodeType("Expression")
      },
      consequent: {
        validate: assertNodeType("Expression")
      },
      alternate: {
        validate: assertNodeType("Expression")
      }
    },
    aliases: ["Expression", "Conditional"]
  });
  defineType("ContinueStatement", {
    visitor: ["label"],
    fields: {
      label: {
        validate: assertNodeType("Identifier"),
        optional: true
      }
    },
    aliases: ["Statement", "Terminatorless", "CompletionStatement"]
  });
  defineType("DebuggerStatement", {
    aliases: ["Statement"]
  });
  defineType("DoWhileStatement", {
    visitor: ["test", "body"],
    fields: {
      test: {
        validate: assertNodeType("Expression")
      },
      body: {
        validate: assertNodeType("Statement")
      }
    },
    aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"]
  });
  defineType("EmptyStatement", {
    aliases: ["Statement"]
  });
  defineType("ExpressionStatement", {
    visitor: ["expression"],
    fields: {
      expression: {
        validate: assertNodeType("Expression")
      }
    },
    aliases: ["Statement", "ExpressionWrapper"]
  });
  defineType("File", {
    builder: ["program", "comments", "tokens"],
    visitor: ["program"],
    fields: {
      program: {
        validate: assertNodeType("Program")
      },
      comments: {
        validate: !browser$6.env.BABEL_TYPES_8_BREAKING ? Object.assign(function () {}, {
          each: {
            oneOfNodeTypes: ["CommentBlock", "CommentLine"]
          }
        }) : assertEach(assertNodeType("CommentBlock", "CommentLine")),
        optional: true
      },
      tokens: {
        validate: assertEach(Object.assign(function () {}, {
          type: "any"
        })),
        optional: true
      }
    }
  });
  defineType("ForInStatement", {
    visitor: ["left", "right", "body"],
    aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
    fields: {
      left: {
        validate: !browser$6.env.BABEL_TYPES_8_BREAKING ? assertNodeType("VariableDeclaration", "LVal") : assertNodeType("VariableDeclaration", "Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern")
      },
      right: {
        validate: assertNodeType("Expression")
      },
      body: {
        validate: assertNodeType("Statement")
      }
    }
  });
  defineType("ForStatement", {
    visitor: ["init", "test", "update", "body"],
    aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop"],
    fields: {
      init: {
        validate: assertNodeType("VariableDeclaration", "Expression"),
        optional: true
      },
      test: {
        validate: assertNodeType("Expression"),
        optional: true
      },
      update: {
        validate: assertNodeType("Expression"),
        optional: true
      },
      body: {
        validate: assertNodeType("Statement")
      }
    }
  });
  var functionCommon = {
    params: {
      validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Identifier", "Pattern", "RestElement")))
    },
    generator: {
      "default": false
    },
    async: {
      "default": false
    }
  };
  var functionTypeAnnotationCommon = {
    returnType: {
      validate: assertNodeType("TypeAnnotation", "TSTypeAnnotation", "Noop"),
      optional: true
    },
    typeParameters: {
      validate: assertNodeType("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
      optional: true
    }
  };
  var functionDeclarationCommon = Object.assign({}, functionCommon, {
    declare: {
      validate: assertValueType("boolean"),
      optional: true
    },
    id: {
      validate: assertNodeType("Identifier"),
      optional: true
    }
  });
  defineType("FunctionDeclaration", {
    builder: ["id", "params", "body", "generator", "async"],
    visitor: ["id", "params", "body", "returnType", "typeParameters"],
    fields: Object.assign({}, functionDeclarationCommon, functionTypeAnnotationCommon, {
      body: {
        validate: assertNodeType("BlockStatement")
      }
    }),
    aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Statement", "Pureish", "Declaration"],
    validate: function () {
      if (!browser$6.env.BABEL_TYPES_8_BREAKING) return function () {};
      var identifier = assertNodeType("Identifier");
      return function (parent, key, node) {
        if (!is$1("ExportDefaultDeclaration", parent)) {
          identifier(node, "id", node.id);
        }
      };
    }()
  });
  defineType("FunctionExpression", {
    inherits: "FunctionDeclaration",
    aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
    fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
      id: {
        validate: assertNodeType("Identifier"),
        optional: true
      },
      body: {
        validate: assertNodeType("BlockStatement")
      }
    })
  });
  var patternLikeCommon = {
    typeAnnotation: {
      validate: assertNodeType("TypeAnnotation", "TSTypeAnnotation", "Noop"),
      optional: true
    },
    decorators: {
      validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator")))
    }
  };
  defineType("Identifier", {
    builder: ["name"],
    visitor: ["typeAnnotation", "decorators"],
    aliases: ["Expression", "PatternLike", "LVal", "TSEntityName"],
    fields: Object.assign({}, patternLikeCommon, {
      name: {
        validate: chain$1(assertValueType("string"), Object.assign(function (node, key, val) {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;

          if (!isValidIdentifier$1(val, false)) {
            throw new TypeError("\"" + val + "\" is not a valid identifier name");
          }
        }, {
          type: "string"
        }))
      },
      optional: {
        validate: assertValueType("boolean"),
        optional: true
      }
    }),
    validate: function validate(parent, key, node) {
      if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;
      var match = /\.(\w+)$/.exec(key);
      if (!match) return;

      var _match = _slicedToArray$2(match, 2),
          parentKey = _match[1];

      var nonComp = {
        computed: false
      };

      if (parentKey === "property") {
        if (is$1("MemberExpression", parent, nonComp)) return;
        if (is$1("OptionalMemberExpression", parent, nonComp)) return;
      } else if (parentKey === "key") {
        if (is$1("Property", parent, nonComp)) return;
        if (is$1("Method", parent, nonComp)) return;
      } else if (parentKey === "exported") {
        if (is$1("ExportSpecifier", parent)) return;
      } else if (parentKey === "imported") {
        if (is$1("ImportSpecifier", parent, {
          imported: node
        })) return;
      } else if (parentKey === "meta") {
        if (is$1("MetaProperty", parent, {
          meta: node
        })) return;
      }

      if ((isKeyword(node.name) || isReservedWord(node.name, false)) && node.name !== "this") {
        throw new TypeError("\"" + node.name + "\" is not a valid identifier");
      }
    }
  });
  defineType("IfStatement", {
    visitor: ["test", "consequent", "alternate"],
    aliases: ["Statement", "Conditional"],
    fields: {
      test: {
        validate: assertNodeType("Expression")
      },
      consequent: {
        validate: assertNodeType("Statement")
      },
      alternate: {
        optional: true,
        validate: assertNodeType("Statement")
      }
    }
  });
  defineType("LabeledStatement", {
    visitor: ["label", "body"],
    aliases: ["Statement"],
    fields: {
      label: {
        validate: assertNodeType("Identifier")
      },
      body: {
        validate: assertNodeType("Statement")
      }
    }
  });
  defineType("StringLiteral", {
    builder: ["value"],
    fields: {
      value: {
        validate: assertValueType("string")
      }
    },
    aliases: ["Expression", "Pureish", "Literal", "Immutable"]
  });
  defineType("NumericLiteral", {
    builder: ["value"],
    deprecatedAlias: "NumberLiteral",
    fields: {
      value: {
        validate: assertValueType("number")
      }
    },
    aliases: ["Expression", "Pureish", "Literal", "Immutable"]
  });
  defineType("NullLiteral", {
    aliases: ["Expression", "Pureish", "Literal", "Immutable"]
  });
  defineType("BooleanLiteral", {
    builder: ["value"],
    fields: {
      value: {
        validate: assertValueType("boolean")
      }
    },
    aliases: ["Expression", "Pureish", "Literal", "Immutable"]
  });
  defineType("RegExpLiteral", {
    builder: ["pattern", "flags"],
    deprecatedAlias: "RegexLiteral",
    aliases: ["Expression", "Pureish", "Literal"],
    fields: {
      pattern: {
        validate: assertValueType("string")
      },
      flags: {
        validate: chain$1(assertValueType("string"), Object.assign(function (node, key, val) {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;
          var invalid = /[^gimsuy]/.exec(val);

          if (invalid) {
            throw new TypeError("\"" + invalid[0] + "\" is not a valid RegExp flag");
          }
        }, {
          type: "string"
        })),
        "default": ""
      }
    }
  });
  defineType("LogicalExpression", {
    builder: ["operator", "left", "right"],
    visitor: ["left", "right"],
    aliases: ["Binary", "Expression"],
    fields: {
      operator: {
        validate: assertOneOf.apply(void 0, _toConsumableArray(LOGICAL_OPERATORS$2))
      },
      left: {
        validate: assertNodeType("Expression")
      },
      right: {
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("MemberExpression", {
    builder: ["object", "property", "computed"].concat(_toConsumableArray(!browser$6.env.BABEL_TYPES_8_BREAKING ? ["optional"] : [])),
    visitor: ["object", "property"],
    aliases: ["Expression", "LVal"],
    fields: Object.assign({
      object: {
        validate: assertNodeType("Expression")
      },
      property: {
        validate: function () {
          var normal = assertNodeType("Identifier", "PrivateName");
          var computed = assertNodeType("Expression");

          var validator = function validator(node, key, val) {
            var validator = node.computed ? computed : normal;
            validator(node, key, val);
          };

          validator.oneOfNodeTypes = ["Expression", "Identifier", "PrivateName"];
          return validator;
        }()
      },
      computed: {
        "default": false
      }
    }, !browser$6.env.BABEL_TYPES_8_BREAKING ? {
      optional: {
        validate: assertOneOf(true, false),
        optional: true
      }
    } : {})
  });
  defineType("NewExpression", {
    inherits: "CallExpression"
  });
  defineType("Program", {
    visitor: ["directives", "body"],
    builder: ["body", "directives", "sourceType", "interpreter"],
    fields: {
      sourceFile: {
        validate: assertValueType("string")
      },
      sourceType: {
        validate: assertOneOf("script", "module"),
        "default": "script"
      },
      interpreter: {
        validate: assertNodeType("InterpreterDirective"),
        "default": null,
        optional: true
      },
      directives: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Directive"))),
        "default": []
      },
      body: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Statement")))
      }
    },
    aliases: ["Scopable", "BlockParent", "Block"]
  });
  defineType("ObjectExpression", {
    visitor: ["properties"],
    aliases: ["Expression"],
    fields: {
      properties: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("ObjectMethod", "ObjectProperty", "SpreadElement")))
      }
    }
  });
  defineType("ObjectMethod", {
    builder: ["kind", "key", "params", "body", "computed", "generator", "async"],
    fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
      kind: Object.assign({
        validate: assertOneOf("method", "get", "set")
      }, !browser$6.env.BABEL_TYPES_8_BREAKING ? {
        "default": "method"
      } : {}),
      computed: {
        "default": false
      },
      key: {
        validate: function () {
          var normal = assertNodeType("Identifier", "StringLiteral", "NumericLiteral");
          var computed = assertNodeType("Expression");

          var validator = function validator(node, key, val) {
            var validator = node.computed ? computed : normal;
            validator(node, key, val);
          };

          validator.oneOfNodeTypes = ["Expression", "Identifier", "StringLiteral", "NumericLiteral"];
          return validator;
        }()
      },
      decorators: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
        optional: true
      },
      body: {
        validate: assertNodeType("BlockStatement")
      }
    }),
    visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    aliases: ["UserWhitespacable", "Function", "Scopable", "BlockParent", "FunctionParent", "Method", "ObjectMember"]
  });
  defineType("ObjectProperty", {
    builder: ["key", "value", "computed", "shorthand"].concat(_toConsumableArray(!browser$6.env.BABEL_TYPES_8_BREAKING ? ["decorators"] : [])),
    fields: {
      computed: {
        "default": false
      },
      key: {
        validate: function () {
          var normal = assertNodeType("Identifier", "StringLiteral", "NumericLiteral");
          var computed = assertNodeType("Expression");

          var validator = function validator(node, key, val) {
            var validator = node.computed ? computed : normal;
            validator(node, key, val);
          };

          validator.oneOfNodeTypes = ["Expression", "Identifier", "StringLiteral", "NumericLiteral"];
          return validator;
        }()
      },
      value: {
        validate: assertNodeType("Expression", "PatternLike")
      },
      shorthand: {
        validate: chain$1(assertValueType("boolean"), Object.assign(function (node, key, val) {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;

          if (val && node.computed) {
            throw new TypeError("Property shorthand of ObjectProperty cannot be true if computed is true");
          }
        }, {
          type: "boolean"
        }), function (node, key, val) {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;

          if (val && !is$1("Identifier", node.key)) {
            throw new TypeError("Property shorthand of ObjectProperty cannot be true if key is not an Identifier");
          }
        }),
        "default": false
      },
      decorators: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
        optional: true
      }
    },
    visitor: ["key", "value", "decorators"],
    aliases: ["UserWhitespacable", "Property", "ObjectMember"],
    validate: function () {
      var pattern = assertNodeType("Identifier", "Pattern");
      var expression = assertNodeType("Expression");
      return function (parent, key, node) {
        if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;
        var validator = is$1("ObjectPattern", parent) ? pattern : expression;
        validator(node, "value", node.value);
      };
    }()
  });
  defineType("RestElement", {
    visitor: ["argument", "typeAnnotation"],
    builder: ["argument"],
    aliases: ["LVal", "PatternLike"],
    deprecatedAlias: "RestProperty",
    fields: Object.assign({}, patternLikeCommon, {
      argument: {
        validate: !browser$6.env.BABEL_TYPES_8_BREAKING ? assertNodeType("LVal") : assertNodeType("Identifier", "ArrayPattern", "ObjectPattern", "MemberExpression")
      },
      optional: {
        validate: assertValueType("boolean"),
        optional: true
      }
    }),
    validate: function validate(parent, key) {
      if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;
      var match = /(\w+)\[(\d+)\]/.exec(key);
      if (!match) throw new Error("Internal Babel error: malformed key.");

      var _match2 = _slicedToArray$2(match, 3),
          listKey = _match2[1],
          index = _match2[2];

      if (parent[listKey].length > index + 1) {
        throw new TypeError("RestElement must be last element of " + listKey);
      }
    }
  });
  defineType("ReturnStatement", {
    visitor: ["argument"],
    aliases: ["Statement", "Terminatorless", "CompletionStatement"],
    fields: {
      argument: {
        validate: assertNodeType("Expression"),
        optional: true
      }
    }
  });
  defineType("SequenceExpression", {
    visitor: ["expressions"],
    fields: {
      expressions: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Expression")))
      }
    },
    aliases: ["Expression"]
  });
  defineType("ParenthesizedExpression", {
    visitor: ["expression"],
    aliases: ["Expression", "ExpressionWrapper"],
    fields: {
      expression: {
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("SwitchCase", {
    visitor: ["test", "consequent"],
    fields: {
      test: {
        validate: assertNodeType("Expression"),
        optional: true
      },
      consequent: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Statement")))
      }
    }
  });
  defineType("SwitchStatement", {
    visitor: ["discriminant", "cases"],
    aliases: ["Statement", "BlockParent", "Scopable"],
    fields: {
      discriminant: {
        validate: assertNodeType("Expression")
      },
      cases: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("SwitchCase")))
      }
    }
  });
  defineType("ThisExpression", {
    aliases: ["Expression"]
  });
  defineType("ThrowStatement", {
    visitor: ["argument"],
    aliases: ["Statement", "Terminatorless", "CompletionStatement"],
    fields: {
      argument: {
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("TryStatement", {
    visitor: ["block", "handler", "finalizer"],
    aliases: ["Statement"],
    fields: {
      block: {
        validate: chain$1(assertNodeType("BlockStatement"), Object.assign(function (node) {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;

          if (!node.handler && !node.finalizer) {
            throw new TypeError("TryStatement expects either a handler or finalizer, or both");
          }
        }, {
          oneOfNodeTypes: ["BlockStatement"]
        }))
      },
      handler: {
        optional: true,
        validate: assertNodeType("CatchClause")
      },
      finalizer: {
        optional: true,
        validate: assertNodeType("BlockStatement")
      }
    }
  });
  defineType("UnaryExpression", {
    builder: ["operator", "argument", "prefix"],
    fields: {
      prefix: {
        "default": true
      },
      argument: {
        validate: assertNodeType("Expression")
      },
      operator: {
        validate: assertOneOf.apply(void 0, _toConsumableArray(UNARY_OPERATORS))
      }
    },
    visitor: ["argument"],
    aliases: ["UnaryLike", "Expression"]
  });
  defineType("UpdateExpression", {
    builder: ["operator", "argument", "prefix"],
    fields: {
      prefix: {
        "default": false
      },
      argument: {
        validate: !browser$6.env.BABEL_TYPES_8_BREAKING ? assertNodeType("Expression") : assertNodeType("Identifier", "MemberExpression")
      },
      operator: {
        validate: assertOneOf.apply(void 0, _toConsumableArray(UPDATE_OPERATORS))
      }
    },
    visitor: ["argument"],
    aliases: ["Expression"]
  });
  defineType("VariableDeclaration", {
    builder: ["kind", "declarations"],
    visitor: ["declarations"],
    aliases: ["Statement", "Declaration"],
    fields: {
      declare: {
        validate: assertValueType("boolean"),
        optional: true
      },
      kind: {
        validate: assertOneOf("var", "let", "const")
      },
      declarations: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("VariableDeclarator")))
      }
    },
    validate: function validate(parent, key, node) {
      if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;
      if (!is$1("ForXStatement", parent, {
        left: node
      })) return;

      if (node.declarations.length !== 1) {
        throw new TypeError("Exactly one VariableDeclarator is required in the VariableDeclaration of a " + parent.type);
      }
    }
  });
  defineType("VariableDeclarator", {
    visitor: ["id", "init"],
    fields: {
      id: {
        validate: function () {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) {
            return assertNodeType("LVal");
          }

          var normal = assertNodeType("Identifier", "ArrayPattern", "ObjectPattern");
          var without = assertNodeType("Identifier");
          return function (node, key, val) {
            var validator = node.init ? normal : without;
            validator(node, key, val);
          };
        }()
      },
      definite: {
        optional: true,
        validate: assertValueType("boolean")
      },
      init: {
        optional: true,
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("WhileStatement", {
    visitor: ["test", "body"],
    aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"],
    fields: {
      test: {
        validate: assertNodeType("Expression")
      },
      body: {
        validate: assertNodeType("Statement")
      }
    }
  });
  defineType("WithStatement", {
    visitor: ["object", "body"],
    aliases: ["Statement"],
    fields: {
      object: {
        validate: assertNodeType("Expression")
      },
      body: {
        validate: assertNodeType("Statement")
      }
    }
  });
  defineType("AssignmentPattern", {
    visitor: ["left", "right", "decorators"],
    builder: ["left", "right"],
    aliases: ["Pattern", "PatternLike", "LVal"],
    fields: Object.assign({}, patternLikeCommon, {
      left: {
        validate: assertNodeType("Identifier", "ObjectPattern", "ArrayPattern", "MemberExpression")
      },
      right: {
        validate: assertNodeType("Expression")
      },
      decorators: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
        optional: true
      }
    })
  });
  defineType("ArrayPattern", {
    visitor: ["elements", "typeAnnotation"],
    builder: ["elements"],
    aliases: ["Pattern", "PatternLike", "LVal"],
    fields: Object.assign({}, patternLikeCommon, {
      elements: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeOrValueType("null", "PatternLike")))
      },
      decorators: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
        optional: true
      },
      optional: {
        validate: assertValueType("boolean"),
        optional: true
      }
    })
  });
  defineType("ArrowFunctionExpression", {
    builder: ["params", "body", "async"],
    visitor: ["params", "body", "returnType", "typeParameters"],
    aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
    fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
      expression: {
        validate: assertValueType("boolean")
      },
      body: {
        validate: assertNodeType("BlockStatement", "Expression")
      }
    })
  });
  defineType("ClassBody", {
    visitor: ["body"],
    fields: {
      body: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("ClassMethod", "ClassPrivateMethod", "ClassProperty", "ClassPrivateProperty", "TSDeclareMethod", "TSIndexSignature")))
      }
    }
  });
  defineType("ClassExpression", {
    builder: ["id", "superClass", "body", "decorators"],
    visitor: ["id", "body", "superClass", "mixins", "typeParameters", "superTypeParameters", "implements", "decorators"],
    aliases: ["Scopable", "Class", "Expression"],
    fields: {
      id: {
        validate: assertNodeType("Identifier"),
        optional: true
      },
      typeParameters: {
        validate: assertNodeType("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
        optional: true
      },
      body: {
        validate: assertNodeType("ClassBody")
      },
      superClass: {
        optional: true,
        validate: assertNodeType("Expression")
      },
      superTypeParameters: {
        validate: assertNodeType("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
        optional: true
      },
      "implements": {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("TSExpressionWithTypeArguments", "ClassImplements"))),
        optional: true
      },
      decorators: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
        optional: true
      },
      mixins: {
        validate: assertNodeType("InterfaceExtends"),
        optional: true
      }
    }
  });
  defineType("ClassDeclaration", {
    inherits: "ClassExpression",
    aliases: ["Scopable", "Class", "Statement", "Declaration"],
    fields: {
      id: {
        validate: assertNodeType("Identifier")
      },
      typeParameters: {
        validate: assertNodeType("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
        optional: true
      },
      body: {
        validate: assertNodeType("ClassBody")
      },
      superClass: {
        optional: true,
        validate: assertNodeType("Expression")
      },
      superTypeParameters: {
        validate: assertNodeType("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
        optional: true
      },
      "implements": {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("TSExpressionWithTypeArguments", "ClassImplements"))),
        optional: true
      },
      decorators: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
        optional: true
      },
      mixins: {
        validate: assertNodeType("InterfaceExtends"),
        optional: true
      },
      declare: {
        validate: assertValueType("boolean"),
        optional: true
      },
      "abstract": {
        validate: assertValueType("boolean"),
        optional: true
      }
    },
    validate: function () {
      var identifier = assertNodeType("Identifier");
      return function (parent, key, node) {
        if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;

        if (!is$1("ExportDefaultDeclaration", parent)) {
          identifier(node, "id", node.id);
        }
      };
    }()
  });
  defineType("ExportAllDeclaration", {
    visitor: ["source"],
    aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    fields: {
      source: {
        validate: assertNodeType("StringLiteral")
      },
      exportKind: validateOptional(assertOneOf("type", "value")),
      assertions: {
        optional: true,
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("ImportAttribute")))
      }
    }
  });
  defineType("ExportDefaultDeclaration", {
    visitor: ["declaration"],
    aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    fields: {
      declaration: {
        validate: assertNodeType("FunctionDeclaration", "TSDeclareFunction", "ClassDeclaration", "Expression")
      },
      exportKind: validateOptional(assertOneOf("value"))
    }
  });
  defineType("ExportNamedDeclaration", {
    visitor: ["declaration", "specifiers", "source"],
    aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    fields: {
      declaration: {
        optional: true,
        validate: chain$1(assertNodeType("Declaration"), Object.assign(function (node, key, val) {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;

          if (val && node.specifiers.length) {
            throw new TypeError("Only declaration or specifiers is allowed on ExportNamedDeclaration");
          }
        }, {
          oneOfNodeTypes: ["Declaration"]
        }), function (node, key, val) {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;

          if (val && node.source) {
            throw new TypeError("Cannot export a declaration from a source");
          }
        })
      },
      assertions: {
        optional: true,
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("ImportAttribute")))
      },
      specifiers: {
        "default": [],
        validate: chain$1(assertValueType("array"), assertEach(function () {
          var sourced = assertNodeType("ExportSpecifier", "ExportDefaultSpecifier", "ExportNamespaceSpecifier");
          var sourceless = assertNodeType("ExportSpecifier");
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return sourced;
          return function (node, key, val) {
            var validator = node.source ? sourced : sourceless;
            validator(node, key, val);
          };
        }()))
      },
      source: {
        validate: assertNodeType("StringLiteral"),
        optional: true
      },
      exportKind: validateOptional(assertOneOf("type", "value"))
    }
  });
  defineType("ExportSpecifier", {
    visitor: ["local", "exported"],
    aliases: ["ModuleSpecifier"],
    fields: {
      local: {
        validate: assertNodeType("Identifier")
      },
      exported: {
        validate: assertNodeType("Identifier", "StringLiteral")
      }
    }
  });
  defineType("ForOfStatement", {
    visitor: ["left", "right", "body"],
    builder: ["left", "right", "body", "await"],
    aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
    fields: {
      left: {
        validate: function () {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) {
            return assertNodeType("VariableDeclaration", "LVal");
          }

          var declaration = assertNodeType("VariableDeclaration");
          var lval = assertNodeType("Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern");
          return function (node, key, val) {
            if (is$1("VariableDeclaration", val)) {
              declaration(node, key, val);
            } else {
              lval(node, key, val);
            }
          };
        }()
      },
      right: {
        validate: assertNodeType("Expression")
      },
      body: {
        validate: assertNodeType("Statement")
      },
      "await": {
        "default": false
      }
    }
  });
  defineType("ImportDeclaration", {
    visitor: ["specifiers", "source"],
    aliases: ["Statement", "Declaration", "ModuleDeclaration"],
    fields: {
      assertions: {
        optional: true,
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("ImportAttribute")))
      },
      specifiers: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("ImportSpecifier", "ImportDefaultSpecifier", "ImportNamespaceSpecifier")))
      },
      source: {
        validate: assertNodeType("StringLiteral")
      },
      importKind: {
        validate: assertOneOf("type", "typeof", "value"),
        optional: true
      }
    }
  });
  defineType("ImportDefaultSpecifier", {
    visitor: ["local"],
    aliases: ["ModuleSpecifier"],
    fields: {
      local: {
        validate: assertNodeType("Identifier")
      }
    }
  });
  defineType("ImportNamespaceSpecifier", {
    visitor: ["local"],
    aliases: ["ModuleSpecifier"],
    fields: {
      local: {
        validate: assertNodeType("Identifier")
      }
    }
  });
  defineType("ImportSpecifier", {
    visitor: ["local", "imported"],
    aliases: ["ModuleSpecifier"],
    fields: {
      local: {
        validate: assertNodeType("Identifier")
      },
      imported: {
        validate: assertNodeType("Identifier", "StringLiteral")
      },
      importKind: {
        validate: assertOneOf("type", "typeof"),
        optional: true
      }
    }
  });
  defineType("MetaProperty", {
    visitor: ["meta", "property"],
    aliases: ["Expression"],
    fields: {
      meta: {
        validate: chain$1(assertNodeType("Identifier"), Object.assign(function (node, key, val) {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;
          var property;

          switch (val.name) {
            case "function":
              property = "sent";
              break;

            case "new":
              property = "target";
              break;

            case "import":
              property = "meta";
              break;
          }

          if (!is$1("Identifier", node.property, {
            name: property
          })) {
            throw new TypeError("Unrecognised MetaProperty");
          }
        }, {
          oneOfNodeTypes: ["Identifier"]
        }))
      },
      property: {
        validate: assertNodeType("Identifier")
      }
    }
  });
  var classMethodOrPropertyCommon = {
    "abstract": {
      validate: assertValueType("boolean"),
      optional: true
    },
    accessibility: {
      validate: assertOneOf("public", "private", "protected"),
      optional: true
    },
    "static": {
      "default": false
    },
    override: {
      "default": false
    },
    computed: {
      "default": false
    },
    optional: {
      validate: assertValueType("boolean"),
      optional: true
    },
    key: {
      validate: chain$1(function () {
        var normal = assertNodeType("Identifier", "StringLiteral", "NumericLiteral");
        var computed = assertNodeType("Expression");
        return function (node, key, val) {
          var validator = node.computed ? computed : normal;
          validator(node, key, val);
        };
      }(), assertNodeType("Identifier", "StringLiteral", "NumericLiteral", "Expression"))
    }
  };
  var classMethodOrDeclareMethodCommon = Object.assign({}, functionCommon, classMethodOrPropertyCommon, {
    params: {
      validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Identifier", "Pattern", "RestElement", "TSParameterProperty")))
    },
    kind: {
      validate: assertOneOf("get", "set", "method", "constructor"),
      "default": "method"
    },
    access: {
      validate: chain$1(assertValueType("string"), assertOneOf("public", "private", "protected")),
      optional: true
    },
    decorators: {
      validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
      optional: true
    }
  });
  defineType("ClassMethod", {
    aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method"],
    builder: ["kind", "key", "params", "body", "computed", "static", "generator", "async"],
    visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    fields: Object.assign({}, classMethodOrDeclareMethodCommon, functionTypeAnnotationCommon, {
      body: {
        validate: assertNodeType("BlockStatement")
      }
    })
  });
  defineType("ObjectPattern", {
    visitor: ["properties", "typeAnnotation", "decorators"],
    builder: ["properties"],
    aliases: ["Pattern", "PatternLike", "LVal"],
    fields: Object.assign({}, patternLikeCommon, {
      properties: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("RestElement", "ObjectProperty")))
      }
    })
  });
  defineType("SpreadElement", {
    visitor: ["argument"],
    aliases: ["UnaryLike"],
    deprecatedAlias: "SpreadProperty",
    fields: {
      argument: {
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("Super", {
    aliases: ["Expression"]
  });
  defineType("TaggedTemplateExpression", {
    visitor: ["tag", "quasi", "typeParameters"],
    builder: ["tag", "quasi"],
    aliases: ["Expression"],
    fields: {
      tag: {
        validate: assertNodeType("Expression")
      },
      quasi: {
        validate: assertNodeType("TemplateLiteral")
      },
      typeParameters: {
        validate: assertNodeType("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
        optional: true
      }
    }
  });
  defineType("TemplateElement", {
    builder: ["value", "tail"],
    fields: {
      value: {
        validate: assertShape({
          raw: {
            validate: assertValueType("string")
          },
          cooked: {
            validate: assertValueType("string"),
            optional: true
          }
        })
      },
      tail: {
        "default": false
      }
    }
  });
  defineType("TemplateLiteral", {
    visitor: ["quasis", "expressions"],
    aliases: ["Expression", "Literal"],
    fields: {
      quasis: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("TemplateElement")))
      },
      expressions: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Expression", "TSType")), function (node, key, val) {
          if (node.quasis.length !== val.length + 1) {
            throw new TypeError("Number of " + node.type + " quasis should be exactly one more than the number of expressions.\nExpected " + (val.length + 1) + " quasis but got " + node.quasis.length);
          }
        })
      }
    }
  });
  defineType("YieldExpression", {
    builder: ["argument", "delegate"],
    visitor: ["argument"],
    aliases: ["Expression", "Terminatorless"],
    fields: {
      delegate: {
        validate: chain$1(assertValueType("boolean"), Object.assign(function (node, key, val) {
          if (!browser$6.env.BABEL_TYPES_8_BREAKING) return;

          if (val && !node.argument) {
            throw new TypeError("Property delegate of YieldExpression cannot be true if there is no argument");
          }
        }, {
          type: "boolean"
        })),
        "default": false
      },
      argument: {
        optional: true,
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("AwaitExpression", {
    builder: ["argument"],
    visitor: ["argument"],
    aliases: ["Expression", "Terminatorless"],
    fields: {
      argument: {
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("Import", {
    aliases: ["Expression"]
  });
  defineType("BigIntLiteral", {
    builder: ["value"],
    fields: {
      value: {
        validate: assertValueType("string")
      }
    },
    aliases: ["Expression", "Pureish", "Literal", "Immutable"]
  });
  defineType("ExportNamespaceSpecifier", {
    visitor: ["exported"],
    aliases: ["ModuleSpecifier"],
    fields: {
      exported: {
        validate: assertNodeType("Identifier")
      }
    }
  });
  defineType("OptionalMemberExpression", {
    builder: ["object", "property", "computed", "optional"],
    visitor: ["object", "property"],
    aliases: ["Expression"],
    fields: {
      object: {
        validate: assertNodeType("Expression")
      },
      property: {
        validate: function () {
          var normal = assertNodeType("Identifier");
          var computed = assertNodeType("Expression");

          var validator = function validator(node, key, val) {
            var validator = node.computed ? computed : normal;
            validator(node, key, val);
          };

          validator.oneOfNodeTypes = ["Expression", "Identifier"];
          return validator;
        }()
      },
      computed: {
        "default": false
      },
      optional: {
        validate: !browser$6.env.BABEL_TYPES_8_BREAKING ? assertValueType("boolean") : chain$1(assertValueType("boolean"), assertOptionalChainStart())
      }
    }
  });
  defineType("OptionalCallExpression", {
    visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
    builder: ["callee", "arguments", "optional"],
    aliases: ["Expression"],
    fields: {
      callee: {
        validate: assertNodeType("Expression")
      },
      arguments: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Expression", "SpreadElement", "JSXNamespacedName", "ArgumentPlaceholder")))
      },
      optional: {
        validate: !browser$6.env.BABEL_TYPES_8_BREAKING ? assertValueType("boolean") : chain$1(assertValueType("boolean"), assertOptionalChainStart())
      },
      typeArguments: {
        validate: assertNodeType("TypeParameterInstantiation"),
        optional: true
      },
      typeParameters: {
        validate: assertNodeType("TSTypeParameterInstantiation"),
        optional: true
      }
    }
  });
  defineType("ClassProperty", {
    visitor: ["key", "value", "typeAnnotation", "decorators"],
    builder: ["key", "value", "typeAnnotation", "decorators", "computed", "static"],
    aliases: ["Property"],
    fields: Object.assign({}, classMethodOrPropertyCommon, {
      value: {
        validate: assertNodeType("Expression"),
        optional: true
      },
      definite: {
        validate: assertValueType("boolean"),
        optional: true
      },
      typeAnnotation: {
        validate: assertNodeType("TypeAnnotation", "TSTypeAnnotation", "Noop"),
        optional: true
      },
      decorators: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
        optional: true
      },
      readonly: {
        validate: assertValueType("boolean"),
        optional: true
      },
      declare: {
        validate: assertValueType("boolean"),
        optional: true
      },
      variance: {
        validate: assertNodeType("Variance"),
        optional: true
      }
    })
  });
  defineType("ClassPrivateProperty", {
    visitor: ["key", "value", "decorators", "typeAnnotation"],
    builder: ["key", "value", "decorators", "static"],
    aliases: ["Property", "Private"],
    fields: {
      key: {
        validate: assertNodeType("PrivateName")
      },
      value: {
        validate: assertNodeType("Expression"),
        optional: true
      },
      typeAnnotation: {
        validate: assertNodeType("TypeAnnotation", "TSTypeAnnotation", "Noop"),
        optional: true
      },
      decorators: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
        optional: true
      },
      readonly: {
        validate: assertValueType("boolean"),
        optional: true
      },
      definite: {
        validate: assertValueType("boolean"),
        optional: true
      },
      variance: {
        validate: assertNodeType("Variance"),
        optional: true
      }
    }
  });
  defineType("ClassPrivateMethod", {
    builder: ["kind", "key", "params", "body", "static"],
    visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method", "Private"],
    fields: Object.assign({}, classMethodOrDeclareMethodCommon, functionTypeAnnotationCommon, {
      key: {
        validate: assertNodeType("PrivateName")
      },
      body: {
        validate: assertNodeType("BlockStatement")
      }
    })
  });
  defineType("PrivateName", {
    visitor: ["id"],
    aliases: ["Private"],
    fields: {
      id: {
        validate: assertNodeType("Identifier")
      }
    }
  });

  var defineInterfaceishType = function defineInterfaceishType(name, typeParameterType) {
    if (typeParameterType === void 0) {
      typeParameterType = "TypeParameterDeclaration";
    }

    defineType(name, {
      builder: ["id", "typeParameters", "extends", "body"],
      visitor: ["id", "typeParameters", "extends", "mixins", "implements", "body"],
      aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
      fields: {
        id: validateType("Identifier"),
        typeParameters: validateOptionalType(typeParameterType),
        "extends": validateOptional(arrayOfType("InterfaceExtends")),
        mixins: validateOptional(arrayOfType("InterfaceExtends")),
        "implements": validateOptional(arrayOfType("ClassImplements")),
        body: validateType("ObjectTypeAnnotation")
      }
    });
  };

  defineType("AnyTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("ArrayTypeAnnotation", {
    visitor: ["elementType"],
    aliases: ["Flow", "FlowType"],
    fields: {
      elementType: validateType("FlowType")
    }
  });
  defineType("BooleanTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("BooleanLiteralTypeAnnotation", {
    builder: ["value"],
    aliases: ["Flow", "FlowType"],
    fields: {
      value: validate$5(assertValueType("boolean"))
    }
  });
  defineType("NullLiteralTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("ClassImplements", {
    visitor: ["id", "typeParameters"],
    aliases: ["Flow"],
    fields: {
      id: validateType("Identifier"),
      typeParameters: validateOptionalType("TypeParameterInstantiation")
    }
  });
  defineInterfaceishType("DeclareClass");
  defineType("DeclareFunction", {
    visitor: ["id"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      id: validateType("Identifier"),
      predicate: validateOptionalType("DeclaredPredicate")
    }
  });
  defineInterfaceishType("DeclareInterface");
  defineType("DeclareModule", {
    builder: ["id", "body", "kind"],
    visitor: ["id", "body"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      id: validateType(["Identifier", "StringLiteral"]),
      body: validateType("BlockStatement"),
      kind: validateOptional(assertOneOf("CommonJS", "ES"))
    }
  });
  defineType("DeclareModuleExports", {
    visitor: ["typeAnnotation"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      typeAnnotation: validateType("TypeAnnotation")
    }
  });
  defineType("DeclareTypeAlias", {
    visitor: ["id", "typeParameters", "right"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      id: validateType("Identifier"),
      typeParameters: validateOptionalType("TypeParameterDeclaration"),
      right: validateType("FlowType")
    }
  });
  defineType("DeclareOpaqueType", {
    visitor: ["id", "typeParameters", "supertype"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      id: validateType("Identifier"),
      typeParameters: validateOptionalType("TypeParameterDeclaration"),
      supertype: validateOptionalType("FlowType"),
      impltype: validateOptionalType("FlowType")
    }
  });
  defineType("DeclareVariable", {
    visitor: ["id"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      id: validateType("Identifier")
    }
  });
  defineType("DeclareExportDeclaration", {
    visitor: ["declaration", "specifiers", "source"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      declaration: validateOptionalType("Flow"),
      specifiers: validateOptional(arrayOfType(["ExportSpecifier", "ExportNamespaceSpecifier"])),
      source: validateOptionalType("StringLiteral"),
      "default": validateOptional(assertValueType("boolean"))
    }
  });
  defineType("DeclareExportAllDeclaration", {
    visitor: ["source"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      source: validateType("StringLiteral"),
      exportKind: validateOptional(assertOneOf("type", "value"))
    }
  });
  defineType("DeclaredPredicate", {
    visitor: ["value"],
    aliases: ["Flow", "FlowPredicate"],
    fields: {
      value: validateType("Flow")
    }
  });
  defineType("ExistsTypeAnnotation", {
    aliases: ["Flow", "FlowType"]
  });
  defineType("FunctionTypeAnnotation", {
    visitor: ["typeParameters", "params", "rest", "returnType"],
    aliases: ["Flow", "FlowType"],
    fields: {
      typeParameters: validateOptionalType("TypeParameterDeclaration"),
      params: validate$5(arrayOfType("FunctionTypeParam")),
      rest: validateOptionalType("FunctionTypeParam"),
      "this": validateOptionalType("FunctionTypeParam"),
      returnType: validateType("FlowType")
    }
  });
  defineType("FunctionTypeParam", {
    visitor: ["name", "typeAnnotation"],
    aliases: ["Flow"],
    fields: {
      name: validateOptionalType("Identifier"),
      typeAnnotation: validateType("FlowType"),
      optional: validateOptional(assertValueType("boolean"))
    }
  });
  defineType("GenericTypeAnnotation", {
    visitor: ["id", "typeParameters"],
    aliases: ["Flow", "FlowType"],
    fields: {
      id: validateType(["Identifier", "QualifiedTypeIdentifier"]),
      typeParameters: validateOptionalType("TypeParameterInstantiation")
    }
  });
  defineType("InferredPredicate", {
    aliases: ["Flow", "FlowPredicate"]
  });
  defineType("InterfaceExtends", {
    visitor: ["id", "typeParameters"],
    aliases: ["Flow"],
    fields: {
      id: validateType(["Identifier", "QualifiedTypeIdentifier"]),
      typeParameters: validateOptionalType("TypeParameterInstantiation")
    }
  });
  defineInterfaceishType("InterfaceDeclaration");
  defineType("InterfaceTypeAnnotation", {
    visitor: ["extends", "body"],
    aliases: ["Flow", "FlowType"],
    fields: {
      "extends": validateOptional(arrayOfType("InterfaceExtends")),
      body: validateType("ObjectTypeAnnotation")
    }
  });
  defineType("IntersectionTypeAnnotation", {
    visitor: ["types"],
    aliases: ["Flow", "FlowType"],
    fields: {
      types: validate$5(arrayOfType("FlowType"))
    }
  });
  defineType("MixedTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("EmptyTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("NullableTypeAnnotation", {
    visitor: ["typeAnnotation"],
    aliases: ["Flow", "FlowType"],
    fields: {
      typeAnnotation: validateType("FlowType")
    }
  });
  defineType("NumberLiteralTypeAnnotation", {
    builder: ["value"],
    aliases: ["Flow", "FlowType"],
    fields: {
      value: validate$5(assertValueType("number"))
    }
  });
  defineType("NumberTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("ObjectTypeAnnotation", {
    visitor: ["properties", "indexers", "callProperties", "internalSlots"],
    aliases: ["Flow", "FlowType"],
    builder: ["properties", "indexers", "callProperties", "internalSlots", "exact"],
    fields: {
      properties: validate$5(arrayOfType(["ObjectTypeProperty", "ObjectTypeSpreadProperty"])),
      indexers: validateOptional(arrayOfType("ObjectTypeIndexer")),
      callProperties: validateOptional(arrayOfType("ObjectTypeCallProperty")),
      internalSlots: validateOptional(arrayOfType("ObjectTypeInternalSlot")),
      exact: {
        validate: assertValueType("boolean"),
        "default": false
      },
      inexact: validateOptional(assertValueType("boolean"))
    }
  });
  defineType("ObjectTypeInternalSlot", {
    visitor: ["id", "value", "optional", "static", "method"],
    aliases: ["Flow", "UserWhitespacable"],
    fields: {
      id: validateType("Identifier"),
      value: validateType("FlowType"),
      optional: validate$5(assertValueType("boolean")),
      "static": validate$5(assertValueType("boolean")),
      method: validate$5(assertValueType("boolean"))
    }
  });
  defineType("ObjectTypeCallProperty", {
    visitor: ["value"],
    aliases: ["Flow", "UserWhitespacable"],
    fields: {
      value: validateType("FlowType"),
      "static": validate$5(assertValueType("boolean"))
    }
  });
  defineType("ObjectTypeIndexer", {
    visitor: ["id", "key", "value", "variance"],
    aliases: ["Flow", "UserWhitespacable"],
    fields: {
      id: validateOptionalType("Identifier"),
      key: validateType("FlowType"),
      value: validateType("FlowType"),
      "static": validate$5(assertValueType("boolean")),
      variance: validateOptionalType("Variance")
    }
  });
  defineType("ObjectTypeProperty", {
    visitor: ["key", "value", "variance"],
    aliases: ["Flow", "UserWhitespacable"],
    fields: {
      key: validateType(["Identifier", "StringLiteral"]),
      value: validateType("FlowType"),
      kind: validate$5(assertOneOf("init", "get", "set")),
      "static": validate$5(assertValueType("boolean")),
      proto: validate$5(assertValueType("boolean")),
      optional: validate$5(assertValueType("boolean")),
      variance: validateOptionalType("Variance"),
      method: validate$5(assertValueType("boolean"))
    }
  });
  defineType("ObjectTypeSpreadProperty", {
    visitor: ["argument"],
    aliases: ["Flow", "UserWhitespacable"],
    fields: {
      argument: validateType("FlowType")
    }
  });
  defineType("OpaqueType", {
    visitor: ["id", "typeParameters", "supertype", "impltype"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      id: validateType("Identifier"),
      typeParameters: validateOptionalType("TypeParameterDeclaration"),
      supertype: validateOptionalType("FlowType"),
      impltype: validateType("FlowType")
    }
  });
  defineType("QualifiedTypeIdentifier", {
    visitor: ["id", "qualification"],
    aliases: ["Flow"],
    fields: {
      id: validateType("Identifier"),
      qualification: validateType(["Identifier", "QualifiedTypeIdentifier"])
    }
  });
  defineType("StringLiteralTypeAnnotation", {
    builder: ["value"],
    aliases: ["Flow", "FlowType"],
    fields: {
      value: validate$5(assertValueType("string"))
    }
  });
  defineType("StringTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("SymbolTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("ThisTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("TupleTypeAnnotation", {
    visitor: ["types"],
    aliases: ["Flow", "FlowType"],
    fields: {
      types: validate$5(arrayOfType("FlowType"))
    }
  });
  defineType("TypeofTypeAnnotation", {
    visitor: ["argument"],
    aliases: ["Flow", "FlowType"],
    fields: {
      argument: validateType("FlowType")
    }
  });
  defineType("TypeAlias", {
    visitor: ["id", "typeParameters", "right"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {
      id: validateType("Identifier"),
      typeParameters: validateOptionalType("TypeParameterDeclaration"),
      right: validateType("FlowType")
    }
  });
  defineType("TypeAnnotation", {
    aliases: ["Flow"],
    visitor: ["typeAnnotation"],
    fields: {
      typeAnnotation: validateType("FlowType")
    }
  });
  defineType("TypeCastExpression", {
    visitor: ["expression", "typeAnnotation"],
    aliases: ["Flow", "ExpressionWrapper", "Expression"],
    fields: {
      expression: validateType("Expression"),
      typeAnnotation: validateType("TypeAnnotation")
    }
  });
  defineType("TypeParameter", {
    aliases: ["Flow"],
    visitor: ["bound", "default", "variance"],
    fields: {
      name: validate$5(assertValueType("string")),
      bound: validateOptionalType("TypeAnnotation"),
      "default": validateOptionalType("FlowType"),
      variance: validateOptionalType("Variance")
    }
  });
  defineType("TypeParameterDeclaration", {
    aliases: ["Flow"],
    visitor: ["params"],
    fields: {
      params: validate$5(arrayOfType("TypeParameter"))
    }
  });
  defineType("TypeParameterInstantiation", {
    aliases: ["Flow"],
    visitor: ["params"],
    fields: {
      params: validate$5(arrayOfType("FlowType"))
    }
  });
  defineType("UnionTypeAnnotation", {
    visitor: ["types"],
    aliases: ["Flow", "FlowType"],
    fields: {
      types: validate$5(arrayOfType("FlowType"))
    }
  });
  defineType("Variance", {
    aliases: ["Flow"],
    builder: ["kind"],
    fields: {
      kind: validate$5(assertOneOf("minus", "plus"))
    }
  });
  defineType("VoidTypeAnnotation", {
    aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
  });
  defineType("EnumDeclaration", {
    aliases: ["Statement", "Declaration"],
    visitor: ["id", "body"],
    fields: {
      id: validateType("Identifier"),
      body: validateType(["EnumBooleanBody", "EnumNumberBody", "EnumStringBody", "EnumSymbolBody"])
    }
  });
  defineType("EnumBooleanBody", {
    aliases: ["EnumBody"],
    visitor: ["members"],
    fields: {
      explicitType: validate$5(assertValueType("boolean")),
      members: validateArrayOfType("EnumBooleanMember"),
      hasUnknownMembers: validate$5(assertValueType("boolean"))
    }
  });
  defineType("EnumNumberBody", {
    aliases: ["EnumBody"],
    visitor: ["members"],
    fields: {
      explicitType: validate$5(assertValueType("boolean")),
      members: validateArrayOfType("EnumNumberMember"),
      hasUnknownMembers: validate$5(assertValueType("boolean"))
    }
  });
  defineType("EnumStringBody", {
    aliases: ["EnumBody"],
    visitor: ["members"],
    fields: {
      explicitType: validate$5(assertValueType("boolean")),
      members: validateArrayOfType(["EnumStringMember", "EnumDefaultedMember"]),
      hasUnknownMembers: validate$5(assertValueType("boolean"))
    }
  });
  defineType("EnumSymbolBody", {
    aliases: ["EnumBody"],
    visitor: ["members"],
    fields: {
      members: validateArrayOfType("EnumDefaultedMember"),
      hasUnknownMembers: validate$5(assertValueType("boolean"))
    }
  });
  defineType("EnumBooleanMember", {
    aliases: ["EnumMember"],
    visitor: ["id"],
    fields: {
      id: validateType("Identifier"),
      init: validateType("BooleanLiteral")
    }
  });
  defineType("EnumNumberMember", {
    aliases: ["EnumMember"],
    visitor: ["id", "init"],
    fields: {
      id: validateType("Identifier"),
      init: validateType("NumericLiteral")
    }
  });
  defineType("EnumStringMember", {
    aliases: ["EnumMember"],
    visitor: ["id", "init"],
    fields: {
      id: validateType("Identifier"),
      init: validateType("StringLiteral")
    }
  });
  defineType("EnumDefaultedMember", {
    aliases: ["EnumMember"],
    visitor: ["id"],
    fields: {
      id: validateType("Identifier")
    }
  });
  defineType("IndexedAccessType", {
    visitor: ["objectType", "indexType"],
    aliases: ["Flow", "FlowType"],
    fields: {
      objectType: validateType("FlowType"),
      indexType: validateType("FlowType")
    }
  });
  defineType("OptionalIndexedAccessType", {
    visitor: ["objectType", "indexType"],
    aliases: ["Flow", "FlowType"],
    fields: {
      objectType: validateType("FlowType"),
      indexType: validateType("FlowType"),
      optional: validate$5(assertValueType("boolean"))
    }
  });

  defineType("JSXAttribute", {
    visitor: ["name", "value"],
    aliases: ["JSX", "Immutable"],
    fields: {
      name: {
        validate: assertNodeType("JSXIdentifier", "JSXNamespacedName")
      },
      value: {
        optional: true,
        validate: assertNodeType("JSXElement", "JSXFragment", "StringLiteral", "JSXExpressionContainer")
      }
    }
  });
  defineType("JSXClosingElement", {
    visitor: ["name"],
    aliases: ["JSX", "Immutable"],
    fields: {
      name: {
        validate: assertNodeType("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
      }
    }
  });
  defineType("JSXElement", {
    builder: ["openingElement", "closingElement", "children", "selfClosing"],
    visitor: ["openingElement", "children", "closingElement"],
    aliases: ["JSX", "Immutable", "Expression"],
    fields: {
      openingElement: {
        validate: assertNodeType("JSXOpeningElement")
      },
      closingElement: {
        optional: true,
        validate: assertNodeType("JSXClosingElement")
      },
      children: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")))
      },
      selfClosing: {
        validate: assertValueType("boolean"),
        optional: true
      }
    }
  });
  defineType("JSXEmptyExpression", {
    aliases: ["JSX"]
  });
  defineType("JSXExpressionContainer", {
    visitor: ["expression"],
    aliases: ["JSX", "Immutable"],
    fields: {
      expression: {
        validate: assertNodeType("Expression", "JSXEmptyExpression")
      }
    }
  });
  defineType("JSXSpreadChild", {
    visitor: ["expression"],
    aliases: ["JSX", "Immutable"],
    fields: {
      expression: {
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("JSXIdentifier", {
    builder: ["name"],
    aliases: ["JSX"],
    fields: {
      name: {
        validate: assertValueType("string")
      }
    }
  });
  defineType("JSXMemberExpression", {
    visitor: ["object", "property"],
    aliases: ["JSX"],
    fields: {
      object: {
        validate: assertNodeType("JSXMemberExpression", "JSXIdentifier")
      },
      property: {
        validate: assertNodeType("JSXIdentifier")
      }
    }
  });
  defineType("JSXNamespacedName", {
    visitor: ["namespace", "name"],
    aliases: ["JSX"],
    fields: {
      namespace: {
        validate: assertNodeType("JSXIdentifier")
      },
      name: {
        validate: assertNodeType("JSXIdentifier")
      }
    }
  });
  defineType("JSXOpeningElement", {
    builder: ["name", "attributes", "selfClosing"],
    visitor: ["name", "attributes"],
    aliases: ["JSX", "Immutable"],
    fields: {
      name: {
        validate: assertNodeType("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
      },
      selfClosing: {
        "default": false
      },
      attributes: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("JSXAttribute", "JSXSpreadAttribute")))
      },
      typeParameters: {
        validate: assertNodeType("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
        optional: true
      }
    }
  });
  defineType("JSXSpreadAttribute", {
    visitor: ["argument"],
    aliases: ["JSX"],
    fields: {
      argument: {
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("JSXText", {
    aliases: ["JSX", "Immutable"],
    builder: ["value"],
    fields: {
      value: {
        validate: assertValueType("string")
      }
    }
  });
  defineType("JSXFragment", {
    builder: ["openingFragment", "closingFragment", "children"],
    visitor: ["openingFragment", "children", "closingFragment"],
    aliases: ["JSX", "Immutable", "Expression"],
    fields: {
      openingFragment: {
        validate: assertNodeType("JSXOpeningFragment")
      },
      closingFragment: {
        validate: assertNodeType("JSXClosingFragment")
      },
      children: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")))
      }
    }
  });
  defineType("JSXOpeningFragment", {
    aliases: ["JSX", "Immutable"]
  });
  defineType("JSXClosingFragment", {
    aliases: ["JSX", "Immutable"]
  });

  var PLACEHOLDERS = ["Identifier", "StringLiteral", "Expression", "Statement", "Declaration", "BlockStatement", "ClassBody", "Pattern"];
  var PLACEHOLDERS_ALIAS = {
    Declaration: ["Statement"],
    Pattern: ["PatternLike", "LVal"]
  };

  for (var _i$3 = 0, _PLACEHOLDERS = PLACEHOLDERS; _i$3 < _PLACEHOLDERS.length; _i$3++) {
    var type$2 = _PLACEHOLDERS[_i$3];
    var alias = ALIAS_KEYS[type$2];
    if (alias != null && alias.length) PLACEHOLDERS_ALIAS[type$2] = alias;
  }

  var PLACEHOLDERS_FLIPPED_ALIAS = {};
  Object.keys(PLACEHOLDERS_ALIAS).forEach(function (type) {
    PLACEHOLDERS_ALIAS[type].forEach(function (alias) {
      if (!Object.hasOwnProperty.call(PLACEHOLDERS_FLIPPED_ALIAS, alias)) {
        PLACEHOLDERS_FLIPPED_ALIAS[alias] = [];
      }

      PLACEHOLDERS_FLIPPED_ALIAS[alias].push(type);
    });
  });

  {
    defineType("Noop", {
      visitor: []
    });
  }
  defineType("Placeholder", {
    visitor: [],
    builder: ["expectedNode", "name"],
    fields: {
      name: {
        validate: assertNodeType("Identifier")
      },
      expectedNode: {
        validate: assertOneOf.apply(void 0, _toConsumableArray(PLACEHOLDERS))
      }
    }
  });
  defineType("V8IntrinsicIdentifier", {
    builder: ["name"],
    fields: {
      name: {
        validate: assertValueType("string")
      }
    }
  });

  defineType("ArgumentPlaceholder", {});
  defineType("BindExpression", {
    visitor: ["object", "callee"],
    aliases: ["Expression"],
    fields: !browser$6.env.BABEL_TYPES_8_BREAKING ? {
      object: {
        validate: Object.assign(function () {}, {
          oneOfNodeTypes: ["Expression"]
        })
      },
      callee: {
        validate: Object.assign(function () {}, {
          oneOfNodeTypes: ["Expression"]
        })
      }
    } : {
      object: {
        validate: assertNodeType("Expression")
      },
      callee: {
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("ImportAttribute", {
    visitor: ["key", "value"],
    fields: {
      key: {
        validate: assertNodeType("Identifier", "StringLiteral")
      },
      value: {
        validate: assertNodeType("StringLiteral")
      }
    }
  });
  defineType("Decorator", {
    visitor: ["expression"],
    fields: {
      expression: {
        validate: assertNodeType("Expression")
      }
    }
  });
  defineType("DoExpression", {
    visitor: ["body"],
    builder: ["body", "async"],
    aliases: ["Expression"],
    fields: {
      body: {
        validate: assertNodeType("BlockStatement")
      },
      async: {
        validate: assertValueType("boolean"),
        "default": false
      }
    }
  });
  defineType("ExportDefaultSpecifier", {
    visitor: ["exported"],
    aliases: ["ModuleSpecifier"],
    fields: {
      exported: {
        validate: assertNodeType("Identifier")
      }
    }
  });
  defineType("RecordExpression", {
    visitor: ["properties"],
    aliases: ["Expression"],
    fields: {
      properties: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("ObjectProperty", "SpreadElement")))
      }
    }
  });
  defineType("TupleExpression", {
    fields: {
      elements: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Expression", "SpreadElement"))),
        "default": []
      }
    },
    visitor: ["elements"],
    aliases: ["Expression"]
  });
  defineType("DecimalLiteral", {
    builder: ["value"],
    fields: {
      value: {
        validate: assertValueType("string")
      }
    },
    aliases: ["Expression", "Pureish", "Literal", "Immutable"]
  });
  defineType("StaticBlock", {
    visitor: ["body"],
    fields: {
      body: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Statement")))
      }
    },
    aliases: ["Scopable", "BlockParent"]
  });
  defineType("ModuleExpression", {
    visitor: ["body"],
    fields: {
      body: {
        validate: assertNodeType("Program")
      }
    },
    aliases: ["Expression"]
  });
  defineType("TopicReference", {
    aliases: ["Expression"]
  });
  defineType("PipelineTopicExpression", {
    builder: ["expression"],
    visitor: ["expression"],
    fields: {
      expression: {
        validate: assertNodeType("Expression")
      }
    },
    aliases: ["Expression"]
  });
  defineType("PipelineBareFunction", {
    builder: ["callee"],
    visitor: ["callee"],
    fields: {
      callee: {
        validate: assertNodeType("Expression")
      }
    },
    aliases: ["Expression"]
  });
  defineType("PipelinePrimaryTopicReference", {
    aliases: ["Expression"]
  });

  var bool = assertValueType("boolean");
  var tSFunctionTypeAnnotationCommon = {
    returnType: {
      validate: assertNodeType("TSTypeAnnotation", "Noop"),
      optional: true
    },
    typeParameters: {
      validate: assertNodeType("TSTypeParameterDeclaration", "Noop"),
      optional: true
    }
  };
  defineType("TSParameterProperty", {
    aliases: ["LVal"],
    visitor: ["parameter"],
    fields: {
      accessibility: {
        validate: assertOneOf("public", "private", "protected"),
        optional: true
      },
      readonly: {
        validate: assertValueType("boolean"),
        optional: true
      },
      parameter: {
        validate: assertNodeType("Identifier", "AssignmentPattern")
      },
      override: {
        validate: assertValueType("boolean"),
        optional: true
      },
      decorators: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("Decorator"))),
        optional: true
      }
    }
  });
  defineType("TSDeclareFunction", {
    aliases: ["Statement", "Declaration"],
    visitor: ["id", "typeParameters", "params", "returnType"],
    fields: Object.assign({}, functionDeclarationCommon, tSFunctionTypeAnnotationCommon)
  });
  defineType("TSDeclareMethod", {
    visitor: ["decorators", "key", "typeParameters", "params", "returnType"],
    fields: Object.assign({}, classMethodOrDeclareMethodCommon, tSFunctionTypeAnnotationCommon)
  });
  defineType("TSQualifiedName", {
    aliases: ["TSEntityName"],
    visitor: ["left", "right"],
    fields: {
      left: validateType("TSEntityName"),
      right: validateType("Identifier")
    }
  });
  var signatureDeclarationCommon = {
    typeParameters: validateOptionalType("TSTypeParameterDeclaration"),
    parameters: validateArrayOfType(["Identifier", "RestElement"]),
    typeAnnotation: validateOptionalType("TSTypeAnnotation")
  };
  var callConstructSignatureDeclaration = {
    aliases: ["TSTypeElement"],
    visitor: ["typeParameters", "parameters", "typeAnnotation"],
    fields: signatureDeclarationCommon
  };
  defineType("TSCallSignatureDeclaration", callConstructSignatureDeclaration);
  defineType("TSConstructSignatureDeclaration", callConstructSignatureDeclaration);
  var namedTypeElementCommon = {
    key: validateType("Expression"),
    computed: validate$5(bool),
    optional: validateOptional(bool)
  };
  defineType("TSPropertySignature", {
    aliases: ["TSTypeElement"],
    visitor: ["key", "typeAnnotation", "initializer"],
    fields: Object.assign({}, namedTypeElementCommon, {
      readonly: validateOptional(bool),
      typeAnnotation: validateOptionalType("TSTypeAnnotation"),
      initializer: validateOptionalType("Expression"),
      kind: {
        validate: assertOneOf("get", "set")
      }
    })
  });
  defineType("TSMethodSignature", {
    aliases: ["TSTypeElement"],
    visitor: ["key", "typeParameters", "parameters", "typeAnnotation"],
    fields: Object.assign({}, signatureDeclarationCommon, namedTypeElementCommon, {
      kind: {
        validate: assertOneOf("method", "get", "set")
      }
    })
  });
  defineType("TSIndexSignature", {
    aliases: ["TSTypeElement"],
    visitor: ["parameters", "typeAnnotation"],
    fields: {
      readonly: validateOptional(bool),
      "static": validateOptional(bool),
      parameters: validateArrayOfType("Identifier"),
      typeAnnotation: validateOptionalType("TSTypeAnnotation")
    }
  });
  var tsKeywordTypes = ["TSAnyKeyword", "TSBooleanKeyword", "TSBigIntKeyword", "TSIntrinsicKeyword", "TSNeverKeyword", "TSNullKeyword", "TSNumberKeyword", "TSObjectKeyword", "TSStringKeyword", "TSSymbolKeyword", "TSUndefinedKeyword", "TSUnknownKeyword", "TSVoidKeyword"];

  for (var _i$2 = 0, _tsKeywordTypes = tsKeywordTypes; _i$2 < _tsKeywordTypes.length; _i$2++) {
    var type$1 = _tsKeywordTypes[_i$2];
    defineType(type$1, {
      aliases: ["TSType", "TSBaseType"],
      visitor: [],
      fields: {}
    });
  }

  defineType("TSThisType", {
    aliases: ["TSType", "TSBaseType"],
    visitor: [],
    fields: {}
  });
  var fnOrCtrBase = {
    aliases: ["TSType"],
    visitor: ["typeParameters", "parameters", "typeAnnotation"]
  };
  defineType("TSFunctionType", Object.assign({}, fnOrCtrBase, {
    fields: signatureDeclarationCommon
  }));
  defineType("TSConstructorType", Object.assign({}, fnOrCtrBase, {
    fields: Object.assign({}, signatureDeclarationCommon, {
      "abstract": validateOptional(bool)
    })
  }));
  defineType("TSTypeReference", {
    aliases: ["TSType"],
    visitor: ["typeName", "typeParameters"],
    fields: {
      typeName: validateType("TSEntityName"),
      typeParameters: validateOptionalType("TSTypeParameterInstantiation")
    }
  });
  defineType("TSTypePredicate", {
    aliases: ["TSType"],
    visitor: ["parameterName", "typeAnnotation"],
    builder: ["parameterName", "typeAnnotation", "asserts"],
    fields: {
      parameterName: validateType(["Identifier", "TSThisType"]),
      typeAnnotation: validateOptionalType("TSTypeAnnotation"),
      asserts: validateOptional(bool)
    }
  });
  defineType("TSTypeQuery", {
    aliases: ["TSType"],
    visitor: ["exprName"],
    fields: {
      exprName: validateType(["TSEntityName", "TSImportType"])
    }
  });
  defineType("TSTypeLiteral", {
    aliases: ["TSType"],
    visitor: ["members"],
    fields: {
      members: validateArrayOfType("TSTypeElement")
    }
  });
  defineType("TSArrayType", {
    aliases: ["TSType"],
    visitor: ["elementType"],
    fields: {
      elementType: validateType("TSType")
    }
  });
  defineType("TSTupleType", {
    aliases: ["TSType"],
    visitor: ["elementTypes"],
    fields: {
      elementTypes: validateArrayOfType(["TSType", "TSNamedTupleMember"])
    }
  });
  defineType("TSOptionalType", {
    aliases: ["TSType"],
    visitor: ["typeAnnotation"],
    fields: {
      typeAnnotation: validateType("TSType")
    }
  });
  defineType("TSRestType", {
    aliases: ["TSType"],
    visitor: ["typeAnnotation"],
    fields: {
      typeAnnotation: validateType("TSType")
    }
  });
  defineType("TSNamedTupleMember", {
    visitor: ["label", "elementType"],
    builder: ["label", "elementType", "optional"],
    fields: {
      label: validateType("Identifier"),
      optional: {
        validate: bool,
        "default": false
      },
      elementType: validateType("TSType")
    }
  });
  var unionOrIntersection = {
    aliases: ["TSType"],
    visitor: ["types"],
    fields: {
      types: validateArrayOfType("TSType")
    }
  };
  defineType("TSUnionType", unionOrIntersection);
  defineType("TSIntersectionType", unionOrIntersection);
  defineType("TSConditionalType", {
    aliases: ["TSType"],
    visitor: ["checkType", "extendsType", "trueType", "falseType"],
    fields: {
      checkType: validateType("TSType"),
      extendsType: validateType("TSType"),
      trueType: validateType("TSType"),
      falseType: validateType("TSType")
    }
  });
  defineType("TSInferType", {
    aliases: ["TSType"],
    visitor: ["typeParameter"],
    fields: {
      typeParameter: validateType("TSTypeParameter")
    }
  });
  defineType("TSParenthesizedType", {
    aliases: ["TSType"],
    visitor: ["typeAnnotation"],
    fields: {
      typeAnnotation: validateType("TSType")
    }
  });
  defineType("TSTypeOperator", {
    aliases: ["TSType"],
    visitor: ["typeAnnotation"],
    fields: {
      operator: validate$5(assertValueType("string")),
      typeAnnotation: validateType("TSType")
    }
  });
  defineType("TSIndexedAccessType", {
    aliases: ["TSType"],
    visitor: ["objectType", "indexType"],
    fields: {
      objectType: validateType("TSType"),
      indexType: validateType("TSType")
    }
  });
  defineType("TSMappedType", {
    aliases: ["TSType"],
    visitor: ["typeParameter", "typeAnnotation", "nameType"],
    fields: {
      readonly: validateOptional(bool),
      typeParameter: validateType("TSTypeParameter"),
      optional: validateOptional(bool),
      typeAnnotation: validateOptionalType("TSType"),
      nameType: validateOptionalType("TSType")
    }
  });
  defineType("TSLiteralType", {
    aliases: ["TSType", "TSBaseType"],
    visitor: ["literal"],
    fields: {
      literal: {
        validate: function () {
          var unaryExpression = assertNodeType("NumericLiteral", "BigIntLiteral");
          var unaryOperator = assertOneOf("-");
          var literal = assertNodeType("NumericLiteral", "StringLiteral", "BooleanLiteral", "BigIntLiteral");

          function validator(parent, key, node) {
            if (is$1("UnaryExpression", node)) {
              unaryOperator(node, "operator", node.operator);
              unaryExpression(node, "argument", node.argument);
            } else {
              literal(parent, key, node);
            }
          }

          validator.oneOfNodeTypes = ["NumericLiteral", "StringLiteral", "BooleanLiteral", "BigIntLiteral", "UnaryExpression"];
          return validator;
        }()
      }
    }
  });
  defineType("TSExpressionWithTypeArguments", {
    aliases: ["TSType"],
    visitor: ["expression", "typeParameters"],
    fields: {
      expression: validateType("TSEntityName"),
      typeParameters: validateOptionalType("TSTypeParameterInstantiation")
    }
  });
  defineType("TSInterfaceDeclaration", {
    aliases: ["Statement", "Declaration"],
    visitor: ["id", "typeParameters", "extends", "body"],
    fields: {
      declare: validateOptional(bool),
      id: validateType("Identifier"),
      typeParameters: validateOptionalType("TSTypeParameterDeclaration"),
      "extends": validateOptional(arrayOfType("TSExpressionWithTypeArguments")),
      body: validateType("TSInterfaceBody")
    }
  });
  defineType("TSInterfaceBody", {
    visitor: ["body"],
    fields: {
      body: validateArrayOfType("TSTypeElement")
    }
  });
  defineType("TSTypeAliasDeclaration", {
    aliases: ["Statement", "Declaration"],
    visitor: ["id", "typeParameters", "typeAnnotation"],
    fields: {
      declare: validateOptional(bool),
      id: validateType("Identifier"),
      typeParameters: validateOptionalType("TSTypeParameterDeclaration"),
      typeAnnotation: validateType("TSType")
    }
  });
  defineType("TSAsExpression", {
    aliases: ["Expression"],
    visitor: ["expression", "typeAnnotation"],
    fields: {
      expression: validateType("Expression"),
      typeAnnotation: validateType("TSType")
    }
  });
  defineType("TSTypeAssertion", {
    aliases: ["Expression"],
    visitor: ["typeAnnotation", "expression"],
    fields: {
      typeAnnotation: validateType("TSType"),
      expression: validateType("Expression")
    }
  });
  defineType("TSEnumDeclaration", {
    aliases: ["Statement", "Declaration"],
    visitor: ["id", "members"],
    fields: {
      declare: validateOptional(bool),
      "const": validateOptional(bool),
      id: validateType("Identifier"),
      members: validateArrayOfType("TSEnumMember"),
      initializer: validateOptionalType("Expression")
    }
  });
  defineType("TSEnumMember", {
    visitor: ["id", "initializer"],
    fields: {
      id: validateType(["Identifier", "StringLiteral"]),
      initializer: validateOptionalType("Expression")
    }
  });
  defineType("TSModuleDeclaration", {
    aliases: ["Statement", "Declaration"],
    visitor: ["id", "body"],
    fields: {
      declare: validateOptional(bool),
      global: validateOptional(bool),
      id: validateType(["Identifier", "StringLiteral"]),
      body: validateType(["TSModuleBlock", "TSModuleDeclaration"])
    }
  });
  defineType("TSModuleBlock", {
    aliases: ["Scopable", "Block", "BlockParent"],
    visitor: ["body"],
    fields: {
      body: validateArrayOfType("Statement")
    }
  });
  defineType("TSImportType", {
    aliases: ["TSType"],
    visitor: ["argument", "qualifier", "typeParameters"],
    fields: {
      argument: validateType("StringLiteral"),
      qualifier: validateOptionalType("TSEntityName"),
      typeParameters: validateOptionalType("TSTypeParameterInstantiation")
    }
  });
  defineType("TSImportEqualsDeclaration", {
    aliases: ["Statement"],
    visitor: ["id", "moduleReference"],
    fields: {
      isExport: validate$5(bool),
      id: validateType("Identifier"),
      moduleReference: validateType(["TSEntityName", "TSExternalModuleReference"]),
      importKind: {
        validate: assertOneOf("type", "value"),
        optional: true
      }
    }
  });
  defineType("TSExternalModuleReference", {
    visitor: ["expression"],
    fields: {
      expression: validateType("StringLiteral")
    }
  });
  defineType("TSNonNullExpression", {
    aliases: ["Expression"],
    visitor: ["expression"],
    fields: {
      expression: validateType("Expression")
    }
  });
  defineType("TSExportAssignment", {
    aliases: ["Statement"],
    visitor: ["expression"],
    fields: {
      expression: validateType("Expression")
    }
  });
  defineType("TSNamespaceExportDeclaration", {
    aliases: ["Statement"],
    visitor: ["id"],
    fields: {
      id: validateType("Identifier")
    }
  });
  defineType("TSTypeAnnotation", {
    visitor: ["typeAnnotation"],
    fields: {
      typeAnnotation: {
        validate: assertNodeType("TSType")
      }
    }
  });
  defineType("TSTypeParameterInstantiation", {
    visitor: ["params"],
    fields: {
      params: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("TSType")))
      }
    }
  });
  defineType("TSTypeParameterDeclaration", {
    visitor: ["params"],
    fields: {
      params: {
        validate: chain$1(assertValueType("array"), assertEach(assertNodeType("TSTypeParameter")))
      }
    }
  });
  defineType("TSTypeParameter", {
    builder: ["constraint", "default", "name"],
    visitor: ["constraint", "default"],
    fields: {
      name: {
        validate: assertValueType("string")
      },
      constraint: {
        validate: assertNodeType("TSType"),
        optional: true
      },
      "default": {
        validate: assertNodeType("TSType"),
        optional: true
      }
    }
  });

  toFastProperties(VISITOR_KEYS$6);
  toFastProperties(ALIAS_KEYS);
  toFastProperties(FLIPPED_ALIAS_KEYS$3);
  toFastProperties(NODE_FIELDS);
  toFastProperties(BUILDER_KEYS);
  toFastProperties(DEPRECATED_KEYS$1);
  toFastProperties(PLACEHOLDERS_ALIAS);
  toFastProperties(PLACEHOLDERS_FLIPPED_ALIAS);
  var TYPES$1 = Object.keys(VISITOR_KEYS$6).concat(Object.keys(FLIPPED_ALIAS_KEYS$3)).concat(Object.keys(DEPRECATED_KEYS$1));

  function builder(type) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var keys = BUILDER_KEYS[type];
    var countArgs = args.length;

    if (countArgs > keys.length) {
      throw new Error(type + ": Too many arguments passed. Received " + countArgs + " but can receive no more than " + keys.length);
    }

    var node = {
      type: type
    };
    var i = 0;
    keys.forEach(function (key) {
      var field = NODE_FIELDS[type][key];
      var arg;
      if (i < countArgs) arg = args[i];

      if (arg === undefined) {
        arg = Array.isArray(field["default"]) ? [] : field["default"];
      }

      node[key] = arg;
      i++;
    });

    for (var _i = 0, _Object$keys = Object.keys(node); _i < _Object$keys.length; _i++) {
      var key = _Object$keys[_i];
      validate$6(node, key, node[key]);
    }

    return node;
  }

  function arrayExpression$2(elements) {
    return builder.apply(void 0, ["ArrayExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function assignmentExpression$c(operator, left, right) {
    return builder.apply(void 0, ["AssignmentExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function binaryExpression$4(operator, left, right) {
    return builder.apply(void 0, ["BinaryExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function interpreterDirective$1(value) {
    return builder.apply(void 0, ["InterpreterDirective"].concat(Array.prototype.slice.call(arguments)));
  }
  function directive$1(value) {
    return builder.apply(void 0, ["Directive"].concat(Array.prototype.slice.call(arguments)));
  }
  function directiveLiteral$1(value) {
    return builder.apply(void 0, ["DirectiveLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function blockStatement$6(body, directives) {
    return builder.apply(void 0, ["BlockStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function breakStatement(label) {
    return builder.apply(void 0, ["BreakStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function callExpression$e(callee, _arguments) {
    return builder.apply(void 0, ["CallExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function catchClause(param, body) {
    return builder.apply(void 0, ["CatchClause"].concat(Array.prototype.slice.call(arguments)));
  }
  function conditionalExpression$3(test, consequent, alternate) {
    return builder.apply(void 0, ["ConditionalExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function continueStatement(label) {
    return builder.apply(void 0, ["ContinueStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function debuggerStatement() {
    return builder.apply(void 0, ["DebuggerStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function doWhileStatement(test, body) {
    return builder.apply(void 0, ["DoWhileStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function emptyStatement$1() {
    return builder.apply(void 0, ["EmptyStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function expressionStatement$a(expression) {
    return builder.apply(void 0, ["ExpressionStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function file$1(program, comments, tokens) {
    return builder.apply(void 0, ["File"].concat(Array.prototype.slice.call(arguments)));
  }
  function forInStatement(left, right, body) {
    return builder.apply(void 0, ["ForInStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function forStatement(init, test, update, body) {
    return builder.apply(void 0, ["ForStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function functionDeclaration(id, params, body, generator, async) {
    return builder.apply(void 0, ["FunctionDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function functionExpression$3(id, params, body, generator, async) {
    return builder.apply(void 0, ["FunctionExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function identifier$j(name) {
    return builder.apply(void 0, ["Identifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function ifStatement(test, consequent, alternate) {
    return builder.apply(void 0, ["IfStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function labeledStatement(label, body) {
    return builder.apply(void 0, ["LabeledStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function stringLiteral$8(value) {
    return builder.apply(void 0, ["StringLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function numericLiteral$8(value) {
    return builder.apply(void 0, ["NumericLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function nullLiteral$2() {
    return builder.apply(void 0, ["NullLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function booleanLiteral$5(value) {
    return builder.apply(void 0, ["BooleanLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function regExpLiteral(pattern, flags) {
    return builder.apply(void 0, ["RegExpLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function logicalExpression$2(operator, left, right) {
    return builder.apply(void 0, ["LogicalExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function memberExpression$b(object, property, computed, optional) {
    return builder.apply(void 0, ["MemberExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function newExpression(callee, _arguments) {
    return builder.apply(void 0, ["NewExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function program$3(body, directives, sourceType, interpreter) {
    return builder.apply(void 0, ["Program"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectExpression$4(properties) {
    return builder.apply(void 0, ["ObjectExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectMethod(kind, key, params, body, computed, generator, async) {
    return builder.apply(void 0, ["ObjectMethod"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectProperty$2(key, value, computed, shorthand, decorators) {
    return builder.apply(void 0, ["ObjectProperty"].concat(Array.prototype.slice.call(arguments)));
  }
  function restElement$1(argument) {
    return builder.apply(void 0, ["RestElement"].concat(Array.prototype.slice.call(arguments)));
  }
  function returnStatement$3(argument) {
    return builder.apply(void 0, ["ReturnStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function sequenceExpression$7(expressions) {
    return builder.apply(void 0, ["SequenceExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function parenthesizedExpression(expression) {
    return builder.apply(void 0, ["ParenthesizedExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function switchCase(test, consequent) {
    return builder.apply(void 0, ["SwitchCase"].concat(Array.prototype.slice.call(arguments)));
  }
  function switchStatement(discriminant, cases) {
    return builder.apply(void 0, ["SwitchStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function thisExpression$3() {
    return builder.apply(void 0, ["ThisExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function throwStatement(argument) {
    return builder.apply(void 0, ["ThrowStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function tryStatement(block, handler, finalizer) {
    return builder.apply(void 0, ["TryStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function unaryExpression$7(operator, argument, prefix) {
    return builder.apply(void 0, ["UnaryExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function updateExpression(operator, argument, prefix) {
    return builder.apply(void 0, ["UpdateExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function variableDeclaration$8(kind, declarations) {
    return builder.apply(void 0, ["VariableDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function variableDeclarator$8(id, init) {
    return builder.apply(void 0, ["VariableDeclarator"].concat(Array.prototype.slice.call(arguments)));
  }
  function whileStatement(test, body) {
    return builder.apply(void 0, ["WhileStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function withStatement(object, body) {
    return builder.apply(void 0, ["WithStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function assignmentPattern(left, right) {
    return builder.apply(void 0, ["AssignmentPattern"].concat(Array.prototype.slice.call(arguments)));
  }
  function arrayPattern(elements) {
    return builder.apply(void 0, ["ArrayPattern"].concat(Array.prototype.slice.call(arguments)));
  }
  function arrowFunctionExpression$4(params, body, async) {
    return builder.apply(void 0, ["ArrowFunctionExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function classBody(body) {
    return builder.apply(void 0, ["ClassBody"].concat(Array.prototype.slice.call(arguments)));
  }
  function classExpression(id, superClass, body, decorators) {
    return builder.apply(void 0, ["ClassExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function classDeclaration(id, superClass, body, decorators) {
    return builder.apply(void 0, ["ClassDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function exportAllDeclaration(source) {
    return builder.apply(void 0, ["ExportAllDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function exportDefaultDeclaration(declaration) {
    return builder.apply(void 0, ["ExportDefaultDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function exportNamedDeclaration$2(declaration, specifiers, source) {
    return builder.apply(void 0, ["ExportNamedDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function exportSpecifier$2(local, exported) {
    return builder.apply(void 0, ["ExportSpecifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function forOfStatement(left, right, body, _await) {
    return builder.apply(void 0, ["ForOfStatement"].concat(Array.prototype.slice.call(arguments)));
  }
  function importDeclaration$1(specifiers, source) {
    return builder.apply(void 0, ["ImportDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function importDefaultSpecifier$1(local) {
    return builder.apply(void 0, ["ImportDefaultSpecifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function importNamespaceSpecifier$1(local) {
    return builder.apply(void 0, ["ImportNamespaceSpecifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function importSpecifier$1(local, imported) {
    return builder.apply(void 0, ["ImportSpecifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function metaProperty$1(meta, property) {
    return builder.apply(void 0, ["MetaProperty"].concat(Array.prototype.slice.call(arguments)));
  }
  function classMethod(kind, key, params, body, computed, _static, generator, async) {
    return builder.apply(void 0, ["ClassMethod"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectPattern(properties) {
    return builder.apply(void 0, ["ObjectPattern"].concat(Array.prototype.slice.call(arguments)));
  }
  function spreadElement$2(argument) {
    return builder.apply(void 0, ["SpreadElement"].concat(Array.prototype.slice.call(arguments)));
  }

  function _super$1() {
    return builder.apply(void 0, ["Super"].concat(Array.prototype.slice.call(arguments)));
  }
  function taggedTemplateExpression(tag, quasi) {
    return builder.apply(void 0, ["TaggedTemplateExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function templateElement(value, tail) {
    return builder.apply(void 0, ["TemplateElement"].concat(Array.prototype.slice.call(arguments)));
  }
  function templateLiteral(quasis, expressions) {
    return builder.apply(void 0, ["TemplateLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function yieldExpression$2(argument, delegate) {
    return builder.apply(void 0, ["YieldExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function awaitExpression$1(argument) {
    return builder.apply(void 0, ["AwaitExpression"].concat(Array.prototype.slice.call(arguments)));
  }

  function _import() {
    return builder.apply(void 0, ["Import"].concat(Array.prototype.slice.call(arguments)));
  }
  function bigIntLiteral(value) {
    return builder.apply(void 0, ["BigIntLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function exportNamespaceSpecifier(exported) {
    return builder.apply(void 0, ["ExportNamespaceSpecifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function optionalMemberExpression$2(object, property, computed, optional) {
    return builder.apply(void 0, ["OptionalMemberExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function optionalCallExpression$2(callee, _arguments, optional) {
    return builder.apply(void 0, ["OptionalCallExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function classProperty(key, value, typeAnnotation, decorators, computed, _static) {
    return builder.apply(void 0, ["ClassProperty"].concat(Array.prototype.slice.call(arguments)));
  }
  function classPrivateProperty(key, value, decorators, _static) {
    return builder.apply(void 0, ["ClassPrivateProperty"].concat(Array.prototype.slice.call(arguments)));
  }
  function classPrivateMethod(kind, key, params, body, _static) {
    return builder.apply(void 0, ["ClassPrivateMethod"].concat(Array.prototype.slice.call(arguments)));
  }
  function privateName(id) {
    return builder.apply(void 0, ["PrivateName"].concat(Array.prototype.slice.call(arguments)));
  }
  function anyTypeAnnotation$2() {
    return builder.apply(void 0, ["AnyTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function arrayTypeAnnotation$1(elementType) {
    return builder.apply(void 0, ["ArrayTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function booleanTypeAnnotation$1() {
    return builder.apply(void 0, ["BooleanTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function booleanLiteralTypeAnnotation(value) {
    return builder.apply(void 0, ["BooleanLiteralTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function nullLiteralTypeAnnotation$1() {
    return builder.apply(void 0, ["NullLiteralTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function classImplements(id, typeParameters) {
    return builder.apply(void 0, ["ClassImplements"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareClass(id, typeParameters, _extends, body) {
    return builder.apply(void 0, ["DeclareClass"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareFunction(id) {
    return builder.apply(void 0, ["DeclareFunction"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareInterface(id, typeParameters, _extends, body) {
    return builder.apply(void 0, ["DeclareInterface"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareModule(id, body, kind) {
    return builder.apply(void 0, ["DeclareModule"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareModuleExports(typeAnnotation) {
    return builder.apply(void 0, ["DeclareModuleExports"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareTypeAlias(id, typeParameters, right) {
    return builder.apply(void 0, ["DeclareTypeAlias"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareOpaqueType(id, typeParameters, supertype) {
    return builder.apply(void 0, ["DeclareOpaqueType"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareVariable(id) {
    return builder.apply(void 0, ["DeclareVariable"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareExportDeclaration(declaration, specifiers, source) {
    return builder.apply(void 0, ["DeclareExportDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function declareExportAllDeclaration(source) {
    return builder.apply(void 0, ["DeclareExportAllDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function declaredPredicate(value) {
    return builder.apply(void 0, ["DeclaredPredicate"].concat(Array.prototype.slice.call(arguments)));
  }
  function existsTypeAnnotation() {
    return builder.apply(void 0, ["ExistsTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function functionTypeAnnotation(typeParameters, params, rest, returnType) {
    return builder.apply(void 0, ["FunctionTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function functionTypeParam(name, typeAnnotation) {
    return builder.apply(void 0, ["FunctionTypeParam"].concat(Array.prototype.slice.call(arguments)));
  }
  function genericTypeAnnotation$1(id, typeParameters) {
    return builder.apply(void 0, ["GenericTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function inferredPredicate() {
    return builder.apply(void 0, ["InferredPredicate"].concat(Array.prototype.slice.call(arguments)));
  }
  function interfaceExtends(id, typeParameters) {
    return builder.apply(void 0, ["InterfaceExtends"].concat(Array.prototype.slice.call(arguments)));
  }
  function interfaceDeclaration(id, typeParameters, _extends, body) {
    return builder.apply(void 0, ["InterfaceDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function interfaceTypeAnnotation(_extends, body) {
    return builder.apply(void 0, ["InterfaceTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function intersectionTypeAnnotation(types) {
    return builder.apply(void 0, ["IntersectionTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function mixedTypeAnnotation() {
    return builder.apply(void 0, ["MixedTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function emptyTypeAnnotation() {
    return builder.apply(void 0, ["EmptyTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function nullableTypeAnnotation(typeAnnotation) {
    return builder.apply(void 0, ["NullableTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function numberLiteralTypeAnnotation(value) {
    return builder.apply(void 0, ["NumberLiteralTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function numberTypeAnnotation$2() {
    return builder.apply(void 0, ["NumberTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectTypeAnnotation(properties, indexers, callProperties, internalSlots, exact) {
    return builder.apply(void 0, ["ObjectTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectTypeInternalSlot(id, value, optional, _static, method) {
    return builder.apply(void 0, ["ObjectTypeInternalSlot"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectTypeCallProperty(value) {
    return builder.apply(void 0, ["ObjectTypeCallProperty"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectTypeIndexer(id, key, value, variance) {
    return builder.apply(void 0, ["ObjectTypeIndexer"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectTypeProperty(key, value, variance) {
    return builder.apply(void 0, ["ObjectTypeProperty"].concat(Array.prototype.slice.call(arguments)));
  }
  function objectTypeSpreadProperty(argument) {
    return builder.apply(void 0, ["ObjectTypeSpreadProperty"].concat(Array.prototype.slice.call(arguments)));
  }
  function opaqueType(id, typeParameters, supertype, impltype) {
    return builder.apply(void 0, ["OpaqueType"].concat(Array.prototype.slice.call(arguments)));
  }
  function qualifiedTypeIdentifier(id, qualification) {
    return builder.apply(void 0, ["QualifiedTypeIdentifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function stringLiteralTypeAnnotation(value) {
    return builder.apply(void 0, ["StringLiteralTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function stringTypeAnnotation$2() {
    return builder.apply(void 0, ["StringTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function symbolTypeAnnotation() {
    return builder.apply(void 0, ["SymbolTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function thisTypeAnnotation() {
    return builder.apply(void 0, ["ThisTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function tupleTypeAnnotation$1(types) {
    return builder.apply(void 0, ["TupleTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function typeofTypeAnnotation(argument) {
    return builder.apply(void 0, ["TypeofTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function typeAlias(id, typeParameters, right) {
    return builder.apply(void 0, ["TypeAlias"].concat(Array.prototype.slice.call(arguments)));
  }
  function typeAnnotation(typeAnnotation) {
    return builder.apply(void 0, ["TypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function typeCastExpression(expression, typeAnnotation) {
    return builder.apply(void 0, ["TypeCastExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function typeParameter(bound, _default, variance) {
    return builder.apply(void 0, ["TypeParameter"].concat(Array.prototype.slice.call(arguments)));
  }
  function typeParameterDeclaration(params) {
    return builder.apply(void 0, ["TypeParameterDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function typeParameterInstantiation(params) {
    return builder.apply(void 0, ["TypeParameterInstantiation"].concat(Array.prototype.slice.call(arguments)));
  }
  function unionTypeAnnotation$1(types) {
    return builder.apply(void 0, ["UnionTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function variance(kind) {
    return builder.apply(void 0, ["Variance"].concat(Array.prototype.slice.call(arguments)));
  }
  function voidTypeAnnotation$3() {
    return builder.apply(void 0, ["VoidTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function enumDeclaration(id, body) {
    return builder.apply(void 0, ["EnumDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function enumBooleanBody(members) {
    return builder.apply(void 0, ["EnumBooleanBody"].concat(Array.prototype.slice.call(arguments)));
  }
  function enumNumberBody(members) {
    return builder.apply(void 0, ["EnumNumberBody"].concat(Array.prototype.slice.call(arguments)));
  }
  function enumStringBody(members) {
    return builder.apply(void 0, ["EnumStringBody"].concat(Array.prototype.slice.call(arguments)));
  }
  function enumSymbolBody(members) {
    return builder.apply(void 0, ["EnumSymbolBody"].concat(Array.prototype.slice.call(arguments)));
  }
  function enumBooleanMember(id) {
    return builder.apply(void 0, ["EnumBooleanMember"].concat(Array.prototype.slice.call(arguments)));
  }
  function enumNumberMember(id, init) {
    return builder.apply(void 0, ["EnumNumberMember"].concat(Array.prototype.slice.call(arguments)));
  }
  function enumStringMember(id, init) {
    return builder.apply(void 0, ["EnumStringMember"].concat(Array.prototype.slice.call(arguments)));
  }
  function enumDefaultedMember(id) {
    return builder.apply(void 0, ["EnumDefaultedMember"].concat(Array.prototype.slice.call(arguments)));
  }
  function indexedAccessType(objectType, indexType) {
    return builder.apply(void 0, ["IndexedAccessType"].concat(Array.prototype.slice.call(arguments)));
  }
  function optionalIndexedAccessType(objectType, indexType) {
    return builder.apply(void 0, ["OptionalIndexedAccessType"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxAttribute(name, value) {
    return builder.apply(void 0, ["JSXAttribute"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxClosingElement(name) {
    return builder.apply(void 0, ["JSXClosingElement"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxElement(openingElement, closingElement, children, selfClosing) {
    return builder.apply(void 0, ["JSXElement"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxEmptyExpression() {
    return builder.apply(void 0, ["JSXEmptyExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxExpressionContainer$1(expression) {
    return builder.apply(void 0, ["JSXExpressionContainer"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxSpreadChild(expression) {
    return builder.apply(void 0, ["JSXSpreadChild"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxIdentifier$2(name) {
    return builder.apply(void 0, ["JSXIdentifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxMemberExpression$1(object, property) {
    return builder.apply(void 0, ["JSXMemberExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxNamespacedName(namespace, name) {
    return builder.apply(void 0, ["JSXNamespacedName"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxOpeningElement(name, attributes, selfClosing) {
    return builder.apply(void 0, ["JSXOpeningElement"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxSpreadAttribute(argument) {
    return builder.apply(void 0, ["JSXSpreadAttribute"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxText(value) {
    return builder.apply(void 0, ["JSXText"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxFragment(openingFragment, closingFragment, children) {
    return builder.apply(void 0, ["JSXFragment"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxOpeningFragment() {
    return builder.apply(void 0, ["JSXOpeningFragment"].concat(Array.prototype.slice.call(arguments)));
  }
  function jsxClosingFragment() {
    return builder.apply(void 0, ["JSXClosingFragment"].concat(Array.prototype.slice.call(arguments)));
  }
  function noop$1() {
    return builder.apply(void 0, ["Noop"].concat(Array.prototype.slice.call(arguments)));
  }
  function placeholder(expectedNode, name) {
    return builder.apply(void 0, ["Placeholder"].concat(Array.prototype.slice.call(arguments)));
  }
  function v8IntrinsicIdentifier(name) {
    return builder.apply(void 0, ["V8IntrinsicIdentifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function argumentPlaceholder() {
    return builder.apply(void 0, ["ArgumentPlaceholder"].concat(Array.prototype.slice.call(arguments)));
  }
  function bindExpression(object, callee) {
    return builder.apply(void 0, ["BindExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function importAttribute(key, value) {
    return builder.apply(void 0, ["ImportAttribute"].concat(Array.prototype.slice.call(arguments)));
  }
  function decorator(expression) {
    return builder.apply(void 0, ["Decorator"].concat(Array.prototype.slice.call(arguments)));
  }
  function doExpression(body, async) {
    return builder.apply(void 0, ["DoExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function exportDefaultSpecifier(exported) {
    return builder.apply(void 0, ["ExportDefaultSpecifier"].concat(Array.prototype.slice.call(arguments)));
  }
  function recordExpression(properties) {
    return builder.apply(void 0, ["RecordExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function tupleExpression(elements) {
    return builder.apply(void 0, ["TupleExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function decimalLiteral(value) {
    return builder.apply(void 0, ["DecimalLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function staticBlock$1(body) {
    return builder.apply(void 0, ["StaticBlock"].concat(Array.prototype.slice.call(arguments)));
  }
  function moduleExpression(body) {
    return builder.apply(void 0, ["ModuleExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function topicReference() {
    return builder.apply(void 0, ["TopicReference"].concat(Array.prototype.slice.call(arguments)));
  }
  function pipelineTopicExpression(expression) {
    return builder.apply(void 0, ["PipelineTopicExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function pipelineBareFunction(callee) {
    return builder.apply(void 0, ["PipelineBareFunction"].concat(Array.prototype.slice.call(arguments)));
  }
  function pipelinePrimaryTopicReference() {
    return builder.apply(void 0, ["PipelinePrimaryTopicReference"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsParameterProperty(parameter) {
    return builder.apply(void 0, ["TSParameterProperty"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsDeclareFunction(id, typeParameters, params, returnType) {
    return builder.apply(void 0, ["TSDeclareFunction"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsDeclareMethod(decorators, key, typeParameters, params, returnType) {
    return builder.apply(void 0, ["TSDeclareMethod"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsQualifiedName(left, right) {
    return builder.apply(void 0, ["TSQualifiedName"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsCallSignatureDeclaration(typeParameters, parameters, typeAnnotation) {
    return builder.apply(void 0, ["TSCallSignatureDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsConstructSignatureDeclaration(typeParameters, parameters, typeAnnotation) {
    return builder.apply(void 0, ["TSConstructSignatureDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsPropertySignature(key, typeAnnotation, initializer) {
    return builder.apply(void 0, ["TSPropertySignature"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsMethodSignature(key, typeParameters, parameters, typeAnnotation) {
    return builder.apply(void 0, ["TSMethodSignature"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsIndexSignature(parameters, typeAnnotation) {
    return builder.apply(void 0, ["TSIndexSignature"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsAnyKeyword() {
    return builder.apply(void 0, ["TSAnyKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsBooleanKeyword() {
    return builder.apply(void 0, ["TSBooleanKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsBigIntKeyword() {
    return builder.apply(void 0, ["TSBigIntKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsIntrinsicKeyword() {
    return builder.apply(void 0, ["TSIntrinsicKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsNeverKeyword() {
    return builder.apply(void 0, ["TSNeverKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsNullKeyword() {
    return builder.apply(void 0, ["TSNullKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsNumberKeyword() {
    return builder.apply(void 0, ["TSNumberKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsObjectKeyword() {
    return builder.apply(void 0, ["TSObjectKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsStringKeyword() {
    return builder.apply(void 0, ["TSStringKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsSymbolKeyword() {
    return builder.apply(void 0, ["TSSymbolKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsUndefinedKeyword() {
    return builder.apply(void 0, ["TSUndefinedKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsUnknownKeyword() {
    return builder.apply(void 0, ["TSUnknownKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsVoidKeyword() {
    return builder.apply(void 0, ["TSVoidKeyword"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsThisType() {
    return builder.apply(void 0, ["TSThisType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsFunctionType(typeParameters, parameters, typeAnnotation) {
    return builder.apply(void 0, ["TSFunctionType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsConstructorType(typeParameters, parameters, typeAnnotation) {
    return builder.apply(void 0, ["TSConstructorType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeReference(typeName, typeParameters) {
    return builder.apply(void 0, ["TSTypeReference"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypePredicate(parameterName, typeAnnotation, asserts) {
    return builder.apply(void 0, ["TSTypePredicate"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeQuery(exprName) {
    return builder.apply(void 0, ["TSTypeQuery"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeLiteral(members) {
    return builder.apply(void 0, ["TSTypeLiteral"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsArrayType(elementType) {
    return builder.apply(void 0, ["TSArrayType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTupleType(elementTypes) {
    return builder.apply(void 0, ["TSTupleType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsOptionalType(typeAnnotation) {
    return builder.apply(void 0, ["TSOptionalType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsRestType(typeAnnotation) {
    return builder.apply(void 0, ["TSRestType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsNamedTupleMember(label, elementType, optional) {
    return builder.apply(void 0, ["TSNamedTupleMember"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsUnionType(types) {
    return builder.apply(void 0, ["TSUnionType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsIntersectionType(types) {
    return builder.apply(void 0, ["TSIntersectionType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsConditionalType(checkType, extendsType, trueType, falseType) {
    return builder.apply(void 0, ["TSConditionalType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsInferType(typeParameter) {
    return builder.apply(void 0, ["TSInferType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsParenthesizedType(typeAnnotation) {
    return builder.apply(void 0, ["TSParenthesizedType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeOperator(typeAnnotation) {
    return builder.apply(void 0, ["TSTypeOperator"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsIndexedAccessType(objectType, indexType) {
    return builder.apply(void 0, ["TSIndexedAccessType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsMappedType(typeParameter, typeAnnotation, nameType) {
    return builder.apply(void 0, ["TSMappedType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsLiteralType(literal) {
    return builder.apply(void 0, ["TSLiteralType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsExpressionWithTypeArguments(expression, typeParameters) {
    return builder.apply(void 0, ["TSExpressionWithTypeArguments"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsInterfaceDeclaration(id, typeParameters, _extends, body) {
    return builder.apply(void 0, ["TSInterfaceDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsInterfaceBody(body) {
    return builder.apply(void 0, ["TSInterfaceBody"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeAliasDeclaration(id, typeParameters, typeAnnotation) {
    return builder.apply(void 0, ["TSTypeAliasDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsAsExpression(expression, typeAnnotation) {
    return builder.apply(void 0, ["TSAsExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeAssertion(typeAnnotation, expression) {
    return builder.apply(void 0, ["TSTypeAssertion"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsEnumDeclaration(id, members) {
    return builder.apply(void 0, ["TSEnumDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsEnumMember(id, initializer) {
    return builder.apply(void 0, ["TSEnumMember"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsModuleDeclaration(id, body) {
    return builder.apply(void 0, ["TSModuleDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsModuleBlock(body) {
    return builder.apply(void 0, ["TSModuleBlock"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsImportType(argument, qualifier, typeParameters) {
    return builder.apply(void 0, ["TSImportType"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsImportEqualsDeclaration(id, moduleReference) {
    return builder.apply(void 0, ["TSImportEqualsDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsExternalModuleReference(expression) {
    return builder.apply(void 0, ["TSExternalModuleReference"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsNonNullExpression(expression) {
    return builder.apply(void 0, ["TSNonNullExpression"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsExportAssignment(expression) {
    return builder.apply(void 0, ["TSExportAssignment"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsNamespaceExportDeclaration(id) {
    return builder.apply(void 0, ["TSNamespaceExportDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeAnnotation(typeAnnotation) {
    return builder.apply(void 0, ["TSTypeAnnotation"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeParameterInstantiation(params) {
    return builder.apply(void 0, ["TSTypeParameterInstantiation"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeParameterDeclaration(params) {
    return builder.apply(void 0, ["TSTypeParameterDeclaration"].concat(Array.prototype.slice.call(arguments)));
  }
  function tsTypeParameter(constraint, _default, name) {
    return builder.apply(void 0, ["TSTypeParameter"].concat(Array.prototype.slice.call(arguments)));
  }

  function NumberLiteral() {
    console.trace("The node type NumberLiteral has been renamed to NumericLiteral");

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return builder.apply(void 0, ["NumberLiteral"].concat(args));
  }

  function RegexLiteral() {
    console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return builder.apply(void 0, ["RegexLiteral"].concat(args));
  }

  function RestProperty$1() {
    console.trace("The node type RestProperty has been renamed to RestElement");

    for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    return builder.apply(void 0, ["RestProperty"].concat(args));
  }

  function SpreadProperty$1() {
    console.trace("The node type SpreadProperty has been renamed to SpreadElement");

    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    return builder.apply(void 0, ["SpreadProperty"].concat(args));
  }

  function cleanJSXElementLiteralChild(child, args) {
    var lines = child.value.split(/\r\n|\n|\r/);
    var lastNonEmptyLine = 0;

    for (var i = 0; i < lines.length; i++) {
      if (lines[i].match(/[^ \t]/)) {
        lastNonEmptyLine = i;
      }
    }

    var str = "";

    for (var _i = 0; _i < lines.length; _i++) {
      var line = lines[_i];
      var isFirstLine = _i === 0;
      var isLastLine = _i === lines.length - 1;
      var isLastNonEmptyLine = _i === lastNonEmptyLine;
      var trimmedLine = line.replace(/\t/g, " ");

      if (!isFirstLine) {
        trimmedLine = trimmedLine.replace(/^[ ]+/, "");
      }

      if (!isLastLine) {
        trimmedLine = trimmedLine.replace(/[ ]+$/, "");
      }

      if (trimmedLine) {
        if (!isLastNonEmptyLine) {
          trimmedLine += " ";
        }

        str += trimmedLine;
      }
    }

    if (str) args.push(stringLiteral$8(str));
  }

  function buildChildren(node) {
    var elements = [];

    for (var i = 0; i < node.children.length; i++) {
      var child = node.children[i];

      if (isJSXText(child)) {
        cleanJSXElementLiteralChild(child, elements);
        continue;
      }

      if (isJSXExpressionContainer$1(child)) child = child.expression;
      if (isJSXEmptyExpression(child)) continue;
      elements.push(child);
    }

    return elements;
  }

  function isNode(node) {
    return !!(node && VISITOR_KEYS$6[node.type]);
  }

  function assertNode(node) {
    if (!isNode(node)) {
      var _node$type;

      var type = (_node$type = node == null ? void 0 : node.type) != null ? _node$type : JSON.stringify(node);
      throw new TypeError("Not a valid node of type \"" + type + "\"");
    }
  }

  function assert$1(type, node, opts) {
    if (!is$1(type, node, opts)) {
      throw new Error("Expected type \"" + type + "\" with option " + JSON.stringify(opts) + ", " + ("but instead got \"" + node.type + "\"."));
    }
  }

  function assertArrayExpression(node, opts) {
    assert$1("ArrayExpression", node, opts);
  }
  function assertAssignmentExpression(node, opts) {
    assert$1("AssignmentExpression", node, opts);
  }
  function assertBinaryExpression(node, opts) {
    assert$1("BinaryExpression", node, opts);
  }
  function assertInterpreterDirective(node, opts) {
    assert$1("InterpreterDirective", node, opts);
  }
  function assertDirective(node, opts) {
    assert$1("Directive", node, opts);
  }
  function assertDirectiveLiteral(node, opts) {
    assert$1("DirectiveLiteral", node, opts);
  }
  function assertBlockStatement(node, opts) {
    assert$1("BlockStatement", node, opts);
  }
  function assertBreakStatement(node, opts) {
    assert$1("BreakStatement", node, opts);
  }
  function assertCallExpression(node, opts) {
    assert$1("CallExpression", node, opts);
  }
  function assertCatchClause(node, opts) {
    assert$1("CatchClause", node, opts);
  }
  function assertConditionalExpression(node, opts) {
    assert$1("ConditionalExpression", node, opts);
  }
  function assertContinueStatement(node, opts) {
    assert$1("ContinueStatement", node, opts);
  }
  function assertDebuggerStatement(node, opts) {
    assert$1("DebuggerStatement", node, opts);
  }
  function assertDoWhileStatement(node, opts) {
    assert$1("DoWhileStatement", node, opts);
  }
  function assertEmptyStatement(node, opts) {
    assert$1("EmptyStatement", node, opts);
  }
  function assertExpressionStatement$1(node, opts) {
    assert$1("ExpressionStatement", node, opts);
  }
  function assertFile(node, opts) {
    assert$1("File", node, opts);
  }
  function assertForInStatement(node, opts) {
    assert$1("ForInStatement", node, opts);
  }
  function assertForStatement(node, opts) {
    assert$1("ForStatement", node, opts);
  }
  function assertFunctionDeclaration(node, opts) {
    assert$1("FunctionDeclaration", node, opts);
  }
  function assertFunctionExpression(node, opts) {
    assert$1("FunctionExpression", node, opts);
  }
  function assertIdentifier(node, opts) {
    assert$1("Identifier", node, opts);
  }
  function assertIfStatement(node, opts) {
    assert$1("IfStatement", node, opts);
  }
  function assertLabeledStatement(node, opts) {
    assert$1("LabeledStatement", node, opts);
  }
  function assertStringLiteral(node, opts) {
    assert$1("StringLiteral", node, opts);
  }
  function assertNumericLiteral(node, opts) {
    assert$1("NumericLiteral", node, opts);
  }
  function assertNullLiteral(node, opts) {
    assert$1("NullLiteral", node, opts);
  }
  function assertBooleanLiteral(node, opts) {
    assert$1("BooleanLiteral", node, opts);
  }
  function assertRegExpLiteral(node, opts) {
    assert$1("RegExpLiteral", node, opts);
  }
  function assertLogicalExpression(node, opts) {
    assert$1("LogicalExpression", node, opts);
  }
  function assertMemberExpression(node, opts) {
    assert$1("MemberExpression", node, opts);
  }
  function assertNewExpression(node, opts) {
    assert$1("NewExpression", node, opts);
  }
  function assertProgram(node, opts) {
    assert$1("Program", node, opts);
  }
  function assertObjectExpression(node, opts) {
    assert$1("ObjectExpression", node, opts);
  }
  function assertObjectMethod(node, opts) {
    assert$1("ObjectMethod", node, opts);
  }
  function assertObjectProperty(node, opts) {
    assert$1("ObjectProperty", node, opts);
  }
  function assertRestElement(node, opts) {
    assert$1("RestElement", node, opts);
  }
  function assertReturnStatement(node, opts) {
    assert$1("ReturnStatement", node, opts);
  }
  function assertSequenceExpression(node, opts) {
    assert$1("SequenceExpression", node, opts);
  }
  function assertParenthesizedExpression(node, opts) {
    assert$1("ParenthesizedExpression", node, opts);
  }
  function assertSwitchCase(node, opts) {
    assert$1("SwitchCase", node, opts);
  }
  function assertSwitchStatement(node, opts) {
    assert$1("SwitchStatement", node, opts);
  }
  function assertThisExpression(node, opts) {
    assert$1("ThisExpression", node, opts);
  }
  function assertThrowStatement(node, opts) {
    assert$1("ThrowStatement", node, opts);
  }
  function assertTryStatement(node, opts) {
    assert$1("TryStatement", node, opts);
  }
  function assertUnaryExpression(node, opts) {
    assert$1("UnaryExpression", node, opts);
  }
  function assertUpdateExpression(node, opts) {
    assert$1("UpdateExpression", node, opts);
  }
  function assertVariableDeclaration(node, opts) {
    assert$1("VariableDeclaration", node, opts);
  }
  function assertVariableDeclarator(node, opts) {
    assert$1("VariableDeclarator", node, opts);
  }
  function assertWhileStatement(node, opts) {
    assert$1("WhileStatement", node, opts);
  }
  function assertWithStatement(node, opts) {
    assert$1("WithStatement", node, opts);
  }
  function assertAssignmentPattern(node, opts) {
    assert$1("AssignmentPattern", node, opts);
  }
  function assertArrayPattern(node, opts) {
    assert$1("ArrayPattern", node, opts);
  }
  function assertArrowFunctionExpression(node, opts) {
    assert$1("ArrowFunctionExpression", node, opts);
  }
  function assertClassBody(node, opts) {
    assert$1("ClassBody", node, opts);
  }
  function assertClassExpression(node, opts) {
    assert$1("ClassExpression", node, opts);
  }
  function assertClassDeclaration(node, opts) {
    assert$1("ClassDeclaration", node, opts);
  }
  function assertExportAllDeclaration(node, opts) {
    assert$1("ExportAllDeclaration", node, opts);
  }
  function assertExportDefaultDeclaration(node, opts) {
    assert$1("ExportDefaultDeclaration", node, opts);
  }
  function assertExportNamedDeclaration(node, opts) {
    assert$1("ExportNamedDeclaration", node, opts);
  }
  function assertExportSpecifier$1(node, opts) {
    assert$1("ExportSpecifier", node, opts);
  }
  function assertForOfStatement(node, opts) {
    assert$1("ForOfStatement", node, opts);
  }
  function assertImportDeclaration(node, opts) {
    assert$1("ImportDeclaration", node, opts);
  }
  function assertImportDefaultSpecifier(node, opts) {
    assert$1("ImportDefaultSpecifier", node, opts);
  }
  function assertImportNamespaceSpecifier(node, opts) {
    assert$1("ImportNamespaceSpecifier", node, opts);
  }
  function assertImportSpecifier(node, opts) {
    assert$1("ImportSpecifier", node, opts);
  }
  function assertMetaProperty(node, opts) {
    assert$1("MetaProperty", node, opts);
  }
  function assertClassMethod(node, opts) {
    assert$1("ClassMethod", node, opts);
  }
  function assertObjectPattern(node, opts) {
    assert$1("ObjectPattern", node, opts);
  }
  function assertSpreadElement(node, opts) {
    assert$1("SpreadElement", node, opts);
  }
  function assertSuper(node, opts) {
    assert$1("Super", node, opts);
  }
  function assertTaggedTemplateExpression(node, opts) {
    assert$1("TaggedTemplateExpression", node, opts);
  }
  function assertTemplateElement(node, opts) {
    assert$1("TemplateElement", node, opts);
  }
  function assertTemplateLiteral(node, opts) {
    assert$1("TemplateLiteral", node, opts);
  }
  function assertYieldExpression(node, opts) {
    assert$1("YieldExpression", node, opts);
  }
  function assertAwaitExpression(node, opts) {
    assert$1("AwaitExpression", node, opts);
  }
  function assertImport(node, opts) {
    assert$1("Import", node, opts);
  }
  function assertBigIntLiteral(node, opts) {
    assert$1("BigIntLiteral", node, opts);
  }
  function assertExportNamespaceSpecifier(node, opts) {
    assert$1("ExportNamespaceSpecifier", node, opts);
  }
  function assertOptionalMemberExpression(node, opts) {
    assert$1("OptionalMemberExpression", node, opts);
  }
  function assertOptionalCallExpression(node, opts) {
    assert$1("OptionalCallExpression", node, opts);
  }
  function assertClassProperty(node, opts) {
    assert$1("ClassProperty", node, opts);
  }
  function assertClassPrivateProperty(node, opts) {
    assert$1("ClassPrivateProperty", node, opts);
  }
  function assertClassPrivateMethod(node, opts) {
    assert$1("ClassPrivateMethod", node, opts);
  }
  function assertPrivateName(node, opts) {
    assert$1("PrivateName", node, opts);
  }
  function assertAnyTypeAnnotation(node, opts) {
    assert$1("AnyTypeAnnotation", node, opts);
  }
  function assertArrayTypeAnnotation(node, opts) {
    assert$1("ArrayTypeAnnotation", node, opts);
  }
  function assertBooleanTypeAnnotation(node, opts) {
    assert$1("BooleanTypeAnnotation", node, opts);
  }
  function assertBooleanLiteralTypeAnnotation(node, opts) {
    assert$1("BooleanLiteralTypeAnnotation", node, opts);
  }
  function assertNullLiteralTypeAnnotation(node, opts) {
    assert$1("NullLiteralTypeAnnotation", node, opts);
  }
  function assertClassImplements(node, opts) {
    assert$1("ClassImplements", node, opts);
  }
  function assertDeclareClass(node, opts) {
    assert$1("DeclareClass", node, opts);
  }
  function assertDeclareFunction(node, opts) {
    assert$1("DeclareFunction", node, opts);
  }
  function assertDeclareInterface(node, opts) {
    assert$1("DeclareInterface", node, opts);
  }
  function assertDeclareModule(node, opts) {
    assert$1("DeclareModule", node, opts);
  }
  function assertDeclareModuleExports(node, opts) {
    assert$1("DeclareModuleExports", node, opts);
  }
  function assertDeclareTypeAlias(node, opts) {
    assert$1("DeclareTypeAlias", node, opts);
  }
  function assertDeclareOpaqueType(node, opts) {
    assert$1("DeclareOpaqueType", node, opts);
  }
  function assertDeclareVariable(node, opts) {
    assert$1("DeclareVariable", node, opts);
  }
  function assertDeclareExportDeclaration(node, opts) {
    assert$1("DeclareExportDeclaration", node, opts);
  }
  function assertDeclareExportAllDeclaration(node, opts) {
    assert$1("DeclareExportAllDeclaration", node, opts);
  }
  function assertDeclaredPredicate(node, opts) {
    assert$1("DeclaredPredicate", node, opts);
  }
  function assertExistsTypeAnnotation(node, opts) {
    assert$1("ExistsTypeAnnotation", node, opts);
  }
  function assertFunctionTypeAnnotation(node, opts) {
    assert$1("FunctionTypeAnnotation", node, opts);
  }
  function assertFunctionTypeParam(node, opts) {
    assert$1("FunctionTypeParam", node, opts);
  }
  function assertGenericTypeAnnotation(node, opts) {
    assert$1("GenericTypeAnnotation", node, opts);
  }
  function assertInferredPredicate(node, opts) {
    assert$1("InferredPredicate", node, opts);
  }
  function assertInterfaceExtends(node, opts) {
    assert$1("InterfaceExtends", node, opts);
  }
  function assertInterfaceDeclaration(node, opts) {
    assert$1("InterfaceDeclaration", node, opts);
  }
  function assertInterfaceTypeAnnotation(node, opts) {
    assert$1("InterfaceTypeAnnotation", node, opts);
  }
  function assertIntersectionTypeAnnotation(node, opts) {
    assert$1("IntersectionTypeAnnotation", node, opts);
  }
  function assertMixedTypeAnnotation(node, opts) {
    assert$1("MixedTypeAnnotation", node, opts);
  }
  function assertEmptyTypeAnnotation(node, opts) {
    assert$1("EmptyTypeAnnotation", node, opts);
  }
  function assertNullableTypeAnnotation(node, opts) {
    assert$1("NullableTypeAnnotation", node, opts);
  }
  function assertNumberLiteralTypeAnnotation(node, opts) {
    assert$1("NumberLiteralTypeAnnotation", node, opts);
  }
  function assertNumberTypeAnnotation(node, opts) {
    assert$1("NumberTypeAnnotation", node, opts);
  }
  function assertObjectTypeAnnotation(node, opts) {
    assert$1("ObjectTypeAnnotation", node, opts);
  }
  function assertObjectTypeInternalSlot(node, opts) {
    assert$1("ObjectTypeInternalSlot", node, opts);
  }
  function assertObjectTypeCallProperty(node, opts) {
    assert$1("ObjectTypeCallProperty", node, opts);
  }
  function assertObjectTypeIndexer(node, opts) {
    assert$1("ObjectTypeIndexer", node, opts);
  }
  function assertObjectTypeProperty(node, opts) {
    assert$1("ObjectTypeProperty", node, opts);
  }
  function assertObjectTypeSpreadProperty(node, opts) {
    assert$1("ObjectTypeSpreadProperty", node, opts);
  }
  function assertOpaqueType(node, opts) {
    assert$1("OpaqueType", node, opts);
  }
  function assertQualifiedTypeIdentifier(node, opts) {
    assert$1("QualifiedTypeIdentifier", node, opts);
  }
  function assertStringLiteralTypeAnnotation(node, opts) {
    assert$1("StringLiteralTypeAnnotation", node, opts);
  }
  function assertStringTypeAnnotation(node, opts) {
    assert$1("StringTypeAnnotation", node, opts);
  }
  function assertSymbolTypeAnnotation(node, opts) {
    assert$1("SymbolTypeAnnotation", node, opts);
  }
  function assertThisTypeAnnotation(node, opts) {
    assert$1("ThisTypeAnnotation", node, opts);
  }
  function assertTupleTypeAnnotation(node, opts) {
    assert$1("TupleTypeAnnotation", node, opts);
  }
  function assertTypeofTypeAnnotation(node, opts) {
    assert$1("TypeofTypeAnnotation", node, opts);
  }
  function assertTypeAlias(node, opts) {
    assert$1("TypeAlias", node, opts);
  }
  function assertTypeAnnotation(node, opts) {
    assert$1("TypeAnnotation", node, opts);
  }
  function assertTypeCastExpression(node, opts) {
    assert$1("TypeCastExpression", node, opts);
  }
  function assertTypeParameter(node, opts) {
    assert$1("TypeParameter", node, opts);
  }
  function assertTypeParameterDeclaration(node, opts) {
    assert$1("TypeParameterDeclaration", node, opts);
  }
  function assertTypeParameterInstantiation(node, opts) {
    assert$1("TypeParameterInstantiation", node, opts);
  }
  function assertUnionTypeAnnotation(node, opts) {
    assert$1("UnionTypeAnnotation", node, opts);
  }
  function assertVariance(node, opts) {
    assert$1("Variance", node, opts);
  }
  function assertVoidTypeAnnotation(node, opts) {
    assert$1("VoidTypeAnnotation", node, opts);
  }
  function assertEnumDeclaration(node, opts) {
    assert$1("EnumDeclaration", node, opts);
  }
  function assertEnumBooleanBody(node, opts) {
    assert$1("EnumBooleanBody", node, opts);
  }
  function assertEnumNumberBody(node, opts) {
    assert$1("EnumNumberBody", node, opts);
  }
  function assertEnumStringBody(node, opts) {
    assert$1("EnumStringBody", node, opts);
  }
  function assertEnumSymbolBody(node, opts) {
    assert$1("EnumSymbolBody", node, opts);
  }
  function assertEnumBooleanMember(node, opts) {
    assert$1("EnumBooleanMember", node, opts);
  }
  function assertEnumNumberMember(node, opts) {
    assert$1("EnumNumberMember", node, opts);
  }
  function assertEnumStringMember(node, opts) {
    assert$1("EnumStringMember", node, opts);
  }
  function assertEnumDefaultedMember(node, opts) {
    assert$1("EnumDefaultedMember", node, opts);
  }
  function assertIndexedAccessType(node, opts) {
    assert$1("IndexedAccessType", node, opts);
  }
  function assertOptionalIndexedAccessType(node, opts) {
    assert$1("OptionalIndexedAccessType", node, opts);
  }
  function assertJSXAttribute(node, opts) {
    assert$1("JSXAttribute", node, opts);
  }
  function assertJSXClosingElement(node, opts) {
    assert$1("JSXClosingElement", node, opts);
  }
  function assertJSXElement(node, opts) {
    assert$1("JSXElement", node, opts);
  }
  function assertJSXEmptyExpression(node, opts) {
    assert$1("JSXEmptyExpression", node, opts);
  }
  function assertJSXExpressionContainer(node, opts) {
    assert$1("JSXExpressionContainer", node, opts);
  }
  function assertJSXSpreadChild(node, opts) {
    assert$1("JSXSpreadChild", node, opts);
  }
  function assertJSXIdentifier(node, opts) {
    assert$1("JSXIdentifier", node, opts);
  }
  function assertJSXMemberExpression(node, opts) {
    assert$1("JSXMemberExpression", node, opts);
  }
  function assertJSXNamespacedName(node, opts) {
    assert$1("JSXNamespacedName", node, opts);
  }
  function assertJSXOpeningElement(node, opts) {
    assert$1("JSXOpeningElement", node, opts);
  }
  function assertJSXSpreadAttribute(node, opts) {
    assert$1("JSXSpreadAttribute", node, opts);
  }
  function assertJSXText(node, opts) {
    assert$1("JSXText", node, opts);
  }
  function assertJSXFragment(node, opts) {
    assert$1("JSXFragment", node, opts);
  }
  function assertJSXOpeningFragment(node, opts) {
    assert$1("JSXOpeningFragment", node, opts);
  }
  function assertJSXClosingFragment(node, opts) {
    assert$1("JSXClosingFragment", node, opts);
  }
  function assertNoop(node, opts) {
    assert$1("Noop", node, opts);
  }
  function assertPlaceholder(node, opts) {
    assert$1("Placeholder", node, opts);
  }
  function assertV8IntrinsicIdentifier(node, opts) {
    assert$1("V8IntrinsicIdentifier", node, opts);
  }
  function assertArgumentPlaceholder(node, opts) {
    assert$1("ArgumentPlaceholder", node, opts);
  }
  function assertBindExpression(node, opts) {
    assert$1("BindExpression", node, opts);
  }
  function assertImportAttribute(node, opts) {
    assert$1("ImportAttribute", node, opts);
  }
  function assertDecorator(node, opts) {
    assert$1("Decorator", node, opts);
  }
  function assertDoExpression(node, opts) {
    assert$1("DoExpression", node, opts);
  }
  function assertExportDefaultSpecifier(node, opts) {
    assert$1("ExportDefaultSpecifier", node, opts);
  }
  function assertRecordExpression(node, opts) {
    assert$1("RecordExpression", node, opts);
  }
  function assertTupleExpression(node, opts) {
    assert$1("TupleExpression", node, opts);
  }
  function assertDecimalLiteral(node, opts) {
    assert$1("DecimalLiteral", node, opts);
  }
  function assertStaticBlock(node, opts) {
    assert$1("StaticBlock", node, opts);
  }
  function assertModuleExpression(node, opts) {
    assert$1("ModuleExpression", node, opts);
  }
  function assertTopicReference(node, opts) {
    assert$1("TopicReference", node, opts);
  }
  function assertPipelineTopicExpression(node, opts) {
    assert$1("PipelineTopicExpression", node, opts);
  }
  function assertPipelineBareFunction(node, opts) {
    assert$1("PipelineBareFunction", node, opts);
  }
  function assertPipelinePrimaryTopicReference(node, opts) {
    assert$1("PipelinePrimaryTopicReference", node, opts);
  }
  function assertTSParameterProperty(node, opts) {
    assert$1("TSParameterProperty", node, opts);
  }
  function assertTSDeclareFunction(node, opts) {
    assert$1("TSDeclareFunction", node, opts);
  }
  function assertTSDeclareMethod(node, opts) {
    assert$1("TSDeclareMethod", node, opts);
  }
  function assertTSQualifiedName(node, opts) {
    assert$1("TSQualifiedName", node, opts);
  }
  function assertTSCallSignatureDeclaration(node, opts) {
    assert$1("TSCallSignatureDeclaration", node, opts);
  }
  function assertTSConstructSignatureDeclaration(node, opts) {
    assert$1("TSConstructSignatureDeclaration", node, opts);
  }
  function assertTSPropertySignature(node, opts) {
    assert$1("TSPropertySignature", node, opts);
  }
  function assertTSMethodSignature(node, opts) {
    assert$1("TSMethodSignature", node, opts);
  }
  function assertTSIndexSignature(node, opts) {
    assert$1("TSIndexSignature", node, opts);
  }
  function assertTSAnyKeyword(node, opts) {
    assert$1("TSAnyKeyword", node, opts);
  }
  function assertTSBooleanKeyword(node, opts) {
    assert$1("TSBooleanKeyword", node, opts);
  }
  function assertTSBigIntKeyword(node, opts) {
    assert$1("TSBigIntKeyword", node, opts);
  }
  function assertTSIntrinsicKeyword(node, opts) {
    assert$1("TSIntrinsicKeyword", node, opts);
  }
  function assertTSNeverKeyword(node, opts) {
    assert$1("TSNeverKeyword", node, opts);
  }
  function assertTSNullKeyword(node, opts) {
    assert$1("TSNullKeyword", node, opts);
  }
  function assertTSNumberKeyword(node, opts) {
    assert$1("TSNumberKeyword", node, opts);
  }
  function assertTSObjectKeyword(node, opts) {
    assert$1("TSObjectKeyword", node, opts);
  }
  function assertTSStringKeyword(node, opts) {
    assert$1("TSStringKeyword", node, opts);
  }
  function assertTSSymbolKeyword(node, opts) {
    assert$1("TSSymbolKeyword", node, opts);
  }
  function assertTSUndefinedKeyword(node, opts) {
    assert$1("TSUndefinedKeyword", node, opts);
  }
  function assertTSUnknownKeyword(node, opts) {
    assert$1("TSUnknownKeyword", node, opts);
  }
  function assertTSVoidKeyword(node, opts) {
    assert$1("TSVoidKeyword", node, opts);
  }
  function assertTSThisType(node, opts) {
    assert$1("TSThisType", node, opts);
  }
  function assertTSFunctionType(node, opts) {
    assert$1("TSFunctionType", node, opts);
  }
  function assertTSConstructorType(node, opts) {
    assert$1("TSConstructorType", node, opts);
  }
  function assertTSTypeReference(node, opts) {
    assert$1("TSTypeReference", node, opts);
  }
  function assertTSTypePredicate(node, opts) {
    assert$1("TSTypePredicate", node, opts);
  }
  function assertTSTypeQuery(node, opts) {
    assert$1("TSTypeQuery", node, opts);
  }
  function assertTSTypeLiteral(node, opts) {
    assert$1("TSTypeLiteral", node, opts);
  }
  function assertTSArrayType(node, opts) {
    assert$1("TSArrayType", node, opts);
  }
  function assertTSTupleType(node, opts) {
    assert$1("TSTupleType", node, opts);
  }
  function assertTSOptionalType(node, opts) {
    assert$1("TSOptionalType", node, opts);
  }
  function assertTSRestType(node, opts) {
    assert$1("TSRestType", node, opts);
  }
  function assertTSNamedTupleMember(node, opts) {
    assert$1("TSNamedTupleMember", node, opts);
  }
  function assertTSUnionType(node, opts) {
    assert$1("TSUnionType", node, opts);
  }
  function assertTSIntersectionType(node, opts) {
    assert$1("TSIntersectionType", node, opts);
  }
  function assertTSConditionalType(node, opts) {
    assert$1("TSConditionalType", node, opts);
  }
  function assertTSInferType(node, opts) {
    assert$1("TSInferType", node, opts);
  }
  function assertTSParenthesizedType(node, opts) {
    assert$1("TSParenthesizedType", node, opts);
  }
  function assertTSTypeOperator(node, opts) {
    assert$1("TSTypeOperator", node, opts);
  }
  function assertTSIndexedAccessType(node, opts) {
    assert$1("TSIndexedAccessType", node, opts);
  }
  function assertTSMappedType(node, opts) {
    assert$1("TSMappedType", node, opts);
  }
  function assertTSLiteralType(node, opts) {
    assert$1("TSLiteralType", node, opts);
  }
  function assertTSExpressionWithTypeArguments(node, opts) {
    assert$1("TSExpressionWithTypeArguments", node, opts);
  }
  function assertTSInterfaceDeclaration(node, opts) {
    assert$1("TSInterfaceDeclaration", node, opts);
  }
  function assertTSInterfaceBody(node, opts) {
    assert$1("TSInterfaceBody", node, opts);
  }
  function assertTSTypeAliasDeclaration(node, opts) {
    assert$1("TSTypeAliasDeclaration", node, opts);
  }
  function assertTSAsExpression(node, opts) {
    assert$1("TSAsExpression", node, opts);
  }
  function assertTSTypeAssertion(node, opts) {
    assert$1("TSTypeAssertion", node, opts);
  }
  function assertTSEnumDeclaration(node, opts) {
    assert$1("TSEnumDeclaration", node, opts);
  }
  function assertTSEnumMember(node, opts) {
    assert$1("TSEnumMember", node, opts);
  }
  function assertTSModuleDeclaration(node, opts) {
    assert$1("TSModuleDeclaration", node, opts);
  }
  function assertTSModuleBlock(node, opts) {
    assert$1("TSModuleBlock", node, opts);
  }
  function assertTSImportType(node, opts) {
    assert$1("TSImportType", node, opts);
  }
  function assertTSImportEqualsDeclaration(node, opts) {
    assert$1("TSImportEqualsDeclaration", node, opts);
  }
  function assertTSExternalModuleReference(node, opts) {
    assert$1("TSExternalModuleReference", node, opts);
  }
  function assertTSNonNullExpression(node, opts) {
    assert$1("TSNonNullExpression", node, opts);
  }
  function assertTSExportAssignment(node, opts) {
    assert$1("TSExportAssignment", node, opts);
  }
  function assertTSNamespaceExportDeclaration(node, opts) {
    assert$1("TSNamespaceExportDeclaration", node, opts);
  }
  function assertTSTypeAnnotation(node, opts) {
    assert$1("TSTypeAnnotation", node, opts);
  }
  function assertTSTypeParameterInstantiation(node, opts) {
    assert$1("TSTypeParameterInstantiation", node, opts);
  }
  function assertTSTypeParameterDeclaration(node, opts) {
    assert$1("TSTypeParameterDeclaration", node, opts);
  }
  function assertTSTypeParameter(node, opts) {
    assert$1("TSTypeParameter", node, opts);
  }
  function assertExpression$1(node, opts) {
    assert$1("Expression", node, opts);
  }
  function assertBinary(node, opts) {
    assert$1("Binary", node, opts);
  }
  function assertScopable(node, opts) {
    assert$1("Scopable", node, opts);
  }
  function assertBlockParent(node, opts) {
    assert$1("BlockParent", node, opts);
  }
  function assertBlock(node, opts) {
    assert$1("Block", node, opts);
  }
  function assertStatement(node, opts) {
    assert$1("Statement", node, opts);
  }
  function assertTerminatorless(node, opts) {
    assert$1("Terminatorless", node, opts);
  }
  function assertCompletionStatement(node, opts) {
    assert$1("CompletionStatement", node, opts);
  }
  function assertConditional(node, opts) {
    assert$1("Conditional", node, opts);
  }
  function assertLoop(node, opts) {
    assert$1("Loop", node, opts);
  }
  function assertWhile(node, opts) {
    assert$1("While", node, opts);
  }
  function assertExpressionWrapper(node, opts) {
    assert$1("ExpressionWrapper", node, opts);
  }
  function assertFor(node, opts) {
    assert$1("For", node, opts);
  }
  function assertForXStatement(node, opts) {
    assert$1("ForXStatement", node, opts);
  }
  function assertFunction$1(node, opts) {
    assert$1("Function", node, opts);
  }
  function assertFunctionParent(node, opts) {
    assert$1("FunctionParent", node, opts);
  }
  function assertPureish(node, opts) {
    assert$1("Pureish", node, opts);
  }
  function assertDeclaration(node, opts) {
    assert$1("Declaration", node, opts);
  }
  function assertPatternLike(node, opts) {
    assert$1("PatternLike", node, opts);
  }
  function assertLVal(node, opts) {
    assert$1("LVal", node, opts);
  }
  function assertTSEntityName(node, opts) {
    assert$1("TSEntityName", node, opts);
  }
  function assertLiteral(node, opts) {
    assert$1("Literal", node, opts);
  }
  function assertImmutable(node, opts) {
    assert$1("Immutable", node, opts);
  }
  function assertUserWhitespacable(node, opts) {
    assert$1("UserWhitespacable", node, opts);
  }
  function assertMethod(node, opts) {
    assert$1("Method", node, opts);
  }
  function assertObjectMember(node, opts) {
    assert$1("ObjectMember", node, opts);
  }
  function assertProperty(node, opts) {
    assert$1("Property", node, opts);
  }
  function assertUnaryLike(node, opts) {
    assert$1("UnaryLike", node, opts);
  }
  function assertPattern(node, opts) {
    assert$1("Pattern", node, opts);
  }
  function assertClass(node, opts) {
    assert$1("Class", node, opts);
  }
  function assertModuleDeclaration(node, opts) {
    assert$1("ModuleDeclaration", node, opts);
  }
  function assertExportDeclaration(node, opts) {
    assert$1("ExportDeclaration", node, opts);
  }
  function assertModuleSpecifier(node, opts) {
    assert$1("ModuleSpecifier", node, opts);
  }
  function assertPrivate(node, opts) {
    assert$1("Private", node, opts);
  }
  function assertFlow(node, opts) {
    assert$1("Flow", node, opts);
  }
  function assertFlowType(node, opts) {
    assert$1("FlowType", node, opts);
  }
  function assertFlowBaseAnnotation(node, opts) {
    assert$1("FlowBaseAnnotation", node, opts);
  }
  function assertFlowDeclaration(node, opts) {
    assert$1("FlowDeclaration", node, opts);
  }
  function assertFlowPredicate(node, opts) {
    assert$1("FlowPredicate", node, opts);
  }
  function assertEnumBody(node, opts) {
    assert$1("EnumBody", node, opts);
  }
  function assertEnumMember(node, opts) {
    assert$1("EnumMember", node, opts);
  }
  function assertJSX(node, opts) {
    assert$1("JSX", node, opts);
  }
  function assertTSTypeElement(node, opts) {
    assert$1("TSTypeElement", node, opts);
  }
  function assertTSType(node, opts) {
    assert$1("TSType", node, opts);
  }
  function assertTSBaseType(node, opts) {
    assert$1("TSBaseType", node, opts);
  }
  function assertNumberLiteral(node, opts) {
    console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
    assert$1("NumberLiteral", node, opts);
  }
  function assertRegexLiteral(node, opts) {
    console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
    assert$1("RegexLiteral", node, opts);
  }
  function assertRestProperty(node, opts) {
    console.trace("The node type RestProperty has been renamed to RestElement");
    assert$1("RestProperty", node, opts);
  }
  function assertSpreadProperty(node, opts) {
    console.trace("The node type SpreadProperty has been renamed to SpreadElement");
    assert$1("SpreadProperty", node, opts);
  }

  function createTypeAnnotationBasedOnTypeof$1(type) {
    if (type === "string") {
      return stringTypeAnnotation$2();
    } else if (type === "number") {
      return numberTypeAnnotation$2();
    } else if (type === "undefined") {
      return voidTypeAnnotation$3();
    } else if (type === "boolean") {
      return booleanTypeAnnotation$1();
    } else if (type === "function") {
      return genericTypeAnnotation$1(identifier$j("Function"));
    } else if (type === "object") {
      return genericTypeAnnotation$1(identifier$j("Object"));
    } else if (type === "symbol") {
      return genericTypeAnnotation$1(identifier$j("Symbol"));
    } else if (type === "bigint") {
      return anyTypeAnnotation$2();
    } else {
      throw new Error("Invalid typeof value: " + type);
    }
  }

  function getQualifiedName(node) {
    return isIdentifier$g(node) ? node.name : node.id.name + "." + getQualifiedName(node.qualification);
  }

  function removeTypeDuplicates$1(nodes) {
    var generics = {};
    var bases = {};
    var typeGroups = new Set();
    var types = [];

    for (var i = 0; i < nodes.length; i++) {
      var node = nodes[i];
      if (!node) continue;

      if (types.indexOf(node) >= 0) {
        continue;
      }

      if (isAnyTypeAnnotation$1(node)) {
        return [node];
      }

      if (isFlowBaseAnnotation$1(node)) {
        bases[node.type] = node;
        continue;
      }

      if (isUnionTypeAnnotation$2(node)) {
        if (!typeGroups.has(node.types)) {
          nodes = nodes.concat(node.types);
          typeGroups.add(node.types);
        }

        continue;
      }

      if (isGenericTypeAnnotation$1(node)) {
        var name = getQualifiedName(node.id);

        if (generics[name]) {
          var existing = generics[name];

          if (existing.typeParameters) {
            if (node.typeParameters) {
              existing.typeParameters.params = removeTypeDuplicates$1(existing.typeParameters.params.concat(node.typeParameters.params));
            }
          } else {
            existing = node.typeParameters;
          }
        } else {
          generics[name] = node;
        }

        continue;
      }

      types.push(node);
    }

    for (var _i = 0, _Object$keys = Object.keys(bases); _i < _Object$keys.length; _i++) {
      var type = _Object$keys[_i];
      types.push(bases[type]);
    }

    for (var _i2 = 0, _Object$keys2 = Object.keys(generics); _i2 < _Object$keys2.length; _i2++) {
      var _name = _Object$keys2[_i2];
      types.push(generics[_name]);
    }

    return types;
  }

  function createFlowUnionType$2(types) {
    var flattened = removeTypeDuplicates$1(types);

    if (flattened.length === 1) {
      return flattened[0];
    } else {
      return unionTypeAnnotation$1(flattened);
    }
  }

  function removeTypeDuplicates(nodes) {
    var generics = {};
    var bases = {};
    var typeGroups = new Set();
    var types = [];

    for (var i = 0; i < nodes.length; i++) {
      var node = nodes[i];
      if (!node) continue;

      if (types.indexOf(node) >= 0) {
        continue;
      }

      if (isTSAnyKeyword(node)) {
        return [node];
      }

      if (isTSBaseType(node)) {
        bases[node.type] = node;
        continue;
      }

      if (isTSUnionType$1(node)) {
        if (!typeGroups.has(node.types)) {
          nodes.push.apply(nodes, _toConsumableArray(node.types));
          typeGroups.add(node.types);
        }

        continue;
      }

      types.push(node);
    }

    for (var _i = 0, _Object$keys = Object.keys(bases); _i < _Object$keys.length; _i++) {
      var type = _Object$keys[_i];
      types.push(bases[type]);
    }

    for (var _i2 = 0, _Object$keys2 = Object.keys(generics); _i2 < _Object$keys2.length; _i2++) {
      var name = _Object$keys2[_i2];
      types.push(generics[name]);
    }

    return types;
  }

  function createTSUnionType$2(typeAnnotations) {
    var types = typeAnnotations.map(function (type) {
      return type.typeAnnotation;
    });
    var flattened = removeTypeDuplicates(types);

    if (flattened.length === 1) {
      return flattened[0];
    } else {
      return tsUnionType(flattened);
    }
  }

  var has$d = Function.call.bind(Object.prototype.hasOwnProperty);

  function cloneIfNode(obj, deep, withoutLoc) {
    if (obj && typeof obj.type === "string") {
      return cloneNode$i(obj, deep, withoutLoc);
    }

    return obj;
  }

  function cloneIfNodeOrArray(obj, deep, withoutLoc) {
    if (Array.isArray(obj)) {
      return obj.map(function (node) {
        return cloneIfNode(node, deep, withoutLoc);
      });
    }

    return cloneIfNode(obj, deep, withoutLoc);
  }

  function cloneNode$i(node, deep, withoutLoc) {
    if (deep === void 0) {
      deep = true;
    }

    if (withoutLoc === void 0) {
      withoutLoc = false;
    }

    if (!node) return node;
    var type = node.type;
    var newNode = {
      type: node.type
    };

    if (isIdentifier$g(node)) {
      newNode.name = node.name;

      if (has$d(node, "optional") && typeof node.optional === "boolean") {
        newNode.optional = node.optional;
      }

      if (has$d(node, "typeAnnotation")) {
        newNode.typeAnnotation = deep ? cloneIfNodeOrArray(node.typeAnnotation, true, withoutLoc) : node.typeAnnotation;
      }
    } else if (!has$d(NODE_FIELDS, type)) {
      throw new Error("Unknown node type: \"" + type + "\"");
    } else {
      for (var _i = 0, _Object$keys = Object.keys(NODE_FIELDS[type]); _i < _Object$keys.length; _i++) {
        var field = _Object$keys[_i];

        if (has$d(node, field)) {
          if (deep) {
            newNode[field] = isFile$1(node) && field === "comments" ? maybeCloneComments(node.comments, deep, withoutLoc) : cloneIfNodeOrArray(node[field], true, withoutLoc);
          } else {
            newNode[field] = node[field];
          }
        }
      }
    }

    if (has$d(node, "loc")) {
      if (withoutLoc) {
        newNode.loc = null;
      } else {
        newNode.loc = node.loc;
      }
    }

    if (has$d(node, "leadingComments")) {
      newNode.leadingComments = maybeCloneComments(node.leadingComments, deep, withoutLoc);
    }

    if (has$d(node, "innerComments")) {
      newNode.innerComments = maybeCloneComments(node.innerComments, deep, withoutLoc);
    }

    if (has$d(node, "trailingComments")) {
      newNode.trailingComments = maybeCloneComments(node.trailingComments, deep, withoutLoc);
    }

    if (has$d(node, "extra")) {
      newNode.extra = Object.assign({}, node.extra);
    }

    return newNode;
  }

  function maybeCloneComments(comments, deep, withoutLoc) {
    if (!comments || !deep) {
      return comments;
    }

    return comments.map(function (_ref) {
      var type = _ref.type,
          value = _ref.value,
          loc = _ref.loc;

      if (withoutLoc) {
        return {
          type: type,
          value: value,
          loc: null
        };
      }

      return {
        type: type,
        value: value,
        loc: loc
      };
    });
  }

  function clone(node) {
    return cloneNode$i(node, false);
  }

  function cloneDeep$1(node) {
    return cloneNode$i(node);
  }

  function cloneDeepWithoutLoc(node) {
    return cloneNode$i(node, true, true);
  }

  function cloneWithoutLoc(node) {
    return cloneNode$i(node, false, true);
  }

  function addComments$1(node, type, comments) {
    if (!comments || !node) return node;
    var key = type + "Comments";

    if (node[key]) {
      if (type === "leading") {
        node[key] = comments.concat(node[key]);
      } else {
        var _node$key;

        (_node$key = node[key]).push.apply(_node$key, _toConsumableArray(comments));
      }
    } else {
      node[key] = comments;
    }

    return node;
  }

  function addComment$2(node, type, content, line) {
    return addComments$1(node, type, [{
      type: line ? "CommentLine" : "CommentBlock",
      value: content
    }]);
  }

  function inherit(key, child, parent) {
    if (child && parent) {
      child[key] = Array.from(new Set([].concat(child[key], parent[key]).filter(Boolean)));
    }
  }

  function inheritInnerComments(child, parent) {
    inherit("innerComments", child, parent);
  }

  function inheritLeadingComments$1(child, parent) {
    inherit("leadingComments", child, parent);
  }

  function inheritTrailingComments$1(child, parent) {
    inherit("trailingComments", child, parent);
  }

  function inheritsComments$2(child, parent) {
    inheritTrailingComments$1(child, parent);
    inheritLeadingComments$1(child, parent);
    inheritInnerComments(child, parent);
    return child;
  }

  function removeComments$2(node) {
    COMMENT_KEYS.forEach(function (key) {
      node[key] = null;
    });
    return node;
  }

  var EXPRESSION_TYPES = FLIPPED_ALIAS_KEYS$3["Expression"];
  var BINARY_TYPES = FLIPPED_ALIAS_KEYS$3["Binary"];
  var SCOPABLE_TYPES = FLIPPED_ALIAS_KEYS$3["Scopable"];
  var BLOCKPARENT_TYPES = FLIPPED_ALIAS_KEYS$3["BlockParent"];
  var BLOCK_TYPES = FLIPPED_ALIAS_KEYS$3["Block"];
  var STATEMENT_TYPES = FLIPPED_ALIAS_KEYS$3["Statement"];
  var TERMINATORLESS_TYPES = FLIPPED_ALIAS_KEYS$3["Terminatorless"];
  var COMPLETIONSTATEMENT_TYPES = FLIPPED_ALIAS_KEYS$3["CompletionStatement"];
  var CONDITIONAL_TYPES = FLIPPED_ALIAS_KEYS$3["Conditional"];
  var LOOP_TYPES = FLIPPED_ALIAS_KEYS$3["Loop"];
  var WHILE_TYPES = FLIPPED_ALIAS_KEYS$3["While"];
  var EXPRESSIONWRAPPER_TYPES = FLIPPED_ALIAS_KEYS$3["ExpressionWrapper"];
  var FOR_TYPES = FLIPPED_ALIAS_KEYS$3["For"];
  var FORXSTATEMENT_TYPES = FLIPPED_ALIAS_KEYS$3["ForXStatement"];
  var FUNCTION_TYPES$1 = FLIPPED_ALIAS_KEYS$3["Function"];
  var FUNCTIONPARENT_TYPES = FLIPPED_ALIAS_KEYS$3["FunctionParent"];
  var PUREISH_TYPES = FLIPPED_ALIAS_KEYS$3["Pureish"];
  var DECLARATION_TYPES = FLIPPED_ALIAS_KEYS$3["Declaration"];
  var PATTERNLIKE_TYPES = FLIPPED_ALIAS_KEYS$3["PatternLike"];
  var LVAL_TYPES = FLIPPED_ALIAS_KEYS$3["LVal"];
  var TSENTITYNAME_TYPES = FLIPPED_ALIAS_KEYS$3["TSEntityName"];
  var LITERAL_TYPES = FLIPPED_ALIAS_KEYS$3["Literal"];
  var IMMUTABLE_TYPES = FLIPPED_ALIAS_KEYS$3["Immutable"];
  var USERWHITESPACABLE_TYPES = FLIPPED_ALIAS_KEYS$3["UserWhitespacable"];
  var METHOD_TYPES = FLIPPED_ALIAS_KEYS$3["Method"];
  var OBJECTMEMBER_TYPES = FLIPPED_ALIAS_KEYS$3["ObjectMember"];
  var PROPERTY_TYPES = FLIPPED_ALIAS_KEYS$3["Property"];
  var UNARYLIKE_TYPES = FLIPPED_ALIAS_KEYS$3["UnaryLike"];
  var PATTERN_TYPES = FLIPPED_ALIAS_KEYS$3["Pattern"];
  var CLASS_TYPES = FLIPPED_ALIAS_KEYS$3["Class"];
  var MODULEDECLARATION_TYPES = FLIPPED_ALIAS_KEYS$3["ModuleDeclaration"];
  var EXPORTDECLARATION_TYPES = FLIPPED_ALIAS_KEYS$3["ExportDeclaration"];
  var MODULESPECIFIER_TYPES = FLIPPED_ALIAS_KEYS$3["ModuleSpecifier"];
  var PRIVATE_TYPES = FLIPPED_ALIAS_KEYS$3["Private"];
  var FLOW_TYPES = FLIPPED_ALIAS_KEYS$3["Flow"];
  var FLOWTYPE_TYPES = FLIPPED_ALIAS_KEYS$3["FlowType"];
  var FLOWBASEANNOTATION_TYPES = FLIPPED_ALIAS_KEYS$3["FlowBaseAnnotation"];
  var FLOWDECLARATION_TYPES = FLIPPED_ALIAS_KEYS$3["FlowDeclaration"];
  var FLOWPREDICATE_TYPES = FLIPPED_ALIAS_KEYS$3["FlowPredicate"];
  var ENUMBODY_TYPES = FLIPPED_ALIAS_KEYS$3["EnumBody"];
  var ENUMMEMBER_TYPES = FLIPPED_ALIAS_KEYS$3["EnumMember"];
  var JSX_TYPES = FLIPPED_ALIAS_KEYS$3["JSX"];
  var TSTYPEELEMENT_TYPES = FLIPPED_ALIAS_KEYS$3["TSTypeElement"];
  var TSTYPE_TYPES = FLIPPED_ALIAS_KEYS$3["TSType"];
  var TSBASETYPE_TYPES = FLIPPED_ALIAS_KEYS$3["TSBaseType"];

  function toBlock(node, parent) {
    if (isBlockStatement$2(node)) {
      return node;
    }

    var blockNodes = [];

    if (isEmptyStatement$1(node)) {
      blockNodes = [];
    } else {
      if (!isStatement$7(node)) {
        if (isFunction$4(parent)) {
          node = returnStatement$3(node);
        } else {
          node = expressionStatement$a(node);
        }
      }

      blockNodes = [node];
    }

    return blockStatement$6(blockNodes);
  }

  function ensureBlock$1(node, key) {
    if (key === void 0) {
      key = "body";
    }

    return node[key] = toBlock(node[key], node);
  }

  function toIdentifier$1(input) {
    input = input + "";
    var name = "";

    for (var _iterator = _createForOfIteratorHelperLoose(input), _step; !(_step = _iterator()).done;) {
      var c = _step.value;
      name += isIdentifierChar(c.codePointAt(0)) ? c : "-";
    }

    name = name.replace(/^[-0-9]+/, "");
    name = name.replace(/[-\s]+(.)?/g, function (match, c) {
      return c ? c.toUpperCase() : "";
    });

    if (!isValidIdentifier$1(name)) {
      name = "_" + name;
    }

    return name || "_";
  }

  function toBindingIdentifierName$1(name) {
    name = toIdentifier$1(name);
    if (name === "eval" || name === "arguments") name = "_" + name;
    return name;
  }

  function toComputedKey$3(node, key) {
    if (key === void 0) {
      key = node.key || node.property;
    }

    if (!node.computed && isIdentifier$g(key)) key = stringLiteral$8(key.name);
    return key;
  }

  function toExpression(node) {
    if (isExpressionStatement$4(node)) {
      node = node.expression;
    }

    if (isExpression$4(node)) {
      return node;
    }

    if (isClass$1(node)) {
      node.type = "ClassExpression";
    } else if (isFunction$4(node)) {
      node.type = "FunctionExpression";
    }

    if (!isExpression$4(node)) {
      throw new Error("cannot turn " + node.type + " to an expression");
    }

    return node;
  }

  function traverseFast$2(node, enter, opts) {
    if (!node) return;
    var keys = VISITOR_KEYS$6[node.type];
    if (!keys) return;
    opts = opts || {};
    enter(node, opts);

    for (var _iterator = _createForOfIteratorHelperLoose(keys), _step; !(_step = _iterator()).done;) {
      var key = _step.value;
      var subNode = node[key];

      if (Array.isArray(subNode)) {
        for (var _iterator2 = _createForOfIteratorHelperLoose(subNode), _step2; !(_step2 = _iterator2()).done;) {
          var _node = _step2.value;
          traverseFast$2(_node, enter, opts);
        }
      } else {
        traverseFast$2(subNode, enter, opts);
      }
    }
  }

  var CLEAR_KEYS = ["tokens", "start", "end", "loc", "raw", "rawValue"];
  var CLEAR_KEYS_PLUS_COMMENTS = COMMENT_KEYS.concat(["comments"]).concat(CLEAR_KEYS);
  function removeProperties$1(node, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var map = opts.preserveComments ? CLEAR_KEYS : CLEAR_KEYS_PLUS_COMMENTS;

    for (var _iterator = _createForOfIteratorHelperLoose(map), _step; !(_step = _iterator()).done;) {
      var _key = _step.value;
      if (node[_key] != null) node[_key] = undefined;
    }

    for (var _i = 0, _Object$keys = Object.keys(node); _i < _Object$keys.length; _i++) {
      var key = _Object$keys[_i];
      if (key[0] === "_" && node[key] != null) node[key] = undefined;
    }

    var symbols = Object.getOwnPropertySymbols(node);

    for (var _iterator2 = _createForOfIteratorHelperLoose(symbols), _step2; !(_step2 = _iterator2()).done;) {
      var sym = _step2.value;
      node[sym] = null;
    }
  }

  function removePropertiesDeep$1(tree, opts) {
    traverseFast$2(tree, removeProperties$1, opts);
    return tree;
  }

  function toKeyAlias$1(node, key) {
    if (key === void 0) {
      key = node.key;
    }

    var alias;

    if (node.kind === "method") {
      return toKeyAlias$1.increment() + "";
    } else if (isIdentifier$g(key)) {
      alias = key.name;
    } else if (isStringLiteral$7(key)) {
      alias = JSON.stringify(key.value);
    } else {
      alias = JSON.stringify(removePropertiesDeep$1(cloneNode$i(key)));
    }

    if (node.computed) {
      alias = "[" + alias + "]";
    }

    if (node["static"]) {
      alias = "static:" + alias;
    }

    return alias;
  }
  toKeyAlias$1.uid = 0;

  toKeyAlias$1.increment = function () {
    if (toKeyAlias$1.uid >= Number.MAX_SAFE_INTEGER) {
      return toKeyAlias$1.uid = 0;
    } else {
      return toKeyAlias$1.uid++;
    }
  };

  function getBindingIdentifiers$2(node, duplicates, outerOnly) {
    var search = [].concat(node);
    var ids = Object.create(null);

    while (search.length) {
      var id = search.shift();
      if (!id) continue;
      var keys = getBindingIdentifiers$2.keys[id.type];

      if (isIdentifier$g(id)) {
        if (duplicates) {
          var _ids = ids[id.name] = ids[id.name] || [];

          _ids.push(id);
        } else {
          ids[id.name] = id;
        }

        continue;
      }

      if (isExportDeclaration$2(id) && !isExportAllDeclaration$1(id)) {
        if (isDeclaration$1(id.declaration)) {
          search.push(id.declaration);
        }

        continue;
      }

      if (outerOnly) {
        if (isFunctionDeclaration$1(id)) {
          search.push(id.id);
          continue;
        }

        if (isFunctionExpression$1(id)) {
          continue;
        }
      }

      if (keys) {
        for (var i = 0; i < keys.length; i++) {
          var key = keys[i];

          if (id[key]) {
            search = search.concat(id[key]);
          }
        }
      }
    }

    return ids;
  }

  getBindingIdentifiers$2.keys = {
    DeclareClass: ["id"],
    DeclareFunction: ["id"],
    DeclareModule: ["id"],
    DeclareVariable: ["id"],
    DeclareInterface: ["id"],
    DeclareTypeAlias: ["id"],
    DeclareOpaqueType: ["id"],
    InterfaceDeclaration: ["id"],
    TypeAlias: ["id"],
    OpaqueType: ["id"],
    CatchClause: ["param"],
    LabeledStatement: ["label"],
    UnaryExpression: ["argument"],
    AssignmentExpression: ["left"],
    ImportSpecifier: ["local"],
    ImportNamespaceSpecifier: ["local"],
    ImportDefaultSpecifier: ["local"],
    ImportDeclaration: ["specifiers"],
    ExportSpecifier: ["exported"],
    ExportNamespaceSpecifier: ["exported"],
    ExportDefaultSpecifier: ["exported"],
    FunctionDeclaration: ["id", "params"],
    FunctionExpression: ["id", "params"],
    ArrowFunctionExpression: ["params"],
    ObjectMethod: ["params"],
    ClassMethod: ["params"],
    ClassPrivateMethod: ["params"],
    ForInStatement: ["left"],
    ForOfStatement: ["left"],
    ClassDeclaration: ["id"],
    ClassExpression: ["id"],
    RestElement: ["argument"],
    UpdateExpression: ["argument"],
    ObjectProperty: ["value"],
    AssignmentPattern: ["left"],
    ArrayPattern: ["elements"],
    ObjectPattern: ["properties"],
    VariableDeclaration: ["declarations"],
    VariableDeclarator: ["id"]
  };

  function gatherSequenceExpressions(nodes, scope, declars) {
    var exprs = [];
    var ensureLastUndefined = true;

    for (var _iterator = _createForOfIteratorHelperLoose(nodes), _step; !(_step = _iterator()).done;) {
      var node = _step.value;

      if (!isEmptyStatement$1(node)) {
        ensureLastUndefined = false;
      }

      if (isExpression$4(node)) {
        exprs.push(node);
      } else if (isExpressionStatement$4(node)) {
        exprs.push(node.expression);
      } else if (isVariableDeclaration$3(node)) {
        if (node.kind !== "var") return;

        for (var _iterator2 = _createForOfIteratorHelperLoose(node.declarations), _step2; !(_step2 = _iterator2()).done;) {
          var declar = _step2.value;
          var bindings = getBindingIdentifiers$2(declar);

          for (var _i = 0, _Object$keys = Object.keys(bindings); _i < _Object$keys.length; _i++) {
            var key = _Object$keys[_i];
            declars.push({
              kind: node.kind,
              id: cloneNode$i(bindings[key])
            });
          }

          if (declar.init) {
            exprs.push(assignmentExpression$c("=", declar.id, declar.init));
          }
        }

        ensureLastUndefined = true;
      } else if (isIfStatement$2(node)) {
        var consequent = node.consequent ? gatherSequenceExpressions([node.consequent], scope, declars) : scope.buildUndefinedNode();
        var alternate = node.alternate ? gatherSequenceExpressions([node.alternate], scope, declars) : scope.buildUndefinedNode();
        if (!consequent || !alternate) return;
        exprs.push(conditionalExpression$3(node.test, consequent, alternate));
      } else if (isBlockStatement$2(node)) {
        var body = gatherSequenceExpressions(node.body, scope, declars);
        if (!body) return;
        exprs.push(body);
      } else if (isEmptyStatement$1(node)) {
        if (nodes.indexOf(node) === 0) {
          ensureLastUndefined = true;
        }
      } else {
        return;
      }
    }

    if (ensureLastUndefined) {
      exprs.push(scope.buildUndefinedNode());
    }

    if (exprs.length === 1) {
      return exprs[0];
    } else {
      return sequenceExpression$7(exprs);
    }
  }

  function toSequenceExpression$1(nodes, scope) {
    if (!(nodes != null && nodes.length)) return;
    var declars = [];
    var result = gatherSequenceExpressions(nodes, scope, declars);
    if (!result) return;

    for (var _i = 0, _declars = declars; _i < _declars.length; _i++) {
      var declar = _declars[_i];
      scope.push(declar);
    }

    return result;
  }

  function toStatement(node, ignore) {
    if (isStatement$7(node)) {
      return node;
    }

    var mustHaveId = false;
    var newType;

    if (isClass$1(node)) {
      mustHaveId = true;
      newType = "ClassDeclaration";
    } else if (isFunction$4(node)) {
      mustHaveId = true;
      newType = "FunctionDeclaration";
    } else if (isAssignmentExpression$3(node)) {
      return expressionStatement$a(node);
    }

    if (mustHaveId && !node.id) {
      newType = false;
    }

    if (!newType) {
      if (ignore) {
        return false;
      } else {
        throw new Error("cannot turn " + node.type + " to a statement");
      }
    }

    node.type = newType;
    return node;
  }

  var objectToString = Function.call.bind(Object.prototype.toString);

  function isRegExp(value) {
    return objectToString(value) === "[object RegExp]";
  }

  function isPlainObject(value) {
    if (typeof value !== "object" || value === null || Object.prototype.toString.call(value) !== "[object Object]") {
      return false;
    }

    var proto = Object.getPrototypeOf(value);
    return proto === null || Object.getPrototypeOf(proto) === null;
  }

  function valueToNode$1(value) {
    if (value === undefined) {
      return identifier$j("undefined");
    }

    if (value === true || value === false) {
      return booleanLiteral$5(value);
    }

    if (value === null) {
      return nullLiteral$2();
    }

    if (typeof value === "string") {
      return stringLiteral$8(value);
    }

    if (typeof value === "number") {
      var result;

      if (Number.isFinite(value)) {
        result = numericLiteral$8(Math.abs(value));
      } else {
        var numerator;

        if (Number.isNaN(value)) {
          numerator = numericLiteral$8(0);
        } else {
          numerator = numericLiteral$8(1);
        }

        result = binaryExpression$4("/", numerator, numericLiteral$8(0));
      }

      if (value < 0 || Object.is(value, -0)) {
        result = unaryExpression$7("-", result);
      }

      return result;
    }

    if (isRegExp(value)) {
      var pattern = value.source;
      var flags = value.toString().match(/\/([a-z]+|)$/)[1];
      return regExpLiteral(pattern, flags);
    }

    if (Array.isArray(value)) {
      return arrayExpression$2(value.map(valueToNode$1));
    }

    if (isPlainObject(value)) {
      var props = [];

      for (var _i = 0, _Object$keys = Object.keys(value); _i < _Object$keys.length; _i++) {
        var key = _Object$keys[_i];
        var nodeKey = void 0;

        if (isValidIdentifier$1(key)) {
          nodeKey = identifier$j(key);
        } else {
          nodeKey = stringLiteral$8(key);
        }

        props.push(objectProperty$2(nodeKey, valueToNode$1(value[key])));
      }

      return objectExpression$4(props);
    }

    throw new Error("don't know how to turn this value into a node");
  }

  function appendToMemberExpression(member, append, computed) {
    if (computed === void 0) {
      computed = false;
    }

    member.object = memberExpression$b(member.object, member.property, member.computed);
    member.property = append;
    member.computed = !!computed;
    return member;
  }

  function inherits$1(child, parent) {
    if (!child || !parent) return child;

    for (var _iterator = _createForOfIteratorHelperLoose(INHERIT_KEYS.optional), _step; !(_step = _iterator()).done;) {
      var _key = _step.value;

      if (child[_key] == null) {
        child[_key] = parent[_key];
      }
    }

    for (var _i = 0, _Object$keys = Object.keys(parent); _i < _Object$keys.length; _i++) {
      var key = _Object$keys[_i];
      if (key[0] === "_" && key !== "__clone") child[key] = parent[key];
    }

    for (var _iterator2 = _createForOfIteratorHelperLoose(INHERIT_KEYS.force), _step2; !(_step2 = _iterator2()).done;) {
      var _key2 = _step2.value;
      child[_key2] = parent[_key2];
    }

    inheritsComments$2(child, parent);
    return child;
  }

  function prependToMemberExpression(member, prepend) {
    member.object = memberExpression$b(prepend, member.object);
    return member;
  }

  function getOuterBindingIdentifiers$2(node, duplicates) {
    return getBindingIdentifiers$2(node, duplicates, true);
  }

  function traverse$2(node, handlers, state) {
    if (typeof handlers === "function") {
      handlers = {
        enter: handlers
      };
    }

    var _ref = handlers,
        enter = _ref.enter,
        exit = _ref.exit;
    traverseSimpleImpl(node, enter, exit, state, []);
  }

  function traverseSimpleImpl(node, enter, exit, state, ancestors) {
    var keys = VISITOR_KEYS$6[node.type];
    if (!keys) return;
    if (enter) enter(node, ancestors, state);

    for (var _iterator = _createForOfIteratorHelperLoose(keys), _step; !(_step = _iterator()).done;) {
      var key = _step.value;
      var subNode = node[key];

      if (Array.isArray(subNode)) {
        for (var i = 0; i < subNode.length; i++) {
          var child = subNode[i];
          if (!child) continue;
          ancestors.push({
            node: node,
            key: key,
            index: i
          });
          traverseSimpleImpl(child, enter, exit, state, ancestors);
          ancestors.pop();
        }
      } else if (subNode) {
        ancestors.push({
          node: node,
          key: key
        });
        traverseSimpleImpl(subNode, enter, exit, state, ancestors);
        ancestors.pop();
      }
    }

    if (exit) exit(node, ancestors, state);
  }

  function isBinding$1(node, parent, grandparent) {
    if (grandparent && node.type === "Identifier" && parent.type === "ObjectProperty" && grandparent.type === "ObjectExpression") {
      return false;
    }

    var keys = getBindingIdentifiers$2.keys[parent.type];

    if (keys) {
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var val = parent[key];

        if (Array.isArray(val)) {
          if (val.indexOf(node) >= 0) return true;
        } else {
          if (val === node) return true;
        }
      }
    }

    return false;
  }

  function isLet(node) {
    return isVariableDeclaration$3(node) && (node.kind !== "var" || node[BLOCK_SCOPED_SYMBOL]);
  }

  function isBlockScoped$2(node) {
    return isFunctionDeclaration$1(node) || isClassDeclaration$3(node) || isLet(node);
  }

  function isImmutable(node) {
    if (isType$2(node.type, "Immutable")) return true;

    if (isIdentifier$g(node)) {
      if (node.name === "undefined") {
        return true;
      } else {
        return false;
      }
    }

    return false;
  }

  function isNodesEquivalent(a, b) {
    if (typeof a !== "object" || typeof b !== "object" || a == null || b == null) {
      return a === b;
    }

    if (a.type !== b.type) {
      return false;
    }

    var fields = Object.keys(NODE_FIELDS[a.type] || a.type);
    var visitorKeys = VISITOR_KEYS$6[a.type];

    for (var _i = 0, _fields = fields; _i < _fields.length; _i++) {
      var field = _fields[_i];

      if (typeof a[field] !== typeof b[field]) {
        return false;
      }

      if (a[field] == null && b[field] == null) {
        continue;
      } else if (a[field] == null || b[field] == null) {
        return false;
      }

      if (Array.isArray(a[field])) {
        if (!Array.isArray(b[field])) {
          return false;
        }

        if (a[field].length !== b[field].length) {
          return false;
        }

        for (var i = 0; i < a[field].length; i++) {
          if (!isNodesEquivalent(a[field][i], b[field][i])) {
            return false;
          }
        }

        continue;
      }

      if (typeof a[field] === "object" && !(visitorKeys != null && visitorKeys.includes(field))) {
        for (var _i2 = 0, _Object$keys = Object.keys(a[field]); _i2 < _Object$keys.length; _i2++) {
          var key = _Object$keys[_i2];

          if (a[field][key] !== b[field][key]) {
            return false;
          }
        }

        continue;
      }

      if (!isNodesEquivalent(a[field], b[field])) {
        return false;
      }
    }

    return true;
  }

  function isReferenced$2(node, parent, grandparent) {
    switch (parent.type) {
      case "MemberExpression":
      case "OptionalMemberExpression":
        if (parent.property === node) {
          return !!parent.computed;
        }

        return parent.object === node;

      case "JSXMemberExpression":
        return parent.object === node;

      case "VariableDeclarator":
        return parent.init === node;

      case "ArrowFunctionExpression":
        return parent.body === node;

      case "PrivateName":
        return false;

      case "ClassMethod":
      case "ClassPrivateMethod":
      case "ObjectMethod":
        if (parent.key === node) {
          return !!parent.computed;
        }

        return false;

      case "ObjectProperty":
        if (parent.key === node) {
          return !!parent.computed;
        }

        return !grandparent || grandparent.type !== "ObjectPattern";

      case "ClassProperty":
        if (parent.key === node) {
          return !!parent.computed;
        }

        return true;

      case "ClassPrivateProperty":
        return parent.key !== node;

      case "ClassDeclaration":
      case "ClassExpression":
        return parent.superClass === node;

      case "AssignmentExpression":
        return parent.right === node;

      case "AssignmentPattern":
        return parent.right === node;

      case "LabeledStatement":
        return false;

      case "CatchClause":
        return false;

      case "RestElement":
        return false;

      case "BreakStatement":
      case "ContinueStatement":
        return false;

      case "FunctionDeclaration":
      case "FunctionExpression":
        return false;

      case "ExportNamespaceSpecifier":
      case "ExportDefaultSpecifier":
        return false;

      case "ExportSpecifier":
        if (grandparent != null && grandparent.source) {
          return false;
        }

        return parent.local === node;

      case "ImportDefaultSpecifier":
      case "ImportNamespaceSpecifier":
      case "ImportSpecifier":
        return false;

      case "ImportAttribute":
        return false;

      case "JSXAttribute":
        return false;

      case "ObjectPattern":
      case "ArrayPattern":
        return false;

      case "MetaProperty":
        return false;

      case "ObjectTypeProperty":
        return parent.key !== node;

      case "TSEnumMember":
        return parent.id !== node;

      case "TSPropertySignature":
        if (parent.key === node) {
          return !!parent.computed;
        }

        return true;
    }

    return true;
  }

  function isScope$1(node, parent) {
    if (isBlockStatement$2(node) && (isFunction$4(parent) || isCatchClause(parent))) {
      return false;
    }

    if (isPattern(node) && (isFunction$4(parent) || isCatchClause(parent))) {
      return true;
    }

    return isScopable(node);
  }

  function isSpecifierDefault(specifier) {
    return isImportDefaultSpecifier$1(specifier) || isIdentifier$g(specifier.imported || specifier.exported, {
      name: "default"
    });
  }

  var RESERVED_WORDS_ES3_ONLY = new Set(["abstract", "boolean", "byte", "char", "double", "enum", "final", "float", "goto", "implements", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "synchronized", "throws", "transient", "volatile"]);
  function isValidES3Identifier(name) {
    return isValidIdentifier$1(name) && !RESERVED_WORDS_ES3_ONLY.has(name);
  }

  function isVar$2(node) {
    return isVariableDeclaration$3(node, {
      kind: "var"
    }) && !node[BLOCK_SCOPED_SYMBOL];
  }

  var react$3 = {
    isReactComponent: isReactComponent,
    isCompatTag: isCompatTag$1,
    buildChildren: buildChildren
  };

  var t$p = /*#__PURE__*/Object.freeze({
    __proto__: null,
    react: react$3,
    assertNode: assertNode,
    createTypeAnnotationBasedOnTypeof: createTypeAnnotationBasedOnTypeof$1,
    createUnionTypeAnnotation: createFlowUnionType$2,
    createFlowUnionType: createFlowUnionType$2,
    createTSUnionType: createTSUnionType$2,
    cloneNode: cloneNode$i,
    clone: clone,
    cloneDeep: cloneDeep$1,
    cloneDeepWithoutLoc: cloneDeepWithoutLoc,
    cloneWithoutLoc: cloneWithoutLoc,
    addComment: addComment$2,
    addComments: addComments$1,
    inheritInnerComments: inheritInnerComments,
    inheritLeadingComments: inheritLeadingComments$1,
    inheritsComments: inheritsComments$2,
    inheritTrailingComments: inheritTrailingComments$1,
    removeComments: removeComments$2,
    ensureBlock: ensureBlock$1,
    toBindingIdentifierName: toBindingIdentifierName$1,
    toBlock: toBlock,
    toComputedKey: toComputedKey$3,
    toExpression: toExpression,
    toIdentifier: toIdentifier$1,
    toKeyAlias: toKeyAlias$1,
    toSequenceExpression: toSequenceExpression$1,
    toStatement: toStatement,
    valueToNode: valueToNode$1,
    appendToMemberExpression: appendToMemberExpression,
    inherits: inherits$1,
    prependToMemberExpression: prependToMemberExpression,
    removeProperties: removeProperties$1,
    removePropertiesDeep: removePropertiesDeep$1,
    removeTypeDuplicates: removeTypeDuplicates$1,
    getBindingIdentifiers: getBindingIdentifiers$2,
    getOuterBindingIdentifiers: getOuterBindingIdentifiers$2,
    traverse: traverse$2,
    traverseFast: traverseFast$2,
    shallowEqual: shallowEqual,
    is: is$1,
    isBinding: isBinding$1,
    isBlockScoped: isBlockScoped$2,
    isImmutable: isImmutable,
    isLet: isLet,
    isNode: isNode,
    isNodesEquivalent: isNodesEquivalent,
    isPlaceholderType: isPlaceholderType,
    isReferenced: isReferenced$2,
    isScope: isScope$1,
    isSpecifierDefault: isSpecifierDefault,
    isType: isType$2,
    isValidES3Identifier: isValidES3Identifier,
    isValidIdentifier: isValidIdentifier$1,
    isVar: isVar$2,
    matchesPattern: matchesPattern$2,
    validate: validate$6,
    buildMatchMemberExpression: buildMatchMemberExpression$1,
    assertArrayExpression: assertArrayExpression,
    assertAssignmentExpression: assertAssignmentExpression,
    assertBinaryExpression: assertBinaryExpression,
    assertInterpreterDirective: assertInterpreterDirective,
    assertDirective: assertDirective,
    assertDirectiveLiteral: assertDirectiveLiteral,
    assertBlockStatement: assertBlockStatement,
    assertBreakStatement: assertBreakStatement,
    assertCallExpression: assertCallExpression,
    assertCatchClause: assertCatchClause,
    assertConditionalExpression: assertConditionalExpression,
    assertContinueStatement: assertContinueStatement,
    assertDebuggerStatement: assertDebuggerStatement,
    assertDoWhileStatement: assertDoWhileStatement,
    assertEmptyStatement: assertEmptyStatement,
    assertExpressionStatement: assertExpressionStatement$1,
    assertFile: assertFile,
    assertForInStatement: assertForInStatement,
    assertForStatement: assertForStatement,
    assertFunctionDeclaration: assertFunctionDeclaration,
    assertFunctionExpression: assertFunctionExpression,
    assertIdentifier: assertIdentifier,
    assertIfStatement: assertIfStatement,
    assertLabeledStatement: assertLabeledStatement,
    assertStringLiteral: assertStringLiteral,
    assertNumericLiteral: assertNumericLiteral,
    assertNullLiteral: assertNullLiteral,
    assertBooleanLiteral: assertBooleanLiteral,
    assertRegExpLiteral: assertRegExpLiteral,
    assertLogicalExpression: assertLogicalExpression,
    assertMemberExpression: assertMemberExpression,
    assertNewExpression: assertNewExpression,
    assertProgram: assertProgram,
    assertObjectExpression: assertObjectExpression,
    assertObjectMethod: assertObjectMethod,
    assertObjectProperty: assertObjectProperty,
    assertRestElement: assertRestElement,
    assertReturnStatement: assertReturnStatement,
    assertSequenceExpression: assertSequenceExpression,
    assertParenthesizedExpression: assertParenthesizedExpression,
    assertSwitchCase: assertSwitchCase,
    assertSwitchStatement: assertSwitchStatement,
    assertThisExpression: assertThisExpression,
    assertThrowStatement: assertThrowStatement,
    assertTryStatement: assertTryStatement,
    assertUnaryExpression: assertUnaryExpression,
    assertUpdateExpression: assertUpdateExpression,
    assertVariableDeclaration: assertVariableDeclaration,
    assertVariableDeclarator: assertVariableDeclarator,
    assertWhileStatement: assertWhileStatement,
    assertWithStatement: assertWithStatement,
    assertAssignmentPattern: assertAssignmentPattern,
    assertArrayPattern: assertArrayPattern,
    assertArrowFunctionExpression: assertArrowFunctionExpression,
    assertClassBody: assertClassBody,
    assertClassExpression: assertClassExpression,
    assertClassDeclaration: assertClassDeclaration,
    assertExportAllDeclaration: assertExportAllDeclaration,
    assertExportDefaultDeclaration: assertExportDefaultDeclaration,
    assertExportNamedDeclaration: assertExportNamedDeclaration,
    assertExportSpecifier: assertExportSpecifier$1,
    assertForOfStatement: assertForOfStatement,
    assertImportDeclaration: assertImportDeclaration,
    assertImportDefaultSpecifier: assertImportDefaultSpecifier,
    assertImportNamespaceSpecifier: assertImportNamespaceSpecifier,
    assertImportSpecifier: assertImportSpecifier,
    assertMetaProperty: assertMetaProperty,
    assertClassMethod: assertClassMethod,
    assertObjectPattern: assertObjectPattern,
    assertSpreadElement: assertSpreadElement,
    assertSuper: assertSuper,
    assertTaggedTemplateExpression: assertTaggedTemplateExpression,
    assertTemplateElement: assertTemplateElement,
    assertTemplateLiteral: assertTemplateLiteral,
    assertYieldExpression: assertYieldExpression,
    assertAwaitExpression: assertAwaitExpression,
    assertImport: assertImport,
    assertBigIntLiteral: assertBigIntLiteral,
    assertExportNamespaceSpecifier: assertExportNamespaceSpecifier,
    assertOptionalMemberExpression: assertOptionalMemberExpression,
    assertOptionalCallExpression: assertOptionalCallExpression,
    assertClassProperty: assertClassProperty,
    assertClassPrivateProperty: assertClassPrivateProperty,
    assertClassPrivateMethod: assertClassPrivateMethod,
    assertPrivateName: assertPrivateName,
    assertAnyTypeAnnotation: assertAnyTypeAnnotation,
    assertArrayTypeAnnotation: assertArrayTypeAnnotation,
    assertBooleanTypeAnnotation: assertBooleanTypeAnnotation,
    assertBooleanLiteralTypeAnnotation: assertBooleanLiteralTypeAnnotation,
    assertNullLiteralTypeAnnotation: assertNullLiteralTypeAnnotation,
    assertClassImplements: assertClassImplements,
    assertDeclareClass: assertDeclareClass,
    assertDeclareFunction: assertDeclareFunction,
    assertDeclareInterface: assertDeclareInterface,
    assertDeclareModule: assertDeclareModule,
    assertDeclareModuleExports: assertDeclareModuleExports,
    assertDeclareTypeAlias: assertDeclareTypeAlias,
    assertDeclareOpaqueType: assertDeclareOpaqueType,
    assertDeclareVariable: assertDeclareVariable,
    assertDeclareExportDeclaration: assertDeclareExportDeclaration,
    assertDeclareExportAllDeclaration: assertDeclareExportAllDeclaration,
    assertDeclaredPredicate: assertDeclaredPredicate,
    assertExistsTypeAnnotation: assertExistsTypeAnnotation,
    assertFunctionTypeAnnotation: assertFunctionTypeAnnotation,
    assertFunctionTypeParam: assertFunctionTypeParam,
    assertGenericTypeAnnotation: assertGenericTypeAnnotation,
    assertInferredPredicate: assertInferredPredicate,
    assertInterfaceExtends: assertInterfaceExtends,
    assertInterfaceDeclaration: assertInterfaceDeclaration,
    assertInterfaceTypeAnnotation: assertInterfaceTypeAnnotation,
    assertIntersectionTypeAnnotation: assertIntersectionTypeAnnotation,
    assertMixedTypeAnnotation: assertMixedTypeAnnotation,
    assertEmptyTypeAnnotation: assertEmptyTypeAnnotation,
    assertNullableTypeAnnotation: assertNullableTypeAnnotation,
    assertNumberLiteralTypeAnnotation: assertNumberLiteralTypeAnnotation,
    assertNumberTypeAnnotation: assertNumberTypeAnnotation,
    assertObjectTypeAnnotation: assertObjectTypeAnnotation,
    assertObjectTypeInternalSlot: assertObjectTypeInternalSlot,
    assertObjectTypeCallProperty: assertObjectTypeCallProperty,
    assertObjectTypeIndexer: assertObjectTypeIndexer,
    assertObjectTypeProperty: assertObjectTypeProperty,
    assertObjectTypeSpreadProperty: assertObjectTypeSpreadProperty,
    assertOpaqueType: assertOpaqueType,
    assertQualifiedTypeIdentifier: assertQualifiedTypeIdentifier,
    assertStringLiteralTypeAnnotation: assertStringLiteralTypeAnnotation,
    assertStringTypeAnnotation: assertStringTypeAnnotation,
    assertSymbolTypeAnnotation: assertSymbolTypeAnnotation,
    assertThisTypeAnnotation: assertThisTypeAnnotation,
    assertTupleTypeAnnotation: assertTupleTypeAnnotation,
    assertTypeofTypeAnnotation: assertTypeofTypeAnnotation,
    assertTypeAlias: assertTypeAlias,
    assertTypeAnnotation: assertTypeAnnotation,
    assertTypeCastExpression: assertTypeCastExpression,
    assertTypeParameter: assertTypeParameter,
    assertTypeParameterDeclaration: assertTypeParameterDeclaration,
    assertTypeParameterInstantiation: assertTypeParameterInstantiation,
    assertUnionTypeAnnotation: assertUnionTypeAnnotation,
    assertVariance: assertVariance,
    assertVoidTypeAnnotation: assertVoidTypeAnnotation,
    assertEnumDeclaration: assertEnumDeclaration,
    assertEnumBooleanBody: assertEnumBooleanBody,
    assertEnumNumberBody: assertEnumNumberBody,
    assertEnumStringBody: assertEnumStringBody,
    assertEnumSymbolBody: assertEnumSymbolBody,
    assertEnumBooleanMember: assertEnumBooleanMember,
    assertEnumNumberMember: assertEnumNumberMember,
    assertEnumStringMember: assertEnumStringMember,
    assertEnumDefaultedMember: assertEnumDefaultedMember,
    assertIndexedAccessType: assertIndexedAccessType,
    assertOptionalIndexedAccessType: assertOptionalIndexedAccessType,
    assertJSXAttribute: assertJSXAttribute,
    assertJSXClosingElement: assertJSXClosingElement,
    assertJSXElement: assertJSXElement,
    assertJSXEmptyExpression: assertJSXEmptyExpression,
    assertJSXExpressionContainer: assertJSXExpressionContainer,
    assertJSXSpreadChild: assertJSXSpreadChild,
    assertJSXIdentifier: assertJSXIdentifier,
    assertJSXMemberExpression: assertJSXMemberExpression,
    assertJSXNamespacedName: assertJSXNamespacedName,
    assertJSXOpeningElement: assertJSXOpeningElement,
    assertJSXSpreadAttribute: assertJSXSpreadAttribute,
    assertJSXText: assertJSXText,
    assertJSXFragment: assertJSXFragment,
    assertJSXOpeningFragment: assertJSXOpeningFragment,
    assertJSXClosingFragment: assertJSXClosingFragment,
    assertNoop: assertNoop,
    assertPlaceholder: assertPlaceholder,
    assertV8IntrinsicIdentifier: assertV8IntrinsicIdentifier,
    assertArgumentPlaceholder: assertArgumentPlaceholder,
    assertBindExpression: assertBindExpression,
    assertImportAttribute: assertImportAttribute,
    assertDecorator: assertDecorator,
    assertDoExpression: assertDoExpression,
    assertExportDefaultSpecifier: assertExportDefaultSpecifier,
    assertRecordExpression: assertRecordExpression,
    assertTupleExpression: assertTupleExpression,
    assertDecimalLiteral: assertDecimalLiteral,
    assertStaticBlock: assertStaticBlock,
    assertModuleExpression: assertModuleExpression,
    assertTopicReference: assertTopicReference,
    assertPipelineTopicExpression: assertPipelineTopicExpression,
    assertPipelineBareFunction: assertPipelineBareFunction,
    assertPipelinePrimaryTopicReference: assertPipelinePrimaryTopicReference,
    assertTSParameterProperty: assertTSParameterProperty,
    assertTSDeclareFunction: assertTSDeclareFunction,
    assertTSDeclareMethod: assertTSDeclareMethod,
    assertTSQualifiedName: assertTSQualifiedName,
    assertTSCallSignatureDeclaration: assertTSCallSignatureDeclaration,
    assertTSConstructSignatureDeclaration: assertTSConstructSignatureDeclaration,
    assertTSPropertySignature: assertTSPropertySignature,
    assertTSMethodSignature: assertTSMethodSignature,
    assertTSIndexSignature: assertTSIndexSignature,
    assertTSAnyKeyword: assertTSAnyKeyword,
    assertTSBooleanKeyword: assertTSBooleanKeyword,
    assertTSBigIntKeyword: assertTSBigIntKeyword,
    assertTSIntrinsicKeyword: assertTSIntrinsicKeyword,
    assertTSNeverKeyword: assertTSNeverKeyword,
    assertTSNullKeyword: assertTSNullKeyword,
    assertTSNumberKeyword: assertTSNumberKeyword,
    assertTSObjectKeyword: assertTSObjectKeyword,
    assertTSStringKeyword: assertTSStringKeyword,
    assertTSSymbolKeyword: assertTSSymbolKeyword,
    assertTSUndefinedKeyword: assertTSUndefinedKeyword,
    assertTSUnknownKeyword: assertTSUnknownKeyword,
    assertTSVoidKeyword: assertTSVoidKeyword,
    assertTSThisType: assertTSThisType,
    assertTSFunctionType: assertTSFunctionType,
    assertTSConstructorType: assertTSConstructorType,
    assertTSTypeReference: assertTSTypeReference,
    assertTSTypePredicate: assertTSTypePredicate,
    assertTSTypeQuery: assertTSTypeQuery,
    assertTSTypeLiteral: assertTSTypeLiteral,
    assertTSArrayType: assertTSArrayType,
    assertTSTupleType: assertTSTupleType,
    assertTSOptionalType: assertTSOptionalType,
    assertTSRestType: assertTSRestType,
    assertTSNamedTupleMember: assertTSNamedTupleMember,
    assertTSUnionType: assertTSUnionType,
    assertTSIntersectionType: assertTSIntersectionType,
    assertTSConditionalType: assertTSConditionalType,
    assertTSInferType: assertTSInferType,
    assertTSParenthesizedType: assertTSParenthesizedType,
    assertTSTypeOperator: assertTSTypeOperator,
    assertTSIndexedAccessType: assertTSIndexedAccessType,
    assertTSMappedType: assertTSMappedType,
    assertTSLiteralType: assertTSLiteralType,
    assertTSExpressionWithTypeArguments: assertTSExpressionWithTypeArguments,
    assertTSInterfaceDeclaration: assertTSInterfaceDeclaration,
    assertTSInterfaceBody: assertTSInterfaceBody,
    assertTSTypeAliasDeclaration: assertTSTypeAliasDeclaration,
    assertTSAsExpression: assertTSAsExpression,
    assertTSTypeAssertion: assertTSTypeAssertion,
    assertTSEnumDeclaration: assertTSEnumDeclaration,
    assertTSEnumMember: assertTSEnumMember,
    assertTSModuleDeclaration: assertTSModuleDeclaration,
    assertTSModuleBlock: assertTSModuleBlock,
    assertTSImportType: assertTSImportType,
    assertTSImportEqualsDeclaration: assertTSImportEqualsDeclaration,
    assertTSExternalModuleReference: assertTSExternalModuleReference,
    assertTSNonNullExpression: assertTSNonNullExpression,
    assertTSExportAssignment: assertTSExportAssignment,
    assertTSNamespaceExportDeclaration: assertTSNamespaceExportDeclaration,
    assertTSTypeAnnotation: assertTSTypeAnnotation,
    assertTSTypeParameterInstantiation: assertTSTypeParameterInstantiation,
    assertTSTypeParameterDeclaration: assertTSTypeParameterDeclaration,
    assertTSTypeParameter: assertTSTypeParameter,
    assertExpression: assertExpression$1,
    assertBinary: assertBinary,
    assertScopable: assertScopable,
    assertBlockParent: assertBlockParent,
    assertBlock: assertBlock,
    assertStatement: assertStatement,
    assertTerminatorless: assertTerminatorless,
    assertCompletionStatement: assertCompletionStatement,
    assertConditional: assertConditional,
    assertLoop: assertLoop,
    assertWhile: assertWhile,
    assertExpressionWrapper: assertExpressionWrapper,
    assertFor: assertFor,
    assertForXStatement: assertForXStatement,
    assertFunction: assertFunction$1,
    assertFunctionParent: assertFunctionParent,
    assertPureish: assertPureish,
    assertDeclaration: assertDeclaration,
    assertPatternLike: assertPatternLike,
    assertLVal: assertLVal,
    assertTSEntityName: assertTSEntityName,
    assertLiteral: assertLiteral,
    assertImmutable: assertImmutable,
    assertUserWhitespacable: assertUserWhitespacable,
    assertMethod: assertMethod,
    assertObjectMember: assertObjectMember,
    assertProperty: assertProperty,
    assertUnaryLike: assertUnaryLike,
    assertPattern: assertPattern,
    assertClass: assertClass,
    assertModuleDeclaration: assertModuleDeclaration,
    assertExportDeclaration: assertExportDeclaration,
    assertModuleSpecifier: assertModuleSpecifier,
    assertPrivate: assertPrivate,
    assertFlow: assertFlow,
    assertFlowType: assertFlowType,
    assertFlowBaseAnnotation: assertFlowBaseAnnotation,
    assertFlowDeclaration: assertFlowDeclaration,
    assertFlowPredicate: assertFlowPredicate,
    assertEnumBody: assertEnumBody,
    assertEnumMember: assertEnumMember,
    assertJSX: assertJSX,
    assertTSTypeElement: assertTSTypeElement,
    assertTSType: assertTSType,
    assertTSBaseType: assertTSBaseType,
    assertNumberLiteral: assertNumberLiteral,
    assertRegexLiteral: assertRegexLiteral,
    assertRestProperty: assertRestProperty,
    assertSpreadProperty: assertSpreadProperty,
    arrayExpression: arrayExpression$2,
    assignmentExpression: assignmentExpression$c,
    binaryExpression: binaryExpression$4,
    interpreterDirective: interpreterDirective$1,
    directive: directive$1,
    directiveLiteral: directiveLiteral$1,
    blockStatement: blockStatement$6,
    breakStatement: breakStatement,
    callExpression: callExpression$e,
    catchClause: catchClause,
    conditionalExpression: conditionalExpression$3,
    continueStatement: continueStatement,
    debuggerStatement: debuggerStatement,
    doWhileStatement: doWhileStatement,
    emptyStatement: emptyStatement$1,
    expressionStatement: expressionStatement$a,
    file: file$1,
    forInStatement: forInStatement,
    forStatement: forStatement,
    functionDeclaration: functionDeclaration,
    functionExpression: functionExpression$3,
    identifier: identifier$j,
    ifStatement: ifStatement,
    labeledStatement: labeledStatement,
    stringLiteral: stringLiteral$8,
    numericLiteral: numericLiteral$8,
    nullLiteral: nullLiteral$2,
    booleanLiteral: booleanLiteral$5,
    regExpLiteral: regExpLiteral,
    logicalExpression: logicalExpression$2,
    memberExpression: memberExpression$b,
    newExpression: newExpression,
    program: program$3,
    objectExpression: objectExpression$4,
    objectMethod: objectMethod,
    objectProperty: objectProperty$2,
    restElement: restElement$1,
    returnStatement: returnStatement$3,
    sequenceExpression: sequenceExpression$7,
    parenthesizedExpression: parenthesizedExpression,
    switchCase: switchCase,
    switchStatement: switchStatement,
    thisExpression: thisExpression$3,
    throwStatement: throwStatement,
    tryStatement: tryStatement,
    unaryExpression: unaryExpression$7,
    updateExpression: updateExpression,
    variableDeclaration: variableDeclaration$8,
    variableDeclarator: variableDeclarator$8,
    whileStatement: whileStatement,
    withStatement: withStatement,
    assignmentPattern: assignmentPattern,
    arrayPattern: arrayPattern,
    arrowFunctionExpression: arrowFunctionExpression$4,
    classBody: classBody,
    classExpression: classExpression,
    classDeclaration: classDeclaration,
    exportAllDeclaration: exportAllDeclaration,
    exportDefaultDeclaration: exportDefaultDeclaration,
    exportNamedDeclaration: exportNamedDeclaration$2,
    exportSpecifier: exportSpecifier$2,
    forOfStatement: forOfStatement,
    importDeclaration: importDeclaration$1,
    importDefaultSpecifier: importDefaultSpecifier$1,
    importNamespaceSpecifier: importNamespaceSpecifier$1,
    importSpecifier: importSpecifier$1,
    metaProperty: metaProperty$1,
    classMethod: classMethod,
    objectPattern: objectPattern,
    spreadElement: spreadElement$2,
    'super': _super$1,
    taggedTemplateExpression: taggedTemplateExpression,
    templateElement: templateElement,
    templateLiteral: templateLiteral,
    yieldExpression: yieldExpression$2,
    awaitExpression: awaitExpression$1,
    'import': _import,
    bigIntLiteral: bigIntLiteral,
    exportNamespaceSpecifier: exportNamespaceSpecifier,
    optionalMemberExpression: optionalMemberExpression$2,
    optionalCallExpression: optionalCallExpression$2,
    classProperty: classProperty,
    classPrivateProperty: classPrivateProperty,
    classPrivateMethod: classPrivateMethod,
    privateName: privateName,
    anyTypeAnnotation: anyTypeAnnotation$2,
    arrayTypeAnnotation: arrayTypeAnnotation$1,
    booleanTypeAnnotation: booleanTypeAnnotation$1,
    booleanLiteralTypeAnnotation: booleanLiteralTypeAnnotation,
    nullLiteralTypeAnnotation: nullLiteralTypeAnnotation$1,
    classImplements: classImplements,
    declareClass: declareClass,
    declareFunction: declareFunction,
    declareInterface: declareInterface,
    declareModule: declareModule,
    declareModuleExports: declareModuleExports,
    declareTypeAlias: declareTypeAlias,
    declareOpaqueType: declareOpaqueType,
    declareVariable: declareVariable,
    declareExportDeclaration: declareExportDeclaration,
    declareExportAllDeclaration: declareExportAllDeclaration,
    declaredPredicate: declaredPredicate,
    existsTypeAnnotation: existsTypeAnnotation,
    functionTypeAnnotation: functionTypeAnnotation,
    functionTypeParam: functionTypeParam,
    genericTypeAnnotation: genericTypeAnnotation$1,
    inferredPredicate: inferredPredicate,
    interfaceExtends: interfaceExtends,
    interfaceDeclaration: interfaceDeclaration,
    interfaceTypeAnnotation: interfaceTypeAnnotation,
    intersectionTypeAnnotation: intersectionTypeAnnotation,
    mixedTypeAnnotation: mixedTypeAnnotation,
    emptyTypeAnnotation: emptyTypeAnnotation,
    nullableTypeAnnotation: nullableTypeAnnotation,
    numberLiteralTypeAnnotation: numberLiteralTypeAnnotation,
    numberTypeAnnotation: numberTypeAnnotation$2,
    objectTypeAnnotation: objectTypeAnnotation,
    objectTypeInternalSlot: objectTypeInternalSlot,
    objectTypeCallProperty: objectTypeCallProperty,
    objectTypeIndexer: objectTypeIndexer,
    objectTypeProperty: objectTypeProperty,
    objectTypeSpreadProperty: objectTypeSpreadProperty,
    opaqueType: opaqueType,
    qualifiedTypeIdentifier: qualifiedTypeIdentifier,
    stringLiteralTypeAnnotation: stringLiteralTypeAnnotation,
    stringTypeAnnotation: stringTypeAnnotation$2,
    symbolTypeAnnotation: symbolTypeAnnotation,
    thisTypeAnnotation: thisTypeAnnotation,
    tupleTypeAnnotation: tupleTypeAnnotation$1,
    typeofTypeAnnotation: typeofTypeAnnotation,
    typeAlias: typeAlias,
    typeAnnotation: typeAnnotation,
    typeCastExpression: typeCastExpression,
    typeParameter: typeParameter,
    typeParameterDeclaration: typeParameterDeclaration,
    typeParameterInstantiation: typeParameterInstantiation,
    unionTypeAnnotation: unionTypeAnnotation$1,
    variance: variance,
    voidTypeAnnotation: voidTypeAnnotation$3,
    enumDeclaration: enumDeclaration,
    enumBooleanBody: enumBooleanBody,
    enumNumberBody: enumNumberBody,
    enumStringBody: enumStringBody,
    enumSymbolBody: enumSymbolBody,
    enumBooleanMember: enumBooleanMember,
    enumNumberMember: enumNumberMember,
    enumStringMember: enumStringMember,
    enumDefaultedMember: enumDefaultedMember,
    indexedAccessType: indexedAccessType,
    optionalIndexedAccessType: optionalIndexedAccessType,
    jsxAttribute: jsxAttribute,
    jSXAttribute: jsxAttribute,
    jsxClosingElement: jsxClosingElement,
    jSXClosingElement: jsxClosingElement,
    jsxElement: jsxElement,
    jSXElement: jsxElement,
    jsxEmptyExpression: jsxEmptyExpression,
    jSXEmptyExpression: jsxEmptyExpression,
    jsxExpressionContainer: jsxExpressionContainer$1,
    jSXExpressionContainer: jsxExpressionContainer$1,
    jsxSpreadChild: jsxSpreadChild,
    jSXSpreadChild: jsxSpreadChild,
    jsxIdentifier: jsxIdentifier$2,
    jSXIdentifier: jsxIdentifier$2,
    jsxMemberExpression: jsxMemberExpression$1,
    jSXMemberExpression: jsxMemberExpression$1,
    jsxNamespacedName: jsxNamespacedName,
    jSXNamespacedName: jsxNamespacedName,
    jsxOpeningElement: jsxOpeningElement,
    jSXOpeningElement: jsxOpeningElement,
    jsxSpreadAttribute: jsxSpreadAttribute,
    jSXSpreadAttribute: jsxSpreadAttribute,
    jsxText: jsxText,
    jSXText: jsxText,
    jsxFragment: jsxFragment,
    jSXFragment: jsxFragment,
    jsxOpeningFragment: jsxOpeningFragment,
    jSXOpeningFragment: jsxOpeningFragment,
    jsxClosingFragment: jsxClosingFragment,
    jSXClosingFragment: jsxClosingFragment,
    noop: noop$1,
    placeholder: placeholder,
    v8IntrinsicIdentifier: v8IntrinsicIdentifier,
    argumentPlaceholder: argumentPlaceholder,
    bindExpression: bindExpression,
    importAttribute: importAttribute,
    decorator: decorator,
    doExpression: doExpression,
    exportDefaultSpecifier: exportDefaultSpecifier,
    recordExpression: recordExpression,
    tupleExpression: tupleExpression,
    decimalLiteral: decimalLiteral,
    staticBlock: staticBlock$1,
    moduleExpression: moduleExpression,
    topicReference: topicReference,
    pipelineTopicExpression: pipelineTopicExpression,
    pipelineBareFunction: pipelineBareFunction,
    pipelinePrimaryTopicReference: pipelinePrimaryTopicReference,
    tsParameterProperty: tsParameterProperty,
    tSParameterProperty: tsParameterProperty,
    tsDeclareFunction: tsDeclareFunction,
    tSDeclareFunction: tsDeclareFunction,
    tsDeclareMethod: tsDeclareMethod,
    tSDeclareMethod: tsDeclareMethod,
    tsQualifiedName: tsQualifiedName,
    tSQualifiedName: tsQualifiedName,
    tsCallSignatureDeclaration: tsCallSignatureDeclaration,
    tSCallSignatureDeclaration: tsCallSignatureDeclaration,
    tsConstructSignatureDeclaration: tsConstructSignatureDeclaration,
    tSConstructSignatureDeclaration: tsConstructSignatureDeclaration,
    tsPropertySignature: tsPropertySignature,
    tSPropertySignature: tsPropertySignature,
    tsMethodSignature: tsMethodSignature,
    tSMethodSignature: tsMethodSignature,
    tsIndexSignature: tsIndexSignature,
    tSIndexSignature: tsIndexSignature,
    tsAnyKeyword: tsAnyKeyword,
    tSAnyKeyword: tsAnyKeyword,
    tsBooleanKeyword: tsBooleanKeyword,
    tSBooleanKeyword: tsBooleanKeyword,
    tsBigIntKeyword: tsBigIntKeyword,
    tSBigIntKeyword: tsBigIntKeyword,
    tsIntrinsicKeyword: tsIntrinsicKeyword,
    tSIntrinsicKeyword: tsIntrinsicKeyword,
    tsNeverKeyword: tsNeverKeyword,
    tSNeverKeyword: tsNeverKeyword,
    tsNullKeyword: tsNullKeyword,
    tSNullKeyword: tsNullKeyword,
    tsNumberKeyword: tsNumberKeyword,
    tSNumberKeyword: tsNumberKeyword,
    tsObjectKeyword: tsObjectKeyword,
    tSObjectKeyword: tsObjectKeyword,
    tsStringKeyword: tsStringKeyword,
    tSStringKeyword: tsStringKeyword,
    tsSymbolKeyword: tsSymbolKeyword,
    tSSymbolKeyword: tsSymbolKeyword,
    tsUndefinedKeyword: tsUndefinedKeyword,
    tSUndefinedKeyword: tsUndefinedKeyword,
    tsUnknownKeyword: tsUnknownKeyword,
    tSUnknownKeyword: tsUnknownKeyword,
    tsVoidKeyword: tsVoidKeyword,
    tSVoidKeyword: tsVoidKeyword,
    tsThisType: tsThisType,
    tSThisType: tsThisType,
    tsFunctionType: tsFunctionType,
    tSFunctionType: tsFunctionType,
    tsConstructorType: tsConstructorType,
    tSConstructorType: tsConstructorType,
    tsTypeReference: tsTypeReference,
    tSTypeReference: tsTypeReference,
    tsTypePredicate: tsTypePredicate,
    tSTypePredicate: tsTypePredicate,
    tsTypeQuery: tsTypeQuery,
    tSTypeQuery: tsTypeQuery,
    tsTypeLiteral: tsTypeLiteral,
    tSTypeLiteral: tsTypeLiteral,
    tsArrayType: tsArrayType,
    tSArrayType: tsArrayType,
    tsTupleType: tsTupleType,
    tSTupleType: tsTupleType,
    tsOptionalType: tsOptionalType,
    tSOptionalType: tsOptionalType,
    tsRestType: tsRestType,
    tSRestType: tsRestType,
    tsNamedTupleMember: tsNamedTupleMember,
    tSNamedTupleMember: tsNamedTupleMember,
    tsUnionType: tsUnionType,
    tSUnionType: tsUnionType,
    tsIntersectionType: tsIntersectionType,
    tSIntersectionType: tsIntersectionType,
    tsConditionalType: tsConditionalType,
    tSConditionalType: tsConditionalType,
    tsInferType: tsInferType,
    tSInferType: tsInferType,
    tsParenthesizedType: tsParenthesizedType,
    tSParenthesizedType: tsParenthesizedType,
    tsTypeOperator: tsTypeOperator,
    tSTypeOperator: tsTypeOperator,
    tsIndexedAccessType: tsIndexedAccessType,
    tSIndexedAccessType: tsIndexedAccessType,
    tsMappedType: tsMappedType,
    tSMappedType: tsMappedType,
    tsLiteralType: tsLiteralType,
    tSLiteralType: tsLiteralType,
    tsExpressionWithTypeArguments: tsExpressionWithTypeArguments,
    tSExpressionWithTypeArguments: tsExpressionWithTypeArguments,
    tsInterfaceDeclaration: tsInterfaceDeclaration,
    tSInterfaceDeclaration: tsInterfaceDeclaration,
    tsInterfaceBody: tsInterfaceBody,
    tSInterfaceBody: tsInterfaceBody,
    tsTypeAliasDeclaration: tsTypeAliasDeclaration,
    tSTypeAliasDeclaration: tsTypeAliasDeclaration,
    tsAsExpression: tsAsExpression,
    tSAsExpression: tsAsExpression,
    tsTypeAssertion: tsTypeAssertion,
    tSTypeAssertion: tsTypeAssertion,
    tsEnumDeclaration: tsEnumDeclaration,
    tSEnumDeclaration: tsEnumDeclaration,
    tsEnumMember: tsEnumMember,
    tSEnumMember: tsEnumMember,
    tsModuleDeclaration: tsModuleDeclaration,
    tSModuleDeclaration: tsModuleDeclaration,
    tsModuleBlock: tsModuleBlock,
    tSModuleBlock: tsModuleBlock,
    tsImportType: tsImportType,
    tSImportType: tsImportType,
    tsImportEqualsDeclaration: tsImportEqualsDeclaration,
    tSImportEqualsDeclaration: tsImportEqualsDeclaration,
    tsExternalModuleReference: tsExternalModuleReference,
    tSExternalModuleReference: tsExternalModuleReference,
    tsNonNullExpression: tsNonNullExpression,
    tSNonNullExpression: tsNonNullExpression,
    tsExportAssignment: tsExportAssignment,
    tSExportAssignment: tsExportAssignment,
    tsNamespaceExportDeclaration: tsNamespaceExportDeclaration,
    tSNamespaceExportDeclaration: tsNamespaceExportDeclaration,
    tsTypeAnnotation: tsTypeAnnotation,
    tSTypeAnnotation: tsTypeAnnotation,
    tsTypeParameterInstantiation: tsTypeParameterInstantiation,
    tSTypeParameterInstantiation: tsTypeParameterInstantiation,
    tsTypeParameterDeclaration: tsTypeParameterDeclaration,
    tSTypeParameterDeclaration: tsTypeParameterDeclaration,
    tsTypeParameter: tsTypeParameter,
    tSTypeParameter: tsTypeParameter,
    numberLiteral: NumberLiteral,
    regexLiteral: RegexLiteral,
    restProperty: RestProperty$1,
    spreadProperty: SpreadProperty$1,
    ArrayExpression: arrayExpression$2,
    AssignmentExpression: assignmentExpression$c,
    BinaryExpression: binaryExpression$4,
    InterpreterDirective: interpreterDirective$1,
    Directive: directive$1,
    DirectiveLiteral: directiveLiteral$1,
    BlockStatement: blockStatement$6,
    BreakStatement: breakStatement,
    CallExpression: callExpression$e,
    CatchClause: catchClause,
    ConditionalExpression: conditionalExpression$3,
    ContinueStatement: continueStatement,
    DebuggerStatement: debuggerStatement,
    DoWhileStatement: doWhileStatement,
    EmptyStatement: emptyStatement$1,
    ExpressionStatement: expressionStatement$a,
    File: file$1,
    ForInStatement: forInStatement,
    ForStatement: forStatement,
    FunctionDeclaration: functionDeclaration,
    FunctionExpression: functionExpression$3,
    Identifier: identifier$j,
    IfStatement: ifStatement,
    LabeledStatement: labeledStatement,
    StringLiteral: stringLiteral$8,
    NumericLiteral: numericLiteral$8,
    NullLiteral: nullLiteral$2,
    BooleanLiteral: booleanLiteral$5,
    RegExpLiteral: regExpLiteral,
    LogicalExpression: logicalExpression$2,
    MemberExpression: memberExpression$b,
    NewExpression: newExpression,
    Program: program$3,
    ObjectExpression: objectExpression$4,
    ObjectMethod: objectMethod,
    ObjectProperty: objectProperty$2,
    RestElement: restElement$1,
    ReturnStatement: returnStatement$3,
    SequenceExpression: sequenceExpression$7,
    ParenthesizedExpression: parenthesizedExpression,
    SwitchCase: switchCase,
    SwitchStatement: switchStatement,
    ThisExpression: thisExpression$3,
    ThrowStatement: throwStatement,
    TryStatement: tryStatement,
    UnaryExpression: unaryExpression$7,
    UpdateExpression: updateExpression,
    VariableDeclaration: variableDeclaration$8,
    VariableDeclarator: variableDeclarator$8,
    WhileStatement: whileStatement,
    WithStatement: withStatement,
    AssignmentPattern: assignmentPattern,
    ArrayPattern: arrayPattern,
    ArrowFunctionExpression: arrowFunctionExpression$4,
    ClassBody: classBody,
    ClassExpression: classExpression,
    ClassDeclaration: classDeclaration,
    ExportAllDeclaration: exportAllDeclaration,
    ExportDefaultDeclaration: exportDefaultDeclaration,
    ExportNamedDeclaration: exportNamedDeclaration$2,
    ExportSpecifier: exportSpecifier$2,
    ForOfStatement: forOfStatement,
    ImportDeclaration: importDeclaration$1,
    ImportDefaultSpecifier: importDefaultSpecifier$1,
    ImportNamespaceSpecifier: importNamespaceSpecifier$1,
    ImportSpecifier: importSpecifier$1,
    MetaProperty: metaProperty$1,
    ClassMethod: classMethod,
    ObjectPattern: objectPattern,
    SpreadElement: spreadElement$2,
    Super: _super$1,
    TaggedTemplateExpression: taggedTemplateExpression,
    TemplateElement: templateElement,
    TemplateLiteral: templateLiteral,
    YieldExpression: yieldExpression$2,
    AwaitExpression: awaitExpression$1,
    Import: _import,
    BigIntLiteral: bigIntLiteral,
    ExportNamespaceSpecifier: exportNamespaceSpecifier,
    OptionalMemberExpression: optionalMemberExpression$2,
    OptionalCallExpression: optionalCallExpression$2,
    ClassProperty: classProperty,
    ClassPrivateProperty: classPrivateProperty,
    ClassPrivateMethod: classPrivateMethod,
    PrivateName: privateName,
    AnyTypeAnnotation: anyTypeAnnotation$2,
    ArrayTypeAnnotation: arrayTypeAnnotation$1,
    BooleanTypeAnnotation: booleanTypeAnnotation$1,
    BooleanLiteralTypeAnnotation: booleanLiteralTypeAnnotation,
    NullLiteralTypeAnnotation: nullLiteralTypeAnnotation$1,
    ClassImplements: classImplements,
    DeclareClass: declareClass,
    DeclareFunction: declareFunction,
    DeclareInterface: declareInterface,
    DeclareModule: declareModule,
    DeclareModuleExports: declareModuleExports,
    DeclareTypeAlias: declareTypeAlias,
    DeclareOpaqueType: declareOpaqueType,
    DeclareVariable: declareVariable,
    DeclareExportDeclaration: declareExportDeclaration,
    DeclareExportAllDeclaration: declareExportAllDeclaration,
    DeclaredPredicate: declaredPredicate,
    ExistsTypeAnnotation: existsTypeAnnotation,
    FunctionTypeAnnotation: functionTypeAnnotation,
    FunctionTypeParam: functionTypeParam,
    GenericTypeAnnotation: genericTypeAnnotation$1,
    InferredPredicate: inferredPredicate,
    InterfaceExtends: interfaceExtends,
    InterfaceDeclaration: interfaceDeclaration,
    InterfaceTypeAnnotation: interfaceTypeAnnotation,
    IntersectionTypeAnnotation: intersectionTypeAnnotation,
    MixedTypeAnnotation: mixedTypeAnnotation,
    EmptyTypeAnnotation: emptyTypeAnnotation,
    NullableTypeAnnotation: nullableTypeAnnotation,
    NumberLiteralTypeAnnotation: numberLiteralTypeAnnotation,
    NumberTypeAnnotation: numberTypeAnnotation$2,
    ObjectTypeAnnotation: objectTypeAnnotation,
    ObjectTypeInternalSlot: objectTypeInternalSlot,
    ObjectTypeCallProperty: objectTypeCallProperty,
    ObjectTypeIndexer: objectTypeIndexer,
    ObjectTypeProperty: objectTypeProperty,
    ObjectTypeSpreadProperty: objectTypeSpreadProperty,
    OpaqueType: opaqueType,
    QualifiedTypeIdentifier: qualifiedTypeIdentifier,
    StringLiteralTypeAnnotation: stringLiteralTypeAnnotation,
    StringTypeAnnotation: stringTypeAnnotation$2,
    SymbolTypeAnnotation: symbolTypeAnnotation,
    ThisTypeAnnotation: thisTypeAnnotation,
    TupleTypeAnnotation: tupleTypeAnnotation$1,
    TypeofTypeAnnotation: typeofTypeAnnotation,
    TypeAlias: typeAlias,
    TypeAnnotation: typeAnnotation,
    TypeCastExpression: typeCastExpression,
    TypeParameter: typeParameter,
    TypeParameterDeclaration: typeParameterDeclaration,
    TypeParameterInstantiation: typeParameterInstantiation,
    UnionTypeAnnotation: unionTypeAnnotation$1,
    Variance: variance,
    VoidTypeAnnotation: voidTypeAnnotation$3,
    EnumDeclaration: enumDeclaration,
    EnumBooleanBody: enumBooleanBody,
    EnumNumberBody: enumNumberBody,
    EnumStringBody: enumStringBody,
    EnumSymbolBody: enumSymbolBody,
    EnumBooleanMember: enumBooleanMember,
    EnumNumberMember: enumNumberMember,
    EnumStringMember: enumStringMember,
    EnumDefaultedMember: enumDefaultedMember,
    IndexedAccessType: indexedAccessType,
    OptionalIndexedAccessType: optionalIndexedAccessType,
    JSXAttribute: jsxAttribute,
    JSXClosingElement: jsxClosingElement,
    JSXElement: jsxElement,
    JSXEmptyExpression: jsxEmptyExpression,
    JSXExpressionContainer: jsxExpressionContainer$1,
    JSXSpreadChild: jsxSpreadChild,
    JSXIdentifier: jsxIdentifier$2,
    JSXMemberExpression: jsxMemberExpression$1,
    JSXNamespacedName: jsxNamespacedName,
    JSXOpeningElement: jsxOpeningElement,
    JSXSpreadAttribute: jsxSpreadAttribute,
    JSXText: jsxText,
    JSXFragment: jsxFragment,
    JSXOpeningFragment: jsxOpeningFragment,
    JSXClosingFragment: jsxClosingFragment,
    Noop: noop$1,
    Placeholder: placeholder,
    V8IntrinsicIdentifier: v8IntrinsicIdentifier,
    ArgumentPlaceholder: argumentPlaceholder,
    BindExpression: bindExpression,
    ImportAttribute: importAttribute,
    Decorator: decorator,
    DoExpression: doExpression,
    ExportDefaultSpecifier: exportDefaultSpecifier,
    RecordExpression: recordExpression,
    TupleExpression: tupleExpression,
    DecimalLiteral: decimalLiteral,
    StaticBlock: staticBlock$1,
    ModuleExpression: moduleExpression,
    TopicReference: topicReference,
    PipelineTopicExpression: pipelineTopicExpression,
    PipelineBareFunction: pipelineBareFunction,
    PipelinePrimaryTopicReference: pipelinePrimaryTopicReference,
    TSParameterProperty: tsParameterProperty,
    TSDeclareFunction: tsDeclareFunction,
    TSDeclareMethod: tsDeclareMethod,
    TSQualifiedName: tsQualifiedName,
    TSCallSignatureDeclaration: tsCallSignatureDeclaration,
    TSConstructSignatureDeclaration: tsConstructSignatureDeclaration,
    TSPropertySignature: tsPropertySignature,
    TSMethodSignature: tsMethodSignature,
    TSIndexSignature: tsIndexSignature,
    TSAnyKeyword: tsAnyKeyword,
    TSBooleanKeyword: tsBooleanKeyword,
    TSBigIntKeyword: tsBigIntKeyword,
    TSIntrinsicKeyword: tsIntrinsicKeyword,
    TSNeverKeyword: tsNeverKeyword,
    TSNullKeyword: tsNullKeyword,
    TSNumberKeyword: tsNumberKeyword,
    TSObjectKeyword: tsObjectKeyword,
    TSStringKeyword: tsStringKeyword,
    TSSymbolKeyword: tsSymbolKeyword,
    TSUndefinedKeyword: tsUndefinedKeyword,
    TSUnknownKeyword: tsUnknownKeyword,
    TSVoidKeyword: tsVoidKeyword,
    TSThisType: tsThisType,
    TSFunctionType: tsFunctionType,
    TSConstructorType: tsConstructorType,
    TSTypeReference: tsTypeReference,
    TSTypePredicate: tsTypePredicate,
    TSTypeQuery: tsTypeQuery,
    TSTypeLiteral: tsTypeLiteral,
    TSArrayType: tsArrayType,
    TSTupleType: tsTupleType,
    TSOptionalType: tsOptionalType,
    TSRestType: tsRestType,
    TSNamedTupleMember: tsNamedTupleMember,
    TSUnionType: tsUnionType,
    TSIntersectionType: tsIntersectionType,
    TSConditionalType: tsConditionalType,
    TSInferType: tsInferType,
    TSParenthesizedType: tsParenthesizedType,
    TSTypeOperator: tsTypeOperator,
    TSIndexedAccessType: tsIndexedAccessType,
    TSMappedType: tsMappedType,
    TSLiteralType: tsLiteralType,
    TSExpressionWithTypeArguments: tsExpressionWithTypeArguments,
    TSInterfaceDeclaration: tsInterfaceDeclaration,
    TSInterfaceBody: tsInterfaceBody,
    TSTypeAliasDeclaration: tsTypeAliasDeclaration,
    TSAsExpression: tsAsExpression,
    TSTypeAssertion: tsTypeAssertion,
    TSEnumDeclaration: tsEnumDeclaration,
    TSEnumMember: tsEnumMember,
    TSModuleDeclaration: tsModuleDeclaration,
    TSModuleBlock: tsModuleBlock,
    TSImportType: tsImportType,
    TSImportEqualsDeclaration: tsImportEqualsDeclaration,
    TSExternalModuleReference: tsExternalModuleReference,
    TSNonNullExpression: tsNonNullExpression,
    TSExportAssignment: tsExportAssignment,
    TSNamespaceExportDeclaration: tsNamespaceExportDeclaration,
    TSTypeAnnotation: tsTypeAnnotation,
    TSTypeParameterInstantiation: tsTypeParameterInstantiation,
    TSTypeParameterDeclaration: tsTypeParameterDeclaration,
    TSTypeParameter: tsTypeParameter,
    NumberLiteral: NumberLiteral,
    RegexLiteral: RegexLiteral,
    RestProperty: RestProperty$1,
    SpreadProperty: SpreadProperty$1,
    EXPRESSION_TYPES: EXPRESSION_TYPES,
    BINARY_TYPES: BINARY_TYPES,
    SCOPABLE_TYPES: SCOPABLE_TYPES,
    BLOCKPARENT_TYPES: BLOCKPARENT_TYPES,
    BLOCK_TYPES: BLOCK_TYPES,
    STATEMENT_TYPES: STATEMENT_TYPES,
    TERMINATORLESS_TYPES: TERMINATORLESS_TYPES,
    COMPLETIONSTATEMENT_TYPES: COMPLETIONSTATEMENT_TYPES,
    CONDITIONAL_TYPES: CONDITIONAL_TYPES,
    LOOP_TYPES: LOOP_TYPES,
    WHILE_TYPES: WHILE_TYPES,
    EXPRESSIONWRAPPER_TYPES: EXPRESSIONWRAPPER_TYPES,
    FOR_TYPES: FOR_TYPES,
    FORXSTATEMENT_TYPES: FORXSTATEMENT_TYPES,
    FUNCTION_TYPES: FUNCTION_TYPES$1,
    FUNCTIONPARENT_TYPES: FUNCTIONPARENT_TYPES,
    PUREISH_TYPES: PUREISH_TYPES,
    DECLARATION_TYPES: DECLARATION_TYPES,
    PATTERNLIKE_TYPES: PATTERNLIKE_TYPES,
    LVAL_TYPES: LVAL_TYPES,
    TSENTITYNAME_TYPES: TSENTITYNAME_TYPES,
    LITERAL_TYPES: LITERAL_TYPES,
    IMMUTABLE_TYPES: IMMUTABLE_TYPES,
    USERWHITESPACABLE_TYPES: USERWHITESPACABLE_TYPES,
    METHOD_TYPES: METHOD_TYPES,
    OBJECTMEMBER_TYPES: OBJECTMEMBER_TYPES,
    PROPERTY_TYPES: PROPERTY_TYPES,
    UNARYLIKE_TYPES: UNARYLIKE_TYPES,
    PATTERN_TYPES: PATTERN_TYPES,
    CLASS_TYPES: CLASS_TYPES,
    MODULEDECLARATION_TYPES: MODULEDECLARATION_TYPES,
    EXPORTDECLARATION_TYPES: EXPORTDECLARATION_TYPES,
    MODULESPECIFIER_TYPES: MODULESPECIFIER_TYPES,
    PRIVATE_TYPES: PRIVATE_TYPES,
    FLOW_TYPES: FLOW_TYPES,
    FLOWTYPE_TYPES: FLOWTYPE_TYPES,
    FLOWBASEANNOTATION_TYPES: FLOWBASEANNOTATION_TYPES,
    FLOWDECLARATION_TYPES: FLOWDECLARATION_TYPES,
    FLOWPREDICATE_TYPES: FLOWPREDICATE_TYPES,
    ENUMBODY_TYPES: ENUMBODY_TYPES,
    ENUMMEMBER_TYPES: ENUMMEMBER_TYPES,
    JSX_TYPES: JSX_TYPES,
    TSTYPEELEMENT_TYPES: TSTYPEELEMENT_TYPES,
    TSTYPE_TYPES: TSTYPE_TYPES,
    TSBASETYPE_TYPES: TSBASETYPE_TYPES,
    STATEMENT_OR_BLOCK_KEYS: STATEMENT_OR_BLOCK_KEYS$1,
    FLATTENABLE_KEYS: FLATTENABLE_KEYS,
    FOR_INIT_KEYS: FOR_INIT_KEYS,
    COMMENT_KEYS: COMMENT_KEYS,
    LOGICAL_OPERATORS: LOGICAL_OPERATORS$2,
    UPDATE_OPERATORS: UPDATE_OPERATORS,
    BOOLEAN_NUMBER_BINARY_OPERATORS: BOOLEAN_NUMBER_BINARY_OPERATORS$1,
    EQUALITY_BINARY_OPERATORS: EQUALITY_BINARY_OPERATORS,
    COMPARISON_BINARY_OPERATORS: COMPARISON_BINARY_OPERATORS,
    BOOLEAN_BINARY_OPERATORS: BOOLEAN_BINARY_OPERATORS$1,
    NUMBER_BINARY_OPERATORS: NUMBER_BINARY_OPERATORS$1,
    BINARY_OPERATORS: BINARY_OPERATORS,
    ASSIGNMENT_OPERATORS: ASSIGNMENT_OPERATORS,
    BOOLEAN_UNARY_OPERATORS: BOOLEAN_UNARY_OPERATORS$1,
    NUMBER_UNARY_OPERATORS: NUMBER_UNARY_OPERATORS$1,
    STRING_UNARY_OPERATORS: STRING_UNARY_OPERATORS$1,
    UNARY_OPERATORS: UNARY_OPERATORS,
    INHERIT_KEYS: INHERIT_KEYS,
    BLOCK_SCOPED_SYMBOL: BLOCK_SCOPED_SYMBOL,
    NOT_LOCAL_BINDING: NOT_LOCAL_BINDING$2,
    VISITOR_KEYS: VISITOR_KEYS$6,
    ALIAS_KEYS: ALIAS_KEYS,
    FLIPPED_ALIAS_KEYS: FLIPPED_ALIAS_KEYS$3,
    NODE_FIELDS: NODE_FIELDS,
    BUILDER_KEYS: BUILDER_KEYS,
    DEPRECATED_KEYS: DEPRECATED_KEYS$1,
    NODE_PARENT_VALIDATIONS: NODE_PARENT_VALIDATIONS,
    PLACEHOLDERS: PLACEHOLDERS,
    PLACEHOLDERS_ALIAS: PLACEHOLDERS_ALIAS,
    PLACEHOLDERS_FLIPPED_ALIAS: PLACEHOLDERS_FLIPPED_ALIAS,
    TYPES: TYPES$1,
    isArrayExpression: isArrayExpression$2,
    isAssignmentExpression: isAssignmentExpression$3,
    isBinaryExpression: isBinaryExpression$1,
    isInterpreterDirective: isInterpreterDirective,
    isDirective: isDirective,
    isDirectiveLiteral: isDirectiveLiteral,
    isBlockStatement: isBlockStatement$2,
    isBreakStatement: isBreakStatement,
    isCallExpression: isCallExpression$6,
    isCatchClause: isCatchClause,
    isConditionalExpression: isConditionalExpression$1,
    isContinueStatement: isContinueStatement,
    isDebuggerStatement: isDebuggerStatement,
    isDoWhileStatement: isDoWhileStatement,
    isEmptyStatement: isEmptyStatement$1,
    isExpressionStatement: isExpressionStatement$4,
    isFile: isFile$1,
    isForInStatement: isForInStatement$1,
    isForStatement: isForStatement$3,
    isFunctionDeclaration: isFunctionDeclaration$1,
    isFunctionExpression: isFunctionExpression$1,
    isIdentifier: isIdentifier$g,
    isIfStatement: isIfStatement$2,
    isLabeledStatement: isLabeledStatement,
    isStringLiteral: isStringLiteral$7,
    isNumericLiteral: isNumericLiteral,
    isNullLiteral: isNullLiteral$1,
    isBooleanLiteral: isBooleanLiteral,
    isRegExpLiteral: isRegExpLiteral$1,
    isLogicalExpression: isLogicalExpression$1,
    isMemberExpression: isMemberExpression$8,
    isNewExpression: isNewExpression$4,
    isProgram: isProgram$2,
    isObjectExpression: isObjectExpression$3,
    isObjectMethod: isObjectMethod$2,
    isObjectProperty: isObjectProperty$2,
    isRestElement: isRestElement$2,
    isReturnStatement: isReturnStatement$1,
    isSequenceExpression: isSequenceExpression$1,
    isParenthesizedExpression: isParenthesizedExpression$1,
    isSwitchCase: isSwitchCase,
    isSwitchStatement: isSwitchStatement$1,
    isThisExpression: isThisExpression$2,
    isThrowStatement: isThrowStatement$1,
    isTryStatement: isTryStatement,
    isUnaryExpression: isUnaryExpression$1,
    isUpdateExpression: isUpdateExpression$1,
    isVariableDeclaration: isVariableDeclaration$3,
    isVariableDeclarator: isVariableDeclarator$2,
    isWhileStatement: isWhileStatement$1,
    isWithStatement: isWithStatement,
    isAssignmentPattern: isAssignmentPattern$3,
    isArrayPattern: isArrayPattern,
    isArrowFunctionExpression: isArrowFunctionExpression$1,
    isClassBody: isClassBody$1,
    isClassExpression: isClassExpression$1,
    isClassDeclaration: isClassDeclaration$3,
    isExportAllDeclaration: isExportAllDeclaration$1,
    isExportDefaultDeclaration: isExportDefaultDeclaration$3,
    isExportNamedDeclaration: isExportNamedDeclaration$2,
    isExportSpecifier: isExportSpecifier,
    isForOfStatement: isForOfStatement$1,
    isImportDeclaration: isImportDeclaration$2,
    isImportDefaultSpecifier: isImportDefaultSpecifier$1,
    isImportNamespaceSpecifier: isImportNamespaceSpecifier$1,
    isImportSpecifier: isImportSpecifier$1,
    isMetaProperty: isMetaProperty,
    isClassMethod: isClassMethod$1,
    isObjectPattern: isObjectPattern$1,
    isSpreadElement: isSpreadElement$1,
    isSuper: isSuper$2,
    isTaggedTemplateExpression: isTaggedTemplateExpression$2,
    isTemplateElement: isTemplateElement,
    isTemplateLiteral: isTemplateLiteral$2,
    isYieldExpression: isYieldExpression$1,
    isAwaitExpression: isAwaitExpression$1,
    isImport: isImport,
    isBigIntLiteral: isBigIntLiteral,
    isExportNamespaceSpecifier: isExportNamespaceSpecifier$1,
    isOptionalMemberExpression: isOptionalMemberExpression$3,
    isOptionalCallExpression: isOptionalCallExpression$3,
    isClassProperty: isClassProperty,
    isClassPrivateProperty: isClassPrivateProperty,
    isClassPrivateMethod: isClassPrivateMethod,
    isPrivateName: isPrivateName$1,
    isAnyTypeAnnotation: isAnyTypeAnnotation$1,
    isArrayTypeAnnotation: isArrayTypeAnnotation$1,
    isBooleanTypeAnnotation: isBooleanTypeAnnotation$1,
    isBooleanLiteralTypeAnnotation: isBooleanLiteralTypeAnnotation,
    isNullLiteralTypeAnnotation: isNullLiteralTypeAnnotation,
    isClassImplements: isClassImplements,
    isDeclareClass: isDeclareClass,
    isDeclareFunction: isDeclareFunction,
    isDeclareInterface: isDeclareInterface,
    isDeclareModule: isDeclareModule,
    isDeclareModuleExports: isDeclareModuleExports,
    isDeclareTypeAlias: isDeclareTypeAlias,
    isDeclareOpaqueType: isDeclareOpaqueType,
    isDeclareVariable: isDeclareVariable,
    isDeclareExportDeclaration: isDeclareExportDeclaration$1,
    isDeclareExportAllDeclaration: isDeclareExportAllDeclaration,
    isDeclaredPredicate: isDeclaredPredicate,
    isExistsTypeAnnotation: isExistsTypeAnnotation,
    isFunctionTypeAnnotation: isFunctionTypeAnnotation,
    isFunctionTypeParam: isFunctionTypeParam,
    isGenericTypeAnnotation: isGenericTypeAnnotation$1,
    isInferredPredicate: isInferredPredicate,
    isInterfaceExtends: isInterfaceExtends,
    isInterfaceDeclaration: isInterfaceDeclaration,
    isInterfaceTypeAnnotation: isInterfaceTypeAnnotation,
    isIntersectionTypeAnnotation: isIntersectionTypeAnnotation$1,
    isMixedTypeAnnotation: isMixedTypeAnnotation$1,
    isEmptyTypeAnnotation: isEmptyTypeAnnotation$1,
    isNullableTypeAnnotation: isNullableTypeAnnotation$1,
    isNumberLiteralTypeAnnotation: isNumberLiteralTypeAnnotation,
    isNumberTypeAnnotation: isNumberTypeAnnotation$1,
    isObjectTypeAnnotation: isObjectTypeAnnotation,
    isObjectTypeInternalSlot: isObjectTypeInternalSlot,
    isObjectTypeCallProperty: isObjectTypeCallProperty,
    isObjectTypeIndexer: isObjectTypeIndexer,
    isObjectTypeProperty: isObjectTypeProperty,
    isObjectTypeSpreadProperty: isObjectTypeSpreadProperty,
    isOpaqueType: isOpaqueType,
    isQualifiedTypeIdentifier: isQualifiedTypeIdentifier,
    isStringLiteralTypeAnnotation: isStringLiteralTypeAnnotation,
    isStringTypeAnnotation: isStringTypeAnnotation$1,
    isSymbolTypeAnnotation: isSymbolTypeAnnotation,
    isThisTypeAnnotation: isThisTypeAnnotation,
    isTupleTypeAnnotation: isTupleTypeAnnotation,
    isTypeofTypeAnnotation: isTypeofTypeAnnotation,
    isTypeAlias: isTypeAlias,
    isTypeAnnotation: isTypeAnnotation$2,
    isTypeCastExpression: isTypeCastExpression$1,
    isTypeParameter: isTypeParameter,
    isTypeParameterDeclaration: isTypeParameterDeclaration,
    isTypeParameterInstantiation: isTypeParameterInstantiation,
    isUnionTypeAnnotation: isUnionTypeAnnotation$2,
    isVariance: isVariance,
    isVoidTypeAnnotation: isVoidTypeAnnotation$1,
    isEnumDeclaration: isEnumDeclaration,
    isEnumBooleanBody: isEnumBooleanBody,
    isEnumNumberBody: isEnumNumberBody,
    isEnumStringBody: isEnumStringBody,
    isEnumSymbolBody: isEnumSymbolBody,
    isEnumBooleanMember: isEnumBooleanMember,
    isEnumNumberMember: isEnumNumberMember,
    isEnumStringMember: isEnumStringMember,
    isEnumDefaultedMember: isEnumDefaultedMember,
    isIndexedAccessType: isIndexedAccessType$1,
    isOptionalIndexedAccessType: isOptionalIndexedAccessType,
    isJSXAttribute: isJSXAttribute,
    isJSXClosingElement: isJSXClosingElement,
    isJSXElement: isJSXElement,
    isJSXEmptyExpression: isJSXEmptyExpression,
    isJSXExpressionContainer: isJSXExpressionContainer$1,
    isJSXSpreadChild: isJSXSpreadChild,
    isJSXIdentifier: isJSXIdentifier$3,
    isJSXMemberExpression: isJSXMemberExpression$2,
    isJSXNamespacedName: isJSXNamespacedName$1,
    isJSXOpeningElement: isJSXOpeningElement,
    isJSXSpreadAttribute: isJSXSpreadAttribute$1,
    isJSXText: isJSXText,
    isJSXFragment: isJSXFragment,
    isJSXOpeningFragment: isJSXOpeningFragment,
    isJSXClosingFragment: isJSXClosingFragment,
    isNoop: isNoop,
    isPlaceholder: isPlaceholder$1,
    isV8IntrinsicIdentifier: isV8IntrinsicIdentifier,
    isArgumentPlaceholder: isArgumentPlaceholder,
    isBindExpression: isBindExpression,
    isImportAttribute: isImportAttribute,
    isDecorator: isDecorator,
    isDoExpression: isDoExpression,
    isExportDefaultSpecifier: isExportDefaultSpecifier$1,
    isRecordExpression: isRecordExpression,
    isTupleExpression: isTupleExpression,
    isDecimalLiteral: isDecimalLiteral,
    isStaticBlock: isStaticBlock,
    isModuleExpression: isModuleExpression,
    isTopicReference: isTopicReference,
    isPipelineTopicExpression: isPipelineTopicExpression,
    isPipelineBareFunction: isPipelineBareFunction,
    isPipelinePrimaryTopicReference: isPipelinePrimaryTopicReference,
    isTSParameterProperty: isTSParameterProperty,
    isTSDeclareFunction: isTSDeclareFunction,
    isTSDeclareMethod: isTSDeclareMethod,
    isTSQualifiedName: isTSQualifiedName,
    isTSCallSignatureDeclaration: isTSCallSignatureDeclaration,
    isTSConstructSignatureDeclaration: isTSConstructSignatureDeclaration,
    isTSPropertySignature: isTSPropertySignature,
    isTSMethodSignature: isTSMethodSignature,
    isTSIndexSignature: isTSIndexSignature,
    isTSAnyKeyword: isTSAnyKeyword,
    isTSBooleanKeyword: isTSBooleanKeyword,
    isTSBigIntKeyword: isTSBigIntKeyword,
    isTSIntrinsicKeyword: isTSIntrinsicKeyword,
    isTSNeverKeyword: isTSNeverKeyword,
    isTSNullKeyword: isTSNullKeyword,
    isTSNumberKeyword: isTSNumberKeyword,
    isTSObjectKeyword: isTSObjectKeyword,
    isTSStringKeyword: isTSStringKeyword,
    isTSSymbolKeyword: isTSSymbolKeyword,
    isTSUndefinedKeyword: isTSUndefinedKeyword,
    isTSUnknownKeyword: isTSUnknownKeyword,
    isTSVoidKeyword: isTSVoidKeyword,
    isTSThisType: isTSThisType,
    isTSFunctionType: isTSFunctionType,
    isTSConstructorType: isTSConstructorType,
    isTSTypeReference: isTSTypeReference,
    isTSTypePredicate: isTSTypePredicate,
    isTSTypeQuery: isTSTypeQuery,
    isTSTypeLiteral: isTSTypeLiteral,
    isTSArrayType: isTSArrayType$1,
    isTSTupleType: isTSTupleType,
    isTSOptionalType: isTSOptionalType$1,
    isTSRestType: isTSRestType$1,
    isTSNamedTupleMember: isTSNamedTupleMember,
    isTSUnionType: isTSUnionType$1,
    isTSIntersectionType: isTSIntersectionType$1,
    isTSConditionalType: isTSConditionalType,
    isTSInferType: isTSInferType,
    isTSParenthesizedType: isTSParenthesizedType,
    isTSTypeOperator: isTSTypeOperator,
    isTSIndexedAccessType: isTSIndexedAccessType,
    isTSMappedType: isTSMappedType,
    isTSLiteralType: isTSLiteralType,
    isTSExpressionWithTypeArguments: isTSExpressionWithTypeArguments,
    isTSInterfaceDeclaration: isTSInterfaceDeclaration,
    isTSInterfaceBody: isTSInterfaceBody,
    isTSTypeAliasDeclaration: isTSTypeAliasDeclaration,
    isTSAsExpression: isTSAsExpression$2,
    isTSTypeAssertion: isTSTypeAssertion$2,
    isTSEnumDeclaration: isTSEnumDeclaration,
    isTSEnumMember: isTSEnumMember,
    isTSModuleDeclaration: isTSModuleDeclaration,
    isTSModuleBlock: isTSModuleBlock,
    isTSImportType: isTSImportType,
    isTSImportEqualsDeclaration: isTSImportEqualsDeclaration,
    isTSExternalModuleReference: isTSExternalModuleReference,
    isTSNonNullExpression: isTSNonNullExpression$2,
    isTSExportAssignment: isTSExportAssignment,
    isTSNamespaceExportDeclaration: isTSNamespaceExportDeclaration,
    isTSTypeAnnotation: isTSTypeAnnotation$2,
    isTSTypeParameterInstantiation: isTSTypeParameterInstantiation,
    isTSTypeParameterDeclaration: isTSTypeParameterDeclaration,
    isTSTypeParameter: isTSTypeParameter,
    isExpression: isExpression$4,
    isBinary: isBinary$3,
    isScopable: isScopable,
    isBlockParent: isBlockParent,
    isBlock: isBlock,
    isStatement: isStatement$7,
    isTerminatorless: isTerminatorless,
    isCompletionStatement: isCompletionStatement,
    isConditional: isConditional$1,
    isLoop: isLoop$1,
    isWhile: isWhile,
    isExpressionWrapper: isExpressionWrapper,
    isFor: isFor$2,
    isForXStatement: isForXStatement$1,
    isFunction: isFunction$4,
    isFunctionParent: isFunctionParent,
    isPureish: isPureish$2,
    isDeclaration: isDeclaration$1,
    isPatternLike: isPatternLike,
    isLVal: isLVal,
    isTSEntityName: isTSEntityName,
    isLiteral: isLiteral$7,
    isUserWhitespacable: isUserWhitespacable,
    isMethod: isMethod$1,
    isObjectMember: isObjectMember,
    isProperty: isProperty$2,
    isUnaryLike: isUnaryLike$1,
    isPattern: isPattern,
    isClass: isClass$1,
    isModuleDeclaration: isModuleDeclaration$1,
    isExportDeclaration: isExportDeclaration$2,
    isModuleSpecifier: isModuleSpecifier$1,
    isPrivate: isPrivate,
    isFlow: isFlow$1,
    isFlowType: isFlowType,
    isFlowBaseAnnotation: isFlowBaseAnnotation$1,
    isFlowDeclaration: isFlowDeclaration,
    isFlowPredicate: isFlowPredicate,
    isEnumBody: isEnumBody,
    isEnumMember: isEnumMember,
    isJSX: isJSX,
    isTSTypeElement: isTSTypeElement,
    isTSType: isTSType,
    isTSBaseType: isTSBaseType,
    isNumberLiteral: isNumberLiteral,
    isRegexLiteral: isRegexLiteral,
    isRestProperty: isRestProperty,
    isSpreadProperty: isSpreadProperty
  });

  var isBinding = isBinding$1,
      isBlockScoped$1 = isBlockScoped$2,
      isExportDeclaration$1 = isExportDeclaration$2,
      isExpression$3 = isExpression$4,
      isFlow = isFlow$1,
      isForStatement$2 = isForStatement$3,
      isForXStatement = isForXStatement$1,
      isIdentifier$f = isIdentifier$g,
      isImportDeclaration$1 = isImportDeclaration$2,
      isImportSpecifier = isImportSpecifier$1,
      isJSXIdentifier$2 = isJSXIdentifier$3,
      isJSXMemberExpression$1 = isJSXMemberExpression$2,
      isMemberExpression$7 = isMemberExpression$8,
      isReferenced$1 = isReferenced$2,
      isScope = isScope$1,
      isStatement$6 = isStatement$7,
      isVar$1 = isVar$2,
      isVariableDeclaration$2 = isVariableDeclaration$3,
      react$2 = react$3;
  var isCompatTag = react$2.isCompatTag;
  var ReferencedIdentifier = {
    types: ["Identifier", "JSXIdentifier"],
    checkPath: function checkPath(path, opts) {
      var node = path.node,
          parent = path.parent;

      if (!isIdentifier$f(node, opts) && !isJSXMemberExpression$1(parent, opts)) {
        if (isJSXIdentifier$2(node, opts)) {
          if (isCompatTag(node.name)) return false;
        } else {
          return false;
        }
      }

      return isReferenced$1(node, parent, path.parentPath.parent);
    }
  };
  var ReferencedMemberExpression = {
    types: ["MemberExpression"],
    checkPath: function checkPath(_ref) {
      var node = _ref.node,
          parent = _ref.parent;
      return isMemberExpression$7(node) && isReferenced$1(node, parent);
    }
  };
  var BindingIdentifier = {
    types: ["Identifier"],
    checkPath: function checkPath(path) {
      var node = path.node,
          parent = path.parent;
      var grandparent = path.parentPath.parent;
      return isIdentifier$f(node) && isBinding(node, parent, grandparent);
    }
  };
  var Statement = {
    types: ["Statement"],
    checkPath: function checkPath(_ref2) {
      var node = _ref2.node,
          parent = _ref2.parent;

      if (isStatement$6(node)) {
        if (isVariableDeclaration$2(node)) {
          if (isForXStatement(parent, {
            left: node
          })) return false;
          if (isForStatement$2(parent, {
            init: node
          })) return false;
        }

        return true;
      } else {
        return false;
      }
    }
  };
  var Expression = {
    types: ["Expression"],
    checkPath: function checkPath(path) {
      if (path.isIdentifier()) {
        return path.isReferencedIdentifier();
      } else {
        return isExpression$3(path.node);
      }
    }
  };
  var Scope$2 = {
    types: ["Scopable", "Pattern"],
    checkPath: function checkPath(path) {
      return isScope(path.node, path.parent);
    }
  };
  var Referenced = {
    checkPath: function checkPath(path) {
      return isReferenced$1(path.node, path.parent);
    }
  };
  var BlockScoped = {
    checkPath: function checkPath(path) {
      return isBlockScoped$1(path.node);
    }
  };
  var Var = {
    types: ["VariableDeclaration"],
    checkPath: function checkPath(path) {
      return isVar$1(path.node);
    }
  };
  var User = {
    checkPath: function checkPath(path) {
      return path.node && !!path.node.loc;
    }
  };
  var Generated = {
    checkPath: function checkPath(path) {
      return !path.isUser();
    }
  };
  var Pure = {
    checkPath: function checkPath(path, opts) {
      return path.scope.isPure(path.node, opts);
    }
  };
  var Flow = {
    types: ["Flow", "ImportDeclaration", "ExportDeclaration", "ImportSpecifier"],
    checkPath: function checkPath(_ref3) {
      var node = _ref3.node;

      if (isFlow(node)) {
        return true;
      } else if (isImportDeclaration$1(node)) {
        return node.importKind === "type" || node.importKind === "typeof";
      } else if (isExportDeclaration$1(node)) {
        return node.exportKind === "type";
      } else if (isImportSpecifier(node)) {
        return node.importKind === "type" || node.importKind === "typeof";
      } else {
        return false;
      }
    }
  };
  var RestProperty = {
    types: ["RestElement"],
    checkPath: function checkPath(path) {
      return path.parentPath && path.parentPath.isObjectPattern();
    }
  };
  var SpreadProperty = {
    types: ["RestElement"],
    checkPath: function checkPath(path) {
      return path.parentPath && path.parentPath.isObjectExpression();
    }
  };
  var ExistentialTypeParam = {
    types: ["ExistsTypeAnnotation"]
  };
  var NumericLiteralTypeAnnotation = {
    types: ["NumberLiteralTypeAnnotation"]
  };
  var ForAwaitStatement = {
    types: ["ForOfStatement"],
    checkPath: function checkPath(_ref4) {
      var node = _ref4.node;
      return node["await"] === true;
    }
  };

  var virtualTypes = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ReferencedIdentifier: ReferencedIdentifier,
    ReferencedMemberExpression: ReferencedMemberExpression,
    BindingIdentifier: BindingIdentifier,
    Statement: Statement,
    Expression: Expression,
    Scope: Scope$2,
    Referenced: Referenced,
    BlockScoped: BlockScoped,
    Var: Var,
    User: User,
    Generated: Generated,
    Pure: Pure,
    Flow: Flow,
    RestProperty: RestProperty,
    SpreadProperty: SpreadProperty,
    ExistentialTypeParam: ExistentialTypeParam,
    NumericLiteralTypeAnnotation: NumericLiteralTypeAnnotation,
    ForAwaitStatement: ForAwaitStatement
  });

  var s$1 = 1000;
  var m$2 = s$1 * 60;
  var h$1 = m$2 * 60;
  var d$1 = h$1 * 24;
  var w$1 = d$1 * 7;
  var y$1 = d$1 * 365.25;

  var ms$1 = function ms(val, options) {
    options = options || {};
    var type = typeof val;

    if (type === 'string' && val.length > 0) {
      return parse$9(val);
    } else if (type === 'number' && isFinite(val)) {
      return options["long"] ? fmtLong$1(val) : fmtShort$1(val);
    }

    throw new Error('val is not a non-empty string or a valid number. val=' + JSON.stringify(val));
  };

  function parse$9(str) {
    str = String(str);

    if (str.length > 100) {
      return;
    }

    var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(str);

    if (!match) {
      return;
    }

    var n = parseFloat(match[1]);
    var type = (match[2] || 'ms').toLowerCase();

    switch (type) {
      case 'years':
      case 'year':
      case 'yrs':
      case 'yr':
      case 'y':
        return n * y$1;

      case 'weeks':
      case 'week':
      case 'w':
        return n * w$1;

      case 'days':
      case 'day':
      case 'd':
        return n * d$1;

      case 'hours':
      case 'hour':
      case 'hrs':
      case 'hr':
      case 'h':
        return n * h$1;

      case 'minutes':
      case 'minute':
      case 'mins':
      case 'min':
      case 'm':
        return n * m$2;

      case 'seconds':
      case 'second':
      case 'secs':
      case 'sec':
      case 's':
        return n * s$1;

      case 'milliseconds':
      case 'millisecond':
      case 'msecs':
      case 'msec':
      case 'ms':
        return n;

      default:
        return undefined;
    }
  }

  function fmtShort$1(ms) {
    var msAbs = Math.abs(ms);

    if (msAbs >= d$1) {
      return Math.round(ms / d$1) + 'd';
    }

    if (msAbs >= h$1) {
      return Math.round(ms / h$1) + 'h';
    }

    if (msAbs >= m$2) {
      return Math.round(ms / m$2) + 'm';
    }

    if (msAbs >= s$1) {
      return Math.round(ms / s$1) + 's';
    }

    return ms + 'ms';
  }

  function fmtLong$1(ms) {
    var msAbs = Math.abs(ms);

    if (msAbs >= d$1) {
      return plural$1(ms, msAbs, d$1, 'day');
    }

    if (msAbs >= h$1) {
      return plural$1(ms, msAbs, h$1, 'hour');
    }

    if (msAbs >= m$2) {
      return plural$1(ms, msAbs, m$2, 'minute');
    }

    if (msAbs >= s$1) {
      return plural$1(ms, msAbs, s$1, 'second');
    }

    return ms + ' ms';
  }

  function plural$1(ms, msAbs, n, name) {
    var isPlural = msAbs >= n * 1.5;
    return Math.round(ms / n) + ' ' + name + (isPlural ? 's' : '');
  }

  function setup$2(env) {
    createDebug.debug = createDebug;
    createDebug["default"] = createDebug;
    createDebug.coerce = coerce;
    createDebug.disable = disable;
    createDebug.enable = enable;
    createDebug.enabled = enabled;
    createDebug.humanize = ms$1;
    createDebug.destroy = destroy;
    Object.keys(env).forEach(function (key) {
      createDebug[key] = env[key];
    });
    createDebug.names = [];
    createDebug.skips = [];
    createDebug.formatters = {};

    function selectColor(namespace) {
      var hash = 0;

      for (var i = 0; i < namespace.length; i++) {
        hash = (hash << 5) - hash + namespace.charCodeAt(i);
        hash |= 0;
      }

      return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
    }

    createDebug.selectColor = selectColor;

    function createDebug(namespace) {
      var prevTime;
      var enableOverride = null;
      var namespacesCache;
      var enabledCache;

      function debug() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        if (!debug.enabled) {
          return;
        }

        var self = debug;
        var curr = Number(new Date());
        var ms = curr - (prevTime || curr);
        self.diff = ms;
        self.prev = prevTime;
        self.curr = curr;
        prevTime = curr;
        args[0] = createDebug.coerce(args[0]);

        if (typeof args[0] !== 'string') {
          args.unshift('%O');
        }

        var index = 0;
        args[0] = args[0].replace(/%([a-zA-Z%])/g, function (match, format) {
          if (match === '%%') {
            return '%';
          }

          index++;
          var formatter = createDebug.formatters[format];

          if (typeof formatter === 'function') {
            var val = args[index];
            match = formatter.call(self, val);
            args.splice(index, 1);
            index--;
          }

          return match;
        });
        createDebug.formatArgs.call(self, args);
        var logFn = self.log || createDebug.log;
        logFn.apply(self, args);
      }

      debug.namespace = namespace;
      debug.useColors = createDebug.useColors();
      debug.color = createDebug.selectColor(namespace);
      debug.extend = extend;
      debug.destroy = createDebug.destroy;
      Object.defineProperty(debug, 'enabled', {
        enumerable: true,
        configurable: false,
        get: function get() {
          if (enableOverride !== null) {
            return enableOverride;
          }

          if (namespacesCache !== createDebug.namespaces) {
            namespacesCache = createDebug.namespaces;
            enabledCache = createDebug.enabled(namespace);
          }

          return enabledCache;
        },
        set: function set(v) {
          enableOverride = v;
        }
      });

      if (typeof createDebug.init === 'function') {
        createDebug.init(debug);
      }

      return debug;
    }

    function extend(namespace, delimiter) {
      var newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
      newDebug.log = this.log;
      return newDebug;
    }

    function enable(namespaces) {
      createDebug.save(namespaces);
      createDebug.namespaces = namespaces;
      createDebug.names = [];
      createDebug.skips = [];
      var i;
      var split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
      var len = split.length;

      for (i = 0; i < len; i++) {
        if (!split[i]) {
          continue;
        }

        namespaces = split[i].replace(/\*/g, '.*?');

        if (namespaces[0] === '-') {
          createDebug.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
        } else {
          createDebug.names.push(new RegExp('^' + namespaces + '$'));
        }
      }
    }

    function disable() {
      var namespaces = [].concat(_toConsumableArray(createDebug.names.map(toNamespace)), _toConsumableArray(createDebug.skips.map(toNamespace).map(function (namespace) {
        return '-' + namespace;
      }))).join(',');
      createDebug.enable('');
      return namespaces;
    }

    function enabled(name) {
      if (name[name.length - 1] === '*') {
        return true;
      }

      var i;
      var len;

      for (i = 0, len = createDebug.skips.length; i < len; i++) {
        if (createDebug.skips[i].test(name)) {
          return false;
        }
      }

      for (i = 0, len = createDebug.names.length; i < len; i++) {
        if (createDebug.names[i].test(name)) {
          return true;
        }
      }

      return false;
    }

    function toNamespace(regexp) {
      return regexp.toString().substring(2, regexp.toString().length - 2).replace(/\.\*\?$/, '*');
    }

    function coerce(val) {
      if (val instanceof Error) {
        return val.stack || val.message;
      }

      return val;
    }

    function destroy() {
      console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
    }

    createDebug.enable(createDebug.load());
    return createDebug;
  }

  var common$1 = setup$2;

  var browser$5 = createCommonjsModule(function (module, exports) {
    exports.formatArgs = formatArgs;
    exports.save = save;
    exports.load = load;
    exports.useColors = useColors;
    exports.storage = localstorage();

    exports.destroy = function () {
      var warned = false;
      return function () {
        if (!warned) {
          warned = true;
          console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
        }
      };
    }();

    exports.colors = ['#0000CC', '#0000FF', '#0033CC', '#0033FF', '#0066CC', '#0066FF', '#0099CC', '#0099FF', '#00CC00', '#00CC33', '#00CC66', '#00CC99', '#00CCCC', '#00CCFF', '#3300CC', '#3300FF', '#3333CC', '#3333FF', '#3366CC', '#3366FF', '#3399CC', '#3399FF', '#33CC00', '#33CC33', '#33CC66', '#33CC99', '#33CCCC', '#33CCFF', '#6600CC', '#6600FF', '#6633CC', '#6633FF', '#66CC00', '#66CC33', '#9900CC', '#9900FF', '#9933CC', '#9933FF', '#99CC00', '#99CC33', '#CC0000', '#CC0033', '#CC0066', '#CC0099', '#CC00CC', '#CC00FF', '#CC3300', '#CC3333', '#CC3366', '#CC3399', '#CC33CC', '#CC33FF', '#CC6600', '#CC6633', '#CC9900', '#CC9933', '#CCCC00', '#CCCC33', '#FF0000', '#FF0033', '#FF0066', '#FF0099', '#FF00CC', '#FF00FF', '#FF3300', '#FF3333', '#FF3366', '#FF3399', '#FF33CC', '#FF33FF', '#FF6600', '#FF6633', '#FF9900', '#FF9933', '#FFCC00', '#FFCC33'];

    function useColors() {
      if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
        return true;
      }

      if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
        return false;
      }

      return typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || typeof window !== 'undefined' && window.console && (window.console.firebug || window.console.exception && window.console.table) || typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31 || typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
    }

    function formatArgs(args) {
      args[0] = (this.useColors ? '%c' : '') + this.namespace + (this.useColors ? ' %c' : ' ') + args[0] + (this.useColors ? '%c ' : ' ') + '+' + module.exports.humanize(this.diff);

      if (!this.useColors) {
        return;
      }

      var c = 'color: ' + this.color;
      args.splice(1, 0, c, 'color: inherit');
      var index = 0;
      var lastC = 0;
      args[0].replace(/%[a-zA-Z%]/g, function (match) {
        if (match === '%%') {
          return;
        }

        index++;

        if (match === '%c') {
          lastC = index;
        }
      });
      args.splice(lastC, 0, c);
    }

    exports.log = console.debug || console.log || function () {};

    function save(namespaces) {
      try {
        if (namespaces) {
          exports.storage.setItem('debug', namespaces);
        } else {
          exports.storage.removeItem('debug');
        }
      } catch (error) {}
    }

    function load() {
      var r;

      try {
        r = exports.storage.getItem('debug');
      } catch (error) {}

      if (!r && typeof browser$6 !== 'undefined' && 'env' in browser$6) {
        r = browser$6.env.DEBUG;
      }

      return r;
    }

    function localstorage() {
      try {
        return localStorage;
      } catch (error) {}
    }

    module.exports = common$1(exports);
    var formatters = module.exports.formatters;

    formatters.j = function (v) {
      try {
        return JSON.stringify(v);
      } catch (error) {
        return '[UnexpectedJSONParseError]: ' + error.message;
      }
    };
  }, "/$$rollup_base$$/packages/babel-traverse/node_modules/debug/src");

  var Binding = function () {
    function Binding(_ref) {
      var identifier = _ref.identifier,
          scope = _ref.scope,
          path = _ref.path,
          kind = _ref.kind;
      this.identifier = void 0;
      this.scope = void 0;
      this.path = void 0;
      this.kind = void 0;
      this.constantViolations = [];
      this.constant = true;
      this.referencePaths = [];
      this.referenced = false;
      this.references = 0;
      this.identifier = identifier;
      this.scope = scope;
      this.path = path;
      this.kind = kind;
      this.clearValue();
    }

    var _proto = Binding.prototype;

    _proto.deoptValue = function deoptValue() {
      this.clearValue();
      this.hasDeoptedValue = true;
    };

    _proto.setValue = function setValue(value) {
      if (this.hasDeoptedValue) return;
      this.hasValue = true;
      this.value = value;
    };

    _proto.clearValue = function clearValue() {
      this.hasDeoptedValue = false;
      this.hasValue = false;
      this.value = null;
    };

    _proto.reassign = function reassign(path) {
      this.constant = false;

      if (this.constantViolations.indexOf(path) !== -1) {
        return;
      }

      this.constantViolations.push(path);
    };

    _proto.reference = function reference(path) {
      if (this.referencePaths.indexOf(path) !== -1) {
        return;
      }

      this.referenced = true;
      this.references++;
      this.referencePaths.push(path);
    };

    _proto.dereference = function dereference() {
      this.references--;
      this.referenced = !!this.references;
    };

    return Binding;
  }();

  var cloneNode$h = cloneNode$i,
      exportNamedDeclaration$1 = exportNamedDeclaration$2,
      exportSpecifier$1 = exportSpecifier$2,
      identifier$i = identifier$j,
      variableDeclaration$7 = variableDeclaration$8,
      variableDeclarator$7 = variableDeclarator$8;
  function splitExportDeclaration(exportDeclaration) {
    if (!exportDeclaration.isExportDeclaration()) {
      throw new Error("Only export declarations can be split.");
    }

    var isDefault = exportDeclaration.isExportDefaultDeclaration();
    var declaration = exportDeclaration.get("declaration");
    var isClassDeclaration = declaration.isClassDeclaration();

    if (isDefault) {
      var standaloneDeclaration = declaration.isFunctionDeclaration() || isClassDeclaration;
      var scope = declaration.isScope() ? declaration.scope.parent : declaration.scope;
      var id = declaration.node.id;
      var needBindingRegistration = false;

      if (!id) {
        needBindingRegistration = true;
        id = scope.generateUidIdentifier("default");

        if (standaloneDeclaration || declaration.isFunctionExpression() || declaration.isClassExpression()) {
          declaration.node.id = cloneNode$h(id);
        }
      }

      var updatedDeclaration = standaloneDeclaration ? declaration : variableDeclaration$7("var", [variableDeclarator$7(cloneNode$h(id), declaration.node)]);
      var updatedExportDeclaration = exportNamedDeclaration$1(null, [exportSpecifier$1(cloneNode$h(id), identifier$i("default"))]);
      exportDeclaration.insertAfter(updatedExportDeclaration);
      exportDeclaration.replaceWith(updatedDeclaration);

      if (needBindingRegistration) {
        scope.registerDeclaration(exportDeclaration);
      }

      return exportDeclaration;
    }

    if (exportDeclaration.get("specifiers").length > 0) {
      throw new Error("It doesn't make sense to split exported specifiers.");
    }

    var bindingIdentifiers = declaration.getOuterBindingIdentifiers();
    var specifiers = Object.keys(bindingIdentifiers).map(function (name) {
      return exportSpecifier$1(identifier$i(name), identifier$i(name));
    });
    var aliasDeclar = exportNamedDeclaration$1(null, specifiers);
    exportDeclaration.insertAfter(aliasDeclar);
    exportDeclaration.replaceWith(declaration.node);
    return exportDeclaration;
  }

  var VISITOR_KEYS$5 = VISITOR_KEYS$6;
  var renameVisitor = {
    ReferencedIdentifier: function ReferencedIdentifier(_ref, state) {
      var node = _ref.node;

      if (node.name === state.oldName) {
        node.name = state.newName;
      }
    },
    Scope: function Scope(path, state) {
      if (!path.scope.bindingIdentifierEquals(state.oldName, state.binding.identifier)) {
        skipAllButComputedMethodKey(path);
      }
    },
    "AssignmentExpression|Declaration|VariableDeclarator": function AssignmentExpressionDeclarationVariableDeclarator(path, state) {
      if (path.isVariableDeclaration()) return;
      var ids = path.getOuterBindingIdentifiers();

      for (var name in ids) {
        if (name === state.oldName) ids[name].name = state.newName;
      }
    }
  };

  var Renamer = function () {
    function Renamer(binding, oldName, newName) {
      this.newName = newName;
      this.oldName = oldName;
      this.binding = binding;
    }

    var _proto = Renamer.prototype;

    _proto.maybeConvertFromExportDeclaration = function maybeConvertFromExportDeclaration(parentDeclar) {
      var maybeExportDeclar = parentDeclar.parentPath;

      if (!maybeExportDeclar.isExportDeclaration()) {
        return;
      }

      if (maybeExportDeclar.isExportDefaultDeclaration() && !maybeExportDeclar.get("declaration").node.id) {
        return;
      }

      splitExportDeclaration(maybeExportDeclar);
    };

    _proto.maybeConvertFromClassFunctionDeclaration = function maybeConvertFromClassFunctionDeclaration(path) {
      return;
    };

    _proto.maybeConvertFromClassFunctionExpression = function maybeConvertFromClassFunctionExpression(path) {
      return;
    };

    _proto.rename = function rename(block) {
      var _this = this;

      var binding = this.binding,
          oldName = this.oldName,
          newName = this.newName;
      var scope = binding.scope,
          path = binding.path;
      var parentDeclar = path.find(function (path) {
        return path.isDeclaration() || path.isFunctionExpression() || path.isClassExpression();
      });

      if (parentDeclar) {
        var bindingIds = parentDeclar.getOuterBindingIdentifiers();

        if (bindingIds[oldName] === binding.identifier) {
          this.maybeConvertFromExportDeclaration(parentDeclar);
        }
      }

      var blockToTraverse = block || scope.block;

      if ((blockToTraverse == null ? void 0 : blockToTraverse.type) === "SwitchStatement") {
        blockToTraverse.cases.forEach(function (c) {
          scope.traverse(c, renameVisitor, _this);
        });
      } else {
        scope.traverse(blockToTraverse, renameVisitor, this);
      }

      if (!block) {
        scope.removeOwnBinding(oldName);
        scope.bindings[newName] = binding;
        this.binding.identifier.name = newName;
      }

      if (parentDeclar) {
        this.maybeConvertFromClassFunctionDeclaration(parentDeclar);
        this.maybeConvertFromClassFunctionExpression(parentDeclar);
      }
    };

    return Renamer;
  }();

  function skipAllButComputedMethodKey(path) {
    if (!path.isMethod() || !path.node.computed) {
      path.skip();
      return;
    }

    var keys = VISITOR_KEYS$5[path.type];

    for (var _iterator = _createForOfIteratorHelperLoose(keys), _step; !(_step = _iterator()).done;) {
      var key = _step.value;
      if (key !== "key") path.skipKey(key);
    }
  }

  var builtin$1 = {
  	"Array": false,
  	"ArrayBuffer": false,
  	Atomics: false,
  	BigInt: false,
  	BigInt64Array: false,
  	BigUint64Array: false,
  	"Boolean": false,
  	constructor: false,
  	"DataView": false,
  	"Date": false,
  	"decodeURI": false,
  	"decodeURIComponent": false,
  	"encodeURI": false,
  	"encodeURIComponent": false,
  	"Error": false,
  	"escape": false,
  	"eval": false,
  	"EvalError": false,
  	"Float32Array": false,
  	"Float64Array": false,
  	"Function": false,
  	globalThis: false,
  	hasOwnProperty: false,
  	"Infinity": false,
  	"Int16Array": false,
  	"Int32Array": false,
  	"Int8Array": false,
  	"isFinite": false,
  	"isNaN": false,
  	isPrototypeOf: false,
  	"JSON": false,
  	"Map": false,
  	"Math": false,
  	"NaN": false,
  	"Number": false,
  	"Object": false,
  	"parseFloat": false,
  	"parseInt": false,
  	"Promise": false,
  	propertyIsEnumerable: false,
  	"Proxy": false,
  	"RangeError": false,
  	"ReferenceError": false,
  	"Reflect": false,
  	"RegExp": false,
  	"Set": false,
  	SharedArrayBuffer: false,
  	"String": false,
  	"Symbol": false,
  	"SyntaxError": false,
  	toLocaleString: false,
  	toString: false,
  	"TypeError": false,
  	"Uint16Array": false,
  	"Uint32Array": false,
  	"Uint8Array": false,
  	"Uint8ClampedArray": false,
  	"undefined": false,
  	"unescape": false,
  	"URIError": false,
  	valueOf: false,
  	"WeakMap": false,
  	"WeakSet": false
  };
  var es5$1 = {
  	"Array": false,
  	"Boolean": false,
  	constructor: false,
  	"Date": false,
  	"decodeURI": false,
  	"decodeURIComponent": false,
  	"encodeURI": false,
  	"encodeURIComponent": false,
  	"Error": false,
  	"escape": false,
  	"eval": false,
  	"EvalError": false,
  	"Function": false,
  	hasOwnProperty: false,
  	"Infinity": false,
  	"isFinite": false,
  	"isNaN": false,
  	isPrototypeOf: false,
  	"JSON": false,
  	"Math": false,
  	"NaN": false,
  	"Number": false,
  	"Object": false,
  	"parseFloat": false,
  	"parseInt": false,
  	propertyIsEnumerable: false,
  	"RangeError": false,
  	"ReferenceError": false,
  	"RegExp": false,
  	"String": false,
  	"SyntaxError": false,
  	toLocaleString: false,
  	toString: false,
  	"TypeError": false,
  	"undefined": false,
  	"unescape": false,
  	"URIError": false,
  	valueOf: false
  };
  var es2015$1 = {
  	"Array": false,
  	"ArrayBuffer": false,
  	"Boolean": false,
  	constructor: false,
  	"DataView": false,
  	"Date": false,
  	"decodeURI": false,
  	"decodeURIComponent": false,
  	"encodeURI": false,
  	"encodeURIComponent": false,
  	"Error": false,
  	"escape": false,
  	"eval": false,
  	"EvalError": false,
  	"Float32Array": false,
  	"Float64Array": false,
  	"Function": false,
  	hasOwnProperty: false,
  	"Infinity": false,
  	"Int16Array": false,
  	"Int32Array": false,
  	"Int8Array": false,
  	"isFinite": false,
  	"isNaN": false,
  	isPrototypeOf: false,
  	"JSON": false,
  	"Map": false,
  	"Math": false,
  	"NaN": false,
  	"Number": false,
  	"Object": false,
  	"parseFloat": false,
  	"parseInt": false,
  	"Promise": false,
  	propertyIsEnumerable: false,
  	"Proxy": false,
  	"RangeError": false,
  	"ReferenceError": false,
  	"Reflect": false,
  	"RegExp": false,
  	"Set": false,
  	"String": false,
  	"Symbol": false,
  	"SyntaxError": false,
  	toLocaleString: false,
  	toString: false,
  	"TypeError": false,
  	"Uint16Array": false,
  	"Uint32Array": false,
  	"Uint8Array": false,
  	"Uint8ClampedArray": false,
  	"undefined": false,
  	"unescape": false,
  	"URIError": false,
  	valueOf: false,
  	"WeakMap": false,
  	"WeakSet": false
  };
  var es2017$1 = {
  	"Array": false,
  	"ArrayBuffer": false,
  	Atomics: false,
  	"Boolean": false,
  	constructor: false,
  	"DataView": false,
  	"Date": false,
  	"decodeURI": false,
  	"decodeURIComponent": false,
  	"encodeURI": false,
  	"encodeURIComponent": false,
  	"Error": false,
  	"escape": false,
  	"eval": false,
  	"EvalError": false,
  	"Float32Array": false,
  	"Float64Array": false,
  	"Function": false,
  	hasOwnProperty: false,
  	"Infinity": false,
  	"Int16Array": false,
  	"Int32Array": false,
  	"Int8Array": false,
  	"isFinite": false,
  	"isNaN": false,
  	isPrototypeOf: false,
  	"JSON": false,
  	"Map": false,
  	"Math": false,
  	"NaN": false,
  	"Number": false,
  	"Object": false,
  	"parseFloat": false,
  	"parseInt": false,
  	"Promise": false,
  	propertyIsEnumerable: false,
  	"Proxy": false,
  	"RangeError": false,
  	"ReferenceError": false,
  	"Reflect": false,
  	"RegExp": false,
  	"Set": false,
  	SharedArrayBuffer: false,
  	"String": false,
  	"Symbol": false,
  	"SyntaxError": false,
  	toLocaleString: false,
  	toString: false,
  	"TypeError": false,
  	"Uint16Array": false,
  	"Uint32Array": false,
  	"Uint8Array": false,
  	"Uint8ClampedArray": false,
  	"undefined": false,
  	"unescape": false,
  	"URIError": false,
  	valueOf: false,
  	"WeakMap": false,
  	"WeakSet": false
  };
  var browser$4 = {
  	AbortController: false,
  	AbortSignal: false,
  	addEventListener: false,
  	alert: false,
  	AnalyserNode: false,
  	Animation: false,
  	AnimationEffectReadOnly: false,
  	AnimationEffectTiming: false,
  	AnimationEffectTimingReadOnly: false,
  	AnimationEvent: false,
  	AnimationPlaybackEvent: false,
  	AnimationTimeline: false,
  	applicationCache: false,
  	ApplicationCache: false,
  	ApplicationCacheErrorEvent: false,
  	atob: false,
  	Attr: false,
  	Audio: false,
  	AudioBuffer: false,
  	AudioBufferSourceNode: false,
  	AudioContext: false,
  	AudioDestinationNode: false,
  	AudioListener: false,
  	AudioNode: false,
  	AudioParam: false,
  	AudioProcessingEvent: false,
  	AudioScheduledSourceNode: false,
  	"AudioWorkletGlobalScope ": false,
  	AudioWorkletNode: false,
  	AudioWorkletProcessor: false,
  	BarProp: false,
  	BaseAudioContext: false,
  	BatteryManager: false,
  	BeforeUnloadEvent: false,
  	BiquadFilterNode: false,
  	Blob: false,
  	BlobEvent: false,
  	blur: false,
  	BroadcastChannel: false,
  	btoa: false,
  	BudgetService: false,
  	ByteLengthQueuingStrategy: false,
  	Cache: false,
  	caches: false,
  	CacheStorage: false,
  	cancelAnimationFrame: false,
  	cancelIdleCallback: false,
  	CanvasCaptureMediaStreamTrack: false,
  	CanvasGradient: false,
  	CanvasPattern: false,
  	CanvasRenderingContext2D: false,
  	ChannelMergerNode: false,
  	ChannelSplitterNode: false,
  	CharacterData: false,
  	clearInterval: false,
  	clearTimeout: false,
  	clientInformation: false,
  	ClipboardEvent: false,
  	close: false,
  	closed: false,
  	CloseEvent: false,
  	Comment: false,
  	CompositionEvent: false,
  	confirm: false,
  	console: false,
  	ConstantSourceNode: false,
  	ConvolverNode: false,
  	CountQueuingStrategy: false,
  	createImageBitmap: false,
  	Credential: false,
  	CredentialsContainer: false,
  	crypto: false,
  	Crypto: false,
  	CryptoKey: false,
  	CSS: false,
  	CSSConditionRule: false,
  	CSSFontFaceRule: false,
  	CSSGroupingRule: false,
  	CSSImportRule: false,
  	CSSKeyframeRule: false,
  	CSSKeyframesRule: false,
  	CSSMediaRule: false,
  	CSSNamespaceRule: false,
  	CSSPageRule: false,
  	CSSRule: false,
  	CSSRuleList: false,
  	CSSStyleDeclaration: false,
  	CSSStyleRule: false,
  	CSSStyleSheet: false,
  	CSSSupportsRule: false,
  	CustomElementRegistry: false,
  	customElements: false,
  	CustomEvent: false,
  	DataTransfer: false,
  	DataTransferItem: false,
  	DataTransferItemList: false,
  	defaultstatus: false,
  	defaultStatus: false,
  	DelayNode: false,
  	DeviceMotionEvent: false,
  	DeviceOrientationEvent: false,
  	devicePixelRatio: false,
  	dispatchEvent: false,
  	document: false,
  	Document: false,
  	DocumentFragment: false,
  	DocumentType: false,
  	DOMError: false,
  	DOMException: false,
  	DOMImplementation: false,
  	DOMMatrix: false,
  	DOMMatrixReadOnly: false,
  	DOMParser: false,
  	DOMPoint: false,
  	DOMPointReadOnly: false,
  	DOMQuad: false,
  	DOMRect: false,
  	DOMRectReadOnly: false,
  	DOMStringList: false,
  	DOMStringMap: false,
  	DOMTokenList: false,
  	DragEvent: false,
  	DynamicsCompressorNode: false,
  	Element: false,
  	ErrorEvent: false,
  	event: false,
  	Event: false,
  	EventSource: false,
  	EventTarget: false,
  	external: false,
  	fetch: false,
  	File: false,
  	FileList: false,
  	FileReader: false,
  	find: false,
  	focus: false,
  	FocusEvent: false,
  	FontFace: false,
  	FontFaceSetLoadEvent: false,
  	FormData: false,
  	frameElement: false,
  	frames: false,
  	GainNode: false,
  	Gamepad: false,
  	GamepadButton: false,
  	GamepadEvent: false,
  	getComputedStyle: false,
  	getSelection: false,
  	HashChangeEvent: false,
  	Headers: false,
  	history: false,
  	History: false,
  	HTMLAllCollection: false,
  	HTMLAnchorElement: false,
  	HTMLAreaElement: false,
  	HTMLAudioElement: false,
  	HTMLBaseElement: false,
  	HTMLBodyElement: false,
  	HTMLBRElement: false,
  	HTMLButtonElement: false,
  	HTMLCanvasElement: false,
  	HTMLCollection: false,
  	HTMLContentElement: false,
  	HTMLDataElement: false,
  	HTMLDataListElement: false,
  	HTMLDetailsElement: false,
  	HTMLDialogElement: false,
  	HTMLDirectoryElement: false,
  	HTMLDivElement: false,
  	HTMLDListElement: false,
  	HTMLDocument: false,
  	HTMLElement: false,
  	HTMLEmbedElement: false,
  	HTMLFieldSetElement: false,
  	HTMLFontElement: false,
  	HTMLFormControlsCollection: false,
  	HTMLFormElement: false,
  	HTMLFrameElement: false,
  	HTMLFrameSetElement: false,
  	HTMLHeadElement: false,
  	HTMLHeadingElement: false,
  	HTMLHRElement: false,
  	HTMLHtmlElement: false,
  	HTMLIFrameElement: false,
  	HTMLImageElement: false,
  	HTMLInputElement: false,
  	HTMLLabelElement: false,
  	HTMLLegendElement: false,
  	HTMLLIElement: false,
  	HTMLLinkElement: false,
  	HTMLMapElement: false,
  	HTMLMarqueeElement: false,
  	HTMLMediaElement: false,
  	HTMLMenuElement: false,
  	HTMLMetaElement: false,
  	HTMLMeterElement: false,
  	HTMLModElement: false,
  	HTMLObjectElement: false,
  	HTMLOListElement: false,
  	HTMLOptGroupElement: false,
  	HTMLOptionElement: false,
  	HTMLOptionsCollection: false,
  	HTMLOutputElement: false,
  	HTMLParagraphElement: false,
  	HTMLParamElement: false,
  	HTMLPictureElement: false,
  	HTMLPreElement: false,
  	HTMLProgressElement: false,
  	HTMLQuoteElement: false,
  	HTMLScriptElement: false,
  	HTMLSelectElement: false,
  	HTMLShadowElement: false,
  	HTMLSlotElement: false,
  	HTMLSourceElement: false,
  	HTMLSpanElement: false,
  	HTMLStyleElement: false,
  	HTMLTableCaptionElement: false,
  	HTMLTableCellElement: false,
  	HTMLTableColElement: false,
  	HTMLTableElement: false,
  	HTMLTableRowElement: false,
  	HTMLTableSectionElement: false,
  	HTMLTemplateElement: false,
  	HTMLTextAreaElement: false,
  	HTMLTimeElement: false,
  	HTMLTitleElement: false,
  	HTMLTrackElement: false,
  	HTMLUListElement: false,
  	HTMLUnknownElement: false,
  	HTMLVideoElement: false,
  	IDBCursor: false,
  	IDBCursorWithValue: false,
  	IDBDatabase: false,
  	IDBFactory: false,
  	IDBIndex: false,
  	IDBKeyRange: false,
  	IDBObjectStore: false,
  	IDBOpenDBRequest: false,
  	IDBRequest: false,
  	IDBTransaction: false,
  	IDBVersionChangeEvent: false,
  	IdleDeadline: false,
  	IIRFilterNode: false,
  	Image: false,
  	ImageBitmap: false,
  	ImageBitmapRenderingContext: false,
  	ImageCapture: false,
  	ImageData: false,
  	indexedDB: false,
  	innerHeight: false,
  	innerWidth: false,
  	InputEvent: false,
  	IntersectionObserver: false,
  	IntersectionObserverEntry: false,
  	"Intl": false,
  	isSecureContext: false,
  	KeyboardEvent: false,
  	KeyframeEffect: false,
  	KeyframeEffectReadOnly: false,
  	length: false,
  	localStorage: false,
  	location: true,
  	Location: false,
  	locationbar: false,
  	matchMedia: false,
  	MediaDeviceInfo: false,
  	MediaDevices: false,
  	MediaElementAudioSourceNode: false,
  	MediaEncryptedEvent: false,
  	MediaError: false,
  	MediaKeyMessageEvent: false,
  	MediaKeySession: false,
  	MediaKeyStatusMap: false,
  	MediaKeySystemAccess: false,
  	MediaList: false,
  	MediaQueryList: false,
  	MediaQueryListEvent: false,
  	MediaRecorder: false,
  	MediaSettingsRange: false,
  	MediaSource: false,
  	MediaStream: false,
  	MediaStreamAudioDestinationNode: false,
  	MediaStreamAudioSourceNode: false,
  	MediaStreamEvent: false,
  	MediaStreamTrack: false,
  	MediaStreamTrackEvent: false,
  	menubar: false,
  	MessageChannel: false,
  	MessageEvent: false,
  	MessagePort: false,
  	MIDIAccess: false,
  	MIDIConnectionEvent: false,
  	MIDIInput: false,
  	MIDIInputMap: false,
  	MIDIMessageEvent: false,
  	MIDIOutput: false,
  	MIDIOutputMap: false,
  	MIDIPort: false,
  	MimeType: false,
  	MimeTypeArray: false,
  	MouseEvent: false,
  	moveBy: false,
  	moveTo: false,
  	MutationEvent: false,
  	MutationObserver: false,
  	MutationRecord: false,
  	name: false,
  	NamedNodeMap: false,
  	NavigationPreloadManager: false,
  	navigator: false,
  	Navigator: false,
  	NetworkInformation: false,
  	Node: false,
  	NodeFilter: false,
  	NodeIterator: false,
  	NodeList: false,
  	Notification: false,
  	OfflineAudioCompletionEvent: false,
  	OfflineAudioContext: false,
  	offscreenBuffering: false,
  	OffscreenCanvas: true,
  	onabort: true,
  	onafterprint: true,
  	onanimationend: true,
  	onanimationiteration: true,
  	onanimationstart: true,
  	onappinstalled: true,
  	onauxclick: true,
  	onbeforeinstallprompt: true,
  	onbeforeprint: true,
  	onbeforeunload: true,
  	onblur: true,
  	oncancel: true,
  	oncanplay: true,
  	oncanplaythrough: true,
  	onchange: true,
  	onclick: true,
  	onclose: true,
  	oncontextmenu: true,
  	oncuechange: true,
  	ondblclick: true,
  	ondevicemotion: true,
  	ondeviceorientation: true,
  	ondeviceorientationabsolute: true,
  	ondrag: true,
  	ondragend: true,
  	ondragenter: true,
  	ondragleave: true,
  	ondragover: true,
  	ondragstart: true,
  	ondrop: true,
  	ondurationchange: true,
  	onemptied: true,
  	onended: true,
  	onerror: true,
  	onfocus: true,
  	ongotpointercapture: true,
  	onhashchange: true,
  	oninput: true,
  	oninvalid: true,
  	onkeydown: true,
  	onkeypress: true,
  	onkeyup: true,
  	onlanguagechange: true,
  	onload: true,
  	onloadeddata: true,
  	onloadedmetadata: true,
  	onloadstart: true,
  	onlostpointercapture: true,
  	onmessage: true,
  	onmessageerror: true,
  	onmousedown: true,
  	onmouseenter: true,
  	onmouseleave: true,
  	onmousemove: true,
  	onmouseout: true,
  	onmouseover: true,
  	onmouseup: true,
  	onmousewheel: true,
  	onoffline: true,
  	ononline: true,
  	onpagehide: true,
  	onpageshow: true,
  	onpause: true,
  	onplay: true,
  	onplaying: true,
  	onpointercancel: true,
  	onpointerdown: true,
  	onpointerenter: true,
  	onpointerleave: true,
  	onpointermove: true,
  	onpointerout: true,
  	onpointerover: true,
  	onpointerup: true,
  	onpopstate: true,
  	onprogress: true,
  	onratechange: true,
  	onrejectionhandled: true,
  	onreset: true,
  	onresize: true,
  	onscroll: true,
  	onsearch: true,
  	onseeked: true,
  	onseeking: true,
  	onselect: true,
  	onstalled: true,
  	onstorage: true,
  	onsubmit: true,
  	onsuspend: true,
  	ontimeupdate: true,
  	ontoggle: true,
  	ontransitionend: true,
  	onunhandledrejection: true,
  	onunload: true,
  	onvolumechange: true,
  	onwaiting: true,
  	onwheel: true,
  	open: false,
  	openDatabase: false,
  	opener: false,
  	Option: false,
  	origin: false,
  	OscillatorNode: false,
  	outerHeight: false,
  	outerWidth: false,
  	PageTransitionEvent: false,
  	pageXOffset: false,
  	pageYOffset: false,
  	PannerNode: false,
  	parent: false,
  	Path2D: false,
  	PaymentAddress: false,
  	PaymentRequest: false,
  	PaymentRequestUpdateEvent: false,
  	PaymentResponse: false,
  	performance: false,
  	Performance: false,
  	PerformanceEntry: false,
  	PerformanceLongTaskTiming: false,
  	PerformanceMark: false,
  	PerformanceMeasure: false,
  	PerformanceNavigation: false,
  	PerformanceNavigationTiming: false,
  	PerformanceObserver: false,
  	PerformanceObserverEntryList: false,
  	PerformancePaintTiming: false,
  	PerformanceResourceTiming: false,
  	PerformanceTiming: false,
  	PeriodicWave: false,
  	Permissions: false,
  	PermissionStatus: false,
  	personalbar: false,
  	PhotoCapabilities: false,
  	Plugin: false,
  	PluginArray: false,
  	PointerEvent: false,
  	PopStateEvent: false,
  	postMessage: false,
  	Presentation: false,
  	PresentationAvailability: false,
  	PresentationConnection: false,
  	PresentationConnectionAvailableEvent: false,
  	PresentationConnectionCloseEvent: false,
  	PresentationConnectionList: false,
  	PresentationReceiver: false,
  	PresentationRequest: false,
  	print: false,
  	ProcessingInstruction: false,
  	ProgressEvent: false,
  	PromiseRejectionEvent: false,
  	prompt: false,
  	PushManager: false,
  	PushSubscription: false,
  	PushSubscriptionOptions: false,
  	queueMicrotask: false,
  	RadioNodeList: false,
  	Range: false,
  	ReadableStream: false,
  	registerProcessor: false,
  	RemotePlayback: false,
  	removeEventListener: false,
  	Request: false,
  	requestAnimationFrame: false,
  	requestIdleCallback: false,
  	resizeBy: false,
  	ResizeObserver: false,
  	ResizeObserverEntry: false,
  	resizeTo: false,
  	Response: false,
  	RTCCertificate: false,
  	RTCDataChannel: false,
  	RTCDataChannelEvent: false,
  	RTCDtlsTransport: false,
  	RTCIceCandidate: false,
  	RTCIceGatherer: false,
  	RTCIceTransport: false,
  	RTCPeerConnection: false,
  	RTCPeerConnectionIceEvent: false,
  	RTCRtpContributingSource: false,
  	RTCRtpReceiver: false,
  	RTCRtpSender: false,
  	RTCSctpTransport: false,
  	RTCSessionDescription: false,
  	RTCStatsReport: false,
  	RTCTrackEvent: false,
  	screen: false,
  	Screen: false,
  	screenLeft: false,
  	ScreenOrientation: false,
  	screenTop: false,
  	screenX: false,
  	screenY: false,
  	ScriptProcessorNode: false,
  	scroll: false,
  	scrollbars: false,
  	scrollBy: false,
  	scrollTo: false,
  	scrollX: false,
  	scrollY: false,
  	SecurityPolicyViolationEvent: false,
  	Selection: false,
  	self: false,
  	ServiceWorker: false,
  	ServiceWorkerContainer: false,
  	ServiceWorkerRegistration: false,
  	sessionStorage: false,
  	setInterval: false,
  	setTimeout: false,
  	ShadowRoot: false,
  	SharedWorker: false,
  	SourceBuffer: false,
  	SourceBufferList: false,
  	speechSynthesis: false,
  	SpeechSynthesisEvent: false,
  	SpeechSynthesisUtterance: false,
  	StaticRange: false,
  	status: false,
  	statusbar: false,
  	StereoPannerNode: false,
  	stop: false,
  	Storage: false,
  	StorageEvent: false,
  	StorageManager: false,
  	styleMedia: false,
  	StyleSheet: false,
  	StyleSheetList: false,
  	SubtleCrypto: false,
  	SVGAElement: false,
  	SVGAngle: false,
  	SVGAnimatedAngle: false,
  	SVGAnimatedBoolean: false,
  	SVGAnimatedEnumeration: false,
  	SVGAnimatedInteger: false,
  	SVGAnimatedLength: false,
  	SVGAnimatedLengthList: false,
  	SVGAnimatedNumber: false,
  	SVGAnimatedNumberList: false,
  	SVGAnimatedPreserveAspectRatio: false,
  	SVGAnimatedRect: false,
  	SVGAnimatedString: false,
  	SVGAnimatedTransformList: false,
  	SVGAnimateElement: false,
  	SVGAnimateMotionElement: false,
  	SVGAnimateTransformElement: false,
  	SVGAnimationElement: false,
  	SVGCircleElement: false,
  	SVGClipPathElement: false,
  	SVGComponentTransferFunctionElement: false,
  	SVGDefsElement: false,
  	SVGDescElement: false,
  	SVGDiscardElement: false,
  	SVGElement: false,
  	SVGEllipseElement: false,
  	SVGFEBlendElement: false,
  	SVGFEColorMatrixElement: false,
  	SVGFEComponentTransferElement: false,
  	SVGFECompositeElement: false,
  	SVGFEConvolveMatrixElement: false,
  	SVGFEDiffuseLightingElement: false,
  	SVGFEDisplacementMapElement: false,
  	SVGFEDistantLightElement: false,
  	SVGFEDropShadowElement: false,
  	SVGFEFloodElement: false,
  	SVGFEFuncAElement: false,
  	SVGFEFuncBElement: false,
  	SVGFEFuncGElement: false,
  	SVGFEFuncRElement: false,
  	SVGFEGaussianBlurElement: false,
  	SVGFEImageElement: false,
  	SVGFEMergeElement: false,
  	SVGFEMergeNodeElement: false,
  	SVGFEMorphologyElement: false,
  	SVGFEOffsetElement: false,
  	SVGFEPointLightElement: false,
  	SVGFESpecularLightingElement: false,
  	SVGFESpotLightElement: false,
  	SVGFETileElement: false,
  	SVGFETurbulenceElement: false,
  	SVGFilterElement: false,
  	SVGForeignObjectElement: false,
  	SVGGElement: false,
  	SVGGeometryElement: false,
  	SVGGradientElement: false,
  	SVGGraphicsElement: false,
  	SVGImageElement: false,
  	SVGLength: false,
  	SVGLengthList: false,
  	SVGLinearGradientElement: false,
  	SVGLineElement: false,
  	SVGMarkerElement: false,
  	SVGMaskElement: false,
  	SVGMatrix: false,
  	SVGMetadataElement: false,
  	SVGMPathElement: false,
  	SVGNumber: false,
  	SVGNumberList: false,
  	SVGPathElement: false,
  	SVGPatternElement: false,
  	SVGPoint: false,
  	SVGPointList: false,
  	SVGPolygonElement: false,
  	SVGPolylineElement: false,
  	SVGPreserveAspectRatio: false,
  	SVGRadialGradientElement: false,
  	SVGRect: false,
  	SVGRectElement: false,
  	SVGScriptElement: false,
  	SVGSetElement: false,
  	SVGStopElement: false,
  	SVGStringList: false,
  	SVGStyleElement: false,
  	SVGSVGElement: false,
  	SVGSwitchElement: false,
  	SVGSymbolElement: false,
  	SVGTextContentElement: false,
  	SVGTextElement: false,
  	SVGTextPathElement: false,
  	SVGTextPositioningElement: false,
  	SVGTitleElement: false,
  	SVGTransform: false,
  	SVGTransformList: false,
  	SVGTSpanElement: false,
  	SVGUnitTypes: false,
  	SVGUseElement: false,
  	SVGViewElement: false,
  	TaskAttributionTiming: false,
  	Text: false,
  	TextDecoder: false,
  	TextEncoder: false,
  	TextEvent: false,
  	TextMetrics: false,
  	TextTrack: false,
  	TextTrackCue: false,
  	TextTrackCueList: false,
  	TextTrackList: false,
  	TimeRanges: false,
  	toolbar: false,
  	top: false,
  	Touch: false,
  	TouchEvent: false,
  	TouchList: false,
  	TrackEvent: false,
  	TransitionEvent: false,
  	TreeWalker: false,
  	UIEvent: false,
  	URL: false,
  	URLSearchParams: false,
  	ValidityState: false,
  	visualViewport: false,
  	VisualViewport: false,
  	VTTCue: false,
  	WaveShaperNode: false,
  	WebAssembly: false,
  	WebGL2RenderingContext: false,
  	WebGLActiveInfo: false,
  	WebGLBuffer: false,
  	WebGLContextEvent: false,
  	WebGLFramebuffer: false,
  	WebGLProgram: false,
  	WebGLQuery: false,
  	WebGLRenderbuffer: false,
  	WebGLRenderingContext: false,
  	WebGLSampler: false,
  	WebGLShader: false,
  	WebGLShaderPrecisionFormat: false,
  	WebGLSync: false,
  	WebGLTexture: false,
  	WebGLTransformFeedback: false,
  	WebGLUniformLocation: false,
  	WebGLVertexArrayObject: false,
  	WebSocket: false,
  	WheelEvent: false,
  	window: false,
  	Window: false,
  	Worker: false,
  	WritableStream: false,
  	XMLDocument: false,
  	XMLHttpRequest: false,
  	XMLHttpRequestEventTarget: false,
  	XMLHttpRequestUpload: false,
  	XMLSerializer: false,
  	XPathEvaluator: false,
  	XPathExpression: false,
  	XPathResult: false,
  	XSLTProcessor: false
  };
  var worker$1 = {
  	addEventListener: false,
  	applicationCache: false,
  	atob: false,
  	Blob: false,
  	BroadcastChannel: false,
  	btoa: false,
  	Cache: false,
  	caches: false,
  	clearInterval: false,
  	clearTimeout: false,
  	close: true,
  	console: false,
  	fetch: false,
  	FileReaderSync: false,
  	FormData: false,
  	Headers: false,
  	IDBCursor: false,
  	IDBCursorWithValue: false,
  	IDBDatabase: false,
  	IDBFactory: false,
  	IDBIndex: false,
  	IDBKeyRange: false,
  	IDBObjectStore: false,
  	IDBOpenDBRequest: false,
  	IDBRequest: false,
  	IDBTransaction: false,
  	IDBVersionChangeEvent: false,
  	ImageData: false,
  	importScripts: true,
  	indexedDB: false,
  	location: false,
  	MessageChannel: false,
  	MessagePort: false,
  	name: false,
  	navigator: false,
  	Notification: false,
  	onclose: true,
  	onconnect: true,
  	onerror: true,
  	onlanguagechange: true,
  	onmessage: true,
  	onoffline: true,
  	ononline: true,
  	onrejectionhandled: true,
  	onunhandledrejection: true,
  	performance: false,
  	Performance: false,
  	PerformanceEntry: false,
  	PerformanceMark: false,
  	PerformanceMeasure: false,
  	PerformanceNavigation: false,
  	PerformanceResourceTiming: false,
  	PerformanceTiming: false,
  	postMessage: true,
  	"Promise": false,
  	queueMicrotask: false,
  	removeEventListener: false,
  	Request: false,
  	Response: false,
  	self: true,
  	ServiceWorkerRegistration: false,
  	setInterval: false,
  	setTimeout: false,
  	TextDecoder: false,
  	TextEncoder: false,
  	URL: false,
  	URLSearchParams: false,
  	WebSocket: false,
  	Worker: false,
  	WorkerGlobalScope: false,
  	XMLHttpRequest: false
  };
  var node$1 = {
  	__dirname: false,
  	__filename: false,
  	Buffer: false,
  	clearImmediate: false,
  	clearInterval: false,
  	clearTimeout: false,
  	console: false,
  	exports: true,
  	global: false,
  	"Intl": false,
  	module: false,
  	process: false,
  	queueMicrotask: false,
  	require: false,
  	setImmediate: false,
  	setInterval: false,
  	setTimeout: false,
  	TextDecoder: false,
  	TextEncoder: false,
  	URL: false,
  	URLSearchParams: false
  };
  var commonjs$1 = {
  	exports: true,
  	global: false,
  	module: false,
  	require: false
  };
  var amd$1 = {
  	define: false,
  	require: false
  };
  var mocha$1 = {
  	after: false,
  	afterEach: false,
  	before: false,
  	beforeEach: false,
  	context: false,
  	describe: false,
  	it: false,
  	mocha: false,
  	run: false,
  	setup: false,
  	specify: false,
  	suite: false,
  	suiteSetup: false,
  	suiteTeardown: false,
  	teardown: false,
  	test: false,
  	xcontext: false,
  	xdescribe: false,
  	xit: false,
  	xspecify: false
  };
  var jasmine$1 = {
  	afterAll: false,
  	afterEach: false,
  	beforeAll: false,
  	beforeEach: false,
  	describe: false,
  	expect: false,
  	fail: false,
  	fdescribe: false,
  	fit: false,
  	it: false,
  	jasmine: false,
  	pending: false,
  	runs: false,
  	spyOn: false,
  	spyOnProperty: false,
  	waits: false,
  	waitsFor: false,
  	xdescribe: false,
  	xit: false
  };
  var jest$1 = {
  	afterAll: false,
  	afterEach: false,
  	beforeAll: false,
  	beforeEach: false,
  	describe: false,
  	expect: false,
  	fdescribe: false,
  	fit: false,
  	it: false,
  	jest: false,
  	pit: false,
  	require: false,
  	test: false,
  	xdescribe: false,
  	xit: false,
  	xtest: false
  };
  var qunit$1 = {
  	asyncTest: false,
  	deepEqual: false,
  	equal: false,
  	expect: false,
  	module: false,
  	notDeepEqual: false,
  	notEqual: false,
  	notOk: false,
  	notPropEqual: false,
  	notStrictEqual: false,
  	ok: false,
  	propEqual: false,
  	QUnit: false,
  	raises: false,
  	start: false,
  	stop: false,
  	strictEqual: false,
  	test: false,
  	throws: false
  };
  var phantomjs$1 = {
  	console: true,
  	exports: true,
  	phantom: true,
  	require: true,
  	WebPage: true
  };
  var couch$1 = {
  	emit: false,
  	exports: false,
  	getRow: false,
  	log: false,
  	module: false,
  	provides: false,
  	require: false,
  	respond: false,
  	send: false,
  	start: false,
  	sum: false
  };
  var rhino$1 = {
  	defineClass: false,
  	deserialize: false,
  	gc: false,
  	help: false,
  	importClass: false,
  	importPackage: false,
  	java: false,
  	load: false,
  	loadClass: false,
  	Packages: false,
  	print: false,
  	quit: false,
  	readFile: false,
  	readUrl: false,
  	runCommand: false,
  	seal: false,
  	serialize: false,
  	spawn: false,
  	sync: false,
  	toint32: false,
  	version: false
  };
  var nashorn$1 = {
  	__DIR__: false,
  	__FILE__: false,
  	__LINE__: false,
  	com: false,
  	edu: false,
  	exit: false,
  	java: false,
  	Java: false,
  	javafx: false,
  	JavaImporter: false,
  	javax: false,
  	JSAdapter: false,
  	load: false,
  	loadWithNewGlobal: false,
  	org: false,
  	Packages: false,
  	print: false,
  	quit: false
  };
  var wsh$1 = {
  	ActiveXObject: true,
  	Enumerator: true,
  	GetObject: true,
  	ScriptEngine: true,
  	ScriptEngineBuildVersion: true,
  	ScriptEngineMajorVersion: true,
  	ScriptEngineMinorVersion: true,
  	VBArray: true,
  	WScript: true,
  	WSH: true,
  	XDomainRequest: true
  };
  var jquery$1 = {
  	$: false,
  	jQuery: false
  };
  var yui$1 = {
  	YAHOO: false,
  	YAHOO_config: false,
  	YUI: false,
  	YUI_config: false
  };
  var shelljs$1 = {
  	cat: false,
  	cd: false,
  	chmod: false,
  	config: false,
  	cp: false,
  	dirs: false,
  	echo: false,
  	env: false,
  	error: false,
  	exec: false,
  	exit: false,
  	find: false,
  	grep: false,
  	ln: false,
  	ls: false,
  	mkdir: false,
  	mv: false,
  	popd: false,
  	pushd: false,
  	pwd: false,
  	rm: false,
  	sed: false,
  	set: false,
  	target: false,
  	tempdir: false,
  	test: false,
  	touch: false,
  	which: false
  };
  var prototypejs$1 = {
  	$: false,
  	$$: false,
  	$A: false,
  	$break: false,
  	$continue: false,
  	$F: false,
  	$H: false,
  	$R: false,
  	$w: false,
  	Abstract: false,
  	Ajax: false,
  	Autocompleter: false,
  	Builder: false,
  	Class: false,
  	Control: false,
  	Draggable: false,
  	Draggables: false,
  	Droppables: false,
  	Effect: false,
  	Element: false,
  	Enumerable: false,
  	Event: false,
  	Field: false,
  	Form: false,
  	Hash: false,
  	Insertion: false,
  	ObjectRange: false,
  	PeriodicalExecuter: false,
  	Position: false,
  	Prototype: false,
  	Scriptaculous: false,
  	Selector: false,
  	Sortable: false,
  	SortableObserver: false,
  	Sound: false,
  	Template: false,
  	Toggle: false,
  	Try: false
  };
  var meteor$1 = {
  	_: false,
  	$: false,
  	Accounts: false,
  	AccountsClient: false,
  	AccountsCommon: false,
  	AccountsServer: false,
  	App: false,
  	Assets: false,
  	Blaze: false,
  	check: false,
  	Cordova: false,
  	DDP: false,
  	DDPRateLimiter: false,
  	DDPServer: false,
  	Deps: false,
  	EJSON: false,
  	Email: false,
  	HTTP: false,
  	Log: false,
  	Match: false,
  	Meteor: false,
  	Mongo: false,
  	MongoInternals: false,
  	Npm: false,
  	Package: false,
  	Plugin: false,
  	process: false,
  	Random: false,
  	ReactiveDict: false,
  	ReactiveVar: false,
  	Router: false,
  	ServiceConfiguration: false,
  	Session: false,
  	share: false,
  	Spacebars: false,
  	Template: false,
  	Tinytest: false,
  	Tracker: false,
  	UI: false,
  	Utils: false,
  	WebApp: false,
  	WebAppInternals: false
  };
  var mongo$1 = {
  	_isWindows: false,
  	_rand: false,
  	BulkWriteResult: false,
  	cat: false,
  	cd: false,
  	connect: false,
  	db: false,
  	getHostName: false,
  	getMemInfo: false,
  	hostname: false,
  	ISODate: false,
  	listFiles: false,
  	load: false,
  	ls: false,
  	md5sumFile: false,
  	mkdir: false,
  	Mongo: false,
  	NumberInt: false,
  	NumberLong: false,
  	ObjectId: false,
  	PlanCache: false,
  	print: false,
  	printjson: false,
  	pwd: false,
  	quit: false,
  	removeFile: false,
  	rs: false,
  	sh: false,
  	UUID: false,
  	version: false,
  	WriteResult: false
  };
  var applescript$1 = {
  	$: false,
  	Application: false,
  	Automation: false,
  	console: false,
  	delay: false,
  	Library: false,
  	ObjC: false,
  	ObjectSpecifier: false,
  	Path: false,
  	Progress: false,
  	Ref: false
  };
  var serviceworker$1 = {
  	addEventListener: false,
  	applicationCache: false,
  	atob: false,
  	Blob: false,
  	BroadcastChannel: false,
  	btoa: false,
  	Cache: false,
  	caches: false,
  	CacheStorage: false,
  	clearInterval: false,
  	clearTimeout: false,
  	Client: false,
  	clients: false,
  	Clients: false,
  	close: true,
  	console: false,
  	ExtendableEvent: false,
  	ExtendableMessageEvent: false,
  	fetch: false,
  	FetchEvent: false,
  	FileReaderSync: false,
  	FormData: false,
  	Headers: false,
  	IDBCursor: false,
  	IDBCursorWithValue: false,
  	IDBDatabase: false,
  	IDBFactory: false,
  	IDBIndex: false,
  	IDBKeyRange: false,
  	IDBObjectStore: false,
  	IDBOpenDBRequest: false,
  	IDBRequest: false,
  	IDBTransaction: false,
  	IDBVersionChangeEvent: false,
  	ImageData: false,
  	importScripts: false,
  	indexedDB: false,
  	location: false,
  	MessageChannel: false,
  	MessagePort: false,
  	name: false,
  	navigator: false,
  	Notification: false,
  	onclose: true,
  	onconnect: true,
  	onerror: true,
  	onfetch: true,
  	oninstall: true,
  	onlanguagechange: true,
  	onmessage: true,
  	onmessageerror: true,
  	onnotificationclick: true,
  	onnotificationclose: true,
  	onoffline: true,
  	ononline: true,
  	onpush: true,
  	onpushsubscriptionchange: true,
  	onrejectionhandled: true,
  	onsync: true,
  	onunhandledrejection: true,
  	performance: false,
  	Performance: false,
  	PerformanceEntry: false,
  	PerformanceMark: false,
  	PerformanceMeasure: false,
  	PerformanceNavigation: false,
  	PerformanceResourceTiming: false,
  	PerformanceTiming: false,
  	postMessage: true,
  	"Promise": false,
  	queueMicrotask: false,
  	registration: false,
  	removeEventListener: false,
  	Request: false,
  	Response: false,
  	self: false,
  	ServiceWorker: false,
  	ServiceWorkerContainer: false,
  	ServiceWorkerGlobalScope: false,
  	ServiceWorkerMessageEvent: false,
  	ServiceWorkerRegistration: false,
  	setInterval: false,
  	setTimeout: false,
  	skipWaiting: false,
  	TextDecoder: false,
  	TextEncoder: false,
  	URL: false,
  	URLSearchParams: false,
  	WebSocket: false,
  	WindowClient: false,
  	Worker: false,
  	WorkerGlobalScope: false,
  	XMLHttpRequest: false
  };
  var atomtest$1 = {
  	advanceClock: false,
  	fakeClearInterval: false,
  	fakeClearTimeout: false,
  	fakeSetInterval: false,
  	fakeSetTimeout: false,
  	resetTimeouts: false,
  	waitsForPromise: false
  };
  var embertest$1 = {
  	andThen: false,
  	click: false,
  	currentPath: false,
  	currentRouteName: false,
  	currentURL: false,
  	fillIn: false,
  	find: false,
  	findAll: false,
  	findWithAssert: false,
  	keyEvent: false,
  	pauseTest: false,
  	resumeTest: false,
  	triggerEvent: false,
  	visit: false,
  	wait: false
  };
  var protractor$1 = {
  	$: false,
  	$$: false,
  	browser: false,
  	by: false,
  	By: false,
  	DartObject: false,
  	element: false,
  	protractor: false
  };
  var webextensions$1 = {
  	browser: false,
  	chrome: false,
  	opr: false
  };
  var greasemonkey$1 = {
  	cloneInto: false,
  	createObjectIn: false,
  	exportFunction: false,
  	GM: false,
  	GM_addStyle: false,
  	GM_deleteValue: false,
  	GM_getResourceText: false,
  	GM_getResourceURL: false,
  	GM_getValue: false,
  	GM_info: false,
  	GM_listValues: false,
  	GM_log: false,
  	GM_openInTab: false,
  	GM_registerMenuCommand: false,
  	GM_setClipboard: false,
  	GM_setValue: false,
  	GM_xmlhttpRequest: false,
  	unsafeWindow: false
  };
  var devtools$1 = {
  	$: false,
  	$_: false,
  	$$: false,
  	$0: false,
  	$1: false,
  	$2: false,
  	$3: false,
  	$4: false,
  	$x: false,
  	chrome: false,
  	clear: false,
  	copy: false,
  	debug: false,
  	dir: false,
  	dirxml: false,
  	getEventListeners: false,
  	inspect: false,
  	keys: false,
  	monitor: false,
  	monitorEvents: false,
  	profile: false,
  	profileEnd: false,
  	queryObjects: false,
  	table: false,
  	undebug: false,
  	unmonitor: false,
  	unmonitorEvents: false,
  	values: false
  };
  var require$$0$8 = {
  	builtin: builtin$1,
  	es5: es5$1,
  	es2015: es2015$1,
  	es2017: es2017$1,
  	browser: browser$4,
  	worker: worker$1,
  	node: node$1,
  	commonjs: commonjs$1,
  	amd: amd$1,
  	mocha: mocha$1,
  	jasmine: jasmine$1,
  	jest: jest$1,
  	qunit: qunit$1,
  	phantomjs: phantomjs$1,
  	couch: couch$1,
  	rhino: rhino$1,
  	nashorn: nashorn$1,
  	wsh: wsh$1,
  	jquery: jquery$1,
  	yui: yui$1,
  	shelljs: shelljs$1,
  	prototypejs: prototypejs$1,
  	meteor: meteor$1,
  	mongo: mongo$1,
  	applescript: applescript$1,
  	serviceworker: serviceworker$1,
  	atomtest: atomtest$1,
  	embertest: embertest$1,
  	protractor: protractor$1,
  	"shared-node-browser": {
  	clearInterval: false,
  	clearTimeout: false,
  	console: false,
  	setInterval: false,
  	setTimeout: false,
  	URL: false,
  	URLSearchParams: false
  },
  	webextensions: webextensions$1,
  	greasemonkey: greasemonkey$1,
  	devtools: devtools$1
  };

  var globalsBABEL_8_BREAKINGFalse$1 = require$$0$8;

  var globals$1 = globalsBABEL_8_BREAKINGFalse$1;

  var path$3 = new WeakMap();
  var scope = new WeakMap();
  function clear() {
    clearPath();
    clearScope();
  }
  function clearPath() {
    path$3 = new WeakMap();
  }
  function clearScope() {
    scope = new WeakMap();
  }

  var cache$4 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    get path () { return path$3; },
    get scope () { return scope; },
    clear: clear,
    clearPath: clearPath,
    clearScope: clearScope
  });

  var NOT_LOCAL_BINDING$1 = NOT_LOCAL_BINDING$2,
      callExpression$d = callExpression$e,
      cloneNode$g = cloneNode$i,
      getBindingIdentifiers$1 = getBindingIdentifiers$2,
      identifier$h = identifier$j,
      isArrayExpression$1 = isArrayExpression$2,
      isBinary$2 = isBinary$3,
      isClass = isClass$1,
      isClassBody = isClassBody$1,
      isClassDeclaration$2 = isClassDeclaration$3,
      isExportAllDeclaration = isExportAllDeclaration$1,
      isExportDefaultDeclaration$2 = isExportDefaultDeclaration$3,
      isExportNamedDeclaration$1 = isExportNamedDeclaration$2,
      isFunctionDeclaration = isFunctionDeclaration$1,
      isIdentifier$e = isIdentifier$g,
      isImportDeclaration = isImportDeclaration$2,
      isLiteral$6 = isLiteral$7,
      isMethod = isMethod$1,
      isModuleDeclaration = isModuleDeclaration$1,
      isModuleSpecifier = isModuleSpecifier$1,
      isObjectExpression$2 = isObjectExpression$3,
      isProperty$1 = isProperty$2,
      isPureish$1 = isPureish$2,
      isSuper$1 = isSuper$2,
      isTaggedTemplateExpression$1 = isTaggedTemplateExpression$2,
      isTemplateLiteral$1 = isTemplateLiteral$2,
      isThisExpression$1 = isThisExpression$2,
      isUnaryExpression = isUnaryExpression$1,
      isVariableDeclaration$1 = isVariableDeclaration$3,
      matchesPattern$1 = matchesPattern$2,
      memberExpression$a = memberExpression$b,
      numericLiteral$7 = numericLiteral$8,
      toIdentifier = toIdentifier$1,
      unaryExpression$6 = unaryExpression$7,
      variableDeclaration$6 = variableDeclaration$8,
      variableDeclarator$6 = variableDeclarator$8;

  function gatherNodeParts(node, parts) {
    switch (node == null ? void 0 : node.type) {
      default:
        if (isModuleDeclaration(node)) {
          if ((isExportAllDeclaration(node) || isExportNamedDeclaration$1(node) || isImportDeclaration(node)) && node.source) {
            gatherNodeParts(node.source, parts);
          } else if ((isExportNamedDeclaration$1(node) || isImportDeclaration(node)) && node.specifiers && node.specifiers.length) {
            for (var _iterator = _createForOfIteratorHelperLoose(node.specifiers), _step; !(_step = _iterator()).done;) {
              var e = _step.value;
              gatherNodeParts(e, parts);
            }
          } else if ((isExportDefaultDeclaration$2(node) || isExportNamedDeclaration$1(node)) && node.declaration) {
            gatherNodeParts(node.declaration, parts);
          }
        } else if (isModuleSpecifier(node)) {
          gatherNodeParts(node.local, parts);
        } else if (isLiteral$6(node)) {
          parts.push(node.value);
        }

        break;

      case "MemberExpression":
      case "OptionalMemberExpression":
      case "JSXMemberExpression":
        gatherNodeParts(node.object, parts);
        gatherNodeParts(node.property, parts);
        break;

      case "Identifier":
      case "JSXIdentifier":
        parts.push(node.name);
        break;

      case "CallExpression":
      case "OptionalCallExpression":
      case "NewExpression":
        gatherNodeParts(node.callee, parts);
        break;

      case "ObjectExpression":
      case "ObjectPattern":
        for (var _iterator2 = _createForOfIteratorHelperLoose(node.properties), _step2; !(_step2 = _iterator2()).done;) {
          var _e = _step2.value;
          gatherNodeParts(_e, parts);
        }

        break;

      case "SpreadElement":
      case "RestElement":
        gatherNodeParts(node.argument, parts);
        break;

      case "ObjectProperty":
      case "ObjectMethod":
      case "ClassProperty":
      case "ClassMethod":
      case "ClassPrivateProperty":
      case "ClassPrivateMethod":
        gatherNodeParts(node.key, parts);
        break;

      case "ThisExpression":
        parts.push("this");
        break;

      case "Super":
        parts.push("super");
        break;

      case "Import":
        parts.push("import");
        break;

      case "DoExpression":
        parts.push("do");
        break;

      case "YieldExpression":
        parts.push("yield");
        gatherNodeParts(node.argument, parts);
        break;

      case "AwaitExpression":
        parts.push("await");
        gatherNodeParts(node.argument, parts);
        break;

      case "AssignmentExpression":
        gatherNodeParts(node.left, parts);
        break;

      case "VariableDeclarator":
        gatherNodeParts(node.id, parts);
        break;

      case "FunctionExpression":
      case "FunctionDeclaration":
      case "ClassExpression":
      case "ClassDeclaration":
        gatherNodeParts(node.id, parts);
        break;

      case "PrivateName":
        gatherNodeParts(node.id, parts);
        break;

      case "ParenthesizedExpression":
        gatherNodeParts(node.expression, parts);
        break;

      case "UnaryExpression":
      case "UpdateExpression":
        gatherNodeParts(node.argument, parts);
        break;

      case "MetaProperty":
        gatherNodeParts(node.meta, parts);
        gatherNodeParts(node.property, parts);
        break;

      case "JSXElement":
        gatherNodeParts(node.openingElement, parts);
        break;

      case "JSXOpeningElement":
        parts.push(node.name);
        break;

      case "JSXFragment":
        gatherNodeParts(node.openingFragment, parts);
        break;

      case "JSXOpeningFragment":
        parts.push("Fragment");
        break;

      case "JSXNamespacedName":
        gatherNodeParts(node.namespace, parts);
        gatherNodeParts(node.name, parts);
        break;
    }
  }

  var collectorVisitor = {
    ForStatement: function ForStatement(path) {
      var declar = path.get("init");

      if (declar.isVar()) {
        var scope = path.scope;
        var parentScope = scope.getFunctionParent() || scope.getProgramParent();
        parentScope.registerBinding("var", declar);
      }
    },
    Declaration: function Declaration(path) {
      if (path.isBlockScoped()) return;
      if (path.isImportDeclaration()) return;
      if (path.isExportDeclaration()) return;
      var parent = path.scope.getFunctionParent() || path.scope.getProgramParent();
      parent.registerDeclaration(path);
    },
    ImportDeclaration: function ImportDeclaration(path) {
      var parent = path.scope.getBlockParent();
      parent.registerDeclaration(path);
    },
    ReferencedIdentifier: function ReferencedIdentifier(path, state) {
      state.references.push(path);
    },
    ForXStatement: function ForXStatement(path, state) {
      var left = path.get("left");

      if (left.isPattern() || left.isIdentifier()) {
        state.constantViolations.push(path);
      } else if (left.isVar()) {
        var scope = path.scope;
        var parentScope = scope.getFunctionParent() || scope.getProgramParent();
        parentScope.registerBinding("var", left);
      }
    },
    ExportDeclaration: {
      exit: function exit(path) {
        var node = path.node,
            scope = path.scope;
        if (isExportAllDeclaration(node)) return;
        var declar = node.declaration;

        if (isClassDeclaration$2(declar) || isFunctionDeclaration(declar)) {
          var id = declar.id;
          if (!id) return;
          var binding = scope.getBinding(id.name);
          binding == null ? void 0 : binding.reference(path);
        } else if (isVariableDeclaration$1(declar)) {
          for (var _iterator3 = _createForOfIteratorHelperLoose(declar.declarations), _step3; !(_step3 = _iterator3()).done;) {
            var decl = _step3.value;

            for (var _i = 0, _Object$keys = Object.keys(getBindingIdentifiers$1(decl)); _i < _Object$keys.length; _i++) {
              var _name = _Object$keys[_i];

              var _binding = scope.getBinding(_name);

              _binding == null ? void 0 : _binding.reference(path);
            }
          }
        }
      }
    },
    LabeledStatement: function LabeledStatement(path) {
      path.scope.getBlockParent().registerDeclaration(path);
    },
    AssignmentExpression: function AssignmentExpression(path, state) {
      state.assignments.push(path);
    },
    UpdateExpression: function UpdateExpression(path, state) {
      state.constantViolations.push(path);
    },
    UnaryExpression: function UnaryExpression(path, state) {
      if (path.node.operator === "delete") {
        state.constantViolations.push(path);
      }
    },
    BlockScoped: function BlockScoped(path) {
      var scope = path.scope;
      if (scope.path === path) scope = scope.parent;
      var parent = scope.getBlockParent();
      parent.registerDeclaration(path);

      if (path.isClassDeclaration() && path.node.id) {
        var id = path.node.id;
        var _name2 = id.name;
        path.scope.bindings[_name2] = path.scope.parent.getBinding(_name2);
      }
    },
    CatchClause: function CatchClause(path) {
      path.scope.registerBinding("let", path);
    },
    Function: function Function(path) {
      if (path.isFunctionExpression() && path.has("id") && !path.get("id").node[NOT_LOCAL_BINDING$1]) {
        path.scope.registerBinding("local", path.get("id"), path);
      }

      var params = path.get("params");

      for (var _iterator4 = _createForOfIteratorHelperLoose(params), _step4; !(_step4 = _iterator4()).done;) {
        var param = _step4.value;
        path.scope.registerBinding("param", param);
      }
    },
    ClassExpression: function ClassExpression(path) {
      if (path.has("id") && !path.get("id").node[NOT_LOCAL_BINDING$1]) {
        path.scope.registerBinding("local", path);
      }
    }
  };
  var uid = 0;

  var Scope$1 = function () {
    function Scope(path) {
      this.uid = void 0;
      this.path = void 0;
      this.block = void 0;
      this.labels = void 0;
      this.inited = void 0;
      this.bindings = void 0;
      this.references = void 0;
      this.globals = void 0;
      this.uids = void 0;
      this.data = void 0;
      this.crawling = void 0;
      var node = path.node;
      var cached = scope.get(node);

      if ((cached == null ? void 0 : cached.path) === path) {
        return cached;
      }

      scope.set(node, this);
      this.uid = uid++;
      this.block = node;
      this.path = path;
      this.labels = new Map();
      this.inited = false;
    }

    var _proto = Scope.prototype;

    _proto.traverse = function traverse$1(node, opts, state) {
      traverse(node, opts, this, state, this.path);
    };

    _proto.generateDeclaredUidIdentifier = function generateDeclaredUidIdentifier(name) {
      var id = this.generateUidIdentifier(name);
      this.push({
        id: id
      });
      return cloneNode$g(id);
    };

    _proto.generateUidIdentifier = function generateUidIdentifier(name) {
      return identifier$h(this.generateUid(name));
    };

    _proto.generateUid = function generateUid(name) {
      if (name === void 0) {
        name = "temp";
      }

      name = toIdentifier(name).replace(/^_+/, "").replace(/[0-9]+$/g, "");
      var uid;
      var i = 1;

      do {
        uid = this._generateUid(name, i);
        i++;
      } while (this.hasLabel(uid) || this.hasBinding(uid) || this.hasGlobal(uid) || this.hasReference(uid));

      var program = this.getProgramParent();
      program.references[uid] = true;
      program.uids[uid] = true;
      return uid;
    };

    _proto._generateUid = function _generateUid(name, i) {
      var id = name;
      if (i > 1) id += i;
      return "_" + id;
    };

    _proto.generateUidBasedOnNode = function generateUidBasedOnNode(node, defaultName) {
      var parts = [];
      gatherNodeParts(node, parts);
      var id = parts.join("$");
      id = id.replace(/^_/, "") || defaultName || "ref";
      return this.generateUid(id.slice(0, 20));
    };

    _proto.generateUidIdentifierBasedOnNode = function generateUidIdentifierBasedOnNode(node, defaultName) {
      return identifier$h(this.generateUidBasedOnNode(node, defaultName));
    };

    _proto.isStatic = function isStatic(node) {
      if (isThisExpression$1(node) || isSuper$1(node)) {
        return true;
      }

      if (isIdentifier$e(node)) {
        var binding = this.getBinding(node.name);

        if (binding) {
          return binding.constant;
        } else {
          return this.hasBinding(node.name);
        }
      }

      return false;
    };

    _proto.maybeGenerateMemoised = function maybeGenerateMemoised(node, dontPush) {
      if (this.isStatic(node)) {
        return null;
      } else {
        var id = this.generateUidIdentifierBasedOnNode(node);

        if (!dontPush) {
          this.push({
            id: id
          });
          return cloneNode$g(id);
        }

        return id;
      }
    };

    _proto.checkBlockScopedCollisions = function checkBlockScopedCollisions(local, kind, name, id) {
      if (kind === "param") return;
      if (local.kind === "local") return;
      var duplicate = kind === "let" || local.kind === "let" || local.kind === "const" || local.kind === "module" || local.kind === "param" && (kind === "let" || kind === "const");

      if (duplicate) {
        throw this.hub.buildError(id, "Duplicate declaration \"" + name + "\"", TypeError);
      }
    };

    _proto.rename = function rename(oldName, newName, block) {
      var binding = this.getBinding(oldName);

      if (binding) {
        newName = newName || this.generateUidIdentifier(oldName).name;
        return new Renamer(binding, oldName, newName).rename(block);
      }
    };

    _proto._renameFromMap = function _renameFromMap(map, oldName, newName, value) {
      if (map[oldName]) {
        map[newName] = value;
        map[oldName] = null;
      }
    };

    _proto.dump = function dump() {
      var sep = "-".repeat(60);
      console.log(sep);
      var scope = this;

      do {
        console.log("#", scope.block.type);

        for (var _i2 = 0, _Object$keys2 = Object.keys(scope.bindings); _i2 < _Object$keys2.length; _i2++) {
          var _name3 = _Object$keys2[_i2];
          var binding = scope.bindings[_name3];
          console.log(" -", _name3, {
            constant: binding.constant,
            references: binding.references,
            violations: binding.constantViolations.length,
            kind: binding.kind
          });
        }
      } while (scope = scope.parent);

      console.log(sep);
    };

    _proto.toArray = function toArray(node, i, arrayLikeIsIterable) {
      if (isIdentifier$e(node)) {
        var binding = this.getBinding(node.name);

        if (binding != null && binding.constant && binding.path.isGenericType("Array")) {
          return node;
        }
      }

      if (isArrayExpression$1(node)) {
        return node;
      }

      if (isIdentifier$e(node, {
        name: "arguments"
      })) {
        return callExpression$d(memberExpression$a(memberExpression$a(memberExpression$a(identifier$h("Array"), identifier$h("prototype")), identifier$h("slice")), identifier$h("call")), [node]);
      }

      var helperName;
      var args = [node];

      if (i === true) {
        helperName = "toConsumableArray";
      } else if (i) {
        args.push(numericLiteral$7(i));
        helperName = "slicedToArray";
      } else {
        helperName = "toArray";
      }

      if (arrayLikeIsIterable) {
        args.unshift(this.hub.addHelper(helperName));
        helperName = "maybeArrayLike";
      }

      return callExpression$d(this.hub.addHelper(helperName), args);
    };

    _proto.hasLabel = function hasLabel(name) {
      return !!this.getLabel(name);
    };

    _proto.getLabel = function getLabel(name) {
      return this.labels.get(name);
    };

    _proto.registerLabel = function registerLabel(path) {
      this.labels.set(path.node.label.name, path);
    };

    _proto.registerDeclaration = function registerDeclaration(path) {
      if (path.isLabeledStatement()) {
        this.registerLabel(path);
      } else if (path.isFunctionDeclaration()) {
        this.registerBinding("hoisted", path.get("id"), path);
      } else if (path.isVariableDeclaration()) {
        var declarations = path.get("declarations");

        for (var _iterator5 = _createForOfIteratorHelperLoose(declarations), _step5; !(_step5 = _iterator5()).done;) {
          var declar = _step5.value;
          this.registerBinding(path.node.kind, declar);
        }
      } else if (path.isClassDeclaration()) {
        this.registerBinding("let", path);
      } else if (path.isImportDeclaration()) {
        var specifiers = path.get("specifiers");

        for (var _iterator6 = _createForOfIteratorHelperLoose(specifiers), _step6; !(_step6 = _iterator6()).done;) {
          var specifier = _step6.value;
          this.registerBinding("module", specifier);
        }
      } else if (path.isExportDeclaration()) {
        var _declar = path.get("declaration");

        if (_declar.isClassDeclaration() || _declar.isFunctionDeclaration() || _declar.isVariableDeclaration()) {
          this.registerDeclaration(_declar);
        }
      } else {
        this.registerBinding("unknown", path);
      }
    };

    _proto.buildUndefinedNode = function buildUndefinedNode() {
      return unaryExpression$6("void", numericLiteral$7(0), true);
    };

    _proto.registerConstantViolation = function registerConstantViolation(path) {
      var ids = path.getBindingIdentifiers();

      for (var _i3 = 0, _Object$keys3 = Object.keys(ids); _i3 < _Object$keys3.length; _i3++) {
        var _name4 = _Object$keys3[_i3];
        var binding = this.getBinding(_name4);
        if (binding) binding.reassign(path);
      }
    };

    _proto.registerBinding = function registerBinding(kind, path, bindingPath) {
      if (bindingPath === void 0) {
        bindingPath = path;
      }

      if (!kind) throw new ReferenceError("no `kind`");

      if (path.isVariableDeclaration()) {
        var declarators = path.get("declarations");

        for (var _iterator7 = _createForOfIteratorHelperLoose(declarators), _step7; !(_step7 = _iterator7()).done;) {
          var declar = _step7.value;
          this.registerBinding(kind, declar);
        }

        return;
      }

      var parent = this.getProgramParent();
      var ids = path.getOuterBindingIdentifiers(true);

      for (var _i4 = 0, _Object$keys4 = Object.keys(ids); _i4 < _Object$keys4.length; _i4++) {
        var _name5 = _Object$keys4[_i4];
        parent.references[_name5] = true;

        for (var _iterator8 = _createForOfIteratorHelperLoose(ids[_name5]), _step8; !(_step8 = _iterator8()).done;) {
          var id = _step8.value;
          var local = this.getOwnBinding(_name5);

          if (local) {
            if (local.identifier === id) continue;
            this.checkBlockScopedCollisions(local, kind, _name5, id);
          }

          if (local) {
            this.registerConstantViolation(bindingPath);
          } else {
            this.bindings[_name5] = new Binding({
              identifier: id,
              scope: this,
              path: bindingPath,
              kind: kind
            });
          }
        }
      }
    };

    _proto.addGlobal = function addGlobal(node) {
      this.globals[node.name] = node;
    };

    _proto.hasUid = function hasUid(name) {
      var scope = this;

      do {
        if (scope.uids[name]) return true;
      } while (scope = scope.parent);

      return false;
    };

    _proto.hasGlobal = function hasGlobal(name) {
      var scope = this;

      do {
        if (scope.globals[name]) return true;
      } while (scope = scope.parent);

      return false;
    };

    _proto.hasReference = function hasReference(name) {
      return !!this.getProgramParent().references[name];
    };

    _proto.isPure = function isPure(node, constantsOnly) {
      if (isIdentifier$e(node)) {
        var binding = this.getBinding(node.name);
        if (!binding) return false;
        if (constantsOnly) return binding.constant;
        return true;
      } else if (isClass(node)) {
        if (node.superClass && !this.isPure(node.superClass, constantsOnly)) {
          return false;
        }

        return this.isPure(node.body, constantsOnly);
      } else if (isClassBody(node)) {
        for (var _iterator9 = _createForOfIteratorHelperLoose(node.body), _step9; !(_step9 = _iterator9()).done;) {
          var method = _step9.value;
          if (!this.isPure(method, constantsOnly)) return false;
        }

        return true;
      } else if (isBinary$2(node)) {
        return this.isPure(node.left, constantsOnly) && this.isPure(node.right, constantsOnly);
      } else if (isArrayExpression$1(node)) {
        for (var _iterator10 = _createForOfIteratorHelperLoose(node.elements), _step10; !(_step10 = _iterator10()).done;) {
          var elem = _step10.value;
          if (!this.isPure(elem, constantsOnly)) return false;
        }

        return true;
      } else if (isObjectExpression$2(node)) {
        for (var _iterator11 = _createForOfIteratorHelperLoose(node.properties), _step11; !(_step11 = _iterator11()).done;) {
          var prop = _step11.value;
          if (!this.isPure(prop, constantsOnly)) return false;
        }

        return true;
      } else if (isMethod(node)) {
        if (node.computed && !this.isPure(node.key, constantsOnly)) return false;
        if (node.kind === "get" || node.kind === "set") return false;
        return true;
      } else if (isProperty$1(node)) {
        if (node.computed && !this.isPure(node.key, constantsOnly)) return false;
        return this.isPure(node.value, constantsOnly);
      } else if (isUnaryExpression(node)) {
        return this.isPure(node.argument, constantsOnly);
      } else if (isTaggedTemplateExpression$1(node)) {
        return matchesPattern$1(node.tag, "String.raw") && !this.hasBinding("String", true) && this.isPure(node.quasi, constantsOnly);
      } else if (isTemplateLiteral$1(node)) {
        for (var _iterator12 = _createForOfIteratorHelperLoose(node.expressions), _step12; !(_step12 = _iterator12()).done;) {
          var expression = _step12.value;
          if (!this.isPure(expression, constantsOnly)) return false;
        }

        return true;
      } else {
        return isPureish$1(node);
      }
    };

    _proto.setData = function setData(key, val) {
      return this.data[key] = val;
    };

    _proto.getData = function getData(key) {
      var scope = this;

      do {
        var data = scope.data[key];
        if (data != null) return data;
      } while (scope = scope.parent);
    };

    _proto.removeData = function removeData(key) {
      var scope = this;

      do {
        var data = scope.data[key];
        if (data != null) scope.data[key] = null;
      } while (scope = scope.parent);
    };

    _proto.init = function init() {
      if (!this.inited) {
        this.inited = true;
        this.crawl();
      }
    };

    _proto.crawl = function crawl() {
      var path = this.path;
      this.references = Object.create(null);
      this.bindings = Object.create(null);
      this.globals = Object.create(null);
      this.uids = Object.create(null);
      this.data = Object.create(null);
      var programParent = this.getProgramParent();
      if (programParent.crawling) return;
      var state = {
        references: [],
        constantViolations: [],
        assignments: []
      };
      this.crawling = true;

      if (path.type !== "Program" && collectorVisitor._exploded) {
        for (var _iterator13 = _createForOfIteratorHelperLoose(collectorVisitor.enter), _step13; !(_step13 = _iterator13()).done;) {
          var _visit = _step13.value;

          _visit(path, state);
        }

        var typeVisitors = collectorVisitor[path.type];

        if (typeVisitors) {
          for (var _iterator14 = _createForOfIteratorHelperLoose(typeVisitors.enter), _step14; !(_step14 = _iterator14()).done;) {
            var visit = _step14.value;
            visit(path, state);
          }
        }
      }

      path.traverse(collectorVisitor, state);
      this.crawling = false;

      for (var _iterator15 = _createForOfIteratorHelperLoose(state.assignments), _step15; !(_step15 = _iterator15()).done;) {
        var _path = _step15.value;

        var ids = _path.getBindingIdentifiers();

        for (var _i5 = 0, _Object$keys5 = Object.keys(ids); _i5 < _Object$keys5.length; _i5++) {
          var _name6 = _Object$keys5[_i5];
          if (_path.scope.getBinding(_name6)) continue;
          programParent.addGlobal(ids[_name6]);
        }

        _path.scope.registerConstantViolation(_path);
      }

      for (var _iterator16 = _createForOfIteratorHelperLoose(state.references), _step16; !(_step16 = _iterator16()).done;) {
        var ref = _step16.value;
        var binding = ref.scope.getBinding(ref.node.name);

        if (binding) {
          binding.reference(ref);
        } else {
          programParent.addGlobal(ref.node);
        }
      }

      for (var _iterator17 = _createForOfIteratorHelperLoose(state.constantViolations), _step17; !(_step17 = _iterator17()).done;) {
        var _path2 = _step17.value;

        _path2.scope.registerConstantViolation(_path2);
      }
    };

    _proto.push = function push(opts) {
      var path = this.path;

      if (!path.isBlockStatement() && !path.isProgram()) {
        path = this.getBlockParent().path;
      }

      if (path.isSwitchStatement()) {
        path = (this.getFunctionParent() || this.getProgramParent()).path;
      }

      if (path.isLoop() || path.isCatchClause() || path.isFunction()) {
        path.ensureBlock();
        path = path.get("body");
      }

      var unique = opts.unique;
      var kind = opts.kind || "var";
      var blockHoist = opts._blockHoist == null ? 2 : opts._blockHoist;
      var dataKey = "declaration:" + kind + ":" + blockHoist;
      var declarPath = !unique && path.getData(dataKey);

      if (!declarPath) {
        var declar = variableDeclaration$6(kind, []);
        declar._blockHoist = blockHoist;

        var _path$unshiftContaine = path.unshiftContainer("body", [declar]);

        var _path$unshiftContaine2 = _slicedToArray$2(_path$unshiftContaine, 1);

        declarPath = _path$unshiftContaine2[0];
        if (!unique) path.setData(dataKey, declarPath);
      }

      var declarator = variableDeclarator$6(opts.id, opts.init);
      declarPath.node.declarations.push(declarator);
      this.registerBinding(kind, declarPath.get("declarations").pop());
    };

    _proto.getProgramParent = function getProgramParent() {
      var scope = this;

      do {
        if (scope.path.isProgram()) {
          return scope;
        }
      } while (scope = scope.parent);

      throw new Error("Couldn't find a Program");
    };

    _proto.getFunctionParent = function getFunctionParent() {
      var scope = this;

      do {
        if (scope.path.isFunctionParent()) {
          return scope;
        }
      } while (scope = scope.parent);

      return null;
    };

    _proto.getBlockParent = function getBlockParent() {
      var scope = this;

      do {
        if (scope.path.isBlockParent()) {
          return scope;
        }
      } while (scope = scope.parent);

      throw new Error("We couldn't find a BlockStatement, For, Switch, Function, Loop or Program...");
    };

    _proto.getAllBindings = function getAllBindings() {
      var ids = Object.create(null);
      var scope = this;

      do {
        for (var _i6 = 0, _Object$keys6 = Object.keys(scope.bindings); _i6 < _Object$keys6.length; _i6++) {
          var key = _Object$keys6[_i6];

          if (key in ids === false) {
            ids[key] = scope.bindings[key];
          }
        }

        scope = scope.parent;
      } while (scope);

      return ids;
    };

    _proto.getAllBindingsOfKind = function getAllBindingsOfKind() {
      var ids = Object.create(null);

      for (var _len = arguments.length, kinds = new Array(_len), _key = 0; _key < _len; _key++) {
        kinds[_key] = arguments[_key];
      }

      for (var _i7 = 0, _kinds = kinds; _i7 < _kinds.length; _i7++) {
        var kind = _kinds[_i7];
        var scope = this;

        do {
          for (var _i8 = 0, _Object$keys7 = Object.keys(scope.bindings); _i8 < _Object$keys7.length; _i8++) {
            var _name7 = _Object$keys7[_i8];
            var binding = scope.bindings[_name7];
            if (binding.kind === kind) ids[_name7] = binding;
          }

          scope = scope.parent;
        } while (scope);
      }

      return ids;
    };

    _proto.bindingIdentifierEquals = function bindingIdentifierEquals(name, node) {
      return this.getBindingIdentifier(name) === node;
    };

    _proto.getBinding = function getBinding(name) {
      var scope = this;
      var previousPath;

      do {
        var binding = scope.getOwnBinding(name);

        if (binding) {
          var _previousPath;

          if ((_previousPath = previousPath) != null && _previousPath.isPattern() && binding.kind !== "param") ; else {
            return binding;
          }
        }

        previousPath = scope.path;
      } while (scope = scope.parent);
    };

    _proto.getOwnBinding = function getOwnBinding(name) {
      return this.bindings[name];
    };

    _proto.getBindingIdentifier = function getBindingIdentifier(name) {
      var _this$getBinding;

      return (_this$getBinding = this.getBinding(name)) == null ? void 0 : _this$getBinding.identifier;
    };

    _proto.getOwnBindingIdentifier = function getOwnBindingIdentifier(name) {
      var binding = this.bindings[name];
      return binding == null ? void 0 : binding.identifier;
    };

    _proto.hasOwnBinding = function hasOwnBinding(name) {
      return !!this.getOwnBinding(name);
    };

    _proto.hasBinding = function hasBinding(name, noGlobals) {
      if (!name) return false;
      if (this.hasOwnBinding(name)) return true;
      if (this.parentHasBinding(name, noGlobals)) return true;
      if (this.hasUid(name)) return true;
      if (!noGlobals && Scope.globals.includes(name)) return true;
      if (!noGlobals && Scope.contextVariables.includes(name)) return true;
      return false;
    };

    _proto.parentHasBinding = function parentHasBinding(name, noGlobals) {
      var _this$parent;

      return (_this$parent = this.parent) == null ? void 0 : _this$parent.hasBinding(name, noGlobals);
    };

    _proto.moveBindingTo = function moveBindingTo(name, scope) {
      var info = this.getBinding(name);

      if (info) {
        info.scope.removeOwnBinding(name);
        info.scope = scope;
        scope.bindings[name] = info;
      }
    };

    _proto.removeOwnBinding = function removeOwnBinding(name) {
      delete this.bindings[name];
    };

    _proto.removeBinding = function removeBinding(name) {
      var _this$getBinding2;

      (_this$getBinding2 = this.getBinding(name)) == null ? void 0 : _this$getBinding2.scope.removeOwnBinding(name);
      var scope = this;

      do {
        if (scope.uids[name]) {
          scope.uids[name] = false;
        }
      } while (scope = scope.parent);
    };

    _createClass(Scope, [{
      key: "parent",
      get: function get() {
        var _parent;

        var parent,
            path = this.path;

        do {
          var isKey = path.key === "key";
          path = path.parentPath;
          if (isKey && path.isMethod()) path = path.parentPath;
          if (path && path.isScope()) parent = path;
        } while (path && !parent);

        return (_parent = parent) == null ? void 0 : _parent.scope;
      }
    }, {
      key: "parentBlock",
      get: function get() {
        return this.path.parent;
      }
    }, {
      key: "hub",
      get: function get() {
        return this.path.hub;
      }
    }]);

    return Scope;
  }();

  Scope$1.globals = Object.keys(globals$1.builtin);
  Scope$1.contextVariables = ["arguments", "undefined", "Infinity", "NaN"];

  var intToCharMap$1 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');

  var encode$3 = function encode(number) {
    if (0 <= number && number < intToCharMap$1.length) {
      return intToCharMap$1[number];
    }

    throw new TypeError("Must be between 0 and 63: " + number);
  };

  var decode$3 = function decode(charCode) {
    var bigA = 65;
    var bigZ = 90;
    var littleA = 97;
    var littleZ = 122;
    var zero = 48;
    var nine = 57;
    var plus = 43;
    var slash = 47;
    var littleOffset = 26;
    var numberOffset = 52;

    if (bigA <= charCode && charCode <= bigZ) {
      return charCode - bigA;
    }

    if (littleA <= charCode && charCode <= littleZ) {
      return charCode - littleA + littleOffset;
    }

    if (zero <= charCode && charCode <= nine) {
      return charCode - zero + numberOffset;
    }

    if (charCode == plus) {
      return 62;
    }

    if (charCode == slash) {
      return 63;
    }

    return -1;
  };

  var base64$1 = {
    encode: encode$3,
    decode: decode$3
  };

  var VLQ_BASE_SHIFT$1 = 5;
  var VLQ_BASE$1 = 1 << VLQ_BASE_SHIFT$1;
  var VLQ_BASE_MASK$1 = VLQ_BASE$1 - 1;
  var VLQ_CONTINUATION_BIT$1 = VLQ_BASE$1;

  function toVLQSigned$1(aValue) {
    return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
  }

  function fromVLQSigned$1(aValue) {
    var isNegative = (aValue & 1) === 1;
    var shifted = aValue >> 1;
    return isNegative ? -shifted : shifted;
  }

  var encode$2 = function base64VLQ_encode(aValue) {
    var encoded = "";
    var digit;
    var vlq = toVLQSigned$1(aValue);

    do {
      digit = vlq & VLQ_BASE_MASK$1;
      vlq >>>= VLQ_BASE_SHIFT$1;

      if (vlq > 0) {
        digit |= VLQ_CONTINUATION_BIT$1;
      }

      encoded += base64$1.encode(digit);
    } while (vlq > 0);

    return encoded;
  };

  var decode$2 = function base64VLQ_decode(aStr, aIndex, aOutParam) {
    var strLen = aStr.length;
    var result = 0;
    var shift = 0;
    var continuation, digit;

    do {
      if (aIndex >= strLen) {
        throw new Error("Expected more digits in base 64 VLQ value.");
      }

      digit = base64$1.decode(aStr.charCodeAt(aIndex++));

      if (digit === -1) {
        throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
      }

      continuation = !!(digit & VLQ_CONTINUATION_BIT$1);
      digit &= VLQ_BASE_MASK$1;
      result = result + (digit << shift);
      shift += VLQ_BASE_SHIFT$1;
    } while (continuation);

    aOutParam.value = fromVLQSigned$1(result);
    aOutParam.rest = aIndex;
  };

  var base64Vlq$1 = {
    encode: encode$2,
    decode: decode$2
  };

  var util$6 = createCommonjsModule(function (module, exports) {
    function getArg(aArgs, aName, aDefaultValue) {
      if (aName in aArgs) {
        return aArgs[aName];
      } else if (arguments.length === 3) {
        return aDefaultValue;
      } else {
        throw new Error('"' + aName + '" is a required argument.');
      }
    }

    exports.getArg = getArg;
    var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.]*)(?::(\d+))?(\S*)$/;
    var dataUrlRegexp = /^data:.+\,.+$/;

    function urlParse(aUrl) {
      var match = aUrl.match(urlRegexp);

      if (!match) {
        return null;
      }

      return {
        scheme: match[1],
        auth: match[2],
        host: match[3],
        port: match[4],
        path: match[5]
      };
    }

    exports.urlParse = urlParse;

    function urlGenerate(aParsedUrl) {
      var url = '';

      if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ':';
      }

      url += '//';

      if (aParsedUrl.auth) {
        url += aParsedUrl.auth + '@';
      }

      if (aParsedUrl.host) {
        url += aParsedUrl.host;
      }

      if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
      }

      if (aParsedUrl.path) {
        url += aParsedUrl.path;
      }

      return url;
    }

    exports.urlGenerate = urlGenerate;

    function normalize(aPath) {
      var path = aPath;
      var url = urlParse(aPath);

      if (url) {
        if (!url.path) {
          return aPath;
        }

        path = url.path;
      }

      var isAbsolute = exports.isAbsolute(path);
      var parts = path.split(/\/+/);

      for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
        part = parts[i];

        if (part === '.') {
          parts.splice(i, 1);
        } else if (part === '..') {
          up++;
        } else if (up > 0) {
          if (part === '') {
            parts.splice(i + 1, up);
            up = 0;
          } else {
            parts.splice(i, 2);
            up--;
          }
        }
      }

      path = parts.join('/');

      if (path === '') {
        path = isAbsolute ? '/' : '.';
      }

      if (url) {
        url.path = path;
        return urlGenerate(url);
      }

      return path;
    }

    exports.normalize = normalize;

    function join(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }

      if (aPath === "") {
        aPath = ".";
      }

      var aPathUrl = urlParse(aPath);
      var aRootUrl = urlParse(aRoot);

      if (aRootUrl) {
        aRoot = aRootUrl.path || '/';
      }

      if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
          aPathUrl.scheme = aRootUrl.scheme;
        }

        return urlGenerate(aPathUrl);
      }

      if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
      }

      if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
      }

      var joined = aPath.charAt(0) === '/' ? aPath : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

      if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
      }

      return joined;
    }

    exports.join = join;

    exports.isAbsolute = function (aPath) {
      return aPath.charAt(0) === '/' || !!aPath.match(urlRegexp);
    };

    function relative(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }

      aRoot = aRoot.replace(/\/$/, '');
      var level = 0;

      while (aPath.indexOf(aRoot + '/') !== 0) {
        var index = aRoot.lastIndexOf("/");

        if (index < 0) {
          return aPath;
        }

        aRoot = aRoot.slice(0, index);

        if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
          return aPath;
        }

        ++level;
      }

      return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
    }

    exports.relative = relative;

    var supportsNullProto = function () {
      var obj = Object.create(null);
      return !('__proto__' in obj);
    }();

    function identity(s) {
      return s;
    }

    function toSetString(aStr) {
      if (isProtoString(aStr)) {
        return '$' + aStr;
      }

      return aStr;
    }

    exports.toSetString = supportsNullProto ? identity : toSetString;

    function fromSetString(aStr) {
      if (isProtoString(aStr)) {
        return aStr.slice(1);
      }

      return aStr;
    }

    exports.fromSetString = supportsNullProto ? identity : fromSetString;

    function isProtoString(s) {
      if (!s) {
        return false;
      }

      var length = s.length;

      if (length < 9) {
        return false;
      }

      if (s.charCodeAt(length - 1) !== 95 || s.charCodeAt(length - 2) !== 95 || s.charCodeAt(length - 3) !== 111 || s.charCodeAt(length - 4) !== 116 || s.charCodeAt(length - 5) !== 111 || s.charCodeAt(length - 6) !== 114 || s.charCodeAt(length - 7) !== 112 || s.charCodeAt(length - 8) !== 95 || s.charCodeAt(length - 9) !== 95) {
        return false;
      }

      for (var i = length - 10; i >= 0; i--) {
        if (s.charCodeAt(i) !== 36) {
          return false;
        }
      }

      return true;
    }

    function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
      var cmp = mappingA.source - mappingB.source;

      if (cmp !== 0) {
        return cmp;
      }

      cmp = mappingA.originalLine - mappingB.originalLine;

      if (cmp !== 0) {
        return cmp;
      }

      cmp = mappingA.originalColumn - mappingB.originalColumn;

      if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
      }

      cmp = mappingA.generatedColumn - mappingB.generatedColumn;

      if (cmp !== 0) {
        return cmp;
      }

      cmp = mappingA.generatedLine - mappingB.generatedLine;

      if (cmp !== 0) {
        return cmp;
      }

      return mappingA.name - mappingB.name;
    }

    exports.compareByOriginalPositions = compareByOriginalPositions;

    function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;

      if (cmp !== 0) {
        return cmp;
      }

      cmp = mappingA.generatedColumn - mappingB.generatedColumn;

      if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
      }

      cmp = mappingA.source - mappingB.source;

      if (cmp !== 0) {
        return cmp;
      }

      cmp = mappingA.originalLine - mappingB.originalLine;

      if (cmp !== 0) {
        return cmp;
      }

      cmp = mappingA.originalColumn - mappingB.originalColumn;

      if (cmp !== 0) {
        return cmp;
      }

      return mappingA.name - mappingB.name;
    }

    exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

    function strcmp(aStr1, aStr2) {
      if (aStr1 === aStr2) {
        return 0;
      }

      if (aStr1 > aStr2) {
        return 1;
      }

      return -1;
    }

    function compareByGeneratedPositionsInflated(mappingA, mappingB) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;

      if (cmp !== 0) {
        return cmp;
      }

      cmp = mappingA.generatedColumn - mappingB.generatedColumn;

      if (cmp !== 0) {
        return cmp;
      }

      cmp = strcmp(mappingA.source, mappingB.source);

      if (cmp !== 0) {
        return cmp;
      }

      cmp = mappingA.originalLine - mappingB.originalLine;

      if (cmp !== 0) {
        return cmp;
      }

      cmp = mappingA.originalColumn - mappingB.originalColumn;

      if (cmp !== 0) {
        return cmp;
      }

      return strcmp(mappingA.name, mappingB.name);
    }

    exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
  }, "/$$rollup_base$$/packages/babel-generator/node_modules/source-map/lib");

  var has$c = Object.prototype.hasOwnProperty;
  var hasNativeMap$1 = typeof Map !== "undefined";

  function ArraySet$5() {
    this._array = [];
    this._set = hasNativeMap$1 ? new Map() : Object.create(null);
  }

  ArraySet$5.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
    var set = new ArraySet$5();

    for (var i = 0, len = aArray.length; i < len; i++) {
      set.add(aArray[i], aAllowDuplicates);
    }

    return set;
  };

  ArraySet$5.prototype.size = function ArraySet_size() {
    return hasNativeMap$1 ? this._set.size : Object.getOwnPropertyNames(this._set).length;
  };

  ArraySet$5.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
    var sStr = hasNativeMap$1 ? aStr : util$6.toSetString(aStr);
    var isDuplicate = hasNativeMap$1 ? this.has(aStr) : has$c.call(this._set, sStr);
    var idx = this._array.length;

    if (!isDuplicate || aAllowDuplicates) {
      this._array.push(aStr);
    }

    if (!isDuplicate) {
      if (hasNativeMap$1) {
        this._set.set(aStr, idx);
      } else {
        this._set[sStr] = idx;
      }
    }
  };

  ArraySet$5.prototype.has = function ArraySet_has(aStr) {
    if (hasNativeMap$1) {
      return this._set.has(aStr);
    } else {
      var sStr = util$6.toSetString(aStr);
      return has$c.call(this._set, sStr);
    }
  };

  ArraySet$5.prototype.indexOf = function ArraySet_indexOf(aStr) {
    if (hasNativeMap$1) {
      var idx = this._set.get(aStr);

      if (idx >= 0) {
        return idx;
      }
    } else {
      var sStr = util$6.toSetString(aStr);

      if (has$c.call(this._set, sStr)) {
        return this._set[sStr];
      }
    }

    throw new Error('"' + aStr + '" is not in the set.');
  };

  ArraySet$5.prototype.at = function ArraySet_at(aIdx) {
    if (aIdx >= 0 && aIdx < this._array.length) {
      return this._array[aIdx];
    }

    throw new Error('No element indexed by ' + aIdx);
  };

  ArraySet$5.prototype.toArray = function ArraySet_toArray() {
    return this._array.slice();
  };

  var ArraySet_1$1 = ArraySet$5;
  var arraySet$1 = {
    ArraySet: ArraySet_1$1
  };

  function generatedPositionAfter$1(mappingA, mappingB) {
    var lineA = mappingA.generatedLine;
    var lineB = mappingB.generatedLine;
    var columnA = mappingA.generatedColumn;
    var columnB = mappingB.generatedColumn;
    return lineB > lineA || lineB == lineA && columnB >= columnA || util$6.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
  }

  function MappingList$3() {
    this._array = [];
    this._sorted = true;
    this._last = {
      generatedLine: -1,
      generatedColumn: 0
    };
  }

  MappingList$3.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
    this._array.forEach(aCallback, aThisArg);
  };

  MappingList$3.prototype.add = function MappingList_add(aMapping) {
    if (generatedPositionAfter$1(this._last, aMapping)) {
      this._last = aMapping;

      this._array.push(aMapping);
    } else {
      this._sorted = false;

      this._array.push(aMapping);
    }
  };

  MappingList$3.prototype.toArray = function MappingList_toArray() {
    if (!this._sorted) {
      this._array.sort(util$6.compareByGeneratedPositionsInflated);

      this._sorted = true;
    }

    return this._array;
  };

  var MappingList_1$1 = MappingList$3;
  var mappingList$1 = {
    MappingList: MappingList_1$1
  };

  var ArraySet$4 = arraySet$1.ArraySet;
  var MappingList$2 = mappingList$1.MappingList;

  function SourceMapGenerator$5(aArgs) {
    if (!aArgs) {
      aArgs = {};
    }

    this._file = util$6.getArg(aArgs, 'file', null);
    this._sourceRoot = util$6.getArg(aArgs, 'sourceRoot', null);
    this._skipValidation = util$6.getArg(aArgs, 'skipValidation', false);
    this._sources = new ArraySet$4();
    this._names = new ArraySet$4();
    this._mappings = new MappingList$2();
    this._sourcesContents = null;
  }

  SourceMapGenerator$5.prototype._version = 3;

  SourceMapGenerator$5.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
    var sourceRoot = aSourceMapConsumer.sourceRoot;
    var generator = new SourceMapGenerator$5({
      file: aSourceMapConsumer.file,
      sourceRoot: sourceRoot
    });
    aSourceMapConsumer.eachMapping(function (mapping) {
      var newMapping = {
        generated: {
          line: mapping.generatedLine,
          column: mapping.generatedColumn
        }
      };

      if (mapping.source != null) {
        newMapping.source = mapping.source;

        if (sourceRoot != null) {
          newMapping.source = util$6.relative(sourceRoot, newMapping.source);
        }

        newMapping.original = {
          line: mapping.originalLine,
          column: mapping.originalColumn
        };

        if (mapping.name != null) {
          newMapping.name = mapping.name;
        }
      }

      generator.addMapping(newMapping);
    });
    aSourceMapConsumer.sources.forEach(function (sourceFile) {
      var content = aSourceMapConsumer.sourceContentFor(sourceFile);

      if (content != null) {
        generator.setSourceContent(sourceFile, content);
      }
    });
    return generator;
  };

  SourceMapGenerator$5.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
    var generated = util$6.getArg(aArgs, 'generated');
    var original = util$6.getArg(aArgs, 'original', null);
    var source = util$6.getArg(aArgs, 'source', null);
    var name = util$6.getArg(aArgs, 'name', null);

    if (!this._skipValidation) {
      this._validateMapping(generated, original, source, name);
    }

    if (source != null) {
      source = String(source);

      if (!this._sources.has(source)) {
        this._sources.add(source);
      }
    }

    if (name != null) {
      name = String(name);

      if (!this._names.has(name)) {
        this._names.add(name);
      }
    }

    this._mappings.add({
      generatedLine: generated.line,
      generatedColumn: generated.column,
      originalLine: original != null && original.line,
      originalColumn: original != null && original.column,
      source: source,
      name: name
    });
  };

  SourceMapGenerator$5.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
    var source = aSourceFile;

    if (this._sourceRoot != null) {
      source = util$6.relative(this._sourceRoot, source);
    }

    if (aSourceContent != null) {
      if (!this._sourcesContents) {
        this._sourcesContents = Object.create(null);
      }

      this._sourcesContents[util$6.toSetString(source)] = aSourceContent;
    } else if (this._sourcesContents) {
      delete this._sourcesContents[util$6.toSetString(source)];

      if (Object.keys(this._sourcesContents).length === 0) {
        this._sourcesContents = null;
      }
    }
  };

  SourceMapGenerator$5.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
    var sourceFile = aSourceFile;

    if (aSourceFile == null) {
      if (aSourceMapConsumer.file == null) {
        throw new Error('SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' + 'or the source map\'s "file" property. Both were omitted.');
      }

      sourceFile = aSourceMapConsumer.file;
    }

    var sourceRoot = this._sourceRoot;

    if (sourceRoot != null) {
      sourceFile = util$6.relative(sourceRoot, sourceFile);
    }

    var newSources = new ArraySet$4();
    var newNames = new ArraySet$4();

    this._mappings.unsortedForEach(function (mapping) {
      if (mapping.source === sourceFile && mapping.originalLine != null) {
        var original = aSourceMapConsumer.originalPositionFor({
          line: mapping.originalLine,
          column: mapping.originalColumn
        });

        if (original.source != null) {
          mapping.source = original.source;

          if (aSourceMapPath != null) {
            mapping.source = util$6.join(aSourceMapPath, mapping.source);
          }

          if (sourceRoot != null) {
            mapping.source = util$6.relative(sourceRoot, mapping.source);
          }

          mapping.originalLine = original.line;
          mapping.originalColumn = original.column;

          if (original.name != null) {
            mapping.name = original.name;
          }
        }
      }

      var source = mapping.source;

      if (source != null && !newSources.has(source)) {
        newSources.add(source);
      }

      var name = mapping.name;

      if (name != null && !newNames.has(name)) {
        newNames.add(name);
      }
    }, this);

    this._sources = newSources;
    this._names = newNames;
    aSourceMapConsumer.sources.forEach(function (sourceFile) {
      var content = aSourceMapConsumer.sourceContentFor(sourceFile);

      if (content != null) {
        if (aSourceMapPath != null) {
          sourceFile = util$6.join(aSourceMapPath, sourceFile);
        }

        if (sourceRoot != null) {
          sourceFile = util$6.relative(sourceRoot, sourceFile);
        }

        this.setSourceContent(sourceFile, content);
      }
    }, this);
  };

  SourceMapGenerator$5.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
    if (aOriginal && typeof aOriginal.line !== 'number' && typeof aOriginal.column !== 'number') {
      throw new Error('original.line and original.column are not numbers -- you probably meant to omit ' + 'the original mapping entirely and only map the generated position. If so, pass ' + 'null for the original mapping instead of an object with empty or null values.');
    }

    if (aGenerated && 'line' in aGenerated && 'column' in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
      return;
    } else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated && aOriginal && 'line' in aOriginal && 'column' in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
      return;
    } else {
      throw new Error('Invalid mapping: ' + JSON.stringify({
        generated: aGenerated,
        source: aSource,
        original: aOriginal,
        name: aName
      }));
    }
  };

  SourceMapGenerator$5.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
    var previousGeneratedColumn = 0;
    var previousGeneratedLine = 1;
    var previousOriginalColumn = 0;
    var previousOriginalLine = 0;
    var previousName = 0;
    var previousSource = 0;
    var result = '';
    var next;
    var mapping;
    var nameIdx;
    var sourceIdx;

    var mappings = this._mappings.toArray();

    for (var i = 0, len = mappings.length; i < len; i++) {
      mapping = mappings[i];
      next = '';

      if (mapping.generatedLine !== previousGeneratedLine) {
        previousGeneratedColumn = 0;

        while (mapping.generatedLine !== previousGeneratedLine) {
          next += ';';
          previousGeneratedLine++;
        }
      } else {
        if (i > 0) {
          if (!util$6.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
            continue;
          }

          next += ',';
        }
      }

      next += base64Vlq$1.encode(mapping.generatedColumn - previousGeneratedColumn);
      previousGeneratedColumn = mapping.generatedColumn;

      if (mapping.source != null) {
        sourceIdx = this._sources.indexOf(mapping.source);
        next += base64Vlq$1.encode(sourceIdx - previousSource);
        previousSource = sourceIdx;
        next += base64Vlq$1.encode(mapping.originalLine - 1 - previousOriginalLine);
        previousOriginalLine = mapping.originalLine - 1;
        next += base64Vlq$1.encode(mapping.originalColumn - previousOriginalColumn);
        previousOriginalColumn = mapping.originalColumn;

        if (mapping.name != null) {
          nameIdx = this._names.indexOf(mapping.name);
          next += base64Vlq$1.encode(nameIdx - previousName);
          previousName = nameIdx;
        }
      }

      result += next;
    }

    return result;
  };

  SourceMapGenerator$5.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
    return aSources.map(function (source) {
      if (!this._sourcesContents) {
        return null;
      }

      if (aSourceRoot != null) {
        source = util$6.relative(aSourceRoot, source);
      }

      var key = util$6.toSetString(source);
      return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
    }, this);
  };

  SourceMapGenerator$5.prototype.toJSON = function SourceMapGenerator_toJSON() {
    var map = {
      version: this._version,
      sources: this._sources.toArray(),
      names: this._names.toArray(),
      mappings: this._serializeMappings()
    };

    if (this._file != null) {
      map.file = this._file;
    }

    if (this._sourceRoot != null) {
      map.sourceRoot = this._sourceRoot;
    }

    if (this._sourcesContents) {
      map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
    }

    return map;
  };

  SourceMapGenerator$5.prototype.toString = function SourceMapGenerator_toString() {
    return JSON.stringify(this.toJSON());
  };

  var SourceMapGenerator_1$1 = SourceMapGenerator$5;
  var sourceMapGenerator$1 = {
    SourceMapGenerator: SourceMapGenerator_1$1
  };

  var binarySearch$1 = createCommonjsModule(function (module, exports) {
    exports.GREATEST_LOWER_BOUND = 1;
    exports.LEAST_UPPER_BOUND = 2;

    function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
      var mid = Math.floor((aHigh - aLow) / 2) + aLow;
      var cmp = aCompare(aNeedle, aHaystack[mid], true);

      if (cmp === 0) {
        return mid;
      } else if (cmp > 0) {
        if (aHigh - mid > 1) {
          return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
        }

        if (aBias == exports.LEAST_UPPER_BOUND) {
          return aHigh < aHaystack.length ? aHigh : -1;
        } else {
          return mid;
        }
      } else {
        if (mid - aLow > 1) {
          return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }

        if (aBias == exports.LEAST_UPPER_BOUND) {
          return mid;
        } else {
          return aLow < 0 ? -1 : aLow;
        }
      }
    }

    exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
      if (aHaystack.length === 0) {
        return -1;
      }

      var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack, aCompare, aBias || exports.GREATEST_LOWER_BOUND);

      if (index < 0) {
        return -1;
      }

      while (index - 1 >= 0) {
        if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
          break;
        }

        --index;
      }

      return index;
    };
  }, "/$$rollup_base$$/packages/babel-generator/node_modules/source-map/lib");

  function swap$1(ary, x, y) {
    var temp = ary[x];
    ary[x] = ary[y];
    ary[y] = temp;
  }

  function randomIntInRange$1(low, high) {
    return Math.round(low + Math.random() * (high - low));
  }

  function doQuickSort$1(ary, comparator, p, r) {
    if (p < r) {
      var pivotIndex = randomIntInRange$1(p, r);
      var i = p - 1;
      swap$1(ary, pivotIndex, r);
      var pivot = ary[r];

      for (var j = p; j < r; j++) {
        if (comparator(ary[j], pivot) <= 0) {
          i += 1;
          swap$1(ary, i, j);
        }
      }

      swap$1(ary, i + 1, j);
      var q = i + 1;
      doQuickSort$1(ary, comparator, p, q - 1);
      doQuickSort$1(ary, comparator, q + 1, r);
    }
  }

  var quickSort_1$1 = function quickSort_1(ary, comparator) {
    doQuickSort$1(ary, comparator, 0, ary.length - 1);
  };

  var quickSort$3 = {
    quickSort: quickSort_1$1
  };

  var ArraySet$3 = arraySet$1.ArraySet;
  var quickSort$2 = quickSort$3.quickSort;

  function SourceMapConsumer$3(aSourceMap) {
    var sourceMap = aSourceMap;

    if (typeof aSourceMap === 'string') {
      sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
    }

    return sourceMap.sections != null ? new IndexedSourceMapConsumer$1(sourceMap) : new BasicSourceMapConsumer$1(sourceMap);
  }

  SourceMapConsumer$3.fromSourceMap = function (aSourceMap) {
    return BasicSourceMapConsumer$1.fromSourceMap(aSourceMap);
  };

  SourceMapConsumer$3.prototype._version = 3;
  SourceMapConsumer$3.prototype.__generatedMappings = null;
  Object.defineProperty(SourceMapConsumer$3.prototype, '_generatedMappings', {
    get: function get() {
      if (!this.__generatedMappings) {
        this._parseMappings(this._mappings, this.sourceRoot);
      }

      return this.__generatedMappings;
    }
  });
  SourceMapConsumer$3.prototype.__originalMappings = null;
  Object.defineProperty(SourceMapConsumer$3.prototype, '_originalMappings', {
    get: function get() {
      if (!this.__originalMappings) {
        this._parseMappings(this._mappings, this.sourceRoot);
      }

      return this.__originalMappings;
    }
  });

  SourceMapConsumer$3.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
    var c = aStr.charAt(index);
    return c === ";" || c === ",";
  };

  SourceMapConsumer$3.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
    throw new Error("Subclasses must implement _parseMappings");
  };

  SourceMapConsumer$3.GENERATED_ORDER = 1;
  SourceMapConsumer$3.ORIGINAL_ORDER = 2;
  SourceMapConsumer$3.GREATEST_LOWER_BOUND = 1;
  SourceMapConsumer$3.LEAST_UPPER_BOUND = 2;

  SourceMapConsumer$3.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
    var context = aContext || null;
    var order = aOrder || SourceMapConsumer$3.GENERATED_ORDER;
    var mappings;

    switch (order) {
      case SourceMapConsumer$3.GENERATED_ORDER:
        mappings = this._generatedMappings;
        break;

      case SourceMapConsumer$3.ORIGINAL_ORDER:
        mappings = this._originalMappings;
        break;

      default:
        throw new Error("Unknown order of iteration.");
    }

    var sourceRoot = this.sourceRoot;
    mappings.map(function (mapping) {
      var source = mapping.source === null ? null : this._sources.at(mapping.source);

      if (source != null && sourceRoot != null) {
        source = util$6.join(sourceRoot, source);
      }

      return {
        source: source,
        generatedLine: mapping.generatedLine,
        generatedColumn: mapping.generatedColumn,
        originalLine: mapping.originalLine,
        originalColumn: mapping.originalColumn,
        name: mapping.name === null ? null : this._names.at(mapping.name)
      };
    }, this).forEach(aCallback, context);
  };

  SourceMapConsumer$3.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
    var line = util$6.getArg(aArgs, 'line');
    var needle = {
      source: util$6.getArg(aArgs, 'source'),
      originalLine: line,
      originalColumn: util$6.getArg(aArgs, 'column', 0)
    };

    if (this.sourceRoot != null) {
      needle.source = util$6.relative(this.sourceRoot, needle.source);
    }

    if (!this._sources.has(needle.source)) {
      return [];
    }

    needle.source = this._sources.indexOf(needle.source);
    var mappings = [];

    var index = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util$6.compareByOriginalPositions, binarySearch$1.LEAST_UPPER_BOUND);

    if (index >= 0) {
      var mapping = this._originalMappings[index];

      if (aArgs.column === undefined) {
        var originalLine = mapping.originalLine;

        while (mapping && mapping.originalLine === originalLine) {
          mappings.push({
            line: util$6.getArg(mapping, 'generatedLine', null),
            column: util$6.getArg(mapping, 'generatedColumn', null),
            lastColumn: util$6.getArg(mapping, 'lastGeneratedColumn', null)
          });
          mapping = this._originalMappings[++index];
        }
      } else {
        var originalColumn = mapping.originalColumn;

        while (mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn) {
          mappings.push({
            line: util$6.getArg(mapping, 'generatedLine', null),
            column: util$6.getArg(mapping, 'generatedColumn', null),
            lastColumn: util$6.getArg(mapping, 'lastGeneratedColumn', null)
          });
          mapping = this._originalMappings[++index];
        }
      }
    }

    return mappings;
  };

  var SourceMapConsumer_1$1 = SourceMapConsumer$3;

  function BasicSourceMapConsumer$1(aSourceMap) {
    var sourceMap = aSourceMap;

    if (typeof aSourceMap === 'string') {
      sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
    }

    var version = util$6.getArg(sourceMap, 'version');
    var sources = util$6.getArg(sourceMap, 'sources');
    var names = util$6.getArg(sourceMap, 'names', []);
    var sourceRoot = util$6.getArg(sourceMap, 'sourceRoot', null);
    var sourcesContent = util$6.getArg(sourceMap, 'sourcesContent', null);
    var mappings = util$6.getArg(sourceMap, 'mappings');
    var file = util$6.getArg(sourceMap, 'file', null);

    if (version != this._version) {
      throw new Error('Unsupported version: ' + version);
    }

    sources = sources.map(String).map(util$6.normalize).map(function (source) {
      return sourceRoot && util$6.isAbsolute(sourceRoot) && util$6.isAbsolute(source) ? util$6.relative(sourceRoot, source) : source;
    });
    this._names = ArraySet$3.fromArray(names.map(String), true);
    this._sources = ArraySet$3.fromArray(sources, true);
    this.sourceRoot = sourceRoot;
    this.sourcesContent = sourcesContent;
    this._mappings = mappings;
    this.file = file;
  }

  BasicSourceMapConsumer$1.prototype = Object.create(SourceMapConsumer$3.prototype);
  BasicSourceMapConsumer$1.prototype.consumer = SourceMapConsumer$3;

  BasicSourceMapConsumer$1.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap) {
    var smc = Object.create(BasicSourceMapConsumer$1.prototype);
    var names = smc._names = ArraySet$3.fromArray(aSourceMap._names.toArray(), true);
    var sources = smc._sources = ArraySet$3.fromArray(aSourceMap._sources.toArray(), true);
    smc.sourceRoot = aSourceMap._sourceRoot;
    smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(), smc.sourceRoot);
    smc.file = aSourceMap._file;

    var generatedMappings = aSourceMap._mappings.toArray().slice();

    var destGeneratedMappings = smc.__generatedMappings = [];
    var destOriginalMappings = smc.__originalMappings = [];

    for (var i = 0, length = generatedMappings.length; i < length; i++) {
      var srcMapping = generatedMappings[i];
      var destMapping = new Mapping$1();
      destMapping.generatedLine = srcMapping.generatedLine;
      destMapping.generatedColumn = srcMapping.generatedColumn;

      if (srcMapping.source) {
        destMapping.source = sources.indexOf(srcMapping.source);
        destMapping.originalLine = srcMapping.originalLine;
        destMapping.originalColumn = srcMapping.originalColumn;

        if (srcMapping.name) {
          destMapping.name = names.indexOf(srcMapping.name);
        }

        destOriginalMappings.push(destMapping);
      }

      destGeneratedMappings.push(destMapping);
    }

    quickSort$2(smc.__originalMappings, util$6.compareByOriginalPositions);
    return smc;
  };

  BasicSourceMapConsumer$1.prototype._version = 3;
  Object.defineProperty(BasicSourceMapConsumer$1.prototype, 'sources', {
    get: function get() {
      return this._sources.toArray().map(function (s) {
        return this.sourceRoot != null ? util$6.join(this.sourceRoot, s) : s;
      }, this);
    }
  });

  function Mapping$1() {
    this.generatedLine = 0;
    this.generatedColumn = 0;
    this.source = null;
    this.originalLine = null;
    this.originalColumn = null;
    this.name = null;
  }

  BasicSourceMapConsumer$1.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
    var generatedLine = 1;
    var previousGeneratedColumn = 0;
    var previousOriginalLine = 0;
    var previousOriginalColumn = 0;
    var previousSource = 0;
    var previousName = 0;
    var length = aStr.length;
    var index = 0;
    var cachedSegments = {};
    var temp = {};
    var originalMappings = [];
    var generatedMappings = [];
    var mapping, str, segment, end, value;

    while (index < length) {
      if (aStr.charAt(index) === ';') {
        generatedLine++;
        index++;
        previousGeneratedColumn = 0;
      } else if (aStr.charAt(index) === ',') {
        index++;
      } else {
        mapping = new Mapping$1();
        mapping.generatedLine = generatedLine;

        for (end = index; end < length; end++) {
          if (this._charIsMappingSeparator(aStr, end)) {
            break;
          }
        }

        str = aStr.slice(index, end);
        segment = cachedSegments[str];

        if (segment) {
          index += str.length;
        } else {
          segment = [];

          while (index < end) {
            base64Vlq$1.decode(aStr, index, temp);
            value = temp.value;
            index = temp.rest;
            segment.push(value);
          }

          if (segment.length === 2) {
            throw new Error('Found a source, but no line and column');
          }

          if (segment.length === 3) {
            throw new Error('Found a source and line, but no column');
          }

          cachedSegments[str] = segment;
        }

        mapping.generatedColumn = previousGeneratedColumn + segment[0];
        previousGeneratedColumn = mapping.generatedColumn;

        if (segment.length > 1) {
          mapping.source = previousSource + segment[1];
          previousSource += segment[1];
          mapping.originalLine = previousOriginalLine + segment[2];
          previousOriginalLine = mapping.originalLine;
          mapping.originalLine += 1;
          mapping.originalColumn = previousOriginalColumn + segment[3];
          previousOriginalColumn = mapping.originalColumn;

          if (segment.length > 4) {
            mapping.name = previousName + segment[4];
            previousName += segment[4];
          }
        }

        generatedMappings.push(mapping);

        if (typeof mapping.originalLine === 'number') {
          originalMappings.push(mapping);
        }
      }
    }

    quickSort$2(generatedMappings, util$6.compareByGeneratedPositionsDeflated);
    this.__generatedMappings = generatedMappings;
    quickSort$2(originalMappings, util$6.compareByOriginalPositions);
    this.__originalMappings = originalMappings;
  };

  BasicSourceMapConsumer$1.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
    if (aNeedle[aLineName] <= 0) {
      throw new TypeError('Line must be greater than or equal to 1, got ' + aNeedle[aLineName]);
    }

    if (aNeedle[aColumnName] < 0) {
      throw new TypeError('Column must be greater than or equal to 0, got ' + aNeedle[aColumnName]);
    }

    return binarySearch$1.search(aNeedle, aMappings, aComparator, aBias);
  };

  BasicSourceMapConsumer$1.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
    for (var index = 0; index < this._generatedMappings.length; ++index) {
      var mapping = this._generatedMappings[index];

      if (index + 1 < this._generatedMappings.length) {
        var nextMapping = this._generatedMappings[index + 1];

        if (mapping.generatedLine === nextMapping.generatedLine) {
          mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
          continue;
        }
      }

      mapping.lastGeneratedColumn = Infinity;
    }
  };

  BasicSourceMapConsumer$1.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
    var needle = {
      generatedLine: util$6.getArg(aArgs, 'line'),
      generatedColumn: util$6.getArg(aArgs, 'column')
    };

    var index = this._findMapping(needle, this._generatedMappings, "generatedLine", "generatedColumn", util$6.compareByGeneratedPositionsDeflated, util$6.getArg(aArgs, 'bias', SourceMapConsumer$3.GREATEST_LOWER_BOUND));

    if (index >= 0) {
      var mapping = this._generatedMappings[index];

      if (mapping.generatedLine === needle.generatedLine) {
        var source = util$6.getArg(mapping, 'source', null);

        if (source !== null) {
          source = this._sources.at(source);

          if (this.sourceRoot != null) {
            source = util$6.join(this.sourceRoot, source);
          }
        }

        var name = util$6.getArg(mapping, 'name', null);

        if (name !== null) {
          name = this._names.at(name);
        }

        return {
          source: source,
          line: util$6.getArg(mapping, 'originalLine', null),
          column: util$6.getArg(mapping, 'originalColumn', null),
          name: name
        };
      }
    }

    return {
      source: null,
      line: null,
      column: null,
      name: null
    };
  };

  BasicSourceMapConsumer$1.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
    if (!this.sourcesContent) {
      return false;
    }

    return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function (sc) {
      return sc == null;
    });
  };

  BasicSourceMapConsumer$1.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
    if (!this.sourcesContent) {
      return null;
    }

    if (this.sourceRoot != null) {
      aSource = util$6.relative(this.sourceRoot, aSource);
    }

    if (this._sources.has(aSource)) {
      return this.sourcesContent[this._sources.indexOf(aSource)];
    }

    var url;

    if (this.sourceRoot != null && (url = util$6.urlParse(this.sourceRoot))) {
      var fileUriAbsPath = aSource.replace(/^file:\/\//, "");

      if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
        return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
      }

      if ((!url.path || url.path == "/") && this._sources.has("/" + aSource)) {
        return this.sourcesContent[this._sources.indexOf("/" + aSource)];
      }
    }

    if (nullOnMissing) {
      return null;
    } else {
      throw new Error('"' + aSource + '" is not in the SourceMap.');
    }
  };

  BasicSourceMapConsumer$1.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
    var source = util$6.getArg(aArgs, 'source');

    if (this.sourceRoot != null) {
      source = util$6.relative(this.sourceRoot, source);
    }

    if (!this._sources.has(source)) {
      return {
        line: null,
        column: null,
        lastColumn: null
      };
    }

    source = this._sources.indexOf(source);
    var needle = {
      source: source,
      originalLine: util$6.getArg(aArgs, 'line'),
      originalColumn: util$6.getArg(aArgs, 'column')
    };

    var index = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util$6.compareByOriginalPositions, util$6.getArg(aArgs, 'bias', SourceMapConsumer$3.GREATEST_LOWER_BOUND));

    if (index >= 0) {
      var mapping = this._originalMappings[index];

      if (mapping.source === needle.source) {
        return {
          line: util$6.getArg(mapping, 'generatedLine', null),
          column: util$6.getArg(mapping, 'generatedColumn', null),
          lastColumn: util$6.getArg(mapping, 'lastGeneratedColumn', null)
        };
      }
    }

    return {
      line: null,
      column: null,
      lastColumn: null
    };
  };

  var BasicSourceMapConsumer_1$1 = BasicSourceMapConsumer$1;

  function IndexedSourceMapConsumer$1(aSourceMap) {
    var sourceMap = aSourceMap;

    if (typeof aSourceMap === 'string') {
      sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
    }

    var version = util$6.getArg(sourceMap, 'version');
    var sections = util$6.getArg(sourceMap, 'sections');

    if (version != this._version) {
      throw new Error('Unsupported version: ' + version);
    }

    this._sources = new ArraySet$3();
    this._names = new ArraySet$3();
    var lastOffset = {
      line: -1,
      column: 0
    };
    this._sections = sections.map(function (s) {
      if (s.url) {
        throw new Error('Support for url field in sections not implemented.');
      }

      var offset = util$6.getArg(s, 'offset');
      var offsetLine = util$6.getArg(offset, 'line');
      var offsetColumn = util$6.getArg(offset, 'column');

      if (offsetLine < lastOffset.line || offsetLine === lastOffset.line && offsetColumn < lastOffset.column) {
        throw new Error('Section offsets must be ordered and non-overlapping.');
      }

      lastOffset = offset;
      return {
        generatedOffset: {
          generatedLine: offsetLine + 1,
          generatedColumn: offsetColumn + 1
        },
        consumer: new SourceMapConsumer$3(util$6.getArg(s, 'map'))
      };
    });
  }

  IndexedSourceMapConsumer$1.prototype = Object.create(SourceMapConsumer$3.prototype);
  IndexedSourceMapConsumer$1.prototype.constructor = SourceMapConsumer$3;
  IndexedSourceMapConsumer$1.prototype._version = 3;
  Object.defineProperty(IndexedSourceMapConsumer$1.prototype, 'sources', {
    get: function get() {
      var sources = [];

      for (var i = 0; i < this._sections.length; i++) {
        for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
          sources.push(this._sections[i].consumer.sources[j]);
        }
      }

      return sources;
    }
  });

  IndexedSourceMapConsumer$1.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
    var needle = {
      generatedLine: util$6.getArg(aArgs, 'line'),
      generatedColumn: util$6.getArg(aArgs, 'column')
    };
    var sectionIndex = binarySearch$1.search(needle, this._sections, function (needle, section) {
      var cmp = needle.generatedLine - section.generatedOffset.generatedLine;

      if (cmp) {
        return cmp;
      }

      return needle.generatedColumn - section.generatedOffset.generatedColumn;
    });
    var section = this._sections[sectionIndex];

    if (!section) {
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    }

    return section.consumer.originalPositionFor({
      line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
      column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
      bias: aArgs.bias
    });
  };

  IndexedSourceMapConsumer$1.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
    return this._sections.every(function (s) {
      return s.consumer.hasContentsOfAllSources();
    });
  };

  IndexedSourceMapConsumer$1.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
    for (var i = 0; i < this._sections.length; i++) {
      var section = this._sections[i];
      var content = section.consumer.sourceContentFor(aSource, true);

      if (content) {
        return content;
      }
    }

    if (nullOnMissing) {
      return null;
    } else {
      throw new Error('"' + aSource + '" is not in the SourceMap.');
    }
  };

  IndexedSourceMapConsumer$1.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
    for (var i = 0; i < this._sections.length; i++) {
      var section = this._sections[i];

      if (section.consumer.sources.indexOf(util$6.getArg(aArgs, 'source')) === -1) {
        continue;
      }

      var generatedPosition = section.consumer.generatedPositionFor(aArgs);

      if (generatedPosition) {
        var ret = {
          line: generatedPosition.line + (section.generatedOffset.generatedLine - 1),
          column: generatedPosition.column + (section.generatedOffset.generatedLine === generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0)
        };
        return ret;
      }
    }

    return {
      line: null,
      column: null
    };
  };

  IndexedSourceMapConsumer$1.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
    this.__generatedMappings = [];
    this.__originalMappings = [];

    for (var i = 0; i < this._sections.length; i++) {
      var section = this._sections[i];
      var sectionMappings = section.consumer._generatedMappings;

      for (var j = 0; j < sectionMappings.length; j++) {
        var mapping = sectionMappings[j];

        var source = section.consumer._sources.at(mapping.source);

        if (section.consumer.sourceRoot !== null) {
          source = util$6.join(section.consumer.sourceRoot, source);
        }

        this._sources.add(source);

        source = this._sources.indexOf(source);

        var name = section.consumer._names.at(mapping.name);

        this._names.add(name);

        name = this._names.indexOf(name);
        var adjustedMapping = {
          source: source,
          generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
          generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: name
        };

        this.__generatedMappings.push(adjustedMapping);

        if (typeof adjustedMapping.originalLine === 'number') {
          this.__originalMappings.push(adjustedMapping);
        }
      }
    }

    quickSort$2(this.__generatedMappings, util$6.compareByGeneratedPositionsDeflated);
    quickSort$2(this.__originalMappings, util$6.compareByOriginalPositions);
  };

  var IndexedSourceMapConsumer_1$1 = IndexedSourceMapConsumer$1;
  var sourceMapConsumer$1 = {
    SourceMapConsumer: SourceMapConsumer_1$1,
    BasicSourceMapConsumer: BasicSourceMapConsumer_1$1,
    IndexedSourceMapConsumer: IndexedSourceMapConsumer_1$1
  };

  var SourceMapGenerator$4 = sourceMapGenerator$1.SourceMapGenerator;
  var REGEX_NEWLINE$1 = /(\r?\n)/;
  var NEWLINE_CODE$1 = 10;
  var isSourceNode$1 = "$$$isSourceNode$$$";

  function SourceNode$3(aLine, aColumn, aSource, aChunks, aName) {
    this.children = [];
    this.sourceContents = {};
    this.line = aLine == null ? null : aLine;
    this.column = aColumn == null ? null : aColumn;
    this.source = aSource == null ? null : aSource;
    this.name = aName == null ? null : aName;
    this[isSourceNode$1] = true;
    if (aChunks != null) this.add(aChunks);
  }

  SourceNode$3.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
    var node = new SourceNode$3();
    var remainingLines = aGeneratedCode.split(REGEX_NEWLINE$1);
    var remainingLinesIndex = 0;

    var shiftNextLine = function shiftNextLine() {
      var lineContents = getNextLine();
      var newLine = getNextLine() || "";
      return lineContents + newLine;

      function getNextLine() {
        return remainingLinesIndex < remainingLines.length ? remainingLines[remainingLinesIndex++] : undefined;
      }
    };

    var lastGeneratedLine = 1,
        lastGeneratedColumn = 0;
    var lastMapping = null;
    aSourceMapConsumer.eachMapping(function (mapping) {
      if (lastMapping !== null) {
        if (lastGeneratedLine < mapping.generatedLine) {
          addMappingWithCode(lastMapping, shiftNextLine());
          lastGeneratedLine++;
          lastGeneratedColumn = 0;
        } else {
          var nextLine = remainingLines[remainingLinesIndex];
          var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
          addMappingWithCode(lastMapping, code);
          lastMapping = mapping;
          return;
        }
      }

      while (lastGeneratedLine < mapping.generatedLine) {
        node.add(shiftNextLine());
        lastGeneratedLine++;
      }

      if (lastGeneratedColumn < mapping.generatedColumn) {
        var nextLine = remainingLines[remainingLinesIndex];
        node.add(nextLine.substr(0, mapping.generatedColumn));
        remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
        lastGeneratedColumn = mapping.generatedColumn;
      }

      lastMapping = mapping;
    }, this);

    if (remainingLinesIndex < remainingLines.length) {
      if (lastMapping) {
        addMappingWithCode(lastMapping, shiftNextLine());
      }

      node.add(remainingLines.splice(remainingLinesIndex).join(""));
    }

    aSourceMapConsumer.sources.forEach(function (sourceFile) {
      var content = aSourceMapConsumer.sourceContentFor(sourceFile);

      if (content != null) {
        if (aRelativePath != null) {
          sourceFile = util$6.join(aRelativePath, sourceFile);
        }

        node.setSourceContent(sourceFile, content);
      }
    });
    return node;

    function addMappingWithCode(mapping, code) {
      if (mapping === null || mapping.source === undefined) {
        node.add(code);
      } else {
        var source = aRelativePath ? util$6.join(aRelativePath, mapping.source) : mapping.source;
        node.add(new SourceNode$3(mapping.originalLine, mapping.originalColumn, source, code, mapping.name));
      }
    }
  };

  SourceNode$3.prototype.add = function SourceNode_add(aChunk) {
    if (Array.isArray(aChunk)) {
      aChunk.forEach(function (chunk) {
        this.add(chunk);
      }, this);
    } else if (aChunk[isSourceNode$1] || typeof aChunk === "string") {
      if (aChunk) {
        this.children.push(aChunk);
      }
    } else {
      throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
    }

    return this;
  };

  SourceNode$3.prototype.prepend = function SourceNode_prepend(aChunk) {
    if (Array.isArray(aChunk)) {
      for (var i = aChunk.length - 1; i >= 0; i--) {
        this.prepend(aChunk[i]);
      }
    } else if (aChunk[isSourceNode$1] || typeof aChunk === "string") {
      this.children.unshift(aChunk);
    } else {
      throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
    }

    return this;
  };

  SourceNode$3.prototype.walk = function SourceNode_walk(aFn) {
    var chunk;

    for (var i = 0, len = this.children.length; i < len; i++) {
      chunk = this.children[i];

      if (chunk[isSourceNode$1]) {
        chunk.walk(aFn);
      } else {
        if (chunk !== '') {
          aFn(chunk, {
            source: this.source,
            line: this.line,
            column: this.column,
            name: this.name
          });
        }
      }
    }
  };

  SourceNode$3.prototype.join = function SourceNode_join(aSep) {
    var newChildren;
    var i;
    var len = this.children.length;

    if (len > 0) {
      newChildren = [];

      for (i = 0; i < len - 1; i++) {
        newChildren.push(this.children[i]);
        newChildren.push(aSep);
      }

      newChildren.push(this.children[i]);
      this.children = newChildren;
    }

    return this;
  };

  SourceNode$3.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
    var lastChild = this.children[this.children.length - 1];

    if (lastChild[isSourceNode$1]) {
      lastChild.replaceRight(aPattern, aReplacement);
    } else if (typeof lastChild === 'string') {
      this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
    } else {
      this.children.push(''.replace(aPattern, aReplacement));
    }

    return this;
  };

  SourceNode$3.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
    this.sourceContents[util$6.toSetString(aSourceFile)] = aSourceContent;
  };

  SourceNode$3.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
    for (var i = 0, len = this.children.length; i < len; i++) {
      if (this.children[i][isSourceNode$1]) {
        this.children[i].walkSourceContents(aFn);
      }
    }

    var sources = Object.keys(this.sourceContents);

    for (var i = 0, len = sources.length; i < len; i++) {
      aFn(util$6.fromSetString(sources[i]), this.sourceContents[sources[i]]);
    }
  };

  SourceNode$3.prototype.toString = function SourceNode_toString() {
    var str = "";
    this.walk(function (chunk) {
      str += chunk;
    });
    return str;
  };

  SourceNode$3.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
    var generated = {
      code: "",
      line: 1,
      column: 0
    };
    var map = new SourceMapGenerator$4(aArgs);
    var sourceMappingActive = false;
    var lastOriginalSource = null;
    var lastOriginalLine = null;
    var lastOriginalColumn = null;
    var lastOriginalName = null;
    this.walk(function (chunk, original) {
      generated.code += chunk;

      if (original.source !== null && original.line !== null && original.column !== null) {
        if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
          map.addMapping({
            source: original.source,
            original: {
              line: original.line,
              column: original.column
            },
            generated: {
              line: generated.line,
              column: generated.column
            },
            name: original.name
          });
        }

        lastOriginalSource = original.source;
        lastOriginalLine = original.line;
        lastOriginalColumn = original.column;
        lastOriginalName = original.name;
        sourceMappingActive = true;
      } else if (sourceMappingActive) {
        map.addMapping({
          generated: {
            line: generated.line,
            column: generated.column
          }
        });
        lastOriginalSource = null;
        sourceMappingActive = false;
      }

      for (var idx = 0, length = chunk.length; idx < length; idx++) {
        if (chunk.charCodeAt(idx) === NEWLINE_CODE$1) {
          generated.line++;
          generated.column = 0;

          if (idx + 1 === length) {
            lastOriginalSource = null;
            sourceMappingActive = false;
          } else if (sourceMappingActive) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
        } else {
          generated.column++;
        }
      }
    });
    this.walkSourceContents(function (sourceFile, sourceContent) {
      map.setSourceContent(sourceFile, sourceContent);
    });
    return {
      code: generated.code,
      map: map
    };
  };

  var SourceNode_1$1 = SourceNode$3;
  var sourceNode$1 = {
    SourceNode: SourceNode_1$1
  };

  var SourceMapGenerator$3 = sourceMapGenerator$1.SourceMapGenerator;
  var SourceMapConsumer$2 = sourceMapConsumer$1.SourceMapConsumer;
  var SourceNode$2 = sourceNode$1.SourceNode;
  var sourceMap$1 = {
    SourceMapGenerator: SourceMapGenerator$3,
    SourceMapConsumer: SourceMapConsumer$2,
    SourceNode: SourceNode$2
  };

  var SourceMap = function () {
    function SourceMap(opts, code) {
      this._cachedMap = void 0;
      this._code = void 0;
      this._opts = void 0;
      this._rawMappings = void 0;
      this._lastGenLine = void 0;
      this._lastSourceLine = void 0;
      this._lastSourceColumn = void 0;
      this._cachedMap = null;
      this._code = code;
      this._opts = opts;
      this._rawMappings = [];
    }

    var _proto = SourceMap.prototype;

    _proto.get = function get() {
      if (!this._cachedMap) {
        var map = this._cachedMap = new sourceMap$1.SourceMapGenerator({
          sourceRoot: this._opts.sourceRoot
        });
        var code = this._code;

        if (typeof code === "string") {
          map.setSourceContent(this._opts.sourceFileName.replace(/\\/g, "/"), code);
        } else if (typeof code === "object") {
          Object.keys(code).forEach(function (sourceFileName) {
            map.setSourceContent(sourceFileName.replace(/\\/g, "/"), code[sourceFileName]);
          });
        }

        this._rawMappings.forEach(function (mapping) {
          return map.addMapping(mapping);
        }, map);
      }

      return this._cachedMap.toJSON();
    };

    _proto.getRawMappings = function getRawMappings() {
      return this._rawMappings.slice();
    };

    _proto.mark = function mark(generatedLine, generatedColumn, line, column, identifierName, filename, force) {
      if (this._lastGenLine !== generatedLine && line === null) return;

      if (!force && this._lastGenLine === generatedLine && this._lastSourceLine === line && this._lastSourceColumn === column) {
        return;
      }

      this._cachedMap = null;
      this._lastGenLine = generatedLine;
      this._lastSourceLine = line;
      this._lastSourceColumn = column;

      this._rawMappings.push({
        name: identifierName || undefined,
        generated: {
          line: generatedLine,
          column: generatedColumn
        },
        source: line == null ? undefined : (filename || this._opts.sourceFileName).replace(/\\/g, "/"),
        original: line == null ? undefined : {
          line: line,
          column: column
        }
      });
    };

    return SourceMap;
  }();

  var SPACES_RE = /^[ \t]+$/;

  var Buffer = function () {
    function Buffer(map) {
      this._map = null;
      this._buf = "";
      this._last = 0;
      this._queue = [];
      this._position = {
        line: 1,
        column: 0
      };
      this._sourcePosition = {
        identifierName: null,
        line: null,
        column: null,
        filename: null
      };
      this._disallowedPop = null;
      this._map = map;
    }

    var _proto = Buffer.prototype;

    _proto.get = function get() {
      this._flush();

      var map = this._map;
      var result = {
        code: this._buf.trimRight(),
        map: null,
        rawMappings: map == null ? void 0 : map.getRawMappings()
      };

      if (map) {
        Object.defineProperty(result, "map", {
          configurable: true,
          enumerable: true,
          get: function get() {
            return this.map = map.get();
          },
          set: function set(value) {
            Object.defineProperty(this, "map", {
              value: value,
              writable: true
            });
          }
        });
      }

      return result;
    };

    _proto.append = function append(str) {
      this._flush();

      var _this$_sourcePosition = this._sourcePosition,
          line = _this$_sourcePosition.line,
          column = _this$_sourcePosition.column,
          filename = _this$_sourcePosition.filename,
          identifierName = _this$_sourcePosition.identifierName,
          force = _this$_sourcePosition.force;

      this._append(str, line, column, identifierName, filename, force);
    };

    _proto.queue = function queue(str) {
      if (str === "\n") {
        while (this._queue.length > 0 && SPACES_RE.test(this._queue[0][0])) {
          this._queue.shift();
        }
      }

      var _this$_sourcePosition2 = this._sourcePosition,
          line = _this$_sourcePosition2.line,
          column = _this$_sourcePosition2.column,
          filename = _this$_sourcePosition2.filename,
          identifierName = _this$_sourcePosition2.identifierName,
          force = _this$_sourcePosition2.force;

      this._queue.unshift([str, line, column, identifierName, filename, force]);
    };

    _proto._flush = function _flush() {
      var item;

      while (item = this._queue.pop()) {
        this._append.apply(this, _toConsumableArray(item));
      }
    };

    _proto._append = function _append(str, line, column, identifierName, filename, force) {
      this._buf += str;
      this._last = str.charCodeAt(str.length - 1);
      var i = str.indexOf("\n");
      var last = 0;

      if (i !== 0) {
        this._mark(line, column, identifierName, filename, force);
      }

      while (i !== -1) {
        this._position.line++;
        this._position.column = 0;
        last = i + 1;

        if (last < str.length) {
          this._mark(++line, 0, identifierName, filename, force);
        }

        i = str.indexOf("\n", last);
      }

      this._position.column += str.length - last;
    };

    _proto._mark = function _mark(line, column, identifierName, filename, force) {
      var _this$_map;

      (_this$_map = this._map) == null ? void 0 : _this$_map.mark(this._position.line, this._position.column, line, column, identifierName, filename, force);
    };

    _proto.removeTrailingNewline = function removeTrailingNewline() {
      if (this._queue.length > 0 && this._queue[0][0] === "\n") {
        this._queue.shift();
      }
    };

    _proto.removeLastSemicolon = function removeLastSemicolon() {
      if (this._queue.length > 0 && this._queue[0][0] === ";") {
        this._queue.shift();
      }
    };

    _proto.getLastChar = function getLastChar() {
      var last;

      if (this._queue.length > 0) {
        var _str = this._queue[0][0];
        last = _str.charCodeAt(0);
      } else {
        last = this._last;
      }

      return last;
    };

    _proto.endsWithCharAndNewline = function endsWithCharAndNewline() {
      var queue = this._queue;

      if (queue.length > 0) {
        var last = queue[0][0];
        var lastCp = last.charCodeAt(0);
        if (lastCp !== 10) return;

        if (queue.length > 1) {
          var secondLast = queue[1][0];
          return secondLast.charCodeAt(0);
        } else {
          return this._last;
        }
      }
    };

    _proto.hasContent = function hasContent() {
      return this._queue.length > 0 || !!this._last;
    };

    _proto.exactSource = function exactSource(loc, cb) {
      this.source("start", loc, true);
      cb();
      this.source("end", loc);

      this._disallowPop("start", loc);
    };

    _proto.source = function source(prop, loc, force) {
      if (prop && !loc) return;

      this._normalizePosition(prop, loc, this._sourcePosition, force);
    };

    _proto.withSource = function withSource(prop, loc, cb) {
      if (!this._map) return cb();
      var originalLine = this._sourcePosition.line;
      var originalColumn = this._sourcePosition.column;
      var originalFilename = this._sourcePosition.filename;
      var originalIdentifierName = this._sourcePosition.identifierName;
      this.source(prop, loc);
      cb();

      if ((!this._sourcePosition.force || this._sourcePosition.line !== originalLine || this._sourcePosition.column !== originalColumn || this._sourcePosition.filename !== originalFilename) && (!this._disallowedPop || this._disallowedPop.line !== originalLine || this._disallowedPop.column !== originalColumn || this._disallowedPop.filename !== originalFilename)) {
        this._sourcePosition.line = originalLine;
        this._sourcePosition.column = originalColumn;
        this._sourcePosition.filename = originalFilename;
        this._sourcePosition.identifierName = originalIdentifierName;
        this._sourcePosition.force = false;
        this._disallowedPop = null;
      }
    };

    _proto._disallowPop = function _disallowPop(prop, loc) {
      if (prop && !loc) return;
      this._disallowedPop = this._normalizePosition(prop, loc);
    };

    _proto._normalizePosition = function _normalizePosition(prop, loc, targetObj, force) {
      var pos = loc ? loc[prop] : null;

      if (targetObj === undefined) {
        targetObj = {
          identifierName: null,
          line: null,
          column: null,
          filename: null,
          force: false
        };
      }

      var origLine = targetObj.line;
      var origColumn = targetObj.column;
      var origFilename = targetObj.filename;
      targetObj.identifierName = prop === "start" && (loc == null ? void 0 : loc.identifierName) || null;
      targetObj.line = pos == null ? void 0 : pos.line;
      targetObj.column = pos == null ? void 0 : pos.column;
      targetObj.filename = loc == null ? void 0 : loc.filename;

      if (force || targetObj.line !== origLine || targetObj.column !== origColumn || targetObj.filename !== origFilename) {
        targetObj.force = force;
      }

      return targetObj;
    };

    _proto.getCurrentColumn = function getCurrentColumn() {
      var extra = this._queue.reduce(function (acc, item) {
        return item[0] + acc;
      }, "");

      var lastIndex = extra.lastIndexOf("\n");
      return lastIndex === -1 ? this._position.column + extra.length : extra.length - 1 - lastIndex;
    };

    _proto.getCurrentLine = function getCurrentLine() {
      var extra = this._queue.reduce(function (acc, item) {
        return item[0] + acc;
      }, "");

      var count = 0;

      for (var i = 0; i < extra.length; i++) {
        if (extra[i] === "\n") count++;
      }

      return this._position.line + count;
    };

    return Buffer;
  }();

  var FLIPPED_ALIAS_KEYS$2 = FLIPPED_ALIAS_KEYS$3,
      isArrayExpression = isArrayExpression$2,
      isAssignmentExpression$2 = isAssignmentExpression$3,
      isBinary$1 = isBinary$3,
      isBlockStatement$1 = isBlockStatement$2,
      isCallExpression$5 = isCallExpression$6,
      isFunction$3 = isFunction$4,
      isIdentifier$d = isIdentifier$g,
      isLiteral$5 = isLiteral$7,
      isMemberExpression$6 = isMemberExpression$8,
      isObjectExpression$1 = isObjectExpression$3,
      isOptionalCallExpression$2 = isOptionalCallExpression$3,
      isOptionalMemberExpression$2 = isOptionalMemberExpression$3,
      isStringLiteral$6 = isStringLiteral$7;

  function crawl(node, state) {
    if (state === void 0) {
      state = {};
    }

    if (isMemberExpression$6(node) || isOptionalMemberExpression$2(node)) {
      crawl(node.object, state);
      if (node.computed) crawl(node.property, state);
    } else if (isBinary$1(node) || isAssignmentExpression$2(node)) {
      crawl(node.left, state);
      crawl(node.right, state);
    } else if (isCallExpression$5(node) || isOptionalCallExpression$2(node)) {
      state.hasCall = true;
      crawl(node.callee, state);
    } else if (isFunction$3(node)) {
      state.hasFunction = true;
    } else if (isIdentifier$d(node)) {
      state.hasHelper = state.hasHelper || isHelper(node.callee);
    }

    return state;
  }

  function isHelper(node) {
    if (isMemberExpression$6(node)) {
      return isHelper(node.object) || isHelper(node.property);
    } else if (isIdentifier$d(node)) {
      return node.name === "require" || node.name[0] === "_";
    } else if (isCallExpression$5(node)) {
      return isHelper(node.callee);
    } else if (isBinary$1(node) || isAssignmentExpression$2(node)) {
      return isIdentifier$d(node.left) && isHelper(node.left) || isHelper(node.right);
    } else {
      return false;
    }
  }

  function isType$1(node) {
    return isLiteral$5(node) || isObjectExpression$1(node) || isArrayExpression(node) || isIdentifier$d(node) || isMemberExpression$6(node);
  }

  var nodes = {
    AssignmentExpression: function (_AssignmentExpression) {
      function AssignmentExpression(_x) {
        return _AssignmentExpression.apply(this, arguments);
      }

      AssignmentExpression.toString = function () {
        return _AssignmentExpression.toString();
      };

      return AssignmentExpression;
    }(function (node) {
      var state = crawl(node.right);

      if (state.hasCall && state.hasHelper || state.hasFunction) {
        return {
          before: state.hasFunction,
          after: true
        };
      }
    }),
    SwitchCase: function (_SwitchCase) {
      function SwitchCase(_x2, _x3) {
        return _SwitchCase.apply(this, arguments);
      }

      SwitchCase.toString = function () {
        return _SwitchCase.toString();
      };

      return SwitchCase;
    }(function (node, parent) {
      return {
        before: !!node.consequent.length || parent.cases[0] === node,
        after: !node.consequent.length && parent.cases[parent.cases.length - 1] === node
      };
    }),
    LogicalExpression: function (_LogicalExpression) {
      function LogicalExpression(_x4) {
        return _LogicalExpression.apply(this, arguments);
      }

      LogicalExpression.toString = function () {
        return _LogicalExpression.toString();
      };

      return LogicalExpression;
    }(function (node) {
      if (isFunction$3(node.left) || isFunction$3(node.right)) {
        return {
          after: true
        };
      }
    }),
    Literal: function (_Literal) {
      function Literal(_x5) {
        return _Literal.apply(this, arguments);
      }

      Literal.toString = function () {
        return _Literal.toString();
      };

      return Literal;
    }(function (node) {
      if (isStringLiteral$6(node) && node.value === "use strict") {
        return {
          after: true
        };
      }
    }),
    CallExpression: function (_CallExpression) {
      function CallExpression(_x6) {
        return _CallExpression.apply(this, arguments);
      }

      CallExpression.toString = function () {
        return _CallExpression.toString();
      };

      return CallExpression;
    }(function (node) {
      if (isFunction$3(node.callee) || isHelper(node)) {
        return {
          before: true,
          after: true
        };
      }
    }),
    OptionalCallExpression: function (_OptionalCallExpression) {
      function OptionalCallExpression(_x7) {
        return _OptionalCallExpression.apply(this, arguments);
      }

      OptionalCallExpression.toString = function () {
        return _OptionalCallExpression.toString();
      };

      return OptionalCallExpression;
    }(function (node) {
      if (isFunction$3(node.callee)) {
        return {
          before: true,
          after: true
        };
      }
    }),
    VariableDeclaration: function (_VariableDeclaration) {
      function VariableDeclaration(_x8) {
        return _VariableDeclaration.apply(this, arguments);
      }

      VariableDeclaration.toString = function () {
        return _VariableDeclaration.toString();
      };

      return VariableDeclaration;
    }(function (node) {
      for (var i = 0; i < node.declarations.length; i++) {
        var declar = node.declarations[i];
        var enabled = isHelper(declar.id) && !isType$1(declar.init);

        if (!enabled) {
          var state = crawl(declar.init);
          enabled = isHelper(declar.init) && state.hasCall || state.hasFunction;
        }

        if (enabled) {
          return {
            before: true,
            after: true
          };
        }
      }
    }),
    IfStatement: function (_IfStatement) {
      function IfStatement(_x9) {
        return _IfStatement.apply(this, arguments);
      }

      IfStatement.toString = function () {
        return _IfStatement.toString();
      };

      return IfStatement;
    }(function (node) {
      if (isBlockStatement$1(node.consequent)) {
        return {
          before: true,
          after: true
        };
      }
    })
  };

  nodes.ObjectProperty = nodes.ObjectTypeProperty = nodes.ObjectMethod = function (node, parent) {
    if (parent.properties[0] === node) {
      return {
        before: true
      };
    }
  };

  nodes.ObjectTypeCallProperty = function (node, parent) {
    var _parent$properties;

    if (parent.callProperties[0] === node && !((_parent$properties = parent.properties) != null && _parent$properties.length)) {
      return {
        before: true
      };
    }
  };

  nodes.ObjectTypeIndexer = function (node, parent) {
    var _parent$properties2, _parent$callPropertie;

    if (parent.indexers[0] === node && !((_parent$properties2 = parent.properties) != null && _parent$properties2.length) && !((_parent$callPropertie = parent.callProperties) != null && _parent$callPropertie.length)) {
      return {
        before: true
      };
    }
  };

  nodes.ObjectTypeInternalSlot = function (node, parent) {
    var _parent$properties3, _parent$callPropertie2, _parent$indexers;

    if (parent.internalSlots[0] === node && !((_parent$properties3 = parent.properties) != null && _parent$properties3.length) && !((_parent$callPropertie2 = parent.callProperties) != null && _parent$callPropertie2.length) && !((_parent$indexers = parent.indexers) != null && _parent$indexers.length)) {
      return {
        before: true
      };
    }
  };

  var list$1 = {
    VariableDeclaration: function (_VariableDeclaration2) {
      function VariableDeclaration(_x10) {
        return _VariableDeclaration2.apply(this, arguments);
      }

      VariableDeclaration.toString = function () {
        return _VariableDeclaration2.toString();
      };

      return VariableDeclaration;
    }(function (node) {
      return node.declarations.map(function (decl) {
        return decl.init;
      });
    }),
    ArrayExpression: function (_ArrayExpression) {
      function ArrayExpression(_x11) {
        return _ArrayExpression.apply(this, arguments);
      }

      ArrayExpression.toString = function () {
        return _ArrayExpression.toString();
      };

      return ArrayExpression;
    }(function (node) {
      return node.elements;
    }),
    ObjectExpression: function (_ObjectExpression) {
      function ObjectExpression(_x12) {
        return _ObjectExpression.apply(this, arguments);
      }

      ObjectExpression.toString = function () {
        return _ObjectExpression.toString();
      };

      return ObjectExpression;
    }(function (node) {
      return node.properties;
    })
  };
  [["Function", true], ["Class", true], ["Loop", true], ["LabeledStatement", true], ["SwitchStatement", true], ["TryStatement", true]].forEach(function (_ref) {
    var _ref2 = _slicedToArray$2(_ref, 2),
        type = _ref2[0],
        amounts = _ref2[1];

    if (typeof amounts === "boolean") {
      amounts = {
        after: amounts,
        before: amounts
      };
    }

    [type].concat(FLIPPED_ALIAS_KEYS$2[type] || []).forEach(function (type) {
      nodes[type] = function () {
        return amounts;
      };
    });
  });

  var isArrayTypeAnnotation = isArrayTypeAnnotation$1,
      isArrowFunctionExpression = isArrowFunctionExpression$1,
      isAssignmentExpression$1 = isAssignmentExpression$3,
      isAwaitExpression = isAwaitExpression$1,
      isBinary = isBinary$3,
      isBinaryExpression = isBinaryExpression$1,
      isCallExpression$4 = isCallExpression$6,
      isClassDeclaration$1 = isClassDeclaration$3,
      isClassExpression = isClassExpression$1,
      isConditional = isConditional$1,
      isConditionalExpression = isConditionalExpression$1,
      isExportDeclaration = isExportDeclaration$2,
      isExportDefaultDeclaration$1 = isExportDefaultDeclaration$3,
      isExpressionStatement$3 = isExpressionStatement$4,
      isFor$1 = isFor$2,
      isForInStatement = isForInStatement$1,
      isForOfStatement = isForOfStatement$1,
      isForStatement$1 = isForStatement$3,
      isIfStatement$1 = isIfStatement$2,
      isIndexedAccessType = isIndexedAccessType$1,
      isIntersectionTypeAnnotation = isIntersectionTypeAnnotation$1,
      isLogicalExpression = isLogicalExpression$1,
      isMemberExpression$5 = isMemberExpression$8,
      isNewExpression$3 = isNewExpression$4,
      isNullableTypeAnnotation = isNullableTypeAnnotation$1,
      isObjectPattern = isObjectPattern$1,
      isOptionalCallExpression$1 = isOptionalCallExpression$3,
      isOptionalMemberExpression$1 = isOptionalMemberExpression$3,
      isReturnStatement = isReturnStatement$1,
      isSequenceExpression = isSequenceExpression$1,
      isSwitchStatement = isSwitchStatement$1,
      isTSArrayType = isTSArrayType$1,
      isTSAsExpression$1 = isTSAsExpression$2,
      isTSIntersectionType = isTSIntersectionType$1,
      isTSNonNullExpression$1 = isTSNonNullExpression$2,
      isTSOptionalType = isTSOptionalType$1,
      isTSRestType = isTSRestType$1,
      isTSTypeAssertion$1 = isTSTypeAssertion$2,
      isTSUnionType = isTSUnionType$1,
      isTaggedTemplateExpression = isTaggedTemplateExpression$2,
      isThrowStatement = isThrowStatement$1,
      isTypeAnnotation$1 = isTypeAnnotation$2,
      isUnaryLike = isUnaryLike$1,
      isUnionTypeAnnotation$1 = isUnionTypeAnnotation$2,
      isVariableDeclarator$1 = isVariableDeclarator$2,
      isWhileStatement = isWhileStatement$1,
      isYieldExpression = isYieldExpression$1;
  var PRECEDENCE = {
    "||": 0,
    "??": 0,
    "&&": 1,
    "|": 2,
    "^": 3,
    "&": 4,
    "==": 5,
    "===": 5,
    "!=": 5,
    "!==": 5,
    "<": 6,
    ">": 6,
    "<=": 6,
    ">=": 6,
    "in": 6,
    "instanceof": 6,
    ">>": 7,
    "<<": 7,
    ">>>": 7,
    "+": 8,
    "-": 8,
    "*": 9,
    "/": 9,
    "%": 9,
    "**": 10
  };

  var isClassExtendsClause = function isClassExtendsClause(node, parent) {
    return (isClassDeclaration$1(parent) || isClassExpression(parent)) && parent.superClass === node;
  };

  var hasPostfixPart = function hasPostfixPart(node, parent) {
    return (isMemberExpression$5(parent) || isOptionalMemberExpression$1(parent)) && parent.object === node || (isCallExpression$4(parent) || isOptionalCallExpression$1(parent) || isNewExpression$3(parent)) && parent.callee === node || isTaggedTemplateExpression(parent) && parent.tag === node || isTSNonNullExpression$1(parent);
  };

  function NullableTypeAnnotation$1(node, parent) {
    return isArrayTypeAnnotation(parent);
  }
  function FunctionTypeAnnotation$1(node, parent, printStack) {
    return isUnionTypeAnnotation$1(parent) || isIntersectionTypeAnnotation(parent) || isArrayTypeAnnotation(parent) || isTypeAnnotation$1(parent) && isArrowFunctionExpression(printStack[printStack.length - 3]);
  }
  function UpdateExpression$2(node, parent) {
    return hasPostfixPart(node, parent) || isClassExtendsClause(node, parent);
  }
  function ObjectExpression$2(node, parent, printStack) {
    return isFirstInContext(printStack, {
      expressionStatement: true,
      arrowBody: true
    });
  }
  function DoExpression$1(node, parent, printStack) {
    return !node.async && isFirstInContext(printStack, {
      expressionStatement: true
    });
  }
  function Binary(node, parent) {
    if (node.operator === "**" && isBinaryExpression(parent, {
      operator: "**"
    })) {
      return parent.left === node;
    }

    if (isClassExtendsClause(node, parent)) {
      return true;
    }

    if (hasPostfixPart(node, parent) || isUnaryLike(parent) || isAwaitExpression(parent)) {
      return true;
    }

    if (isBinary(parent)) {
      var parentOp = parent.operator;
      var parentPos = PRECEDENCE[parentOp];
      var nodeOp = node.operator;
      var nodePos = PRECEDENCE[nodeOp];

      if (parentPos === nodePos && parent.right === node && !isLogicalExpression(parent) || parentPos > nodePos) {
        return true;
      }
    }
  }
  function UnionTypeAnnotation$1(node, parent) {
    return isArrayTypeAnnotation(parent) || isNullableTypeAnnotation(parent) || isIntersectionTypeAnnotation(parent) || isUnionTypeAnnotation$1(parent);
  }
  function OptionalIndexedAccessType$1(node, parent) {
    return isIndexedAccessType(parent, {
      objectType: node
    });
  }
  function TSAsExpression$1() {
    return true;
  }
  function TSTypeAssertion$1() {
    return true;
  }
  function TSUnionType$1(node, parent) {
    return isTSArrayType(parent) || isTSOptionalType(parent) || isTSIntersectionType(parent) || isTSUnionType(parent) || isTSRestType(parent);
  }
  function TSInferType$1(node, parent) {
    return isTSArrayType(parent) || isTSOptionalType(parent);
  }
  function BinaryExpression$1(node, parent) {
    return node.operator === "in" && (isVariableDeclarator$1(parent) || isFor$1(parent));
  }
  function SequenceExpression$2(node, parent) {
    if (isForStatement$1(parent) || isThrowStatement(parent) || isReturnStatement(parent) || isIfStatement$1(parent) && parent.test === node || isWhileStatement(parent) && parent.test === node || isForInStatement(parent) && parent.right === node || isSwitchStatement(parent) && parent.discriminant === node || isExpressionStatement$3(parent) && parent.expression === node) {
      return false;
    }

    return true;
  }
  function YieldExpression$1(node, parent) {
    return isBinary(parent) || isUnaryLike(parent) || hasPostfixPart(node, parent) || isAwaitExpression(parent) && isYieldExpression(node) || isConditionalExpression(parent) && node === parent.test || isClassExtendsClause(node, parent);
  }
  function ClassExpression(node, parent, printStack) {
    return isFirstInContext(printStack, {
      expressionStatement: true,
      exportDefault: true
    });
  }
  function UnaryLike(node, parent) {
    return hasPostfixPart(node, parent) || isBinaryExpression(parent, {
      operator: "**",
      left: node
    }) || isClassExtendsClause(node, parent);
  }
  function FunctionExpression$1(node, parent, printStack) {
    return isFirstInContext(printStack, {
      expressionStatement: true,
      exportDefault: true
    });
  }
  function ArrowFunctionExpression$1(node, parent) {
    return isExportDeclaration(parent) || ConditionalExpression$2(node, parent);
  }
  function ConditionalExpression$2(node, parent) {
    if (isUnaryLike(parent) || isBinary(parent) || isConditionalExpression(parent, {
      test: node
    }) || isAwaitExpression(parent) || isTSTypeAssertion$1(parent) || isTSAsExpression$1(parent)) {
      return true;
    }

    return UnaryLike(node, parent);
  }
  function OptionalMemberExpression$1(node, parent) {
    return isCallExpression$4(parent, {
      callee: node
    }) || isMemberExpression$5(parent, {
      object: node
    });
  }
  function AssignmentExpression$2(node, parent) {
    if (isObjectPattern(node.left)) {
      return true;
    } else {
      return ConditionalExpression$2(node, parent);
    }
  }
  function LogicalExpression$1(node, parent) {
    switch (node.operator) {
      case "||":
        if (!isLogicalExpression(parent)) return false;
        return parent.operator === "??" || parent.operator === "&&";

      case "&&":
        return isLogicalExpression(parent, {
          operator: "??"
        });

      case "??":
        return isLogicalExpression(parent) && parent.operator !== "??";
    }
  }
  function Identifier$1(node, parent, printStack) {
    if (node.name === "let") {
      var isFollowedByBracket = isMemberExpression$5(parent, {
        object: node,
        computed: true
      }) || isOptionalMemberExpression$1(parent, {
        object: node,
        computed: true,
        optional: false
      });
      return isFirstInContext(printStack, {
        expressionStatement: isFollowedByBracket,
        forHead: isFollowedByBracket,
        forInHead: isFollowedByBracket,
        forOfHead: true
      });
    }

    return node.name === "async" && isForOfStatement(parent) && node === parent.left;
  }

  function isFirstInContext(printStack, _ref) {
    var _ref$expressionStatem = _ref.expressionStatement,
        expressionStatement = _ref$expressionStatem === void 0 ? false : _ref$expressionStatem,
        _ref$arrowBody = _ref.arrowBody,
        arrowBody = _ref$arrowBody === void 0 ? false : _ref$arrowBody,
        _ref$exportDefault = _ref.exportDefault,
        exportDefault = _ref$exportDefault === void 0 ? false : _ref$exportDefault,
        _ref$forHead = _ref.forHead,
        forHead = _ref$forHead === void 0 ? false : _ref$forHead,
        _ref$forInHead = _ref.forInHead,
        forInHead = _ref$forInHead === void 0 ? false : _ref$forInHead,
        _ref$forOfHead = _ref.forOfHead,
        forOfHead = _ref$forOfHead === void 0 ? false : _ref$forOfHead;
    var i = printStack.length - 1;
    var node = printStack[i];
    i--;
    var parent = printStack[i];

    while (i >= 0) {
      if (expressionStatement && isExpressionStatement$3(parent, {
        expression: node
      }) || exportDefault && isExportDefaultDeclaration$1(parent, {
        declaration: node
      }) || arrowBody && isArrowFunctionExpression(parent, {
        body: node
      }) || forHead && isForStatement$1(parent, {
        init: node
      }) || forInHead && isForInStatement(parent, {
        left: node
      }) || forOfHead && isForOfStatement(parent, {
        left: node
      })) {
        return true;
      }

      if (hasPostfixPart(node, parent) && !isNewExpression$3(parent) || isSequenceExpression(parent) && parent.expressions[0] === node || isConditional(parent, {
        test: node
      }) || isBinary(parent, {
        left: node
      }) || isAssignmentExpression$1(parent, {
        left: node
      })) {
        node = parent;
        i--;
        parent = printStack[i];
      } else {
        return false;
      }
    }

    return false;
  }

  var parens = /*#__PURE__*/Object.freeze({
    __proto__: null,
    NullableTypeAnnotation: NullableTypeAnnotation$1,
    FunctionTypeAnnotation: FunctionTypeAnnotation$1,
    UpdateExpression: UpdateExpression$2,
    ObjectExpression: ObjectExpression$2,
    DoExpression: DoExpression$1,
    Binary: Binary,
    UnionTypeAnnotation: UnionTypeAnnotation$1,
    IntersectionTypeAnnotation: UnionTypeAnnotation$1,
    OptionalIndexedAccessType: OptionalIndexedAccessType$1,
    TSAsExpression: TSAsExpression$1,
    TSTypeAssertion: TSTypeAssertion$1,
    TSUnionType: TSUnionType$1,
    TSIntersectionType: TSUnionType$1,
    TSInferType: TSInferType$1,
    BinaryExpression: BinaryExpression$1,
    SequenceExpression: SequenceExpression$2,
    YieldExpression: YieldExpression$1,
    AwaitExpression: YieldExpression$1,
    ClassExpression: ClassExpression,
    UnaryLike: UnaryLike,
    FunctionExpression: FunctionExpression$1,
    ArrowFunctionExpression: ArrowFunctionExpression$1,
    ConditionalExpression: ConditionalExpression$2,
    OptionalMemberExpression: OptionalMemberExpression$1,
    OptionalCallExpression: OptionalMemberExpression$1,
    AssignmentExpression: AssignmentExpression$2,
    LogicalExpression: LogicalExpression$1,
    Identifier: Identifier$1
  });

  var FLIPPED_ALIAS_KEYS$1 = FLIPPED_ALIAS_KEYS$3,
      isCallExpression$3 = isCallExpression$6,
      isExpressionStatement$2 = isExpressionStatement$4,
      isMemberExpression$4 = isMemberExpression$8,
      isNewExpression$2 = isNewExpression$4;

  function expandAliases(obj) {
    var newObj = {};

    function add(type, func) {
      var fn = newObj[type];
      newObj[type] = fn ? function (node, parent, stack) {
        var result = fn(node, parent, stack);
        return result == null ? func(node, parent, stack) : result;
      } : func;
    }

    for (var _i = 0, _Object$keys = Object.keys(obj); _i < _Object$keys.length; _i++) {
      var type = _Object$keys[_i];
      var aliases = FLIPPED_ALIAS_KEYS$1[type];

      if (aliases) {
        for (var _iterator = _createForOfIteratorHelperLoose(aliases), _step; !(_step = _iterator()).done;) {
          var alias = _step.value;
          add(alias, obj[type]);
        }
      } else {
        add(type, obj[type]);
      }
    }

    return newObj;
  }

  var expandedParens = expandAliases(parens);
  var expandedWhitespaceNodes = expandAliases(nodes);
  var expandedWhitespaceList = expandAliases(list$1);

  function find$2(obj, node, parent, printStack) {
    var fn = obj[node.type];
    return fn ? fn(node, parent, printStack) : null;
  }

  function isOrHasCallExpression(node) {
    if (isCallExpression$3(node)) {
      return true;
    }

    return isMemberExpression$4(node) && isOrHasCallExpression(node.object);
  }

  function needsWhitespace(node, parent, type) {
    if (!node) return 0;

    if (isExpressionStatement$2(node)) {
      node = node.expression;
    }

    var linesInfo = find$2(expandedWhitespaceNodes, node, parent);

    if (!linesInfo) {
      var items = find$2(expandedWhitespaceList, node, parent);

      if (items) {
        for (var i = 0; i < items.length; i++) {
          linesInfo = needsWhitespace(items[i], node, type);
          if (linesInfo) break;
        }
      }
    }

    if (typeof linesInfo === "object" && linesInfo !== null) {
      return linesInfo[type] || 0;
    }

    return 0;
  }
  function needsWhitespaceBefore$1(node, parent) {
    return needsWhitespace(node, parent, "before");
  }
  function needsWhitespaceAfter$1(node, parent) {
    return needsWhitespace(node, parent, "after");
  }
  function needsParens$1(node, parent, printStack) {
    if (!parent) return false;

    if (isNewExpression$2(parent) && parent.callee === node) {
      if (isOrHasCallExpression(node)) return true;
    }

    return find$2(expandedParens, node, parent, printStack);
  }

  function TaggedTemplateExpression$1(node) {
    this.print(node.tag, node);
    this.print(node.typeParameters, node);
    this.print(node.quasi, node);
  }
  function TemplateElement(node, parent) {
    var isFirst = parent.quasis[0] === node;
    var isLast = parent.quasis[parent.quasis.length - 1] === node;
    var value = (isFirst ? "`" : "}") + node.value.raw + (isLast ? "`" : "${");
    this.token(value);
  }
  function TemplateLiteral$1(node) {
    var quasis = node.quasis;

    for (var i = 0; i < quasis.length; i++) {
      this.print(quasis[i], node);

      if (i + 1 < quasis.length) {
        this.print(node.expressions[i], node);
      }
    }
  }

  var isCallExpression$2 = isCallExpression$6,
      isLiteral$4 = isLiteral$7,
      isMemberExpression$3 = isMemberExpression$8,
      isNewExpression$1 = isNewExpression$4;
  function UnaryExpression$1(node) {
    if (node.operator === "void" || node.operator === "delete" || node.operator === "typeof" || node.operator === "throw") {
      this.word(node.operator);
      this.space();
    } else {
      this.token(node.operator);
    }

    this.print(node.argument, node);
  }
  function DoExpression(node) {
    if (node.async) {
      this.word("async");
      this.space();
    }

    this.word("do");
    this.space();
    this.print(node.body, node);
  }
  function ParenthesizedExpression$1(node) {
    this.token("(");
    this.print(node.expression, node);
    this.token(")");
  }
  function UpdateExpression$1(node) {
    if (node.prefix) {
      this.token(node.operator);
      this.print(node.argument, node);
    } else {
      this.startTerminatorless(true);
      this.print(node.argument, node);
      this.endTerminatorless();
      this.token(node.operator);
    }
  }
  function ConditionalExpression$1(node) {
    this.print(node.test, node);
    this.space();
    this.token("?");
    this.space();
    this.print(node.consequent, node);
    this.space();
    this.token(":");
    this.space();
    this.print(node.alternate, node);
  }
  function NewExpression$1(node, parent) {
    this.word("new");
    this.space();
    this.print(node.callee, node);

    if (this.format.minified && node.arguments.length === 0 && !node.optional && !isCallExpression$2(parent, {
      callee: node
    }) && !isMemberExpression$3(parent) && !isNewExpression$1(parent)) {
      return;
    }

    this.print(node.typeArguments, node);
    this.print(node.typeParameters, node);

    if (node.optional) {
      this.token("?.");
    }

    this.token("(");
    this.printList(node.arguments, node);
    this.token(")");
  }
  function SequenceExpression$1(node) {
    this.printList(node.expressions, node);
  }
  function ThisExpression() {
    this.word("this");
  }
  function Super() {
    this.word("super");
  }
  function Decorator(node) {
    this.token("@");
    this.print(node.expression, node);
    this.newline();
  }
  function OptionalMemberExpression(node) {
    this.print(node.object, node);

    if (!node.computed && isMemberExpression$3(node.property)) {
      throw new TypeError("Got a MemberExpression for MemberExpression property");
    }

    var computed = node.computed;

    if (isLiteral$4(node.property) && typeof node.property.value === "number") {
      computed = true;
    }

    if (node.optional) {
      this.token("?.");
    }

    if (computed) {
      this.token("[");
      this.print(node.property, node);
      this.token("]");
    } else {
      if (!node.optional) {
        this.token(".");
      }

      this.print(node.property, node);
    }
  }
  function OptionalCallExpression(node) {
    this.print(node.callee, node);
    this.print(node.typeArguments, node);
    this.print(node.typeParameters, node);

    if (node.optional) {
      this.token("?.");
    }

    this.token("(");
    this.printList(node.arguments, node);
    this.token(")");
  }
  function CallExpression$1(node) {
    this.print(node.callee, node);
    this.print(node.typeArguments, node);
    this.print(node.typeParameters, node);
    this.token("(");
    this.printList(node.arguments, node);
    this.token(")");
  }
  function Import() {
    this.word("import");
  }

  function buildYieldAwait(keyword) {
    return function (node) {
      this.word(keyword);

      if (node.delegate) {
        this.token("*");
      }

      if (node.argument) {
        this.space();
        var terminatorState = this.startTerminatorless();
        this.print(node.argument, node);
        this.endTerminatorless(terminatorState);
      }
    };
  }

  var YieldExpression = buildYieldAwait("yield");
  var AwaitExpression = buildYieldAwait("await");
  function EmptyStatement() {
    this.semicolon(true);
  }
  function ExpressionStatement(node) {
    this.print(node.expression, node);
    this.semicolon();
  }
  function AssignmentPattern(node) {
    this.print(node.left, node);
    if (node.left.optional) this.token("?");
    this.print(node.left.typeAnnotation, node);
    this.space();
    this.token("=");
    this.space();
    this.print(node.right, node);
  }
  function AssignmentExpression$1(node, parent) {
    var parens = this.inForStatementInitCounter && node.operator === "in" && !needsParens$1(node, parent);

    if (parens) {
      this.token("(");
    }

    this.print(node.left, node);
    this.space();

    if (node.operator === "in" || node.operator === "instanceof") {
      this.word(node.operator);
    } else {
      this.token(node.operator);
    }

    this.space();
    this.print(node.right, node);

    if (parens) {
      this.token(")");
    }
  }
  function BindExpression(node) {
    this.print(node.object, node);
    this.token("::");
    this.print(node.callee, node);
  }
  function MemberExpression(node) {
    this.print(node.object, node);

    if (!node.computed && isMemberExpression$3(node.property)) {
      throw new TypeError("Got a MemberExpression for MemberExpression property");
    }

    var computed = node.computed;

    if (isLiteral$4(node.property) && typeof node.property.value === "number") {
      computed = true;
    }

    if (computed) {
      this.token("[");
      this.print(node.property, node);
      this.token("]");
    } else {
      this.token(".");
      this.print(node.property, node);
    }
  }
  function MetaProperty(node) {
    this.print(node.meta, node);
    this.token(".");
    this.print(node.property, node);
  }
  function PrivateName(node) {
    this.token("#");
    this.print(node.id, node);
  }
  function V8IntrinsicIdentifier(node) {
    this.token("%");
    this.word(node.name);
  }
  function ModuleExpression(node) {
    this.word("module");
    this.space();
    this.token("{");

    if (node.body.body.length === 0) {
      this.token("}");
    } else {
      this.newline();
      this.printSequence(node.body.body, node, {
        indent: true
      });
      this.rightBrace();
    }
  }

  var isFor = isFor$2,
      isForStatement = isForStatement$3,
      isIfStatement = isIfStatement$2,
      isStatement$5 = isStatement$7;
  function WithStatement(node) {
    this.word("with");
    this.space();
    this.token("(");
    this.print(node.object, node);
    this.token(")");
    this.printBlock(node);
  }
  function IfStatement(node) {
    this.word("if");
    this.space();
    this.token("(");
    this.print(node.test, node);
    this.token(")");
    this.space();
    var needsBlock = node.alternate && isIfStatement(getLastStatement(node.consequent));

    if (needsBlock) {
      this.token("{");
      this.newline();
      this.indent();
    }

    this.printAndIndentOnComments(node.consequent, node);

    if (needsBlock) {
      this.dedent();
      this.newline();
      this.token("}");
    }

    if (node.alternate) {
      if (this.endsWith(125)) this.space();
      this.word("else");
      this.space();
      this.printAndIndentOnComments(node.alternate, node);
    }
  }

  function getLastStatement(statement) {
    if (!isStatement$5(statement.body)) return statement;
    return getLastStatement(statement.body);
  }

  function ForStatement(node) {
    this.word("for");
    this.space();
    this.token("(");
    this.inForStatementInitCounter++;
    this.print(node.init, node);
    this.inForStatementInitCounter--;
    this.token(";");

    if (node.test) {
      this.space();
      this.print(node.test, node);
    }

    this.token(";");

    if (node.update) {
      this.space();
      this.print(node.update, node);
    }

    this.token(")");
    this.printBlock(node);
  }
  function WhileStatement(node) {
    this.word("while");
    this.space();
    this.token("(");
    this.print(node.test, node);
    this.token(")");
    this.printBlock(node);
  }

  var buildForXStatement = function buildForXStatement(op) {
    return function (node) {
      this.word("for");
      this.space();

      if (op === "of" && node["await"]) {
        this.word("await");
        this.space();
      }

      this.token("(");
      this.print(node.left, node);
      this.space();
      this.word(op);
      this.space();
      this.print(node.right, node);
      this.token(")");
      this.printBlock(node);
    };
  };

  var ForInStatement = buildForXStatement("in");
  var ForOfStatement = buildForXStatement("of");
  function DoWhileStatement(node) {
    this.word("do");
    this.space();
    this.print(node.body, node);
    this.space();
    this.word("while");
    this.space();
    this.token("(");
    this.print(node.test, node);
    this.token(")");
    this.semicolon();
  }

  function buildLabelStatement(prefix, key) {
    if (key === void 0) {
      key = "label";
    }

    return function (node) {
      this.word(prefix);
      var label = node[key];

      if (label) {
        this.space();
        var isLabel = key == "label";
        var terminatorState = this.startTerminatorless(isLabel);
        this.print(label, node);
        this.endTerminatorless(terminatorState);
      }

      this.semicolon();
    };
  }

  var ContinueStatement = buildLabelStatement("continue");
  var ReturnStatement = buildLabelStatement("return", "argument");
  var BreakStatement = buildLabelStatement("break");
  var ThrowStatement = buildLabelStatement("throw", "argument");
  function LabeledStatement(node) {
    this.print(node.label, node);
    this.token(":");
    this.space();
    this.print(node.body, node);
  }
  function TryStatement(node) {
    this.word("try");
    this.space();
    this.print(node.block, node);
    this.space();

    if (node.handlers) {
      this.print(node.handlers[0], node);
    } else {
      this.print(node.handler, node);
    }

    if (node.finalizer) {
      this.space();
      this.word("finally");
      this.space();
      this.print(node.finalizer, node);
    }
  }
  function CatchClause(node) {
    this.word("catch");
    this.space();

    if (node.param) {
      this.token("(");
      this.print(node.param, node);
      this.print(node.param.typeAnnotation, node);
      this.token(")");
      this.space();
    }

    this.print(node.body, node);
  }
  function SwitchStatement(node) {
    this.word("switch");
    this.space();
    this.token("(");
    this.print(node.discriminant, node);
    this.token(")");
    this.space();
    this.token("{");
    this.printSequence(node.cases, node, {
      indent: true,
      addNewlines: function addNewlines(leading, cas) {
        if (!leading && node.cases[node.cases.length - 1] === cas) return -1;
      }
    });
    this.token("}");
  }
  function SwitchCase(node) {
    if (node.test) {
      this.word("case");
      this.space();
      this.print(node.test, node);
      this.token(":");
    } else {
      this.word("default");
      this.token(":");
    }

    if (node.consequent.length) {
      this.newline();
      this.printSequence(node.consequent, node, {
        indent: true
      });
    }
  }
  function DebuggerStatement() {
    this.word("debugger");
    this.semicolon();
  }

  function variableDeclarationIndent() {
    this.token(",");
    this.newline();

    if (this.endsWith(10)) {
      for (var i = 0; i < 4; i++) {
        this.space(true);
      }
    }
  }

  function constDeclarationIndent() {
    this.token(",");
    this.newline();

    if (this.endsWith(10)) {
      for (var i = 0; i < 6; i++) {
        this.space(true);
      }
    }
  }

  function VariableDeclaration(node, parent) {
    if (node.declare) {
      this.word("declare");
      this.space();
    }

    this.word(node.kind);
    this.space();
    var hasInits = false;

    if (!isFor(parent)) {
      for (var _iterator = _createForOfIteratorHelperLoose(node.declarations), _step; !(_step = _iterator()).done;) {
        var declar = _step.value;

        if (declar.init) {
          hasInits = true;
        }
      }
    }

    var separator;

    if (hasInits) {
      separator = node.kind === "const" ? constDeclarationIndent : variableDeclarationIndent;
    }

    this.printList(node.declarations, node, {
      separator: separator
    });

    if (isFor(parent)) {
      if (isForStatement(parent)) {
        if (parent.init === node) return;
      } else {
        if (parent.left === node) return;
      }
    }

    this.semicolon();
  }
  function VariableDeclarator$1(node) {
    this.print(node.id, node);
    if (node.definite) this.token("!");
    this.print(node.id.typeAnnotation, node);

    if (node.init) {
      this.space();
      this.token("=");
      this.space();
      this.print(node.init, node);
    }
  }

  var isExportDefaultDeclaration = isExportDefaultDeclaration$3,
      isExportNamedDeclaration = isExportNamedDeclaration$2;
  function ClassDeclaration(node, parent) {
    if (!this.format.decoratorsBeforeExport || !isExportDefaultDeclaration(parent) && !isExportNamedDeclaration(parent)) {
      this.printJoin(node.decorators, node);
    }

    if (node.declare) {
      this.word("declare");
      this.space();
    }

    if (node["abstract"]) {
      this.word("abstract");
      this.space();
    }

    this.word("class");

    if (node.id) {
      this.space();
      this.print(node.id, node);
    }

    this.print(node.typeParameters, node);

    if (node.superClass) {
      this.space();
      this.word("extends");
      this.space();
      this.print(node.superClass, node);
      this.print(node.superTypeParameters, node);
    }

    if (node["implements"]) {
      this.space();
      this.word("implements");
      this.space();
      this.printList(node["implements"], node);
    }

    this.space();
    this.print(node.body, node);
  }
  function ClassBody(node) {
    this.token("{");
    this.printInnerComments(node);

    if (node.body.length === 0) {
      this.token("}");
    } else {
      this.newline();
      this.indent();
      this.printSequence(node.body, node);
      this.dedent();
      if (!this.endsWith(10)) this.newline();
      this.rightBrace();
    }
  }
  function ClassProperty(node) {
    this.printJoin(node.decorators, node);
    this.source("end", node.key.loc);
    this.tsPrintClassMemberModifiers(node, true);

    if (node.computed) {
      this.token("[");
      this.print(node.key, node);
      this.token("]");
    } else {
      this._variance(node);

      this.print(node.key, node);
    }

    if (node.optional) {
      this.token("?");
    }

    if (node.definite) {
      this.token("!");
    }

    this.print(node.typeAnnotation, node);

    if (node.value) {
      this.space();
      this.token("=");
      this.space();
      this.print(node.value, node);
    }

    this.semicolon();
  }
  function ClassPrivateProperty(node) {
    this.printJoin(node.decorators, node);

    if (node["static"]) {
      this.word("static");
      this.space();
    }

    this.print(node.key, node);
    this.print(node.typeAnnotation, node);

    if (node.value) {
      this.space();
      this.token("=");
      this.space();
      this.print(node.value, node);
    }

    this.semicolon();
  }
  function ClassMethod(node) {
    this._classMethodHead(node);

    this.space();
    this.print(node.body, node);
  }
  function ClassPrivateMethod(node) {
    this._classMethodHead(node);

    this.space();
    this.print(node.body, node);
  }
  function _classMethodHead(node) {
    this.printJoin(node.decorators, node);
    this.source("end", node.key.loc);
    this.tsPrintClassMemberModifiers(node, false);

    this._methodHead(node);
  }
  function StaticBlock(node) {
    this.word("static");
    this.space();
    this.token("{");

    if (node.body.length === 0) {
      this.token("}");
    } else {
      this.newline();
      this.printSequence(node.body, node, {
        indent: true
      });
      this.rightBrace();
    }
  }

  var isIdentifier$c = isIdentifier$g;
  function _params(node) {
    this.print(node.typeParameters, node);
    this.token("(");

    this._parameters(node.params, node);

    this.token(")");
    this.print(node.returnType, node);
  }
  function _parameters(parameters, parent) {
    for (var i = 0; i < parameters.length; i++) {
      this._param(parameters[i], parent);

      if (i < parameters.length - 1) {
        this.token(",");
        this.space();
      }
    }
  }
  function _param(parameter, parent) {
    this.printJoin(parameter.decorators, parameter);
    this.print(parameter, parent);
    if (parameter.optional) this.token("?");
    this.print(parameter.typeAnnotation, parameter);
  }
  function _methodHead(node) {
    var kind = node.kind;
    var key = node.key;

    if (kind === "get" || kind === "set") {
      this.word(kind);
      this.space();
    }

    if (node.async) {
      this._catchUp("start", key.loc);

      this.word("async");
      this.space();
    }

    if (kind === "method" || kind === "init") {
      if (node.generator) {
        this.token("*");
      }
    }

    if (node.computed) {
      this.token("[");
      this.print(key, node);
      this.token("]");
    } else {
      this.print(key, node);
    }

    if (node.optional) {
      this.token("?");
    }

    this._params(node);
  }
  function _predicate(node) {
    if (node.predicate) {
      if (!node.returnType) {
        this.token(":");
      }

      this.space();
      this.print(node.predicate, node);
    }
  }
  function _functionHead(node) {
    if (node.async) {
      this.word("async");
      this.space();
    }

    this.word("function");
    if (node.generator) this.token("*");
    this.space();

    if (node.id) {
      this.print(node.id, node);
    }

    this._params(node);

    this._predicate(node);
  }
  function FunctionExpression(node) {
    this._functionHead(node);

    this.space();
    this.print(node.body, node);
  }
  function ArrowFunctionExpression(node) {
    if (node.async) {
      this.word("async");
      this.space();
    }

    var firstParam = node.params[0];

    if (!this.format.retainLines && !this.format.auxiliaryCommentBefore && !this.format.auxiliaryCommentAfter && node.params.length === 1 && isIdentifier$c(firstParam) && !hasTypesOrComments(node, firstParam)) {
      this.print(firstParam, node);
    } else {
      this._params(node);
    }

    this._predicate(node);

    this.space();
    this.token("=>");
    this.space();
    this.print(node.body, node);
  }

  function hasTypesOrComments(node, param) {
    var _param$leadingComment, _param$trailingCommen;

    return !!(node.typeParameters || node.returnType || node.predicate || param.typeAnnotation || param.optional || (_param$leadingComment = param.leadingComments) != null && _param$leadingComment.length || (_param$trailingCommen = param.trailingComments) != null && _param$trailingCommen.length);
  }

  var isClassDeclaration = isClassDeclaration$3,
      isExportDefaultSpecifier = isExportDefaultSpecifier$1,
      isExportNamespaceSpecifier = isExportNamespaceSpecifier$1,
      isImportDefaultSpecifier = isImportDefaultSpecifier$1,
      isImportNamespaceSpecifier = isImportNamespaceSpecifier$1,
      isStatement$4 = isStatement$7;
  function ImportSpecifier(node) {
    if (node.importKind === "type" || node.importKind === "typeof") {
      this.word(node.importKind);
      this.space();
    }

    this.print(node.imported, node);

    if (node.local && node.local.name !== node.imported.name) {
      this.space();
      this.word("as");
      this.space();
      this.print(node.local, node);
    }
  }
  function ImportDefaultSpecifier(node) {
    this.print(node.local, node);
  }
  function ExportDefaultSpecifier(node) {
    this.print(node.exported, node);
  }
  function ExportSpecifier(node) {
    this.print(node.local, node);

    if (node.exported && node.local.name !== node.exported.name) {
      this.space();
      this.word("as");
      this.space();
      this.print(node.exported, node);
    }
  }
  function ExportNamespaceSpecifier(node) {
    this.token("*");
    this.space();
    this.word("as");
    this.space();
    this.print(node.exported, node);
  }
  function ExportAllDeclaration(node) {
    this.word("export");
    this.space();

    if (node.exportKind === "type") {
      this.word("type");
      this.space();
    }

    this.token("*");
    this.space();
    this.word("from");
    this.space();
    this.print(node.source, node);
    this.printAssertions(node);
    this.semicolon();
  }
  function ExportNamedDeclaration(node) {
    if (this.format.decoratorsBeforeExport && isClassDeclaration(node.declaration)) {
      this.printJoin(node.declaration.decorators, node);
    }

    this.word("export");
    this.space();
    ExportDeclaration.apply(this, arguments);
  }
  function ExportDefaultDeclaration(node) {
    if (this.format.decoratorsBeforeExport && isClassDeclaration(node.declaration)) {
      this.printJoin(node.declaration.decorators, node);
    }

    this.word("export");
    this.space();
    this.word("default");
    this.space();
    ExportDeclaration.apply(this, arguments);
  }

  function ExportDeclaration(node) {
    if (node.declaration) {
      var declar = node.declaration;
      this.print(declar, node);
      if (!isStatement$4(declar)) this.semicolon();
    } else {
      if (node.exportKind === "type") {
        this.word("type");
        this.space();
      }

      var specifiers = node.specifiers.slice(0);
      var hasSpecial = false;

      for (;;) {
        var first = specifiers[0];

        if (isExportDefaultSpecifier(first) || isExportNamespaceSpecifier(first)) {
          hasSpecial = true;
          this.print(specifiers.shift(), node);

          if (specifiers.length) {
            this.token(",");
            this.space();
          }
        } else {
          break;
        }
      }

      if (specifiers.length || !specifiers.length && !hasSpecial) {
        this.token("{");

        if (specifiers.length) {
          this.space();
          this.printList(specifiers, node);
          this.space();
        }

        this.token("}");
      }

      if (node.source) {
        this.space();
        this.word("from");
        this.space();
        this.print(node.source, node);
        this.printAssertions(node);
      }

      this.semicolon();
    }
  }

  function ImportDeclaration(node) {
    this.word("import");
    this.space();

    if (node.importKind === "type" || node.importKind === "typeof") {
      this.word(node.importKind);
      this.space();
    }

    var specifiers = node.specifiers.slice(0);

    if (specifiers != null && specifiers.length) {
      for (;;) {
        var first = specifiers[0];

        if (isImportDefaultSpecifier(first) || isImportNamespaceSpecifier(first)) {
          this.print(specifiers.shift(), node);

          if (specifiers.length) {
            this.token(",");
            this.space();
          }
        } else {
          break;
        }
      }

      if (specifiers.length) {
        this.token("{");
        this.space();
        this.printList(specifiers, node);
        this.space();
        this.token("}");
      }

      this.space();
      this.word("from");
      this.space();
    }

    this.print(node.source, node);
    this.printAssertions(node);
    {
      var _node$attributes;

      if ((_node$attributes = node.attributes) != null && _node$attributes.length) {
        this.space();
        this.word("with");
        this.space();
        this.printList(node.attributes, node);
      }
    }
    this.semicolon();
  }
  function ImportAttribute(node) {
    this.print(node.key);
    this.token(":");
    this.space();
    this.print(node.value);
  }
  function ImportNamespaceSpecifier(node) {
    this.token("*");
    this.space();
    this.word("as");
    this.space();
    this.print(node.local, node);
  }

  var byteLength_1 = byteLength;
  var toByteArray_1 = toByteArray;
  var fromByteArray_1 = fromByteArray;
  var lookup = [];
  var revLookup = [];
  var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
  var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

  for (var i = 0, len = code.length; i < len; ++i) {
    lookup[i] = code[i];
    revLookup[code.charCodeAt(i)] = i;
  }

  revLookup['-'.charCodeAt(0)] = 62;
  revLookup['_'.charCodeAt(0)] = 63;

  function getLens(b64) {
    var len = b64.length;

    if (len % 4 > 0) {
      throw new Error('Invalid string. Length must be a multiple of 4');
    }

    var validLen = b64.indexOf('=');
    if (validLen === -1) validLen = len;
    var placeHoldersLen = validLen === len ? 0 : 4 - validLen % 4;
    return [validLen, placeHoldersLen];
  }

  function byteLength(b64) {
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }

  function _byteLength(b64, validLen, placeHoldersLen) {
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }

  function toByteArray(b64) {
    var tmp;
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
    var curByte = 0;
    var len = placeHoldersLen > 0 ? validLen - 4 : validLen;
    var i;

    for (i = 0; i < len; i += 4) {
      tmp = revLookup[b64.charCodeAt(i)] << 18 | revLookup[b64.charCodeAt(i + 1)] << 12 | revLookup[b64.charCodeAt(i + 2)] << 6 | revLookup[b64.charCodeAt(i + 3)];
      arr[curByte++] = tmp >> 16 & 0xFF;
      arr[curByte++] = tmp >> 8 & 0xFF;
      arr[curByte++] = tmp & 0xFF;
    }

    if (placeHoldersLen === 2) {
      tmp = revLookup[b64.charCodeAt(i)] << 2 | revLookup[b64.charCodeAt(i + 1)] >> 4;
      arr[curByte++] = tmp & 0xFF;
    }

    if (placeHoldersLen === 1) {
      tmp = revLookup[b64.charCodeAt(i)] << 10 | revLookup[b64.charCodeAt(i + 1)] << 4 | revLookup[b64.charCodeAt(i + 2)] >> 2;
      arr[curByte++] = tmp >> 8 & 0xFF;
      arr[curByte++] = tmp & 0xFF;
    }

    return arr;
  }

  function tripletToBase64(num) {
    return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F];
  }

  function encodeChunk(uint8, start, end) {
    var tmp;
    var output = [];

    for (var i = start; i < end; i += 3) {
      tmp = (uint8[i] << 16 & 0xFF0000) + (uint8[i + 1] << 8 & 0xFF00) + (uint8[i + 2] & 0xFF);
      output.push(tripletToBase64(tmp));
    }

    return output.join('');
  }

  function fromByteArray(uint8) {
    var tmp;
    var len = uint8.length;
    var extraBytes = len % 3;
    var parts = [];
    var maxChunkLength = 16383;

    for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
      parts.push(encodeChunk(uint8, i, i + maxChunkLength > len2 ? len2 : i + maxChunkLength));
    }

    if (extraBytes === 1) {
      tmp = uint8[len - 1];
      parts.push(lookup[tmp >> 2] + lookup[tmp << 4 & 0x3F] + '==');
    } else if (extraBytes === 2) {
      tmp = (uint8[len - 2] << 8) + uint8[len - 1];
      parts.push(lookup[tmp >> 10] + lookup[tmp >> 4 & 0x3F] + lookup[tmp << 2 & 0x3F] + '=');
    }

    return parts.join('');
  }

  var base64Js = {
    byteLength: byteLength_1,
    toByteArray: toByteArray_1,
    fromByteArray: fromByteArray_1
  };

  var read = function read(buffer, offset, isLE, mLen, nBytes) {
    var e, m;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var nBits = -7;
    var i = isLE ? nBytes - 1 : 0;
    var d = isLE ? -1 : 1;
    var s = buffer[offset + i];
    i += d;
    e = s & (1 << -nBits) - 1;
    s >>= -nBits;
    nBits += eLen;

    for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

    m = e & (1 << -nBits) - 1;
    e >>= -nBits;
    nBits += mLen;

    for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

    if (e === 0) {
      e = 1 - eBias;
    } else if (e === eMax) {
      return m ? NaN : (s ? -1 : 1) * Infinity;
    } else {
      m = m + Math.pow(2, mLen);
      e = e - eBias;
    }

    return (s ? -1 : 1) * m * Math.pow(2, e - mLen);
  };

  var write = function write(buffer, value, offset, isLE, mLen, nBytes) {
    var e, m, c;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
    var i = isLE ? 0 : nBytes - 1;
    var d = isLE ? 1 : -1;
    var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
    value = Math.abs(value);

    if (isNaN(value) || value === Infinity) {
      m = isNaN(value) ? 1 : 0;
      e = eMax;
    } else {
      e = Math.floor(Math.log(value) / Math.LN2);

      if (value * (c = Math.pow(2, -e)) < 1) {
        e--;
        c *= 2;
      }

      if (e + eBias >= 1) {
        value += rt / c;
      } else {
        value += rt * Math.pow(2, 1 - eBias);
      }

      if (value * c >= 2) {
        e++;
        c /= 2;
      }

      if (e + eBias >= eMax) {
        m = 0;
        e = eMax;
      } else if (e + eBias >= 1) {
        m = (value * c - 1) * Math.pow(2, mLen);
        e = e + eBias;
      } else {
        m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
        e = 0;
      }
    }

    for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

    e = e << mLen | m;
    eLen += mLen;

    for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

    buffer[offset + i - d] |= s * 128;
  };

  var ieee754 = {
    read: read,
    write: write
  };

  /*!
   * The buffer module from node.js, for the browser.
   *
   * @author   Feross Aboukhadijeh <https://feross.org>
   * @license  MIT
   */
  var buffer = createCommonjsModule(function (module, exports) {

    exports.Buffer = Buffer;
    exports.SlowBuffer = SlowBuffer;
    exports.INSPECT_MAX_BYTES = 50;
    var K_MAX_LENGTH = 0x7fffffff;
    exports.kMaxLength = K_MAX_LENGTH;
    Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport();

    if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' && typeof console.error === 'function') {
      console.error('This browser lacks typed array (Uint8Array) support which is required by ' + '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.');
    }

    function typedArraySupport() {
      try {
        var arr = new Uint8Array(1);
        arr.__proto__ = {
          __proto__: Uint8Array.prototype,
          foo: function foo() {
            return 42;
          }
        };
        return arr.foo() === 42;
      } catch (e) {
        return false;
      }
    }

    Object.defineProperty(Buffer.prototype, 'parent', {
      enumerable: true,
      get: function get() {
        if (!Buffer.isBuffer(this)) return undefined;
        return this.buffer;
      }
    });
    Object.defineProperty(Buffer.prototype, 'offset', {
      enumerable: true,
      get: function get() {
        if (!Buffer.isBuffer(this)) return undefined;
        return this.byteOffset;
      }
    });

    function createBuffer(length) {
      if (length > K_MAX_LENGTH) {
        throw new RangeError('The value "' + length + '" is invalid for option "size"');
      }

      var buf = new Uint8Array(length);
      buf.__proto__ = Buffer.prototype;
      return buf;
    }

    function Buffer(arg, encodingOrOffset, length) {
      if (typeof arg === 'number') {
        if (typeof encodingOrOffset === 'string') {
          throw new TypeError('The "string" argument must be of type string. Received type number');
        }

        return allocUnsafe(arg);
      }

      return from(arg, encodingOrOffset, length);
    }

    if (typeof Symbol !== 'undefined' && Symbol.species != null && Buffer[Symbol.species] === Buffer) {
      Object.defineProperty(Buffer, Symbol.species, {
        value: null,
        configurable: true,
        enumerable: false,
        writable: false
      });
    }

    Buffer.poolSize = 8192;

    function from(value, encodingOrOffset, length) {
      if (typeof value === 'string') {
        return fromString(value, encodingOrOffset);
      }

      if (ArrayBuffer.isView(value)) {
        return fromArrayLike(value);
      }

      if (value == null) {
        throw TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' + 'or Array-like Object. Received type ' + typeof value);
      }

      if (isInstance(value, ArrayBuffer) || value && isInstance(value.buffer, ArrayBuffer)) {
        return fromArrayBuffer(value, encodingOrOffset, length);
      }

      if (typeof value === 'number') {
        throw new TypeError('The "value" argument must not be of type number. Received type number');
      }

      var valueOf = value.valueOf && value.valueOf();

      if (valueOf != null && valueOf !== value) {
        return Buffer.from(valueOf, encodingOrOffset, length);
      }

      var b = fromObject(value);
      if (b) return b;

      if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null && typeof value[Symbol.toPrimitive] === 'function') {
        return Buffer.from(value[Symbol.toPrimitive]('string'), encodingOrOffset, length);
      }

      throw new TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' + 'or Array-like Object. Received type ' + typeof value);
    }

    Buffer.from = function (value, encodingOrOffset, length) {
      return from(value, encodingOrOffset, length);
    };

    Buffer.prototype.__proto__ = Uint8Array.prototype;
    Buffer.__proto__ = Uint8Array;

    function assertSize(size) {
      if (typeof size !== 'number') {
        throw new TypeError('"size" argument must be of type number');
      } else if (size < 0) {
        throw new RangeError('The value "' + size + '" is invalid for option "size"');
      }
    }

    function alloc(size, fill, encoding) {
      assertSize(size);

      if (size <= 0) {
        return createBuffer(size);
      }

      if (fill !== undefined) {
        return typeof encoding === 'string' ? createBuffer(size).fill(fill, encoding) : createBuffer(size).fill(fill);
      }

      return createBuffer(size);
    }

    Buffer.alloc = function (size, fill, encoding) {
      return alloc(size, fill, encoding);
    };

    function allocUnsafe(size) {
      assertSize(size);
      return createBuffer(size < 0 ? 0 : checked(size) | 0);
    }

    Buffer.allocUnsafe = function (size) {
      return allocUnsafe(size);
    };

    Buffer.allocUnsafeSlow = function (size) {
      return allocUnsafe(size);
    };

    function fromString(string, encoding) {
      if (typeof encoding !== 'string' || encoding === '') {
        encoding = 'utf8';
      }

      if (!Buffer.isEncoding(encoding)) {
        throw new TypeError('Unknown encoding: ' + encoding);
      }

      var length = byteLength(string, encoding) | 0;
      var buf = createBuffer(length);
      var actual = buf.write(string, encoding);

      if (actual !== length) {
        buf = buf.slice(0, actual);
      }

      return buf;
    }

    function fromArrayLike(array) {
      var length = array.length < 0 ? 0 : checked(array.length) | 0;
      var buf = createBuffer(length);

      for (var i = 0; i < length; i += 1) {
        buf[i] = array[i] & 255;
      }

      return buf;
    }

    function fromArrayBuffer(array, byteOffset, length) {
      if (byteOffset < 0 || array.byteLength < byteOffset) {
        throw new RangeError('"offset" is outside of buffer bounds');
      }

      if (array.byteLength < byteOffset + (length || 0)) {
        throw new RangeError('"length" is outside of buffer bounds');
      }

      var buf;

      if (byteOffset === undefined && length === undefined) {
        buf = new Uint8Array(array);
      } else if (length === undefined) {
        buf = new Uint8Array(array, byteOffset);
      } else {
        buf = new Uint8Array(array, byteOffset, length);
      }

      buf.__proto__ = Buffer.prototype;
      return buf;
    }

    function fromObject(obj) {
      if (Buffer.isBuffer(obj)) {
        var len = checked(obj.length) | 0;
        var buf = createBuffer(len);

        if (buf.length === 0) {
          return buf;
        }

        obj.copy(buf, 0, 0, len);
        return buf;
      }

      if (obj.length !== undefined) {
        if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
          return createBuffer(0);
        }

        return fromArrayLike(obj);
      }

      if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
        return fromArrayLike(obj.data);
      }
    }

    function checked(length) {
      if (length >= K_MAX_LENGTH) {
        throw new RangeError('Attempt to allocate Buffer larger than maximum ' + 'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes');
      }

      return length | 0;
    }

    function SlowBuffer(length) {
      if (+length != length) {
        length = 0;
      }

      return Buffer.alloc(+length);
    }

    Buffer.isBuffer = function isBuffer(b) {
      return b != null && b._isBuffer === true && b !== Buffer.prototype;
    };

    Buffer.compare = function compare(a, b) {
      if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength);
      if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength);

      if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
        throw new TypeError('The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array');
      }

      if (a === b) return 0;
      var x = a.length;
      var y = b.length;

      for (var i = 0, len = Math.min(x, y); i < len; ++i) {
        if (a[i] !== b[i]) {
          x = a[i];
          y = b[i];
          break;
        }
      }

      if (x < y) return -1;
      if (y < x) return 1;
      return 0;
    };

    Buffer.isEncoding = function isEncoding(encoding) {
      switch (String(encoding).toLowerCase()) {
        case 'hex':
        case 'utf8':
        case 'utf-8':
        case 'ascii':
        case 'latin1':
        case 'binary':
        case 'base64':
        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return true;

        default:
          return false;
      }
    };

    Buffer.concat = function concat(list, length) {
      if (!Array.isArray(list)) {
        throw new TypeError('"list" argument must be an Array of Buffers');
      }

      if (list.length === 0) {
        return Buffer.alloc(0);
      }

      var i;

      if (length === undefined) {
        length = 0;

        for (i = 0; i < list.length; ++i) {
          length += list[i].length;
        }
      }

      var buffer = Buffer.allocUnsafe(length);
      var pos = 0;

      for (i = 0; i < list.length; ++i) {
        var buf = list[i];

        if (isInstance(buf, Uint8Array)) {
          buf = Buffer.from(buf);
        }

        if (!Buffer.isBuffer(buf)) {
          throw new TypeError('"list" argument must be an Array of Buffers');
        }

        buf.copy(buffer, pos);
        pos += buf.length;
      }

      return buffer;
    };

    function byteLength(string, encoding) {
      if (Buffer.isBuffer(string)) {
        return string.length;
      }

      if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
        return string.byteLength;
      }

      if (typeof string !== 'string') {
        throw new TypeError('The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' + 'Received type ' + typeof string);
      }

      var len = string.length;
      var mustMatch = arguments.length > 2 && arguments[2] === true;
      if (!mustMatch && len === 0) return 0;
      var loweredCase = false;

      for (;;) {
        switch (encoding) {
          case 'ascii':
          case 'latin1':
          case 'binary':
            return len;

          case 'utf8':
          case 'utf-8':
            return utf8ToBytes(string).length;

          case 'ucs2':
          case 'ucs-2':
          case 'utf16le':
          case 'utf-16le':
            return len * 2;

          case 'hex':
            return len >>> 1;

          case 'base64':
            return base64ToBytes(string).length;

          default:
            if (loweredCase) {
              return mustMatch ? -1 : utf8ToBytes(string).length;
            }

            encoding = ('' + encoding).toLowerCase();
            loweredCase = true;
        }
      }
    }

    Buffer.byteLength = byteLength;

    function slowToString(encoding, start, end) {
      var loweredCase = false;

      if (start === undefined || start < 0) {
        start = 0;
      }

      if (start > this.length) {
        return '';
      }

      if (end === undefined || end > this.length) {
        end = this.length;
      }

      if (end <= 0) {
        return '';
      }

      end >>>= 0;
      start >>>= 0;

      if (end <= start) {
        return '';
      }

      if (!encoding) encoding = 'utf8';

      while (true) {
        switch (encoding) {
          case 'hex':
            return hexSlice(this, start, end);

          case 'utf8':
          case 'utf-8':
            return utf8Slice(this, start, end);

          case 'ascii':
            return asciiSlice(this, start, end);

          case 'latin1':
          case 'binary':
            return latin1Slice(this, start, end);

          case 'base64':
            return base64Slice(this, start, end);

          case 'ucs2':
          case 'ucs-2':
          case 'utf16le':
          case 'utf-16le':
            return utf16leSlice(this, start, end);

          default:
            if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
            encoding = (encoding + '').toLowerCase();
            loweredCase = true;
        }
      }
    }

    Buffer.prototype._isBuffer = true;

    function swap(b, n, m) {
      var i = b[n];
      b[n] = b[m];
      b[m] = i;
    }

    Buffer.prototype.swap16 = function swap16() {
      var len = this.length;

      if (len % 2 !== 0) {
        throw new RangeError('Buffer size must be a multiple of 16-bits');
      }

      for (var i = 0; i < len; i += 2) {
        swap(this, i, i + 1);
      }

      return this;
    };

    Buffer.prototype.swap32 = function swap32() {
      var len = this.length;

      if (len % 4 !== 0) {
        throw new RangeError('Buffer size must be a multiple of 32-bits');
      }

      for (var i = 0; i < len; i += 4) {
        swap(this, i, i + 3);
        swap(this, i + 1, i + 2);
      }

      return this;
    };

    Buffer.prototype.swap64 = function swap64() {
      var len = this.length;

      if (len % 8 !== 0) {
        throw new RangeError('Buffer size must be a multiple of 64-bits');
      }

      for (var i = 0; i < len; i += 8) {
        swap(this, i, i + 7);
        swap(this, i + 1, i + 6);
        swap(this, i + 2, i + 5);
        swap(this, i + 3, i + 4);
      }

      return this;
    };

    Buffer.prototype.toString = function toString() {
      var length = this.length;
      if (length === 0) return '';
      if (arguments.length === 0) return utf8Slice(this, 0, length);
      return slowToString.apply(this, arguments);
    };

    Buffer.prototype.toLocaleString = Buffer.prototype.toString;

    Buffer.prototype.equals = function equals(b) {
      if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer');
      if (this === b) return true;
      return Buffer.compare(this, b) === 0;
    };

    Buffer.prototype.inspect = function inspect() {
      var str = '';
      var max = exports.INSPECT_MAX_BYTES;
      str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim();
      if (this.length > max) str += ' ... ';
      return '<Buffer ' + str + '>';
    };

    Buffer.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
      if (isInstance(target, Uint8Array)) {
        target = Buffer.from(target, target.offset, target.byteLength);
      }

      if (!Buffer.isBuffer(target)) {
        throw new TypeError('The "target" argument must be one of type Buffer or Uint8Array. ' + 'Received type ' + typeof target);
      }

      if (start === undefined) {
        start = 0;
      }

      if (end === undefined) {
        end = target ? target.length : 0;
      }

      if (thisStart === undefined) {
        thisStart = 0;
      }

      if (thisEnd === undefined) {
        thisEnd = this.length;
      }

      if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
        throw new RangeError('out of range index');
      }

      if (thisStart >= thisEnd && start >= end) {
        return 0;
      }

      if (thisStart >= thisEnd) {
        return -1;
      }

      if (start >= end) {
        return 1;
      }

      start >>>= 0;
      end >>>= 0;
      thisStart >>>= 0;
      thisEnd >>>= 0;
      if (this === target) return 0;
      var x = thisEnd - thisStart;
      var y = end - start;
      var len = Math.min(x, y);
      var thisCopy = this.slice(thisStart, thisEnd);
      var targetCopy = target.slice(start, end);

      for (var i = 0; i < len; ++i) {
        if (thisCopy[i] !== targetCopy[i]) {
          x = thisCopy[i];
          y = targetCopy[i];
          break;
        }
      }

      if (x < y) return -1;
      if (y < x) return 1;
      return 0;
    };

    function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
      if (buffer.length === 0) return -1;

      if (typeof byteOffset === 'string') {
        encoding = byteOffset;
        byteOffset = 0;
      } else if (byteOffset > 0x7fffffff) {
        byteOffset = 0x7fffffff;
      } else if (byteOffset < -0x80000000) {
        byteOffset = -0x80000000;
      }

      byteOffset = +byteOffset;

      if (numberIsNaN(byteOffset)) {
        byteOffset = dir ? 0 : buffer.length - 1;
      }

      if (byteOffset < 0) byteOffset = buffer.length + byteOffset;

      if (byteOffset >= buffer.length) {
        if (dir) return -1;else byteOffset = buffer.length - 1;
      } else if (byteOffset < 0) {
        if (dir) byteOffset = 0;else return -1;
      }

      if (typeof val === 'string') {
        val = Buffer.from(val, encoding);
      }

      if (Buffer.isBuffer(val)) {
        if (val.length === 0) {
          return -1;
        }

        return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
      } else if (typeof val === 'number') {
        val = val & 0xFF;

        if (typeof Uint8Array.prototype.indexOf === 'function') {
          if (dir) {
            return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset);
          } else {
            return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset);
          }
        }

        return arrayIndexOf(buffer, [val], byteOffset, encoding, dir);
      }

      throw new TypeError('val must be string, number or Buffer');
    }

    function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
      var indexSize = 1;
      var arrLength = arr.length;
      var valLength = val.length;

      if (encoding !== undefined) {
        encoding = String(encoding).toLowerCase();

        if (encoding === 'ucs2' || encoding === 'ucs-2' || encoding === 'utf16le' || encoding === 'utf-16le') {
          if (arr.length < 2 || val.length < 2) {
            return -1;
          }

          indexSize = 2;
          arrLength /= 2;
          valLength /= 2;
          byteOffset /= 2;
        }
      }

      function read(buf, i) {
        if (indexSize === 1) {
          return buf[i];
        } else {
          return buf.readUInt16BE(i * indexSize);
        }
      }

      var i;

      if (dir) {
        var foundIndex = -1;

        for (i = byteOffset; i < arrLength; i++) {
          if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
            if (foundIndex === -1) foundIndex = i;
            if (i - foundIndex + 1 === valLength) return foundIndex * indexSize;
          } else {
            if (foundIndex !== -1) i -= i - foundIndex;
            foundIndex = -1;
          }
        }
      } else {
        if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;

        for (i = byteOffset; i >= 0; i--) {
          var found = true;

          for (var j = 0; j < valLength; j++) {
            if (read(arr, i + j) !== read(val, j)) {
              found = false;
              break;
            }
          }

          if (found) return i;
        }
      }

      return -1;
    }

    Buffer.prototype.includes = function includes(val, byteOffset, encoding) {
      return this.indexOf(val, byteOffset, encoding) !== -1;
    };

    Buffer.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
      return bidirectionalIndexOf(this, val, byteOffset, encoding, true);
    };

    Buffer.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
      return bidirectionalIndexOf(this, val, byteOffset, encoding, false);
    };

    function hexWrite(buf, string, offset, length) {
      offset = Number(offset) || 0;
      var remaining = buf.length - offset;

      if (!length) {
        length = remaining;
      } else {
        length = Number(length);

        if (length > remaining) {
          length = remaining;
        }
      }

      var strLen = string.length;

      if (length > strLen / 2) {
        length = strLen / 2;
      }

      for (var i = 0; i < length; ++i) {
        var parsed = parseInt(string.substr(i * 2, 2), 16);
        if (numberIsNaN(parsed)) return i;
        buf[offset + i] = parsed;
      }

      return i;
    }

    function utf8Write(buf, string, offset, length) {
      return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
    }

    function asciiWrite(buf, string, offset, length) {
      return blitBuffer(asciiToBytes(string), buf, offset, length);
    }

    function latin1Write(buf, string, offset, length) {
      return asciiWrite(buf, string, offset, length);
    }

    function base64Write(buf, string, offset, length) {
      return blitBuffer(base64ToBytes(string), buf, offset, length);
    }

    function ucs2Write(buf, string, offset, length) {
      return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
    }

    Buffer.prototype.write = function write(string, offset, length, encoding) {
      if (offset === undefined) {
        encoding = 'utf8';
        length = this.length;
        offset = 0;
      } else if (length === undefined && typeof offset === 'string') {
        encoding = offset;
        length = this.length;
        offset = 0;
      } else if (isFinite(offset)) {
        offset = offset >>> 0;

        if (isFinite(length)) {
          length = length >>> 0;
          if (encoding === undefined) encoding = 'utf8';
        } else {
          encoding = length;
          length = undefined;
        }
      } else {
        throw new Error('Buffer.write(string, encoding, offset[, length]) is no longer supported');
      }

      var remaining = this.length - offset;
      if (length === undefined || length > remaining) length = remaining;

      if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
        throw new RangeError('Attempt to write outside buffer bounds');
      }

      if (!encoding) encoding = 'utf8';
      var loweredCase = false;

      for (;;) {
        switch (encoding) {
          case 'hex':
            return hexWrite(this, string, offset, length);

          case 'utf8':
          case 'utf-8':
            return utf8Write(this, string, offset, length);

          case 'ascii':
            return asciiWrite(this, string, offset, length);

          case 'latin1':
          case 'binary':
            return latin1Write(this, string, offset, length);

          case 'base64':
            return base64Write(this, string, offset, length);

          case 'ucs2':
          case 'ucs-2':
          case 'utf16le':
          case 'utf-16le':
            return ucs2Write(this, string, offset, length);

          default:
            if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
            encoding = ('' + encoding).toLowerCase();
            loweredCase = true;
        }
      }
    };

    Buffer.prototype.toJSON = function toJSON() {
      return {
        type: 'Buffer',
        data: Array.prototype.slice.call(this._arr || this, 0)
      };
    };

    function base64Slice(buf, start, end) {
      if (start === 0 && end === buf.length) {
        return base64Js.fromByteArray(buf);
      } else {
        return base64Js.fromByteArray(buf.slice(start, end));
      }
    }

    function utf8Slice(buf, start, end) {
      end = Math.min(buf.length, end);
      var res = [];
      var i = start;

      while (i < end) {
        var firstByte = buf[i];
        var codePoint = null;
        var bytesPerSequence = firstByte > 0xEF ? 4 : firstByte > 0xDF ? 3 : firstByte > 0xBF ? 2 : 1;

        if (i + bytesPerSequence <= end) {
          var secondByte, thirdByte, fourthByte, tempCodePoint;

          switch (bytesPerSequence) {
            case 1:
              if (firstByte < 0x80) {
                codePoint = firstByte;
              }

              break;

            case 2:
              secondByte = buf[i + 1];

              if ((secondByte & 0xC0) === 0x80) {
                tempCodePoint = (firstByte & 0x1F) << 0x6 | secondByte & 0x3F;

                if (tempCodePoint > 0x7F) {
                  codePoint = tempCodePoint;
                }
              }

              break;

            case 3:
              secondByte = buf[i + 1];
              thirdByte = buf[i + 2];

              if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
                tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | thirdByte & 0x3F;

                if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
                  codePoint = tempCodePoint;
                }
              }

              break;

            case 4:
              secondByte = buf[i + 1];
              thirdByte = buf[i + 2];
              fourthByte = buf[i + 3];

              if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
                tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | fourthByte & 0x3F;

                if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
                  codePoint = tempCodePoint;
                }
              }

          }
        }

        if (codePoint === null) {
          codePoint = 0xFFFD;
          bytesPerSequence = 1;
        } else if (codePoint > 0xFFFF) {
          codePoint -= 0x10000;
          res.push(codePoint >>> 10 & 0x3FF | 0xD800);
          codePoint = 0xDC00 | codePoint & 0x3FF;
        }

        res.push(codePoint);
        i += bytesPerSequence;
      }

      return decodeCodePointsArray(res);
    }

    var MAX_ARGUMENTS_LENGTH = 0x1000;

    function decodeCodePointsArray(codePoints) {
      var len = codePoints.length;

      if (len <= MAX_ARGUMENTS_LENGTH) {
        return String.fromCharCode.apply(String, codePoints);
      }

      var res = '';
      var i = 0;

      while (i < len) {
        res += String.fromCharCode.apply(String, codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH));
      }

      return res;
    }

    function asciiSlice(buf, start, end) {
      var ret = '';
      end = Math.min(buf.length, end);

      for (var i = start; i < end; ++i) {
        ret += String.fromCharCode(buf[i] & 0x7F);
      }

      return ret;
    }

    function latin1Slice(buf, start, end) {
      var ret = '';
      end = Math.min(buf.length, end);

      for (var i = start; i < end; ++i) {
        ret += String.fromCharCode(buf[i]);
      }

      return ret;
    }

    function hexSlice(buf, start, end) {
      var len = buf.length;
      if (!start || start < 0) start = 0;
      if (!end || end < 0 || end > len) end = len;
      var out = '';

      for (var i = start; i < end; ++i) {
        out += toHex(buf[i]);
      }

      return out;
    }

    function utf16leSlice(buf, start, end) {
      var bytes = buf.slice(start, end);
      var res = '';

      for (var i = 0; i < bytes.length; i += 2) {
        res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
      }

      return res;
    }

    Buffer.prototype.slice = function slice(start, end) {
      var len = this.length;
      start = ~~start;
      end = end === undefined ? len : ~~end;

      if (start < 0) {
        start += len;
        if (start < 0) start = 0;
      } else if (start > len) {
        start = len;
      }

      if (end < 0) {
        end += len;
        if (end < 0) end = 0;
      } else if (end > len) {
        end = len;
      }

      if (end < start) end = start;
      var newBuf = this.subarray(start, end);
      newBuf.__proto__ = Buffer.prototype;
      return newBuf;
    };

    function checkOffset(offset, ext, length) {
      if (offset % 1 !== 0 || offset < 0) throw new RangeError('offset is not uint');
      if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length');
    }

    Buffer.prototype.readUIntLE = function readUIntLE(offset, byteLength, noAssert) {
      offset = offset >>> 0;
      byteLength = byteLength >>> 0;
      if (!noAssert) checkOffset(offset, byteLength, this.length);
      var val = this[offset];
      var mul = 1;
      var i = 0;

      while (++i < byteLength && (mul *= 0x100)) {
        val += this[offset + i] * mul;
      }

      return val;
    };

    Buffer.prototype.readUIntBE = function readUIntBE(offset, byteLength, noAssert) {
      offset = offset >>> 0;
      byteLength = byteLength >>> 0;

      if (!noAssert) {
        checkOffset(offset, byteLength, this.length);
      }

      var val = this[offset + --byteLength];
      var mul = 1;

      while (byteLength > 0 && (mul *= 0x100)) {
        val += this[offset + --byteLength] * mul;
      }

      return val;
    };

    Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 1, this.length);
      return this[offset];
    };

    Buffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 2, this.length);
      return this[offset] | this[offset + 1] << 8;
    };

    Buffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 2, this.length);
      return this[offset] << 8 | this[offset + 1];
    };

    Buffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 4, this.length);
      return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 0x1000000;
    };

    Buffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 4, this.length);
      return this[offset] * 0x1000000 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
    };

    Buffer.prototype.readIntLE = function readIntLE(offset, byteLength, noAssert) {
      offset = offset >>> 0;
      byteLength = byteLength >>> 0;
      if (!noAssert) checkOffset(offset, byteLength, this.length);
      var val = this[offset];
      var mul = 1;
      var i = 0;

      while (++i < byteLength && (mul *= 0x100)) {
        val += this[offset + i] * mul;
      }

      mul *= 0x80;
      if (val >= mul) val -= Math.pow(2, 8 * byteLength);
      return val;
    };

    Buffer.prototype.readIntBE = function readIntBE(offset, byteLength, noAssert) {
      offset = offset >>> 0;
      byteLength = byteLength >>> 0;
      if (!noAssert) checkOffset(offset, byteLength, this.length);
      var i = byteLength;
      var mul = 1;
      var val = this[offset + --i];

      while (i > 0 && (mul *= 0x100)) {
        val += this[offset + --i] * mul;
      }

      mul *= 0x80;
      if (val >= mul) val -= Math.pow(2, 8 * byteLength);
      return val;
    };

    Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 1, this.length);
      if (!(this[offset] & 0x80)) return this[offset];
      return (0xff - this[offset] + 1) * -1;
    };

    Buffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 2, this.length);
      var val = this[offset] | this[offset + 1] << 8;
      return val & 0x8000 ? val | 0xFFFF0000 : val;
    };

    Buffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 2, this.length);
      var val = this[offset + 1] | this[offset] << 8;
      return val & 0x8000 ? val | 0xFFFF0000 : val;
    };

    Buffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 4, this.length);
      return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
    };

    Buffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 4, this.length);
      return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
    };

    Buffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 4, this.length);
      return ieee754.read(this, offset, true, 23, 4);
    };

    Buffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 4, this.length);
      return ieee754.read(this, offset, false, 23, 4);
    };

    Buffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 8, this.length);
      return ieee754.read(this, offset, true, 52, 8);
    };

    Buffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset(offset, 8, this.length);
      return ieee754.read(this, offset, false, 52, 8);
    };

    function checkInt(buf, value, offset, ext, max, min) {
      if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
      if (value > max || value < min) throw new RangeError('"value" argument is out of bounds');
      if (offset + ext > buf.length) throw new RangeError('Index out of range');
    }

    Buffer.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength, noAssert) {
      value = +value;
      offset = offset >>> 0;
      byteLength = byteLength >>> 0;

      if (!noAssert) {
        var maxBytes = Math.pow(2, 8 * byteLength) - 1;
        checkInt(this, value, offset, byteLength, maxBytes, 0);
      }

      var mul = 1;
      var i = 0;
      this[offset] = value & 0xFF;

      while (++i < byteLength && (mul *= 0x100)) {
        this[offset + i] = value / mul & 0xFF;
      }

      return offset + byteLength;
    };

    Buffer.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength, noAssert) {
      value = +value;
      offset = offset >>> 0;
      byteLength = byteLength >>> 0;

      if (!noAssert) {
        var maxBytes = Math.pow(2, 8 * byteLength) - 1;
        checkInt(this, value, offset, byteLength, maxBytes, 0);
      }

      var i = byteLength - 1;
      var mul = 1;
      this[offset + i] = value & 0xFF;

      while (--i >= 0 && (mul *= 0x100)) {
        this[offset + i] = value / mul & 0xFF;
      }

      return offset + byteLength;
    };

    Buffer.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
      this[offset] = value & 0xff;
      return offset + 1;
    };

    Buffer.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
      this[offset] = value & 0xff;
      this[offset + 1] = value >>> 8;
      return offset + 2;
    };

    Buffer.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
      this[offset] = value >>> 8;
      this[offset + 1] = value & 0xff;
      return offset + 2;
    };

    Buffer.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
      this[offset + 3] = value >>> 24;
      this[offset + 2] = value >>> 16;
      this[offset + 1] = value >>> 8;
      this[offset] = value & 0xff;
      return offset + 4;
    };

    Buffer.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
      this[offset] = value >>> 24;
      this[offset + 1] = value >>> 16;
      this[offset + 2] = value >>> 8;
      this[offset + 3] = value & 0xff;
      return offset + 4;
    };

    Buffer.prototype.writeIntLE = function writeIntLE(value, offset, byteLength, noAssert) {
      value = +value;
      offset = offset >>> 0;

      if (!noAssert) {
        var limit = Math.pow(2, 8 * byteLength - 1);
        checkInt(this, value, offset, byteLength, limit - 1, -limit);
      }

      var i = 0;
      var mul = 1;
      var sub = 0;
      this[offset] = value & 0xFF;

      while (++i < byteLength && (mul *= 0x100)) {
        if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
          sub = 1;
        }

        this[offset + i] = (value / mul >> 0) - sub & 0xFF;
      }

      return offset + byteLength;
    };

    Buffer.prototype.writeIntBE = function writeIntBE(value, offset, byteLength, noAssert) {
      value = +value;
      offset = offset >>> 0;

      if (!noAssert) {
        var limit = Math.pow(2, 8 * byteLength - 1);
        checkInt(this, value, offset, byteLength, limit - 1, -limit);
      }

      var i = byteLength - 1;
      var mul = 1;
      var sub = 0;
      this[offset + i] = value & 0xFF;

      while (--i >= 0 && (mul *= 0x100)) {
        if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
          sub = 1;
        }

        this[offset + i] = (value / mul >> 0) - sub & 0xFF;
      }

      return offset + byteLength;
    };

    Buffer.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
      if (value < 0) value = 0xff + value + 1;
      this[offset] = value & 0xff;
      return offset + 1;
    };

    Buffer.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
      this[offset] = value & 0xff;
      this[offset + 1] = value >>> 8;
      return offset + 2;
    };

    Buffer.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
      this[offset] = value >>> 8;
      this[offset + 1] = value & 0xff;
      return offset + 2;
    };

    Buffer.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
      this[offset] = value & 0xff;
      this[offset + 1] = value >>> 8;
      this[offset + 2] = value >>> 16;
      this[offset + 3] = value >>> 24;
      return offset + 4;
    };

    Buffer.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
      if (value < 0) value = 0xffffffff + value + 1;
      this[offset] = value >>> 24;
      this[offset + 1] = value >>> 16;
      this[offset + 2] = value >>> 8;
      this[offset + 3] = value & 0xff;
      return offset + 4;
    };

    function checkIEEE754(buf, value, offset, ext, max, min) {
      if (offset + ext > buf.length) throw new RangeError('Index out of range');
      if (offset < 0) throw new RangeError('Index out of range');
    }

    function writeFloat(buf, value, offset, littleEndian, noAssert) {
      value = +value;
      offset = offset >>> 0;

      if (!noAssert) {
        checkIEEE754(buf, value, offset, 4);
      }

      ieee754.write(buf, value, offset, littleEndian, 23, 4);
      return offset + 4;
    }

    Buffer.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
      return writeFloat(this, value, offset, true, noAssert);
    };

    Buffer.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
      return writeFloat(this, value, offset, false, noAssert);
    };

    function writeDouble(buf, value, offset, littleEndian, noAssert) {
      value = +value;
      offset = offset >>> 0;

      if (!noAssert) {
        checkIEEE754(buf, value, offset, 8);
      }

      ieee754.write(buf, value, offset, littleEndian, 52, 8);
      return offset + 8;
    }

    Buffer.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
      return writeDouble(this, value, offset, true, noAssert);
    };

    Buffer.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
      return writeDouble(this, value, offset, false, noAssert);
    };

    Buffer.prototype.copy = function copy(target, targetStart, start, end) {
      if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer');
      if (!start) start = 0;
      if (!end && end !== 0) end = this.length;
      if (targetStart >= target.length) targetStart = target.length;
      if (!targetStart) targetStart = 0;
      if (end > 0 && end < start) end = start;
      if (end === start) return 0;
      if (target.length === 0 || this.length === 0) return 0;

      if (targetStart < 0) {
        throw new RangeError('targetStart out of bounds');
      }

      if (start < 0 || start >= this.length) throw new RangeError('Index out of range');
      if (end < 0) throw new RangeError('sourceEnd out of bounds');
      if (end > this.length) end = this.length;

      if (target.length - targetStart < end - start) {
        end = target.length - targetStart + start;
      }

      var len = end - start;

      if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
        this.copyWithin(targetStart, start, end);
      } else if (this === target && start < targetStart && targetStart < end) {
        for (var i = len - 1; i >= 0; --i) {
          target[i + targetStart] = this[i + start];
        }
      } else {
        Uint8Array.prototype.set.call(target, this.subarray(start, end), targetStart);
      }

      return len;
    };

    Buffer.prototype.fill = function fill(val, start, end, encoding) {
      if (typeof val === 'string') {
        if (typeof start === 'string') {
          encoding = start;
          start = 0;
          end = this.length;
        } else if (typeof end === 'string') {
          encoding = end;
          end = this.length;
        }

        if (encoding !== undefined && typeof encoding !== 'string') {
          throw new TypeError('encoding must be a string');
        }

        if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
          throw new TypeError('Unknown encoding: ' + encoding);
        }

        if (val.length === 1) {
          var code = val.charCodeAt(0);

          if (encoding === 'utf8' && code < 128 || encoding === 'latin1') {
            val = code;
          }
        }
      } else if (typeof val === 'number') {
        val = val & 255;
      }

      if (start < 0 || this.length < start || this.length < end) {
        throw new RangeError('Out of range index');
      }

      if (end <= start) {
        return this;
      }

      start = start >>> 0;
      end = end === undefined ? this.length : end >>> 0;
      if (!val) val = 0;
      var i;

      if (typeof val === 'number') {
        for (i = start; i < end; ++i) {
          this[i] = val;
        }
      } else {
        var bytes = Buffer.isBuffer(val) ? val : Buffer.from(val, encoding);
        var len = bytes.length;

        if (len === 0) {
          throw new TypeError('The value "' + val + '" is invalid for argument "value"');
        }

        for (i = 0; i < end - start; ++i) {
          this[i + start] = bytes[i % len];
        }
      }

      return this;
    };

    var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;

    function base64clean(str) {
      str = str.split('=')[0];
      str = str.trim().replace(INVALID_BASE64_RE, '');
      if (str.length < 2) return '';

      while (str.length % 4 !== 0) {
        str = str + '=';
      }

      return str;
    }

    function toHex(n) {
      if (n < 16) return '0' + n.toString(16);
      return n.toString(16);
    }

    function utf8ToBytes(string, units) {
      units = units || Infinity;
      var codePoint;
      var length = string.length;
      var leadSurrogate = null;
      var bytes = [];

      for (var i = 0; i < length; ++i) {
        codePoint = string.charCodeAt(i);

        if (codePoint > 0xD7FF && codePoint < 0xE000) {
          if (!leadSurrogate) {
            if (codePoint > 0xDBFF) {
              if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
              continue;
            } else if (i + 1 === length) {
              if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
              continue;
            }

            leadSurrogate = codePoint;
            continue;
          }

          if (codePoint < 0xDC00) {
            if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
            leadSurrogate = codePoint;
            continue;
          }

          codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
        } else if (leadSurrogate) {
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
        }

        leadSurrogate = null;

        if (codePoint < 0x80) {
          if ((units -= 1) < 0) break;
          bytes.push(codePoint);
        } else if (codePoint < 0x800) {
          if ((units -= 2) < 0) break;
          bytes.push(codePoint >> 0x6 | 0xC0, codePoint & 0x3F | 0x80);
        } else if (codePoint < 0x10000) {
          if ((units -= 3) < 0) break;
          bytes.push(codePoint >> 0xC | 0xE0, codePoint >> 0x6 & 0x3F | 0x80, codePoint & 0x3F | 0x80);
        } else if (codePoint < 0x110000) {
          if ((units -= 4) < 0) break;
          bytes.push(codePoint >> 0x12 | 0xF0, codePoint >> 0xC & 0x3F | 0x80, codePoint >> 0x6 & 0x3F | 0x80, codePoint & 0x3F | 0x80);
        } else {
          throw new Error('Invalid code point');
        }
      }

      return bytes;
    }

    function asciiToBytes(str) {
      var byteArray = [];

      for (var i = 0; i < str.length; ++i) {
        byteArray.push(str.charCodeAt(i) & 0xFF);
      }

      return byteArray;
    }

    function utf16leToBytes(str, units) {
      var c, hi, lo;
      var byteArray = [];

      for (var i = 0; i < str.length; ++i) {
        if ((units -= 2) < 0) break;
        c = str.charCodeAt(i);
        hi = c >> 8;
        lo = c % 256;
        byteArray.push(lo);
        byteArray.push(hi);
      }

      return byteArray;
    }

    function base64ToBytes(str) {
      return base64Js.toByteArray(base64clean(str));
    }

    function blitBuffer(src, dst, offset, length) {
      for (var i = 0; i < length; ++i) {
        if (i + offset >= dst.length || i >= src.length) break;
        dst[i + offset] = src[i];
      }

      return i;
    }

    function isInstance(obj, type) {
      return obj instanceof type || obj != null && obj.constructor != null && obj.constructor.name != null && obj.constructor.name === type.name;
    }

    function numberIsNaN(obj) {
      return obj !== obj;
    }
  }, "/$$rollup_base$$/node_modules/buffer");

  var object = {};
  var hasOwnProperty$2 = object.hasOwnProperty;

  var forOwn = function forOwn(object, callback) {
    for (var key in object) {
      if (hasOwnProperty$2.call(object, key)) {
        callback(key, object[key]);
      }
    }
  };

  var extend = function extend(destination, source) {
    if (!source) {
      return destination;
    }

    forOwn(source, function (key, value) {
      destination[key] = value;
    });
    return destination;
  };

  var forEach = function forEach(array, callback) {
    var length = array.length;
    var index = -1;

    while (++index < length) {
      callback(array[index]);
    }
  };

  var toString = object.toString;
  var isArray$1 = Array.isArray;
  var isBuffer = buffer.Buffer.isBuffer;

  var isObject = function isObject(value) {
    return toString.call(value) == '[object Object]';
  };

  var isString = function isString(value) {
    return typeof value == 'string' || toString.call(value) == '[object String]';
  };

  var isNumber = function isNumber(value) {
    return typeof value == 'number' || toString.call(value) == '[object Number]';
  };

  var isFunction$2 = function isFunction(value) {
    return typeof value == 'function';
  };

  var isMap = function isMap(value) {
    return toString.call(value) == '[object Map]';
  };

  var isSet = function isSet(value) {
    return toString.call(value) == '[object Set]';
  };

  var singleEscapes = {
    '"': '\\"',
    '\'': '\\\'',
    '\\': '\\\\',
    '\b': '\\b',
    '\f': '\\f',
    '\n': '\\n',
    '\r': '\\r',
    '\t': '\\t'
  };
  var regexSingleEscape = /["'\\\b\f\n\r\t]/;
  var regexDigit = /[0-9]/;
  var regexWhitelist = /[ !#-&\(-\[\]-_a-~]/;

  var jsesc$1 = function jsesc(argument, options) {
    var increaseIndentation = function increaseIndentation() {
      oldIndent = indent;
      ++options.indentLevel;
      indent = options.indent.repeat(options.indentLevel);
    };

    var defaults = {
      'escapeEverything': false,
      'minimal': false,
      'isScriptContext': false,
      'quotes': 'single',
      'wrap': false,
      'es6': false,
      'json': false,
      'compact': true,
      'lowercaseHex': false,
      'numbers': 'decimal',
      'indent': '\t',
      'indentLevel': 0,
      '__inline1__': false,
      '__inline2__': false
    };
    var json = options && options.json;

    if (json) {
      defaults.quotes = 'double';
      defaults.wrap = true;
    }

    options = extend(defaults, options);

    if (options.quotes != 'single' && options.quotes != 'double' && options.quotes != 'backtick') {
      options.quotes = 'single';
    }

    var quote = options.quotes == 'double' ? '"' : options.quotes == 'backtick' ? '`' : '\'';
    var compact = options.compact;
    var lowercaseHex = options.lowercaseHex;
    var indent = options.indent.repeat(options.indentLevel);
    var oldIndent = '';
    var inline1 = options.__inline1__;
    var inline2 = options.__inline2__;
    var newLine = compact ? '' : '\n';
    var result;
    var isEmpty = true;
    var useBinNumbers = options.numbers == 'binary';
    var useOctNumbers = options.numbers == 'octal';
    var useDecNumbers = options.numbers == 'decimal';
    var useHexNumbers = options.numbers == 'hexadecimal';

    if (json && argument && isFunction$2(argument.toJSON)) {
      argument = argument.toJSON();
    }

    if (!isString(argument)) {
      if (isMap(argument)) {
        if (argument.size == 0) {
          return 'new Map()';
        }

        if (!compact) {
          options.__inline1__ = true;
          options.__inline2__ = false;
        }

        return 'new Map(' + jsesc(Array.from(argument), options) + ')';
      }

      if (isSet(argument)) {
        if (argument.size == 0) {
          return 'new Set()';
        }

        return 'new Set(' + jsesc(Array.from(argument), options) + ')';
      }

      if (isBuffer(argument)) {
        if (argument.length == 0) {
          return 'Buffer.from([])';
        }

        return 'Buffer.from(' + jsesc(Array.from(argument), options) + ')';
      }

      if (isArray$1(argument)) {
        result = [];
        options.wrap = true;

        if (inline1) {
          options.__inline1__ = false;
          options.__inline2__ = true;
        }

        if (!inline2) {
          increaseIndentation();
        }

        forEach(argument, function (value) {
          isEmpty = false;

          if (inline2) {
            options.__inline2__ = false;
          }

          result.push((compact || inline2 ? '' : indent) + jsesc(value, options));
        });

        if (isEmpty) {
          return '[]';
        }

        if (inline2) {
          return '[' + result.join(', ') + ']';
        }

        return '[' + newLine + result.join(',' + newLine) + newLine + (compact ? '' : oldIndent) + ']';
      } else if (isNumber(argument)) {
        if (json) {
          return JSON.stringify(argument);
        }

        if (useDecNumbers) {
          return String(argument);
        }

        if (useHexNumbers) {
          var hexadecimal = argument.toString(16);

          if (!lowercaseHex) {
            hexadecimal = hexadecimal.toUpperCase();
          }

          return '0x' + hexadecimal;
        }

        if (useBinNumbers) {
          return '0b' + argument.toString(2);
        }

        if (useOctNumbers) {
          return '0o' + argument.toString(8);
        }
      } else if (!isObject(argument)) {
        if (json) {
          return JSON.stringify(argument) || 'null';
        }

        return String(argument);
      } else {
        result = [];
        options.wrap = true;
        increaseIndentation();
        forOwn(argument, function (key, value) {
          isEmpty = false;
          result.push((compact ? '' : indent) + jsesc(key, options) + ':' + (compact ? '' : ' ') + jsesc(value, options));
        });

        if (isEmpty) {
          return '{}';
        }

        return '{' + newLine + result.join(',' + newLine) + newLine + (compact ? '' : oldIndent) + '}';
      }
    }

    var string = argument;
    var index = -1;
    var length = string.length;
    result = '';

    while (++index < length) {
      var character = string.charAt(index);

      if (options.es6) {
        var first = string.charCodeAt(index);

        if (first >= 0xD800 && first <= 0xDBFF && length > index + 1) {
          var second = string.charCodeAt(index + 1);

          if (second >= 0xDC00 && second <= 0xDFFF) {
            var codePoint = (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;

            var _hexadecimal2 = codePoint.toString(16);

            if (!lowercaseHex) {
              _hexadecimal2 = _hexadecimal2.toUpperCase();
            }

            result += "\\u{" + _hexadecimal2 + '}';
            ++index;
            continue;
          }
        }
      }

      if (!options.escapeEverything) {
        if (regexWhitelist.test(character)) {
          result += character;
          continue;
        }

        if (character == '"') {
          result += quote == character ? '\\"' : character;
          continue;
        }

        if (character == '`') {
          result += quote == character ? '\\`' : character;
          continue;
        }

        if (character == '\'') {
          result += quote == character ? '\\\'' : character;
          continue;
        }
      }

      if (character == '\0' && !json && !regexDigit.test(string.charAt(index + 1))) {
        result += '\\0';
        continue;
      }

      if (regexSingleEscape.test(character)) {
        result += singleEscapes[character];
        continue;
      }

      var charCode = character.charCodeAt(0);

      if (options.minimal && charCode != 0x2028 && charCode != 0x2029) {
        result += character;
        continue;
      }

      var _hexadecimal = charCode.toString(16);

      if (!lowercaseHex) {
        _hexadecimal = _hexadecimal.toUpperCase();
      }

      var longhand = _hexadecimal.length > 2 || json;

      var escaped = '\\' + (longhand ? 'u' : 'x') + ('0000' + _hexadecimal).slice(longhand ? -4 : -2);

      result += escaped;
      continue;
    }

    if (options.wrap) {
      result = quote + result + quote;
    }

    if (quote == '`') {
      result = result.replace(/\$\{/g, '\\\$\{');
    }

    if (options.isScriptContext) {
      return result.replace(/<\/(script|style)/gi, '<\\/$1').replace(/<!--/g, json ? "\\u003C!--" : '\\x3C!--');
    }

    return result;
  };

  jsesc$1.version = '2.5.2';
  var jsesc_1 = jsesc$1;

  var jsesc = jsesc_1;

  var isAssignmentPattern$2 = isAssignmentPattern$3,
      isIdentifier$b = isIdentifier$g;
  function Identifier(node) {
    var _this = this;

    this.exactSource(node.loc, function () {
      _this.word(node.name);
    });
  }
  function ArgumentPlaceholder() {
    this.token("?");
  }
  function RestElement$1(node) {
    this.token("...");
    this.print(node.argument, node);
  }
  function ObjectExpression$1(node) {
    var props = node.properties;
    this.token("{");
    this.printInnerComments(node);

    if (props.length) {
      this.space();
      this.printList(props, node, {
        indent: true,
        statement: true
      });
      this.space();
    }

    this.token("}");
  }
  function ObjectMethod(node) {
    this.printJoin(node.decorators, node);

    this._methodHead(node);

    this.space();
    this.print(node.body, node);
  }
  function ObjectProperty(node) {
    this.printJoin(node.decorators, node);

    if (node.computed) {
      this.token("[");
      this.print(node.key, node);
      this.token("]");
    } else {
      if (isAssignmentPattern$2(node.value) && isIdentifier$b(node.key) && node.key.name === node.value.left.name) {
        this.print(node.value, node);
        return;
      }

      this.print(node.key, node);

      if (node.shorthand && isIdentifier$b(node.key) && isIdentifier$b(node.value) && node.key.name === node.value.name) {
        return;
      }
    }

    this.token(":");
    this.space();
    this.print(node.value, node);
  }
  function ArrayExpression$1(node) {
    var elems = node.elements;
    var len = elems.length;
    this.token("[");
    this.printInnerComments(node);

    for (var i = 0; i < elems.length; i++) {
      var elem = elems[i];

      if (elem) {
        if (i > 0) this.space();
        this.print(elem, node);
        if (i < len - 1) this.token(",");
      } else {
        this.token(",");
      }
    }

    this.token("]");
  }
  function RecordExpression(node) {
    var props = node.properties;
    var startToken;
    var endToken;

    if (this.format.recordAndTupleSyntaxType === "bar") {
      startToken = "{|";
      endToken = "|}";
    } else if (this.format.recordAndTupleSyntaxType === "hash") {
      startToken = "#{";
      endToken = "}";
    } else {
      throw new Error("The \"recordAndTupleSyntaxType\" generator option must be \"bar\" or \"hash\" (" + JSON.stringify(this.format.recordAndTupleSyntaxType) + " received).");
    }

    this.token(startToken);
    this.printInnerComments(node);

    if (props.length) {
      this.space();
      this.printList(props, node, {
        indent: true,
        statement: true
      });
      this.space();
    }

    this.token(endToken);
  }
  function TupleExpression(node) {
    var elems = node.elements;
    var len = elems.length;
    var startToken;
    var endToken;

    if (this.format.recordAndTupleSyntaxType === "bar") {
      startToken = "[|";
      endToken = "|]";
    } else if (this.format.recordAndTupleSyntaxType === "hash") {
      startToken = "#[";
      endToken = "]";
    } else {
      throw new Error(this.format.recordAndTupleSyntaxType + " is not a valid recordAndTuple syntax type");
    }

    this.token(startToken);
    this.printInnerComments(node);

    for (var i = 0; i < elems.length; i++) {
      var elem = elems[i];

      if (elem) {
        if (i > 0) this.space();
        this.print(elem, node);
        if (i < len - 1) this.token(",");
      }
    }

    this.token(endToken);
  }
  function RegExpLiteral$1(node) {
    this.word("/" + node.pattern + "/" + node.flags);
  }
  function BooleanLiteral$1(node) {
    this.word(node.value ? "true" : "false");
  }
  function NullLiteral$1() {
    this.word("null");
  }
  function NumericLiteral$2(node) {
    var raw = this.getPossibleRaw(node);
    var opts = this.format.jsescOption;
    var value = node.value + "";

    if (opts.numbers) {
      this.number(jsesc(node.value, opts));
    } else if (raw == null) {
      this.number(value);
    } else if (this.format.minified) {
      this.number(raw.length < value.length ? raw : value);
    } else {
      this.number(raw);
    }
  }
  function StringLiteral$2(node) {
    var raw = this.getPossibleRaw(node);

    if (!this.format.minified && raw != null) {
      this.token(raw);
      return;
    }

    var val = jsesc(node.value, Object.assign(this.format.jsescOption, this.format.jsonCompatibleStrings && {
      json: true
    }));
    return this.token(val);
  }
  function BigIntLiteral(node) {
    var raw = this.getPossibleRaw(node);

    if (!this.format.minified && raw != null) {
      this.word(raw);
      return;
    }

    this.word(node.value + "n");
  }
  function DecimalLiteral(node) {
    var raw = this.getPossibleRaw(node);

    if (!this.format.minified && raw != null) {
      this.word(raw);
      return;
    }

    this.word(node.value + "m");
  }
  function TopicReference() {
    var topicToken = this.format.topicToken;

    switch (topicToken) {
      case "#":
        this.token("#");
        break;

      default:
        {
          var givenTopicTokenJSON = JSON.stringify(topicToken);
          var message = "The \"topicToken\" generator option must be \"#\" (" + givenTopicTokenJSON + " received instead).";
          throw new Error(message);
        }
    }
  }
  function PipelineTopicExpression(node) {
    this.print(node.expression, node);
  }
  function PipelineBareFunction(node) {
    this.print(node.callee, node);
  }
  function PipelinePrimaryTopicReference() {
    this.token("#");
  }

  var isDeclareExportDeclaration = isDeclareExportDeclaration$1,
      isStatement$3 = isStatement$7;
  function AnyTypeAnnotation() {
    this.word("any");
  }
  function ArrayTypeAnnotation(node) {
    this.print(node.elementType, node);
    this.token("[");
    this.token("]");
  }
  function BooleanTypeAnnotation() {
    this.word("boolean");
  }
  function BooleanLiteralTypeAnnotation(node) {
    this.word(node.value ? "true" : "false");
  }
  function NullLiteralTypeAnnotation() {
    this.word("null");
  }
  function DeclareClass(node, parent) {
    if (!isDeclareExportDeclaration(parent)) {
      this.word("declare");
      this.space();
    }

    this.word("class");
    this.space();

    this._interfaceish(node);
  }
  function DeclareFunction(node, parent) {
    if (!isDeclareExportDeclaration(parent)) {
      this.word("declare");
      this.space();
    }

    this.word("function");
    this.space();
    this.print(node.id, node);
    this.print(node.id.typeAnnotation.typeAnnotation, node);

    if (node.predicate) {
      this.space();
      this.print(node.predicate, node);
    }

    this.semicolon();
  }
  function InferredPredicate() {
    this.token("%");
    this.word("checks");
  }
  function DeclaredPredicate(node) {
    this.token("%");
    this.word("checks");
    this.token("(");
    this.print(node.value, node);
    this.token(")");
  }
  function DeclareInterface(node) {
    this.word("declare");
    this.space();
    this.InterfaceDeclaration(node);
  }
  function DeclareModule(node) {
    this.word("declare");
    this.space();
    this.word("module");
    this.space();
    this.print(node.id, node);
    this.space();
    this.print(node.body, node);
  }
  function DeclareModuleExports(node) {
    this.word("declare");
    this.space();
    this.word("module");
    this.token(".");
    this.word("exports");
    this.print(node.typeAnnotation, node);
  }
  function DeclareTypeAlias(node) {
    this.word("declare");
    this.space();
    this.TypeAlias(node);
  }
  function DeclareOpaqueType(node, parent) {
    if (!isDeclareExportDeclaration(parent)) {
      this.word("declare");
      this.space();
    }

    this.OpaqueType(node);
  }
  function DeclareVariable(node, parent) {
    if (!isDeclareExportDeclaration(parent)) {
      this.word("declare");
      this.space();
    }

    this.word("var");
    this.space();
    this.print(node.id, node);
    this.print(node.id.typeAnnotation, node);
    this.semicolon();
  }
  function DeclareExportDeclaration(node) {
    this.word("declare");
    this.space();
    this.word("export");
    this.space();

    if (node["default"]) {
      this.word("default");
      this.space();
    }

    FlowExportDeclaration.apply(this, arguments);
  }
  function DeclareExportAllDeclaration() {
    this.word("declare");
    this.space();
    ExportAllDeclaration.apply(this, arguments);
  }
  function EnumDeclaration(node) {
    var id = node.id,
        body = node.body;
    this.word("enum");
    this.space();
    this.print(id, node);
    this.print(body, node);
  }

  function enumExplicitType(context, name, hasExplicitType) {
    if (hasExplicitType) {
      context.space();
      context.word("of");
      context.space();
      context.word(name);
    }

    context.space();
  }

  function enumBody(context, node) {
    var members = node.members;
    context.token("{");
    context.indent();
    context.newline();

    for (var _iterator = _createForOfIteratorHelperLoose(members), _step; !(_step = _iterator()).done;) {
      var member = _step.value;
      context.print(member, node);
      context.newline();
    }

    if (node.hasUnknownMembers) {
      context.token("...");
      context.newline();
    }

    context.dedent();
    context.token("}");
  }

  function EnumBooleanBody(node) {
    var explicitType = node.explicitType;
    enumExplicitType(this, "boolean", explicitType);
    enumBody(this, node);
  }
  function EnumNumberBody(node) {
    var explicitType = node.explicitType;
    enumExplicitType(this, "number", explicitType);
    enumBody(this, node);
  }
  function EnumStringBody(node) {
    var explicitType = node.explicitType;
    enumExplicitType(this, "string", explicitType);
    enumBody(this, node);
  }
  function EnumSymbolBody(node) {
    enumExplicitType(this, "symbol", true);
    enumBody(this, node);
  }
  function EnumDefaultedMember(node) {
    var id = node.id;
    this.print(id, node);
    this.token(",");
  }

  function enumInitializedMember(context, node) {
    var id = node.id,
        init = node.init;
    context.print(id, node);
    context.space();
    context.token("=");
    context.space();
    context.print(init, node);
    context.token(",");
  }

  function EnumBooleanMember(node) {
    enumInitializedMember(this, node);
  }
  function EnumNumberMember(node) {
    enumInitializedMember(this, node);
  }
  function EnumStringMember(node) {
    enumInitializedMember(this, node);
  }

  function FlowExportDeclaration(node) {
    if (node.declaration) {
      var declar = node.declaration;
      this.print(declar, node);
      if (!isStatement$3(declar)) this.semicolon();
    } else {
      this.token("{");

      if (node.specifiers.length) {
        this.space();
        this.printList(node.specifiers, node);
        this.space();
      }

      this.token("}");

      if (node.source) {
        this.space();
        this.word("from");
        this.space();
        this.print(node.source, node);
      }

      this.semicolon();
    }
  }

  function ExistsTypeAnnotation() {
    this.token("*");
  }
  function FunctionTypeAnnotation(node, parent) {
    this.print(node.typeParameters, node);
    this.token("(");

    if (node["this"]) {
      this.word("this");
      this.token(":");
      this.space();
      this.print(node["this"].typeAnnotation, node);

      if (node.params.length || node.rest) {
        this.token(",");
        this.space();
      }
    }

    this.printList(node.params, node);

    if (node.rest) {
      if (node.params.length) {
        this.token(",");
        this.space();
      }

      this.token("...");
      this.print(node.rest, node);
    }

    this.token(")");

    if (parent.type === "ObjectTypeCallProperty" || parent.type === "DeclareFunction" || parent.type === "ObjectTypeProperty" && parent.method) {
      this.token(":");
    } else {
      this.space();
      this.token("=>");
    }

    this.space();
    this.print(node.returnType, node);
  }
  function FunctionTypeParam(node) {
    this.print(node.name, node);
    if (node.optional) this.token("?");

    if (node.name) {
      this.token(":");
      this.space();
    }

    this.print(node.typeAnnotation, node);
  }
  function InterfaceExtends(node) {
    this.print(node.id, node);
    this.print(node.typeParameters, node);
  }
  function _interfaceish(node) {
    var _node$extends;

    this.print(node.id, node);
    this.print(node.typeParameters, node);

    if ((_node$extends = node["extends"]) != null && _node$extends.length) {
      this.space();
      this.word("extends");
      this.space();
      this.printList(node["extends"], node);
    }

    if (node.mixins && node.mixins.length) {
      this.space();
      this.word("mixins");
      this.space();
      this.printList(node.mixins, node);
    }

    if (node["implements"] && node["implements"].length) {
      this.space();
      this.word("implements");
      this.space();
      this.printList(node["implements"], node);
    }

    this.space();
    this.print(node.body, node);
  }
  function _variance(node) {
    if (node.variance) {
      if (node.variance.kind === "plus") {
        this.token("+");
      } else if (node.variance.kind === "minus") {
        this.token("-");
      }
    }
  }
  function InterfaceDeclaration(node) {
    this.word("interface");
    this.space();

    this._interfaceish(node);
  }

  function andSeparator() {
    this.space();
    this.token("&");
    this.space();
  }

  function InterfaceTypeAnnotation(node) {
    this.word("interface");

    if (node["extends"] && node["extends"].length) {
      this.space();
      this.word("extends");
      this.space();
      this.printList(node["extends"], node);
    }

    this.space();
    this.print(node.body, node);
  }
  function IntersectionTypeAnnotation(node) {
    this.printJoin(node.types, node, {
      separator: andSeparator
    });
  }
  function MixedTypeAnnotation() {
    this.word("mixed");
  }
  function EmptyTypeAnnotation() {
    this.word("empty");
  }
  function NullableTypeAnnotation(node) {
    this.token("?");
    this.print(node.typeAnnotation, node);
  }
  function NumberTypeAnnotation() {
    this.word("number");
  }
  function StringTypeAnnotation() {
    this.word("string");
  }
  function ThisTypeAnnotation() {
    this.word("this");
  }
  function TupleTypeAnnotation(node) {
    this.token("[");
    this.printList(node.types, node);
    this.token("]");
  }
  function TypeofTypeAnnotation(node) {
    this.word("typeof");
    this.space();
    this.print(node.argument, node);
  }
  function TypeAlias(node) {
    this.word("type");
    this.space();
    this.print(node.id, node);
    this.print(node.typeParameters, node);
    this.space();
    this.token("=");
    this.space();
    this.print(node.right, node);
    this.semicolon();
  }
  function TypeAnnotation(node) {
    this.token(":");
    this.space();
    if (node.optional) this.token("?");
    this.print(node.typeAnnotation, node);
  }
  function TypeParameterInstantiation(node) {
    this.token("<");
    this.printList(node.params, node, {});
    this.token(">");
  }
  function TypeParameter(node) {
    this._variance(node);

    this.word(node.name);

    if (node.bound) {
      this.print(node.bound, node);
    }

    if (node["default"]) {
      this.space();
      this.token("=");
      this.space();
      this.print(node["default"], node);
    }
  }
  function OpaqueType(node) {
    this.word("opaque");
    this.space();
    this.word("type");
    this.space();
    this.print(node.id, node);
    this.print(node.typeParameters, node);

    if (node.supertype) {
      this.token(":");
      this.space();
      this.print(node.supertype, node);
    }

    if (node.impltype) {
      this.space();
      this.token("=");
      this.space();
      this.print(node.impltype, node);
    }

    this.semicolon();
  }
  function ObjectTypeAnnotation(node) {
    var _this = this;

    if (node.exact) {
      this.token("{|");
    } else {
      this.token("{");
    }

    var props = [].concat(_toConsumableArray(node.properties), _toConsumableArray(node.callProperties || []), _toConsumableArray(node.indexers || []), _toConsumableArray(node.internalSlots || []));

    if (props.length) {
      this.space();
      this.printJoin(props, node, {
        addNewlines: function addNewlines(leading) {
          if (leading && !props[0]) return 1;
        },
        indent: true,
        statement: true,
        iterator: function iterator() {
          if (props.length !== 1 || node.inexact) {
            _this.token(",");

            _this.space();
          }
        }
      });
      this.space();
    }

    if (node.inexact) {
      this.indent();
      this.token("...");

      if (props.length) {
        this.newline();
      }

      this.dedent();
    }

    if (node.exact) {
      this.token("|}");
    } else {
      this.token("}");
    }
  }
  function ObjectTypeInternalSlot(node) {
    if (node["static"]) {
      this.word("static");
      this.space();
    }

    this.token("[");
    this.token("[");
    this.print(node.id, node);
    this.token("]");
    this.token("]");
    if (node.optional) this.token("?");

    if (!node.method) {
      this.token(":");
      this.space();
    }

    this.print(node.value, node);
  }
  function ObjectTypeCallProperty(node) {
    if (node["static"]) {
      this.word("static");
      this.space();
    }

    this.print(node.value, node);
  }
  function ObjectTypeIndexer(node) {
    if (node["static"]) {
      this.word("static");
      this.space();
    }

    this._variance(node);

    this.token("[");

    if (node.id) {
      this.print(node.id, node);
      this.token(":");
      this.space();
    }

    this.print(node.key, node);
    this.token("]");
    this.token(":");
    this.space();
    this.print(node.value, node);
  }
  function ObjectTypeProperty(node) {
    if (node.proto) {
      this.word("proto");
      this.space();
    }

    if (node["static"]) {
      this.word("static");
      this.space();
    }

    if (node.kind === "get" || node.kind === "set") {
      this.word(node.kind);
      this.space();
    }

    this._variance(node);

    this.print(node.key, node);
    if (node.optional) this.token("?");

    if (!node.method) {
      this.token(":");
      this.space();
    }

    this.print(node.value, node);
  }
  function ObjectTypeSpreadProperty(node) {
    this.token("...");
    this.print(node.argument, node);
  }
  function QualifiedTypeIdentifier(node) {
    this.print(node.qualification, node);
    this.token(".");
    this.print(node.id, node);
  }
  function SymbolTypeAnnotation() {
    this.word("symbol");
  }

  function orSeparator() {
    this.space();
    this.token("|");
    this.space();
  }

  function UnionTypeAnnotation(node) {
    this.printJoin(node.types, node, {
      separator: orSeparator
    });
  }
  function TypeCastExpression$1(node) {
    this.token("(");
    this.print(node.expression, node);
    this.print(node.typeAnnotation, node);
    this.token(")");
  }
  function Variance(node) {
    if (node.kind === "plus") {
      this.token("+");
    } else {
      this.token("-");
    }
  }
  function VoidTypeAnnotation() {
    this.word("void");
  }
  function IndexedAccessType(node) {
    this.print(node.objectType, node);
    this.token("[");
    this.print(node.indexType, node);
    this.token("]");
  }
  function OptionalIndexedAccessType(node) {
    this.print(node.objectType, node);

    if (node.optional) {
      this.token("?.");
    }

    this.token("[");
    this.print(node.indexType, node);
    this.token("]");
  }

  function File$1(node) {
    if (node.program) {
      this.print(node.program.interpreter, node);
    }

    this.print(node.program, node);
  }
  function Program(node) {
    this.printInnerComments(node, false);
    this.printSequence(node.directives, node);
    if (node.directives && node.directives.length) this.newline();
    this.printSequence(node.body, node);
  }
  function BlockStatement(node) {
    var _node$directives;

    this.token("{");
    this.printInnerComments(node);
    var hasDirectives = (_node$directives = node.directives) == null ? void 0 : _node$directives.length;

    if (node.body.length || hasDirectives) {
      this.newline();
      this.printSequence(node.directives, node, {
        indent: true
      });
      if (hasDirectives) this.newline();
      this.printSequence(node.body, node, {
        indent: true
      });
      this.removeTrailingNewline();
      this.source("end", node.loc);
      if (!this.endsWith(10)) this.newline();
      this.rightBrace();
    } else {
      this.source("end", node.loc);
      this.token("}");
    }
  }
  function Directive(node) {
    this.print(node.value, node);
    this.semicolon();
  }
  var unescapedSingleQuoteRE = /(?:^|[^\\])(?:\\\\)*'/;
  var unescapedDoubleQuoteRE = /(?:^|[^\\])(?:\\\\)*"/;
  function DirectiveLiteral(node) {
    var raw = this.getPossibleRaw(node);

    if (raw != null) {
      this.token(raw);
      return;
    }

    var value = node.value;

    if (!unescapedDoubleQuoteRE.test(value)) {
      this.token("\"" + value + "\"");
    } else if (!unescapedSingleQuoteRE.test(value)) {
      this.token("'" + value + "'");
    } else {
      throw new Error("Malformed AST: it is not possible to print a directive containing" + " both unescaped single and double quotes.");
    }
  }
  function InterpreterDirective(node) {
    this.token("#!" + node.value + "\n");
  }
  function Placeholder(node) {
    this.token("%%");
    this.print(node.name);
    this.token("%%");

    if (node.expectedNode === "Statement") {
      this.semicolon();
    }
  }

  function JSXAttribute(node) {
    this.print(node.name, node);

    if (node.value) {
      this.token("=");
      this.print(node.value, node);
    }
  }
  function JSXIdentifier$1(node) {
    this.word(node.name);
  }
  function JSXNamespacedName(node) {
    this.print(node.namespace, node);
    this.token(":");
    this.print(node.name, node);
  }
  function JSXMemberExpression(node) {
    this.print(node.object, node);
    this.token(".");
    this.print(node.property, node);
  }
  function JSXSpreadAttribute(node) {
    this.token("{");
    this.token("...");
    this.print(node.argument, node);
    this.token("}");
  }
  function JSXExpressionContainer(node) {
    this.token("{");
    this.print(node.expression, node);
    this.token("}");
  }
  function JSXSpreadChild(node) {
    this.token("{");
    this.token("...");
    this.print(node.expression, node);
    this.token("}");
  }
  function JSXText$1(node) {
    var raw = this.getPossibleRaw(node);

    if (raw != null) {
      this.token(raw);
    } else {
      this.token(node.value);
    }
  }
  function JSXElement(node) {
    var open = node.openingElement;
    this.print(open, node);
    if (open.selfClosing) return;
    this.indent();

    for (var _iterator = _createForOfIteratorHelperLoose(node.children), _step; !(_step = _iterator()).done;) {
      var child = _step.value;
      this.print(child, node);
    }

    this.dedent();
    this.print(node.closingElement, node);
  }

  function spaceSeparator() {
    this.space();
  }

  function JSXOpeningElement(node) {
    this.token("<");
    this.print(node.name, node);
    this.print(node.typeParameters, node);

    if (node.attributes.length > 0) {
      this.space();
      this.printJoin(node.attributes, node, {
        separator: spaceSeparator
      });
    }

    if (node.selfClosing) {
      this.space();
      this.token("/>");
    } else {
      this.token(">");
    }
  }
  function JSXClosingElement(node) {
    this.token("</");
    this.print(node.name, node);
    this.token(">");
  }
  function JSXEmptyExpression(node) {
    this.printInnerComments(node);
  }
  function JSXFragment(node) {
    this.print(node.openingFragment, node);
    this.indent();

    for (var _iterator2 = _createForOfIteratorHelperLoose(node.children), _step2; !(_step2 = _iterator2()).done;) {
      var child = _step2.value;
      this.print(child, node);
    }

    this.dedent();
    this.print(node.closingFragment, node);
  }
  function JSXOpeningFragment() {
    this.token("<");
    this.token(">");
  }
  function JSXClosingFragment() {
    this.token("</");
    this.token(">");
  }

  function TSTypeAnnotation(node) {
    this.token(":");
    this.space();
    if (node.optional) this.token("?");
    this.print(node.typeAnnotation, node);
  }
  function TSTypeParameterInstantiation(node) {
    this.token("<");
    this.printList(node.params, node, {});
    this.token(">");
  }
  function TSTypeParameter(node) {
    this.word(node.name);

    if (node.constraint) {
      this.space();
      this.word("extends");
      this.space();
      this.print(node.constraint, node);
    }

    if (node["default"]) {
      this.space();
      this.token("=");
      this.space();
      this.print(node["default"], node);
    }
  }
  function TSParameterProperty(node) {
    if (node.accessibility) {
      this.word(node.accessibility);
      this.space();
    }

    if (node.readonly) {
      this.word("readonly");
      this.space();
    }

    this._param(node.parameter);
  }
  function TSDeclareFunction(node) {
    if (node.declare) {
      this.word("declare");
      this.space();
    }

    this._functionHead(node);

    this.token(";");
  }
  function TSDeclareMethod(node) {
    this._classMethodHead(node);

    this.token(";");
  }
  function TSQualifiedName(node) {
    this.print(node.left, node);
    this.token(".");
    this.print(node.right, node);
  }
  function TSCallSignatureDeclaration(node) {
    this.tsPrintSignatureDeclarationBase(node);
    this.token(";");
  }
  function TSConstructSignatureDeclaration(node) {
    this.word("new");
    this.space();
    this.tsPrintSignatureDeclarationBase(node);
    this.token(";");
  }
  function TSPropertySignature(node) {
    var readonly = node.readonly,
        initializer = node.initializer;

    if (readonly) {
      this.word("readonly");
      this.space();
    }

    this.tsPrintPropertyOrMethodName(node);
    this.print(node.typeAnnotation, node);

    if (initializer) {
      this.space();
      this.token("=");
      this.space();
      this.print(initializer, node);
    }

    this.token(";");
  }
  function tsPrintPropertyOrMethodName(node) {
    if (node.computed) {
      this.token("[");
    }

    this.print(node.key, node);

    if (node.computed) {
      this.token("]");
    }

    if (node.optional) {
      this.token("?");
    }
  }
  function TSMethodSignature(node) {
    var kind = node.kind;

    if (kind === "set" || kind === "get") {
      this.word(kind);
      this.space();
    }

    this.tsPrintPropertyOrMethodName(node);
    this.tsPrintSignatureDeclarationBase(node);
    this.token(";");
  }
  function TSIndexSignature(node) {
    var readonly = node.readonly,
        isStatic = node["static"];

    if (isStatic) {
      this.word("static");
      this.space();
    }

    if (readonly) {
      this.word("readonly");
      this.space();
    }

    this.token("[");

    this._parameters(node.parameters, node);

    this.token("]");
    this.print(node.typeAnnotation, node);
    this.token(";");
  }
  function TSAnyKeyword() {
    this.word("any");
  }
  function TSBigIntKeyword() {
    this.word("bigint");
  }
  function TSUnknownKeyword() {
    this.word("unknown");
  }
  function TSNumberKeyword() {
    this.word("number");
  }
  function TSObjectKeyword() {
    this.word("object");
  }
  function TSBooleanKeyword() {
    this.word("boolean");
  }
  function TSStringKeyword() {
    this.word("string");
  }
  function TSSymbolKeyword() {
    this.word("symbol");
  }
  function TSVoidKeyword() {
    this.word("void");
  }
  function TSUndefinedKeyword() {
    this.word("undefined");
  }
  function TSNullKeyword() {
    this.word("null");
  }
  function TSNeverKeyword() {
    this.word("never");
  }
  function TSIntrinsicKeyword() {
    this.word("intrinsic");
  }
  function TSThisType() {
    this.word("this");
  }
  function TSFunctionType(node) {
    this.tsPrintFunctionOrConstructorType(node);
  }
  function TSConstructorType(node) {
    if (node["abstract"]) {
      this.word("abstract");
      this.space();
    }

    this.word("new");
    this.space();
    this.tsPrintFunctionOrConstructorType(node);
  }
  function tsPrintFunctionOrConstructorType(node) {
    var typeParameters = node.typeParameters,
        parameters = node.parameters;
    this.print(typeParameters, node);
    this.token("(");

    this._parameters(parameters, node);

    this.token(")");
    this.space();
    this.token("=>");
    this.space();
    this.print(node.typeAnnotation.typeAnnotation, node);
  }
  function TSTypeReference(node) {
    this.print(node.typeName, node);
    this.print(node.typeParameters, node);
  }
  function TSTypePredicate(node) {
    if (node.asserts) {
      this.word("asserts");
      this.space();
    }

    this.print(node.parameterName);

    if (node.typeAnnotation) {
      this.space();
      this.word("is");
      this.space();
      this.print(node.typeAnnotation.typeAnnotation);
    }
  }
  function TSTypeQuery(node) {
    this.word("typeof");
    this.space();
    this.print(node.exprName);
  }
  function TSTypeLiteral(node) {
    this.tsPrintTypeLiteralOrInterfaceBody(node.members, node);
  }
  function tsPrintTypeLiteralOrInterfaceBody(members, node) {
    this.tsPrintBraced(members, node);
  }
  function tsPrintBraced(members, node) {
    this.token("{");

    if (members.length) {
      this.indent();
      this.newline();

      for (var _iterator = _createForOfIteratorHelperLoose(members), _step; !(_step = _iterator()).done;) {
        var member = _step.value;
        this.print(member, node);
        this.newline();
      }

      this.dedent();
      this.rightBrace();
    } else {
      this.token("}");
    }
  }
  function TSArrayType(node) {
    this.print(node.elementType, node);
    this.token("[]");
  }
  function TSTupleType(node) {
    this.token("[");
    this.printList(node.elementTypes, node);
    this.token("]");
  }
  function TSOptionalType(node) {
    this.print(node.typeAnnotation, node);
    this.token("?");
  }
  function TSRestType(node) {
    this.token("...");
    this.print(node.typeAnnotation, node);
  }
  function TSNamedTupleMember(node) {
    this.print(node.label, node);
    if (node.optional) this.token("?");
    this.token(":");
    this.space();
    this.print(node.elementType, node);
  }
  function TSUnionType(node) {
    this.tsPrintUnionOrIntersectionType(node, "|");
  }
  function TSIntersectionType(node) {
    this.tsPrintUnionOrIntersectionType(node, "&");
  }
  function tsPrintUnionOrIntersectionType(node, sep) {
    this.printJoin(node.types, node, {
      separator: function separator() {
        this.space();
        this.token(sep);
        this.space();
      }
    });
  }
  function TSConditionalType(node) {
    this.print(node.checkType);
    this.space();
    this.word("extends");
    this.space();
    this.print(node.extendsType);
    this.space();
    this.token("?");
    this.space();
    this.print(node.trueType);
    this.space();
    this.token(":");
    this.space();
    this.print(node.falseType);
  }
  function TSInferType(node) {
    this.token("infer");
    this.space();
    this.print(node.typeParameter);
  }
  function TSParenthesizedType(node) {
    this.token("(");
    this.print(node.typeAnnotation, node);
    this.token(")");
  }
  function TSTypeOperator(node) {
    this.word(node.operator);
    this.space();
    this.print(node.typeAnnotation, node);
  }
  function TSIndexedAccessType(node) {
    this.print(node.objectType, node);
    this.token("[");
    this.print(node.indexType, node);
    this.token("]");
  }
  function TSMappedType(node) {
    var nameType = node.nameType,
        optional = node.optional,
        readonly = node.readonly,
        typeParameter = node.typeParameter;
    this.token("{");
    this.space();

    if (readonly) {
      tokenIfPlusMinus(this, readonly);
      this.word("readonly");
      this.space();
    }

    this.token("[");
    this.word(typeParameter.name);
    this.space();
    this.word("in");
    this.space();
    this.print(typeParameter.constraint, typeParameter);

    if (nameType) {
      this.space();
      this.word("as");
      this.space();
      this.print(nameType, node);
    }

    this.token("]");

    if (optional) {
      tokenIfPlusMinus(this, optional);
      this.token("?");
    }

    this.token(":");
    this.space();
    this.print(node.typeAnnotation, node);
    this.space();
    this.token("}");
  }

  function tokenIfPlusMinus(self, tok) {
    if (tok !== true) {
      self.token(tok);
    }
  }

  function TSLiteralType(node) {
    this.print(node.literal, node);
  }
  function TSExpressionWithTypeArguments(node) {
    this.print(node.expression, node);
    this.print(node.typeParameters, node);
  }
  function TSInterfaceDeclaration(node) {
    var declare = node.declare,
        id = node.id,
        typeParameters = node.typeParameters,
        extendz = node["extends"],
        body = node.body;

    if (declare) {
      this.word("declare");
      this.space();
    }

    this.word("interface");
    this.space();
    this.print(id, node);
    this.print(typeParameters, node);

    if (extendz != null && extendz.length) {
      this.space();
      this.word("extends");
      this.space();
      this.printList(extendz, node);
    }

    this.space();
    this.print(body, node);
  }
  function TSInterfaceBody(node) {
    this.tsPrintTypeLiteralOrInterfaceBody(node.body, node);
  }
  function TSTypeAliasDeclaration(node) {
    var declare = node.declare,
        id = node.id,
        typeParameters = node.typeParameters,
        typeAnnotation = node.typeAnnotation;

    if (declare) {
      this.word("declare");
      this.space();
    }

    this.word("type");
    this.space();
    this.print(id, node);
    this.print(typeParameters, node);
    this.space();
    this.token("=");
    this.space();
    this.print(typeAnnotation, node);
    this.token(";");
  }
  function TSAsExpression(node) {
    var expression = node.expression,
        typeAnnotation = node.typeAnnotation;
    this.print(expression, node);
    this.space();
    this.word("as");
    this.space();
    this.print(typeAnnotation, node);
  }
  function TSTypeAssertion(node) {
    var typeAnnotation = node.typeAnnotation,
        expression = node.expression;
    this.token("<");
    this.print(typeAnnotation, node);
    this.token(">");
    this.space();
    this.print(expression, node);
  }
  function TSEnumDeclaration(node) {
    var declare = node.declare,
        isConst = node["const"],
        id = node.id,
        members = node.members;

    if (declare) {
      this.word("declare");
      this.space();
    }

    if (isConst) {
      this.word("const");
      this.space();
    }

    this.word("enum");
    this.space();
    this.print(id, node);
    this.space();
    this.tsPrintBraced(members, node);
  }
  function TSEnumMember(node) {
    var id = node.id,
        initializer = node.initializer;
    this.print(id, node);

    if (initializer) {
      this.space();
      this.token("=");
      this.space();
      this.print(initializer, node);
    }

    this.token(",");
  }
  function TSModuleDeclaration(node) {
    var declare = node.declare,
        id = node.id;

    if (declare) {
      this.word("declare");
      this.space();
    }

    if (!node.global) {
      this.word(id.type === "Identifier" ? "namespace" : "module");
      this.space();
    }

    this.print(id, node);

    if (!node.body) {
      this.token(";");
      return;
    }

    var body = node.body;

    while (body.type === "TSModuleDeclaration") {
      this.token(".");
      this.print(body.id, body);
      body = body.body;
    }

    this.space();
    this.print(body, node);
  }
  function TSModuleBlock(node) {
    this.tsPrintBraced(node.body, node);
  }
  function TSImportType(node) {
    var argument = node.argument,
        qualifier = node.qualifier,
        typeParameters = node.typeParameters;
    this.word("import");
    this.token("(");
    this.print(argument, node);
    this.token(")");

    if (qualifier) {
      this.token(".");
      this.print(qualifier, node);
    }

    if (typeParameters) {
      this.print(typeParameters, node);
    }
  }
  function TSImportEqualsDeclaration(node) {
    var isExport = node.isExport,
        id = node.id,
        moduleReference = node.moduleReference;

    if (isExport) {
      this.word("export");
      this.space();
    }

    this.word("import");
    this.space();
    this.print(id, node);
    this.space();
    this.token("=");
    this.space();
    this.print(moduleReference, node);
    this.token(";");
  }
  function TSExternalModuleReference(node) {
    this.token("require(");
    this.print(node.expression, node);
    this.token(")");
  }
  function TSNonNullExpression(node) {
    this.print(node.expression, node);
    this.token("!");
  }
  function TSExportAssignment(node) {
    this.word("export");
    this.space();
    this.token("=");
    this.space();
    this.print(node.expression, node);
    this.token(";");
  }
  function TSNamespaceExportDeclaration(node) {
    this.word("export");
    this.space();
    this.word("as");
    this.space();
    this.word("namespace");
    this.space();
    this.print(node.id, node);
  }
  function tsPrintSignatureDeclarationBase(node) {
    var typeParameters = node.typeParameters,
        parameters = node.parameters;
    this.print(typeParameters, node);
    this.token("(");

    this._parameters(parameters, node);

    this.token(")");
    this.print(node.typeAnnotation, node);
  }
  function tsPrintClassMemberModifiers(node, isField) {
    if (isField && node.declare) {
      this.word("declare");
      this.space();
    }

    if (node.accessibility) {
      this.word(node.accessibility);
      this.space();
    }

    if (node["static"]) {
      this.word("static");
      this.space();
    }

    if (node.override) {
      this.word("override");
      this.space();
    }

    if (node["abstract"]) {
      this.word("abstract");
      this.space();
    }

    if (isField && node.readonly) {
      this.word("readonly");
      this.space();
    }
  }

  var generatorFunctions = /*#__PURE__*/Object.freeze({
    __proto__: null,
    TaggedTemplateExpression: TaggedTemplateExpression$1,
    TemplateElement: TemplateElement,
    TemplateLiteral: TemplateLiteral$1,
    UnaryExpression: UnaryExpression$1,
    DoExpression: DoExpression,
    ParenthesizedExpression: ParenthesizedExpression$1,
    UpdateExpression: UpdateExpression$1,
    ConditionalExpression: ConditionalExpression$1,
    NewExpression: NewExpression$1,
    SequenceExpression: SequenceExpression$1,
    ThisExpression: ThisExpression,
    Super: Super,
    Decorator: Decorator,
    OptionalMemberExpression: OptionalMemberExpression,
    OptionalCallExpression: OptionalCallExpression,
    CallExpression: CallExpression$1,
    Import: Import,
    YieldExpression: YieldExpression,
    AwaitExpression: AwaitExpression,
    EmptyStatement: EmptyStatement,
    ExpressionStatement: ExpressionStatement,
    AssignmentPattern: AssignmentPattern,
    AssignmentExpression: AssignmentExpression$1,
    BindExpression: BindExpression,
    BinaryExpression: AssignmentExpression$1,
    LogicalExpression: AssignmentExpression$1,
    MemberExpression: MemberExpression,
    MetaProperty: MetaProperty,
    PrivateName: PrivateName,
    V8IntrinsicIdentifier: V8IntrinsicIdentifier,
    ModuleExpression: ModuleExpression,
    WithStatement: WithStatement,
    IfStatement: IfStatement,
    ForStatement: ForStatement,
    WhileStatement: WhileStatement,
    ForInStatement: ForInStatement,
    ForOfStatement: ForOfStatement,
    DoWhileStatement: DoWhileStatement,
    ContinueStatement: ContinueStatement,
    ReturnStatement: ReturnStatement,
    BreakStatement: BreakStatement,
    ThrowStatement: ThrowStatement,
    LabeledStatement: LabeledStatement,
    TryStatement: TryStatement,
    CatchClause: CatchClause,
    SwitchStatement: SwitchStatement,
    SwitchCase: SwitchCase,
    DebuggerStatement: DebuggerStatement,
    VariableDeclaration: VariableDeclaration,
    VariableDeclarator: VariableDeclarator$1,
    ClassDeclaration: ClassDeclaration,
    ClassExpression: ClassDeclaration,
    ClassBody: ClassBody,
    ClassProperty: ClassProperty,
    ClassPrivateProperty: ClassPrivateProperty,
    ClassMethod: ClassMethod,
    ClassPrivateMethod: ClassPrivateMethod,
    _classMethodHead: _classMethodHead,
    StaticBlock: StaticBlock,
    _params: _params,
    _parameters: _parameters,
    _param: _param,
    _methodHead: _methodHead,
    _predicate: _predicate,
    _functionHead: _functionHead,
    FunctionExpression: FunctionExpression,
    FunctionDeclaration: FunctionExpression,
    ArrowFunctionExpression: ArrowFunctionExpression,
    ImportSpecifier: ImportSpecifier,
    ImportDefaultSpecifier: ImportDefaultSpecifier,
    ExportDefaultSpecifier: ExportDefaultSpecifier,
    ExportSpecifier: ExportSpecifier,
    ExportNamespaceSpecifier: ExportNamespaceSpecifier,
    ExportAllDeclaration: ExportAllDeclaration,
    ExportNamedDeclaration: ExportNamedDeclaration,
    ExportDefaultDeclaration: ExportDefaultDeclaration,
    ImportDeclaration: ImportDeclaration,
    ImportAttribute: ImportAttribute,
    ImportNamespaceSpecifier: ImportNamespaceSpecifier,
    Identifier: Identifier,
    ArgumentPlaceholder: ArgumentPlaceholder,
    RestElement: RestElement$1,
    SpreadElement: RestElement$1,
    ObjectExpression: ObjectExpression$1,
    ObjectPattern: ObjectExpression$1,
    ObjectMethod: ObjectMethod,
    ObjectProperty: ObjectProperty,
    ArrayExpression: ArrayExpression$1,
    ArrayPattern: ArrayExpression$1,
    RecordExpression: RecordExpression,
    TupleExpression: TupleExpression,
    RegExpLiteral: RegExpLiteral$1,
    BooleanLiteral: BooleanLiteral$1,
    NullLiteral: NullLiteral$1,
    NumericLiteral: NumericLiteral$2,
    StringLiteral: StringLiteral$2,
    BigIntLiteral: BigIntLiteral,
    DecimalLiteral: DecimalLiteral,
    TopicReference: TopicReference,
    PipelineTopicExpression: PipelineTopicExpression,
    PipelineBareFunction: PipelineBareFunction,
    PipelinePrimaryTopicReference: PipelinePrimaryTopicReference,
    NumberLiteralTypeAnnotation: NumericLiteral$2,
    StringLiteralTypeAnnotation: StringLiteral$2,
    AnyTypeAnnotation: AnyTypeAnnotation,
    ArrayTypeAnnotation: ArrayTypeAnnotation,
    BooleanTypeAnnotation: BooleanTypeAnnotation,
    BooleanLiteralTypeAnnotation: BooleanLiteralTypeAnnotation,
    NullLiteralTypeAnnotation: NullLiteralTypeAnnotation,
    DeclareClass: DeclareClass,
    DeclareFunction: DeclareFunction,
    InferredPredicate: InferredPredicate,
    DeclaredPredicate: DeclaredPredicate,
    DeclareInterface: DeclareInterface,
    DeclareModule: DeclareModule,
    DeclareModuleExports: DeclareModuleExports,
    DeclareTypeAlias: DeclareTypeAlias,
    DeclareOpaqueType: DeclareOpaqueType,
    DeclareVariable: DeclareVariable,
    DeclareExportDeclaration: DeclareExportDeclaration,
    DeclareExportAllDeclaration: DeclareExportAllDeclaration,
    EnumDeclaration: EnumDeclaration,
    EnumBooleanBody: EnumBooleanBody,
    EnumNumberBody: EnumNumberBody,
    EnumStringBody: EnumStringBody,
    EnumSymbolBody: EnumSymbolBody,
    EnumDefaultedMember: EnumDefaultedMember,
    EnumBooleanMember: EnumBooleanMember,
    EnumNumberMember: EnumNumberMember,
    EnumStringMember: EnumStringMember,
    ExistsTypeAnnotation: ExistsTypeAnnotation,
    FunctionTypeAnnotation: FunctionTypeAnnotation,
    FunctionTypeParam: FunctionTypeParam,
    InterfaceExtends: InterfaceExtends,
    ClassImplements: InterfaceExtends,
    GenericTypeAnnotation: InterfaceExtends,
    _interfaceish: _interfaceish,
    _variance: _variance,
    InterfaceDeclaration: InterfaceDeclaration,
    InterfaceTypeAnnotation: InterfaceTypeAnnotation,
    IntersectionTypeAnnotation: IntersectionTypeAnnotation,
    MixedTypeAnnotation: MixedTypeAnnotation,
    EmptyTypeAnnotation: EmptyTypeAnnotation,
    NullableTypeAnnotation: NullableTypeAnnotation,
    NumberTypeAnnotation: NumberTypeAnnotation,
    StringTypeAnnotation: StringTypeAnnotation,
    ThisTypeAnnotation: ThisTypeAnnotation,
    TupleTypeAnnotation: TupleTypeAnnotation,
    TypeofTypeAnnotation: TypeofTypeAnnotation,
    TypeAlias: TypeAlias,
    TypeAnnotation: TypeAnnotation,
    TypeParameterInstantiation: TypeParameterInstantiation,
    TypeParameterDeclaration: TypeParameterInstantiation,
    TypeParameter: TypeParameter,
    OpaqueType: OpaqueType,
    ObjectTypeAnnotation: ObjectTypeAnnotation,
    ObjectTypeInternalSlot: ObjectTypeInternalSlot,
    ObjectTypeCallProperty: ObjectTypeCallProperty,
    ObjectTypeIndexer: ObjectTypeIndexer,
    ObjectTypeProperty: ObjectTypeProperty,
    ObjectTypeSpreadProperty: ObjectTypeSpreadProperty,
    QualifiedTypeIdentifier: QualifiedTypeIdentifier,
    SymbolTypeAnnotation: SymbolTypeAnnotation,
    UnionTypeAnnotation: UnionTypeAnnotation,
    TypeCastExpression: TypeCastExpression$1,
    Variance: Variance,
    VoidTypeAnnotation: VoidTypeAnnotation,
    IndexedAccessType: IndexedAccessType,
    OptionalIndexedAccessType: OptionalIndexedAccessType,
    File: File$1,
    Program: Program,
    BlockStatement: BlockStatement,
    Directive: Directive,
    DirectiveLiteral: DirectiveLiteral,
    InterpreterDirective: InterpreterDirective,
    Placeholder: Placeholder,
    JSXAttribute: JSXAttribute,
    JSXIdentifier: JSXIdentifier$1,
    JSXNamespacedName: JSXNamespacedName,
    JSXMemberExpression: JSXMemberExpression,
    JSXSpreadAttribute: JSXSpreadAttribute,
    JSXExpressionContainer: JSXExpressionContainer,
    JSXSpreadChild: JSXSpreadChild,
    JSXText: JSXText$1,
    JSXElement: JSXElement,
    JSXOpeningElement: JSXOpeningElement,
    JSXClosingElement: JSXClosingElement,
    JSXEmptyExpression: JSXEmptyExpression,
    JSXFragment: JSXFragment,
    JSXOpeningFragment: JSXOpeningFragment,
    JSXClosingFragment: JSXClosingFragment,
    TSTypeAnnotation: TSTypeAnnotation,
    TSTypeParameterInstantiation: TSTypeParameterInstantiation,
    TSTypeParameterDeclaration: TSTypeParameterInstantiation,
    TSTypeParameter: TSTypeParameter,
    TSParameterProperty: TSParameterProperty,
    TSDeclareFunction: TSDeclareFunction,
    TSDeclareMethod: TSDeclareMethod,
    TSQualifiedName: TSQualifiedName,
    TSCallSignatureDeclaration: TSCallSignatureDeclaration,
    TSConstructSignatureDeclaration: TSConstructSignatureDeclaration,
    TSPropertySignature: TSPropertySignature,
    tsPrintPropertyOrMethodName: tsPrintPropertyOrMethodName,
    TSMethodSignature: TSMethodSignature,
    TSIndexSignature: TSIndexSignature,
    TSAnyKeyword: TSAnyKeyword,
    TSBigIntKeyword: TSBigIntKeyword,
    TSUnknownKeyword: TSUnknownKeyword,
    TSNumberKeyword: TSNumberKeyword,
    TSObjectKeyword: TSObjectKeyword,
    TSBooleanKeyword: TSBooleanKeyword,
    TSStringKeyword: TSStringKeyword,
    TSSymbolKeyword: TSSymbolKeyword,
    TSVoidKeyword: TSVoidKeyword,
    TSUndefinedKeyword: TSUndefinedKeyword,
    TSNullKeyword: TSNullKeyword,
    TSNeverKeyword: TSNeverKeyword,
    TSIntrinsicKeyword: TSIntrinsicKeyword,
    TSThisType: TSThisType,
    TSFunctionType: TSFunctionType,
    TSConstructorType: TSConstructorType,
    tsPrintFunctionOrConstructorType: tsPrintFunctionOrConstructorType,
    TSTypeReference: TSTypeReference,
    TSTypePredicate: TSTypePredicate,
    TSTypeQuery: TSTypeQuery,
    TSTypeLiteral: TSTypeLiteral,
    tsPrintTypeLiteralOrInterfaceBody: tsPrintTypeLiteralOrInterfaceBody,
    tsPrintBraced: tsPrintBraced,
    TSArrayType: TSArrayType,
    TSTupleType: TSTupleType,
    TSOptionalType: TSOptionalType,
    TSRestType: TSRestType,
    TSNamedTupleMember: TSNamedTupleMember,
    TSUnionType: TSUnionType,
    TSIntersectionType: TSIntersectionType,
    tsPrintUnionOrIntersectionType: tsPrintUnionOrIntersectionType,
    TSConditionalType: TSConditionalType,
    TSInferType: TSInferType,
    TSParenthesizedType: TSParenthesizedType,
    TSTypeOperator: TSTypeOperator,
    TSIndexedAccessType: TSIndexedAccessType,
    TSMappedType: TSMappedType,
    TSLiteralType: TSLiteralType,
    TSExpressionWithTypeArguments: TSExpressionWithTypeArguments,
    TSInterfaceDeclaration: TSInterfaceDeclaration,
    TSInterfaceBody: TSInterfaceBody,
    TSTypeAliasDeclaration: TSTypeAliasDeclaration,
    TSAsExpression: TSAsExpression,
    TSTypeAssertion: TSTypeAssertion,
    TSEnumDeclaration: TSEnumDeclaration,
    TSEnumMember: TSEnumMember,
    TSModuleDeclaration: TSModuleDeclaration,
    TSModuleBlock: TSModuleBlock,
    TSImportType: TSImportType,
    TSImportEqualsDeclaration: TSImportEqualsDeclaration,
    TSExternalModuleReference: TSExternalModuleReference,
    TSNonNullExpression: TSNonNullExpression,
    TSExportAssignment: TSExportAssignment,
    TSNamespaceExportDeclaration: TSNamespaceExportDeclaration,
    tsPrintSignatureDeclarationBase: tsPrintSignatureDeclarationBase,
    tsPrintClassMemberModifiers: tsPrintClassMemberModifiers
  });

  var isProgram$1 = isProgram$2,
      isFile = isFile$1,
      isEmptyStatement = isEmptyStatement$1;
  var SCIENTIFIC_NOTATION = /e/i;
  var ZERO_DECIMAL_INTEGER = /\.0+$/;
  var NON_DECIMAL_LITERAL = /^0[box]/;
  var PURE_ANNOTATION_RE = /^\s*[@#]__PURE__\s*$/;
  var needsParens = needsParens$1,
      needsWhitespaceAfter = needsWhitespaceAfter$1,
      needsWhitespaceBefore = needsWhitespaceBefore$1;

  var Printer = function () {
    function Printer(format, map) {
      this.inForStatementInitCounter = 0;
      this._printStack = [];
      this._indent = 0;
      this._insideAux = false;
      this._parenPushNewlineState = null;
      this._noLineTerminator = false;
      this._printAuxAfterOnNextUserNode = false;
      this._printedComments = new WeakSet();
      this._endsWithInteger = false;
      this._endsWithWord = false;
      this.format = format;
      this._buf = new Buffer(map);
    }

    var _proto = Printer.prototype;

    _proto.generate = function generate(ast) {
      this.print(ast);

      this._maybeAddAuxComment();

      return this._buf.get();
    };

    _proto.indent = function indent() {
      if (this.format.compact || this.format.concise) return;
      this._indent++;
    };

    _proto.dedent = function dedent() {
      if (this.format.compact || this.format.concise) return;
      this._indent--;
    };

    _proto.semicolon = function semicolon(force) {
      if (force === void 0) {
        force = false;
      }

      this._maybeAddAuxComment();

      this._append(";", !force);
    };

    _proto.rightBrace = function rightBrace() {
      if (this.format.minified) {
        this._buf.removeLastSemicolon();
      }

      this.token("}");
    };

    _proto.space = function space(force) {
      if (force === void 0) {
        force = false;
      }

      if (this.format.compact) return;

      if (force) {
        this._space();
      } else if (this._buf.hasContent()) {
        var lastCp = this.getLastChar();

        if (lastCp !== 32 && lastCp !== 10) {
          this._space();
        }
      }
    };

    _proto.word = function word(str) {
      if (this._endsWithWord || this.endsWith(47) && str.charCodeAt(0) === 47) {
        this._space();
      }

      this._maybeAddAuxComment();

      this._append(str);

      this._endsWithWord = true;
    };

    _proto.number = function number(str) {
      this.word(str);
      this._endsWithInteger = Number.isInteger(+str) && !NON_DECIMAL_LITERAL.test(str) && !SCIENTIFIC_NOTATION.test(str) && !ZERO_DECIMAL_INTEGER.test(str) && str.charCodeAt(str.length - 1) !== 46;
    };

    _proto.token = function token(str) {
      var lastChar = this.getLastChar();
      var strFirst = str.charCodeAt(0);

      if (str === "--" && lastChar === 33 || strFirst === 43 && lastChar === 43 || strFirst === 45 && lastChar === 45 || strFirst === 46 && this._endsWithInteger) {
        this._space();
      }

      this._maybeAddAuxComment();

      this._append(str);
    };

    _proto.newline = function newline(i) {
      if (i === void 0) {
        i = 1;
      }

      if (this.format.retainLines || this.format.compact) return;

      if (this.format.concise) {
        this.space();
        return;
      }

      var charBeforeNewline = this.endsWithCharAndNewline();
      if (charBeforeNewline === 10) return;

      if (charBeforeNewline === 123 || charBeforeNewline === 58) {
        i--;
      }

      if (i <= 0) return;

      for (var j = 0; j < i; j++) {
        this._newline();
      }
    };

    _proto.endsWith = function endsWith(_char) {
      return this.getLastChar() === _char;
    };

    _proto.getLastChar = function getLastChar() {
      return this._buf.getLastChar();
    };

    _proto.endsWithCharAndNewline = function endsWithCharAndNewline() {
      return this._buf.endsWithCharAndNewline();
    };

    _proto.removeTrailingNewline = function removeTrailingNewline() {
      this._buf.removeTrailingNewline();
    };

    _proto.exactSource = function exactSource(loc, cb) {
      this._catchUp("start", loc);

      this._buf.exactSource(loc, cb);
    };

    _proto.source = function source(prop, loc) {
      this._catchUp(prop, loc);

      this._buf.source(prop, loc);
    };

    _proto.withSource = function withSource(prop, loc, cb) {
      this._catchUp(prop, loc);

      this._buf.withSource(prop, loc, cb);
    };

    _proto._space = function _space() {
      this._append(" ", true);
    };

    _proto._newline = function _newline() {
      this._append("\n", true);
    };

    _proto._append = function _append(str, queue) {
      if (queue === void 0) {
        queue = false;
      }

      this._maybeAddParen(str);

      this._maybeIndent(str);

      if (queue) this._buf.queue(str);else this._buf.append(str);
      this._endsWithWord = false;
      this._endsWithInteger = false;
    };

    _proto._maybeIndent = function _maybeIndent(str) {
      if (this._indent && this.endsWith(10) && str.charCodeAt(0) !== 10) {
        this._buf.queue(this._getIndent());
      }
    };

    _proto._maybeAddParen = function _maybeAddParen(str) {
      var parenPushNewlineState = this._parenPushNewlineState;
      if (!parenPushNewlineState) return;
      var i;

      for (i = 0; i < str.length && str[i] === " "; i++) {
        continue;
      }

      if (i === str.length) {
        return;
      }

      var cha = str[i];

      if (cha !== "\n") {
        if (cha !== "/" || i + 1 === str.length) {
          this._parenPushNewlineState = null;
          return;
        }

        var chaPost = str[i + 1];

        if (chaPost === "*") {
          if (PURE_ANNOTATION_RE.test(str.slice(i + 2, str.length - 2))) {
            return;
          }
        } else if (chaPost !== "/") {
          this._parenPushNewlineState = null;
          return;
        }
      }

      this.token("(");
      this.indent();
      parenPushNewlineState.printed = true;
    };

    _proto._catchUp = function _catchUp(prop, loc) {
      if (!this.format.retainLines) return;
      var pos = loc ? loc[prop] : null;

      if ((pos == null ? void 0 : pos.line) != null) {
        var count = pos.line - this._buf.getCurrentLine();

        for (var i = 0; i < count; i++) {
          this._newline();
        }
      }
    };

    _proto._getIndent = function _getIndent() {
      return this.format.indent.style.repeat(this._indent);
    };

    _proto.startTerminatorless = function startTerminatorless(isLabel) {
      if (isLabel === void 0) {
        isLabel = false;
      }

      if (isLabel) {
        this._noLineTerminator = true;
        return null;
      } else {
        return this._parenPushNewlineState = {
          printed: false
        };
      }
    };

    _proto.endTerminatorless = function endTerminatorless(state) {
      this._noLineTerminator = false;

      if (state != null && state.printed) {
        this.dedent();
        this.newline();
        this.token(")");
      }
    };

    _proto.print = function print(node, parent) {
      var _this = this;

      if (!node) return;
      var oldConcise = this.format.concise;

      if (node._compact) {
        this.format.concise = true;
      }

      var printMethod = this[node.type];

      if (!printMethod) {
        throw new ReferenceError("unknown node of type " + JSON.stringify(node.type) + " with constructor " + JSON.stringify(node == null ? void 0 : node.constructor.name));
      }

      this._printStack.push(node);

      var oldInAux = this._insideAux;
      this._insideAux = !node.loc;

      this._maybeAddAuxComment(this._insideAux && !oldInAux);

      var shouldPrintParens = needsParens(node, parent, this._printStack);

      if (this.format.retainFunctionParens && node.type === "FunctionExpression" && node.extra && node.extra.parenthesized) {
        shouldPrintParens = true;
      }

      if (shouldPrintParens) this.token("(");

      this._printLeadingComments(node);

      var loc = isProgram$1(node) || isFile(node) ? null : node.loc;
      this.withSource("start", loc, function () {
        printMethod.call(_this, node, parent);
      });

      this._printTrailingComments(node);

      if (shouldPrintParens) this.token(")");

      this._printStack.pop();

      this.format.concise = oldConcise;
      this._insideAux = oldInAux;
    };

    _proto._maybeAddAuxComment = function _maybeAddAuxComment(enteredPositionlessNode) {
      if (enteredPositionlessNode) this._printAuxBeforeComment();
      if (!this._insideAux) this._printAuxAfterComment();
    };

    _proto._printAuxBeforeComment = function _printAuxBeforeComment() {
      if (this._printAuxAfterOnNextUserNode) return;
      this._printAuxAfterOnNextUserNode = true;
      var comment = this.format.auxiliaryCommentBefore;

      if (comment) {
        this._printComment({
          type: "CommentBlock",
          value: comment
        });
      }
    };

    _proto._printAuxAfterComment = function _printAuxAfterComment() {
      if (!this._printAuxAfterOnNextUserNode) return;
      this._printAuxAfterOnNextUserNode = false;
      var comment = this.format.auxiliaryCommentAfter;

      if (comment) {
        this._printComment({
          type: "CommentBlock",
          value: comment
        });
      }
    };

    _proto.getPossibleRaw = function getPossibleRaw(node) {
      var extra = node.extra;

      if (extra && extra.raw != null && extra.rawValue != null && node.value === extra.rawValue) {
        return extra.raw;
      }
    };

    _proto.printJoin = function printJoin(nodes, parent, opts) {
      if (opts === void 0) {
        opts = {};
      }

      if (!(nodes != null && nodes.length)) return;
      if (opts.indent) this.indent();
      var newlineOpts = {
        addNewlines: opts.addNewlines
      };

      for (var i = 0; i < nodes.length; i++) {
        var node = nodes[i];
        if (!node) continue;
        if (opts.statement) this._printNewline(true, node, parent, newlineOpts);
        this.print(node, parent);

        if (opts.iterator) {
          opts.iterator(node, i);
        }

        if (opts.separator && i < nodes.length - 1) {
          opts.separator.call(this);
        }

        if (opts.statement) this._printNewline(false, node, parent, newlineOpts);
      }

      if (opts.indent) this.dedent();
    };

    _proto.printAndIndentOnComments = function printAndIndentOnComments(node, parent) {
      var indent = node.leadingComments && node.leadingComments.length > 0;
      if (indent) this.indent();
      this.print(node, parent);
      if (indent) this.dedent();
    };

    _proto.printBlock = function printBlock(parent) {
      var node = parent.body;

      if (!isEmptyStatement(node)) {
        this.space();
      }

      this.print(node, parent);
    };

    _proto._printTrailingComments = function _printTrailingComments(node) {
      this._printComments(this._getComments(false, node));
    };

    _proto._printLeadingComments = function _printLeadingComments(node) {
      this._printComments(this._getComments(true, node), true);
    };

    _proto.printInnerComments = function printInnerComments(node, indent) {
      var _node$innerComments;

      if (indent === void 0) {
        indent = true;
      }

      if (!((_node$innerComments = node.innerComments) != null && _node$innerComments.length)) return;
      if (indent) this.indent();

      this._printComments(node.innerComments);

      if (indent) this.dedent();
    };

    _proto.printSequence = function printSequence(nodes, parent, opts) {
      if (opts === void 0) {
        opts = {};
      }

      opts.statement = true;
      return this.printJoin(nodes, parent, opts);
    };

    _proto.printList = function printList(items, parent, opts) {
      if (opts === void 0) {
        opts = {};
      }

      if (opts.separator == null) {
        opts.separator = commaSeparator;
      }

      return this.printJoin(items, parent, opts);
    };

    _proto._printNewline = function _printNewline(leading, node, parent, opts) {
      if (this.format.retainLines || this.format.compact) return;

      if (this.format.concise) {
        this.space();
        return;
      }

      var lines = 0;

      if (this._buf.hasContent()) {
        if (!leading) lines++;
        if (opts.addNewlines) lines += opts.addNewlines(leading, node) || 0;
        var needs = leading ? needsWhitespaceBefore : needsWhitespaceAfter;
        if (needs(node, parent)) lines++;
      }

      this.newline(Math.min(2, lines));
    };

    _proto._getComments = function _getComments(leading, node) {
      return node && (leading ? node.leadingComments : node.trailingComments) || [];
    };

    _proto._printComment = function _printComment(comment, skipNewLines) {
      var _this2 = this;

      if (!this.format.shouldPrintComment(comment.value)) return;
      if (comment.ignore) return;
      if (this._printedComments.has(comment)) return;

      this._printedComments.add(comment);

      var isBlockComment = comment.type === "CommentBlock";
      var printNewLines = isBlockComment && !skipNewLines && !this._noLineTerminator;
      if (printNewLines && this._buf.hasContent()) this.newline(1);
      var lastCharCode = this.getLastChar();

      if (lastCharCode !== 91 && lastCharCode !== 123) {
        this.space();
      }

      var val = !isBlockComment && !this._noLineTerminator ? "//" + comment.value + "\n" : "/*" + comment.value + "*/";

      if (isBlockComment && this.format.indent.adjustMultilineComment) {
        var _comment$loc;

        var offset = (_comment$loc = comment.loc) == null ? void 0 : _comment$loc.start.column;

        if (offset) {
          var newlineRegex = new RegExp("\\n\\s{1," + offset + "}", "g");
          val = val.replace(newlineRegex, "\n");
        }

        var indentSize = Math.max(this._getIndent().length, this.format.retainLines ? 0 : this._buf.getCurrentColumn());
        val = val.replace(/\n(?!$)/g, "\n" + " ".repeat(indentSize));
      }

      if (this.endsWith(47)) this._space();
      this.withSource("start", comment.loc, function () {
        _this2._append(val);
      });
      if (printNewLines) this.newline(1);
    };

    _proto._printComments = function _printComments(comments, inlinePureAnnotation) {
      if (!(comments != null && comments.length)) return;

      if (inlinePureAnnotation && comments.length === 1 && PURE_ANNOTATION_RE.test(comments[0].value)) {
        this._printComment(comments[0], this._buf.hasContent() && !this.endsWith(10));
      } else {
        for (var _iterator = _createForOfIteratorHelperLoose(comments), _step; !(_step = _iterator()).done;) {
          var _comment = _step.value;

          this._printComment(_comment);
        }
      }
    };

    _proto.printAssertions = function printAssertions(node) {
      var _node$assertions;

      if ((_node$assertions = node.assertions) != null && _node$assertions.length) {
        this.space();
        this.word("assert");
        this.space();
        this.token("{");
        this.space();
        this.printList(node.assertions, node);
        this.space();
        this.token("}");
      }
    };

    return Printer;
  }();

  Object.assign(Printer.prototype, generatorFunctions);
  {
    Printer.prototype.Noop = function Noop() {};
  }

  function commaSeparator() {
    this.token(",");
    this.space();
  }

  var Generator = function (_Printer) {
    _inherits(Generator, _Printer);

    function Generator(ast, opts, code) {
      var _this;

      if (opts === void 0) {
        opts = {};
      }

      var format = normalizeOptions$6(code, opts);
      var map = opts.sourceMaps ? new SourceMap(opts, code) : null;
      _this = _Printer.call(this, format, map) || this;
      _this.ast = void 0;
      _this.ast = ast;
      return _this;
    }

    var _proto = Generator.prototype;

    _proto.generate = function generate() {
      return _Printer.prototype.generate.call(this, this.ast);
    };

    return Generator;
  }(Printer);

  function normalizeOptions$6(code, opts) {
    var format = {
      auxiliaryCommentBefore: opts.auxiliaryCommentBefore,
      auxiliaryCommentAfter: opts.auxiliaryCommentAfter,
      shouldPrintComment: opts.shouldPrintComment,
      retainLines: opts.retainLines,
      retainFunctionParens: opts.retainFunctionParens,
      comments: opts.comments == null || opts.comments,
      compact: opts.compact,
      minified: opts.minified,
      concise: opts.concise,
      indent: {
        adjustMultilineComment: true,
        style: "  ",
        base: 0
      },
      decoratorsBeforeExport: !!opts.decoratorsBeforeExport,
      jsescOption: Object.assign({
        quotes: "double",
        wrap: true,
        minimal: false
      }, opts.jsescOption),
      recordAndTupleSyntaxType: opts.recordAndTupleSyntaxType,
      topicToken: opts.topicToken
    };
    {
      format.jsonCompatibleStrings = opts.jsonCompatibleStrings;
    }

    if (format.minified) {
      format.compact = true;

      format.shouldPrintComment = format.shouldPrintComment || function () {
        return format.comments;
      };
    } else {
      format.shouldPrintComment = format.shouldPrintComment || function (value) {
        return format.comments || value.indexOf("@license") >= 0 || value.indexOf("@preserve") >= 0;
      };
    }

    if (format.compact === "auto") {
      format.compact = code.length > 500000;

      if (format.compact) {
        console.error("[BABEL] Note: The code generator has deoptimised the styling of " + (opts.filename + " as it exceeds the max of " + "500KB" + "."));
      }
    }

    if (format.compact) {
      format.indent.adjustMultilineComment = false;
    }

    return format;
  }
  function generate$1(ast, opts, code) {
    var gen = new Generator(ast, opts, code);
    return gen.generate();
  }

  var VISITOR_KEYS$4 = VISITOR_KEYS$6;
  function findParent(callback) {
    var path = this;

    while (path = path.parentPath) {
      if (callback(path)) return path;
    }

    return null;
  }
  function find$1(callback) {
    var path = this;

    do {
      if (callback(path)) return path;
    } while (path = path.parentPath);

    return null;
  }
  function getFunctionParent() {
    return this.findParent(function (p) {
      return p.isFunction();
    });
  }
  function getStatementParent() {
    var path = this;

    do {
      if (!path.parentPath || Array.isArray(path.container) && path.isStatement()) {
        break;
      } else {
        path = path.parentPath;
      }
    } while (path);

    if (path && (path.isProgram() || path.isFile())) {
      throw new Error("File/Program node, we can't possibly find a statement parent to this");
    }

    return path;
  }
  function getEarliestCommonAncestorFrom(paths) {
    return this.getDeepestCommonAncestorFrom(paths, function (deepest, i, ancestries) {
      var earliest;
      var keys = VISITOR_KEYS$4[deepest.type];

      for (var _iterator = _createForOfIteratorHelperLoose(ancestries), _step; !(_step = _iterator()).done;) {
        var ancestry = _step.value;
        var path = ancestry[i + 1];

        if (!earliest) {
          earliest = path;
          continue;
        }

        if (path.listKey && earliest.listKey === path.listKey) {
          if (path.key < earliest.key) {
            earliest = path;
            continue;
          }
        }

        var earliestKeyIndex = keys.indexOf(earliest.parentKey);
        var currentKeyIndex = keys.indexOf(path.parentKey);

        if (earliestKeyIndex > currentKeyIndex) {
          earliest = path;
        }
      }

      return earliest;
    });
  }
  function getDeepestCommonAncestorFrom(paths, filter) {
    var _this = this;

    if (!paths.length) {
      return this;
    }

    if (paths.length === 1) {
      return paths[0];
    }

    var minDepth = Infinity;
    var lastCommonIndex, lastCommon;
    var ancestries = paths.map(function (path) {
      var ancestry = [];

      do {
        ancestry.unshift(path);
      } while ((path = path.parentPath) && path !== _this);

      if (ancestry.length < minDepth) {
        minDepth = ancestry.length;
      }

      return ancestry;
    });
    var first = ancestries[0];

    depthLoop: for (var _i = 0; _i < minDepth; _i++) {
      var shouldMatch = first[_i];

      for (var _iterator2 = _createForOfIteratorHelperLoose(ancestries), _step2; !(_step2 = _iterator2()).done;) {
        var ancestry = _step2.value;

        if (ancestry[_i] !== shouldMatch) {
          break depthLoop;
        }
      }

      lastCommonIndex = _i;
      lastCommon = shouldMatch;
    }

    if (lastCommon) {
      if (filter) {
        return filter(lastCommon, lastCommonIndex, ancestries);
      } else {
        return lastCommon;
      }
    } else {
      throw new Error("Couldn't find intersection");
    }
  }
  function getAncestry() {
    var path = this;
    var paths = [];

    do {
      paths.push(path);
    } while (path = path.parentPath);

    return paths;
  }
  function isAncestor(maybeDescendant) {
    return maybeDescendant.isDescendant(this);
  }
  function isDescendant(maybeAncestor) {
    return !!this.findParent(function (parent) {
      return parent === maybeAncestor;
    });
  }
  function inType() {
    var path = this;

    for (var _len = arguments.length, candidateTypes = new Array(_len), _key = 0; _key < _len; _key++) {
      candidateTypes[_key] = arguments[_key];
    }

    while (path) {
      for (var _iterator3 = _createForOfIteratorHelperLoose(candidateTypes), _step3; !(_step3 = _iterator3()).done;) {
        var type = _step3.value;
        if (path.node.type === type) return true;
      }

      path = path.parentPath;
    }

    return false;
  }

  var NodePath_ancestry = /*#__PURE__*/Object.freeze({
    __proto__: null,
    findParent: findParent,
    find: find$1,
    getFunctionParent: getFunctionParent,
    getStatementParent: getStatementParent,
    getEarliestCommonAncestorFrom: getEarliestCommonAncestorFrom,
    getDeepestCommonAncestorFrom: getDeepestCommonAncestorFrom,
    getAncestry: getAncestry,
    isAncestor: isAncestor,
    isDescendant: isDescendant,
    inType: inType
  });

  var BOOLEAN_NUMBER_BINARY_OPERATORS = BOOLEAN_NUMBER_BINARY_OPERATORS$1,
      createFlowUnionType$1 = createFlowUnionType$2,
      createTSUnionType$1 = createTSUnionType$2,
      createTypeAnnotationBasedOnTypeof = createTypeAnnotationBasedOnTypeof$1,
      createUnionTypeAnnotation$1 = createFlowUnionType$2,
      isTSTypeAnnotation$1 = isTSTypeAnnotation$2,
      numberTypeAnnotation$1 = numberTypeAnnotation$2,
      voidTypeAnnotation$2 = voidTypeAnnotation$3;
  function infererReference (node) {
    if (!this.isReferenced()) return;
    var binding = this.scope.getBinding(node.name);

    if (binding) {
      if (binding.identifier.typeAnnotation) {
        return binding.identifier.typeAnnotation;
      } else {
        return getTypeAnnotationBindingConstantViolations(binding, this, node.name);
      }
    }

    if (node.name === "undefined") {
      return voidTypeAnnotation$2();
    } else if (node.name === "NaN" || node.name === "Infinity") {
      return numberTypeAnnotation$1();
    } else if (node.name === "arguments") ;
  }

  function getTypeAnnotationBindingConstantViolations(binding, path, name) {
    var types = [];
    var functionConstantViolations = [];
    var constantViolations = getConstantViolationsBefore(binding, path, functionConstantViolations);
    var testType = getConditionalAnnotation(binding, path, name);

    if (testType) {
      var testConstantViolations = getConstantViolationsBefore(binding, testType.ifStatement);
      constantViolations = constantViolations.filter(function (path) {
        return testConstantViolations.indexOf(path) < 0;
      });
      types.push(testType.typeAnnotation);
    }

    if (constantViolations.length) {
      var _constantViolations;

      (_constantViolations = constantViolations).push.apply(_constantViolations, functionConstantViolations);

      for (var _iterator = _createForOfIteratorHelperLoose(constantViolations), _step; !(_step = _iterator()).done;) {
        var violation = _step.value;
        types.push(violation.getTypeAnnotation());
      }
    }

    if (!types.length) {
      return;
    }

    if (isTSTypeAnnotation$1(types[0]) && createTSUnionType$1) {
      return createTSUnionType$1(types);
    }

    if (createFlowUnionType$1) {
      return createFlowUnionType$1(types);
    }

    return createUnionTypeAnnotation$1(types);
  }

  function getConstantViolationsBefore(binding, path, functions) {
    var violations = binding.constantViolations.slice();
    violations.unshift(binding.path);
    return violations.filter(function (violation) {
      violation = violation.resolve();

      var status = violation._guessExecutionStatusRelativeTo(path);

      if (functions && status === "unknown") functions.push(violation);
      return status === "before";
    });
  }

  function inferAnnotationFromBinaryExpression(name, path) {
    var operator = path.node.operator;
    var right = path.get("right").resolve();
    var left = path.get("left").resolve();
    var target;

    if (left.isIdentifier({
      name: name
    })) {
      target = right;
    } else if (right.isIdentifier({
      name: name
    })) {
      target = left;
    }

    if (target) {
      if (operator === "===") {
        return target.getTypeAnnotation();
      }

      if (BOOLEAN_NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
        return numberTypeAnnotation$1();
      }

      return;
    }

    if (operator !== "===" && operator !== "==") return;
    var typeofPath;
    var typePath;

    if (left.isUnaryExpression({
      operator: "typeof"
    })) {
      typeofPath = left;
      typePath = right;
    } else if (right.isUnaryExpression({
      operator: "typeof"
    })) {
      typeofPath = right;
      typePath = left;
    }

    if (!typeofPath) return;
    if (!typeofPath.get("argument").isIdentifier({
      name: name
    })) return;
    typePath = typePath.resolve();
    if (!typePath.isLiteral()) return;
    var typeValue = typePath.node.value;
    if (typeof typeValue !== "string") return;
    return createTypeAnnotationBasedOnTypeof(typeValue);
  }

  function getParentConditionalPath(binding, path, name) {
    var parentPath;

    while (parentPath = path.parentPath) {
      if (parentPath.isIfStatement() || parentPath.isConditionalExpression()) {
        if (path.key === "test") {
          return;
        }

        return parentPath;
      }

      if (parentPath.isFunction()) {
        if (parentPath.parentPath.scope.getBinding(name) !== binding) return;
      }

      path = parentPath;
    }
  }

  function getConditionalAnnotation(binding, path, name) {
    var ifStatement = getParentConditionalPath(binding, path, name);
    if (!ifStatement) return;
    var test = ifStatement.get("test");
    var paths = [test];
    var types = [];

    for (var i = 0; i < paths.length; i++) {
      var _path = paths[i];

      if (_path.isLogicalExpression()) {
        if (_path.node.operator === "&&") {
          paths.push(_path.get("left"));
          paths.push(_path.get("right"));
        }
      } else if (_path.isBinaryExpression()) {
        var type = inferAnnotationFromBinaryExpression(name, _path);
        if (type) types.push(type);
      }
    }

    if (types.length) {
      if (isTSTypeAnnotation$1(types[0]) && createTSUnionType$1) {
        return {
          typeAnnotation: createTSUnionType$1(types),
          ifStatement: ifStatement
        };
      }

      if (createFlowUnionType$1) {
        return {
          typeAnnotation: createFlowUnionType$1(types),
          ifStatement: ifStatement
        };
      }

      return {
        typeAnnotation: createUnionTypeAnnotation$1(types),
        ifStatement: ifStatement
      };
    }

    return getConditionalAnnotation(ifStatement, name);
  }

  var BOOLEAN_BINARY_OPERATORS = BOOLEAN_BINARY_OPERATORS$1,
      BOOLEAN_UNARY_OPERATORS = BOOLEAN_UNARY_OPERATORS$1,
      NUMBER_BINARY_OPERATORS = NUMBER_BINARY_OPERATORS$1,
      NUMBER_UNARY_OPERATORS = NUMBER_UNARY_OPERATORS$1,
      STRING_UNARY_OPERATORS = STRING_UNARY_OPERATORS$1,
      anyTypeAnnotation$1 = anyTypeAnnotation$2,
      arrayTypeAnnotation = arrayTypeAnnotation$1,
      booleanTypeAnnotation = booleanTypeAnnotation$1,
      buildMatchMemberExpression = buildMatchMemberExpression$1,
      createFlowUnionType = createFlowUnionType$2,
      createTSUnionType = createTSUnionType$2,
      createUnionTypeAnnotation = createFlowUnionType$2,
      genericTypeAnnotation = genericTypeAnnotation$1,
      identifier$g = identifier$j,
      isTSTypeAnnotation = isTSTypeAnnotation$2,
      nullLiteralTypeAnnotation = nullLiteralTypeAnnotation$1,
      numberTypeAnnotation = numberTypeAnnotation$2,
      stringTypeAnnotation$1 = stringTypeAnnotation$2,
      tupleTypeAnnotation = tupleTypeAnnotation$1,
      unionTypeAnnotation = unionTypeAnnotation$1,
      voidTypeAnnotation$1 = voidTypeAnnotation$3;
  function VariableDeclarator() {
    var _type;

    var id = this.get("id");
    if (!id.isIdentifier()) return;
    var init = this.get("init");
    var type = init.getTypeAnnotation();

    if (((_type = type) == null ? void 0 : _type.type) === "AnyTypeAnnotation") {
      if (init.isCallExpression() && init.get("callee").isIdentifier({
        name: "Array"
      }) && !init.scope.hasBinding("Array", true)) {
        type = ArrayExpression();
      }
    }

    return type;
  }
  function TypeCastExpression(node) {
    return node.typeAnnotation;
  }
  TypeCastExpression.validParent = true;
  function NewExpression(node) {
    if (this.get("callee").isIdentifier()) {
      return genericTypeAnnotation(node.callee);
    }
  }
  function TemplateLiteral() {
    return stringTypeAnnotation$1();
  }
  function UnaryExpression(node) {
    var operator = node.operator;

    if (operator === "void") {
      return voidTypeAnnotation$1();
    } else if (NUMBER_UNARY_OPERATORS.indexOf(operator) >= 0) {
      return numberTypeAnnotation();
    } else if (STRING_UNARY_OPERATORS.indexOf(operator) >= 0) {
      return stringTypeAnnotation$1();
    } else if (BOOLEAN_UNARY_OPERATORS.indexOf(operator) >= 0) {
      return booleanTypeAnnotation();
    }
  }
  function BinaryExpression(node) {
    var operator = node.operator;

    if (NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
      return numberTypeAnnotation();
    } else if (BOOLEAN_BINARY_OPERATORS.indexOf(operator) >= 0) {
      return booleanTypeAnnotation();
    } else if (operator === "+") {
      var right = this.get("right");
      var left = this.get("left");

      if (left.isBaseType("number") && right.isBaseType("number")) {
        return numberTypeAnnotation();
      } else if (left.isBaseType("string") || right.isBaseType("string")) {
        return stringTypeAnnotation$1();
      }

      return unionTypeAnnotation([stringTypeAnnotation$1(), numberTypeAnnotation()]);
    }
  }
  function LogicalExpression() {
    var argumentTypes = [this.get("left").getTypeAnnotation(), this.get("right").getTypeAnnotation()];

    if (isTSTypeAnnotation(argumentTypes[0]) && createTSUnionType) {
      return createTSUnionType(argumentTypes);
    }

    if (createFlowUnionType) {
      return createFlowUnionType(argumentTypes);
    }

    return createUnionTypeAnnotation(argumentTypes);
  }
  function ConditionalExpression() {
    var argumentTypes = [this.get("consequent").getTypeAnnotation(), this.get("alternate").getTypeAnnotation()];

    if (isTSTypeAnnotation(argumentTypes[0]) && createTSUnionType) {
      return createTSUnionType(argumentTypes);
    }

    if (createFlowUnionType) {
      return createFlowUnionType(argumentTypes);
    }

    return createUnionTypeAnnotation(argumentTypes);
  }
  function SequenceExpression() {
    return this.get("expressions").pop().getTypeAnnotation();
  }
  function ParenthesizedExpression() {
    return this.get("expression").getTypeAnnotation();
  }
  function AssignmentExpression() {
    return this.get("right").getTypeAnnotation();
  }
  function UpdateExpression(node) {
    var operator = node.operator;

    if (operator === "++" || operator === "--") {
      return numberTypeAnnotation();
    }
  }
  function StringLiteral$1() {
    return stringTypeAnnotation$1();
  }
  function NumericLiteral$1() {
    return numberTypeAnnotation();
  }
  function BooleanLiteral() {
    return booleanTypeAnnotation();
  }
  function NullLiteral() {
    return nullLiteralTypeAnnotation();
  }
  function RegExpLiteral() {
    return genericTypeAnnotation(identifier$g("RegExp"));
  }
  function ObjectExpression() {
    return genericTypeAnnotation(identifier$g("Object"));
  }
  function ArrayExpression() {
    return genericTypeAnnotation(identifier$g("Array"));
  }
  function RestElement() {
    return ArrayExpression();
  }
  RestElement.validParent = true;

  function Func() {
    return genericTypeAnnotation(identifier$g("Function"));
  }
  var isArrayFrom = buildMatchMemberExpression("Array.from");
  var isObjectKeys = buildMatchMemberExpression("Object.keys");
  var isObjectValues = buildMatchMemberExpression("Object.values");
  var isObjectEntries = buildMatchMemberExpression("Object.entries");
  function CallExpression() {
    var callee = this.node.callee;

    if (isObjectKeys(callee)) {
      return arrayTypeAnnotation(stringTypeAnnotation$1());
    } else if (isArrayFrom(callee) || isObjectValues(callee)) {
      return arrayTypeAnnotation(anyTypeAnnotation$1());
    } else if (isObjectEntries(callee)) {
      return arrayTypeAnnotation(tupleTypeAnnotation([stringTypeAnnotation$1(), anyTypeAnnotation$1()]));
    }

    return resolveCall(this.get("callee"));
  }
  function TaggedTemplateExpression() {
    return resolveCall(this.get("tag"));
  }

  function resolveCall(callee) {
    callee = callee.resolve();

    if (callee.isFunction()) {
      if (callee.is("async")) {
        if (callee.is("generator")) {
          return genericTypeAnnotation(identifier$g("AsyncIterator"));
        } else {
          return genericTypeAnnotation(identifier$g("Promise"));
        }
      } else {
        if (callee.node.returnType) {
          return callee.node.returnType;
        }
      }
    }
  }

  var inferers = /*#__PURE__*/Object.freeze({
    __proto__: null,
    VariableDeclarator: VariableDeclarator,
    TypeCastExpression: TypeCastExpression,
    NewExpression: NewExpression,
    TemplateLiteral: TemplateLiteral,
    UnaryExpression: UnaryExpression,
    BinaryExpression: BinaryExpression,
    LogicalExpression: LogicalExpression,
    ConditionalExpression: ConditionalExpression,
    SequenceExpression: SequenceExpression,
    ParenthesizedExpression: ParenthesizedExpression,
    AssignmentExpression: AssignmentExpression,
    UpdateExpression: UpdateExpression,
    StringLiteral: StringLiteral$1,
    NumericLiteral: NumericLiteral$1,
    BooleanLiteral: BooleanLiteral,
    NullLiteral: NullLiteral,
    RegExpLiteral: RegExpLiteral,
    ObjectExpression: ObjectExpression,
    ArrayExpression: ArrayExpression,
    RestElement: RestElement,
    FunctionExpression: Func,
    ArrowFunctionExpression: Func,
    FunctionDeclaration: Func,
    ClassExpression: Func,
    ClassDeclaration: Func,
    CallExpression: CallExpression,
    TaggedTemplateExpression: TaggedTemplateExpression,
    Identifier: infererReference
  });

  var anyTypeAnnotation = anyTypeAnnotation$2,
      isAnyTypeAnnotation = isAnyTypeAnnotation$1,
      isBooleanTypeAnnotation = isBooleanTypeAnnotation$1,
      isEmptyTypeAnnotation = isEmptyTypeAnnotation$1,
      isFlowBaseAnnotation = isFlowBaseAnnotation$1,
      isGenericTypeAnnotation = isGenericTypeAnnotation$1,
      isIdentifier$a = isIdentifier$g,
      isMixedTypeAnnotation = isMixedTypeAnnotation$1,
      isNumberTypeAnnotation = isNumberTypeAnnotation$1,
      isStringTypeAnnotation = isStringTypeAnnotation$1,
      isTypeAnnotation = isTypeAnnotation$2,
      isUnionTypeAnnotation = isUnionTypeAnnotation$2,
      isVoidTypeAnnotation = isVoidTypeAnnotation$1,
      stringTypeAnnotation = stringTypeAnnotation$2,
      voidTypeAnnotation = voidTypeAnnotation$3;
  function getTypeAnnotation() {
    if (this.typeAnnotation) return this.typeAnnotation;
    var type = this._getTypeAnnotation() || anyTypeAnnotation();
    if (isTypeAnnotation(type)) type = type.typeAnnotation;
    return this.typeAnnotation = type;
  }
  var typeAnnotationInferringNodes = new WeakSet();
  function _getTypeAnnotation() {
    var node = this.node;

    if (!node) {
      if (this.key === "init" && this.parentPath.isVariableDeclarator()) {
        var declar = this.parentPath.parentPath;
        var declarParent = declar.parentPath;

        if (declar.key === "left" && declarParent.isForInStatement()) {
          return stringTypeAnnotation();
        }

        if (declar.key === "left" && declarParent.isForOfStatement()) {
          return anyTypeAnnotation();
        }

        return voidTypeAnnotation();
      } else {
        return;
      }
    }

    if (node.typeAnnotation) {
      return node.typeAnnotation;
    }

    if (typeAnnotationInferringNodes.has(node)) {
      return;
    }

    typeAnnotationInferringNodes.add(node);

    try {
      var _inferer;

      var inferer = inferers[node.type];

      if (inferer) {
        return inferer.call(this, node);
      }

      inferer = inferers[this.parentPath.type];

      if ((_inferer = inferer) != null && _inferer.validParent) {
        return this.parentPath.getTypeAnnotation();
      }
    } finally {
      typeAnnotationInferringNodes["delete"](node);
    }
  }
  function isBaseType(baseName, soft) {
    return _isBaseType(baseName, this.getTypeAnnotation(), soft);
  }

  function _isBaseType(baseName, type, soft) {
    if (baseName === "string") {
      return isStringTypeAnnotation(type);
    } else if (baseName === "number") {
      return isNumberTypeAnnotation(type);
    } else if (baseName === "boolean") {
      return isBooleanTypeAnnotation(type);
    } else if (baseName === "any") {
      return isAnyTypeAnnotation(type);
    } else if (baseName === "mixed") {
      return isMixedTypeAnnotation(type);
    } else if (baseName === "empty") {
      return isEmptyTypeAnnotation(type);
    } else if (baseName === "void") {
      return isVoidTypeAnnotation(type);
    } else {
      if (soft) {
        return false;
      } else {
        throw new Error("Unknown base type " + baseName);
      }
    }
  }

  function couldBeBaseType(name) {
    var type = this.getTypeAnnotation();
    if (isAnyTypeAnnotation(type)) return true;

    if (isUnionTypeAnnotation(type)) {
      for (var _iterator = _createForOfIteratorHelperLoose(type.types), _step; !(_step = _iterator()).done;) {
        var type2 = _step.value;

        if (isAnyTypeAnnotation(type2) || _isBaseType(name, type2, true)) {
          return true;
        }
      }

      return false;
    } else {
      return _isBaseType(name, type, true);
    }
  }
  function baseTypeStrictlyMatches(rightArg) {
    var left = this.getTypeAnnotation();
    var right = rightArg.getTypeAnnotation();

    if (!isAnyTypeAnnotation(left) && isFlowBaseAnnotation(left)) {
      return right.type === left.type;
    }

    return false;
  }
  function isGenericType(genericName) {
    var type = this.getTypeAnnotation();
    return isGenericTypeAnnotation(type) && isIdentifier$a(type.id, {
      name: genericName
    });
  }

  var NodePath_inference = /*#__PURE__*/Object.freeze({
    __proto__: null,
    getTypeAnnotation: getTypeAnnotation,
    _getTypeAnnotation: _getTypeAnnotation,
    isBaseType: isBaseType,
    couldBeBaseType: couldBeBaseType,
    baseTypeStrictlyMatches: baseTypeStrictlyMatches,
    isGenericType: isGenericType
  });

  var runtime_1 = createCommonjsModule(function (module) {
    var runtime = function (exports) {

      var Op = Object.prototype;
      var hasOwn = Op.hasOwnProperty;
      var undefined$1;
      var $Symbol = typeof Symbol === "function" ? Symbol : {};
      var iteratorSymbol = $Symbol.iterator || "@@iterator";
      var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
      var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

      function define(obj, key, value) {
        Object.defineProperty(obj, key, {
          value: value,
          enumerable: true,
          configurable: true,
          writable: true
        });
        return obj[key];
      }

      try {
        define({}, "");
      } catch (err) {
        define = function define(obj, key, value) {
          return obj[key] = value;
        };
      }

      function wrap(innerFn, outerFn, self, tryLocsList) {
        var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
        var generator = Object.create(protoGenerator.prototype);
        var context = new Context(tryLocsList || []);
        generator._invoke = makeInvokeMethod(innerFn, self, context);
        return generator;
      }

      exports.wrap = wrap;

      function tryCatch(fn, obj, arg) {
        try {
          return {
            type: "normal",
            arg: fn.call(obj, arg)
          };
        } catch (err) {
          return {
            type: "throw",
            arg: err
          };
        }
      }

      var GenStateSuspendedStart = "suspendedStart";
      var GenStateSuspendedYield = "suspendedYield";
      var GenStateExecuting = "executing";
      var GenStateCompleted = "completed";
      var ContinueSentinel = {};

      function Generator() {}

      function GeneratorFunction() {}

      function GeneratorFunctionPrototype() {}

      var IteratorPrototype = {};

      IteratorPrototype[iteratorSymbol] = function () {
        return this;
      };

      var getProto = Object.getPrototypeOf;
      var NativeIteratorPrototype = getProto && getProto(getProto(values([])));

      if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
        IteratorPrototype = NativeIteratorPrototype;
      }

      var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
      GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
      GeneratorFunctionPrototype.constructor = GeneratorFunction;
      GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction");

      function defineIteratorMethods(prototype) {
        ["next", "throw", "return"].forEach(function (method) {
          define(prototype, method, function (arg) {
            return this._invoke(method, arg);
          });
        });
      }

      exports.isGeneratorFunction = function (genFun) {
        var ctor = typeof genFun === "function" && genFun.constructor;
        return ctor ? ctor === GeneratorFunction || (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
      };

      exports.mark = function (genFun) {
        if (Object.setPrototypeOf) {
          Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
        } else {
          genFun.__proto__ = GeneratorFunctionPrototype;
          define(genFun, toStringTagSymbol, "GeneratorFunction");
        }

        genFun.prototype = Object.create(Gp);
        return genFun;
      };

      exports.awrap = function (arg) {
        return {
          __await: arg
        };
      };

      function AsyncIterator(generator, PromiseImpl) {
        function invoke(method, arg, resolve, reject) {
          var record = tryCatch(generator[method], generator, arg);

          if (record.type === "throw") {
            reject(record.arg);
          } else {
            var result = record.arg;
            var value = result.value;

            if (value && typeof value === "object" && hasOwn.call(value, "__await")) {
              return PromiseImpl.resolve(value.__await).then(function (value) {
                invoke("next", value, resolve, reject);
              }, function (err) {
                invoke("throw", err, resolve, reject);
              });
            }

            return PromiseImpl.resolve(value).then(function (unwrapped) {
              result.value = unwrapped;
              resolve(result);
            }, function (error) {
              return invoke("throw", error, resolve, reject);
            });
          }
        }

        var previousPromise;

        function enqueue(method, arg) {
          function callInvokeWithMethodAndArg() {
            return new PromiseImpl(function (resolve, reject) {
              invoke(method, arg, resolve, reject);
            });
          }

          return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
        }

        this._invoke = enqueue;
      }

      defineIteratorMethods(AsyncIterator.prototype);

      AsyncIterator.prototype[asyncIteratorSymbol] = function () {
        return this;
      };

      exports.AsyncIterator = AsyncIterator;

      exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
        if (PromiseImpl === void 0) PromiseImpl = Promise;
        var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
        return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
          return result.done ? result.value : iter.next();
        });
      };

      function makeInvokeMethod(innerFn, self, context) {
        var state = GenStateSuspendedStart;
        return function invoke(method, arg) {
          if (state === GenStateExecuting) {
            throw new Error("Generator is already running");
          }

          if (state === GenStateCompleted) {
            if (method === "throw") {
              throw arg;
            }

            return doneResult();
          }

          context.method = method;
          context.arg = arg;

          while (true) {
            var delegate = context.delegate;

            if (delegate) {
              var delegateResult = maybeInvokeDelegate(delegate, context);

              if (delegateResult) {
                if (delegateResult === ContinueSentinel) continue;
                return delegateResult;
              }
            }

            if (context.method === "next") {
              context.sent = context._sent = context.arg;
            } else if (context.method === "throw") {
              if (state === GenStateSuspendedStart) {
                state = GenStateCompleted;
                throw context.arg;
              }

              context.dispatchException(context.arg);
            } else if (context.method === "return") {
              context.abrupt("return", context.arg);
            }

            state = GenStateExecuting;
            var record = tryCatch(innerFn, self, context);

            if (record.type === "normal") {
              state = context.done ? GenStateCompleted : GenStateSuspendedYield;

              if (record.arg === ContinueSentinel) {
                continue;
              }

              return {
                value: record.arg,
                done: context.done
              };
            } else if (record.type === "throw") {
              state = GenStateCompleted;
              context.method = "throw";
              context.arg = record.arg;
            }
          }
        };
      }

      function maybeInvokeDelegate(delegate, context) {
        var method = delegate.iterator[context.method];

        if (method === undefined$1) {
          context.delegate = null;

          if (context.method === "throw") {
            if (delegate.iterator["return"]) {
              context.method = "return";
              context.arg = undefined$1;
              maybeInvokeDelegate(delegate, context);

              if (context.method === "throw") {
                return ContinueSentinel;
              }
            }

            context.method = "throw";
            context.arg = new TypeError("The iterator does not provide a 'throw' method");
          }

          return ContinueSentinel;
        }

        var record = tryCatch(method, delegate.iterator, context.arg);

        if (record.type === "throw") {
          context.method = "throw";
          context.arg = record.arg;
          context.delegate = null;
          return ContinueSentinel;
        }

        var info = record.arg;

        if (!info) {
          context.method = "throw";
          context.arg = new TypeError("iterator result is not an object");
          context.delegate = null;
          return ContinueSentinel;
        }

        if (info.done) {
          context[delegate.resultName] = info.value;
          context.next = delegate.nextLoc;

          if (context.method !== "return") {
            context.method = "next";
            context.arg = undefined$1;
          }
        } else {
          return info;
        }

        context.delegate = null;
        return ContinueSentinel;
      }

      defineIteratorMethods(Gp);
      define(Gp, toStringTagSymbol, "Generator");

      Gp[iteratorSymbol] = function () {
        return this;
      };

      Gp.toString = function () {
        return "[object Generator]";
      };

      function pushTryEntry(locs) {
        var entry = {
          tryLoc: locs[0]
        };

        if (1 in locs) {
          entry.catchLoc = locs[1];
        }

        if (2 in locs) {
          entry.finallyLoc = locs[2];
          entry.afterLoc = locs[3];
        }

        this.tryEntries.push(entry);
      }

      function resetTryEntry(entry) {
        var record = entry.completion || {};
        record.type = "normal";
        delete record.arg;
        entry.completion = record;
      }

      function Context(tryLocsList) {
        this.tryEntries = [{
          tryLoc: "root"
        }];
        tryLocsList.forEach(pushTryEntry, this);
        this.reset(true);
      }

      exports.keys = function (object) {
        var keys = [];

        for (var key in object) {
          keys.push(key);
        }

        keys.reverse();
        return function next() {
          while (keys.length) {
            var key = keys.pop();

            if (key in object) {
              next.value = key;
              next.done = false;
              return next;
            }
          }

          next.done = true;
          return next;
        };
      };

      function values(iterable) {
        if (iterable) {
          var iteratorMethod = iterable[iteratorSymbol];

          if (iteratorMethod) {
            return iteratorMethod.call(iterable);
          }

          if (typeof iterable.next === "function") {
            return iterable;
          }

          if (!isNaN(iterable.length)) {
            var i = -1,
                next = function next() {
              while (++i < iterable.length) {
                if (hasOwn.call(iterable, i)) {
                  next.value = iterable[i];
                  next.done = false;
                  return next;
                }
              }

              next.value = undefined$1;
              next.done = true;
              return next;
            };

            return next.next = next;
          }
        }

        return {
          next: doneResult
        };
      }

      exports.values = values;

      function doneResult() {
        return {
          value: undefined$1,
          done: true
        };
      }

      Context.prototype = {
        constructor: Context,
        reset: function reset(skipTempReset) {
          this.prev = 0;
          this.next = 0;
          this.sent = this._sent = undefined$1;
          this.done = false;
          this.delegate = null;
          this.method = "next";
          this.arg = undefined$1;
          this.tryEntries.forEach(resetTryEntry);

          if (!skipTempReset) {
            for (var name in this) {
              if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
                this[name] = undefined$1;
              }
            }
          }
        },
        stop: function stop() {
          this.done = true;
          var rootEntry = this.tryEntries[0];
          var rootRecord = rootEntry.completion;

          if (rootRecord.type === "throw") {
            throw rootRecord.arg;
          }

          return this.rval;
        },
        dispatchException: function dispatchException(exception) {
          if (this.done) {
            throw exception;
          }

          var context = this;

          function handle(loc, caught) {
            record.type = "throw";
            record.arg = exception;
            context.next = loc;

            if (caught) {
              context.method = "next";
              context.arg = undefined$1;
            }

            return !!caught;
          }

          for (var i = this.tryEntries.length - 1; i >= 0; --i) {
            var entry = this.tryEntries[i];
            var record = entry.completion;

            if (entry.tryLoc === "root") {
              return handle("end");
            }

            if (entry.tryLoc <= this.prev) {
              var hasCatch = hasOwn.call(entry, "catchLoc");
              var hasFinally = hasOwn.call(entry, "finallyLoc");

              if (hasCatch && hasFinally) {
                if (this.prev < entry.catchLoc) {
                  return handle(entry.catchLoc, true);
                } else if (this.prev < entry.finallyLoc) {
                  return handle(entry.finallyLoc);
                }
              } else if (hasCatch) {
                if (this.prev < entry.catchLoc) {
                  return handle(entry.catchLoc, true);
                }
              } else if (hasFinally) {
                if (this.prev < entry.finallyLoc) {
                  return handle(entry.finallyLoc);
                }
              } else {
                throw new Error("try statement without catch or finally");
              }
            }
          }
        },
        abrupt: function abrupt(type, arg) {
          for (var i = this.tryEntries.length - 1; i >= 0; --i) {
            var entry = this.tryEntries[i];

            if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
              var finallyEntry = entry;
              break;
            }
          }

          if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
            finallyEntry = null;
          }

          var record = finallyEntry ? finallyEntry.completion : {};
          record.type = type;
          record.arg = arg;

          if (finallyEntry) {
            this.method = "next";
            this.next = finallyEntry.finallyLoc;
            return ContinueSentinel;
          }

          return this.complete(record);
        },
        complete: function complete(record, afterLoc) {
          if (record.type === "throw") {
            throw record.arg;
          }

          if (record.type === "break" || record.type === "continue") {
            this.next = record.arg;
          } else if (record.type === "return") {
            this.rval = this.arg = record.arg;
            this.method = "return";
            this.next = "end";
          } else if (record.type === "normal" && afterLoc) {
            this.next = afterLoc;
          }

          return ContinueSentinel;
        },
        finish: function finish(finallyLoc) {
          for (var i = this.tryEntries.length - 1; i >= 0; --i) {
            var entry = this.tryEntries[i];

            if (entry.finallyLoc === finallyLoc) {
              this.complete(entry.completion, entry.afterLoc);
              resetTryEntry(entry);
              return ContinueSentinel;
            }
          }
        },
        "catch": function _catch(tryLoc) {
          for (var i = this.tryEntries.length - 1; i >= 0; --i) {
            var entry = this.tryEntries[i];

            if (entry.tryLoc === tryLoc) {
              var record = entry.completion;

              if (record.type === "throw") {
                var thrown = record.arg;
                resetTryEntry(entry);
              }

              return thrown;
            }
          }

          throw new Error("illegal catch attempt");
        },
        delegateYield: function delegateYield(iterable, resultName, nextLoc) {
          this.delegate = {
            iterator: values(iterable),
            resultName: resultName,
            nextLoc: nextLoc
          };

          if (this.method === "next") {
            this.arg = undefined$1;
          }

          return ContinueSentinel;
        }
      };
      return exports;
    }(module.exports );

    try {
      regeneratorRuntime = runtime;
    } catch (accidentalStrictMode) {
      Function("r", "regeneratorRuntime = r")(runtime);
    }
  }, "/$$rollup_base$$/node_modules/regenerator-runtime");

  var regenerator = runtime_1;

  var IdentifierName, JSXIdentifier, JSXPunctuator, JSXString, JSXText, KeywordsWithExpressionAfter, KeywordsWithNoLineTerminatorAfter, LineTerminatorSequence, MultiLineComment, Newline, NumericLiteral, Punctuator, RegularExpressionLiteral, SingleLineComment, StringLiteral, Template, TokensNotPrecedingObjectLiteral, TokensPrecedingExpression, WhiteSpace;
  RegularExpressionLiteral = new RegExp("\\/(?![\\*\\/])(?:\\[(?:(?![\\\\\\]])(?:[\\0-\\t\\x0B\\f\\x0E-\\u2027\\u202A-\\uD7FF\\uE000-\\uFFFF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]|[\\uD800-\\uDBFF](?![\\uDC00-\\uDFFF])|(?:[^\\uD800-\\uDBFF]|^)[\\uDC00-\\uDFFF])|\\\\(?:[\\0-\\t\\x0B\\f\\x0E-\\u2027\\u202A-\\uD7FF\\uE000-\\uFFFF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]|[\\uD800-\\uDBFF](?![\\uDC00-\\uDFFF])|(?:[^\\uD800-\\uDBFF]|^)[\\uDC00-\\uDFFF]))*\\]|(?![\\/\\\\\\]])(?:[\\0-\\t\\x0B\\f\\x0E-\\u2027\\u202A-\\uD7FF\\uE000-\\uFFFF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]|[\\uD800-\\uDBFF](?![\\uDC00-\\uDFFF])|(?:[^\\uD800-\\uDBFF]|^)[\\uDC00-\\uDFFF])|\\\\(?:[\\0-\\t\\x0B\\f\\x0E-\\u2027\\u202A-\\uD7FF\\uE000-\\uFFFF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]|[\\uD800-\\uDBFF](?![\\uDC00-\\uDFFF])|(?:[^\\uD800-\\uDBFF]|^)[\\uDC00-\\uDFFF]))*(\\/(?:[\\$0-9A-Z_a-z\\xAA\\xB5\\xB7\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0300-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u0483-\\u0487\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0560-\\u0588\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u05D0-\\u05EA\\u05EF-\\u05F2\\u0610-\\u061A\\u0620-\\u0669\\u066E-\\u06D3\\u06D5-\\u06DC\\u06DF-\\u06E8\\u06EA-\\u06FC\\u06FF\\u0710-\\u074A\\u074D-\\u07B1\\u07C0-\\u07F5\\u07FA\\u07FD\\u0800-\\u082D\\u0840-\\u085B\\u0860-\\u086A\\u08A0-\\u08B4\\u08B6-\\u08C7\\u08D3-\\u08E1\\u08E3-\\u0963\\u0966-\\u096F\\u0971-\\u0983\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BC-\\u09C4\\u09C7\\u09C8\\u09CB-\\u09CE\\u09D7\\u09DC\\u09DD\\u09DF-\\u09E3\\u09E6-\\u09F1\\u09FC\\u09FE\\u0A01-\\u0A03\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A3C\\u0A3E-\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A59-\\u0A5C\\u0A5E\\u0A66-\\u0A75\\u0A81-\\u0A83\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABC-\\u0AC5\\u0AC7-\\u0AC9\\u0ACB-\\u0ACD\\u0AD0\\u0AE0-\\u0AE3\\u0AE6-\\u0AEF\\u0AF9-\\u0AFF\\u0B01-\\u0B03\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3C-\\u0B44\\u0B47\\u0B48\\u0B4B-\\u0B4D\\u0B55-\\u0B57\\u0B5C\\u0B5D\\u0B5F-\\u0B63\\u0B66-\\u0B6F\\u0B71\\u0B82\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BBE-\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCD\\u0BD0\\u0BD7\\u0BE6-\\u0BEF\\u0C00-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D-\\u0C44\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C58-\\u0C5A\\u0C60-\\u0C63\\u0C66-\\u0C6F\\u0C80-\\u0C83\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBC-\\u0CC4\\u0CC6-\\u0CC8\\u0CCA-\\u0CCD\\u0CD5\\u0CD6\\u0CDE\\u0CE0-\\u0CE3\\u0CE6-\\u0CEF\\u0CF1\\u0CF2\\u0D00-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D44\\u0D46-\\u0D48\\u0D4A-\\u0D4E\\u0D54-\\u0D57\\u0D5F-\\u0D63\\u0D66-\\u0D6F\\u0D7A-\\u0D7F\\u0D81-\\u0D83\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0DCA\\u0DCF-\\u0DD4\\u0DD6\\u0DD8-\\u0DDF\\u0DE6-\\u0DEF\\u0DF2\\u0DF3\\u0E01-\\u0E3A\\u0E40-\\u0E4E\\u0E50-\\u0E59\\u0E81\\u0E82\\u0E84\\u0E86-\\u0E8A\\u0E8C-\\u0EA3\\u0EA5\\u0EA7-\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EC8-\\u0ECD\\u0ED0-\\u0ED9\\u0EDC-\\u0EDF\\u0F00\\u0F18\\u0F19\\u0F20-\\u0F29\\u0F35\\u0F37\\u0F39\\u0F3E-\\u0F47\\u0F49-\\u0F6C\\u0F71-\\u0F84\\u0F86-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u1000-\\u1049\\u1050-\\u109D\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u135D-\\u135F\\u1369-\\u1371\\u1380-\\u138F\\u13A0-\\u13F5\\u13F8-\\u13FD\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1714\\u1720-\\u1734\\u1740-\\u1753\\u1760-\\u176C\\u176E-\\u1770\\u1772\\u1773\\u1780-\\u17D3\\u17D7\\u17DC\\u17DD\\u17E0-\\u17E9\\u180B-\\u180D\\u1810-\\u1819\\u1820-\\u1878\\u1880-\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1920-\\u192B\\u1930-\\u193B\\u1946-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19B0-\\u19C9\\u19D0-\\u19DA\\u1A00-\\u1A1B\\u1A20-\\u1A5E\\u1A60-\\u1A7C\\u1A7F-\\u1A89\\u1A90-\\u1A99\\u1AA7\\u1AB0-\\u1ABD\\u1ABF\\u1AC0\\u1B00-\\u1B4B\\u1B50-\\u1B59\\u1B6B-\\u1B73\\u1B80-\\u1BF3\\u1C00-\\u1C37\\u1C40-\\u1C49\\u1C4D-\\u1C7D\\u1C80-\\u1C88\\u1C90-\\u1CBA\\u1CBD-\\u1CBF\\u1CD0-\\u1CD2\\u1CD4-\\u1CFA\\u1D00-\\u1DF9\\u1DFB-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u200C\\u200D\\u203F\\u2040\\u2054\\u2071\\u207F\\u2090-\\u209C\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2118-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D7F-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2DE0-\\u2DFF\\u3005-\\u3007\\u3021-\\u302F\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u3099-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312F\\u3131-\\u318E\\u31A0-\\u31BF\\u31F0-\\u31FF\\u3400-\\u4DBF\\u4E00-\\u9FFC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA62B\\uA640-\\uA66F\\uA674-\\uA67D\\uA67F-\\uA6F1\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA7BF\\uA7C2-\\uA7CA\\uA7F5-\\uA827\\uA82C\\uA840-\\uA873\\uA880-\\uA8C5\\uA8D0-\\uA8D9\\uA8E0-\\uA8F7\\uA8FB\\uA8FD-\\uA92D\\uA930-\\uA953\\uA960-\\uA97C\\uA980-\\uA9C0\\uA9CF-\\uA9D9\\uA9E0-\\uA9FE\\uAA00-\\uAA36\\uAA40-\\uAA4D\\uAA50-\\uAA59\\uAA60-\\uAA76\\uAA7A-\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEF\\uAAF2-\\uAAF6\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB69\\uAB70-\\uABEA\\uABEC\\uABED\\uABF0-\\uABF9\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE00-\\uFE0F\\uFE20-\\uFE2F\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF10-\\uFF19\\uFF21-\\uFF3A\\uFF3F\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]|\\uD800[\\uDC00-\\uDC0B\\uDC0D-\\uDC26\\uDC28-\\uDC3A\\uDC3C\\uDC3D\\uDC3F-\\uDC4D\\uDC50-\\uDC5D\\uDC80-\\uDCFA\\uDD40-\\uDD74\\uDDFD\\uDE80-\\uDE9C\\uDEA0-\\uDED0\\uDEE0\\uDF00-\\uDF1F\\uDF2D-\\uDF4A\\uDF50-\\uDF7A\\uDF80-\\uDF9D\\uDFA0-\\uDFC3\\uDFC8-\\uDFCF\\uDFD1-\\uDFD5]|\\uD801[\\uDC00-\\uDC9D\\uDCA0-\\uDCA9\\uDCB0-\\uDCD3\\uDCD8-\\uDCFB\\uDD00-\\uDD27\\uDD30-\\uDD63\\uDE00-\\uDF36\\uDF40-\\uDF55\\uDF60-\\uDF67]|\\uD802[\\uDC00-\\uDC05\\uDC08\\uDC0A-\\uDC35\\uDC37\\uDC38\\uDC3C\\uDC3F-\\uDC55\\uDC60-\\uDC76\\uDC80-\\uDC9E\\uDCE0-\\uDCF2\\uDCF4\\uDCF5\\uDD00-\\uDD15\\uDD20-\\uDD39\\uDD80-\\uDDB7\\uDDBE\\uDDBF\\uDE00-\\uDE03\\uDE05\\uDE06\\uDE0C-\\uDE13\\uDE15-\\uDE17\\uDE19-\\uDE35\\uDE38-\\uDE3A\\uDE3F\\uDE60-\\uDE7C\\uDE80-\\uDE9C\\uDEC0-\\uDEC7\\uDEC9-\\uDEE6\\uDF00-\\uDF35\\uDF40-\\uDF55\\uDF60-\\uDF72\\uDF80-\\uDF91]|\\uD803[\\uDC00-\\uDC48\\uDC80-\\uDCB2\\uDCC0-\\uDCF2\\uDD00-\\uDD27\\uDD30-\\uDD39\\uDE80-\\uDEA9\\uDEAB\\uDEAC\\uDEB0\\uDEB1\\uDF00-\\uDF1C\\uDF27\\uDF30-\\uDF50\\uDFB0-\\uDFC4\\uDFE0-\\uDFF6]|\\uD804[\\uDC00-\\uDC46\\uDC66-\\uDC6F\\uDC7F-\\uDCBA\\uDCD0-\\uDCE8\\uDCF0-\\uDCF9\\uDD00-\\uDD34\\uDD36-\\uDD3F\\uDD44-\\uDD47\\uDD50-\\uDD73\\uDD76\\uDD80-\\uDDC4\\uDDC9-\\uDDCC\\uDDCE-\\uDDDA\\uDDDC\\uDE00-\\uDE11\\uDE13-\\uDE37\\uDE3E\\uDE80-\\uDE86\\uDE88\\uDE8A-\\uDE8D\\uDE8F-\\uDE9D\\uDE9F-\\uDEA8\\uDEB0-\\uDEEA\\uDEF0-\\uDEF9\\uDF00-\\uDF03\\uDF05-\\uDF0C\\uDF0F\\uDF10\\uDF13-\\uDF28\\uDF2A-\\uDF30\\uDF32\\uDF33\\uDF35-\\uDF39\\uDF3B-\\uDF44\\uDF47\\uDF48\\uDF4B-\\uDF4D\\uDF50\\uDF57\\uDF5D-\\uDF63\\uDF66-\\uDF6C\\uDF70-\\uDF74]|\\uD805[\\uDC00-\\uDC4A\\uDC50-\\uDC59\\uDC5E-\\uDC61\\uDC80-\\uDCC5\\uDCC7\\uDCD0-\\uDCD9\\uDD80-\\uDDB5\\uDDB8-\\uDDC0\\uDDD8-\\uDDDD\\uDE00-\\uDE40\\uDE44\\uDE50-\\uDE59\\uDE80-\\uDEB8\\uDEC0-\\uDEC9\\uDF00-\\uDF1A\\uDF1D-\\uDF2B\\uDF30-\\uDF39]|\\uD806[\\uDC00-\\uDC3A\\uDCA0-\\uDCE9\\uDCFF-\\uDD06\\uDD09\\uDD0C-\\uDD13\\uDD15\\uDD16\\uDD18-\\uDD35\\uDD37\\uDD38\\uDD3B-\\uDD43\\uDD50-\\uDD59\\uDDA0-\\uDDA7\\uDDAA-\\uDDD7\\uDDDA-\\uDDE1\\uDDE3\\uDDE4\\uDE00-\\uDE3E\\uDE47\\uDE50-\\uDE99\\uDE9D\\uDEC0-\\uDEF8]|\\uD807[\\uDC00-\\uDC08\\uDC0A-\\uDC36\\uDC38-\\uDC40\\uDC50-\\uDC59\\uDC72-\\uDC8F\\uDC92-\\uDCA7\\uDCA9-\\uDCB6\\uDD00-\\uDD06\\uDD08\\uDD09\\uDD0B-\\uDD36\\uDD3A\\uDD3C\\uDD3D\\uDD3F-\\uDD47\\uDD50-\\uDD59\\uDD60-\\uDD65\\uDD67\\uDD68\\uDD6A-\\uDD8E\\uDD90\\uDD91\\uDD93-\\uDD98\\uDDA0-\\uDDA9\\uDEE0-\\uDEF6\\uDFB0]|\\uD808[\\uDC00-\\uDF99]|\\uD809[\\uDC00-\\uDC6E\\uDC80-\\uDD43]|[\\uD80C\\uD81C-\\uD820\\uD822\\uD840-\\uD868\\uD86A-\\uD86C\\uD86F-\\uD872\\uD874-\\uD879\\uD880-\\uD883][\\uDC00-\\uDFFF]|\\uD80D[\\uDC00-\\uDC2E]|\\uD811[\\uDC00-\\uDE46]|\\uD81A[\\uDC00-\\uDE38\\uDE40-\\uDE5E\\uDE60-\\uDE69\\uDED0-\\uDEED\\uDEF0-\\uDEF4\\uDF00-\\uDF36\\uDF40-\\uDF43\\uDF50-\\uDF59\\uDF63-\\uDF77\\uDF7D-\\uDF8F]|\\uD81B[\\uDE40-\\uDE7F\\uDF00-\\uDF4A\\uDF4F-\\uDF87\\uDF8F-\\uDF9F\\uDFE0\\uDFE1\\uDFE3\\uDFE4\\uDFF0\\uDFF1]|\\uD821[\\uDC00-\\uDFF7]|\\uD823[\\uDC00-\\uDCD5\\uDD00-\\uDD08]|\\uD82C[\\uDC00-\\uDD1E\\uDD50-\\uDD52\\uDD64-\\uDD67\\uDD70-\\uDEFB]|\\uD82F[\\uDC00-\\uDC6A\\uDC70-\\uDC7C\\uDC80-\\uDC88\\uDC90-\\uDC99\\uDC9D\\uDC9E]|\\uD834[\\uDD65-\\uDD69\\uDD6D-\\uDD72\\uDD7B-\\uDD82\\uDD85-\\uDD8B\\uDDAA-\\uDDAD\\uDE42-\\uDE44]|\\uD835[\\uDC00-\\uDC54\\uDC56-\\uDC9C\\uDC9E\\uDC9F\\uDCA2\\uDCA5\\uDCA6\\uDCA9-\\uDCAC\\uDCAE-\\uDCB9\\uDCBB\\uDCBD-\\uDCC3\\uDCC5-\\uDD05\\uDD07-\\uDD0A\\uDD0D-\\uDD14\\uDD16-\\uDD1C\\uDD1E-\\uDD39\\uDD3B-\\uDD3E\\uDD40-\\uDD44\\uDD46\\uDD4A-\\uDD50\\uDD52-\\uDEA5\\uDEA8-\\uDEC0\\uDEC2-\\uDEDA\\uDEDC-\\uDEFA\\uDEFC-\\uDF14\\uDF16-\\uDF34\\uDF36-\\uDF4E\\uDF50-\\uDF6E\\uDF70-\\uDF88\\uDF8A-\\uDFA8\\uDFAA-\\uDFC2\\uDFC4-\\uDFCB\\uDFCE-\\uDFFF]|\\uD836[\\uDE00-\\uDE36\\uDE3B-\\uDE6C\\uDE75\\uDE84\\uDE9B-\\uDE9F\\uDEA1-\\uDEAF]|\\uD838[\\uDC00-\\uDC06\\uDC08-\\uDC18\\uDC1B-\\uDC21\\uDC23\\uDC24\\uDC26-\\uDC2A\\uDD00-\\uDD2C\\uDD30-\\uDD3D\\uDD40-\\uDD49\\uDD4E\\uDEC0-\\uDEF9]|\\uD83A[\\uDC00-\\uDCC4\\uDCD0-\\uDCD6\\uDD00-\\uDD4B\\uDD50-\\uDD59]|\\uD83B[\\uDE00-\\uDE03\\uDE05-\\uDE1F\\uDE21\\uDE22\\uDE24\\uDE27\\uDE29-\\uDE32\\uDE34-\\uDE37\\uDE39\\uDE3B\\uDE42\\uDE47\\uDE49\\uDE4B\\uDE4D-\\uDE4F\\uDE51\\uDE52\\uDE54\\uDE57\\uDE59\\uDE5B\\uDE5D\\uDE5F\\uDE61\\uDE62\\uDE64\\uDE67-\\uDE6A\\uDE6C-\\uDE72\\uDE74-\\uDE77\\uDE79-\\uDE7C\\uDE7E\\uDE80-\\uDE89\\uDE8B-\\uDE9B\\uDEA1-\\uDEA3\\uDEA5-\\uDEA9\\uDEAB-\\uDEBB]|\\uD83E[\\uDFF0-\\uDFF9]|\\uD869[\\uDC00-\\uDEDD\\uDF00-\\uDFFF]|\\uD86D[\\uDC00-\\uDF34\\uDF40-\\uDFFF]|\\uD86E[\\uDC00-\\uDC1D\\uDC20-\\uDFFF]|\\uD873[\\uDC00-\\uDEA1\\uDEB0-\\uDFFF]|\\uD87A[\\uDC00-\\uDFE0]|\\uD87E[\\uDC00-\\uDE1D]|\\uD884[\\uDC00-\\uDF4A]|\\uDB40[\\uDD00-\\uDDEF])*|\\\\)?", "y");
  Punctuator = new RegExp("--|\\+\\+|=>|\\.{3}|\\??\\.(?!\\d)|(?:&&|\\|\\||\\?\\?|[+\\-%&|^]|\\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2}|\\/(?![\\/*]))=?|[?~,:;[\\](){}]", "y");
  IdentifierName = new RegExp("(?=(?:[\\$A-Z\\\\_a-z\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0370-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0560-\\u0588\\u05D0-\\u05EA\\u05EF-\\u05F2\\u0620-\\u064A\\u066E\\u066F\\u0671-\\u06D3\\u06D5\\u06E5\\u06E6\\u06EE\\u06EF\\u06FA-\\u06FC\\u06FF\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1\\u07CA-\\u07EA\\u07F4\\u07F5\\u07FA\\u0800-\\u0815\\u081A\\u0824\\u0828\\u0840-\\u0858\\u0860-\\u086A\\u08A0-\\u08B4\\u08B6-\\u08C7\\u0904-\\u0939\\u093D\\u0950\\u0958-\\u0961\\u0971-\\u0980\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BD\\u09CE\\u09DC\\u09DD\\u09DF-\\u09E1\\u09F0\\u09F1\\u09FC\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A59-\\u0A5C\\u0A5E\\u0A72-\\u0A74\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABD\\u0AD0\\u0AE0\\u0AE1\\u0AF9\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3D\\u0B5C\\u0B5D\\u0B5F-\\u0B61\\u0B71\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BD0\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D\\u0C58-\\u0C5A\\u0C60\\u0C61\\u0C80\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBD\\u0CDE\\u0CE0\\u0CE1\\u0CF1\\u0CF2\\u0D04-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D\\u0D4E\\u0D54-\\u0D56\\u0D5F-\\u0D61\\u0D7A-\\u0D7F\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0E01-\\u0E30\\u0E32\\u0E33\\u0E40-\\u0E46\\u0E81\\u0E82\\u0E84\\u0E86-\\u0E8A\\u0E8C-\\u0EA3\\u0EA5\\u0EA7-\\u0EB0\\u0EB2\\u0EB3\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EDC-\\u0EDF\\u0F00\\u0F40-\\u0F47\\u0F49-\\u0F6C\\u0F88-\\u0F8C\\u1000-\\u102A\\u103F\\u1050-\\u1055\\u105A-\\u105D\\u1061\\u1065\\u1066\\u106E-\\u1070\\u1075-\\u1081\\u108E\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u1380-\\u138F\\u13A0-\\u13F5\\u13F8-\\u13FD\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176C\\u176E-\\u1770\\u1780-\\u17B3\\u17D7\\u17DC\\u1820-\\u1878\\u1880-\\u18A8\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1950-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19B0-\\u19C9\\u1A00-\\u1A16\\u1A20-\\u1A54\\u1AA7\\u1B05-\\u1B33\\u1B45-\\u1B4B\\u1B83-\\u1BA0\\u1BAE\\u1BAF\\u1BBA-\\u1BE5\\u1C00-\\u1C23\\u1C4D-\\u1C4F\\u1C5A-\\u1C7D\\u1C80-\\u1C88\\u1C90-\\u1CBA\\u1CBD-\\u1CBF\\u1CE9-\\u1CEC\\u1CEE-\\u1CF3\\u1CF5\\u1CF6\\u1CFA\\u1D00-\\u1DBF\\u1E00-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u2071\\u207F\\u2090-\\u209C\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2118-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CEE\\u2CF2\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u309B-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312F\\u3131-\\u318E\\u31A0-\\u31BF\\u31F0-\\u31FF\\u3400-\\u4DBF\\u4E00-\\u9FFC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA61F\\uA62A\\uA62B\\uA640-\\uA66E\\uA67F-\\uA69D\\uA6A0-\\uA6EF\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA7BF\\uA7C2-\\uA7CA\\uA7F5-\\uA801\\uA803-\\uA805\\uA807-\\uA80A\\uA80C-\\uA822\\uA840-\\uA873\\uA882-\\uA8B3\\uA8F2-\\uA8F7\\uA8FB\\uA8FD\\uA8FE\\uA90A-\\uA925\\uA930-\\uA946\\uA960-\\uA97C\\uA984-\\uA9B2\\uA9CF\\uA9E0-\\uA9E4\\uA9E6-\\uA9EF\\uA9FA-\\uA9FE\\uAA00-\\uAA28\\uAA40-\\uAA42\\uAA44-\\uAA4B\\uAA60-\\uAA76\\uAA7A\\uAA7E-\\uAAAF\\uAAB1\\uAAB5\\uAAB6\\uAAB9-\\uAABD\\uAAC0\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEA\\uAAF2-\\uAAF4\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB69\\uAB70-\\uABE2\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF21-\\uFF3A\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]|\\uD800[\\uDC00-\\uDC0B\\uDC0D-\\uDC26\\uDC28-\\uDC3A\\uDC3C\\uDC3D\\uDC3F-\\uDC4D\\uDC50-\\uDC5D\\uDC80-\\uDCFA\\uDD40-\\uDD74\\uDE80-\\uDE9C\\uDEA0-\\uDED0\\uDF00-\\uDF1F\\uDF2D-\\uDF4A\\uDF50-\\uDF75\\uDF80-\\uDF9D\\uDFA0-\\uDFC3\\uDFC8-\\uDFCF\\uDFD1-\\uDFD5]|\\uD801[\\uDC00-\\uDC9D\\uDCB0-\\uDCD3\\uDCD8-\\uDCFB\\uDD00-\\uDD27\\uDD30-\\uDD63\\uDE00-\\uDF36\\uDF40-\\uDF55\\uDF60-\\uDF67]|\\uD802[\\uDC00-\\uDC05\\uDC08\\uDC0A-\\uDC35\\uDC37\\uDC38\\uDC3C\\uDC3F-\\uDC55\\uDC60-\\uDC76\\uDC80-\\uDC9E\\uDCE0-\\uDCF2\\uDCF4\\uDCF5\\uDD00-\\uDD15\\uDD20-\\uDD39\\uDD80-\\uDDB7\\uDDBE\\uDDBF\\uDE00\\uDE10-\\uDE13\\uDE15-\\uDE17\\uDE19-\\uDE35\\uDE60-\\uDE7C\\uDE80-\\uDE9C\\uDEC0-\\uDEC7\\uDEC9-\\uDEE4\\uDF00-\\uDF35\\uDF40-\\uDF55\\uDF60-\\uDF72\\uDF80-\\uDF91]|\\uD803[\\uDC00-\\uDC48\\uDC80-\\uDCB2\\uDCC0-\\uDCF2\\uDD00-\\uDD23\\uDE80-\\uDEA9\\uDEB0\\uDEB1\\uDF00-\\uDF1C\\uDF27\\uDF30-\\uDF45\\uDFB0-\\uDFC4\\uDFE0-\\uDFF6]|\\uD804[\\uDC03-\\uDC37\\uDC83-\\uDCAF\\uDCD0-\\uDCE8\\uDD03-\\uDD26\\uDD44\\uDD47\\uDD50-\\uDD72\\uDD76\\uDD83-\\uDDB2\\uDDC1-\\uDDC4\\uDDDA\\uDDDC\\uDE00-\\uDE11\\uDE13-\\uDE2B\\uDE80-\\uDE86\\uDE88\\uDE8A-\\uDE8D\\uDE8F-\\uDE9D\\uDE9F-\\uDEA8\\uDEB0-\\uDEDE\\uDF05-\\uDF0C\\uDF0F\\uDF10\\uDF13-\\uDF28\\uDF2A-\\uDF30\\uDF32\\uDF33\\uDF35-\\uDF39\\uDF3D\\uDF50\\uDF5D-\\uDF61]|\\uD805[\\uDC00-\\uDC34\\uDC47-\\uDC4A\\uDC5F-\\uDC61\\uDC80-\\uDCAF\\uDCC4\\uDCC5\\uDCC7\\uDD80-\\uDDAE\\uDDD8-\\uDDDB\\uDE00-\\uDE2F\\uDE44\\uDE80-\\uDEAA\\uDEB8\\uDF00-\\uDF1A]|\\uD806[\\uDC00-\\uDC2B\\uDCA0-\\uDCDF\\uDCFF-\\uDD06\\uDD09\\uDD0C-\\uDD13\\uDD15\\uDD16\\uDD18-\\uDD2F\\uDD3F\\uDD41\\uDDA0-\\uDDA7\\uDDAA-\\uDDD0\\uDDE1\\uDDE3\\uDE00\\uDE0B-\\uDE32\\uDE3A\\uDE50\\uDE5C-\\uDE89\\uDE9D\\uDEC0-\\uDEF8]|\\uD807[\\uDC00-\\uDC08\\uDC0A-\\uDC2E\\uDC40\\uDC72-\\uDC8F\\uDD00-\\uDD06\\uDD08\\uDD09\\uDD0B-\\uDD30\\uDD46\\uDD60-\\uDD65\\uDD67\\uDD68\\uDD6A-\\uDD89\\uDD98\\uDEE0-\\uDEF2\\uDFB0]|\\uD808[\\uDC00-\\uDF99]|\\uD809[\\uDC00-\\uDC6E\\uDC80-\\uDD43]|[\\uD80C\\uD81C-\\uD820\\uD822\\uD840-\\uD868\\uD86A-\\uD86C\\uD86F-\\uD872\\uD874-\\uD879\\uD880-\\uD883][\\uDC00-\\uDFFF]|\\uD80D[\\uDC00-\\uDC2E]|\\uD811[\\uDC00-\\uDE46]|\\uD81A[\\uDC00-\\uDE38\\uDE40-\\uDE5E\\uDED0-\\uDEED\\uDF00-\\uDF2F\\uDF40-\\uDF43\\uDF63-\\uDF77\\uDF7D-\\uDF8F]|\\uD81B[\\uDE40-\\uDE7F\\uDF00-\\uDF4A\\uDF50\\uDF93-\\uDF9F\\uDFE0\\uDFE1\\uDFE3]|\\uD821[\\uDC00-\\uDFF7]|\\uD823[\\uDC00-\\uDCD5\\uDD00-\\uDD08]|\\uD82C[\\uDC00-\\uDD1E\\uDD50-\\uDD52\\uDD64-\\uDD67\\uDD70-\\uDEFB]|\\uD82F[\\uDC00-\\uDC6A\\uDC70-\\uDC7C\\uDC80-\\uDC88\\uDC90-\\uDC99]|\\uD835[\\uDC00-\\uDC54\\uDC56-\\uDC9C\\uDC9E\\uDC9F\\uDCA2\\uDCA5\\uDCA6\\uDCA9-\\uDCAC\\uDCAE-\\uDCB9\\uDCBB\\uDCBD-\\uDCC3\\uDCC5-\\uDD05\\uDD07-\\uDD0A\\uDD0D-\\uDD14\\uDD16-\\uDD1C\\uDD1E-\\uDD39\\uDD3B-\\uDD3E\\uDD40-\\uDD44\\uDD46\\uDD4A-\\uDD50\\uDD52-\\uDEA5\\uDEA8-\\uDEC0\\uDEC2-\\uDEDA\\uDEDC-\\uDEFA\\uDEFC-\\uDF14\\uDF16-\\uDF34\\uDF36-\\uDF4E\\uDF50-\\uDF6E\\uDF70-\\uDF88\\uDF8A-\\uDFA8\\uDFAA-\\uDFC2\\uDFC4-\\uDFCB]|\\uD838[\\uDD00-\\uDD2C\\uDD37-\\uDD3D\\uDD4E\\uDEC0-\\uDEEB]|\\uD83A[\\uDC00-\\uDCC4\\uDD00-\\uDD43\\uDD4B]|\\uD83B[\\uDE00-\\uDE03\\uDE05-\\uDE1F\\uDE21\\uDE22\\uDE24\\uDE27\\uDE29-\\uDE32\\uDE34-\\uDE37\\uDE39\\uDE3B\\uDE42\\uDE47\\uDE49\\uDE4B\\uDE4D-\\uDE4F\\uDE51\\uDE52\\uDE54\\uDE57\\uDE59\\uDE5B\\uDE5D\\uDE5F\\uDE61\\uDE62\\uDE64\\uDE67-\\uDE6A\\uDE6C-\\uDE72\\uDE74-\\uDE77\\uDE79-\\uDE7C\\uDE7E\\uDE80-\\uDE89\\uDE8B-\\uDE9B\\uDEA1-\\uDEA3\\uDEA5-\\uDEA9\\uDEAB-\\uDEBB]|\\uD869[\\uDC00-\\uDEDD\\uDF00-\\uDFFF]|\\uD86D[\\uDC00-\\uDF34\\uDF40-\\uDFFF]|\\uD86E[\\uDC00-\\uDC1D\\uDC20-\\uDFFF]|\\uD873[\\uDC00-\\uDEA1\\uDEB0-\\uDFFF]|\\uD87A[\\uDC00-\\uDFE0]|\\uD87E[\\uDC00-\\uDE1D]|\\uD884[\\uDC00-\\uDF4A]))(?:(?:[\\$0-9A-Z_a-z\\xAA\\xB5\\xB7\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0300-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u0483-\\u0487\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0560-\\u0588\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u05D0-\\u05EA\\u05EF-\\u05F2\\u0610-\\u061A\\u0620-\\u0669\\u066E-\\u06D3\\u06D5-\\u06DC\\u06DF-\\u06E8\\u06EA-\\u06FC\\u06FF\\u0710-\\u074A\\u074D-\\u07B1\\u07C0-\\u07F5\\u07FA\\u07FD\\u0800-\\u082D\\u0840-\\u085B\\u0860-\\u086A\\u08A0-\\u08B4\\u08B6-\\u08C7\\u08D3-\\u08E1\\u08E3-\\u0963\\u0966-\\u096F\\u0971-\\u0983\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BC-\\u09C4\\u09C7\\u09C8\\u09CB-\\u09CE\\u09D7\\u09DC\\u09DD\\u09DF-\\u09E3\\u09E6-\\u09F1\\u09FC\\u09FE\\u0A01-\\u0A03\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A3C\\u0A3E-\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A59-\\u0A5C\\u0A5E\\u0A66-\\u0A75\\u0A81-\\u0A83\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABC-\\u0AC5\\u0AC7-\\u0AC9\\u0ACB-\\u0ACD\\u0AD0\\u0AE0-\\u0AE3\\u0AE6-\\u0AEF\\u0AF9-\\u0AFF\\u0B01-\\u0B03\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3C-\\u0B44\\u0B47\\u0B48\\u0B4B-\\u0B4D\\u0B55-\\u0B57\\u0B5C\\u0B5D\\u0B5F-\\u0B63\\u0B66-\\u0B6F\\u0B71\\u0B82\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BBE-\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCD\\u0BD0\\u0BD7\\u0BE6-\\u0BEF\\u0C00-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D-\\u0C44\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C58-\\u0C5A\\u0C60-\\u0C63\\u0C66-\\u0C6F\\u0C80-\\u0C83\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBC-\\u0CC4\\u0CC6-\\u0CC8\\u0CCA-\\u0CCD\\u0CD5\\u0CD6\\u0CDE\\u0CE0-\\u0CE3\\u0CE6-\\u0CEF\\u0CF1\\u0CF2\\u0D00-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D44\\u0D46-\\u0D48\\u0D4A-\\u0D4E\\u0D54-\\u0D57\\u0D5F-\\u0D63\\u0D66-\\u0D6F\\u0D7A-\\u0D7F\\u0D81-\\u0D83\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0DCA\\u0DCF-\\u0DD4\\u0DD6\\u0DD8-\\u0DDF\\u0DE6-\\u0DEF\\u0DF2\\u0DF3\\u0E01-\\u0E3A\\u0E40-\\u0E4E\\u0E50-\\u0E59\\u0E81\\u0E82\\u0E84\\u0E86-\\u0E8A\\u0E8C-\\u0EA3\\u0EA5\\u0EA7-\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EC8-\\u0ECD\\u0ED0-\\u0ED9\\u0EDC-\\u0EDF\\u0F00\\u0F18\\u0F19\\u0F20-\\u0F29\\u0F35\\u0F37\\u0F39\\u0F3E-\\u0F47\\u0F49-\\u0F6C\\u0F71-\\u0F84\\u0F86-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u1000-\\u1049\\u1050-\\u109D\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u135D-\\u135F\\u1369-\\u1371\\u1380-\\u138F\\u13A0-\\u13F5\\u13F8-\\u13FD\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1714\\u1720-\\u1734\\u1740-\\u1753\\u1760-\\u176C\\u176E-\\u1770\\u1772\\u1773\\u1780-\\u17D3\\u17D7\\u17DC\\u17DD\\u17E0-\\u17E9\\u180B-\\u180D\\u1810-\\u1819\\u1820-\\u1878\\u1880-\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1920-\\u192B\\u1930-\\u193B\\u1946-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19B0-\\u19C9\\u19D0-\\u19DA\\u1A00-\\u1A1B\\u1A20-\\u1A5E\\u1A60-\\u1A7C\\u1A7F-\\u1A89\\u1A90-\\u1A99\\u1AA7\\u1AB0-\\u1ABD\\u1ABF\\u1AC0\\u1B00-\\u1B4B\\u1B50-\\u1B59\\u1B6B-\\u1B73\\u1B80-\\u1BF3\\u1C00-\\u1C37\\u1C40-\\u1C49\\u1C4D-\\u1C7D\\u1C80-\\u1C88\\u1C90-\\u1CBA\\u1CBD-\\u1CBF\\u1CD0-\\u1CD2\\u1CD4-\\u1CFA\\u1D00-\\u1DF9\\u1DFB-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u200C\\u200D\\u203F\\u2040\\u2054\\u2071\\u207F\\u2090-\\u209C\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2118-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D7F-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2DE0-\\u2DFF\\u3005-\\u3007\\u3021-\\u302F\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u3099-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312F\\u3131-\\u318E\\u31A0-\\u31BF\\u31F0-\\u31FF\\u3400-\\u4DBF\\u4E00-\\u9FFC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA62B\\uA640-\\uA66F\\uA674-\\uA67D\\uA67F-\\uA6F1\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA7BF\\uA7C2-\\uA7CA\\uA7F5-\\uA827\\uA82C\\uA840-\\uA873\\uA880-\\uA8C5\\uA8D0-\\uA8D9\\uA8E0-\\uA8F7\\uA8FB\\uA8FD-\\uA92D\\uA930-\\uA953\\uA960-\\uA97C\\uA980-\\uA9C0\\uA9CF-\\uA9D9\\uA9E0-\\uA9FE\\uAA00-\\uAA36\\uAA40-\\uAA4D\\uAA50-\\uAA59\\uAA60-\\uAA76\\uAA7A-\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEF\\uAAF2-\\uAAF6\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB69\\uAB70-\\uABEA\\uABEC\\uABED\\uABF0-\\uABF9\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE00-\\uFE0F\\uFE20-\\uFE2F\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF10-\\uFF19\\uFF21-\\uFF3A\\uFF3F\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]|\\uD800[\\uDC00-\\uDC0B\\uDC0D-\\uDC26\\uDC28-\\uDC3A\\uDC3C\\uDC3D\\uDC3F-\\uDC4D\\uDC50-\\uDC5D\\uDC80-\\uDCFA\\uDD40-\\uDD74\\uDDFD\\uDE80-\\uDE9C\\uDEA0-\\uDED0\\uDEE0\\uDF00-\\uDF1F\\uDF2D-\\uDF4A\\uDF50-\\uDF7A\\uDF80-\\uDF9D\\uDFA0-\\uDFC3\\uDFC8-\\uDFCF\\uDFD1-\\uDFD5]|\\uD801[\\uDC00-\\uDC9D\\uDCA0-\\uDCA9\\uDCB0-\\uDCD3\\uDCD8-\\uDCFB\\uDD00-\\uDD27\\uDD30-\\uDD63\\uDE00-\\uDF36\\uDF40-\\uDF55\\uDF60-\\uDF67]|\\uD802[\\uDC00-\\uDC05\\uDC08\\uDC0A-\\uDC35\\uDC37\\uDC38\\uDC3C\\uDC3F-\\uDC55\\uDC60-\\uDC76\\uDC80-\\uDC9E\\uDCE0-\\uDCF2\\uDCF4\\uDCF5\\uDD00-\\uDD15\\uDD20-\\uDD39\\uDD80-\\uDDB7\\uDDBE\\uDDBF\\uDE00-\\uDE03\\uDE05\\uDE06\\uDE0C-\\uDE13\\uDE15-\\uDE17\\uDE19-\\uDE35\\uDE38-\\uDE3A\\uDE3F\\uDE60-\\uDE7C\\uDE80-\\uDE9C\\uDEC0-\\uDEC7\\uDEC9-\\uDEE6\\uDF00-\\uDF35\\uDF40-\\uDF55\\uDF60-\\uDF72\\uDF80-\\uDF91]|\\uD803[\\uDC00-\\uDC48\\uDC80-\\uDCB2\\uDCC0-\\uDCF2\\uDD00-\\uDD27\\uDD30-\\uDD39\\uDE80-\\uDEA9\\uDEAB\\uDEAC\\uDEB0\\uDEB1\\uDF00-\\uDF1C\\uDF27\\uDF30-\\uDF50\\uDFB0-\\uDFC4\\uDFE0-\\uDFF6]|\\uD804[\\uDC00-\\uDC46\\uDC66-\\uDC6F\\uDC7F-\\uDCBA\\uDCD0-\\uDCE8\\uDCF0-\\uDCF9\\uDD00-\\uDD34\\uDD36-\\uDD3F\\uDD44-\\uDD47\\uDD50-\\uDD73\\uDD76\\uDD80-\\uDDC4\\uDDC9-\\uDDCC\\uDDCE-\\uDDDA\\uDDDC\\uDE00-\\uDE11\\uDE13-\\uDE37\\uDE3E\\uDE80-\\uDE86\\uDE88\\uDE8A-\\uDE8D\\uDE8F-\\uDE9D\\uDE9F-\\uDEA8\\uDEB0-\\uDEEA\\uDEF0-\\uDEF9\\uDF00-\\uDF03\\uDF05-\\uDF0C\\uDF0F\\uDF10\\uDF13-\\uDF28\\uDF2A-\\uDF30\\uDF32\\uDF33\\uDF35-\\uDF39\\uDF3B-\\uDF44\\uDF47\\uDF48\\uDF4B-\\uDF4D\\uDF50\\uDF57\\uDF5D-\\uDF63\\uDF66-\\uDF6C\\uDF70-\\uDF74]|\\uD805[\\uDC00-\\uDC4A\\uDC50-\\uDC59\\uDC5E-\\uDC61\\uDC80-\\uDCC5\\uDCC7\\uDCD0-\\uDCD9\\uDD80-\\uDDB5\\uDDB8-\\uDDC0\\uDDD8-\\uDDDD\\uDE00-\\uDE40\\uDE44\\uDE50-\\uDE59\\uDE80-\\uDEB8\\uDEC0-\\uDEC9\\uDF00-\\uDF1A\\uDF1D-\\uDF2B\\uDF30-\\uDF39]|\\uD806[\\uDC00-\\uDC3A\\uDCA0-\\uDCE9\\uDCFF-\\uDD06\\uDD09\\uDD0C-\\uDD13\\uDD15\\uDD16\\uDD18-\\uDD35\\uDD37\\uDD38\\uDD3B-\\uDD43\\uDD50-\\uDD59\\uDDA0-\\uDDA7\\uDDAA-\\uDDD7\\uDDDA-\\uDDE1\\uDDE3\\uDDE4\\uDE00-\\uDE3E\\uDE47\\uDE50-\\uDE99\\uDE9D\\uDEC0-\\uDEF8]|\\uD807[\\uDC00-\\uDC08\\uDC0A-\\uDC36\\uDC38-\\uDC40\\uDC50-\\uDC59\\uDC72-\\uDC8F\\uDC92-\\uDCA7\\uDCA9-\\uDCB6\\uDD00-\\uDD06\\uDD08\\uDD09\\uDD0B-\\uDD36\\uDD3A\\uDD3C\\uDD3D\\uDD3F-\\uDD47\\uDD50-\\uDD59\\uDD60-\\uDD65\\uDD67\\uDD68\\uDD6A-\\uDD8E\\uDD90\\uDD91\\uDD93-\\uDD98\\uDDA0-\\uDDA9\\uDEE0-\\uDEF6\\uDFB0]|\\uD808[\\uDC00-\\uDF99]|\\uD809[\\uDC00-\\uDC6E\\uDC80-\\uDD43]|[\\uD80C\\uD81C-\\uD820\\uD822\\uD840-\\uD868\\uD86A-\\uD86C\\uD86F-\\uD872\\uD874-\\uD879\\uD880-\\uD883][\\uDC00-\\uDFFF]|\\uD80D[\\uDC00-\\uDC2E]|\\uD811[\\uDC00-\\uDE46]|\\uD81A[\\uDC00-\\uDE38\\uDE40-\\uDE5E\\uDE60-\\uDE69\\uDED0-\\uDEED\\uDEF0-\\uDEF4\\uDF00-\\uDF36\\uDF40-\\uDF43\\uDF50-\\uDF59\\uDF63-\\uDF77\\uDF7D-\\uDF8F]|\\uD81B[\\uDE40-\\uDE7F\\uDF00-\\uDF4A\\uDF4F-\\uDF87\\uDF8F-\\uDF9F\\uDFE0\\uDFE1\\uDFE3\\uDFE4\\uDFF0\\uDFF1]|\\uD821[\\uDC00-\\uDFF7]|\\uD823[\\uDC00-\\uDCD5\\uDD00-\\uDD08]|\\uD82C[\\uDC00-\\uDD1E\\uDD50-\\uDD52\\uDD64-\\uDD67\\uDD70-\\uDEFB]|\\uD82F[\\uDC00-\\uDC6A\\uDC70-\\uDC7C\\uDC80-\\uDC88\\uDC90-\\uDC99\\uDC9D\\uDC9E]|\\uD834[\\uDD65-\\uDD69\\uDD6D-\\uDD72\\uDD7B-\\uDD82\\uDD85-\\uDD8B\\uDDAA-\\uDDAD\\uDE42-\\uDE44]|\\uD835[\\uDC00-\\uDC54\\uDC56-\\uDC9C\\uDC9E\\uDC9F\\uDCA2\\uDCA5\\uDCA6\\uDCA9-\\uDCAC\\uDCAE-\\uDCB9\\uDCBB\\uDCBD-\\uDCC3\\uDCC5-\\uDD05\\uDD07-\\uDD0A\\uDD0D-\\uDD14\\uDD16-\\uDD1C\\uDD1E-\\uDD39\\uDD3B-\\uDD3E\\uDD40-\\uDD44\\uDD46\\uDD4A-\\uDD50\\uDD52-\\uDEA5\\uDEA8-\\uDEC0\\uDEC2-\\uDEDA\\uDEDC-\\uDEFA\\uDEFC-\\uDF14\\uDF16-\\uDF34\\uDF36-\\uDF4E\\uDF50-\\uDF6E\\uDF70-\\uDF88\\uDF8A-\\uDFA8\\uDFAA-\\uDFC2\\uDFC4-\\uDFCB\\uDFCE-\\uDFFF]|\\uD836[\\uDE00-\\uDE36\\uDE3B-\\uDE6C\\uDE75\\uDE84\\uDE9B-\\uDE9F\\uDEA1-\\uDEAF]|\\uD838[\\uDC00-\\uDC06\\uDC08-\\uDC18\\uDC1B-\\uDC21\\uDC23\\uDC24\\uDC26-\\uDC2A\\uDD00-\\uDD2C\\uDD30-\\uDD3D\\uDD40-\\uDD49\\uDD4E\\uDEC0-\\uDEF9]|\\uD83A[\\uDC00-\\uDCC4\\uDCD0-\\uDCD6\\uDD00-\\uDD4B\\uDD50-\\uDD59]|\\uD83B[\\uDE00-\\uDE03\\uDE05-\\uDE1F\\uDE21\\uDE22\\uDE24\\uDE27\\uDE29-\\uDE32\\uDE34-\\uDE37\\uDE39\\uDE3B\\uDE42\\uDE47\\uDE49\\uDE4B\\uDE4D-\\uDE4F\\uDE51\\uDE52\\uDE54\\uDE57\\uDE59\\uDE5B\\uDE5D\\uDE5F\\uDE61\\uDE62\\uDE64\\uDE67-\\uDE6A\\uDE6C-\\uDE72\\uDE74-\\uDE77\\uDE79-\\uDE7C\\uDE7E\\uDE80-\\uDE89\\uDE8B-\\uDE9B\\uDEA1-\\uDEA3\\uDEA5-\\uDEA9\\uDEAB-\\uDEBB]|\\uD83E[\\uDFF0-\\uDFF9]|\\uD869[\\uDC00-\\uDEDD\\uDF00-\\uDFFF]|\\uD86D[\\uDC00-\\uDF34\\uDF40-\\uDFFF]|\\uD86E[\\uDC00-\\uDC1D\\uDC20-\\uDFFF]|\\uD873[\\uDC00-\\uDEA1\\uDEB0-\\uDFFF]|\\uD87A[\\uDC00-\\uDFE0]|\\uD87E[\\uDC00-\\uDE1D]|\\uD884[\\uDC00-\\uDF4A]|\\uDB40[\\uDD00-\\uDDEF])|\\\\u[0-9A-Fa-f]{4}|\\\\u\\{[0-9A-Fa-f]+\\})+", "y");
  StringLiteral = new RegExp("(['\"])(?:(?!\\1)[^\\\\\\n\\r]|\\\\(?:\\r\\n|[^]))*(\\1)?", "y");
  NumericLiteral = new RegExp("(?:0[xX][\\da-fA-F](?:_?[\\da-fA-F])*|0[oO][0-7](?:_?[0-7])*|0[bB][01](?:_?[01])*)n?|0n|[1-9](?:_?\\d)*n|(?:(?:0(?!\\d)|0\\d*[89]\\d*|[1-9](?:_?\\d)*)(?:\\.(?:\\d(?:_?\\d)*)?)?|\\.\\d(?:_?\\d)*)(?:[eE][+-]?\\d(?:_?\\d)*)?|0[0-7]+", "y");
  Template = new RegExp("[`}](?:[^`\\\\$]|\\\\[^]|\\$(?!\\{))*(`|\\$\\{)?", "y");
  WhiteSpace = new RegExp("[\\t\\x0B\\f \\xA0\\u1680\\u2000-\\u200A\\u202F\\u205F\\u3000\\uFEFF]+", "y");
  LineTerminatorSequence = new RegExp("\\r?\\n|[\\r\\u2028\\u2029]", "y");
  MultiLineComment = new RegExp("\\/\\*(?:[^*]|\\*(?!\\/))*(\\*\\/)?", "y");
  SingleLineComment = new RegExp("\\/\\/.*", "y");
  JSXPunctuator = new RegExp("[<>.:={}]|\\/(?![\\/*])", "y");
  JSXIdentifier = new RegExp("(?:[\\$A-Z_a-z\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0370-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0560-\\u0588\\u05D0-\\u05EA\\u05EF-\\u05F2\\u0620-\\u064A\\u066E\\u066F\\u0671-\\u06D3\\u06D5\\u06E5\\u06E6\\u06EE\\u06EF\\u06FA-\\u06FC\\u06FF\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1\\u07CA-\\u07EA\\u07F4\\u07F5\\u07FA\\u0800-\\u0815\\u081A\\u0824\\u0828\\u0840-\\u0858\\u0860-\\u086A\\u08A0-\\u08B4\\u08B6-\\u08C7\\u0904-\\u0939\\u093D\\u0950\\u0958-\\u0961\\u0971-\\u0980\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BD\\u09CE\\u09DC\\u09DD\\u09DF-\\u09E1\\u09F0\\u09F1\\u09FC\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A59-\\u0A5C\\u0A5E\\u0A72-\\u0A74\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABD\\u0AD0\\u0AE0\\u0AE1\\u0AF9\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3D\\u0B5C\\u0B5D\\u0B5F-\\u0B61\\u0B71\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BD0\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D\\u0C58-\\u0C5A\\u0C60\\u0C61\\u0C80\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBD\\u0CDE\\u0CE0\\u0CE1\\u0CF1\\u0CF2\\u0D04-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D\\u0D4E\\u0D54-\\u0D56\\u0D5F-\\u0D61\\u0D7A-\\u0D7F\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0E01-\\u0E30\\u0E32\\u0E33\\u0E40-\\u0E46\\u0E81\\u0E82\\u0E84\\u0E86-\\u0E8A\\u0E8C-\\u0EA3\\u0EA5\\u0EA7-\\u0EB0\\u0EB2\\u0EB3\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EDC-\\u0EDF\\u0F00\\u0F40-\\u0F47\\u0F49-\\u0F6C\\u0F88-\\u0F8C\\u1000-\\u102A\\u103F\\u1050-\\u1055\\u105A-\\u105D\\u1061\\u1065\\u1066\\u106E-\\u1070\\u1075-\\u1081\\u108E\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u1380-\\u138F\\u13A0-\\u13F5\\u13F8-\\u13FD\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176C\\u176E-\\u1770\\u1780-\\u17B3\\u17D7\\u17DC\\u1820-\\u1878\\u1880-\\u18A8\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1950-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19B0-\\u19C9\\u1A00-\\u1A16\\u1A20-\\u1A54\\u1AA7\\u1B05-\\u1B33\\u1B45-\\u1B4B\\u1B83-\\u1BA0\\u1BAE\\u1BAF\\u1BBA-\\u1BE5\\u1C00-\\u1C23\\u1C4D-\\u1C4F\\u1C5A-\\u1C7D\\u1C80-\\u1C88\\u1C90-\\u1CBA\\u1CBD-\\u1CBF\\u1CE9-\\u1CEC\\u1CEE-\\u1CF3\\u1CF5\\u1CF6\\u1CFA\\u1D00-\\u1DBF\\u1E00-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u2071\\u207F\\u2090-\\u209C\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2118-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CEE\\u2CF2\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u309B-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312F\\u3131-\\u318E\\u31A0-\\u31BF\\u31F0-\\u31FF\\u3400-\\u4DBF\\u4E00-\\u9FFC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA61F\\uA62A\\uA62B\\uA640-\\uA66E\\uA67F-\\uA69D\\uA6A0-\\uA6EF\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA7BF\\uA7C2-\\uA7CA\\uA7F5-\\uA801\\uA803-\\uA805\\uA807-\\uA80A\\uA80C-\\uA822\\uA840-\\uA873\\uA882-\\uA8B3\\uA8F2-\\uA8F7\\uA8FB\\uA8FD\\uA8FE\\uA90A-\\uA925\\uA930-\\uA946\\uA960-\\uA97C\\uA984-\\uA9B2\\uA9CF\\uA9E0-\\uA9E4\\uA9E6-\\uA9EF\\uA9FA-\\uA9FE\\uAA00-\\uAA28\\uAA40-\\uAA42\\uAA44-\\uAA4B\\uAA60-\\uAA76\\uAA7A\\uAA7E-\\uAAAF\\uAAB1\\uAAB5\\uAAB6\\uAAB9-\\uAABD\\uAAC0\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEA\\uAAF2-\\uAAF4\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB69\\uAB70-\\uABE2\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF21-\\uFF3A\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]|\\uD800[\\uDC00-\\uDC0B\\uDC0D-\\uDC26\\uDC28-\\uDC3A\\uDC3C\\uDC3D\\uDC3F-\\uDC4D\\uDC50-\\uDC5D\\uDC80-\\uDCFA\\uDD40-\\uDD74\\uDE80-\\uDE9C\\uDEA0-\\uDED0\\uDF00-\\uDF1F\\uDF2D-\\uDF4A\\uDF50-\\uDF75\\uDF80-\\uDF9D\\uDFA0-\\uDFC3\\uDFC8-\\uDFCF\\uDFD1-\\uDFD5]|\\uD801[\\uDC00-\\uDC9D\\uDCB0-\\uDCD3\\uDCD8-\\uDCFB\\uDD00-\\uDD27\\uDD30-\\uDD63\\uDE00-\\uDF36\\uDF40-\\uDF55\\uDF60-\\uDF67]|\\uD802[\\uDC00-\\uDC05\\uDC08\\uDC0A-\\uDC35\\uDC37\\uDC38\\uDC3C\\uDC3F-\\uDC55\\uDC60-\\uDC76\\uDC80-\\uDC9E\\uDCE0-\\uDCF2\\uDCF4\\uDCF5\\uDD00-\\uDD15\\uDD20-\\uDD39\\uDD80-\\uDDB7\\uDDBE\\uDDBF\\uDE00\\uDE10-\\uDE13\\uDE15-\\uDE17\\uDE19-\\uDE35\\uDE60-\\uDE7C\\uDE80-\\uDE9C\\uDEC0-\\uDEC7\\uDEC9-\\uDEE4\\uDF00-\\uDF35\\uDF40-\\uDF55\\uDF60-\\uDF72\\uDF80-\\uDF91]|\\uD803[\\uDC00-\\uDC48\\uDC80-\\uDCB2\\uDCC0-\\uDCF2\\uDD00-\\uDD23\\uDE80-\\uDEA9\\uDEB0\\uDEB1\\uDF00-\\uDF1C\\uDF27\\uDF30-\\uDF45\\uDFB0-\\uDFC4\\uDFE0-\\uDFF6]|\\uD804[\\uDC03-\\uDC37\\uDC83-\\uDCAF\\uDCD0-\\uDCE8\\uDD03-\\uDD26\\uDD44\\uDD47\\uDD50-\\uDD72\\uDD76\\uDD83-\\uDDB2\\uDDC1-\\uDDC4\\uDDDA\\uDDDC\\uDE00-\\uDE11\\uDE13-\\uDE2B\\uDE80-\\uDE86\\uDE88\\uDE8A-\\uDE8D\\uDE8F-\\uDE9D\\uDE9F-\\uDEA8\\uDEB0-\\uDEDE\\uDF05-\\uDF0C\\uDF0F\\uDF10\\uDF13-\\uDF28\\uDF2A-\\uDF30\\uDF32\\uDF33\\uDF35-\\uDF39\\uDF3D\\uDF50\\uDF5D-\\uDF61]|\\uD805[\\uDC00-\\uDC34\\uDC47-\\uDC4A\\uDC5F-\\uDC61\\uDC80-\\uDCAF\\uDCC4\\uDCC5\\uDCC7\\uDD80-\\uDDAE\\uDDD8-\\uDDDB\\uDE00-\\uDE2F\\uDE44\\uDE80-\\uDEAA\\uDEB8\\uDF00-\\uDF1A]|\\uD806[\\uDC00-\\uDC2B\\uDCA0-\\uDCDF\\uDCFF-\\uDD06\\uDD09\\uDD0C-\\uDD13\\uDD15\\uDD16\\uDD18-\\uDD2F\\uDD3F\\uDD41\\uDDA0-\\uDDA7\\uDDAA-\\uDDD0\\uDDE1\\uDDE3\\uDE00\\uDE0B-\\uDE32\\uDE3A\\uDE50\\uDE5C-\\uDE89\\uDE9D\\uDEC0-\\uDEF8]|\\uD807[\\uDC00-\\uDC08\\uDC0A-\\uDC2E\\uDC40\\uDC72-\\uDC8F\\uDD00-\\uDD06\\uDD08\\uDD09\\uDD0B-\\uDD30\\uDD46\\uDD60-\\uDD65\\uDD67\\uDD68\\uDD6A-\\uDD89\\uDD98\\uDEE0-\\uDEF2\\uDFB0]|\\uD808[\\uDC00-\\uDF99]|\\uD809[\\uDC00-\\uDC6E\\uDC80-\\uDD43]|[\\uD80C\\uD81C-\\uD820\\uD822\\uD840-\\uD868\\uD86A-\\uD86C\\uD86F-\\uD872\\uD874-\\uD879\\uD880-\\uD883][\\uDC00-\\uDFFF]|\\uD80D[\\uDC00-\\uDC2E]|\\uD811[\\uDC00-\\uDE46]|\\uD81A[\\uDC00-\\uDE38\\uDE40-\\uDE5E\\uDED0-\\uDEED\\uDF00-\\uDF2F\\uDF40-\\uDF43\\uDF63-\\uDF77\\uDF7D-\\uDF8F]|\\uD81B[\\uDE40-\\uDE7F\\uDF00-\\uDF4A\\uDF50\\uDF93-\\uDF9F\\uDFE0\\uDFE1\\uDFE3]|\\uD821[\\uDC00-\\uDFF7]|\\uD823[\\uDC00-\\uDCD5\\uDD00-\\uDD08]|\\uD82C[\\uDC00-\\uDD1E\\uDD50-\\uDD52\\uDD64-\\uDD67\\uDD70-\\uDEFB]|\\uD82F[\\uDC00-\\uDC6A\\uDC70-\\uDC7C\\uDC80-\\uDC88\\uDC90-\\uDC99]|\\uD835[\\uDC00-\\uDC54\\uDC56-\\uDC9C\\uDC9E\\uDC9F\\uDCA2\\uDCA5\\uDCA6\\uDCA9-\\uDCAC\\uDCAE-\\uDCB9\\uDCBB\\uDCBD-\\uDCC3\\uDCC5-\\uDD05\\uDD07-\\uDD0A\\uDD0D-\\uDD14\\uDD16-\\uDD1C\\uDD1E-\\uDD39\\uDD3B-\\uDD3E\\uDD40-\\uDD44\\uDD46\\uDD4A-\\uDD50\\uDD52-\\uDEA5\\uDEA8-\\uDEC0\\uDEC2-\\uDEDA\\uDEDC-\\uDEFA\\uDEFC-\\uDF14\\uDF16-\\uDF34\\uDF36-\\uDF4E\\uDF50-\\uDF6E\\uDF70-\\uDF88\\uDF8A-\\uDFA8\\uDFAA-\\uDFC2\\uDFC4-\\uDFCB]|\\uD838[\\uDD00-\\uDD2C\\uDD37-\\uDD3D\\uDD4E\\uDEC0-\\uDEEB]|\\uD83A[\\uDC00-\\uDCC4\\uDD00-\\uDD43\\uDD4B]|\\uD83B[\\uDE00-\\uDE03\\uDE05-\\uDE1F\\uDE21\\uDE22\\uDE24\\uDE27\\uDE29-\\uDE32\\uDE34-\\uDE37\\uDE39\\uDE3B\\uDE42\\uDE47\\uDE49\\uDE4B\\uDE4D-\\uDE4F\\uDE51\\uDE52\\uDE54\\uDE57\\uDE59\\uDE5B\\uDE5D\\uDE5F\\uDE61\\uDE62\\uDE64\\uDE67-\\uDE6A\\uDE6C-\\uDE72\\uDE74-\\uDE77\\uDE79-\\uDE7C\\uDE7E\\uDE80-\\uDE89\\uDE8B-\\uDE9B\\uDEA1-\\uDEA3\\uDEA5-\\uDEA9\\uDEAB-\\uDEBB]|\\uD869[\\uDC00-\\uDEDD\\uDF00-\\uDFFF]|\\uD86D[\\uDC00-\\uDF34\\uDF40-\\uDFFF]|\\uD86E[\\uDC00-\\uDC1D\\uDC20-\\uDFFF]|\\uD873[\\uDC00-\\uDEA1\\uDEB0-\\uDFFF]|\\uD87A[\\uDC00-\\uDFE0]|\\uD87E[\\uDC00-\\uDE1D]|\\uD884[\\uDC00-\\uDF4A])(?:[\\$\\x2D0-9A-Z_a-z\\xAA\\xB5\\xB7\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0300-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u0483-\\u0487\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0560-\\u0588\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u05D0-\\u05EA\\u05EF-\\u05F2\\u0610-\\u061A\\u0620-\\u0669\\u066E-\\u06D3\\u06D5-\\u06DC\\u06DF-\\u06E8\\u06EA-\\u06FC\\u06FF\\u0710-\\u074A\\u074D-\\u07B1\\u07C0-\\u07F5\\u07FA\\u07FD\\u0800-\\u082D\\u0840-\\u085B\\u0860-\\u086A\\u08A0-\\u08B4\\u08B6-\\u08C7\\u08D3-\\u08E1\\u08E3-\\u0963\\u0966-\\u096F\\u0971-\\u0983\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BC-\\u09C4\\u09C7\\u09C8\\u09CB-\\u09CE\\u09D7\\u09DC\\u09DD\\u09DF-\\u09E3\\u09E6-\\u09F1\\u09FC\\u09FE\\u0A01-\\u0A03\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A3C\\u0A3E-\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A59-\\u0A5C\\u0A5E\\u0A66-\\u0A75\\u0A81-\\u0A83\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABC-\\u0AC5\\u0AC7-\\u0AC9\\u0ACB-\\u0ACD\\u0AD0\\u0AE0-\\u0AE3\\u0AE6-\\u0AEF\\u0AF9-\\u0AFF\\u0B01-\\u0B03\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3C-\\u0B44\\u0B47\\u0B48\\u0B4B-\\u0B4D\\u0B55-\\u0B57\\u0B5C\\u0B5D\\u0B5F-\\u0B63\\u0B66-\\u0B6F\\u0B71\\u0B82\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BBE-\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCD\\u0BD0\\u0BD7\\u0BE6-\\u0BEF\\u0C00-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D-\\u0C44\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C58-\\u0C5A\\u0C60-\\u0C63\\u0C66-\\u0C6F\\u0C80-\\u0C83\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBC-\\u0CC4\\u0CC6-\\u0CC8\\u0CCA-\\u0CCD\\u0CD5\\u0CD6\\u0CDE\\u0CE0-\\u0CE3\\u0CE6-\\u0CEF\\u0CF1\\u0CF2\\u0D00-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D44\\u0D46-\\u0D48\\u0D4A-\\u0D4E\\u0D54-\\u0D57\\u0D5F-\\u0D63\\u0D66-\\u0D6F\\u0D7A-\\u0D7F\\u0D81-\\u0D83\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0DCA\\u0DCF-\\u0DD4\\u0DD6\\u0DD8-\\u0DDF\\u0DE6-\\u0DEF\\u0DF2\\u0DF3\\u0E01-\\u0E3A\\u0E40-\\u0E4E\\u0E50-\\u0E59\\u0E81\\u0E82\\u0E84\\u0E86-\\u0E8A\\u0E8C-\\u0EA3\\u0EA5\\u0EA7-\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EC8-\\u0ECD\\u0ED0-\\u0ED9\\u0EDC-\\u0EDF\\u0F00\\u0F18\\u0F19\\u0F20-\\u0F29\\u0F35\\u0F37\\u0F39\\u0F3E-\\u0F47\\u0F49-\\u0F6C\\u0F71-\\u0F84\\u0F86-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u1000-\\u1049\\u1050-\\u109D\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u135D-\\u135F\\u1369-\\u1371\\u1380-\\u138F\\u13A0-\\u13F5\\u13F8-\\u13FD\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1714\\u1720-\\u1734\\u1740-\\u1753\\u1760-\\u176C\\u176E-\\u1770\\u1772\\u1773\\u1780-\\u17D3\\u17D7\\u17DC\\u17DD\\u17E0-\\u17E9\\u180B-\\u180D\\u1810-\\u1819\\u1820-\\u1878\\u1880-\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1920-\\u192B\\u1930-\\u193B\\u1946-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19B0-\\u19C9\\u19D0-\\u19DA\\u1A00-\\u1A1B\\u1A20-\\u1A5E\\u1A60-\\u1A7C\\u1A7F-\\u1A89\\u1A90-\\u1A99\\u1AA7\\u1AB0-\\u1ABD\\u1ABF\\u1AC0\\u1B00-\\u1B4B\\u1B50-\\u1B59\\u1B6B-\\u1B73\\u1B80-\\u1BF3\\u1C00-\\u1C37\\u1C40-\\u1C49\\u1C4D-\\u1C7D\\u1C80-\\u1C88\\u1C90-\\u1CBA\\u1CBD-\\u1CBF\\u1CD0-\\u1CD2\\u1CD4-\\u1CFA\\u1D00-\\u1DF9\\u1DFB-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u200C\\u200D\\u203F\\u2040\\u2054\\u2071\\u207F\\u2090-\\u209C\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2118-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D7F-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2DE0-\\u2DFF\\u3005-\\u3007\\u3021-\\u302F\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u3099-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312F\\u3131-\\u318E\\u31A0-\\u31BF\\u31F0-\\u31FF\\u3400-\\u4DBF\\u4E00-\\u9FFC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA62B\\uA640-\\uA66F\\uA674-\\uA67D\\uA67F-\\uA6F1\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA7BF\\uA7C2-\\uA7CA\\uA7F5-\\uA827\\uA82C\\uA840-\\uA873\\uA880-\\uA8C5\\uA8D0-\\uA8D9\\uA8E0-\\uA8F7\\uA8FB\\uA8FD-\\uA92D\\uA930-\\uA953\\uA960-\\uA97C\\uA980-\\uA9C0\\uA9CF-\\uA9D9\\uA9E0-\\uA9FE\\uAA00-\\uAA36\\uAA40-\\uAA4D\\uAA50-\\uAA59\\uAA60-\\uAA76\\uAA7A-\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEF\\uAAF2-\\uAAF6\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB69\\uAB70-\\uABEA\\uABEC\\uABED\\uABF0-\\uABF9\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE00-\\uFE0F\\uFE20-\\uFE2F\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF10-\\uFF19\\uFF21-\\uFF3A\\uFF3F\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]|\\uD800[\\uDC00-\\uDC0B\\uDC0D-\\uDC26\\uDC28-\\uDC3A\\uDC3C\\uDC3D\\uDC3F-\\uDC4D\\uDC50-\\uDC5D\\uDC80-\\uDCFA\\uDD40-\\uDD74\\uDDFD\\uDE80-\\uDE9C\\uDEA0-\\uDED0\\uDEE0\\uDF00-\\uDF1F\\uDF2D-\\uDF4A\\uDF50-\\uDF7A\\uDF80-\\uDF9D\\uDFA0-\\uDFC3\\uDFC8-\\uDFCF\\uDFD1-\\uDFD5]|\\uD801[\\uDC00-\\uDC9D\\uDCA0-\\uDCA9\\uDCB0-\\uDCD3\\uDCD8-\\uDCFB\\uDD00-\\uDD27\\uDD30-\\uDD63\\uDE00-\\uDF36\\uDF40-\\uDF55\\uDF60-\\uDF67]|\\uD802[\\uDC00-\\uDC05\\uDC08\\uDC0A-\\uDC35\\uDC37\\uDC38\\uDC3C\\uDC3F-\\uDC55\\uDC60-\\uDC76\\uDC80-\\uDC9E\\uDCE0-\\uDCF2\\uDCF4\\uDCF5\\uDD00-\\uDD15\\uDD20-\\uDD39\\uDD80-\\uDDB7\\uDDBE\\uDDBF\\uDE00-\\uDE03\\uDE05\\uDE06\\uDE0C-\\uDE13\\uDE15-\\uDE17\\uDE19-\\uDE35\\uDE38-\\uDE3A\\uDE3F\\uDE60-\\uDE7C\\uDE80-\\uDE9C\\uDEC0-\\uDEC7\\uDEC9-\\uDEE6\\uDF00-\\uDF35\\uDF40-\\uDF55\\uDF60-\\uDF72\\uDF80-\\uDF91]|\\uD803[\\uDC00-\\uDC48\\uDC80-\\uDCB2\\uDCC0-\\uDCF2\\uDD00-\\uDD27\\uDD30-\\uDD39\\uDE80-\\uDEA9\\uDEAB\\uDEAC\\uDEB0\\uDEB1\\uDF00-\\uDF1C\\uDF27\\uDF30-\\uDF50\\uDFB0-\\uDFC4\\uDFE0-\\uDFF6]|\\uD804[\\uDC00-\\uDC46\\uDC66-\\uDC6F\\uDC7F-\\uDCBA\\uDCD0-\\uDCE8\\uDCF0-\\uDCF9\\uDD00-\\uDD34\\uDD36-\\uDD3F\\uDD44-\\uDD47\\uDD50-\\uDD73\\uDD76\\uDD80-\\uDDC4\\uDDC9-\\uDDCC\\uDDCE-\\uDDDA\\uDDDC\\uDE00-\\uDE11\\uDE13-\\uDE37\\uDE3E\\uDE80-\\uDE86\\uDE88\\uDE8A-\\uDE8D\\uDE8F-\\uDE9D\\uDE9F-\\uDEA8\\uDEB0-\\uDEEA\\uDEF0-\\uDEF9\\uDF00-\\uDF03\\uDF05-\\uDF0C\\uDF0F\\uDF10\\uDF13-\\uDF28\\uDF2A-\\uDF30\\uDF32\\uDF33\\uDF35-\\uDF39\\uDF3B-\\uDF44\\uDF47\\uDF48\\uDF4B-\\uDF4D\\uDF50\\uDF57\\uDF5D-\\uDF63\\uDF66-\\uDF6C\\uDF70-\\uDF74]|\\uD805[\\uDC00-\\uDC4A\\uDC50-\\uDC59\\uDC5E-\\uDC61\\uDC80-\\uDCC5\\uDCC7\\uDCD0-\\uDCD9\\uDD80-\\uDDB5\\uDDB8-\\uDDC0\\uDDD8-\\uDDDD\\uDE00-\\uDE40\\uDE44\\uDE50-\\uDE59\\uDE80-\\uDEB8\\uDEC0-\\uDEC9\\uDF00-\\uDF1A\\uDF1D-\\uDF2B\\uDF30-\\uDF39]|\\uD806[\\uDC00-\\uDC3A\\uDCA0-\\uDCE9\\uDCFF-\\uDD06\\uDD09\\uDD0C-\\uDD13\\uDD15\\uDD16\\uDD18-\\uDD35\\uDD37\\uDD38\\uDD3B-\\uDD43\\uDD50-\\uDD59\\uDDA0-\\uDDA7\\uDDAA-\\uDDD7\\uDDDA-\\uDDE1\\uDDE3\\uDDE4\\uDE00-\\uDE3E\\uDE47\\uDE50-\\uDE99\\uDE9D\\uDEC0-\\uDEF8]|\\uD807[\\uDC00-\\uDC08\\uDC0A-\\uDC36\\uDC38-\\uDC40\\uDC50-\\uDC59\\uDC72-\\uDC8F\\uDC92-\\uDCA7\\uDCA9-\\uDCB6\\uDD00-\\uDD06\\uDD08\\uDD09\\uDD0B-\\uDD36\\uDD3A\\uDD3C\\uDD3D\\uDD3F-\\uDD47\\uDD50-\\uDD59\\uDD60-\\uDD65\\uDD67\\uDD68\\uDD6A-\\uDD8E\\uDD90\\uDD91\\uDD93-\\uDD98\\uDDA0-\\uDDA9\\uDEE0-\\uDEF6\\uDFB0]|\\uD808[\\uDC00-\\uDF99]|\\uD809[\\uDC00-\\uDC6E\\uDC80-\\uDD43]|[\\uD80C\\uD81C-\\uD820\\uD822\\uD840-\\uD868\\uD86A-\\uD86C\\uD86F-\\uD872\\uD874-\\uD879\\uD880-\\uD883][\\uDC00-\\uDFFF]|\\uD80D[\\uDC00-\\uDC2E]|\\uD811[\\uDC00-\\uDE46]|\\uD81A[\\uDC00-\\uDE38\\uDE40-\\uDE5E\\uDE60-\\uDE69\\uDED0-\\uDEED\\uDEF0-\\uDEF4\\uDF00-\\uDF36\\uDF40-\\uDF43\\uDF50-\\uDF59\\uDF63-\\uDF77\\uDF7D-\\uDF8F]|\\uD81B[\\uDE40-\\uDE7F\\uDF00-\\uDF4A\\uDF4F-\\uDF87\\uDF8F-\\uDF9F\\uDFE0\\uDFE1\\uDFE3\\uDFE4\\uDFF0\\uDFF1]|\\uD821[\\uDC00-\\uDFF7]|\\uD823[\\uDC00-\\uDCD5\\uDD00-\\uDD08]|\\uD82C[\\uDC00-\\uDD1E\\uDD50-\\uDD52\\uDD64-\\uDD67\\uDD70-\\uDEFB]|\\uD82F[\\uDC00-\\uDC6A\\uDC70-\\uDC7C\\uDC80-\\uDC88\\uDC90-\\uDC99\\uDC9D\\uDC9E]|\\uD834[\\uDD65-\\uDD69\\uDD6D-\\uDD72\\uDD7B-\\uDD82\\uDD85-\\uDD8B\\uDDAA-\\uDDAD\\uDE42-\\uDE44]|\\uD835[\\uDC00-\\uDC54\\uDC56-\\uDC9C\\uDC9E\\uDC9F\\uDCA2\\uDCA5\\uDCA6\\uDCA9-\\uDCAC\\uDCAE-\\uDCB9\\uDCBB\\uDCBD-\\uDCC3\\uDCC5-\\uDD05\\uDD07-\\uDD0A\\uDD0D-\\uDD14\\uDD16-\\uDD1C\\uDD1E-\\uDD39\\uDD3B-\\uDD3E\\uDD40-\\uDD44\\uDD46\\uDD4A-\\uDD50\\uDD52-\\uDEA5\\uDEA8-\\uDEC0\\uDEC2-\\uDEDA\\uDEDC-\\uDEFA\\uDEFC-\\uDF14\\uDF16-\\uDF34\\uDF36-\\uDF4E\\uDF50-\\uDF6E\\uDF70-\\uDF88\\uDF8A-\\uDFA8\\uDFAA-\\uDFC2\\uDFC4-\\uDFCB\\uDFCE-\\uDFFF]|\\uD836[\\uDE00-\\uDE36\\uDE3B-\\uDE6C\\uDE75\\uDE84\\uDE9B-\\uDE9F\\uDEA1-\\uDEAF]|\\uD838[\\uDC00-\\uDC06\\uDC08-\\uDC18\\uDC1B-\\uDC21\\uDC23\\uDC24\\uDC26-\\uDC2A\\uDD00-\\uDD2C\\uDD30-\\uDD3D\\uDD40-\\uDD49\\uDD4E\\uDEC0-\\uDEF9]|\\uD83A[\\uDC00-\\uDCC4\\uDCD0-\\uDCD6\\uDD00-\\uDD4B\\uDD50-\\uDD59]|\\uD83B[\\uDE00-\\uDE03\\uDE05-\\uDE1F\\uDE21\\uDE22\\uDE24\\uDE27\\uDE29-\\uDE32\\uDE34-\\uDE37\\uDE39\\uDE3B\\uDE42\\uDE47\\uDE49\\uDE4B\\uDE4D-\\uDE4F\\uDE51\\uDE52\\uDE54\\uDE57\\uDE59\\uDE5B\\uDE5D\\uDE5F\\uDE61\\uDE62\\uDE64\\uDE67-\\uDE6A\\uDE6C-\\uDE72\\uDE74-\\uDE77\\uDE79-\\uDE7C\\uDE7E\\uDE80-\\uDE89\\uDE8B-\\uDE9B\\uDEA1-\\uDEA3\\uDEA5-\\uDEA9\\uDEAB-\\uDEBB]|\\uD83E[\\uDFF0-\\uDFF9]|\\uD869[\\uDC00-\\uDEDD\\uDF00-\\uDFFF]|\\uD86D[\\uDC00-\\uDF34\\uDF40-\\uDFFF]|\\uD86E[\\uDC00-\\uDC1D\\uDC20-\\uDFFF]|\\uD873[\\uDC00-\\uDEA1\\uDEB0-\\uDFFF]|\\uD87A[\\uDC00-\\uDFE0]|\\uD87E[\\uDC00-\\uDE1D]|\\uD884[\\uDC00-\\uDF4A]|\\uDB40[\\uDD00-\\uDDEF])*", "y");
  JSXString = new RegExp("(['\"])(?:(?!\\1)[^])*(\\1)?", "y");
  JSXText = new RegExp("[^<>{}]+", "y");
  TokensPrecedingExpression = /^(?:[\/+-]|\.{3}|\?(?:InterpolationIn(?:JSX|Template)|NoLineTerminatorHere|NonExpressionParenEnd|UnaryIncDec))?$|[{}([,;<>=*%&|^!~?:]$/;
  TokensNotPrecedingObjectLiteral = /^(?:=>|[;\]){}]|else|\?(?:NoLineTerminatorHere|NonExpressionParenEnd))?$/;
  KeywordsWithExpressionAfter = /^(?:await|case|default|delete|do|else|instanceof|new|return|throw|typeof|void|yield)$/;
  KeywordsWithNoLineTerminatorAfter = /^(?:return|throw|yield)$/;
  Newline = RegExp(LineTerminatorSequence.source);

  regenerator.mark(function jsTokens(input, _temp) {
    var _ref, _ref$jsx, jsx, braces, firstCodePoint, isExpression, lastIndex, lastSignificantToken, length, match, mode, nextLastIndex, nextLastSignificantToken, parenNesting, postfixIncDec, punctuator, stack;

    return regenerator.wrap(function jsTokens$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _ref = _temp === void 0 ? {} : _temp, _ref$jsx = _ref.jsx, jsx = _ref$jsx === void 0 ? false : _ref$jsx;
            length = input.length;
            lastIndex = 0;
            lastSignificantToken = "";
            stack = [{
              tag: "JS"
            }];
            braces = [];
            parenNesting = 0;
            postfixIncDec = false;

          case 8:
            if (!(lastIndex < length)) {
              _context.next = 231;
              break;
            }

            mode = stack[stack.length - 1];
            _context.t0 = mode.tag;
            _context.next = _context.t0 === "JS" ? 13 : _context.t0 === "JSNonExpressionParen" ? 13 : _context.t0 === "InterpolationInTemplate" ? 13 : _context.t0 === "InterpolationInJSX" ? 13 : _context.t0 === "JSXTag" ? 136 : _context.t0 === "JSXTagEnd" ? 136 : _context.t0 === "JSXChildren" ? 172 : 195;
            break;

          case 13:
            if (!(input[lastIndex] === "/" && (TokensPrecedingExpression.test(lastSignificantToken) || KeywordsWithExpressionAfter.test(lastSignificantToken)))) {
              _context.next = 22;
              break;
            }

            RegularExpressionLiteral.lastIndex = lastIndex;

            if (!(match = RegularExpressionLiteral.exec(input))) {
              _context.next = 22;
              break;
            }

            lastIndex = RegularExpressionLiteral.lastIndex;
            lastSignificantToken = match[0];
            postfixIncDec = true;
            _context.next = 21;
            return {
              type: "RegularExpressionLiteral",
              value: match[0],
              closed: match[1] !== void 0 && match[1] !== "\\"
            };

          case 21:
            return _context.abrupt("continue", 8);

          case 22:
            Punctuator.lastIndex = lastIndex;

            if (!(match = Punctuator.exec(input))) {
              _context.next = 93;
              break;
            }

            punctuator = match[0];
            nextLastIndex = Punctuator.lastIndex;
            nextLastSignificantToken = punctuator;
            _context.t1 = punctuator;
            _context.next = _context.t1 === "(" ? 30 : _context.t1 === ")" ? 34 : _context.t1 === "{" ? 38 : _context.t1 === "}" ? 43 : _context.t1 === "]" ? 74 : _context.t1 === "++" ? 76 : _context.t1 === "--" ? 76 : _context.t1 === "<" ? 78 : 87;
            break;

          case 30:
            if (lastSignificantToken === "?NonExpressionParenKeyword") {
              stack.push({
                tag: "JSNonExpressionParen",
                nesting: parenNesting
              });
            }

            parenNesting++;
            postfixIncDec = false;
            return _context.abrupt("break", 88);

          case 34:
            parenNesting--;
            postfixIncDec = true;

            if (mode.tag === "JSNonExpressionParen" && parenNesting === mode.nesting) {
              stack.pop();
              nextLastSignificantToken = "?NonExpressionParenEnd";
              postfixIncDec = false;
            }

            return _context.abrupt("break", 88);

          case 38:
            Punctuator.lastIndex = 0;
            isExpression = !TokensNotPrecedingObjectLiteral.test(lastSignificantToken) && (TokensPrecedingExpression.test(lastSignificantToken) || KeywordsWithExpressionAfter.test(lastSignificantToken));
            braces.push(isExpression);
            postfixIncDec = false;
            return _context.abrupt("break", 88);

          case 43:
            _context.t2 = mode.tag;
            _context.next = _context.t2 === "InterpolationInTemplate" ? 46 : _context.t2 === "InterpolationInJSX" ? 64 : 71;
            break;

          case 46:
            if (!(braces.length === mode.nesting)) {
              _context.next = 63;
              break;
            }

            Template.lastIndex = lastIndex;
            match = Template.exec(input);
            lastIndex = Template.lastIndex;
            lastSignificantToken = match[0];

            if (!(match[1] === "${")) {
              _context.next = 58;
              break;
            }

            lastSignificantToken = "?InterpolationInTemplate";
            postfixIncDec = false;
            _context.next = 56;
            return {
              type: "TemplateMiddle",
              value: match[0]
            };

          case 56:
            _context.next = 62;
            break;

          case 58:
            stack.pop();
            postfixIncDec = true;
            _context.next = 62;
            return {
              type: "TemplateTail",
              value: match[0],
              closed: match[1] === "`"
            };

          case 62:
            return _context.abrupt("continue", 8);

          case 63:
            return _context.abrupt("break", 71);

          case 64:
            if (!(braces.length === mode.nesting)) {
              _context.next = 71;
              break;
            }

            stack.pop();
            lastIndex += 1;
            lastSignificantToken = "}";
            _context.next = 70;
            return {
              type: "JSXPunctuator",
              value: "}"
            };

          case 70:
            return _context.abrupt("continue", 8);

          case 71:
            postfixIncDec = braces.pop();
            nextLastSignificantToken = postfixIncDec ? "?ExpressionBraceEnd" : "}";
            return _context.abrupt("break", 88);

          case 74:
            postfixIncDec = true;
            return _context.abrupt("break", 88);

          case 76:
            nextLastSignificantToken = postfixIncDec ? "?PostfixIncDec" : "?UnaryIncDec";
            return _context.abrupt("break", 88);

          case 78:
            if (!(jsx && (TokensPrecedingExpression.test(lastSignificantToken) || KeywordsWithExpressionAfter.test(lastSignificantToken)))) {
              _context.next = 85;
              break;
            }

            stack.push({
              tag: "JSXTag"
            });
            lastIndex += 1;
            lastSignificantToken = "<";
            _context.next = 84;
            return {
              type: "JSXPunctuator",
              value: punctuator
            };

          case 84:
            return _context.abrupt("continue", 8);

          case 85:
            postfixIncDec = false;
            return _context.abrupt("break", 88);

          case 87:
            postfixIncDec = false;

          case 88:
            lastIndex = nextLastIndex;
            lastSignificantToken = nextLastSignificantToken;
            _context.next = 92;
            return {
              type: "Punctuator",
              value: punctuator
            };

          case 92:
            return _context.abrupt("continue", 8);

          case 93:
            IdentifierName.lastIndex = lastIndex;

            if (!(match = IdentifierName.exec(input))) {
              _context.next = 103;
              break;
            }

            lastIndex = IdentifierName.lastIndex;
            nextLastSignificantToken = match[0];

            switch (match[0]) {
              case "for":
              case "if":
              case "while":
              case "with":
                if (lastSignificantToken !== "." && lastSignificantToken !== "?.") {
                  nextLastSignificantToken = "?NonExpressionParenKeyword";
                }

            }

            lastSignificantToken = nextLastSignificantToken;
            postfixIncDec = !KeywordsWithExpressionAfter.test(match[0]);
            _context.next = 102;
            return {
              type: "IdentifierName",
              value: match[0]
            };

          case 102:
            return _context.abrupt("continue", 8);

          case 103:
            StringLiteral.lastIndex = lastIndex;

            if (!(match = StringLiteral.exec(input))) {
              _context.next = 111;
              break;
            }

            lastIndex = StringLiteral.lastIndex;
            lastSignificantToken = match[0];
            postfixIncDec = true;
            _context.next = 110;
            return {
              type: "StringLiteral",
              value: match[0],
              closed: match[2] !== void 0
            };

          case 110:
            return _context.abrupt("continue", 8);

          case 111:
            NumericLiteral.lastIndex = lastIndex;

            if (!(match = NumericLiteral.exec(input))) {
              _context.next = 119;
              break;
            }

            lastIndex = NumericLiteral.lastIndex;
            lastSignificantToken = match[0];
            postfixIncDec = true;
            _context.next = 118;
            return {
              type: "NumericLiteral",
              value: match[0]
            };

          case 118:
            return _context.abrupt("continue", 8);

          case 119:
            Template.lastIndex = lastIndex;

            if (!(match = Template.exec(input))) {
              _context.next = 135;
              break;
            }

            lastIndex = Template.lastIndex;
            lastSignificantToken = match[0];

            if (!(match[1] === "${")) {
              _context.next = 131;
              break;
            }

            lastSignificantToken = "?InterpolationInTemplate";
            stack.push({
              tag: "InterpolationInTemplate",
              nesting: braces.length
            });
            postfixIncDec = false;
            _context.next = 129;
            return {
              type: "TemplateHead",
              value: match[0]
            };

          case 129:
            _context.next = 134;
            break;

          case 131:
            postfixIncDec = true;
            _context.next = 134;
            return {
              type: "NoSubstitutionTemplate",
              value: match[0],
              closed: match[1] === "`"
            };

          case 134:
            return _context.abrupt("continue", 8);

          case 135:
            return _context.abrupt("break", 195);

          case 136:
            JSXPunctuator.lastIndex = lastIndex;

            if (!(match = JSXPunctuator.exec(input))) {
              _context.next = 157;
              break;
            }

            lastIndex = JSXPunctuator.lastIndex;
            nextLastSignificantToken = match[0];
            _context.t3 = match[0];
            _context.next = _context.t3 === "<" ? 143 : _context.t3 === ">" ? 145 : _context.t3 === "{" ? 148 : _context.t3 === "/" ? 152 : 153;
            break;

          case 143:
            stack.push({
              tag: "JSXTag"
            });
            return _context.abrupt("break", 153);

          case 145:
            stack.pop();

            if (lastSignificantToken === "/" || mode.tag === "JSXTagEnd") {
              nextLastSignificantToken = "?JSX";
              postfixIncDec = true;
            } else {
              stack.push({
                tag: "JSXChildren"
              });
            }

            return _context.abrupt("break", 153);

          case 148:
            stack.push({
              tag: "InterpolationInJSX",
              nesting: braces.length
            });
            nextLastSignificantToken = "?InterpolationInJSX";
            postfixIncDec = false;
            return _context.abrupt("break", 153);

          case 152:
            if (lastSignificantToken === "<") {
              stack.pop();

              if (stack[stack.length - 1].tag === "JSXChildren") {
                stack.pop();
              }

              stack.push({
                tag: "JSXTagEnd"
              });
            }

          case 153:
            lastSignificantToken = nextLastSignificantToken;
            _context.next = 156;
            return {
              type: "JSXPunctuator",
              value: match[0]
            };

          case 156:
            return _context.abrupt("continue", 8);

          case 157:
            JSXIdentifier.lastIndex = lastIndex;

            if (!(match = JSXIdentifier.exec(input))) {
              _context.next = 164;
              break;
            }

            lastIndex = JSXIdentifier.lastIndex;
            lastSignificantToken = match[0];
            _context.next = 163;
            return {
              type: "JSXIdentifier",
              value: match[0]
            };

          case 163:
            return _context.abrupt("continue", 8);

          case 164:
            JSXString.lastIndex = lastIndex;

            if (!(match = JSXString.exec(input))) {
              _context.next = 171;
              break;
            }

            lastIndex = JSXString.lastIndex;
            lastSignificantToken = match[0];
            _context.next = 170;
            return {
              type: "JSXString",
              value: match[0],
              closed: match[2] !== void 0
            };

          case 170:
            return _context.abrupt("continue", 8);

          case 171:
            return _context.abrupt("break", 195);

          case 172:
            JSXText.lastIndex = lastIndex;

            if (!(match = JSXText.exec(input))) {
              _context.next = 179;
              break;
            }

            lastIndex = JSXText.lastIndex;
            lastSignificantToken = match[0];
            _context.next = 178;
            return {
              type: "JSXText",
              value: match[0]
            };

          case 178:
            return _context.abrupt("continue", 8);

          case 179:
            _context.t4 = input[lastIndex];
            _context.next = _context.t4 === "<" ? 182 : _context.t4 === "{" ? 188 : 195;
            break;

          case 182:
            stack.push({
              tag: "JSXTag"
            });
            lastIndex++;
            lastSignificantToken = "<";
            _context.next = 187;
            return {
              type: "JSXPunctuator",
              value: "<"
            };

          case 187:
            return _context.abrupt("continue", 8);

          case 188:
            stack.push({
              tag: "InterpolationInJSX",
              nesting: braces.length
            });
            lastIndex++;
            lastSignificantToken = "?InterpolationInJSX";
            postfixIncDec = false;
            _context.next = 194;
            return {
              type: "JSXPunctuator",
              value: "{"
            };

          case 194:
            return _context.abrupt("continue", 8);

          case 195:
            WhiteSpace.lastIndex = lastIndex;

            if (!(match = WhiteSpace.exec(input))) {
              _context.next = 201;
              break;
            }

            lastIndex = WhiteSpace.lastIndex;
            _context.next = 200;
            return {
              type: "WhiteSpace",
              value: match[0]
            };

          case 200:
            return _context.abrupt("continue", 8);

          case 201:
            LineTerminatorSequence.lastIndex = lastIndex;

            if (!(match = LineTerminatorSequence.exec(input))) {
              _context.next = 209;
              break;
            }

            lastIndex = LineTerminatorSequence.lastIndex;
            postfixIncDec = false;

            if (KeywordsWithNoLineTerminatorAfter.test(lastSignificantToken)) {
              lastSignificantToken = "?NoLineTerminatorHere";
            }

            _context.next = 208;
            return {
              type: "LineTerminatorSequence",
              value: match[0]
            };

          case 208:
            return _context.abrupt("continue", 8);

          case 209:
            MultiLineComment.lastIndex = lastIndex;

            if (!(match = MultiLineComment.exec(input))) {
              _context.next = 216;
              break;
            }

            lastIndex = MultiLineComment.lastIndex;

            if (Newline.test(match[0])) {
              postfixIncDec = false;

              if (KeywordsWithNoLineTerminatorAfter.test(lastSignificantToken)) {
                lastSignificantToken = "?NoLineTerminatorHere";
              }
            }

            _context.next = 215;
            return {
              type: "MultiLineComment",
              value: match[0],
              closed: match[1] !== void 0
            };

          case 215:
            return _context.abrupt("continue", 8);

          case 216:
            SingleLineComment.lastIndex = lastIndex;

            if (!(match = SingleLineComment.exec(input))) {
              _context.next = 223;
              break;
            }

            lastIndex = SingleLineComment.lastIndex;
            postfixIncDec = false;
            _context.next = 222;
            return {
              type: "SingleLineComment",
              value: match[0]
            };

          case 222:
            return _context.abrupt("continue", 8);

          case 223:
            firstCodePoint = String.fromCodePoint(input.codePointAt(lastIndex));
            lastIndex += firstCodePoint.length;
            lastSignificantToken = firstCodePoint;
            postfixIncDec = false;
            _context.next = 229;
            return {
              type: mode.tag.startsWith("JSX") ? "JSXInvalid" : "Invalid",
              value: firstCodePoint
            };

          case 229:
            _context.next = 8;
            break;

          case 231:
            return _context.abrupt("return", void 0);

          case 232:
          case "end":
            return _context.stop();
        }
      }
    }, jsTokens);
  });

  var _default = /((['"])(?:(?!\2|\\).|\\(?:\r\n|[\s\S]))*(\2)?|`(?:[^`\\$]|\\[\s\S]|\$(?!\{)|\$\{(?:[^{}]|\{[^}]*\}?)*\}?)*(`)?)|(\/\/.*)|(\/\*(?:[^*]|\*(?!\/))*(\*\/)?)|(\/(?!\*)(?:\[(?:(?![\]\\]).|\\.)*\]|(?![\/\]\\]).|\\.)+\/(?:(?!\s*(?:\b|[\u0080-\uFFFF$\\'"~({]|[+\-!](?!=)|\.?\d))|[gmiyus]{1,6}\b(?![\u0080-\uFFFF$\\]|\s*(?:[+\-*%&|^<>!=?({]|\/(?![\/*])))))|(0[xX][\da-fA-F]+|0[oO][0-7]+|0[bB][01]+|(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?)|((?!\d)(?:(?!\s)[$\w\u0080-\uFFFF]|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]+\})+)|(--|\+\+|&&|\|\||=>|\.{3}|(?:[+\-\/%&|^]|\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2})=?|[?~.,:;[\](){}])|(\s+)|(^$|[\s\S])/g;

  var matchToToken = function matchToToken(match) {
    var token = {
      type: "invalid",
      value: match[0],
      closed: undefined
    };
    if (match[1]) token.type = "string", token.closed = !!(match[3] || match[4]);else if (match[5]) token.type = "comment";else if (match[6]) token.type = "comment", token.closed = !!match[7];else if (match[8]) token.type = "regex";else if (match[9]) token.type = "number";else if (match[10]) token.type = "name";else if (match[11]) token.type = "punctuator";else if (match[12]) token.type = "whitespace";
    return token;
  };

  var jsTokensBABEL_8_BREAKINGFalse = Object.defineProperty({
    "default": _default,
    matchToToken: matchToToken
  }, '__esModule', {
    value: true
  });

  var jsTokens = jsTokensBABEL_8_BREAKINGFalse;

  var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;

  var escapeStringRegexp = function escapeStringRegexp(str) {
    if (typeof str !== 'string') {
      throw new TypeError('Expected a string');
    }

    return str.replace(matchOperatorsRe, '\\$&');
  };

  var colorName = {
    "aliceblue": [240, 248, 255],
    "antiquewhite": [250, 235, 215],
    "aqua": [0, 255, 255],
    "aquamarine": [127, 255, 212],
    "azure": [240, 255, 255],
    "beige": [245, 245, 220],
    "bisque": [255, 228, 196],
    "black": [0, 0, 0],
    "blanchedalmond": [255, 235, 205],
    "blue": [0, 0, 255],
    "blueviolet": [138, 43, 226],
    "brown": [165, 42, 42],
    "burlywood": [222, 184, 135],
    "cadetblue": [95, 158, 160],
    "chartreuse": [127, 255, 0],
    "chocolate": [210, 105, 30],
    "coral": [255, 127, 80],
    "cornflowerblue": [100, 149, 237],
    "cornsilk": [255, 248, 220],
    "crimson": [220, 20, 60],
    "cyan": [0, 255, 255],
    "darkblue": [0, 0, 139],
    "darkcyan": [0, 139, 139],
    "darkgoldenrod": [184, 134, 11],
    "darkgray": [169, 169, 169],
    "darkgreen": [0, 100, 0],
    "darkgrey": [169, 169, 169],
    "darkkhaki": [189, 183, 107],
    "darkmagenta": [139, 0, 139],
    "darkolivegreen": [85, 107, 47],
    "darkorange": [255, 140, 0],
    "darkorchid": [153, 50, 204],
    "darkred": [139, 0, 0],
    "darksalmon": [233, 150, 122],
    "darkseagreen": [143, 188, 143],
    "darkslateblue": [72, 61, 139],
    "darkslategray": [47, 79, 79],
    "darkslategrey": [47, 79, 79],
    "darkturquoise": [0, 206, 209],
    "darkviolet": [148, 0, 211],
    "deeppink": [255, 20, 147],
    "deepskyblue": [0, 191, 255],
    "dimgray": [105, 105, 105],
    "dimgrey": [105, 105, 105],
    "dodgerblue": [30, 144, 255],
    "firebrick": [178, 34, 34],
    "floralwhite": [255, 250, 240],
    "forestgreen": [34, 139, 34],
    "fuchsia": [255, 0, 255],
    "gainsboro": [220, 220, 220],
    "ghostwhite": [248, 248, 255],
    "gold": [255, 215, 0],
    "goldenrod": [218, 165, 32],
    "gray": [128, 128, 128],
    "green": [0, 128, 0],
    "greenyellow": [173, 255, 47],
    "grey": [128, 128, 128],
    "honeydew": [240, 255, 240],
    "hotpink": [255, 105, 180],
    "indianred": [205, 92, 92],
    "indigo": [75, 0, 130],
    "ivory": [255, 255, 240],
    "khaki": [240, 230, 140],
    "lavender": [230, 230, 250],
    "lavenderblush": [255, 240, 245],
    "lawngreen": [124, 252, 0],
    "lemonchiffon": [255, 250, 205],
    "lightblue": [173, 216, 230],
    "lightcoral": [240, 128, 128],
    "lightcyan": [224, 255, 255],
    "lightgoldenrodyellow": [250, 250, 210],
    "lightgray": [211, 211, 211],
    "lightgreen": [144, 238, 144],
    "lightgrey": [211, 211, 211],
    "lightpink": [255, 182, 193],
    "lightsalmon": [255, 160, 122],
    "lightseagreen": [32, 178, 170],
    "lightskyblue": [135, 206, 250],
    "lightslategray": [119, 136, 153],
    "lightslategrey": [119, 136, 153],
    "lightsteelblue": [176, 196, 222],
    "lightyellow": [255, 255, 224],
    "lime": [0, 255, 0],
    "limegreen": [50, 205, 50],
    "linen": [250, 240, 230],
    "magenta": [255, 0, 255],
    "maroon": [128, 0, 0],
    "mediumaquamarine": [102, 205, 170],
    "mediumblue": [0, 0, 205],
    "mediumorchid": [186, 85, 211],
    "mediumpurple": [147, 112, 219],
    "mediumseagreen": [60, 179, 113],
    "mediumslateblue": [123, 104, 238],
    "mediumspringgreen": [0, 250, 154],
    "mediumturquoise": [72, 209, 204],
    "mediumvioletred": [199, 21, 133],
    "midnightblue": [25, 25, 112],
    "mintcream": [245, 255, 250],
    "mistyrose": [255, 228, 225],
    "moccasin": [255, 228, 181],
    "navajowhite": [255, 222, 173],
    "navy": [0, 0, 128],
    "oldlace": [253, 245, 230],
    "olive": [128, 128, 0],
    "olivedrab": [107, 142, 35],
    "orange": [255, 165, 0],
    "orangered": [255, 69, 0],
    "orchid": [218, 112, 214],
    "palegoldenrod": [238, 232, 170],
    "palegreen": [152, 251, 152],
    "paleturquoise": [175, 238, 238],
    "palevioletred": [219, 112, 147],
    "papayawhip": [255, 239, 213],
    "peachpuff": [255, 218, 185],
    "peru": [205, 133, 63],
    "pink": [255, 192, 203],
    "plum": [221, 160, 221],
    "powderblue": [176, 224, 230],
    "purple": [128, 0, 128],
    "rebeccapurple": [102, 51, 153],
    "red": [255, 0, 0],
    "rosybrown": [188, 143, 143],
    "royalblue": [65, 105, 225],
    "saddlebrown": [139, 69, 19],
    "salmon": [250, 128, 114],
    "sandybrown": [244, 164, 96],
    "seagreen": [46, 139, 87],
    "seashell": [255, 245, 238],
    "sienna": [160, 82, 45],
    "silver": [192, 192, 192],
    "skyblue": [135, 206, 235],
    "slateblue": [106, 90, 205],
    "slategray": [112, 128, 144],
    "slategrey": [112, 128, 144],
    "snow": [255, 250, 250],
    "springgreen": [0, 255, 127],
    "steelblue": [70, 130, 180],
    "tan": [210, 180, 140],
    "teal": [0, 128, 128],
    "thistle": [216, 191, 216],
    "tomato": [255, 99, 71],
    "turquoise": [64, 224, 208],
    "violet": [238, 130, 238],
    "wheat": [245, 222, 179],
    "white": [255, 255, 255],
    "whitesmoke": [245, 245, 245],
    "yellow": [255, 255, 0],
    "yellowgreen": [154, 205, 50]
  };

  var conversions = createCommonjsModule(function (module) {
    var reverseKeywords = {};

    for (var key in colorName) {
      if (colorName.hasOwnProperty(key)) {
        reverseKeywords[colorName[key]] = key;
      }
    }

    var convert = module.exports = {
      rgb: {
        channels: 3,
        labels: 'rgb'
      },
      hsl: {
        channels: 3,
        labels: 'hsl'
      },
      hsv: {
        channels: 3,
        labels: 'hsv'
      },
      hwb: {
        channels: 3,
        labels: 'hwb'
      },
      cmyk: {
        channels: 4,
        labels: 'cmyk'
      },
      xyz: {
        channels: 3,
        labels: 'xyz'
      },
      lab: {
        channels: 3,
        labels: 'lab'
      },
      lch: {
        channels: 3,
        labels: 'lch'
      },
      hex: {
        channels: 1,
        labels: ['hex']
      },
      keyword: {
        channels: 1,
        labels: ['keyword']
      },
      ansi16: {
        channels: 1,
        labels: ['ansi16']
      },
      ansi256: {
        channels: 1,
        labels: ['ansi256']
      },
      hcg: {
        channels: 3,
        labels: ['h', 'c', 'g']
      },
      apple: {
        channels: 3,
        labels: ['r16', 'g16', 'b16']
      },
      gray: {
        channels: 1,
        labels: ['gray']
      }
    };

    for (var model in convert) {
      if (convert.hasOwnProperty(model)) {
        if (!('channels' in convert[model])) {
          throw new Error('missing channels property: ' + model);
        }

        if (!('labels' in convert[model])) {
          throw new Error('missing channel labels property: ' + model);
        }

        if (convert[model].labels.length !== convert[model].channels) {
          throw new Error('channel and label counts mismatch: ' + model);
        }

        var channels = convert[model].channels;
        var labels = convert[model].labels;
        delete convert[model].channels;
        delete convert[model].labels;
        Object.defineProperty(convert[model], 'channels', {
          value: channels
        });
        Object.defineProperty(convert[model], 'labels', {
          value: labels
        });
      }
    }

    convert.rgb.hsl = function (rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var min = Math.min(r, g, b);
      var max = Math.max(r, g, b);
      var delta = max - min;
      var h;
      var s;
      var l;

      if (max === min) {
        h = 0;
      } else if (r === max) {
        h = (g - b) / delta;
      } else if (g === max) {
        h = 2 + (b - r) / delta;
      } else if (b === max) {
        h = 4 + (r - g) / delta;
      }

      h = Math.min(h * 60, 360);

      if (h < 0) {
        h += 360;
      }

      l = (min + max) / 2;

      if (max === min) {
        s = 0;
      } else if (l <= 0.5) {
        s = delta / (max + min);
      } else {
        s = delta / (2 - max - min);
      }

      return [h, s * 100, l * 100];
    };

    convert.rgb.hsv = function (rgb) {
      var rdif;
      var gdif;
      var bdif;
      var h;
      var s;
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var v = Math.max(r, g, b);
      var diff = v - Math.min(r, g, b);

      var diffc = function diffc(c) {
        return (v - c) / 6 / diff + 1 / 2;
      };

      if (diff === 0) {
        h = s = 0;
      } else {
        s = diff / v;
        rdif = diffc(r);
        gdif = diffc(g);
        bdif = diffc(b);

        if (r === v) {
          h = bdif - gdif;
        } else if (g === v) {
          h = 1 / 3 + rdif - bdif;
        } else if (b === v) {
          h = 2 / 3 + gdif - rdif;
        }

        if (h < 0) {
          h += 1;
        } else if (h > 1) {
          h -= 1;
        }
      }

      return [h * 360, s * 100, v * 100];
    };

    convert.rgb.hwb = function (rgb) {
      var r = rgb[0];
      var g = rgb[1];
      var b = rgb[2];
      var h = convert.rgb.hsl(rgb)[0];
      var w = 1 / 255 * Math.min(r, Math.min(g, b));
      b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));
      return [h, w * 100, b * 100];
    };

    convert.rgb.cmyk = function (rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var c;
      var m;
      var y;
      var k;
      k = Math.min(1 - r, 1 - g, 1 - b);
      c = (1 - r - k) / (1 - k) || 0;
      m = (1 - g - k) / (1 - k) || 0;
      y = (1 - b - k) / (1 - k) || 0;
      return [c * 100, m * 100, y * 100, k * 100];
    };

    function comparativeDistance(x, y) {
      return Math.pow(x[0] - y[0], 2) + Math.pow(x[1] - y[1], 2) + Math.pow(x[2] - y[2], 2);
    }

    convert.rgb.keyword = function (rgb) {
      var reversed = reverseKeywords[rgb];

      if (reversed) {
        return reversed;
      }

      var currentClosestDistance = Infinity;
      var currentClosestKeyword;

      for (var keyword in colorName) {
        if (colorName.hasOwnProperty(keyword)) {
          var value = colorName[keyword];
          var distance = comparativeDistance(rgb, value);

          if (distance < currentClosestDistance) {
            currentClosestDistance = distance;
            currentClosestKeyword = keyword;
          }
        }
      }

      return currentClosestKeyword;
    };

    convert.keyword.rgb = function (keyword) {
      return colorName[keyword];
    };

    convert.rgb.xyz = function (rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
      g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
      b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;
      var x = r * 0.4124 + g * 0.3576 + b * 0.1805;
      var y = r * 0.2126 + g * 0.7152 + b * 0.0722;
      var z = r * 0.0193 + g * 0.1192 + b * 0.9505;
      return [x * 100, y * 100, z * 100];
    };

    convert.rgb.lab = function (rgb) {
      var xyz = convert.rgb.xyz(rgb);
      var x = xyz[0];
      var y = xyz[1];
      var z = xyz[2];
      var l;
      var a;
      var b;
      x /= 95.047;
      y /= 100;
      z /= 108.883;
      x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
      z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
      l = 116 * y - 16;
      a = 500 * (x - y);
      b = 200 * (y - z);
      return [l, a, b];
    };

    convert.hsl.rgb = function (hsl) {
      var h = hsl[0] / 360;
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var t1;
      var t2;
      var t3;
      var rgb;
      var val;

      if (s === 0) {
        val = l * 255;
        return [val, val, val];
      }

      if (l < 0.5) {
        t2 = l * (1 + s);
      } else {
        t2 = l + s - l * s;
      }

      t1 = 2 * l - t2;
      rgb = [0, 0, 0];

      for (var i = 0; i < 3; i++) {
        t3 = h + 1 / 3 * -(i - 1);

        if (t3 < 0) {
          t3++;
        }

        if (t3 > 1) {
          t3--;
        }

        if (6 * t3 < 1) {
          val = t1 + (t2 - t1) * 6 * t3;
        } else if (2 * t3 < 1) {
          val = t2;
        } else if (3 * t3 < 2) {
          val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
        } else {
          val = t1;
        }

        rgb[i] = val * 255;
      }

      return rgb;
    };

    convert.hsl.hsv = function (hsl) {
      var h = hsl[0];
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var smin = s;
      var lmin = Math.max(l, 0.01);
      var sv;
      var v;
      l *= 2;
      s *= l <= 1 ? l : 2 - l;
      smin *= lmin <= 1 ? lmin : 2 - lmin;
      v = (l + s) / 2;
      sv = l === 0 ? 2 * smin / (lmin + smin) : 2 * s / (l + s);
      return [h, sv * 100, v * 100];
    };

    convert.hsv.rgb = function (hsv) {
      var h = hsv[0] / 60;
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var hi = Math.floor(h) % 6;
      var f = h - Math.floor(h);
      var p = 255 * v * (1 - s);
      var q = 255 * v * (1 - s * f);
      var t = 255 * v * (1 - s * (1 - f));
      v *= 255;

      switch (hi) {
        case 0:
          return [v, t, p];

        case 1:
          return [q, v, p];

        case 2:
          return [p, v, t];

        case 3:
          return [p, q, v];

        case 4:
          return [t, p, v];

        case 5:
          return [v, p, q];
      }
    };

    convert.hsv.hsl = function (hsv) {
      var h = hsv[0];
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var vmin = Math.max(v, 0.01);
      var lmin;
      var sl;
      var l;
      l = (2 - s) * v;
      lmin = (2 - s) * vmin;
      sl = s * vmin;
      sl /= lmin <= 1 ? lmin : 2 - lmin;
      sl = sl || 0;
      l /= 2;
      return [h, sl * 100, l * 100];
    };

    convert.hwb.rgb = function (hwb) {
      var h = hwb[0] / 360;
      var wh = hwb[1] / 100;
      var bl = hwb[2] / 100;
      var ratio = wh + bl;
      var i;
      var v;
      var f;
      var n;

      if (ratio > 1) {
        wh /= ratio;
        bl /= ratio;
      }

      i = Math.floor(6 * h);
      v = 1 - bl;
      f = 6 * h - i;

      if ((i & 0x01) !== 0) {
        f = 1 - f;
      }

      n = wh + f * (v - wh);
      var r;
      var g;
      var b;

      switch (i) {
        default:
        case 6:
        case 0:
          r = v;
          g = n;
          b = wh;
          break;

        case 1:
          r = n;
          g = v;
          b = wh;
          break;

        case 2:
          r = wh;
          g = v;
          b = n;
          break;

        case 3:
          r = wh;
          g = n;
          b = v;
          break;

        case 4:
          r = n;
          g = wh;
          b = v;
          break;

        case 5:
          r = v;
          g = wh;
          b = n;
          break;
      }

      return [r * 255, g * 255, b * 255];
    };

    convert.cmyk.rgb = function (cmyk) {
      var c = cmyk[0] / 100;
      var m = cmyk[1] / 100;
      var y = cmyk[2] / 100;
      var k = cmyk[3] / 100;
      var r;
      var g;
      var b;
      r = 1 - Math.min(1, c * (1 - k) + k);
      g = 1 - Math.min(1, m * (1 - k) + k);
      b = 1 - Math.min(1, y * (1 - k) + k);
      return [r * 255, g * 255, b * 255];
    };

    convert.xyz.rgb = function (xyz) {
      var x = xyz[0] / 100;
      var y = xyz[1] / 100;
      var z = xyz[2] / 100;
      var r;
      var g;
      var b;
      r = x * 3.2406 + y * -1.5372 + z * -0.4986;
      g = x * -0.9689 + y * 1.8758 + z * 0.0415;
      b = x * 0.0557 + y * -0.2040 + z * 1.0570;
      r = r > 0.0031308 ? 1.055 * Math.pow(r, 1.0 / 2.4) - 0.055 : r * 12.92;
      g = g > 0.0031308 ? 1.055 * Math.pow(g, 1.0 / 2.4) - 0.055 : g * 12.92;
      b = b > 0.0031308 ? 1.055 * Math.pow(b, 1.0 / 2.4) - 0.055 : b * 12.92;
      r = Math.min(Math.max(0, r), 1);
      g = Math.min(Math.max(0, g), 1);
      b = Math.min(Math.max(0, b), 1);
      return [r * 255, g * 255, b * 255];
    };

    convert.xyz.lab = function (xyz) {
      var x = xyz[0];
      var y = xyz[1];
      var z = xyz[2];
      var l;
      var a;
      var b;
      x /= 95.047;
      y /= 100;
      z /= 108.883;
      x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
      z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
      l = 116 * y - 16;
      a = 500 * (x - y);
      b = 200 * (y - z);
      return [l, a, b];
    };

    convert.lab.xyz = function (lab) {
      var l = lab[0];
      var a = lab[1];
      var b = lab[2];
      var x;
      var y;
      var z;
      y = (l + 16) / 116;
      x = a / 500 + y;
      z = y - b / 200;
      var y2 = Math.pow(y, 3);
      var x2 = Math.pow(x, 3);
      var z2 = Math.pow(z, 3);
      y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
      x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
      z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;
      x *= 95.047;
      y *= 100;
      z *= 108.883;
      return [x, y, z];
    };

    convert.lab.lch = function (lab) {
      var l = lab[0];
      var a = lab[1];
      var b = lab[2];
      var hr;
      var h;
      var c;
      hr = Math.atan2(b, a);
      h = hr * 360 / 2 / Math.PI;

      if (h < 0) {
        h += 360;
      }

      c = Math.sqrt(a * a + b * b);
      return [l, c, h];
    };

    convert.lch.lab = function (lch) {
      var l = lch[0];
      var c = lch[1];
      var h = lch[2];
      var a;
      var b;
      var hr;
      hr = h / 360 * 2 * Math.PI;
      a = c * Math.cos(hr);
      b = c * Math.sin(hr);
      return [l, a, b];
    };

    convert.rgb.ansi16 = function (args) {
      var r = args[0];
      var g = args[1];
      var b = args[2];
      var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2];
      value = Math.round(value / 50);

      if (value === 0) {
        return 30;
      }

      var ansi = 30 + (Math.round(b / 255) << 2 | Math.round(g / 255) << 1 | Math.round(r / 255));

      if (value === 2) {
        ansi += 60;
      }

      return ansi;
    };

    convert.hsv.ansi16 = function (args) {
      return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
    };

    convert.rgb.ansi256 = function (args) {
      var r = args[0];
      var g = args[1];
      var b = args[2];

      if (r === g && g === b) {
        if (r < 8) {
          return 16;
        }

        if (r > 248) {
          return 231;
        }

        return Math.round((r - 8) / 247 * 24) + 232;
      }

      var ansi = 16 + 36 * Math.round(r / 255 * 5) + 6 * Math.round(g / 255 * 5) + Math.round(b / 255 * 5);
      return ansi;
    };

    convert.ansi16.rgb = function (args) {
      var color = args % 10;

      if (color === 0 || color === 7) {
        if (args > 50) {
          color += 3.5;
        }

        color = color / 10.5 * 255;
        return [color, color, color];
      }

      var mult = (~~(args > 50) + 1) * 0.5;
      var r = (color & 1) * mult * 255;
      var g = (color >> 1 & 1) * mult * 255;
      var b = (color >> 2 & 1) * mult * 255;
      return [r, g, b];
    };

    convert.ansi256.rgb = function (args) {
      if (args >= 232) {
        var c = (args - 232) * 10 + 8;
        return [c, c, c];
      }

      args -= 16;
      var rem;
      var r = Math.floor(args / 36) / 5 * 255;
      var g = Math.floor((rem = args % 36) / 6) / 5 * 255;
      var b = rem % 6 / 5 * 255;
      return [r, g, b];
    };

    convert.rgb.hex = function (args) {
      var integer = ((Math.round(args[0]) & 0xFF) << 16) + ((Math.round(args[1]) & 0xFF) << 8) + (Math.round(args[2]) & 0xFF);
      var string = integer.toString(16).toUpperCase();
      return '000000'.substring(string.length) + string;
    };

    convert.hex.rgb = function (args) {
      var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);

      if (!match) {
        return [0, 0, 0];
      }

      var colorString = match[0];

      if (match[0].length === 3) {
        colorString = colorString.split('').map(function (_char) {
          return _char + _char;
        }).join('');
      }

      var integer = parseInt(colorString, 16);
      var r = integer >> 16 & 0xFF;
      var g = integer >> 8 & 0xFF;
      var b = integer & 0xFF;
      return [r, g, b];
    };

    convert.rgb.hcg = function (rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var max = Math.max(Math.max(r, g), b);
      var min = Math.min(Math.min(r, g), b);
      var chroma = max - min;
      var grayscale;
      var hue;

      if (chroma < 1) {
        grayscale = min / (1 - chroma);
      } else {
        grayscale = 0;
      }

      if (chroma <= 0) {
        hue = 0;
      } else if (max === r) {
        hue = (g - b) / chroma % 6;
      } else if (max === g) {
        hue = 2 + (b - r) / chroma;
      } else {
        hue = 4 + (r - g) / chroma + 4;
      }

      hue /= 6;
      hue %= 1;
      return [hue * 360, chroma * 100, grayscale * 100];
    };

    convert.hsl.hcg = function (hsl) {
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var c = 1;
      var f = 0;

      if (l < 0.5) {
        c = 2.0 * s * l;
      } else {
        c = 2.0 * s * (1.0 - l);
      }

      if (c < 1.0) {
        f = (l - 0.5 * c) / (1.0 - c);
      }

      return [hsl[0], c * 100, f * 100];
    };

    convert.hsv.hcg = function (hsv) {
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var c = s * v;
      var f = 0;

      if (c < 1.0) {
        f = (v - c) / (1 - c);
      }

      return [hsv[0], c * 100, f * 100];
    };

    convert.hcg.rgb = function (hcg) {
      var h = hcg[0] / 360;
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;

      if (c === 0.0) {
        return [g * 255, g * 255, g * 255];
      }

      var pure = [0, 0, 0];
      var hi = h % 1 * 6;
      var v = hi % 1;
      var w = 1 - v;
      var mg = 0;

      switch (Math.floor(hi)) {
        case 0:
          pure[0] = 1;
          pure[1] = v;
          pure[2] = 0;
          break;

        case 1:
          pure[0] = w;
          pure[1] = 1;
          pure[2] = 0;
          break;

        case 2:
          pure[0] = 0;
          pure[1] = 1;
          pure[2] = v;
          break;

        case 3:
          pure[0] = 0;
          pure[1] = w;
          pure[2] = 1;
          break;

        case 4:
          pure[0] = v;
          pure[1] = 0;
          pure[2] = 1;
          break;

        default:
          pure[0] = 1;
          pure[1] = 0;
          pure[2] = w;
      }

      mg = (1.0 - c) * g;
      return [(c * pure[0] + mg) * 255, (c * pure[1] + mg) * 255, (c * pure[2] + mg) * 255];
    };

    convert.hcg.hsv = function (hcg) {
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      var v = c + g * (1.0 - c);
      var f = 0;

      if (v > 0.0) {
        f = c / v;
      }

      return [hcg[0], f * 100, v * 100];
    };

    convert.hcg.hsl = function (hcg) {
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      var l = g * (1.0 - c) + 0.5 * c;
      var s = 0;

      if (l > 0.0 && l < 0.5) {
        s = c / (2 * l);
      } else if (l >= 0.5 && l < 1.0) {
        s = c / (2 * (1 - l));
      }

      return [hcg[0], s * 100, l * 100];
    };

    convert.hcg.hwb = function (hcg) {
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      var v = c + g * (1.0 - c);
      return [hcg[0], (v - c) * 100, (1 - v) * 100];
    };

    convert.hwb.hcg = function (hwb) {
      var w = hwb[1] / 100;
      var b = hwb[2] / 100;
      var v = 1 - b;
      var c = v - w;
      var g = 0;

      if (c < 1) {
        g = (v - c) / (1 - c);
      }

      return [hwb[0], c * 100, g * 100];
    };

    convert.apple.rgb = function (apple) {
      return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
    };

    convert.rgb.apple = function (rgb) {
      return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
    };

    convert.gray.rgb = function (args) {
      return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
    };

    convert.gray.hsl = convert.gray.hsv = function (args) {
      return [0, 0, args[0]];
    };

    convert.gray.hwb = function (gray) {
      return [0, 100, gray[0]];
    };

    convert.gray.cmyk = function (gray) {
      return [0, 0, 0, gray[0]];
    };

    convert.gray.lab = function (gray) {
      return [gray[0], 0, 0];
    };

    convert.gray.hex = function (gray) {
      var val = Math.round(gray[0] / 100 * 255) & 0xFF;
      var integer = (val << 16) + (val << 8) + val;
      var string = integer.toString(16).toUpperCase();
      return '000000'.substring(string.length) + string;
    };

    convert.rgb.gray = function (rgb) {
      var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
      return [val / 255 * 100];
    };
  }, "/$$rollup_base$$/packages/babel-highlight/node_modules/chalk/node_modules/ansi-styles/node_modules/color-convert");

  function buildGraph() {
    var graph = {};
    var models = Object.keys(conversions);

    for (var len = models.length, i = 0; i < len; i++) {
      graph[models[i]] = {
        distance: -1,
        parent: null
      };
    }

    return graph;
  }

  function deriveBFS(fromModel) {
    var graph = buildGraph();
    var queue = [fromModel];
    graph[fromModel].distance = 0;

    while (queue.length) {
      var current = queue.pop();
      var adjacents = Object.keys(conversions[current]);

      for (var len = adjacents.length, i = 0; i < len; i++) {
        var adjacent = adjacents[i];
        var node = graph[adjacent];

        if (node.distance === -1) {
          node.distance = graph[current].distance + 1;
          node.parent = current;
          queue.unshift(adjacent);
        }
      }
    }

    return graph;
  }

  function link(from, to) {
    return function (args) {
      return to(from(args));
    };
  }

  function wrapConversion(toModel, graph) {
    var path = [graph[toModel].parent, toModel];
    var fn = conversions[graph[toModel].parent][toModel];
    var cur = graph[toModel].parent;

    while (graph[cur].parent) {
      path.unshift(graph[cur].parent);
      fn = link(conversions[graph[cur].parent][cur], fn);
      cur = graph[cur].parent;
    }

    fn.conversion = path;
    return fn;
  }

  var route = function route(fromModel) {
    var graph = deriveBFS(fromModel);
    var conversion = {};
    var models = Object.keys(graph);

    for (var len = models.length, i = 0; i < len; i++) {
      var toModel = models[i];
      var node = graph[toModel];

      if (node.parent === null) {
        continue;
      }

      conversion[toModel] = wrapConversion(toModel, graph);
    }

    return conversion;
  };

  var convert = {};
  var models = Object.keys(conversions);

  function wrapRaw(fn) {
    var wrappedFn = function wrappedFn(args) {
      if (args === undefined || args === null) {
        return args;
      }

      if (arguments.length > 1) {
        args = Array.prototype.slice.call(arguments);
      }

      return fn(args);
    };

    if ('conversion' in fn) {
      wrappedFn.conversion = fn.conversion;
    }

    return wrappedFn;
  }

  function wrapRounded(fn) {
    var wrappedFn = function wrappedFn(args) {
      if (args === undefined || args === null) {
        return args;
      }

      if (arguments.length > 1) {
        args = Array.prototype.slice.call(arguments);
      }

      var result = fn(args);

      if (typeof result === 'object') {
        for (var len = result.length, i = 0; i < len; i++) {
          result[i] = Math.round(result[i]);
        }
      }

      return result;
    };

    if ('conversion' in fn) {
      wrappedFn.conversion = fn.conversion;
    }

    return wrappedFn;
  }

  models.forEach(function (fromModel) {
    convert[fromModel] = {};
    Object.defineProperty(convert[fromModel], 'channels', {
      value: conversions[fromModel].channels
    });
    Object.defineProperty(convert[fromModel], 'labels', {
      value: conversions[fromModel].labels
    });
    var routes = route(fromModel);
    var routeModels = Object.keys(routes);
    routeModels.forEach(function (toModel) {
      var fn = routes[toModel];
      convert[fromModel][toModel] = wrapRounded(fn);
      convert[fromModel][toModel].raw = wrapRaw(fn);
    });
  });
  var colorConvert = convert;

  var ansiStyles = createCommonjsModule(function (module) {

    var wrapAnsi16 = function wrapAnsi16(fn, offset) {
      return function () {
        var code = fn.apply(colorConvert, arguments);
        return "\x1B[" + (code + offset) + "m";
      };
    };

    var wrapAnsi256 = function wrapAnsi256(fn, offset) {
      return function () {
        var code = fn.apply(colorConvert, arguments);
        return "\x1B[" + (38 + offset) + ";5;" + code + "m";
      };
    };

    var wrapAnsi16m = function wrapAnsi16m(fn, offset) {
      return function () {
        var rgb = fn.apply(colorConvert, arguments);
        return "\x1B[" + (38 + offset) + ";2;" + rgb[0] + ";" + rgb[1] + ";" + rgb[2] + "m";
      };
    };

    function assembleStyles() {
      var codes = new Map();
      var styles = {
        modifier: {
          reset: [0, 0],
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29]
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          gray: [90, 39],
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39]
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49]
        }
      };
      styles.color.grey = styles.color.gray;

      for (var _i = 0, _Object$keys = Object.keys(styles); _i < _Object$keys.length; _i++) {
        var groupName = _Object$keys[_i];
        var group = styles[groupName];

        for (var _i2 = 0, _Object$keys2 = Object.keys(group); _i2 < _Object$keys2.length; _i2++) {
          var styleName = _Object$keys2[_i2];
          var style = group[styleName];
          styles[styleName] = {
            open: "\x1B[" + style[0] + "m",
            close: "\x1B[" + style[1] + "m"
          };
          group[styleName] = styles[styleName];
          codes.set(style[0], style[1]);
        }

        Object.defineProperty(styles, groupName, {
          value: group,
          enumerable: false
        });
        Object.defineProperty(styles, 'codes', {
          value: codes,
          enumerable: false
        });
      }

      var ansi2ansi = function ansi2ansi(n) {
        return n;
      };

      var rgb2rgb = function rgb2rgb(r, g, b) {
        return [r, g, b];
      };

      styles.color.close = "\x1B[39m";
      styles.bgColor.close = "\x1B[49m";
      styles.color.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 0)
      };
      styles.color.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 0)
      };
      styles.color.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 0)
      };
      styles.bgColor.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 10)
      };
      styles.bgColor.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 10)
      };
      styles.bgColor.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 10)
      };

      for (var _i3 = 0, _Object$keys3 = Object.keys(colorConvert); _i3 < _Object$keys3.length; _i3++) {
        var key = _Object$keys3[_i3];

        if (typeof colorConvert[key] !== 'object') {
          continue;
        }

        var suite = colorConvert[key];

        if (key === 'ansi16') {
          key = 'ansi';
        }

        if ('ansi16' in suite) {
          styles.color.ansi[key] = wrapAnsi16(suite.ansi16, 0);
          styles.bgColor.ansi[key] = wrapAnsi16(suite.ansi16, 10);
        }

        if ('ansi256' in suite) {
          styles.color.ansi256[key] = wrapAnsi256(suite.ansi256, 0);
          styles.bgColor.ansi256[key] = wrapAnsi256(suite.ansi256, 10);
        }

        if ('rgb' in suite) {
          styles.color.ansi16m[key] = wrapAnsi16m(suite.rgb, 0);
          styles.bgColor.ansi16m[key] = wrapAnsi16m(suite.rgb, 10);
        }
      }

      return styles;
    }

    Object.defineProperty(module, 'exports', {
      enumerable: true,
      get: assembleStyles
    });
  }, "/$$rollup_base$$/packages/babel-highlight/node_modules/chalk/node_modules/ansi-styles");

  var browser$3 = {
    stdout: false,
    stderr: false
  };

  var TEMPLATE_REGEX = /(?:\\(u[a-f\d]{4}|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
  var STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
  var STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
  var ESCAPE_REGEX = /\\(u[a-f\d]{4}|x[a-f\d]{2}|.)|([^\\])/gi;
  var ESCAPES = new Map([['n', '\n'], ['r', '\r'], ['t', '\t'], ['b', '\b'], ['f', '\f'], ['v', '\v'], ['0', '\0'], ['\\', '\\'], ['e', "\x1B"], ['a', "\x07"]]);

  function unescape(c) {
    if (c[0] === 'u' && c.length === 5 || c[0] === 'x' && c.length === 3) {
      return String.fromCharCode(parseInt(c.slice(1), 16));
    }

    return ESCAPES.get(c) || c;
  }

  function parseArguments(name, args) {
    var results = [];
    var chunks = args.trim().split(/\s*,\s*/g);
    var matches;

    for (var _iterator = _createForOfIteratorHelperLoose(chunks), _step; !(_step = _iterator()).done;) {
      var chunk = _step.value;

      if (!isNaN(chunk)) {
        results.push(Number(chunk));
      } else if (matches = chunk.match(STRING_REGEX)) {
        results.push(matches[2].replace(ESCAPE_REGEX, function (m, escape, chr) {
          return escape ? unescape(escape) : chr;
        }));
      } else {
        throw new Error("Invalid Chalk template style argument: " + chunk + " (in style '" + name + "')");
      }
    }

    return results;
  }

  function parseStyle(style) {
    STYLE_REGEX.lastIndex = 0;
    var results = [];
    var matches;

    while ((matches = STYLE_REGEX.exec(style)) !== null) {
      var name = matches[1];

      if (matches[2]) {
        var args = parseArguments(name, matches[2]);
        results.push([name].concat(args));
      } else {
        results.push([name]);
      }
    }

    return results;
  }

  function buildStyle(chalk, styles) {
    var enabled = {};

    for (var _iterator2 = _createForOfIteratorHelperLoose(styles), _step2; !(_step2 = _iterator2()).done;) {
      var layer = _step2.value;

      for (var _iterator3 = _createForOfIteratorHelperLoose(layer.styles), _step3; !(_step3 = _iterator3()).done;) {
        var style = _step3.value;
        enabled[style[0]] = layer.inverse ? null : style.slice(1);
      }
    }

    var current = chalk;

    for (var _i = 0, _Object$keys = Object.keys(enabled); _i < _Object$keys.length; _i++) {
      var styleName = _Object$keys[_i];

      if (Array.isArray(enabled[styleName])) {
        if (!(styleName in current)) {
          throw new Error("Unknown Chalk style: " + styleName);
        }

        if (enabled[styleName].length > 0) {
          current = current[styleName].apply(current, enabled[styleName]);
        } else {
          current = current[styleName];
        }
      }
    }

    return current;
  }

  var templates = function templates(chalk, tmp) {
    var styles = [];
    var chunks = [];
    var chunk = [];
    tmp.replace(TEMPLATE_REGEX, function (m, escapeChar, inverse, style, close, chr) {
      if (escapeChar) {
        chunk.push(unescape(escapeChar));
      } else if (style) {
        var str = chunk.join('');
        chunk = [];
        chunks.push(styles.length === 0 ? str : buildStyle(chalk, styles)(str));
        styles.push({
          inverse: inverse,
          styles: parseStyle(style)
        });
      } else if (close) {
        if (styles.length === 0) {
          throw new Error('Found extraneous } in Chalk template literal');
        }

        chunks.push(buildStyle(chalk, styles)(chunk.join('')));
        chunk = [];
        styles.pop();
      } else {
        chunk.push(chr);
      }
    });
    chunks.push(chunk.join(''));

    if (styles.length > 0) {
      var errMsg = "Chalk template literal is missing " + styles.length + " closing bracket" + (styles.length === 1 ? '' : 's') + " (`}`)";
      throw new Error(errMsg);
    }

    return chunks.join('');
  };

  var chalk = createCommonjsModule(function (module) {

    var stdoutColor = browser$3.stdout;
    var isSimpleWindowsTerm = browser$6.platform === 'win32' && !(browser$6.env.TERM || '').toLowerCase().startsWith('xterm');
    var levelMapping = ['ansi', 'ansi', 'ansi256', 'ansi16m'];
    var skipModels = new Set(['gray']);
    var styles = Object.create(null);

    function applyOptions(obj, options) {
      options = options || {};
      var scLevel = 0;
      obj.level = options.level === undefined ? scLevel : options.level;
      obj.enabled = 'enabled' in options ? options.enabled : obj.level > 0;
    }

    function Chalk(options) {
      if (!this || !(this instanceof Chalk) || this.template) {
        var _chalk = {};
        applyOptions(_chalk, options);

        _chalk.template = function () {
          var args = [].slice.call(arguments);
          return chalkTag.apply(null, [_chalk.template].concat(args));
        };

        Object.setPrototypeOf(_chalk, Chalk.prototype);
        Object.setPrototypeOf(_chalk.template, _chalk);
        _chalk.template.constructor = Chalk;
        return _chalk.template;
      }

      applyOptions(this, options);
    }

    if (isSimpleWindowsTerm) {
      ansiStyles.blue.open = "\x1B[94m";
    }

    var _loop = function _loop() {
      var key = _Object$keys[_i];
      ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), 'g');
      styles[key] = {
        get: function get() {
          var codes = ansiStyles[key];
          return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, key);
        }
      };
    };

    for (var _i = 0, _Object$keys = Object.keys(ansiStyles); _i < _Object$keys.length; _i++) {
      _loop();
    }

    styles.visible = {
      get: function get() {
        return build.call(this, this._styles || [], true, 'visible');
      }
    };
    ansiStyles.color.closeRe = new RegExp(escapeStringRegexp(ansiStyles.color.close), 'g');

    var _loop2 = function _loop2() {
      var model = _Object$keys2[_i2];

      if (skipModels.has(model)) {
        return "continue";
      }

      styles[model] = {
        get: function get() {
          var level = this.level;
          return function () {
            var open = ansiStyles.color[levelMapping[level]][model].apply(null, arguments);
            var codes = {
              open: open,
              close: ansiStyles.color.close,
              closeRe: ansiStyles.color.closeRe
            };
            return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
          };
        }
      };
    };

    for (var _i2 = 0, _Object$keys2 = Object.keys(ansiStyles.color.ansi); _i2 < _Object$keys2.length; _i2++) {
      var _ret = _loop2();

      if (_ret === "continue") continue;
    }

    ansiStyles.bgColor.closeRe = new RegExp(escapeStringRegexp(ansiStyles.bgColor.close), 'g');

    var _loop3 = function _loop3() {
      var model = _Object$keys3[_i3];

      if (skipModels.has(model)) {
        return "continue";
      }

      var bgModel = 'bg' + model[0].toUpperCase() + model.slice(1);
      styles[bgModel] = {
        get: function get() {
          var level = this.level;
          return function () {
            var open = ansiStyles.bgColor[levelMapping[level]][model].apply(null, arguments);
            var codes = {
              open: open,
              close: ansiStyles.bgColor.close,
              closeRe: ansiStyles.bgColor.closeRe
            };
            return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
          };
        }
      };
    };

    for (var _i3 = 0, _Object$keys3 = Object.keys(ansiStyles.bgColor.ansi); _i3 < _Object$keys3.length; _i3++) {
      var _ret2 = _loop3();

      if (_ret2 === "continue") continue;
    }

    var proto = Object.defineProperties(function () {}, styles);

    function build(_styles, _empty, key) {
      var builder = function builder() {
        return applyStyle.apply(builder, arguments);
      };

      builder._styles = _styles;
      builder._empty = _empty;
      var self = this;
      Object.defineProperty(builder, 'level', {
        enumerable: true,
        get: function get() {
          return self.level;
        },
        set: function set(level) {
          self.level = level;
        }
      });
      Object.defineProperty(builder, 'enabled', {
        enumerable: true,
        get: function get() {
          return self.enabled;
        },
        set: function set(enabled) {
          self.enabled = enabled;
        }
      });
      builder.hasGrey = this.hasGrey || key === 'gray' || key === 'grey';
      builder.__proto__ = proto;
      return builder;
    }

    function applyStyle() {
      var args = arguments;
      var argsLen = args.length;
      var str = String(arguments[0]);

      if (argsLen === 0) {
        return '';
      }

      if (argsLen > 1) {
        for (var a = 1; a < argsLen; a++) {
          str += ' ' + args[a];
        }
      }

      if (!this.enabled || this.level <= 0 || !str) {
        return this._empty ? '' : str;
      }

      var originalDim = ansiStyles.dim.open;

      if (isSimpleWindowsTerm && this.hasGrey) {
        ansiStyles.dim.open = '';
      }

      for (var _iterator = _createForOfIteratorHelperLoose(this._styles.slice().reverse()), _step; !(_step = _iterator()).done;) {
        var code = _step.value;
        str = code.open + str.replace(code.closeRe, code.open) + code.close;
        str = str.replace(/\r?\n/g, code.close + "$&" + code.open);
      }

      ansiStyles.dim.open = originalDim;
      return str;
    }

    function chalkTag(chalk, strings) {
      if (!Array.isArray(strings)) {
        return [].slice.call(arguments, 1).join(' ');
      }

      var args = [].slice.call(arguments, 2);
      var parts = [strings.raw[0]];

      for (var i = 1; i < strings.length; i++) {
        parts.push(String(args[i - 1]).replace(/[{}\\]/g, '\\$&'));
        parts.push(String(strings.raw[i]));
      }

      return templates(chalk, parts.join(''));
    }

    Object.defineProperties(Chalk.prototype, styles);
    module.exports = Chalk();
    module.exports.supportsColor = stdoutColor;
    module.exports["default"] = module.exports;
  }, "/$$rollup_base$$/packages/babel-highlight/node_modules/chalk");

  var sometimesKeywords = new Set(["as", "async", "from", "get", "of", "set"]);

  function getDefs$1(chalk) {
    return {
      keyword: chalk.cyan,
      capitalized: chalk.yellow,
      jsxIdentifier: chalk.yellow,
      punctuator: chalk.yellow,
      number: chalk.magenta,
      string: chalk.green,
      regex: chalk.magenta,
      comment: chalk.grey,
      invalid: chalk.white.bgRed.bold
    };
  }

  var NEWLINE$1 = /\r\n|[\n\r\u2028\u2029]/;
  var BRACKET = /^[()[\]{}]$/;
  var tokenize;
  {
    var JSX_TAG = /^[a-z][\w-]*$/i;

    var getTokenType = function getTokenType(token, offset, text) {
      if (token.type === "name") {
        if (isKeyword(token.value) || isStrictReservedWord(token.value, true) || sometimesKeywords.has(token.value)) {
          return "keyword";
        }

        if (JSX_TAG.test(token.value) && (text[offset - 1] === "<" || text.substr(offset - 2, 2) == "</")) {
          return "jsxIdentifier";
        }

        if (token.value[0] !== token.value[0].toLowerCase()) {
          return "capitalized";
        }
      }

      if (token.type === "punctuator" && BRACKET.test(token.value)) {
        return "bracket";
      }

      if (token.type === "invalid" && (token.value === "@" || token.value === "#")) {
        return "punctuator";
      }

      return token.type;
    };

    tokenize = regenerator.mark(function tokenize(text) {
      var match, token;
      return regenerator.wrap(function tokenize$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (!(match = jsTokens["default"].exec(text))) {
                _context.next = 6;
                break;
              }

              token = jsTokens.matchToToken(match);
              _context.next = 4;
              return {
                type: getTokenType(token, match.index, text),
                value: token.value
              };

            case 4:
              _context.next = 0;
              break;

            case 6:
            case "end":
              return _context.stop();
          }
        }
      }, tokenize);
    });
  }

  function highlightTokens(defs, text) {
    var highlighted = "";

    var _loop = function _loop() {
      var _step$value = _step.value,
          type = _step$value.type,
          value = _step$value.value;
      var colorize = defs[type];

      if (colorize) {
        highlighted += value.split(NEWLINE$1).map(function (str) {
          return colorize(str);
        }).join("\n");
      } else {
        highlighted += value;
      }
    };

    for (var _iterator = _createForOfIteratorHelperLoose(tokenize(text)), _step; !(_step = _iterator()).done;) {
      _loop();
    }

    return highlighted;
  }

  function shouldHighlight(options) {
    return !!chalk.supportsColor || options.forceColor;
  }
  function getChalk(options) {
    return options.forceColor ? new chalk.constructor({
      enabled: true,
      level: 1
    }) : chalk;
  }
  function highlight(code, options) {
    if (options === void 0) {
      options = {};
    }

    if (shouldHighlight(options)) {
      var chalk = getChalk(options);
      var defs = getDefs$1(chalk);
      return highlightTokens(defs, code);
    } else {
      return code;
    }
  }

  function getDefs(chalk) {
    return {
      gutter: chalk.grey,
      marker: chalk.red.bold,
      message: chalk.red.bold
    };
  }

  var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;

  function getMarkerLines(loc, source, opts) {
    var startLoc = Object.assign({
      column: 0,
      line: -1
    }, loc.start);
    var endLoc = Object.assign({}, startLoc, loc.end);

    var _ref = opts || {},
        _ref$linesAbove = _ref.linesAbove,
        linesAbove = _ref$linesAbove === void 0 ? 2 : _ref$linesAbove,
        _ref$linesBelow = _ref.linesBelow,
        linesBelow = _ref$linesBelow === void 0 ? 3 : _ref$linesBelow;

    var startLine = startLoc.line;
    var startColumn = startLoc.column;
    var endLine = endLoc.line;
    var endColumn = endLoc.column;
    var start = Math.max(startLine - (linesAbove + 1), 0);
    var end = Math.min(source.length, endLine + linesBelow);

    if (startLine === -1) {
      start = 0;
    }

    if (endLine === -1) {
      end = source.length;
    }

    var lineDiff = endLine - startLine;
    var markerLines = {};

    if (lineDiff) {
      for (var i = 0; i <= lineDiff; i++) {
        var lineNumber = i + startLine;

        if (!startColumn) {
          markerLines[lineNumber] = true;
        } else if (i === 0) {
          var sourceLength = source[lineNumber - 1].length;
          markerLines[lineNumber] = [startColumn, sourceLength - startColumn + 1];
        } else if (i === lineDiff) {
          markerLines[lineNumber] = [0, endColumn];
        } else {
          var _sourceLength = source[lineNumber - i].length;
          markerLines[lineNumber] = [0, _sourceLength];
        }
      }
    } else {
      if (startColumn === endColumn) {
        if (startColumn) {
          markerLines[startLine] = [startColumn, 0];
        } else {
          markerLines[startLine] = true;
        }
      } else {
        markerLines[startLine] = [startColumn, endColumn - startColumn];
      }
    }

    return {
      start: start,
      end: end,
      markerLines: markerLines
    };
  }

  function codeFrameColumns(rawLines, loc, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var highlighted = (opts.highlightCode || opts.forceColor) && shouldHighlight(opts);
    var chalk = getChalk(opts);
    var defs = getDefs(chalk);

    var maybeHighlight = function maybeHighlight(chalkFn, string) {
      return highlighted ? chalkFn(string) : string;
    };

    var lines = rawLines.split(NEWLINE);

    var _getMarkerLines = getMarkerLines(loc, lines, opts),
        start = _getMarkerLines.start,
        end = _getMarkerLines.end,
        markerLines = _getMarkerLines.markerLines;

    var hasColumns = loc.start && typeof loc.start.column === "number";
    var numberMaxWidth = String(end).length;
    var highlightedLines = highlighted ? highlight(rawLines, opts) : rawLines;
    var frame = highlightedLines.split(NEWLINE).slice(start, end).map(function (line, index) {
      var number = start + 1 + index;
      var paddedNumber = (" " + number).slice(-numberMaxWidth);
      var gutter = " " + paddedNumber + " |";
      var hasMarker = markerLines[number];
      var lastMarkerLine = !markerLines[number + 1];

      if (hasMarker) {
        var markerLine = "";

        if (Array.isArray(hasMarker)) {
          var markerSpacing = line.slice(0, Math.max(hasMarker[0] - 1, 0)).replace(/[^\t]/g, " ");
          var numberOfMarkers = hasMarker[1] || 1;
          markerLine = ["\n ", maybeHighlight(defs.gutter, gutter.replace(/\d/g, " ")), " ", markerSpacing, maybeHighlight(defs.marker, "^").repeat(numberOfMarkers)].join("");

          if (lastMarkerLine && opts.message) {
            markerLine += " " + maybeHighlight(defs.message, opts.message);
          }
        }

        return [maybeHighlight(defs.marker, ">"), maybeHighlight(defs.gutter, gutter), line.length > 0 ? " " + line : "", markerLine].join("");
      } else {
        return " " + maybeHighlight(defs.gutter, gutter) + (line.length > 0 ? " " + line : "");
      }
    }).join("\n");

    if (opts.message && !hasColumns) {
      frame = "" + " ".repeat(numberMaxWidth + 1) + opts.message + "\n" + frame;
    }

    if (highlighted) {
      return chalk.reset(frame);
    } else {
      return frame;
    }
  }

  var beforeExpr = true;
  var startsExpr = true;
  var isLoop = true;
  var isAssign = true;
  var prefix = true;
  var postfix = true;
  var TokenType = function TokenType(label, conf) {
    if (conf === void 0) {
      conf = {};
    }

    this.label = void 0;
    this.keyword = void 0;
    this.beforeExpr = void 0;
    this.startsExpr = void 0;
    this.rightAssociative = void 0;
    this.isLoop = void 0;
    this.isAssign = void 0;
    this.prefix = void 0;
    this.postfix = void 0;
    this.binop = void 0;
    this.updateContext = void 0;
    this.label = label;
    this.keyword = conf.keyword;
    this.beforeExpr = !!conf.beforeExpr;
    this.startsExpr = !!conf.startsExpr;
    this.rightAssociative = !!conf.rightAssociative;
    this.isLoop = !!conf.isLoop;
    this.isAssign = !!conf.isAssign;
    this.prefix = !!conf.prefix;
    this.postfix = !!conf.postfix;
    this.binop = conf.binop != null ? conf.binop : null;
    this.updateContext = null;
  };
  var keywords = new Map();

  function createKeyword(name, options) {
    if (options === void 0) {
      options = {};
    }

    options.keyword = name;
    var token = new TokenType(name, options);
    keywords.set(name, token);
    return token;
  }

  function createBinop(name, binop) {
    return new TokenType(name, {
      beforeExpr: beforeExpr,
      binop: binop
    });
  }

  var types$1 = {
    num: new TokenType("num", {
      startsExpr: startsExpr
    }),
    bigint: new TokenType("bigint", {
      startsExpr: startsExpr
    }),
    decimal: new TokenType("decimal", {
      startsExpr: startsExpr
    }),
    regexp: new TokenType("regexp", {
      startsExpr: startsExpr
    }),
    string: new TokenType("string", {
      startsExpr: startsExpr
    }),
    name: new TokenType("name", {
      startsExpr: startsExpr
    }),
    privateName: new TokenType("#name", {
      startsExpr: startsExpr
    }),
    eof: new TokenType("eof"),
    bracketL: new TokenType("[", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr
    }),
    bracketHashL: new TokenType("#[", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr
    }),
    bracketBarL: new TokenType("[|", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr
    }),
    bracketR: new TokenType("]"),
    bracketBarR: new TokenType("|]"),
    braceL: new TokenType("{", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr
    }),
    braceBarL: new TokenType("{|", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr
    }),
    braceHashL: new TokenType("#{", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr
    }),
    braceR: new TokenType("}", {
      beforeExpr: beforeExpr
    }),
    braceBarR: new TokenType("|}"),
    parenL: new TokenType("(", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr
    }),
    parenR: new TokenType(")"),
    comma: new TokenType(",", {
      beforeExpr: beforeExpr
    }),
    semi: new TokenType(";", {
      beforeExpr: beforeExpr
    }),
    colon: new TokenType(":", {
      beforeExpr: beforeExpr
    }),
    doubleColon: new TokenType("::", {
      beforeExpr: beforeExpr
    }),
    dot: new TokenType("."),
    question: new TokenType("?", {
      beforeExpr: beforeExpr
    }),
    questionDot: new TokenType("?."),
    arrow: new TokenType("=>", {
      beforeExpr: beforeExpr
    }),
    template: new TokenType("template"),
    ellipsis: new TokenType("...", {
      beforeExpr: beforeExpr
    }),
    backQuote: new TokenType("`", {
      startsExpr: startsExpr
    }),
    dollarBraceL: new TokenType("${", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr
    }),
    at: new TokenType("@"),
    hash: new TokenType("#", {
      startsExpr: startsExpr
    }),
    interpreterDirective: new TokenType("#!..."),
    eq: new TokenType("=", {
      beforeExpr: beforeExpr,
      isAssign: isAssign
    }),
    assign: new TokenType("_=", {
      beforeExpr: beforeExpr,
      isAssign: isAssign
    }),
    slashAssign: new TokenType("_=", {
      beforeExpr: beforeExpr,
      isAssign: isAssign
    }),
    moduloAssign: new TokenType("_=", {
      beforeExpr: beforeExpr,
      isAssign: isAssign
    }),
    incDec: new TokenType("++/--", {
      prefix: prefix,
      postfix: postfix,
      startsExpr: startsExpr
    }),
    bang: new TokenType("!", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr
    }),
    tilde: new TokenType("~", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr
    }),
    pipeline: createBinop("|>", 0),
    nullishCoalescing: createBinop("??", 1),
    logicalOR: createBinop("||", 1),
    logicalAND: createBinop("&&", 2),
    bitwiseOR: createBinop("|", 3),
    bitwiseXOR: createBinop("^", 4),
    bitwiseAND: createBinop("&", 5),
    equality: createBinop("==/!=/===/!==", 6),
    relational: createBinop("</>/<=/>=", 7),
    bitShift: createBinop("<</>>/>>>", 8),
    plusMin: new TokenType("+/-", {
      beforeExpr: beforeExpr,
      binop: 9,
      prefix: prefix,
      startsExpr: startsExpr
    }),
    modulo: new TokenType("%", {
      binop: 10,
      startsExpr: startsExpr
    }),
    star: new TokenType("*", {
      binop: 10
    }),
    slash: createBinop("/", 10),
    exponent: new TokenType("**", {
      beforeExpr: beforeExpr,
      binop: 11,
      rightAssociative: true
    }),
    _break: createKeyword("break"),
    _case: createKeyword("case", {
      beforeExpr: beforeExpr
    }),
    _catch: createKeyword("catch"),
    _continue: createKeyword("continue"),
    _debugger: createKeyword("debugger"),
    _default: createKeyword("default", {
      beforeExpr: beforeExpr
    }),
    _do: createKeyword("do", {
      isLoop: isLoop,
      beforeExpr: beforeExpr
    }),
    _else: createKeyword("else", {
      beforeExpr: beforeExpr
    }),
    _finally: createKeyword("finally"),
    _for: createKeyword("for", {
      isLoop: isLoop
    }),
    _function: createKeyword("function", {
      startsExpr: startsExpr
    }),
    _if: createKeyword("if"),
    _return: createKeyword("return", {
      beforeExpr: beforeExpr
    }),
    _switch: createKeyword("switch"),
    _throw: createKeyword("throw", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr
    }),
    _try: createKeyword("try"),
    _var: createKeyword("var"),
    _const: createKeyword("const"),
    _while: createKeyword("while", {
      isLoop: isLoop
    }),
    _with: createKeyword("with"),
    _new: createKeyword("new", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr
    }),
    _this: createKeyword("this", {
      startsExpr: startsExpr
    }),
    _super: createKeyword("super", {
      startsExpr: startsExpr
    }),
    _class: createKeyword("class", {
      startsExpr: startsExpr
    }),
    _extends: createKeyword("extends", {
      beforeExpr: beforeExpr
    }),
    _export: createKeyword("export"),
    _import: createKeyword("import", {
      startsExpr: startsExpr
    }),
    _null: createKeyword("null", {
      startsExpr: startsExpr
    }),
    _true: createKeyword("true", {
      startsExpr: startsExpr
    }),
    _false: createKeyword("false", {
      startsExpr: startsExpr
    }),
    _in: createKeyword("in", {
      beforeExpr: beforeExpr,
      binop: 7
    }),
    _instanceof: createKeyword("instanceof", {
      beforeExpr: beforeExpr,
      binop: 7
    }),
    _typeof: createKeyword("typeof", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr
    }),
    _void: createKeyword("void", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr
    }),
    _delete: createKeyword("delete", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr
    })
  };

  var lineBreak = /\r\n?|[\n\u2028\u2029]/;
  var lineBreakG = new RegExp(lineBreak.source, "g");
  function isNewLine(code) {
    switch (code) {
      case 10:
      case 13:
      case 8232:
      case 8233:
        return true;

      default:
        return false;
    }
  }
  var skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;
  var skipWhiteSpaceInLine = new RegExp("(?:[^\\S\\n\\r\\u2028\\u2029]|\\/\\/.*|\\/\\*.*?\\*\\/)*", "y");
  var skipWhiteSpaceToLineBreak = new RegExp("(?=(" + skipWhiteSpaceInLine.source + "))\\1" + /(?=[\n\r\u2028\u2029]|\/\*(?!.*?\*\/)|$)/.source, "y");
  function isWhitespace(code) {
    switch (code) {
      case 0x0009:
      case 0x000b:
      case 0x000c:
      case 32:
      case 160:
      case 5760:
      case 0x2000:
      case 0x2001:
      case 0x2002:
      case 0x2003:
      case 0x2004:
      case 0x2005:
      case 0x2006:
      case 0x2007:
      case 0x2008:
      case 0x2009:
      case 0x200a:
      case 0x202f:
      case 0x205f:
      case 0x3000:
      case 0xfeff:
        return true;

      default:
        return false;
    }
  }

  var Position = function Position(line, col) {
    this.line = void 0;
    this.column = void 0;
    this.line = line;
    this.column = col;
  };
  var SourceLocation = function SourceLocation(start, end) {
    this.start = void 0;
    this.end = void 0;
    this.filename = void 0;
    this.identifierName = void 0;
    this.start = start;
    this.end = end;
  };
  function getLineInfo(input, offset) {
    var line = 1;
    var lineStart = 0;
    var match;
    lineBreakG.lastIndex = 0;

    while ((match = lineBreakG.exec(input)) && match.index < offset) {
      line++;
      lineStart = lineBreakG.lastIndex;
    }

    return new Position(line, offset - lineStart);
  }

  var BaseParser = function () {
    function BaseParser() {
      this.sawUnambiguousESM = false;
      this.ambiguousScriptDifferentAst = false;
    }

    var _proto = BaseParser.prototype;

    _proto.hasPlugin = function hasPlugin(name) {
      return this.plugins.has(name);
    };

    _proto.getPluginOption = function getPluginOption(plugin, name) {
      if (this.hasPlugin(plugin)) return this.plugins.get(plugin)[name];
    };

    return BaseParser;
  }();

  function setTrailingComments(node, comments) {
    if (node.trailingComments === undefined) {
      node.trailingComments = comments;
    } else {
      var _node$trailingComment;

      (_node$trailingComment = node.trailingComments).unshift.apply(_node$trailingComment, comments);
    }
  }

  function setInnerComments(node, comments) {
    if (node.innerComments === undefined) {
      node.innerComments = comments;
    } else if (comments !== undefined) {
      var _node$innerComments;

      (_node$innerComments = node.innerComments).unshift.apply(_node$innerComments, comments);
    }
  }

  function adjustInnerComments(node, elements, commentWS) {
    var lastElement = null;
    var i = elements.length;

    while (lastElement === null && i > 0) {
      lastElement = elements[--i];
    }

    if (lastElement === null || lastElement.start > commentWS.start) {
      setInnerComments(node, commentWS.comments);
    } else {
      setTrailingComments(lastElement, commentWS.comments);
    }
  }

  var CommentsParser = function (_BaseParser) {
    _inherits(CommentsParser, _BaseParser);

    function CommentsParser() {
      return _BaseParser.apply(this, arguments) || this;
    }

    var _proto = CommentsParser.prototype;

    _proto.addComment = function addComment(comment) {
      if (this.filename) comment.loc.filename = this.filename;
      this.state.comments.push(comment);
    };

    _proto.processComment = function processComment(node) {
      var commentStack = this.state.commentStack;
      var commentStackLength = commentStack.length;
      if (commentStackLength === 0) return;
      var i = commentStackLength - 1;
      var lastCommentWS = commentStack[i];

      if (lastCommentWS.start === node.end) {
        lastCommentWS.leadingNode = node;
        i--;
      }

      var nodeStart = node.start;

      for (; i >= 0; i--) {
        var commentWS = commentStack[i];
        var commentEnd = commentWS.end;

        if (commentEnd > nodeStart) {
          commentWS.containingNode = node;
          this.finalizeComment(commentWS);
          commentStack.splice(i, 1);
        } else {
          if (commentEnd === nodeStart) {
            commentWS.trailingNode = node;
          }

          break;
        }
      }
    };

    _proto.finalizeComment = function finalizeComment(commentWS) {
      var comments = commentWS.comments;

      if (commentWS.leadingNode !== null || commentWS.trailingNode !== null) {
        if (commentWS.leadingNode !== null) {
          setTrailingComments(commentWS.leadingNode, comments);
        }

        if (commentWS.trailingNode !== null) {
          commentWS.trailingNode.leadingComments = comments;
        }
      } else {
        var node = commentWS.containingNode,
            commentStart = commentWS.start;

        if (this.input.charCodeAt(commentStart - 1) === 44) {
          switch (node.type) {
            case "ObjectExpression":
            case "ObjectPattern":
            case "RecordExpression":
              adjustInnerComments(node, node.properties, commentWS);
              break;

            case "CallExpression":
            case "OptionalCallExpression":
              adjustInnerComments(node, node.arguments, commentWS);
              break;

            case "FunctionDeclaration":
            case "FunctionExpression":
            case "ArrowFunctionExpression":
            case "ObjectMethod":
            case "ClassMethod":
            case "ClassPrivateMethod":
              adjustInnerComments(node, node.params, commentWS);
              break;

            case "ArrayExpression":
            case "ArrayPattern":
            case "TupleExpression":
              adjustInnerComments(node, node.elements, commentWS);
              break;

            case "ExportNamedDeclaration":
            case "ImportDeclaration":
              adjustInnerComments(node, node.specifiers, commentWS);
              break;

            default:
              {
                setInnerComments(node, comments);
              }
          }
        } else {
          setInnerComments(node, comments);
        }
      }
    };

    _proto.finalizeRemainingComments = function finalizeRemainingComments() {
      var commentStack = this.state.commentStack;

      for (var i = commentStack.length - 1; i >= 0; i--) {
        this.finalizeComment(commentStack[i]);
      }

      this.state.commentStack = [];
    };

    _proto.resetPreviousNodeTrailingComments = function resetPreviousNodeTrailingComments(node) {
      var commentStack = this.state.commentStack;
      var length = commentStack.length;
      if (length === 0) return;
      var commentWS = commentStack[length - 1];

      if (commentWS.leadingNode === node) {
        commentWS.leadingNode = null;
      }
    };

    return CommentsParser;
  }(BaseParser);

  var ErrorCodes = Object.freeze({
    SyntaxError: "BABEL_PARSER_SYNTAX_ERROR",
    SourceTypeModuleError: "BABEL_PARSER_SOURCETYPE_MODULE_REQUIRED"
  });

  var ErrorMessages = makeErrorTemplates({
    AccessorIsGenerator: "A %0ter cannot be a generator.",
    ArgumentsInClass: "'arguments' is only allowed in functions and class methods.",
    AsyncFunctionInSingleStatementContext: "Async functions can only be declared at the top level or inside a block.",
    AwaitBindingIdentifier: "Can not use 'await' as identifier inside an async function.",
    AwaitBindingIdentifierInStaticBlock: "Can not use 'await' as identifier inside a static block.",
    AwaitExpressionFormalParameter: "'await' is not allowed in async function parameters.",
    AwaitNotInAsyncContext: "'await' is only allowed within async functions and at the top levels of modules.",
    AwaitNotInAsyncFunction: "'await' is only allowed within async functions.",
    BadGetterArity: "A 'get' accesor must not have any formal parameters.",
    BadSetterArity: "A 'set' accesor must have exactly one formal parameter.",
    BadSetterRestParameter: "A 'set' accesor function argument must not be a rest parameter.",
    ConstructorClassField: "Classes may not have a field named 'constructor'.",
    ConstructorClassPrivateField: "Classes may not have a private field named '#constructor'.",
    ConstructorIsAccessor: "Class constructor may not be an accessor.",
    ConstructorIsAsync: "Constructor can't be an async function.",
    ConstructorIsGenerator: "Constructor can't be a generator.",
    DeclarationMissingInitializer: "'%0' require an initialization value.",
    DecoratorBeforeExport: "Decorators must be placed *before* the 'export' keyword. You can set the 'decoratorsBeforeExport' option to false to use the 'export @decorator class {}' syntax.",
    DecoratorConstructor: "Decorators can't be used with a constructor. Did you mean '@dec class { ... }'?",
    DecoratorExportClass: "Using the export keyword between a decorator and a class is not allowed. Please use `export @dec class` instead.",
    DecoratorSemicolon: "Decorators must not be followed by a semicolon.",
    DecoratorStaticBlock: "Decorators can't be used with a static block.",
    DeletePrivateField: "Deleting a private field is not allowed.",
    DestructureNamedImport: "ES2015 named imports do not destructure. Use another statement for destructuring after the import.",
    DuplicateConstructor: "Duplicate constructor in the same class.",
    DuplicateDefaultExport: "Only one default export allowed per module.",
    DuplicateExport: "`%0` has already been exported. Exported identifiers must be unique.",
    DuplicateProto: "Redefinition of __proto__ property.",
    DuplicateRegExpFlags: "Duplicate regular expression flag.",
    ElementAfterRest: "Rest element must be last element.",
    EscapedCharNotAnIdentifier: "Invalid Unicode escape.",
    ExportBindingIsString: "A string literal cannot be used as an exported binding without `from`.\n- Did you mean `export { '%0' as '%1' } from 'some-module'`?",
    ExportDefaultFromAsIdentifier: "'from' is not allowed as an identifier after 'export default'.",
    ForInOfLoopInitializer: "'%0' loop variable declaration may not have an initializer.",
    ForOfAsync: "The left-hand side of a for-of loop may not be 'async'.",
    ForOfLet: "The left-hand side of a for-of loop may not start with 'let'.",
    GeneratorInSingleStatementContext: "Generators can only be declared at the top level or inside a block.",
    IllegalBreakContinue: "Unsyntactic %0.",
    IllegalLanguageModeDirective: "Illegal 'use strict' directive in function with non-simple parameter list.",
    IllegalReturn: "'return' outside of function.",
    ImportBindingIsString: 'A string literal cannot be used as an imported binding.\n- Did you mean `import { "%0" as foo }`?',
    ImportCallArgumentTrailingComma: "Trailing comma is disallowed inside import(...) arguments.",
    ImportCallArity: "`import()` requires exactly %0.",
    ImportCallNotNewExpression: "Cannot use new with import(...).",
    ImportCallSpreadArgument: "`...` is not allowed in `import()`.",
    InvalidBigIntLiteral: "Invalid BigIntLiteral.",
    InvalidCodePoint: "Code point out of bounds.",
    InvalidDecimal: "Invalid decimal.",
    InvalidDigit: "Expected number in radix %0.",
    InvalidEscapeSequence: "Bad character escape sequence.",
    InvalidEscapeSequenceTemplate: "Invalid escape sequence in template.",
    InvalidEscapedReservedWord: "Escape sequence in keyword %0.",
    InvalidIdentifier: "Invalid identifier %0.",
    InvalidLhs: "Invalid left-hand side in %0.",
    InvalidLhsBinding: "Binding invalid left-hand side in %0.",
    InvalidNumber: "Invalid number.",
    InvalidOrMissingExponent: "Floating-point numbers require a valid exponent after the 'e'.",
    InvalidOrUnexpectedToken: "Unexpected character '%0'.",
    InvalidParenthesizedAssignment: "Invalid parenthesized assignment pattern.",
    InvalidPrivateFieldResolution: "Private name #%0 is not defined.",
    InvalidPropertyBindingPattern: "Binding member expression.",
    InvalidRecordProperty: "Only properties and spread elements are allowed in record definitions.",
    InvalidRestAssignmentPattern: "Invalid rest operator's argument.",
    LabelRedeclaration: "Label '%0' is already declared.",
    LetInLexicalBinding: "'let' is not allowed to be used as a name in 'let' or 'const' declarations.",
    LineTerminatorBeforeArrow: "No line break is allowed before '=>'.",
    MalformedRegExpFlags: "Invalid regular expression flag.",
    MissingClassName: "A class name is required.",
    MissingEqInAssignment: "Only '=' operator can be used for specifying default value.",
    MissingSemicolon: "Missing semicolon.",
    MissingUnicodeEscape: "Expecting Unicode escape sequence \\uXXXX.",
    MixingCoalesceWithLogical: "Nullish coalescing operator(??) requires parens when mixing with logical operators.",
    ModuleAttributeDifferentFromType: "The only accepted module attribute is `type`.",
    ModuleAttributeInvalidValue: "Only string literals are allowed as module attribute values.",
    ModuleAttributesWithDuplicateKeys: 'Duplicate key "%0" is not allowed in module attributes.',
    ModuleExportNameHasLoneSurrogate: "An export name cannot include a lone surrogate, found '\\u%0'.",
    ModuleExportUndefined: "Export '%0' is not defined.",
    MultipleDefaultsInSwitch: "Multiple default clauses.",
    NewlineAfterThrow: "Illegal newline after throw.",
    NoCatchOrFinally: "Missing catch or finally clause.",
    NumberIdentifier: "Identifier directly after number.",
    NumericSeparatorInEscapeSequence: "Numeric separators are not allowed inside unicode escape sequences or hex escape sequences.",
    ObsoleteAwaitStar: "'await*' has been removed from the async functions proposal. Use Promise.all() instead.",
    OptionalChainingNoNew: "Constructors in/after an Optional Chain are not allowed.",
    OptionalChainingNoTemplate: "Tagged Template Literals are not allowed in optionalChain.",
    OverrideOnConstructor: "'override' modifier cannot appear on a constructor declaration.",
    ParamDupe: "Argument name clash.",
    PatternHasAccessor: "Object pattern can't contain getter or setter.",
    PatternHasMethod: "Object pattern can't contain methods.",
    PipeBodyIsTighter: "Unexpected %0 after pipeline body; any %0 expression acting as Hack-style pipe body must be parenthesized due to its loose operator precedence.",
    PipeTopicRequiresHackPipes: 'Topic reference is used, but the pipelineOperator plugin was not passed a "proposal": "hack" or "smart" option.',
    PipeTopicUnbound: "Topic reference is unbound; it must be inside a pipe body.",
    PipeTopicUnconfiguredToken: 'Invalid topic token %0. In order to use %0 as a topic reference, the pipelineOperator plugin must be configured with { "proposal": "hack", "topicToken": "%0" }.',
    PipeTopicUnused: "Hack-style pipe body does not contain a topic reference; Hack-style pipes must use topic at least once.",
    PipeUnparenthesizedBody: "Hack-style pipe body cannot be an unparenthesized %0 expression; please wrap it in parentheses.",
    PipelineBodyNoArrow: 'Unexpected arrow "=>" after pipeline body; arrow function in pipeline body must be parenthesized.',
    PipelineBodySequenceExpression: "Pipeline body may not be a comma-separated sequence expression.",
    PipelineHeadSequenceExpression: "Pipeline head should not be a comma-separated sequence expression.",
    PipelineTopicUnused: "Pipeline is in topic style but does not use topic reference.",
    PrimaryTopicNotAllowed: "Topic reference was used in a lexical context without topic binding.",
    PrimaryTopicRequiresSmartPipeline: 'Topic reference is used, but the pipelineOperator plugin was not passed a "proposal": "hack" or "smart" option.',
    PrivateInExpectedIn: "Private names are only allowed in property accesses (`obj.#%0`) or in `in` expressions (`#%0 in obj`).",
    PrivateNameRedeclaration: "Duplicate private name #%0.",
    RecordExpressionBarIncorrectEndSyntaxType: "Record expressions ending with '|}' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
    RecordExpressionBarIncorrectStartSyntaxType: "Record expressions starting with '{|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
    RecordExpressionHashIncorrectStartSyntaxType: "Record expressions starting with '#{' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.",
    RecordNoProto: "'__proto__' is not allowed in Record expressions.",
    RestTrailingComma: "Unexpected trailing comma after rest element.",
    SloppyFunction: "In non-strict mode code, functions can only be declared at top level, inside a block, or as the body of an if statement.",
    StaticPrototype: "Classes may not have static property named prototype.",
    StrictDelete: "Deleting local variable in strict mode.",
    StrictEvalArguments: "Assigning to '%0' in strict mode.",
    StrictEvalArgumentsBinding: "Binding '%0' in strict mode.",
    StrictFunction: "In strict mode code, functions can only be declared at top level or inside a block.",
    StrictNumericEscape: "The only valid numeric escape in strict mode is '\\0'.",
    StrictOctalLiteral: "Legacy octal literals are not allowed in strict mode.",
    StrictWith: "'with' in strict mode.",
    SuperNotAllowed: "`super()` is only valid inside a class constructor of a subclass. Maybe a typo in the method name ('constructor') or not extending another class?",
    SuperPrivateField: "Private fields can't be accessed on super.",
    TrailingDecorator: "Decorators must be attached to a class element.",
    TupleExpressionBarIncorrectEndSyntaxType: "Tuple expressions ending with '|]' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
    TupleExpressionBarIncorrectStartSyntaxType: "Tuple expressions starting with '[|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
    TupleExpressionHashIncorrectStartSyntaxType: "Tuple expressions starting with '#[' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.",
    UnexpectedArgumentPlaceholder: "Unexpected argument placeholder.",
    UnexpectedAwaitAfterPipelineBody: 'Unexpected "await" after pipeline body; await must have parentheses in minimal proposal.',
    UnexpectedDigitAfterHash: "Unexpected digit after hash token.",
    UnexpectedImportExport: "'import' and 'export' may only appear at the top level.",
    UnexpectedKeyword: "Unexpected keyword '%0'.",
    UnexpectedLeadingDecorator: "Leading decorators must be attached to a class declaration.",
    UnexpectedLexicalDeclaration: "Lexical declaration cannot appear in a single-statement context.",
    UnexpectedNewTarget: "`new.target` can only be used in functions or class properties.",
    UnexpectedNumericSeparator: "A numeric separator is only allowed between two digits.",
    UnexpectedPrivateField: "Private names can only be used as the name of a class element (i.e. class C { #p = 42; #m() {} } )\n or a property of member expression (i.e. this.#p).",
    UnexpectedReservedWord: "Unexpected reserved word '%0'.",
    UnexpectedSuper: "'super' is only allowed in object methods and classes.",
    UnexpectedToken: "Unexpected token '%0'.",
    UnexpectedTokenUnaryExponentiation: "Illegal expression. Wrap left hand side or entire exponentiation in parentheses.",
    UnsupportedBind: "Binding should be performed on object property.",
    UnsupportedDecoratorExport: "A decorated export must export a class declaration.",
    UnsupportedDefaultExport: "Only expressions, functions or classes are allowed as the `default` export.",
    UnsupportedImport: "`import` can only be used in `import()` or `import.meta`.",
    UnsupportedMetaProperty: "The only valid meta property for %0 is %0.%1.",
    UnsupportedParameterDecorator: "Decorators cannot be used to decorate parameters.",
    UnsupportedPropertyDecorator: "Decorators cannot be used to decorate object literal properties.",
    UnsupportedSuper: "'super' can only be used with function calls (i.e. super()) or in property accesses (i.e. super.prop or super[prop]).",
    UnterminatedComment: "Unterminated comment.",
    UnterminatedRegExp: "Unterminated regular expression.",
    UnterminatedString: "Unterminated string constant.",
    UnterminatedTemplate: "Unterminated template.",
    VarRedeclaration: "Identifier '%0' has already been declared.",
    YieldBindingIdentifier: "Can not use 'yield' as identifier inside a generator.",
    YieldInParameter: "Yield expression is not allowed in formal parameters.",
    ZeroDigitNumericSeparator: "Numeric separator can not be used after leading 0."
  }, ErrorCodes.SyntaxError);
  var SourceTypeModuleErrorMessages = makeErrorTemplates({
    ImportMetaOutsideModule: "import.meta may appear only with 'sourceType: \"module\"'",
    ImportOutsideModule: "'import' and 'export' may appear only with 'sourceType: \"module\"'"
  }, ErrorCodes.SourceTypeModuleError);

  function keepReasonCodeCompat(reasonCode, syntaxPlugin) {
    {
      if (syntaxPlugin === "flow" && reasonCode === "PatternIsOptional") {
        return "OptionalBindingPattern";
      }
    }
    return reasonCode;
  }

  function makeErrorTemplates(messages, code, syntaxPlugin) {
    var templates = {};
    Object.keys(messages).forEach(function (reasonCode) {
      templates[reasonCode] = Object.freeze({
        code: code,
        reasonCode: keepReasonCodeCompat(reasonCode, syntaxPlugin),
        template: messages[reasonCode]
      });
    });
    return Object.freeze(templates);
  }

  var ParserError = function (_CommentsParser) {
    _inherits(ParserError, _CommentsParser);

    function ParserError() {
      return _CommentsParser.apply(this, arguments) || this;
    }

    var _proto = ParserError.prototype;

    _proto.getLocationForPosition = function getLocationForPosition(pos) {
      var loc;
      if (pos === this.state.start) loc = this.state.startLoc;else if (pos === this.state.lastTokStart) loc = this.state.lastTokStartLoc;else if (pos === this.state.end) loc = this.state.endLoc;else if (pos === this.state.lastTokEnd) loc = this.state.lastTokEndLoc;else loc = getLineInfo(this.input, pos);
      return loc;
    };

    _proto.raise = function raise(pos, _ref) {
      var code = _ref.code,
          reasonCode = _ref.reasonCode,
          template = _ref.template;

      for (var _len = arguments.length, params = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        params[_key - 2] = arguments[_key];
      }

      return this.raiseWithData.apply(this, [pos, {
        code: code,
        reasonCode: reasonCode
      }, template].concat(params));
    };

    _proto.raiseOverwrite = function raiseOverwrite(pos, _ref2) {
      var code = _ref2.code,
          template = _ref2.template;

      for (var _len2 = arguments.length, params = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
        params[_key2 - 2] = arguments[_key2];
      }

      var loc = this.getLocationForPosition(pos);
      var message = template.replace(/%(\d+)/g, function (_, i) {
        return params[i];
      }) + (" (" + loc.line + ":" + loc.column + ")");

      if (this.options.errorRecovery) {
        var errors = this.state.errors;

        for (var i = errors.length - 1; i >= 0; i--) {
          var error = errors[i];

          if (error.pos === pos) {
            return Object.assign(error, {
              message: message
            });
          } else if (error.pos < pos) {
            break;
          }
        }
      }

      return this._raise({
        code: code,
        loc: loc,
        pos: pos
      }, message);
    };

    _proto.raiseWithData = function raiseWithData(pos, data, errorTemplate) {
      for (var _len3 = arguments.length, params = new Array(_len3 > 3 ? _len3 - 3 : 0), _key3 = 3; _key3 < _len3; _key3++) {
        params[_key3 - 3] = arguments[_key3];
      }

      var loc = this.getLocationForPosition(pos);
      var message = errorTemplate.replace(/%(\d+)/g, function (_, i) {
        return params[i];
      }) + (" (" + loc.line + ":" + loc.column + ")");
      return this._raise(Object.assign({
        loc: loc,
        pos: pos
      }, data), message);
    };

    _proto._raise = function _raise(errorContext, message) {
      var err = new SyntaxError(message);
      Object.assign(err, errorContext);

      if (this.options.errorRecovery) {
        if (!this.isLookahead) this.state.errors.push(err);
        return err;
      } else {
        throw err;
      }
    };

    return ParserError;
  }(CommentsParser);

  var estree = (function (superClass) {
    return function (_superClass) {
      _inherits(_class, _superClass);

      function _class() {
        return _superClass.apply(this, arguments) || this;
      }

      var _proto = _class.prototype;

      _proto.parseRegExpLiteral = function parseRegExpLiteral(_ref) {
        var pattern = _ref.pattern,
            flags = _ref.flags;
        var regex = null;

        try {
          regex = new RegExp(pattern, flags);
        } catch (e) {}

        var node = this.estreeParseLiteral(regex);
        node.regex = {
          pattern: pattern,
          flags: flags
        };
        return node;
      };

      _proto.parseBigIntLiteral = function parseBigIntLiteral(value) {
        var bigInt;

        try {
          bigInt = BigInt(value);
        } catch (_unused) {
          bigInt = null;
        }

        var node = this.estreeParseLiteral(bigInt);
        node.bigint = String(node.value || value);
        return node;
      };

      _proto.parseDecimalLiteral = function parseDecimalLiteral(value) {
        var decimal = null;
        var node = this.estreeParseLiteral(decimal);
        node.decimal = String(node.value || value);
        return node;
      };

      _proto.estreeParseLiteral = function estreeParseLiteral(value) {
        return this.parseLiteral(value, "Literal");
      };

      _proto.parseStringLiteral = function parseStringLiteral(value) {
        return this.estreeParseLiteral(value);
      };

      _proto.parseNumericLiteral = function parseNumericLiteral(value) {
        return this.estreeParseLiteral(value);
      };

      _proto.parseNullLiteral = function parseNullLiteral() {
        return this.estreeParseLiteral(null);
      };

      _proto.parseBooleanLiteral = function parseBooleanLiteral(value) {
        return this.estreeParseLiteral(value);
      };

      _proto.directiveToStmt = function directiveToStmt(directive) {
        var directiveLiteral = directive.value;
        var stmt = this.startNodeAt(directive.start, directive.loc.start);
        var expression = this.startNodeAt(directiveLiteral.start, directiveLiteral.loc.start);
        expression.value = directiveLiteral.extra.expressionValue;
        expression.raw = directiveLiteral.extra.raw;
        stmt.expression = this.finishNodeAt(expression, "Literal", directiveLiteral.end, directiveLiteral.loc.end);
        stmt.directive = directiveLiteral.extra.raw.slice(1, -1);
        return this.finishNodeAt(stmt, "ExpressionStatement", directive.end, directive.loc.end);
      };

      _proto.initFunction = function initFunction(node, isAsync) {
        _superClass.prototype.initFunction.call(this, node, isAsync);

        node.expression = false;
      };

      _proto.checkDeclaration = function checkDeclaration(node) {
        if (node != null && this.isObjectProperty(node)) {
          this.checkDeclaration(node.value);
        } else {
          _superClass.prototype.checkDeclaration.call(this, node);
        }
      };

      _proto.getObjectOrClassMethodParams = function getObjectOrClassMethodParams(method) {
        return method.value.params;
      };

      _proto.isValidDirective = function isValidDirective(stmt) {
        var _stmt$expression$extr;

        return stmt.type === "ExpressionStatement" && stmt.expression.type === "Literal" && typeof stmt.expression.value === "string" && !((_stmt$expression$extr = stmt.expression.extra) != null && _stmt$expression$extr.parenthesized);
      };

      _proto.stmtToDirective = function stmtToDirective(stmt) {
        var value = stmt.expression.value;

        var directive = _superClass.prototype.stmtToDirective.call(this, stmt);

        this.addExtra(directive.value, "expressionValue", value);
        return directive;
      };

      _proto.parseBlockBody = function parseBlockBody(node) {
        var _superClass$prototype,
            _this = this;

        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        (_superClass$prototype = _superClass.prototype.parseBlockBody).call.apply(_superClass$prototype, [this, node].concat(args));

        var directiveStatements = node.directives.map(function (d) {
          return _this.directiveToStmt(d);
        });
        node.body = directiveStatements.concat(node.body);
        delete node.directives;
      };

      _proto.pushClassMethod = function pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper) {
        this.parseMethod(method, isGenerator, isAsync, isConstructor, allowsDirectSuper, "ClassMethod", true);

        if (method.typeParameters) {
          method.value.typeParameters = method.typeParameters;
          delete method.typeParameters;
        }

        classBody.body.push(method);
      };

      _proto.parseMaybePrivateName = function parseMaybePrivateName() {
        var _superClass$prototype2;

        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        var node = (_superClass$prototype2 = _superClass.prototype.parseMaybePrivateName).call.apply(_superClass$prototype2, [this].concat(args));

        if (node.type === "PrivateName" && this.getPluginOption("estree", "classFeatures")) {
          return this.convertPrivateNameToPrivateIdentifier(node);
        }

        return node;
      };

      _proto.convertPrivateNameToPrivateIdentifier = function convertPrivateNameToPrivateIdentifier(node) {
        var name = _superClass.prototype.getPrivateNameSV.call(this, node);

        node = node;
        delete node.id;
        node.name = name;
        node.type = "PrivateIdentifier";
        return node;
      };

      _proto.isPrivateName = function isPrivateName(node) {
        if (!this.getPluginOption("estree", "classFeatures")) {
          return _superClass.prototype.isPrivateName.call(this, node);
        }

        return node.type === "PrivateIdentifier";
      };

      _proto.getPrivateNameSV = function getPrivateNameSV(node) {
        if (!this.getPluginOption("estree", "classFeatures")) {
          return _superClass.prototype.getPrivateNameSV.call(this, node);
        }

        return node.name;
      };

      _proto.parseLiteral = function parseLiteral(value, type) {
        var node = _superClass.prototype.parseLiteral.call(this, value, type);

        node.raw = node.extra.raw;
        delete node.extra;
        return node;
      };

      _proto.parseFunctionBody = function parseFunctionBody(node, allowExpression, isMethod) {
        if (isMethod === void 0) {
          isMethod = false;
        }

        _superClass.prototype.parseFunctionBody.call(this, node, allowExpression, isMethod);

        node.expression = node.body.type !== "BlockStatement";
      };

      _proto.parseMethod = function parseMethod(node, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope) {
        if (inClassScope === void 0) {
          inClassScope = false;
        }

        var funcNode = this.startNode();
        funcNode.kind = node.kind;
        funcNode = _superClass.prototype.parseMethod.call(this, funcNode, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope);
        funcNode.type = "FunctionExpression";
        delete funcNode.kind;
        node.value = funcNode;

        if (type === "ClassPrivateMethod") {
          node.computed = false;
        }

        type = "MethodDefinition";
        return this.finishNode(node, type);
      };

      _proto.parseClassProperty = function parseClassProperty() {
        var _superClass$prototype3;

        for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
          args[_key3] = arguments[_key3];
        }

        var propertyNode = (_superClass$prototype3 = _superClass.prototype.parseClassProperty).call.apply(_superClass$prototype3, [this].concat(args));

        if (this.getPluginOption("estree", "classFeatures")) {
          propertyNode.type = "PropertyDefinition";
        }

        return propertyNode;
      };

      _proto.parseClassPrivateProperty = function parseClassPrivateProperty() {
        var _superClass$prototype4;

        for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
          args[_key4] = arguments[_key4];
        }

        var propertyNode = (_superClass$prototype4 = _superClass.prototype.parseClassPrivateProperty).call.apply(_superClass$prototype4, [this].concat(args));

        if (this.getPluginOption("estree", "classFeatures")) {
          propertyNode.type = "PropertyDefinition";
          propertyNode.computed = false;
        }

        return propertyNode;
      };

      _proto.parseObjectMethod = function parseObjectMethod(prop, isGenerator, isAsync, isPattern, isAccessor) {
        var node = _superClass.prototype.parseObjectMethod.call(this, prop, isGenerator, isAsync, isPattern, isAccessor);

        if (node) {
          node.type = "Property";
          if (node.kind === "method") node.kind = "init";
          node.shorthand = false;
        }

        return node;
      };

      _proto.parseObjectProperty = function parseObjectProperty(prop, startPos, startLoc, isPattern, refExpressionErrors) {
        var node = _superClass.prototype.parseObjectProperty.call(this, prop, startPos, startLoc, isPattern, refExpressionErrors);

        if (node) {
          node.kind = "init";
          node.type = "Property";
        }

        return node;
      };

      _proto.isAssignable = function isAssignable(node, isBinding) {
        if (node != null && this.isObjectProperty(node)) {
          return this.isAssignable(node.value, isBinding);
        }

        return _superClass.prototype.isAssignable.call(this, node, isBinding);
      };

      _proto.toAssignable = function toAssignable(node, isLHS) {
        if (isLHS === void 0) {
          isLHS = false;
        }

        if (node != null && this.isObjectProperty(node)) {
          this.toAssignable(node.value, isLHS);
          return node;
        }

        return _superClass.prototype.toAssignable.call(this, node, isLHS);
      };

      _proto.toAssignableObjectExpressionProp = function toAssignableObjectExpressionProp(prop) {
        if (prop.kind === "get" || prop.kind === "set") {
          this.raise(prop.key.start, ErrorMessages.PatternHasAccessor);
        } else if (prop.method) {
          this.raise(prop.key.start, ErrorMessages.PatternHasMethod);
        } else {
          var _superClass$prototype5;

          for (var _len5 = arguments.length, args = new Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
            args[_key5 - 1] = arguments[_key5];
          }

          (_superClass$prototype5 = _superClass.prototype.toAssignableObjectExpressionProp).call.apply(_superClass$prototype5, [this, prop].concat(args));
        }
      };

      _proto.finishCallExpression = function finishCallExpression(node, optional) {
        _superClass.prototype.finishCallExpression.call(this, node, optional);

        if (node.callee.type === "Import") {
          node.type = "ImportExpression";
          node.source = node.arguments[0];

          if (this.hasPlugin("importAssertions")) {
            var _node$arguments$;

            node.attributes = (_node$arguments$ = node.arguments[1]) != null ? _node$arguments$ : null;
          }

          delete node.arguments;
          delete node.callee;
        }

        return node;
      };

      _proto.toReferencedArguments = function toReferencedArguments(node) {
        if (node.type === "ImportExpression") {
          return;
        }

        _superClass.prototype.toReferencedArguments.call(this, node);
      };

      _proto.parseExport = function parseExport(node) {
        _superClass.prototype.parseExport.call(this, node);

        switch (node.type) {
          case "ExportAllDeclaration":
            node.exported = null;
            break;

          case "ExportNamedDeclaration":
            if (node.specifiers.length === 1 && node.specifiers[0].type === "ExportNamespaceSpecifier") {
              node.type = "ExportAllDeclaration";
              node.exported = node.specifiers[0].exported;
              delete node.specifiers;
            }

            break;
        }

        return node;
      };

      _proto.parseSubscript = function parseSubscript(base, startPos, startLoc, noCalls, state) {
        var node = _superClass.prototype.parseSubscript.call(this, base, startPos, startLoc, noCalls, state);

        if (state.optionalChainMember) {
          if (node.type === "OptionalMemberExpression" || node.type === "OptionalCallExpression") {
            node.type = node.type.substring(8);
          }

          if (state.stop) {
            var chain = this.startNodeAtNode(node);
            chain.expression = node;
            return this.finishNode(chain, "ChainExpression");
          }
        } else if (node.type === "MemberExpression" || node.type === "CallExpression") {
          node.optional = false;
        }

        return node;
      };

      _proto.hasPropertyAsPrivateName = function hasPropertyAsPrivateName(node) {
        if (node.type === "ChainExpression") {
          node = node.expression;
        }

        return _superClass.prototype.hasPropertyAsPrivateName.call(this, node);
      };

      _proto.isOptionalChain = function isOptionalChain(node) {
        return node.type === "ChainExpression";
      };

      _proto.isObjectProperty = function isObjectProperty(node) {
        return node.type === "Property" && node.kind === "init" && !node.method;
      };

      _proto.isObjectMethod = function isObjectMethod(node) {
        return node.method || node.kind === "get" || node.kind === "set";
      };

      return _class;
    }(superClass);
  });

  var TokContext = function TokContext(token, preserveSpace) {
    this.token = void 0;
    this.preserveSpace = void 0;
    this.token = token;
    this.preserveSpace = !!preserveSpace;
  };
  var types = {
    brace: new TokContext("{"),
    template: new TokContext("`", true)
  };

  types$1.braceR.updateContext = function (context) {
    context.pop();
  };

  types$1.braceL.updateContext = types$1.braceHashL.updateContext = types$1.dollarBraceL.updateContext = function (context) {
    context.push(types.brace);
  };

  types$1.backQuote.updateContext = function (context) {
    if (context[context.length - 1] === types.template) {
      context.pop();
    } else {
      context.push(types.template);
    }
  };

  function isIteratorStart(current, next) {
    return current === 64 && next === 64;
  }
  var reservedWordLikeSet = new Set(["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "eval", "arguments", "enum", "await"]);
  function canBeReservedWord(word) {
    return reservedWordLikeSet.has(word);
  }

  var SCOPE_OTHER = 0,
      SCOPE_PROGRAM = 1,
      SCOPE_FUNCTION = 2,
      SCOPE_ARROW = 4,
      SCOPE_SIMPLE_CATCH = 8,
      SCOPE_SUPER = 16,
      SCOPE_DIRECT_SUPER = 32,
      SCOPE_CLASS = 64,
      SCOPE_STATIC_BLOCK = 128,
      SCOPE_TS_MODULE = 256,
      SCOPE_VAR = SCOPE_PROGRAM | SCOPE_FUNCTION | SCOPE_TS_MODULE;
  var BIND_KIND_VALUE = 1,
      BIND_KIND_TYPE = 2,
      BIND_SCOPE_VAR = 4,
      BIND_SCOPE_LEXICAL = 8,
      BIND_SCOPE_FUNCTION = 16,
      BIND_FLAGS_NONE = 64,
      BIND_FLAGS_CLASS = 128,
      BIND_FLAGS_TS_ENUM = 256,
      BIND_FLAGS_TS_CONST_ENUM = 512,
      BIND_FLAGS_TS_EXPORT_ONLY = 1024,
      BIND_FLAGS_FLOW_DECLARE_FN = 2048;
  var BIND_CLASS = BIND_KIND_VALUE | BIND_KIND_TYPE | BIND_SCOPE_LEXICAL | BIND_FLAGS_CLASS,
      BIND_LEXICAL = BIND_KIND_VALUE | 0 | BIND_SCOPE_LEXICAL | 0,
      BIND_VAR = BIND_KIND_VALUE | 0 | BIND_SCOPE_VAR | 0,
      BIND_FUNCTION = BIND_KIND_VALUE | 0 | BIND_SCOPE_FUNCTION | 0,
      BIND_TS_INTERFACE = 0 | BIND_KIND_TYPE | 0 | BIND_FLAGS_CLASS,
      BIND_TS_TYPE = 0 | BIND_KIND_TYPE | 0 | 0,
      BIND_TS_ENUM = BIND_KIND_VALUE | BIND_KIND_TYPE | BIND_SCOPE_LEXICAL | BIND_FLAGS_TS_ENUM,
      BIND_TS_AMBIENT = 0 | 0 | 0 | BIND_FLAGS_TS_EXPORT_ONLY,
      BIND_NONE = 0 | 0 | 0 | BIND_FLAGS_NONE,
      BIND_OUTSIDE = BIND_KIND_VALUE | 0 | 0 | BIND_FLAGS_NONE,
      BIND_TS_CONST_ENUM = BIND_TS_ENUM | BIND_FLAGS_TS_CONST_ENUM,
      BIND_TS_NAMESPACE = 0 | 0 | 0 | BIND_FLAGS_TS_EXPORT_ONLY,
      BIND_FLOW_DECLARE_FN = BIND_FLAGS_FLOW_DECLARE_FN;
  var CLASS_ELEMENT_FLAG_STATIC = 4,
      CLASS_ELEMENT_KIND_GETTER = 2,
      CLASS_ELEMENT_KIND_SETTER = 1,
      CLASS_ELEMENT_KIND_ACCESSOR = CLASS_ELEMENT_KIND_GETTER | CLASS_ELEMENT_KIND_SETTER;
  var CLASS_ELEMENT_STATIC_GETTER = CLASS_ELEMENT_KIND_GETTER | CLASS_ELEMENT_FLAG_STATIC,
      CLASS_ELEMENT_STATIC_SETTER = CLASS_ELEMENT_KIND_SETTER | CLASS_ELEMENT_FLAG_STATIC,
      CLASS_ELEMENT_INSTANCE_GETTER = CLASS_ELEMENT_KIND_GETTER,
      CLASS_ELEMENT_INSTANCE_SETTER = CLASS_ELEMENT_KIND_SETTER,
      CLASS_ELEMENT_OTHER = 0;

  var Scope = function Scope(flags) {
    this["var"] = new Set();
    this.lexical = new Set();
    this.functions = new Set();
    this.flags = flags;
  };

  var ScopeHandler = function () {
    function ScopeHandler(raise, inModule) {
      this.scopeStack = [];
      this.undefinedExports = new Map();
      this.undefinedPrivateNames = new Map();
      this.raise = raise;
      this.inModule = inModule;
    }

    var _proto = ScopeHandler.prototype;

    _proto.createScope = function createScope(flags) {
      return new Scope(flags);
    };

    _proto.enter = function enter(flags) {
      this.scopeStack.push(this.createScope(flags));
    };

    _proto.exit = function exit() {
      this.scopeStack.pop();
    };

    _proto.treatFunctionsAsVarInScope = function treatFunctionsAsVarInScope(scope) {
      return !!(scope.flags & SCOPE_FUNCTION || !this.inModule && scope.flags & SCOPE_PROGRAM);
    };

    _proto.declareName = function declareName(name, bindingType, pos) {
      var scope = this.currentScope();

      if (bindingType & BIND_SCOPE_LEXICAL || bindingType & BIND_SCOPE_FUNCTION) {
        this.checkRedeclarationInScope(scope, name, bindingType, pos);

        if (bindingType & BIND_SCOPE_FUNCTION) {
          scope.functions.add(name);
        } else {
          scope.lexical.add(name);
        }

        if (bindingType & BIND_SCOPE_LEXICAL) {
          this.maybeExportDefined(scope, name);
        }
      } else if (bindingType & BIND_SCOPE_VAR) {
        for (var i = this.scopeStack.length - 1; i >= 0; --i) {
          scope = this.scopeStack[i];
          this.checkRedeclarationInScope(scope, name, bindingType, pos);
          scope["var"].add(name);
          this.maybeExportDefined(scope, name);
          if (scope.flags & SCOPE_VAR) break;
        }
      }

      if (this.inModule && scope.flags & SCOPE_PROGRAM) {
        this.undefinedExports["delete"](name);
      }
    };

    _proto.maybeExportDefined = function maybeExportDefined(scope, name) {
      if (this.inModule && scope.flags & SCOPE_PROGRAM) {
        this.undefinedExports["delete"](name);
      }
    };

    _proto.checkRedeclarationInScope = function checkRedeclarationInScope(scope, name, bindingType, pos) {
      if (this.isRedeclaredInScope(scope, name, bindingType)) {
        this.raise(pos, ErrorMessages.VarRedeclaration, name);
      }
    };

    _proto.isRedeclaredInScope = function isRedeclaredInScope(scope, name, bindingType) {
      if (!(bindingType & BIND_KIND_VALUE)) return false;

      if (bindingType & BIND_SCOPE_LEXICAL) {
        return scope.lexical.has(name) || scope.functions.has(name) || scope["var"].has(name);
      }

      if (bindingType & BIND_SCOPE_FUNCTION) {
        return scope.lexical.has(name) || !this.treatFunctionsAsVarInScope(scope) && scope["var"].has(name);
      }

      return scope.lexical.has(name) && !(scope.flags & SCOPE_SIMPLE_CATCH && scope.lexical.values().next().value === name) || !this.treatFunctionsAsVarInScope(scope) && scope.functions.has(name);
    };

    _proto.checkLocalExport = function checkLocalExport(id) {
      var name = id.name;
      var topLevelScope = this.scopeStack[0];

      if (!topLevelScope.lexical.has(name) && !topLevelScope["var"].has(name) && !topLevelScope.functions.has(name)) {
        this.undefinedExports.set(name, id.start);
      }
    };

    _proto.currentScope = function currentScope() {
      return this.scopeStack[this.scopeStack.length - 1];
    };

    _proto.currentVarScopeFlags = function currentVarScopeFlags() {
      for (var i = this.scopeStack.length - 1;; i--) {
        var flags = this.scopeStack[i].flags;

        if (flags & SCOPE_VAR) {
          return flags;
        }
      }
    };

    _proto.currentThisScopeFlags = function currentThisScopeFlags() {
      for (var i = this.scopeStack.length - 1;; i--) {
        var flags = this.scopeStack[i].flags;

        if (flags & (SCOPE_VAR | SCOPE_CLASS) && !(flags & SCOPE_ARROW)) {
          return flags;
        }
      }
    };

    _createClass(ScopeHandler, [{
      key: "inFunction",
      get: function get() {
        return (this.currentVarScopeFlags() & SCOPE_FUNCTION) > 0;
      }
    }, {
      key: "allowSuper",
      get: function get() {
        return (this.currentThisScopeFlags() & SCOPE_SUPER) > 0;
      }
    }, {
      key: "allowDirectSuper",
      get: function get() {
        return (this.currentThisScopeFlags() & SCOPE_DIRECT_SUPER) > 0;
      }
    }, {
      key: "inClass",
      get: function get() {
        return (this.currentThisScopeFlags() & SCOPE_CLASS) > 0;
      }
    }, {
      key: "inClassAndNotInNonArrowFunction",
      get: function get() {
        var flags = this.currentThisScopeFlags();
        return (flags & SCOPE_CLASS) > 0 && (flags & SCOPE_FUNCTION) === 0;
      }
    }, {
      key: "inStaticBlock",
      get: function get() {
        for (var i = this.scopeStack.length - 1;; i--) {
          var flags = this.scopeStack[i].flags;

          if (flags & SCOPE_STATIC_BLOCK) {
            return true;
          }

          if (flags & (SCOPE_VAR | SCOPE_CLASS)) {
            return false;
          }
        }
      }
    }, {
      key: "inNonArrowFunction",
      get: function get() {
        return (this.currentThisScopeFlags() & SCOPE_FUNCTION) > 0;
      }
    }, {
      key: "treatFunctionsAsVar",
      get: function get() {
        return this.treatFunctionsAsVarInScope(this.currentScope());
      }
    }]);

    return ScopeHandler;
  }();

  var FlowScope = function (_Scope) {
    _inherits(FlowScope, _Scope);

    function FlowScope() {
      var _this;

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _Scope.call.apply(_Scope, [this].concat(args)) || this;
      _this.declareFunctions = new Set();
      return _this;
    }

    return FlowScope;
  }(Scope);

  var FlowScopeHandler = function (_ScopeHandler) {
    _inherits(FlowScopeHandler, _ScopeHandler);

    function FlowScopeHandler() {
      return _ScopeHandler.apply(this, arguments) || this;
    }

    var _proto = FlowScopeHandler.prototype;

    _proto.createScope = function createScope(flags) {
      return new FlowScope(flags);
    };

    _proto.declareName = function declareName(name, bindingType, pos) {
      var scope = this.currentScope();

      if (bindingType & BIND_FLAGS_FLOW_DECLARE_FN) {
        this.checkRedeclarationInScope(scope, name, bindingType, pos);
        this.maybeExportDefined(scope, name);
        scope.declareFunctions.add(name);
        return;
      }

      _ScopeHandler.prototype.declareName.apply(this, arguments);
    };

    _proto.isRedeclaredInScope = function isRedeclaredInScope(scope, name, bindingType) {
      if (_ScopeHandler.prototype.isRedeclaredInScope.apply(this, arguments)) return true;

      if (bindingType & BIND_FLAGS_FLOW_DECLARE_FN) {
        return !scope.declareFunctions.has(name) && (scope.lexical.has(name) || scope.functions.has(name));
      }

      return false;
    };

    _proto.checkLocalExport = function checkLocalExport(id) {
      if (!this.scopeStack[0].declareFunctions.has(id.name)) {
        _ScopeHandler.prototype.checkLocalExport.call(this, id);
      }
    };

    return FlowScopeHandler;
  }(ScopeHandler);

  var State = function () {
    function State() {
      this.strict = void 0;
      this.curLine = void 0;
      this.startLoc = void 0;
      this.endLoc = void 0;
      this.errors = [];
      this.potentialArrowAt = -1;
      this.noArrowAt = [];
      this.noArrowParamsConversionAt = [];
      this.maybeInArrowParameters = false;
      this.inType = false;
      this.noAnonFunctionType = false;
      this.inPropertyName = false;
      this.hasFlowComment = false;
      this.isAmbientContext = false;
      this.inAbstractClass = false;
      this.topicContext = {
        maxNumOfResolvableTopics: 0,
        maxTopicIndex: null
      };
      this.soloAwait = false;
      this.inFSharpPipelineDirectBody = false;
      this.labels = [];
      this.decoratorStack = [[]];
      this.comments = [];
      this.commentStack = [];
      this.pos = 0;
      this.lineStart = 0;
      this.type = types$1.eof;
      this.value = null;
      this.start = 0;
      this.end = 0;
      this.lastTokEndLoc = null;
      this.lastTokStartLoc = null;
      this.lastTokStart = 0;
      this.lastTokEnd = 0;
      this.context = [types.brace];
      this.exprAllowed = true;
      this.containsEsc = false;
      this.strictErrors = new Map();
      this.tokensLength = 0;
    }

    var _proto = State.prototype;

    _proto.init = function init(options) {
      this.strict = options.strictMode === false ? false : options.strictMode === true ? true : options.sourceType === "module";
      this.curLine = options.startLine;
      this.startLoc = this.endLoc = this.curPosition();
    };

    _proto.curPosition = function curPosition() {
      return new Position(this.curLine, this.pos - this.lineStart);
    };

    _proto.clone = function clone(skipArrays) {
      var state = new State();
      var keys = Object.keys(this);

      for (var i = 0, length = keys.length; i < length; i++) {
        var key = keys[i];
        var val = this[key];

        if (!skipArrays && Array.isArray(val)) {
          val = val.slice();
        }

        state[key] = val;
      }

      return state;
    };

    return State;
  }();

  var _isDigit = function isDigit(code) {
    return code >= 48 && code <= 57;
  };
  var VALID_REGEX_FLAGS = new Set([103, 109, 115, 105, 121, 117, 100]);
  var forbiddenNumericSeparatorSiblings = {
    decBinOct: [46, 66, 69, 79, 95, 98, 101, 111],
    hex: [46, 88, 95, 120]
  };
  var allowedNumericSeparatorSiblings = {};
  allowedNumericSeparatorSiblings.bin = [48, 49];
  allowedNumericSeparatorSiblings.oct = [].concat(allowedNumericSeparatorSiblings.bin, [50, 51, 52, 53, 54, 55]);
  allowedNumericSeparatorSiblings.dec = [].concat(allowedNumericSeparatorSiblings.oct, [56, 57]);
  allowedNumericSeparatorSiblings.hex = [].concat(allowedNumericSeparatorSiblings.dec, [65, 66, 67, 68, 69, 70, 97, 98, 99, 100, 101, 102]);
  var Token = function Token(state) {
    this.type = state.type;
    this.value = state.value;
    this.start = state.start;
    this.end = state.end;
    this.loc = new SourceLocation(state.startLoc, state.endLoc);
  };

  var Tokenizer = function (_ParserErrors) {
    _inherits(Tokenizer, _ParserErrors);

    function Tokenizer(options, input) {
      var _this;

      _this = _ParserErrors.call(this) || this;
      _this.isLookahead = void 0;
      _this.tokens = [];
      _this.state = new State();

      _this.state.init(options);

      _this.input = input;
      _this.length = input.length;
      _this.isLookahead = false;
      return _this;
    }

    var _proto = Tokenizer.prototype;

    _proto.pushToken = function pushToken(token) {
      this.tokens.length = this.state.tokensLength;
      this.tokens.push(token);
      ++this.state.tokensLength;
    };

    _proto.next = function next() {
      this.checkKeywordEscapes();

      if (this.options.tokens) {
        this.pushToken(new Token(this.state));
      }

      this.state.lastTokEnd = this.state.end;
      this.state.lastTokStart = this.state.start;
      this.state.lastTokEndLoc = this.state.endLoc;
      this.state.lastTokStartLoc = this.state.startLoc;
      this.nextToken();
    };

    _proto.eat = function eat(type) {
      if (this.match(type)) {
        this.next();
        return true;
      } else {
        return false;
      }
    };

    _proto.match = function match(type) {
      return this.state.type === type;
    };

    _proto.createLookaheadState = function createLookaheadState(state) {
      return {
        pos: state.pos,
        value: null,
        type: state.type,
        start: state.start,
        end: state.end,
        lastTokEnd: state.end,
        context: [this.curContext()],
        inType: state.inType
      };
    };

    _proto.lookahead = function lookahead() {
      var old = this.state;
      this.state = this.createLookaheadState(old);
      this.isLookahead = true;
      this.nextToken();
      this.isLookahead = false;
      var curr = this.state;
      this.state = old;
      return curr;
    };

    _proto.nextTokenStart = function nextTokenStart() {
      return this.nextTokenStartSince(this.state.pos);
    };

    _proto.nextTokenStartSince = function nextTokenStartSince(pos) {
      skipWhiteSpace.lastIndex = pos;
      return skipWhiteSpace.test(this.input) ? skipWhiteSpace.lastIndex : pos;
    };

    _proto.lookaheadCharCode = function lookaheadCharCode() {
      return this.input.charCodeAt(this.nextTokenStart());
    };

    _proto.codePointAtPos = function codePointAtPos(pos) {
      var cp = this.input.charCodeAt(pos);

      if ((cp & 0xfc00) === 0xd800 && ++pos < this.input.length) {
        var trail = this.input.charCodeAt(pos);

        if ((trail & 0xfc00) === 0xdc00) {
          cp = 0x10000 + ((cp & 0x3ff) << 10) + (trail & 0x3ff);
        }
      }

      return cp;
    };

    _proto.setStrict = function setStrict(strict) {
      var _this2 = this;

      this.state.strict = strict;

      if (strict) {
        this.state.strictErrors.forEach(function (message, pos) {
          return _this2.raise(pos, message);
        });
        this.state.strictErrors.clear();
      }
    };

    _proto.curContext = function curContext() {
      return this.state.context[this.state.context.length - 1];
    };

    _proto.nextToken = function nextToken() {
      var curContext = this.curContext();
      if (!curContext.preserveSpace) this.skipSpace();
      this.state.start = this.state.pos;
      if (!this.isLookahead) this.state.startLoc = this.state.curPosition();

      if (this.state.pos >= this.length) {
        this.finishToken(types$1.eof);
        return;
      }

      if (curContext === types.template) {
        this.readTmplToken();
      } else {
        this.getTokenFromCode(this.codePointAtPos(this.state.pos));
      }
    };

    _proto.skipBlockComment = function skipBlockComment() {
      var startLoc;
      if (!this.isLookahead) startLoc = this.state.curPosition();
      var start = this.state.pos;
      var end = this.input.indexOf("*/", start + 2);
      if (end === -1) throw this.raise(start, ErrorMessages.UnterminatedComment);
      this.state.pos = end + 2;
      lineBreakG.lastIndex = start + 2;

      while (lineBreakG.test(this.input) && lineBreakG.lastIndex <= end) {
        ++this.state.curLine;
        this.state.lineStart = lineBreakG.lastIndex;
      }

      if (this.isLookahead) return;
      var comment = {
        type: "CommentBlock",
        value: this.input.slice(start + 2, end),
        start: start,
        end: end + 2,
        loc: new SourceLocation(startLoc, this.state.curPosition())
      };
      if (this.options.tokens) this.pushToken(comment);
      return comment;
    };

    _proto.skipLineComment = function skipLineComment(startSkip) {
      var start = this.state.pos;
      var startLoc;
      if (!this.isLookahead) startLoc = this.state.curPosition();
      var ch = this.input.charCodeAt(this.state.pos += startSkip);

      if (this.state.pos < this.length) {
        while (!isNewLine(ch) && ++this.state.pos < this.length) {
          ch = this.input.charCodeAt(this.state.pos);
        }
      }

      if (this.isLookahead) return;
      var end = this.state.pos;
      var value = this.input.slice(start + startSkip, end);
      var comment = {
        type: "CommentLine",
        value: value,
        start: start,
        end: end,
        loc: new SourceLocation(startLoc, this.state.curPosition())
      };
      if (this.options.tokens) this.pushToken(comment);
      return comment;
    };

    _proto.skipSpace = function skipSpace() {
      var spaceStart = this.state.pos;
      var comments = [];

      loop: while (this.state.pos < this.length) {
        var ch = this.input.charCodeAt(this.state.pos);

        switch (ch) {
          case 32:
          case 160:
          case 9:
            ++this.state.pos;
            break;

          case 13:
            if (this.input.charCodeAt(this.state.pos + 1) === 10) {
              ++this.state.pos;
            }

          case 10:
          case 8232:
          case 8233:
            ++this.state.pos;
            ++this.state.curLine;
            this.state.lineStart = this.state.pos;
            break;

          case 47:
            switch (this.input.charCodeAt(this.state.pos + 1)) {
              case 42:
                {
                  var comment = this.skipBlockComment();

                  if (comment !== undefined) {
                    this.addComment(comment);
                    if (this.options.attachComment) comments.push(comment);
                  }

                  break;
                }

              case 47:
                {
                  var _comment = this.skipLineComment(2);

                  if (_comment !== undefined) {
                    this.addComment(_comment);
                    if (this.options.attachComment) comments.push(_comment);
                  }

                  break;
                }

              default:
                break loop;
            }

            break;

          default:
            if (isWhitespace(ch)) {
              ++this.state.pos;
            } else if (ch === 45 && !this.inModule) {
              var pos = this.state.pos;

              if (this.input.charCodeAt(pos + 1) === 45 && this.input.charCodeAt(pos + 2) === 62 && (spaceStart === 0 || this.state.lineStart > spaceStart)) {
                var _comment2 = this.skipLineComment(3);

                if (_comment2 !== undefined) {
                  this.addComment(_comment2);
                  if (this.options.attachComment) comments.push(_comment2);
                }
              } else {
                break loop;
              }
            } else if (ch === 60 && !this.inModule) {
              var _pos = this.state.pos;

              if (this.input.charCodeAt(_pos + 1) === 33 && this.input.charCodeAt(_pos + 2) === 45 && this.input.charCodeAt(_pos + 3) === 45) {
                var _comment3 = this.skipLineComment(4);

                if (_comment3 !== undefined) {
                  this.addComment(_comment3);
                  if (this.options.attachComment) comments.push(_comment3);
                }
              } else {
                break loop;
              }
            } else {
              break loop;
            }

        }
      }

      if (comments.length > 0) {
        var end = this.state.pos;
        var CommentWhitespace = {
          start: spaceStart,
          end: end,
          comments: comments,
          leadingNode: null,
          trailingNode: null,
          containingNode: null
        };
        this.state.commentStack.push(CommentWhitespace);
      }
    };

    _proto.finishToken = function finishToken(type, val) {
      this.state.end = this.state.pos;
      var prevType = this.state.type;
      this.state.type = type;
      this.state.value = val;

      if (!this.isLookahead) {
        this.state.endLoc = this.state.curPosition();
        this.updateContext(prevType);
      }
    };

    _proto.readToken_numberSign = function readToken_numberSign() {
      if (this.state.pos === 0 && this.readToken_interpreter()) {
        return;
      }

      var nextPos = this.state.pos + 1;
      var next = this.codePointAtPos(nextPos);

      if (next >= 48 && next <= 57) {
        throw this.raise(this.state.pos, ErrorMessages.UnexpectedDigitAfterHash);
      }

      if (next === 123 || next === 91 && this.hasPlugin("recordAndTuple")) {
        this.expectPlugin("recordAndTuple");

        if (this.getPluginOption("recordAndTuple", "syntaxType") !== "hash") {
          throw this.raise(this.state.pos, next === 123 ? ErrorMessages.RecordExpressionHashIncorrectStartSyntaxType : ErrorMessages.TupleExpressionHashIncorrectStartSyntaxType);
        }

        this.state.pos += 2;

        if (next === 123) {
          this.finishToken(types$1.braceHashL);
        } else {
          this.finishToken(types$1.bracketHashL);
        }
      } else if (isIdentifierStart(next)) {
        ++this.state.pos;
        this.finishToken(types$1.privateName, this.readWord1(next));
      } else if (next === 92) {
        ++this.state.pos;
        this.finishToken(types$1.privateName, this.readWord1());
      } else {
        this.finishOp(types$1.hash, 1);
      }
    };

    _proto.readToken_dot = function readToken_dot() {
      var next = this.input.charCodeAt(this.state.pos + 1);

      if (next >= 48 && next <= 57) {
        this.readNumber(true);
        return;
      }

      if (next === 46 && this.input.charCodeAt(this.state.pos + 2) === 46) {
        this.state.pos += 3;
        this.finishToken(types$1.ellipsis);
      } else {
        ++this.state.pos;
        this.finishToken(types$1.dot);
      }
    };

    _proto.readToken_slash = function readToken_slash() {
      var next = this.input.charCodeAt(this.state.pos + 1);

      if (next === 61) {
        this.finishOp(types$1.slashAssign, 2);
      } else {
        this.finishOp(types$1.slash, 1);
      }
    };

    _proto.readToken_interpreter = function readToken_interpreter() {
      if (this.state.pos !== 0 || this.length < 2) return false;
      var ch = this.input.charCodeAt(this.state.pos + 1);
      if (ch !== 33) return false;
      var start = this.state.pos;
      this.state.pos += 1;

      while (!isNewLine(ch) && ++this.state.pos < this.length) {
        ch = this.input.charCodeAt(this.state.pos);
      }

      var value = this.input.slice(start + 2, this.state.pos);
      this.finishToken(types$1.interpreterDirective, value);
      return true;
    };

    _proto.readToken_mult_modulo = function readToken_mult_modulo(code) {
      var type = code === 42 ? types$1.star : types$1.modulo;
      var width = 1;
      var next = this.input.charCodeAt(this.state.pos + 1);

      if (code === 42 && next === 42) {
        width++;
        next = this.input.charCodeAt(this.state.pos + 2);
        type = types$1.exponent;
      }

      if (next === 61 && !this.state.inType) {
        width++;
        type = code === 37 ? types$1.moduloAssign : types$1.assign;
      }

      this.finishOp(type, width);
    };

    _proto.readToken_pipe_amp = function readToken_pipe_amp(code) {
      var next = this.input.charCodeAt(this.state.pos + 1);

      if (next === code) {
        if (this.input.charCodeAt(this.state.pos + 2) === 61) {
          this.finishOp(types$1.assign, 3);
        } else {
          this.finishOp(code === 124 ? types$1.logicalOR : types$1.logicalAND, 2);
        }

        return;
      }

      if (code === 124) {
        if (next === 62) {
          this.finishOp(types$1.pipeline, 2);
          return;
        }

        if (this.hasPlugin("recordAndTuple") && next === 125) {
          if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
            throw this.raise(this.state.pos, ErrorMessages.RecordExpressionBarIncorrectEndSyntaxType);
          }

          this.state.pos += 2;
          this.finishToken(types$1.braceBarR);
          return;
        }

        if (this.hasPlugin("recordAndTuple") && next === 93) {
          if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
            throw this.raise(this.state.pos, ErrorMessages.TupleExpressionBarIncorrectEndSyntaxType);
          }

          this.state.pos += 2;
          this.finishToken(types$1.bracketBarR);
          return;
        }
      }

      if (next === 61) {
        this.finishOp(types$1.assign, 2);
        return;
      }

      this.finishOp(code === 124 ? types$1.bitwiseOR : types$1.bitwiseAND, 1);
    };

    _proto.readToken_caret = function readToken_caret() {
      var next = this.input.charCodeAt(this.state.pos + 1);

      if (next === 61) {
        this.finishOp(types$1.assign, 2);
      } else {
        this.finishOp(types$1.bitwiseXOR, 1);
      }
    };

    _proto.readToken_plus_min = function readToken_plus_min(code) {
      var next = this.input.charCodeAt(this.state.pos + 1);

      if (next === code) {
        this.finishOp(types$1.incDec, 2);
        return;
      }

      if (next === 61) {
        this.finishOp(types$1.assign, 2);
      } else {
        this.finishOp(types$1.plusMin, 1);
      }
    };

    _proto.readToken_lt_gt = function readToken_lt_gt(code) {
      var next = this.input.charCodeAt(this.state.pos + 1);
      var size = 1;

      if (next === code) {
        size = code === 62 && this.input.charCodeAt(this.state.pos + 2) === 62 ? 3 : 2;

        if (this.input.charCodeAt(this.state.pos + size) === 61) {
          this.finishOp(types$1.assign, size + 1);
          return;
        }

        this.finishOp(types$1.bitShift, size);
        return;
      }

      if (next === 61) {
        size = 2;
      }

      this.finishOp(types$1.relational, size);
    };

    _proto.readToken_eq_excl = function readToken_eq_excl(code) {
      var next = this.input.charCodeAt(this.state.pos + 1);

      if (next === 61) {
        this.finishOp(types$1.equality, this.input.charCodeAt(this.state.pos + 2) === 61 ? 3 : 2);
        return;
      }

      if (code === 61 && next === 62) {
        this.state.pos += 2;
        this.finishToken(types$1.arrow);
        return;
      }

      this.finishOp(code === 61 ? types$1.eq : types$1.bang, 1);
    };

    _proto.readToken_question = function readToken_question() {
      var next = this.input.charCodeAt(this.state.pos + 1);
      var next2 = this.input.charCodeAt(this.state.pos + 2);

      if (next === 63) {
        if (next2 === 61) {
          this.finishOp(types$1.assign, 3);
        } else {
          this.finishOp(types$1.nullishCoalescing, 2);
        }
      } else if (next === 46 && !(next2 >= 48 && next2 <= 57)) {
        this.state.pos += 2;
        this.finishToken(types$1.questionDot);
      } else {
        ++this.state.pos;
        this.finishToken(types$1.question);
      }
    };

    _proto.getTokenFromCode = function getTokenFromCode(code) {
      switch (code) {
        case 46:
          this.readToken_dot();
          return;

        case 40:
          ++this.state.pos;
          this.finishToken(types$1.parenL);
          return;

        case 41:
          ++this.state.pos;
          this.finishToken(types$1.parenR);
          return;

        case 59:
          ++this.state.pos;
          this.finishToken(types$1.semi);
          return;

        case 44:
          ++this.state.pos;
          this.finishToken(types$1.comma);
          return;

        case 91:
          if (this.hasPlugin("recordAndTuple") && this.input.charCodeAt(this.state.pos + 1) === 124) {
            if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
              throw this.raise(this.state.pos, ErrorMessages.TupleExpressionBarIncorrectStartSyntaxType);
            }

            this.state.pos += 2;
            this.finishToken(types$1.bracketBarL);
          } else {
            ++this.state.pos;
            this.finishToken(types$1.bracketL);
          }

          return;

        case 93:
          ++this.state.pos;
          this.finishToken(types$1.bracketR);
          return;

        case 123:
          if (this.hasPlugin("recordAndTuple") && this.input.charCodeAt(this.state.pos + 1) === 124) {
            if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
              throw this.raise(this.state.pos, ErrorMessages.RecordExpressionBarIncorrectStartSyntaxType);
            }

            this.state.pos += 2;
            this.finishToken(types$1.braceBarL);
          } else {
            ++this.state.pos;
            this.finishToken(types$1.braceL);
          }

          return;

        case 125:
          ++this.state.pos;
          this.finishToken(types$1.braceR);
          return;

        case 58:
          if (this.hasPlugin("functionBind") && this.input.charCodeAt(this.state.pos + 1) === 58) {
            this.finishOp(types$1.doubleColon, 2);
          } else {
            ++this.state.pos;
            this.finishToken(types$1.colon);
          }

          return;

        case 63:
          this.readToken_question();
          return;

        case 96:
          ++this.state.pos;
          this.finishToken(types$1.backQuote);
          return;

        case 48:
          {
            var next = this.input.charCodeAt(this.state.pos + 1);

            if (next === 120 || next === 88) {
              this.readRadixNumber(16);
              return;
            }

            if (next === 111 || next === 79) {
              this.readRadixNumber(8);
              return;
            }

            if (next === 98 || next === 66) {
              this.readRadixNumber(2);
              return;
            }
          }

        case 49:
        case 50:
        case 51:
        case 52:
        case 53:
        case 54:
        case 55:
        case 56:
        case 57:
          this.readNumber(false);
          return;

        case 34:
        case 39:
          this.readString(code);
          return;

        case 47:
          this.readToken_slash();
          return;

        case 37:
        case 42:
          this.readToken_mult_modulo(code);
          return;

        case 124:
        case 38:
          this.readToken_pipe_amp(code);
          return;

        case 94:
          this.readToken_caret();
          return;

        case 43:
        case 45:
          this.readToken_plus_min(code);
          return;

        case 60:
        case 62:
          this.readToken_lt_gt(code);
          return;

        case 61:
        case 33:
          this.readToken_eq_excl(code);
          return;

        case 126:
          this.finishOp(types$1.tilde, 1);
          return;

        case 64:
          ++this.state.pos;
          this.finishToken(types$1.at);
          return;

        case 35:
          this.readToken_numberSign();
          return;

        case 92:
          this.readWord();
          return;

        default:
          if (isIdentifierStart(code)) {
            this.readWord(code);
            return;
          }

      }

      throw this.raise(this.state.pos, ErrorMessages.InvalidOrUnexpectedToken, String.fromCodePoint(code));
    };

    _proto.finishOp = function finishOp(type, size) {
      var str = this.input.slice(this.state.pos, this.state.pos + size);
      this.state.pos += size;
      this.finishToken(type, str);
    };

    _proto.readRegexp = function readRegexp() {
      var start = this.state.start + 1;
      var escaped, inClass;
      var pos = this.state.pos;

      for (;; ++pos) {
        if (pos >= this.length) {
          throw this.raise(start, ErrorMessages.UnterminatedRegExp);
        }

        var ch = this.input.charCodeAt(pos);

        if (isNewLine(ch)) {
          throw this.raise(start, ErrorMessages.UnterminatedRegExp);
        }

        if (escaped) {
          escaped = false;
        } else {
          if (ch === 91) {
            inClass = true;
          } else if (ch === 93 && inClass) {
            inClass = false;
          } else if (ch === 47 && !inClass) {
            break;
          }

          escaped = ch === 92;
        }
      }

      var content = this.input.slice(start, pos);
      ++pos;
      var mods = "";

      while (pos < this.length) {
        var cp = this.codePointAtPos(pos);

        var _char = String.fromCharCode(cp);

        if (VALID_REGEX_FLAGS.has(cp)) {
          if (mods.includes(_char)) {
            this.raise(pos + 1, ErrorMessages.DuplicateRegExpFlags);
          }
        } else if (isIdentifierChar(cp) || cp === 92) {
          this.raise(pos + 1, ErrorMessages.MalformedRegExpFlags);
        } else {
          break;
        }

        ++pos;
        mods += _char;
      }

      this.state.pos = pos;
      this.finishToken(types$1.regexp, {
        pattern: content,
        flags: mods
      });
    };

    _proto.readInt = function readInt(radix, len, forceLen, allowNumSeparator) {
      if (allowNumSeparator === void 0) {
        allowNumSeparator = true;
      }

      var start = this.state.pos;
      var forbiddenSiblings = radix === 16 ? forbiddenNumericSeparatorSiblings.hex : forbiddenNumericSeparatorSiblings.decBinOct;
      var allowedSiblings = radix === 16 ? allowedNumericSeparatorSiblings.hex : radix === 10 ? allowedNumericSeparatorSiblings.dec : radix === 8 ? allowedNumericSeparatorSiblings.oct : allowedNumericSeparatorSiblings.bin;
      var invalid = false;
      var total = 0;

      for (var i = 0, e = len == null ? Infinity : len; i < e; ++i) {
        var code = this.input.charCodeAt(this.state.pos);
        var val = void 0;

        if (code === 95) {
          var prev = this.input.charCodeAt(this.state.pos - 1);
          var next = this.input.charCodeAt(this.state.pos + 1);

          if (allowedSiblings.indexOf(next) === -1) {
            this.raise(this.state.pos, ErrorMessages.UnexpectedNumericSeparator);
          } else if (forbiddenSiblings.indexOf(prev) > -1 || forbiddenSiblings.indexOf(next) > -1 || Number.isNaN(next)) {
            this.raise(this.state.pos, ErrorMessages.UnexpectedNumericSeparator);
          }

          if (!allowNumSeparator) {
            this.raise(this.state.pos, ErrorMessages.NumericSeparatorInEscapeSequence);
          }

          ++this.state.pos;
          continue;
        }

        if (code >= 97) {
          val = code - 97 + 10;
        } else if (code >= 65) {
          val = code - 65 + 10;
        } else if (_isDigit(code)) {
          val = code - 48;
        } else {
          val = Infinity;
        }

        if (val >= radix) {
          if (this.options.errorRecovery && val <= 9) {
            val = 0;
            this.raise(this.state.start + i + 2, ErrorMessages.InvalidDigit, radix);
          } else if (forceLen) {
            val = 0;
            invalid = true;
          } else {
            break;
          }
        }

        ++this.state.pos;
        total = total * radix + val;
      }

      if (this.state.pos === start || len != null && this.state.pos - start !== len || invalid) {
        return null;
      }

      return total;
    };

    _proto.readRadixNumber = function readRadixNumber(radix) {
      var start = this.state.pos;
      var isBigInt = false;
      this.state.pos += 2;
      var val = this.readInt(radix);

      if (val == null) {
        this.raise(this.state.start + 2, ErrorMessages.InvalidDigit, radix);
      }

      var next = this.input.charCodeAt(this.state.pos);

      if (next === 110) {
        ++this.state.pos;
        isBigInt = true;
      } else if (next === 109) {
        throw this.raise(start, ErrorMessages.InvalidDecimal);
      }

      if (isIdentifierStart(this.codePointAtPos(this.state.pos))) {
        throw this.raise(this.state.pos, ErrorMessages.NumberIdentifier);
      }

      if (isBigInt) {
        var str = this.input.slice(start, this.state.pos).replace(/[_n]/g, "");
        this.finishToken(types$1.bigint, str);
        return;
      }

      this.finishToken(types$1.num, val);
    };

    _proto.readNumber = function readNumber(startsWithDot) {
      var start = this.state.pos;
      var isFloat = false;
      var isBigInt = false;
      var isDecimal = false;
      var hasExponent = false;
      var isOctal = false;

      if (!startsWithDot && this.readInt(10) === null) {
        this.raise(start, ErrorMessages.InvalidNumber);
      }

      var hasLeadingZero = this.state.pos - start >= 2 && this.input.charCodeAt(start) === 48;

      if (hasLeadingZero) {
        var integer = this.input.slice(start, this.state.pos);
        this.recordStrictModeErrors(start, ErrorMessages.StrictOctalLiteral);

        if (!this.state.strict) {
          var underscorePos = integer.indexOf("_");

          if (underscorePos > 0) {
            this.raise(underscorePos + start, ErrorMessages.ZeroDigitNumericSeparator);
          }
        }

        isOctal = hasLeadingZero && !/[89]/.test(integer);
      }

      var next = this.input.charCodeAt(this.state.pos);

      if (next === 46 && !isOctal) {
        ++this.state.pos;
        this.readInt(10);
        isFloat = true;
        next = this.input.charCodeAt(this.state.pos);
      }

      if ((next === 69 || next === 101) && !isOctal) {
        next = this.input.charCodeAt(++this.state.pos);

        if (next === 43 || next === 45) {
          ++this.state.pos;
        }

        if (this.readInt(10) === null) {
          this.raise(start, ErrorMessages.InvalidOrMissingExponent);
        }

        isFloat = true;
        hasExponent = true;
        next = this.input.charCodeAt(this.state.pos);
      }

      if (next === 110) {
        if (isFloat || hasLeadingZero) {
          this.raise(start, ErrorMessages.InvalidBigIntLiteral);
        }

        ++this.state.pos;
        isBigInt = true;
      }

      if (next === 109) {
        this.expectPlugin("decimal", this.state.pos);

        if (hasExponent || hasLeadingZero) {
          this.raise(start, ErrorMessages.InvalidDecimal);
        }

        ++this.state.pos;
        isDecimal = true;
      }

      if (isIdentifierStart(this.codePointAtPos(this.state.pos))) {
        throw this.raise(this.state.pos, ErrorMessages.NumberIdentifier);
      }

      var str = this.input.slice(start, this.state.pos).replace(/[_mn]/g, "");

      if (isBigInt) {
        this.finishToken(types$1.bigint, str);
        return;
      }

      if (isDecimal) {
        this.finishToken(types$1.decimal, str);
        return;
      }

      var val = isOctal ? parseInt(str, 8) : parseFloat(str);
      this.finishToken(types$1.num, val);
    };

    _proto.readCodePoint = function readCodePoint(throwOnInvalid) {
      var ch = this.input.charCodeAt(this.state.pos);
      var code;

      if (ch === 123) {
        var codePos = ++this.state.pos;
        code = this.readHexChar(this.input.indexOf("}", this.state.pos) - this.state.pos, true, throwOnInvalid);
        ++this.state.pos;

        if (code !== null && code > 0x10ffff) {
          if (throwOnInvalid) {
            this.raise(codePos, ErrorMessages.InvalidCodePoint);
          } else {
            return null;
          }
        }
      } else {
        code = this.readHexChar(4, false, throwOnInvalid);
      }

      return code;
    };

    _proto.readString = function readString(quote) {
      var out = "",
          chunkStart = ++this.state.pos;

      for (;;) {
        if (this.state.pos >= this.length) {
          throw this.raise(this.state.start, ErrorMessages.UnterminatedString);
        }

        var ch = this.input.charCodeAt(this.state.pos);
        if (ch === quote) break;

        if (ch === 92) {
          out += this.input.slice(chunkStart, this.state.pos);
          out += this.readEscapedChar(false);
          chunkStart = this.state.pos;
        } else if (ch === 8232 || ch === 8233) {
          ++this.state.pos;
          ++this.state.curLine;
          this.state.lineStart = this.state.pos;
        } else if (isNewLine(ch)) {
          throw this.raise(this.state.start, ErrorMessages.UnterminatedString);
        } else {
          ++this.state.pos;
        }
      }

      out += this.input.slice(chunkStart, this.state.pos++);
      this.finishToken(types$1.string, out);
    };

    _proto.readTmplToken = function readTmplToken() {
      var out = "",
          chunkStart = this.state.pos,
          containsInvalid = false;

      for (;;) {
        if (this.state.pos >= this.length) {
          throw this.raise(this.state.start, ErrorMessages.UnterminatedTemplate);
        }

        var ch = this.input.charCodeAt(this.state.pos);

        if (ch === 96 || ch === 36 && this.input.charCodeAt(this.state.pos + 1) === 123) {
          if (this.state.pos === this.state.start && this.match(types$1.template)) {
            if (ch === 36) {
              this.state.pos += 2;
              this.finishToken(types$1.dollarBraceL);
              return;
            } else {
              ++this.state.pos;
              this.finishToken(types$1.backQuote);
              return;
            }
          }

          out += this.input.slice(chunkStart, this.state.pos);
          this.finishToken(types$1.template, containsInvalid ? null : out);
          return;
        }

        if (ch === 92) {
          out += this.input.slice(chunkStart, this.state.pos);
          var escaped = this.readEscapedChar(true);

          if (escaped === null) {
            containsInvalid = true;
          } else {
            out += escaped;
          }

          chunkStart = this.state.pos;
        } else if (isNewLine(ch)) {
          out += this.input.slice(chunkStart, this.state.pos);
          ++this.state.pos;

          switch (ch) {
            case 13:
              if (this.input.charCodeAt(this.state.pos) === 10) {
                ++this.state.pos;
              }

            case 10:
              out += "\n";
              break;

            default:
              out += String.fromCharCode(ch);
              break;
          }

          ++this.state.curLine;
          this.state.lineStart = this.state.pos;
          chunkStart = this.state.pos;
        } else {
          ++this.state.pos;
        }
      }
    };

    _proto.recordStrictModeErrors = function recordStrictModeErrors(pos, message) {
      if (this.state.strict && !this.state.strictErrors.has(pos)) {
        this.raise(pos, message);
      } else {
        this.state.strictErrors.set(pos, message);
      }
    };

    _proto.readEscapedChar = function readEscapedChar(inTemplate) {
      var throwOnInvalid = !inTemplate;
      var ch = this.input.charCodeAt(++this.state.pos);
      ++this.state.pos;

      switch (ch) {
        case 110:
          return "\n";

        case 114:
          return "\r";

        case 120:
          {
            var code = this.readHexChar(2, false, throwOnInvalid);
            return code === null ? null : String.fromCharCode(code);
          }

        case 117:
          {
            var _code = this.readCodePoint(throwOnInvalid);

            return _code === null ? null : String.fromCodePoint(_code);
          }

        case 116:
          return "\t";

        case 98:
          return "\b";

        case 118:
          return "\x0B";

        case 102:
          return "\f";

        case 13:
          if (this.input.charCodeAt(this.state.pos) === 10) {
            ++this.state.pos;
          }

        case 10:
          this.state.lineStart = this.state.pos;
          ++this.state.curLine;

        case 8232:
        case 8233:
          return "";

        case 56:
        case 57:
          if (inTemplate) {
            return null;
          } else {
            this.recordStrictModeErrors(this.state.pos - 1, ErrorMessages.StrictNumericEscape);
          }

        default:
          if (ch >= 48 && ch <= 55) {
            var codePos = this.state.pos - 1;
            var match = this.input.substr(this.state.pos - 1, 3).match(/^[0-7]+/);
            var octalStr = match[0];
            var octal = parseInt(octalStr, 8);

            if (octal > 255) {
              octalStr = octalStr.slice(0, -1);
              octal = parseInt(octalStr, 8);
            }

            this.state.pos += octalStr.length - 1;
            var next = this.input.charCodeAt(this.state.pos);

            if (octalStr !== "0" || next === 56 || next === 57) {
              if (inTemplate) {
                return null;
              } else {
                this.recordStrictModeErrors(codePos, ErrorMessages.StrictNumericEscape);
              }
            }

            return String.fromCharCode(octal);
          }

          return String.fromCharCode(ch);
      }
    };

    _proto.readHexChar = function readHexChar(len, forceLen, throwOnInvalid) {
      var codePos = this.state.pos;
      var n = this.readInt(16, len, forceLen, false);

      if (n === null) {
        if (throwOnInvalid) {
          this.raise(codePos, ErrorMessages.InvalidEscapeSequence);
        } else {
          this.state.pos = codePos - 1;
        }
      }

      return n;
    };

    _proto.readWord1 = function readWord1(firstCode) {
      this.state.containsEsc = false;
      var word = "";
      var start = this.state.pos;
      var chunkStart = this.state.pos;

      if (firstCode !== undefined) {
        this.state.pos += firstCode <= 0xffff ? 1 : 2;
      }

      while (this.state.pos < this.length) {
        var ch = this.codePointAtPos(this.state.pos);

        if (isIdentifierChar(ch)) {
          this.state.pos += ch <= 0xffff ? 1 : 2;
        } else if (ch === 92) {
          this.state.containsEsc = true;
          word += this.input.slice(chunkStart, this.state.pos);
          var escStart = this.state.pos;
          var identifierCheck = this.state.pos === start ? isIdentifierStart : isIdentifierChar;

          if (this.input.charCodeAt(++this.state.pos) !== 117) {
            this.raise(this.state.pos, ErrorMessages.MissingUnicodeEscape);
            chunkStart = this.state.pos - 1;
            continue;
          }

          ++this.state.pos;
          var esc = this.readCodePoint(true);

          if (esc !== null) {
            if (!identifierCheck(esc)) {
              this.raise(escStart, ErrorMessages.EscapedCharNotAnIdentifier);
            }

            word += String.fromCodePoint(esc);
          }

          chunkStart = this.state.pos;
        } else {
          break;
        }
      }

      return word + this.input.slice(chunkStart, this.state.pos);
    };

    _proto.readWord = function readWord(firstCode) {
      var word = this.readWord1(firstCode);
      var type = keywords.get(word) || types$1.name;
      this.finishToken(type, word);
    };

    _proto.checkKeywordEscapes = function checkKeywordEscapes() {
      var kw = this.state.type.keyword;

      if (kw && this.state.containsEsc) {
        this.raise(this.state.start, ErrorMessages.InvalidEscapedReservedWord, kw);
      }
    };

    _proto.updateContext = function updateContext(prevType) {
      var _this$state$type$upda, _this$state$type;

      (_this$state$type$upda = (_this$state$type = this.state.type).updateContext) == null ? void 0 : _this$state$type$upda.call(_this$state$type, this.state.context);
    };

    return Tokenizer;
  }(ParserError);

  var ClassScope = function ClassScope() {
    this.privateNames = new Set();
    this.loneAccessors = new Map();
    this.undefinedPrivateNames = new Map();
  };

  var ClassScopeHandler = function () {
    function ClassScopeHandler(raise) {
      this.stack = [];
      this.undefinedPrivateNames = new Map();
      this.raise = raise;
    }

    var _proto = ClassScopeHandler.prototype;

    _proto.current = function current() {
      return this.stack[this.stack.length - 1];
    };

    _proto.enter = function enter() {
      this.stack.push(new ClassScope());
    };

    _proto.exit = function exit() {
      var oldClassScope = this.stack.pop();
      var current = this.current();

      for (var _i2 = 0, _Array$from2 = Array.from(oldClassScope.undefinedPrivateNames); _i2 < _Array$from2.length; _i2++) {
        var _Array$from2$_i = _Array$from2[_i2],
            name = _Array$from2$_i[0],
            pos = _Array$from2$_i[1];

        if (current) {
          if (!current.undefinedPrivateNames.has(name)) {
            current.undefinedPrivateNames.set(name, pos);
          }
        } else {
          this.raise(pos, ErrorMessages.InvalidPrivateFieldResolution, name);
        }
      }
    };

    _proto.declarePrivateName = function declarePrivateName(name, elementType, pos) {
      var classScope = this.current();
      var redefined = classScope.privateNames.has(name);

      if (elementType & CLASS_ELEMENT_KIND_ACCESSOR) {
        var accessor = redefined && classScope.loneAccessors.get(name);

        if (accessor) {
          var oldStatic = accessor & CLASS_ELEMENT_FLAG_STATIC;
          var newStatic = elementType & CLASS_ELEMENT_FL