import { normalizeReplacements } from "./options.js";
import parseAndBuildMetadata from "./parse.js";
import populatePlaceholders from "./populate.js";
export default function stringTemplate(formatter, code, opts) {
  code = formatter.code(code);
  let metadata;
  return arg => {
    const replacements = normalizeReplacements(arg);
    if (!metadata) metadata = parseAndBuildMetadata(formatter, code, opts);
    return formatter.unwrap(populatePlaceholders(metadata, replacements));
  };
}

//# sourceMappingURL=string.js.map
