import { traverseNode } from "../traverse-node.js";
import { SHOULD_SKIP, SHOULD_STOP } from "./index.js";
export function call(key) {
  const opts = this.opts;
  this.debug(key);
  if (this.node) {
    if (this._call(opts[key])) return true;
  }
  if (this.node) {
    return this._call(opts[this.node.type]?.[key]);
  }
  return false;
}
export function _call(fns) {
  if (!fns) return false;
  for (const fn of fns) {
    if (!fn) continue;
    const node = this.node;
    if (!node) return true;
    const ret = fn.call(this.state, this, this.state);
    if (ret && typeof ret === "object" && typeof ret.then === "function") {
      throw new Error(`You appear to be using a plugin with an async traversal visitor, ` + `which your current version of Babel does not support. ` + `If you're using a published plugin, you may need to upgrade ` + `your @babel/core version.`);
    }
    if (ret) {
      throw new Error(`Unexpected return value from visitor method ${fn}`);
    }
    if (this.node !== node) return true;
    if (this._traverseFlags > 0) return true;
  }
  return false;
}
export function isDenylisted() {
  const denylist = this.opts.denylist ?? this.opts.blacklist;
  return denylist && denylist.indexOf(this.node.type) > -1;
}
export { isDenylisted as isBlacklisted };
function restoreContext(path, context) {
  if (path.context !== context) {
    path.context = context;
    path.state = context.state;
    path.opts = context.opts;
  }
}
export function visit() {
  if (!this.node) {
    return false;
  }
  if (this.isDenylisted()) {
    return false;
  }
  if (this.opts.shouldSkip?.(this)) {
    return false;
  }
  const currentContext = this.context;
  if (this.shouldSkip || this.call("enter")) {
    this.debug("Skip...");
    return this.shouldStop;
  }
  restoreContext(this, currentContext);
  this.debug("Recursing into...");
  this.shouldStop = traverseNode(this.node, this.opts, this.scope, this.state, this, this.skipKeys);
  restoreContext(this, currentContext);
  this.call("exit");
  return this.shouldStop;
}
export function skip() {
  this.shouldSkip = true;
}
export function skipKey(key) {
  if (this.skipKeys == null) {
    this.skipKeys = {};
  }
  this.skipKeys[key] = true;
}
export function stop() {
  this._traverseFlags |= SHOULD_SKIP | SHOULD_STOP;
}
export function setScope() {
  if (this.opts?.noScope) return;
  let path = this.parentPath;
  if ((this.key === "key" || this.listKey === "decorators") && path.isMethod() || this.key === "discriminant" && path.isSwitchStatement()) {
    path = path.parentPath;
  }
  let target;
  while (path && !target) {
    if (path.opts?.noScope) return;
    target = path.scope;
    path = path.parentPath;
  }
  this.scope = this.getScope(target);
  this.scope?.init();
}
export function setContext(context) {
  if (this.skipKeys != null) {
    this.skipKeys = {};
  }
  this._traverseFlags = 0;
  if (context) {
    this.context = context;
    this.state = context.state;
    this.opts = context.opts;
  }
  this.setScope();
  return this;
}
export function resync() {
  if (this.removed) return;
  this._resyncParent();
  this._resyncList();
  this._resyncKey();
}
export function _resyncParent() {
  if (this.parentPath) {
    this.parent = this.parentPath.node;
  }
}
export function _resyncKey() {
  if (!this.container) return;
  if (this.node === this.container[this.key]) {
    return;
  }
  if (Array.isArray(this.container)) {
    for (let i = 0; i < this.container.length; i++) {
      if (this.container[i] === this.node) {
        this.setKey(i);
        return;
      }
    }
  } else {
    for (const key of Object.keys(this.container)) {
      if (this.container[key] === this.node) {
        this.setKey(key);
        return;
      }
    }
  }
  this.key = null;
}
export function _resyncList() {
  if (!this.parent || !this.inList) return;
  const newContainer = this.parent[this.listKey];
  if (this.container === newContainer) return;
  this.container = newContainer || null;
}
export function _resyncRemoved() {
  if (this.key == null || !this.container || this.container[this.key] !== this.node) {
    this._markRemoved();
  }
}
export function popContext() {
  this.contexts.pop();
  if (this.contexts.length > 0) {
    this.setContext(this.contexts[this.contexts.length - 1]);
  } else {
    this.setContext(undefined);
  }
}
export function pushContext(context) {
  this.contexts.push(context);
  this.setContext(context);
}
export function setup(parentPath, container, listKey, key) {
  this.listKey = listKey;
  this.container = container;
  this.parentPath = parentPath || this.parentPath;
  this.setKey(key);
}
export function setKey(key) {
  this.key = key;
  this.node = this.container[this.key];
  this.type = this.node?.type;
}
export function requeue(pathToQueue = this) {
  if (pathToQueue.removed) return;
  {
    pathToQueue.shouldSkip = false;
  }
  const contexts = this.contexts;
  for (const context of contexts) {
    context.maybeQueue(pathToQueue);
  }
}
export function _getQueueContexts() {
  let path = this;
  let contexts = this.contexts;
  while (!contexts.length) {
    path = path.parentPath;
    if (!path) break;
    contexts = path.contexts;
  }
  return contexts;
}

//# sourceMappingURL=context.js.map
