import * as virtualTypes from "./lib/virtual-types.js";
import buildDebug from "debug";
import traverse from "../index.js";
import Scope from "../scope/index.js";
import * as _t from "@babel/types";
const {
  validate
} = _t;
import * as t from "@babel/types";
import { path as pathCache } from "../cache.js";
import generator from "@babel/generator";
import * as NodePath_ancestry from "./ancestry.js";
import * as NodePath_inference from "./inference/index.js";
import * as NodePath_replacement from "./replacement.js";
import * as NodePath_evaluation from "./evaluation.js";
import * as NodePath_conversion from "./conversion.js";
import * as NodePath_introspection from "./introspection.js";
import * as NodePath_context from "./context.js";
import * as NodePath_removal from "./removal.js";
import * as NodePath_modification from "./modification.js";
import * as NodePath_family from "./family.js";
import * as NodePath_comments from "./comments.js";
import * as NodePath_virtual_types_validator from "./lib/virtual-types-validator.js";
const debug = buildDebug("babel");
export const REMOVED = 1 << 0;
export const SHOULD_STOP = 1 << 1;
export const SHOULD_SKIP = 1 << 2;
class NodePath {
  constructor(hub, parent) {
    this.parent = parent;
    this.hub = hub;
    this.data = null;
    this.context = null;
    this.scope = null;
  }
  contexts = [];
  state = null;
  opts = null;
  _traverseFlags = 0;
  skipKeys = null;
  parentPath = null;
  container = null;
  listKey = null;
  key = null;
  node = null;
  type = null;
  static get({
    hub,
    parentPath,
    parent,
    container,
    listKey,
    key
  }) {
    if (!hub && parentPath) {
      hub = parentPath.hub;
    }
    if (!parent) {
      throw new Error("To get a node path the parent needs to exist");
    }
    const targetNode = container[key];
    let paths = pathCache.get(parent);
    if (!paths) {
      paths = new Map();
      pathCache.set(parent, paths);
    }
    let path = paths.get(targetNode);
    if (!path) {
      path = new NodePath(hub, parent);
      if (targetNode) paths.set(targetNode, path);
    }
    path.setup(parentPath, container, listKey, key);
    return path;
  }
  getScope(scope) {
    return this.isScope() ? new Scope(this) : scope;
  }
  setData(key, val) {
    if (this.data == null) {
      this.data = Object.create(null);
    }
    return this.data[key] = val;
  }
  getData(key, def) {
    if (this.data == null) {
      this.data = Object.create(null);
    }
    let val = this.data[key];
    if (val === undefined && def !== undefined) val = this.data[key] = def;
    return val;
  }
  hasNode() {
    return this.node != null;
  }
  buildCodeFrameError(msg, Error = SyntaxError) {
    return this.hub.buildError(this.node, msg, Error);
  }
  traverse(visitor, state) {
    traverse(this.node, visitor, this.scope, state, this);
  }
  set(key, node) {
    validate(this.node, key, node);
    this.node[key] = node;
  }
  getPathLocation() {
    const parts = [];
    let path = this;
    do {
      let key = path.key;
      if (path.inList) key = `${path.listKey}[${key}]`;
      parts.unshift(key);
    } while (path = path.parentPath);
    return parts.join(".");
  }
  debug(message) {
    if (!debug.enabled) return;
    debug(`${this.getPathLocation()} ${this.type}: ${message}`);
  }
  toString() {
    return generator(this.node).code;
  }
  get inList() {
    return !!this.listKey;
  }
  set inList(inList) {
    if (!inList) {
      this.listKey = null;
    }
  }
  get parentKey() {
    return this.listKey || this.key;
  }
  get shouldSkip() {
    return !!(this._traverseFlags & SHOULD_SKIP);
  }
  set shouldSkip(v) {
    if (v) {
      this._traverseFlags |= SHOULD_SKIP;
    } else {
      this._traverseFlags &= ~SHOULD_SKIP;
    }
  }
  get shouldStop() {
    return !!(this._traverseFlags & SHOULD_STOP);
  }
  set shouldStop(v) {
    if (v) {
      this._traverseFlags |= SHOULD_STOP;
    } else {
      this._traverseFlags &= ~SHOULD_STOP;
    }
  }
  get removed() {
    return !!(this._traverseFlags & REMOVED);
  }
  set removed(v) {
    if (v) {
      this._traverseFlags |= REMOVED;
    } else {
      this._traverseFlags &= ~REMOVED;
    }
  }
}
Object.assign(NodePath.prototype, NodePath_ancestry, NodePath_inference, NodePath_replacement, NodePath_evaluation, NodePath_conversion, NodePath_introspection, NodePath_context, NodePath_removal, NodePath_modification, NodePath_family, NodePath_comments);
;
for (const type of t.TYPES) {
  const typeKey = `is${type}`;
  const fn = t[typeKey];
  NodePath.prototype[typeKey] = function (opts) {
    return fn(this.node, opts);
  };
  NodePath.prototype[`assert${type}`] = function (opts) {
    if (!fn(this.node, opts)) {
      throw new TypeError(`Expected node path of type ${type}`);
    }
  };
}
Object.assign(NodePath.prototype, NodePath_virtual_types_validator);
for (const type of Object.keys(virtualTypes)) {
  if (type[0] === "_") continue;
  if (!t.TYPES.includes(type)) t.TYPES.push(type);
}
export default NodePath;

//# sourceMappingURL=index.js.map
