import TraversalContext from "./context.js";
import * as _t from "@babel/types";
const {
  VISITOR_KEYS
} = _t;
export function traverseNode(node, opts, scope, state, path, skipKeys) {
  const keys = VISITOR_KEYS[node.type];
  if (!keys) return false;
  const context = new TraversalContext(scope, opts, state, path);
  for (const key of keys) {
    if (skipKeys && skipKeys[key]) continue;
    if (context.visit(node, key)) {
      return true;
    }
  }
  return false;
}

//# sourceMappingURL=traverse-node.js.map
