export declare const ISO_PATTERN = "yyyy-MM-dd";
export declare const DATE_PATTERN = "dd-MM-yyyy";
export declare const TIMEZONE = "T00:00:00.000Z";
/**
 * Returns a JS Date instance of the exact moment
 *
 * ```typescript
 * const date = now()
 * // Wed Mar 10 2021 20:30:32 GMT+0100 (Central European Standard Time)
 * ```
 */
export declare function now(): Date;
/**
 * Returns a JS Date instance of today with time being set to 0
 *
 * ```typescript
 * const date = today()
 * // Wed Mar 10 2021 00:00:00 GMT+0100 (Central European Standard Time)
 * ```
 */
export declare function today(): Date;
/**
 * Returns a JS Date instance with time being set to 0
 *
 * ```typescript
 * const date = floorTime(new Date())
 * // Wed Mar 10 2021 00:00:00 GMT+0100 (Central European Standard Time)
 * ```
 */
export declare function floorTime(date: Date): Date;
/**
 * Returns a JS Date instance with the time set to the possible end
 *
 * ```typescript
 * const date = ceilTime(new Date())
 * // Wed Mar 10 2021 23:59:59 GMT+0100 (Central European Standard Time)
 * ```
 */
export declare function ceilTime(date: Date): Date;
/**
 * Return the formatted date string in ISO 8601 format. Options may be passed to control the parts and notations of the date.
 *
 * ```typescript
 * const dateString = formatDateString(new Date())
 * // '2022-02-14'
 * ```
 */
export declare function formatDateString(date: Date): string;
/**
 * Validates if the given date string matches the iso date format.
 *
 * ```typescript
 * isValidIsoString('2022-02-14')
 * // 'true'
 * ```
 */
export declare function isValidIsoString(dateString: string | undefined | null): boolean;
/**
 * Formats the dates according to the given locale.
 *
 * ```typescript
 * format('de-CH', new Date())
 * // '14.2.2022'
 * ```
 */
export declare function format(locale?: string, date?: Date): string;
/**
 * Parses the iso date string into a javascript date object.
 *
 * ```typescript
 * const dateString = parse('2021-03-10')
 * // Wed Mar 10 2021 00:00:00 GMT+0100 (Central European Standard Time)
 * ```
 */
export declare function parse(dateString: string, locale?: string): Date | undefined;
/**
 * Returns the char which separates day form month and year.
 *
 * ```typescript
 * dateSeparator('de-CH')
 * // .
 * ```
 */
export declare function dateSeparator(locale?: string): string;
