/**
 * Returns `true` if the arrays are equal
 *
 * ```typescript
 * isValidMonetaryNumber(`1'000.99`) // true
 * ```
 */
export declare function isValidMonetaryNumber(stringValue: string): boolean;
/**
 * Returns the decimal separator of the given locale
 *
 * ```typescript
 * getDecimalSeparator('de-ch') // .
 * ```
 */
export declare function getDecimalSeparator(locale?: string): string;
/**
 * Returns the thousand separator of the given locale
 *
 * ```typescript
 * getThousandSeparator('de-ch') // '
 * ```
 */
export declare function getThousandSeparator(locale?: string): string;
/**
 * Formats the number into the given locale
 *
 * ```typescript
 * formatLocaleNumber('de-ch', 1000.42) // 1'000.42
 * ```
 */
export declare function formatLocaleNumber(locale: string, number: number, minimumFractionDigits?: number): string;
/**
 * Parses the locale formatted number into a native number
 *
 * ```typescript
 * parseLocaleNumber('de-ch', '1'000.42') // 1000.42
 * ```
 */
export declare function parseLocaleNumber(locale: string, stringNumber: string): number;
