export { BalValidatorFn } from './validator.type';
import { isCustom } from './custom.validators';
import { isBefore, isAfter, isDate } from './date.validators';
import { isMin, isMax, isNumber, isMonetaryNumber } from './number.validators';
import { matchesRegex, isEmail, isPhone } from './regex.validators';
import { isRequired, isRequiredTrue } from './required.validators';
import { isMinLength, isMaxLength } from './string.validators';
import { validateConditionally } from './validateConditionally.validators';
export declare const BalValidators: {
    isCustom: typeof isCustom;
    isBefore: typeof isBefore;
    isAfter: typeof isAfter;
    isDate: typeof isDate;
    isMin: typeof isMin;
    isMax: typeof isMax;
    isNumber: typeof isNumber;
    isMonetaryNumber: typeof isMonetaryNumber;
    matchesRegex: typeof matchesRegex;
    isEmail: typeof isEmail;
    isPhone: typeof isPhone;
    isRequired: typeof isRequired;
    isRequiredTrue: typeof isRequiredTrue;
    isMinLength: typeof isMinLength;
    isMaxLength: typeof isMaxLength;
    validateConditionally: typeof validateConditionally;
};
