import { BalValidatorFn } from './validator.type';
/**
 * Returns `true` if the number is bigger or equal than the min number
 *
 * ```typescript
 * BalValidators.isMin(10)(10) // true
 * BalValidators.isMin(10)(11) // true
 * BalValidators.isMin(10)(9) // false
 * ```
 */
export declare function isMin(min: number): BalValidatorFn;
/**
 * Returns `true` if the number is smaller or equal than the max number
 *
 * ```typescript
 * BalValidators.isMax(10)(10) // true
 * BalValidators.isMax(10)(9) // true
 * BalValidators.isMax(10)(11) // false
 * ```
 */
export declare function isMax(max: number): BalValidatorFn;
/**
 * Returns `true` if the number is valid
 *
 * ```typescript
 * BalValidators.isNumber()(10) // true
 * BalValidators.isNumber()('10') // true
 * BalValidators.isNumber()('a') // false
 * ```
 */
export declare function isNumber(): BalValidatorFn;
/**
 * Returns `true` if the value is a valid formatted number
 *
 * ```typescript
 * BalValidators.isMonetaryNumber()(10) // true
 * BalValidators.isMonetaryNumber()(`1'000.99`) // true
 * BalValidators.isMonetaryNumber()(`a`) // false
 * ```
 */
export declare function isMonetaryNumber(): BalValidatorFn;
