import { BalValidatorFn } from './validator.type';
/**
 * Returns `true` if the value matches the regex
 *
 * ```typescript
 * BalValidators.matchesRegex(new RegExp('^\\d+$'))('1') // true
 * ```
 */
export declare function matchesRegex(regex: RegExp): BalValidatorFn;
/**
 * Returns `true` if the value matches the regex
 *
 * ```typescript
 * BalValidators.isEmail()('peter@baloise.ch') // true
 * ```
 */
export declare function isEmail(): BalValidatorFn;
/**
 * Returns `true` if the value matches the regex
 *
 * ```typescript
 * BalValidators.isPhone()('123 456 78 90') // true
 * ```
 */
export declare function isPhone(): BalValidatorFn;
