/**
 * Irish (Gaeilge) language functions
 */
import BananaLanguage from './language'

export default class IrishLanguage extends BananaLanguage {
  convertGrammar (word, form) {
    if (form === 'ainmlae') {
      switch (word) {
        case 'an Domhnach':
          word = 'Dé Domhnaigh'
          break
        case 'an Luan':
          word = 'Dé Luain'
          break
        case 'an Mháirt':
          word = 'Dé Mháirt'
          break
        case 'an Chéadaoin':
          word = 'Dé Chéadaoin'
          break
        case 'an Déardaoin':
          word = 'Déardaoin'
          break
        case 'an Aoine':
          word = 'Dé hAoine'
          break
        case 'an Satharn':
          word = 'Dé Sathairn'
          break
      }
    }

    return word
  }
}
