# BangJS
Reactive Angular :boom:


## Overview

Program watertight web-based user interface behavior with [AngularJS](https://angularjs.org/) and [Bacon.js](https://baconjs.github.io/).

Enjoy everything that’s good about [functional reactive programming](https://gist.github.com/staltz/868e7e9bc2a7b8c1f754) with all the benefits of a mature and vibrant front-end framework ecosystem.

The nature of user interfaces and front-end apps in general is inherently asynchronous. Servers and users have one thing in common: you never know when they decide to talk to you. BangJS offers you the tools to take this challenge head on:

* make support for asynchronous logic the default;
* focus on your business logic instead of managing state;
* keep your code maintainable and scalable due to inherent composability.

No need to go all-in, no lock-ins. It's all pretty unpretentious, [go see for yourself](https://github.com/bangjs/bangjs/blob/master/doc/build/bang/bang.md)!


## Documentation

[Quick code sample and main API docs](https://github.com/bangjs/bangjs/blob/master/doc/build/bang/bang.md).


## Demo

Concise and compliant implementation of the [TodoMVC](http://todomvc.com/) benchmark app:

* [Source code](https://github.com/bangjs/todomvc/)
* [Live app](http://bangjs.org/todomvc/)


## About

BangJS was created by [Tim Molendijk](https://twitter.com/timmolendijk), uses [Bacon.Circuit](https://github.com/bangjs/bacon.circuit/) internally and is currently in production use at [Nouncy](http://nouncy.com/).

Contributions are welcomed. Feel free to [email me](https://github.com/bangjs/bangjs/blob/master/package.json#L25) or send in an issue or pull request.

* [Home page](http://bangjs.org/)
* [Release history](https://github.com/bangjs/bangjs/blob/master/CHANGES.md)
* [License](http://timmolendijk.mit-license.org/)