
Base structural styles, resets, and colors for buttons are set with this module.
All buttons share common padding and height, well suited for tap targets on touchscreen displays, and align with form inputs and selects.

Use the `.btn` class to style buttons, input buttons, and links.

```html
<div class="mb1">
  <button class="btn">Button</button>
  <a href="#!" class="btn">Link Button</a>
  <input type="button" class="btn" value="Input Button">
</div>
```

Note: adjusting the line-height and padding variables may require adjustments to form element variables to maintain vertical alignment.

By default elements with the `.btn` class have transparent backgrounds. Use color utilities or `.btn` color styles to adjust the appearance.

