# Basscss

Low-level CSS toolkit <http://basscss.com>

[![Build Status](https://travis-ci.org/basscss/basscss.svg)](https://travis-ci.org/basscss/basscss)
[![npm version](https://badge.fury.io/js/basscss.svg)](https://badge.fury.io/js/basscss)

## Lightning-Fast Modular CSS with No Side Effects

Basscss is a lightweight collection of immutable utilities designed for speed, clarity, performance, and scalability.


## Features

### Code with Confidence

Using clear, humanized naming conventions, Basscss is quick to internalize
and easy to reason about while speeding up development time with more scalable,
more readable code.

### No Side Effects

Things behave exactly as expected with immutable utilities
and styles that follow the open/closed principle
to help prevent common pitfalls with CSS.

### Composable

Reusable, interoperable styles
work like building blocks to lay the foundation for any stylesheet
and can be mixed and matched in any number of combinations.

## Designed for Design

Basscss strikes a balance between consistency and flexibility
to allow for rapid prototyping and quick iterative changes
when designing in the browser.

## Responsive by Default

Basscss provides lightweight, performant styles
and flexible utilities to design for any device
and to help reduce boilerplate in stylesheets.

## Unassuming

Modular and customizable typography and layout styles don’t dictate
what things should look like and play well with other stylesheets and frameworks.

[Read More](http://basscss.com)

---

## Contributing

See [CONTRIBUTING.md](CONTRIBUTING.md)

---

[MIT license](LICENSE.md)

