# Protractor rules for Bazel

The Protractor rules run tests under the Protractor framework with Bazel.


## Installation

Add the `@bazel/protractor` npm package to your `devDependencies` in `package.json`.

Your `WORKSPACE` should declare a `yarn_install` or `npm_install` rule named `npm`.
It should then install the rules found in the npm packages using the `install_bazel_dependencies' function.
See https://github.com/bazelbuild/rules_nodejs/#quickstart

This causes the `@bazel/protractor` package to be installed as a Bazel workspace named `npm_bazel_protractor`.

[name]: https://bazel.build/docs/build-ref.html#name
[label]: https://bazel.build/docs/build-ref.html#labels
[labels]: https://bazel.build/docs/build-ref.html#labels


## protractor_web_test

Runs a protractor test in a browser.


### Usage

```
protractor_web_test(name, configuration, on_prepare, srcs, deps, data, server, tags, peer_deps, protractor_entry_point, kwargs)
```



#### `name`
      
The name of the test




#### `configuration`
      
Protractor configuration file.

Defaults to `None`



#### `on_prepare`
      
A file with a node.js script to run once before all tests run.
    If the script exports a function which returns a promise, protractor
    will wait for the promise to resolve before beginning tests.

Defaults to `None`



#### `srcs`
      
JavaScript source files

Defaults to `[]`



#### `deps`
      
Other targets which produce JavaScript such as `ts_library`

Defaults to `[]`



#### `data`
      
Runtime dependencies

Defaults to `[]`



#### `server`
      
Optional server executable target

Defaults to `None`



#### `tags`
      
Standard Bazel tags, this macro adds one for ibazel

Defaults to `[]`



#### `peer_deps`
      
List of peer npm deps required by protractor_web_test.

Defaults to `["@npm//@bazel/protractor", "@npm//protractor"]`



#### `protractor_entry_point`
      
A label providing the @npm//protractor entry point.
    Default to `@npm//:node_modules/protractor/bin/protractor`.

Defaults to `"@npm//:node_modules/protractor/bin/protractor"`



#### `kwargs`
      
passed through to `protractor_web_test`






## protractor_web_test_suite

Defines a test_suite of web_test targets that wrap a protractor_web_test target.


### Usage

```
protractor_web_test_suite(name, browsers, web_test_data, wrapped_test_tags, kwargs)
```



#### `name`
      
The base name of the test




#### `browsers`
      
A sequence of labels specifying the browsers to use.

Defaults to `None`



#### `web_test_data`
      
Data dependencies for the wrapoer web_test targets.

Defaults to `[]`



#### `wrapped_test_tags`
      
A list of test tag strings to use for the wrapped
  karma_web_test target.

Defaults to `["manual", "noci"]`



#### `kwargs`
      
Arguments for the wrapped karma_web_test target.





