var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/* eslint max-lines: 0 */

import { ZalgoPromise } from 'zalgo-promise/src';
import { WeakMap } from 'cross-domain-safe-weakmap/src';

export function base64encode(str) {
    if (typeof btoa === 'function') {
        return btoa(str);
    } else if (typeof Buffer !== 'undefined') {
        return Buffer.from(str, 'utf8').toString('base64');
    }

    throw new Error('Can not find window.btoa or Buffer');
}

export function base64decode(str) {
    if (typeof window !== 'undefined' && typeof window.atob === 'function') {
        return window.atob(str);
    }

    if (typeof Buffer !== 'undefined') {
        return Buffer.from(str, 'base64').toString('utf8');
    }

    throw new Error('Can not find window.atob or Buffer');
}

export function uniqueID() {

    var chars = '0123456789abcdef';

    var randomID = 'xxxxxxxxxx'.replace(/./g, function () {
        return chars.charAt(Math.floor(Math.random() * chars.length));
    });

    var timeID = base64encode(new Date().toISOString().slice(11, 19).replace('T', '.')).replace(/[^a-zA-Z0-9]/g, '').toLowerCase();

    return randomID + '_' + timeID;
}

export function getGlobal() {
    if (typeof window !== 'undefined') {
        return window;
    }
    if (typeof global !== 'undefined') {
        return global;
    }
    if (typeof __GLOBAL__ !== 'undefined') {
        return __GLOBAL__;
    }
    throw new Error('No global found');
}

var objectIDs = void 0;

export function getObjectID(obj) {

    objectIDs = objectIDs || new WeakMap();

    if (obj === null || obj === undefined || (typeof obj === 'undefined' ? 'undefined' : _typeof(obj)) !== 'object' && typeof obj !== 'function') {
        throw new Error('Invalid object');
    }

    var uid = objectIDs.get(obj);

    if (!uid) {
        uid = (typeof obj === 'undefined' ? 'undefined' : _typeof(obj)) + ':' + uniqueID();
        objectIDs.set(obj, uid);
    }

    return uid;
}

function serializeArgs(args) {
    try {
        return JSON.stringify(Array.prototype.slice.call(args), function (subkey, val) {
            if (typeof val === 'function') {
                return 'memoize[' + getObjectID(val) + ']';
            }
            return val;
        });
    } catch (err) {
        throw new Error('Arguments not serializable -- can not be used to memoize');
    }
}
export function memoize(method) {
    var _this = this;

    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var cacheMap = new WeakMap();

    // $FlowFixMe
    var memoizedFunction = function memoizedFunction() {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        var cache = cacheMap.getOrSet(options.thisNamespace ? this : method, function () {
            return {};
        });

        var key = serializeArgs(args);

        var cacheTime = options.time;
        if (cache[key] && cacheTime && Date.now() - cache[key].time < cacheTime) {
            delete cache[key];
        }

        if (cache[key]) {
            return cache[key].value;
        }

        var time = Date.now();
        var value = method.apply(this, arguments);

        cache[key] = { time: time, value: value };

        return cache[key].value;
    };

    memoizedFunction.reset = function () {
        cacheMap['delete'](options.thisNamespace ? _this : method);
    };

    if (options.name) {
        memoizedFunction.displayName = options.name + ':memoized';
    }

    return memoizedFunction;
}

// eslint-disable-next-line flowtype/no-weak-types
export function memoizePromise(method) {
    var cache = {};

    // eslint-disable-next-line flowtype/no-weak-types
    function memoizedPromiseFunction() {
        var _this2 = this,
            _arguments = arguments;

        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
        }

        var key = serializeArgs(args);

        if (cache.hasOwnProperty(key)) {
            return cache[key];
        }

        cache[key] = ZalgoPromise['try'](function () {
            return method.apply(_this2, _arguments);
        })['finally'](function () {
            delete cache[key];
        });

        return cache[key];
    }

    memoizedPromiseFunction.reset = function () {
        cache = {};
    };

    return memoizedPromiseFunction;
}

// eslint-disable-next-line flowtype/no-weak-types
export function promisify(method) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    function promisifiedFunction() {
        return ZalgoPromise['try'](method, this, arguments);
    }

    if (options.name) {
        promisifiedFunction.displayName = options.name + ':promisified';
    }

    return promisifiedFunction;
}

// eslint-disable-next-line flowtype/no-weak-types
export function inlineMemoize(method, logic) {
    var args = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

    // $FlowFixMe
    var cache = method.__inline_memoize_cache__ = method.__inline_memoize_cache__ || {};
    var key = serializeArgs(args);

    if (cache.hasOwnProperty(key)) {
        return cache[key];
    }

    var result = cache[key] = logic.apply(undefined, args);
    return result;
}

// eslint-disable-next-line no-unused-vars
export function noop() {
    // pass
}

export function once(method) {
    var called = false;

    return function onceFunction() {
        if (!called) {
            called = true;
            return method.apply(this, arguments);
        }
    };
}

export function hashStr(str) {
    var hash = 0;
    for (var i = 0; i < str.length; i++) {
        hash += str[i].charCodeAt(0) * Math.pow(i % 10 + 1, 5);
    }
    return Math.floor(Math.pow(Math.sqrt(hash), 5));
}

export function strHashStr(str) {
    var hash = '';

    for (var i = 0; i < str.length; i++) {
        var total = str[i].charCodeAt(0) * i;

        if (str[i + 1]) {
            total += str[i + 1].charCodeAt(0) * (i - 1);
        }

        hash += String.fromCharCode(97 + Math.abs(total) % 26);
    }

    return hash;
}

export function match(str, pattern) {
    var regmatch = str.match(pattern);
    if (regmatch) {
        return regmatch[1];
    }
}

export function awaitKey(obj, key) {
    return new ZalgoPromise(function (resolve) {

        var value = obj[key];

        if (value) {
            return resolve(value);
        }

        delete obj[key];

        Object.defineProperty(obj, key, {

            configurable: true,

            set: function set(item) {
                value = item;

                if (value) {
                    resolve(value);
                }
            },
            get: function get() {
                return value;
            }
        });
    });
}

export function stringifyError(err) {
    var level = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;


    if (level >= 3) {
        return 'stringifyError stack overflow';
    }

    try {
        if (!err) {
            return '<unknown error: ' + Object.prototype.toString.call(err) + '>';
        }

        if (typeof err === 'string') {
            return err;
        }

        if (err instanceof Error) {
            var stack = err && err.stack;
            var message = err && err.message;

            if (stack && message) {
                if (stack.indexOf(message) !== -1) {
                    return stack;
                } else {
                    return message + '\n' + stack;
                }
            } else if (stack) {
                return stack;
            } else if (message) {
                return message;
            }
        }

        if (err && err.toString && typeof err.toString === 'function') {
            // $FlowFixMe
            return err.toString();
        }

        return Object.prototype.toString.call(err);
    } catch (newErr) {
        // eslint-disable-line unicorn/catch-error-name
        return 'Error while stringifying error: ' + stringifyError(newErr, level + 1);
    }
}

export function stringifyErrorMessage(err) {

    var defaultMessage = '<unknown error: ' + Object.prototype.toString.call(err) + '>';

    if (!err) {
        return defaultMessage;
    }

    if (err instanceof Error) {
        return err.message || defaultMessage;
    }

    if (typeof err.message === 'string') {
        return err.message || defaultMessage;
    }

    return defaultMessage;
}

export function stringify(item) {
    if (typeof item === 'string') {
        return item;
    }

    if (item && item.toString && typeof item.toString === 'function') {
        // $FlowFixMe
        return item.toString();
    }

    return Object.prototype.toString.call(item);
}

export function domainMatches(hostname, domain) {
    hostname = hostname.split('://')[1];
    var index = hostname.indexOf(domain);
    return index !== -1 && hostname.slice(index) === domain;
}

export function patchMethod(obj, name, handler) {
    var original = obj[name];

    obj[name] = function patchedMethod() {
        var _this3 = this,
            _arguments2 = arguments;

        return handler({
            context: this,
            args: Array.prototype.slice.call(arguments),
            original: original,
            callOriginal: function callOriginal() {
                return original.apply(_this3, _arguments2);
            }
        });
    };
}

export function extend(obj, source) {
    if (!source) {
        return obj;
    }

    if (Object.assign) {
        return Object.assign(obj, source);
    }

    for (var key in source) {
        if (source.hasOwnProperty(key)) {
            obj[key] = source[key];
        }
    }

    return obj;
}

export function values(obj) {
    var result = [];
    for (var key in obj) {
        if (obj.hasOwnProperty(key)) {
            result.push(obj[key]);
        }
    }
    return result;
}

export function perc(pixels, percentage) {
    return Math.round(pixels * percentage / 100);
}

export function min() {
    return Math.min.apply(Math, arguments);
}

export function max() {
    return Math.max.apply(Math, arguments);
}

export function regexMap(str, regexp, handler) {
    var results = [];

    // $FlowFixMe
    str.replace(regexp, function regexMapMatcher(item) {
        results.push(handler ? handler.apply(null, arguments) : item);
    });

    // $FlowFixMe
    return results;
}

export function svgToBase64(svg) {
    return 'data:image/svg+xml;base64,' + base64encode(svg);
}

export function objFilter(obj) {
    var filter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Boolean;

    var result = {};

    for (var key in obj) {
        if (!obj.hasOwnProperty(key) || !filter(obj[key], key)) {
            continue;
        }

        result[key] = obj[key];
    }

    return result;
}

export function identity(item) {
    return item;
}

export function regexTokenize(text, regexp) {
    var result = [];
    text.replace(regexp, function (token) {
        result.push(token);
        return '';
    });
    return result;
}

export function promiseDebounce(method) {
    var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 50;


    var promise = void 0;
    var timeout = void 0;

    return function promiseDebouncedMethod() {
        if (timeout) {
            clearTimeout(timeout);
        }

        var localPromise = promise = promise || new ZalgoPromise();

        timeout = setTimeout(function () {
            promise = null;
            timeout = null;

            ZalgoPromise['try'](method).then(function (result) {
                localPromise.resolve(result);
            }, function (err) {
                localPromise.reject(err);
            });
        }, delay);

        return localPromise;
    };
}

export function safeInterval(method, time) {

    var timeout = void 0;

    function loop() {
        timeout = setTimeout(function () {
            method();
            loop();
        }, time);
    }

    loop();

    return {
        cancel: function cancel() {
            clearTimeout(timeout);
        }
    };
}

export function isInteger(str) {
    return Boolean(str.match(/^[0-9]+$/));
}

export function isFloat(str) {
    return Boolean(str.match(/^[0-9]+\.[0-9]+$/));
}

export function serializePrimitive(value) {
    return value.toString();
}

export function deserializePrimitive(value) {
    if (value === 'true') {
        return true;
    } else if (value === 'false') {
        return false;
    } else if (isInteger(value)) {
        return parseInt(value, 10);
    } else if (isFloat(value)) {
        return parseFloat(value);
    } else {
        return value;
    }
}

export function dotify(obj) {
    var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var newobj = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    prefix = prefix ? prefix + '.' : prefix;
    for (var key in obj) {
        if (!obj.hasOwnProperty(key) || obj[key] === undefined || obj[key] === null || typeof obj[key] === 'function') {
            continue;
        } else if (obj[key] && Array.isArray(obj[key]) && obj[key].length && obj[key].every(function (val) {
            return (typeof val === 'undefined' ? 'undefined' : _typeof(val)) !== 'object';
        })) {
            newobj['' + prefix + key + '[]'] = obj[key].join(',');
        } else if (obj[key] && _typeof(obj[key]) === 'object') {
            newobj = dotify(obj[key], '' + prefix + key, newobj);
        } else {
            newobj['' + prefix + key] = serializePrimitive(obj[key]);
        }
    }
    return newobj;
}

export function undotify(obj) {

    var result = {};

    for (var key in obj) {
        if (!obj.hasOwnProperty(key) || typeof obj[key] !== 'string') {
            continue;
        }

        var value = obj[key];

        if (key.match(/^.+\[\]$/)) {
            key = key.slice(0, key.length - 2);
            value = value.split(',').map(deserializePrimitive);
        } else {
            value = deserializePrimitive(value);
        }

        var keyResult = result;
        var parts = key.split('.');
        for (var i = 0; i < parts.length; i++) {
            var part = parts[i];
            var isLast = i + 1 === parts.length;
            var isIndex = !isLast && isInteger(parts[i + 1]);

            if (part === 'constructor' || part === 'prototype') {
                throw new Error('Disallowed key: ' + part);
            }

            if (isLast) {
                // $FlowFixMe
                keyResult[part] = value;
            } else {
                // $FlowFixMe
                keyResult = keyResult[part] = keyResult[part] || (isIndex ? [] : {});
            }
        }
    }

    return result;
}

export function eventEmitter() {
    var triggered = {};
    var handlers = {};

    return {
        on: function on(eventName, handler) {
            var handlerList = handlers[eventName] = handlers[eventName] || [];

            handlerList.push(handler);

            var cancelled = false;

            return {
                cancel: function cancel() {
                    if (!cancelled) {
                        cancelled = true;
                        handlerList.splice(handlerList.indexOf(handler), 1);
                    }
                }
            };
        },
        once: function once(eventName, handler) {

            var listener = this.on(eventName, function () {
                listener.cancel();
                handler();
            });

            return listener;
        },
        trigger: function trigger(eventName) {
            for (var _len3 = arguments.length, args = Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
                args[_key3 - 1] = arguments[_key3];
            }

            var handlerList = handlers[eventName];
            var promises = [];

            if (handlerList) {
                var _loop = function _loop(_i2, _length2) {
                    var handler = handlerList[_i2];
                    promises.push(ZalgoPromise['try'](function () {
                        return handler.apply(undefined, args);
                    }));
                };

                for (var _i2 = 0, _length2 = handlerList == null ? 0 : handlerList.length; _i2 < _length2; _i2++) {
                    _loop(_i2, _length2);
                }
            }

            return ZalgoPromise.all(promises).then(noop);
        },
        triggerOnce: function triggerOnce(eventName) {

            if (triggered[eventName]) {
                return ZalgoPromise.resolve();
            }

            triggered[eventName] = true;

            for (var _len4 = arguments.length, args = Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
                args[_key4 - 1] = arguments[_key4];
            }

            return this.trigger.apply(this, [eventName].concat(args));
        }
    };
}

export function camelToDasherize(string) {
    return string.replace(/([A-Z])/g, function (g) {
        return '-' + g.toLowerCase();
    });
}

export function dasherizeToCamel(string) {
    return string.replace(/-([a-z])/g, function (g) {
        return g[1].toUpperCase();
    });
}

export function capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1).toLowerCase();
}

export function get(item, path, def) {

    if (!path) {
        return def;
    }

    var pathParts = path.split('.');

    // Loop through each section of our key path

    for (var i = 0; i < pathParts.length; i++) {

        // If we have an object, we can get the key
        if ((typeof item === 'undefined' ? 'undefined' : _typeof(item)) === 'object' && item !== null) {
            item = item[pathParts[i]];

            // Otherwise, we should return the default (undefined if not provided)
        } else {
            return def;
        }
    }

    // If our final result is undefined, we should return the default

    return item === undefined ? def : item;
}

export function safeTimeout(method, time) {

    var interval = safeInterval(function () {
        time -= 100;
        if (time <= 0) {
            interval.cancel();
            method();
        }
    }, 100);
}

export function defineLazyProp(obj, key, getter) {
    if (Array.isArray(obj)) {
        if (typeof key !== 'number') {
            throw new TypeError('Array key must be number');
        }
    } else if ((typeof obj === 'undefined' ? 'undefined' : _typeof(obj)) === 'object' && obj !== null) {
        if (typeof key !== 'string') {
            throw new TypeError('Object key must be string');
        }
    }

    Object.defineProperty(obj, key, {
        configurable: true,
        enumerable: true,
        get: function get() {
            // $FlowFixMe
            delete obj[key];
            var value = getter();
            // $FlowFixMe
            obj[key] = value;
            return value;
        },
        set: function set(value) {
            // $FlowFixMe
            delete obj[key];
            // $FlowFixMe
            obj[key] = value;
        }
    });
}

export function arrayFrom(item) {
    // eslint-disable-line no-undef
    return Array.prototype.slice.call(item);
}

export function isObject(item) {
    return (typeof item === 'undefined' ? 'undefined' : _typeof(item)) === 'object' && item !== null;
}

export function isObjectObject(obj) {
    return isObject(obj) && Object.prototype.toString.call(obj) === '[object Object]';
}

export function isPlainObject(obj) {
    if (!isObjectObject(obj)) {
        return false;
    }

    // $FlowFixMe
    var constructor = obj.constructor;

    if (typeof constructor !== 'function') {
        return false;
    }

    var prototype = constructor.prototype;

    if (!isObjectObject(prototype)) {
        return false;
    }

    if (!prototype.hasOwnProperty('isPrototypeOf')) {
        return false;
    }

    return true;
}

export function replaceObject(item, replacer) {
    var fullKey = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';


    if (Array.isArray(item)) {
        var _length3 = item.length;
        var result = [];

        var _loop2 = function _loop2(i) {

            defineLazyProp(result, i, function () {
                var itemKey = fullKey ? fullKey + '.' + i : '' + i;
                var el = item[i];

                var child = replacer(el, i, itemKey);

                if (isPlainObject(child) || Array.isArray(child)) {
                    // $FlowFixMe
                    child = replaceObject(child, replacer, itemKey);
                }

                return child;
            });
        };

        for (var i = 0; i < _length3; i++) {
            _loop2(i);
        }

        // $FlowFixMe
        return result;
    } else if (isPlainObject(item)) {
        var _result = {};

        var _loop3 = function _loop3(key) {
            if (!item.hasOwnProperty(key)) {
                return 'continue';
            }

            defineLazyProp(_result, key, function () {
                var itemKey = fullKey ? fullKey + '.' + key : '' + key;
                // $FlowFixMe
                var el = item[key];

                var child = replacer(el, key, itemKey);

                if (isPlainObject(child) || Array.isArray(child)) {
                    // $FlowFixMe
                    child = replaceObject(child, replacer, itemKey);
                }

                return child;
            });
        };

        for (var key in item) {
            var _ret3 = _loop3(key);

            if (_ret3 === 'continue') continue;
        }

        // $FlowFixMe
        return _result;
    } else {
        throw new Error('Pass an object or array');
    }
}

export function copyProp(source, target, name, def) {
    if (source.hasOwnProperty(name)) {
        var descriptor = Object.getOwnPropertyDescriptor(source, name);
        // $FlowFixMe
        Object.defineProperty(target, name, descriptor);
    } else {
        target[name] = def;
    }
}

export function regex(pattern, string) {
    var start = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;


    if (typeof pattern === 'string') {
        // eslint-disable-next-line security/detect-non-literal-regexp
        pattern = new RegExp(pattern);
    }

    var result = string.slice(start).match(pattern);

    if (!result) {
        return;
    }

    // $FlowFixMe
    var index = result.index;
    var regmatch = result[0];

    return {
        text: regmatch,
        groups: result.slice(1),
        start: start + index,
        end: start + index + regmatch.length,
        length: regmatch.length,

        replace: function replace(text) {

            if (!regmatch) {
                return '';
            }

            return '' + regmatch.slice(0, start + index) + text + regmatch.slice(index + regmatch.length);
        }
    };
}

export function regexAll(pattern, string) {

    var matches = [];
    var start = 0;

    // eslint-disable-next-line no-constant-condition
    while (true) {
        var regmatch = regex(pattern, string, start);

        if (!regmatch) {
            break;
        }

        matches.push(regmatch);
        start = match.end;
    }

    return matches;
}

export function isDefined(value) {
    return value !== null && value !== undefined;
}

export function cycle(method) {
    return ZalgoPromise['try'](method).then(function () {
        return cycle(method);
    });
}

export function debounce(method) {
    var time = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 100;


    var timeout = void 0;

    return function debounceWrapper() {
        var _this4 = this,
            _arguments3 = arguments;

        clearTimeout(timeout);

        timeout = setTimeout(function () {
            return method.apply(_this4, _arguments3);
        }, time);
    };
}

export function isRegex(item) {
    return Object.prototype.toString.call(item) === '[object RegExp]';
}

// eslint-disable-next-line flowtype/no-weak-types
export var weakMapMemoize = function weakMapMemoize(method) {

    var weakmap = new WeakMap();

    // eslint-disable-next-line flowtype/no-weak-types
    return function weakmapMemoized(arg) {
        var _this5 = this;

        return weakmap.getOrSet(arg, function () {
            return method.call(_this5, arg);
        });
    };
};

// eslint-disable-next-line flowtype/no-weak-types
export var weakMapMemoizePromise = function weakMapMemoizePromise(method) {

    var weakmap = new WeakMap();

    // eslint-disable-next-line flowtype/no-weak-types
    return function weakmapMemoizedPromise(arg) {
        var _this6 = this;

        return weakmap.getOrSet(arg, function () {
            return method.call(_this6, arg)['finally'](function () {
                weakmap['delete'](arg);
            });
        });
    };
};

export function getOrSet(obj, key, getter) {
    if (obj.hasOwnProperty(key)) {
        return obj[key];
    }

    var val = getter();
    obj[key] = val;
    return val;
}

export function cleanup(obj) {

    var tasks = [];
    var cleaned = false;

    return {
        set: function set(name, item) {
            if (!cleaned) {
                obj[name] = item;
                this.register(function () {
                    delete obj[name];
                });
            }
            return item;
        },
        register: function register(method) {
            if (cleaned) {
                method();
            } else {
                tasks.push(once(method));
            }
        },
        all: function all() {
            var results = [];
            cleaned = true;

            while (tasks.length) {
                var task = tasks.pop();
                results.push(task());
            }

            return ZalgoPromise.all(results).then(noop);
        }
    };
}

export function tryCatch(fn) {
    var result = void 0;
    var error = void 0;

    try {
        result = fn();
    } catch (err) {
        error = err;
    }

    // $FlowFixMe
    return { result: result, error: error };
}

export function removeFromArray(arr, item) {
    var index = arr.indexOf(item);
    if (index !== -1) {
        arr.splice(index, 1);
    }
}

export function assertExists(name, thing) {
    if (thing === null || typeof thing === 'undefined') {
        throw new Error('Expected ' + name + ' to be present');
    }

    return thing;
}

export function unique(arr) {
    var result = {};

    for (var _i4 = 0, _length5 = arr == null ? 0 : arr.length; _i4 < _length5; _i4++) {
        var item = arr[_i4];
        // eslint-disable-next-line const-immutable/no-mutation
        result[item] = true;
    }

    return Object.keys(result);
}