'use strict'

const fs = require('fs')
const streamify = require('./streamify')

module.exports = write

/**
 * Public function `write`.
 *
 * Returns a promise and asynchronously serialises a data structure to a
 * JSON file on disk. Sanely handles promises, buffers, maps and other
 * iterables.
 *
 * @param path:     Path to the JSON file.
 *
 * @param data:     The data to transform.
 *
 * @option space:   Indentation string, or the number of spaces
 *          to indent each nested level by.
 *
 * @option promises:  'resolve' or 'ignore', default is 'resolve'.
 *
 * @option buffers:   'toString' or 'ignore', default is 'toString'.
 *
 * @option maps:    'object' or 'ignore', default is 'object'.
 *
 * @option iterables: 'array' or 'ignore', default is 'array'.
 *
 * @option circular:  'error' or 'ignore', default is 'error'.
 **/
function write (path, data, options) {
  return new Promise((resolve, reject) => {
    streamify(data, options)
      .pipe(fs.createWriteStream(path, options))
      .on('finish', () => {
        resolve()
      })
      .on('error', reject)
      .on('dataError', reject)
  })
}

