import { BigJsonViewerEvent, BigJsonViewerNode, BigJsonViewerOptions, JsonNodesStubElement, PaginatedOption, TreeSearchAreaOption, TreeSearchCursor, TreeSearchMatch } from './model/big-json-viewer.model';
import { WorkerClientApi } from './helpers/worker-client';
export interface JsonNodeElement extends JsonNodesStubElement {
    jsonNode: BigJsonViewerNode;
    /**
     * Opens the given path and returns the JsonNodeElement if the path was found.
     */
    openPath(path: string[]): Promise<JsonNodeElement>;
    /**
     * Opens all nodes with limits.
     * maxDepth is Infinity by default.
     * paginated is first by default. This opens only the first page.
     * all, would open all pages.
     * none would open no pages and just show the stubs.
     * Returns the number of opened nodes.
     */
    openAll(maxDepth?: number, paginated?: PaginatedOption): Promise<number>;
    /**
     * Get a list of all opened paths
     * withsStubs is true by default, it makes sure, that opened stubs are represented
     */
    getOpenPaths(withStubs?: boolean): string[][];
    openNode(dispatchEvent?: boolean): Promise<boolean>;
    closeNode(dispatchEvent?: boolean): Promise<boolean>;
    toggleNode(dispatchEvent?: boolean): Promise<boolean>;
}
export declare class BigJsonViewerDom {
    private workerClient;
    private options;
    private currentPattern;
    private currentArea;
    private currentMark;
    private rootElement;
    private rootNode;
    /**
     * Initialized the viewer with JSON encoded data
     */
    static fromData(data: ArrayBuffer | string, options?: BigJsonViewerOptions): Promise<BigJsonViewerDom>;
    /**
     * Initializes the viewer with a JavaScript object
     */
    static fromObject(data: string | object | null | number | boolean, options?: BigJsonViewerOptions): Promise<BigJsonViewerDom>;
    protected constructor(options?: BigJsonViewerOptions);
    protected getWorkerClient(): Promise<WorkerClientApi>;
    protected setData(data: ArrayBuffer | string): Promise<BigJsonViewerNode>;
    protected setObject(data: any): Promise<BigJsonViewerNode>;
    protected getChildNodes(path: string[], start: number, limit: number): Promise<BigJsonViewerNode[]>;
    protected getSearchMatches(pattern: RegExp, searchArea: TreeSearchAreaOption): Promise<TreeSearchMatch[]>;
    protected getKeyIndex(path: string[], key: string): Promise<number>;
    /**
     * Destroys the viewer and frees resources like the worker
     */
    destroy(): void;
    getRootElement(): JsonNodeElement;
    protected getNodeElement(node: BigJsonViewerNode): JsonNodeElement;
    protected attachInteractivity(nodeElement: JsonNodeElement, node: BigJsonViewerNode): void;
    protected attachClickToggleListener(anchor: HTMLAnchorElement): void;
    protected isOpenableNode(node: BigJsonViewerNode): number;
    protected closeNode(nodeElement: JsonNodeElement, dispatchEvent?: boolean): boolean;
    protected refreshHeaders(nodeElement: JsonNodeElement): void;
    protected getHighlightedText(text: string, pattern: RegExp): DocumentFragment;
    /**
     * Opens the tree nodes based on a pattern
     * openLimit is 1 by default, you can provide Infinity for all
     * searchArea is 'all' by default
     */
    openBySearch(pattern: RegExp, openLimit?: number, searchArea?: TreeSearchAreaOption): Promise<TreeSearchCursor>;
    protected findMarkForMatch(nodeElement: JsonNodeElement, match: TreeSearchMatch): HTMLElement;
    protected openSearchMatch(nodeElement: JsonNodeElement, match: TreeSearchMatch): Promise<JsonNodeElement>;
    protected getOpenPaths(nodeElement: JsonNodeElement, withSubs: any): string[][];
    protected openNode(nodeElement: JsonNodeElement, dispatchEvent?: boolean): Promise<boolean>;
    protected dispatchNodeEvent(type: BigJsonViewerEvent, nodeElement: JsonNodesStubElement): void;
    protected openKey(nodeElement: JsonNodeElement, key: string): Promise<JsonNodeElement>;
    protected openPath(nodeElement: JsonNodeElement, path: string[], dispatchEvent?: boolean): Promise<JsonNodeElement>;
    protected openAll(nodeElement: JsonNodeElement, maxDepth: number, paginated: PaginatedOption, dispatchEvent?: boolean): Promise<number>;
    protected openAllChildren(children: HTMLCollection, maxDepth: number, paginated: PaginatedOption): Promise<number>;
    /**
     * Returns the pagination limit, if the node should have
     */
    protected getPaginationLimit(node: BigJsonViewerNode): number;
    protected getVisibleChildren(children: HTMLCollection): JsonNodeElement[];
    protected getPaginatedNodeChildren(nodeElement: JsonNodeElement): Promise<HTMLDivElement>;
    protected getPaginationStub(node: BigJsonViewerNode, start: number, limit: number): JsonNodesStubElement;
    protected closePaginationStub(stubElement: JsonNodesStubElement, dispatchEvent?: boolean): void;
    protected openPaginationStub(stubElement: JsonNodesStubElement, node: BigJsonViewerNode, nodes: BigJsonViewerNode[], dispatchEvent?: boolean): void;
    protected addChildNodes(nodes: BigJsonViewerNode[], parent: HTMLElement, collapseSameValue: number): void;
    protected getCollapseIndicator(count: any): HTMLDivElement;
    protected getNodeHeader(node: BigJsonViewerNode): HTMLDivElement;
    protected generateAccessor(parent: HTMLElement): void;
    protected generateTypeInfo(parent: HTMLElement, node: BigJsonViewerNode): void;
    protected generateLabel(parent: HTMLElement, node: BigJsonViewerNode, highlightPattern: RegExp): void;
    protected generateValue(parent: HTMLElement, node: BigJsonViewerNode, highlightPattern: RegExp): void;
    protected getLabelNode(label: string | HTMLElement): Node;
    protected generateLinks(parent: HTMLElement, node: BigJsonViewerNode): void;
    protected findNodeElement(el: HTMLElement): JsonNodeElement;
}
