"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var worker_client_1 = require("./helpers/worker-client");
var json_node_search_1 = require("./parser/json-node-search");
var big_json_viewer_worker_inline_1 = require("./worker/big-json-viewer.worker.inline");
var BigJsonViewerDom = /** @class */ (function () {
    function BigJsonViewerDom(options) {
        this.options = {
            objectNodesLimit: 50,
            arrayNodesLimit: 50,
            labelAsPath: false,
            linkLabelCopyPath: 'Copy path',
            linkLabelExpandAll: 'Expand all',
            workerPath: null,
            collapseSameValue: 5
        };
        this.currentArea = 'all';
        this.currentMark = null;
        if (options) {
            Object.assign(this.options, options);
        }
    }
    /**
     * Initialized the viewer with JSON encoded data
     */
    BigJsonViewerDom.fromData = function (data, options) {
        return __awaiter(this, void 0, void 0, function () {
            var viewer;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        viewer = new BigJsonViewerDom(options);
                        return [4 /*yield*/, viewer.setData(data)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, viewer];
                }
            });
        });
    };
    /**
     * Initializes the viewer with a JavaScript object
     */
    BigJsonViewerDom.fromObject = function (data, options) {
        return __awaiter(this, void 0, void 0, function () {
            var viewer;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        viewer = new BigJsonViewerDom(options);
                        return [4 /*yield*/, viewer.setObject(data)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, viewer];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.getWorkerClient = function () {
        return __awaiter(this, void 0, void 0, function () {
            var worker, client, e_1, serviceModule, service;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!!this.workerClient) return [3 /*break*/, 4];
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        worker = this.options.workerPath
                            ? new Worker(this.options.workerPath)
                            : big_json_viewer_worker_inline_1.initWorker();
                        client = new worker_client_1.WorkerClient(worker);
                        return [4 /*yield*/, client.initWorker()];
                    case 2:
                        _a.sent();
                        this.workerClient = client;
                        return [3 /*break*/, 4];
                    case 3:
                        e_1 = _a.sent();
                        console.warn('Could not instantiate Worker ' +
                            this.options.workerPath +
                            ', using mock', e_1);
                        serviceModule = require('./big-json-viewer-service');
                        service = new serviceModule.BigJsonViewerService();
                        this.workerClient = new worker_client_1.WorkerClientMock(service);
                        return [3 /*break*/, 4];
                    case 4: return [2 /*return*/, this.workerClient];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.setData = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            var client, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.getWorkerClient()];
                    case 1:
                        client = _b.sent();
                        _a = this;
                        return [4 /*yield*/, client.call('initWithData', data)];
                    case 2:
                        _a.rootNode = _b.sent();
                        return [2 /*return*/, this.rootNode];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.setObject = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            var client, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.getWorkerClient()];
                    case 1:
                        client = _b.sent();
                        _a = this;
                        return [4 /*yield*/, client.call('initWithJs', data)];
                    case 2:
                        _a.rootNode = _b.sent();
                        return [2 /*return*/, this.rootNode];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.getChildNodes = function (path, start, limit) {
        return __awaiter(this, void 0, void 0, function () {
            var client;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getWorkerClient()];
                    case 1:
                        client = _a.sent();
                        return [2 /*return*/, client.call('getNodes', path, start, limit)];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.getSearchMatches = function (pattern, searchArea) {
        return __awaiter(this, void 0, void 0, function () {
            var client;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getWorkerClient()];
                    case 1:
                        client = _a.sent();
                        return [4 /*yield*/, client.call('search', pattern, searchArea)];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.getKeyIndex = function (path, key) {
        return __awaiter(this, void 0, void 0, function () {
            var client;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getWorkerClient()];
                    case 1:
                        client = _a.sent();
                        return [4 /*yield*/, client.call('getKeyIndex', path, key)];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     * Destroys the viewer and frees resources like the worker
     */
    BigJsonViewerDom.prototype.destroy = function () {
        if (this.workerClient) {
            this.workerClient.destroy();
            this.workerClient = null;
        }
        this.rootElement = null;
        this.currentPattern = null;
    };
    BigJsonViewerDom.prototype.getRootElement = function () {
        if (this.rootElement) {
            return this.rootElement;
        }
        if (this.rootNode) {
            var nodeElement = this.getNodeElement(this.rootNode);
            nodeElement.classList.add('json-node-root');
            this.rootElement = nodeElement;
            return nodeElement;
        }
        return null;
    };
    BigJsonViewerDom.prototype.getNodeElement = function (node) {
        var element = document.createElement('div');
        element.classList.add('json-node');
        element.jsonNode = node;
        var header = this.getNodeHeader(node);
        element.headerElement = element.appendChild(header);
        this.attachInteractivity(element, node);
        return element;
    };
    BigJsonViewerDom.prototype.attachInteractivity = function (nodeElement, node) {
        var _this = this;
        nodeElement.isNodeOpen = function () {
            if (_this.isOpenableNode(node)) {
                return nodeElement.headerElement.classList.contains('json-node-open');
            }
            return false;
        };
        nodeElement.openNode = function (dispatchEvent) {
            if (dispatchEvent === void 0) { dispatchEvent = false; }
            return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!this.isOpenableNode(node)) return [3 /*break*/, 2];
                            return [4 /*yield*/, this.openNode(nodeElement, dispatchEvent)];
                        case 1: return [2 /*return*/, _a.sent()];
                        case 2: return [2 /*return*/, false];
                    }
                });
            });
        };
        nodeElement.closeNode = function (dispatchEvent) {
            if (dispatchEvent === void 0) { dispatchEvent = false; }
            return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    if (this.isOpenableNode(node)) {
                        return [2 /*return*/, this.closeNode(nodeElement, dispatchEvent)];
                    }
                    return [2 /*return*/, false];
                });
            });
        };
        nodeElement.toggleNode = function (dispatchEvent) {
            if (dispatchEvent === void 0) { dispatchEvent = false; }
            return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!nodeElement.isNodeOpen()) return [3 /*break*/, 2];
                            return [4 /*yield*/, nodeElement.closeNode(dispatchEvent)];
                        case 1: return [2 /*return*/, _a.sent()];
                        case 2: return [4 /*yield*/, nodeElement.openNode(dispatchEvent)];
                        case 3: return [2 /*return*/, _a.sent()];
                    }
                });
            });
        };
        nodeElement.openPath = function (path) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.isOpenableNode(node)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.openPath(nodeElement, path, true)];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2: return [2 /*return*/, null];
                }
            });
        }); };
        nodeElement.openAll = function (maxDepth, paginated) {
            if (maxDepth === void 0) { maxDepth = Infinity; }
            if (paginated === void 0) { paginated = 'first'; }
            return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!this.isOpenableNode(node)) return [3 /*break*/, 2];
                            return [4 /*yield*/, this.openAll(nodeElement, maxDepth, paginated)];
                        case 1: return [2 /*return*/, _a.sent()];
                        case 2: return [2 /*return*/, 0];
                    }
                });
            });
        };
        nodeElement.getOpenPaths = function (withStubs) {
            if (withStubs === void 0) { withStubs = true; }
            if (_this.isOpenableNode(node)) {
                return _this.getOpenPaths(nodeElement, withStubs);
            }
            return [];
        };
    };
    BigJsonViewerDom.prototype.attachClickToggleListener = function (anchor) {
        var _this = this;
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            var nodeElement = _this.findNodeElement(anchor);
            if (nodeElement) {
                nodeElement.toggleNode(true);
            }
        });
    };
    BigJsonViewerDom.prototype.isOpenableNode = function (node) {
        return (node.type === 'array' || node.type === 'object') && node.length;
    };
    BigJsonViewerDom.prototype.closeNode = function (nodeElement, dispatchEvent) {
        if (dispatchEvent === void 0) { dispatchEvent = false; }
        if (!nodeElement.isNodeOpen()) {
            return false;
        }
        if (nodeElement.childrenElement) {
            nodeElement.headerElement.classList.remove('json-node-open');
            nodeElement.removeChild(nodeElement.childrenElement);
            nodeElement.childrenElement = null;
            if (dispatchEvent) {
                this.dispatchNodeEvent('closeNode', nodeElement);
            }
            return true;
        }
        return false;
    };
    BigJsonViewerDom.prototype.refreshHeaders = function (nodeElement) {
        var _this = this;
        var header = this.getNodeHeader(nodeElement.jsonNode);
        if (nodeElement.isNodeOpen()) {
            header.classList.add('json-node-open');
        }
        nodeElement.headerElement.parentElement.replaceChild(header, nodeElement.headerElement);
        nodeElement.headerElement = header;
        if (nodeElement.childrenElement) {
            this.getVisibleChildren(nodeElement.childrenElement.children).forEach(function (element) { return _this.refreshHeaders(element); });
        }
    };
    BigJsonViewerDom.prototype.getHighlightedText = function (text, pattern) {
        var fragment = document.createDocumentFragment();
        if (!pattern) {
            fragment.appendChild(document.createTextNode(text));
            return fragment;
        }
        var lastIndex = 0;
        json_node_search_1.forEachMatchFromString(pattern, text, function (index, length) {
            if (lastIndex < index) {
                fragment.appendChild(document.createTextNode(text.substring(lastIndex, index)));
            }
            var mark = document.createElement('mark');
            mark.appendChild(document.createTextNode(text.substr(index, length)));
            fragment.appendChild(mark);
            lastIndex = index + length;
        });
        if (lastIndex !== text.length) {
            fragment.appendChild(document.createTextNode(text.substring(lastIndex, text.length)));
        }
        return fragment;
    };
    /**
     * Opens the tree nodes based on a pattern
     * openLimit is 1 by default, you can provide Infinity for all
     * searchArea is 'all' by default
     */
    BigJsonViewerDom.prototype.openBySearch = function (pattern, openLimit, searchArea) {
        if (openLimit === void 0) { openLimit = 1; }
        if (searchArea === void 0) { searchArea = 'all'; }
        return __awaiter(this, void 0, void 0, function () {
            var nodeElement, viewer, matches, cursor, length, i;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        nodeElement = this.rootElement;
                        this.currentPattern = pattern;
                        this.currentArea = searchArea;
                        if (!pattern) {
                            this.closeNode(nodeElement, true);
                            return [2 /*return*/, null];
                        }
                        this.refreshHeaders(nodeElement);
                        viewer = this;
                        return [4 /*yield*/, this.getSearchMatches(pattern, searchArea)];
                    case 1:
                        matches = _a.sent();
                        cursor = {
                            matches: matches,
                            index: 0,
                            navigateTo: function (index) {
                                return __awaiter(this, void 0, void 0, function () {
                                    var match, openedElement;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                this.index = index;
                                                match = this.matches[index];
                                                if (!match) {
                                                    console.warn('searchIndex does not exist on ' + this.matches.length, index);
                                                    return [2 /*return*/];
                                                }
                                                return [4 /*yield*/, viewer.openSearchMatch(nodeElement, match)];
                                            case 1:
                                                openedElement = _a.sent();
                                                if (openedElement) {
                                                    if (openedElement.scrollIntoView) {
                                                        openedElement.scrollIntoView({ block: 'center' });
                                                    }
                                                    if (viewer.currentMark) {
                                                        viewer.currentMark.classList.remove('highlight-active');
                                                    }
                                                    viewer.currentMark = viewer.findMarkForMatch(openedElement, match);
                                                    if (viewer.currentMark) {
                                                        viewer.currentMark.classList.add('highlight-active');
                                                    }
                                                    return [2 /*return*/, true];
                                                }
                                                return [2 /*return*/, false];
                                        }
                                    });
                                });
                            },
                            next: function () {
                                return this.navigateTo(this.index + 1 >= this.matches.length ? 0 : this.index + 1);
                            },
                            previous: function () {
                                return this.navigateTo(this.index - 1 < 0 ? this.matches.length : this.index - 1);
                            }
                        };
                        length = Math.min(matches.length, openLimit);
                        i = 0;
                        _a.label = 2;
                    case 2:
                        if (!(i < length && i < openLimit)) return [3 /*break*/, 5];
                        return [4 /*yield*/, this.openSearchMatch(nodeElement, matches[i])];
                    case 3:
                        _a.sent();
                        _a.label = 4;
                    case 4:
                        i++;
                        return [3 /*break*/, 2];
                    case 5:
                        this.dispatchNodeEvent('openedNodes', nodeElement);
                        if (!matches.length) return [3 /*break*/, 7];
                        return [4 /*yield*/, cursor.navigateTo(0)];
                    case 6:
                        _a.sent();
                        _a.label = 7;
                    case 7: return [2 /*return*/, cursor];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.findMarkForMatch = function (nodeElement, match) {
        var children = null, expectIndex = 0;
        if (match.key !== undefined) {
            var label = nodeElement.headerElement.querySelector('.json-node-label');
            if (label) {
                children = label.childNodes;
                expectIndex = match.key;
            }
        }
        if (match.value !== undefined) {
            var value = nodeElement.headerElement.querySelector('.json-node-value');
            if (value) {
                children = value.childNodes;
                expectIndex = match.value;
            }
        }
        if (children) {
            var index = nodeElement.jsonNode.type === 'string' ? -1 : 0;
            for (var i = 0; i < children.length; i++) {
                var cn = children[i];
                if (cn.nodeType === Node.TEXT_NODE) {
                    index += cn.textContent.length;
                }
                if (cn.nodeType === Node.ELEMENT_NODE &&
                    cn.tagName === 'MARK' &&
                    expectIndex === index) {
                    return cn;
                }
            }
        }
        return null;
    };
    BigJsonViewerDom.prototype.openSearchMatch = function (nodeElement, match) {
        return __awaiter(this, void 0, void 0, function () {
            var matchNodeElementParent;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(match.key !== undefined && match.path.length)) return [3 /*break*/, 4];
                        if (!match.path.length) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.openPath(nodeElement, match.path.slice(0, -1))];
                    case 1:
                        matchNodeElementParent = _a.sent();
                        if (!matchNodeElementParent) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.openKey(matchNodeElementParent, match.path[match.path.length - 1])];
                    case 2: return [2 /*return*/, _a.sent()]; // ensure the key is visible
                    case 3: return [3 /*break*/, 6];
                    case 4:
                        if (!(match.value !== undefined)) return [3 /*break*/, 6];
                        return [4 /*yield*/, this.openPath(nodeElement, match.path)];
                    case 5: return [2 /*return*/, _a.sent()];
                    case 6: return [2 /*return*/, null];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.getOpenPaths = function (nodeElement, withSubs) {
        var result = [];
        if (!nodeElement.isNodeOpen()) {
            return result;
        }
        var children = nodeElement.childrenElement.children;
        var nodeElements = this.getVisibleChildren(children);
        for (var i = 0; i < nodeElements.length; i++) {
            var element = nodeElements[i];
            if (element.isNodeOpen()) {
                result.push.apply(result, this.getOpenPaths(element, withSubs));
            }
        }
        var limit = this.getPaginationLimit(nodeElement.jsonNode);
        // find open stubs
        if (!result.length && limit) {
            for (var i = 0; i < children.length; i++) {
                var child = children[i];
                if (child.isNodeOpen() &&
                    child.childrenElement &&
                    child.childrenElement.children.length) {
                    var first = child.childrenElement.children[0];
                    if (first.jsonNode) {
                        result.push(first.jsonNode.path);
                    }
                }
            }
        }
        if (!result.length) {
            result.push(nodeElement.jsonNode.path);
        }
        return result;
    };
    BigJsonViewerDom.prototype.openNode = function (nodeElement, dispatchEvent) {
        if (dispatchEvent === void 0) { dispatchEvent = false; }
        return __awaiter(this, void 0, void 0, function () {
            var children;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (nodeElement.isNodeOpen()) {
                            return [2 /*return*/, false];
                        }
                        nodeElement.headerElement.classList.add('json-node-open');
                        return [4 /*yield*/, this.getPaginatedNodeChildren(nodeElement)];
                    case 1:
                        children = _a.sent();
                        nodeElement.childrenElement = nodeElement.appendChild(children);
                        if (dispatchEvent) {
                            this.dispatchNodeEvent('openNode', nodeElement);
                        }
                        return [2 /*return*/, true];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.dispatchNodeEvent = function (type, nodeElement) {
        var event;
        if (document.createEvent) {
            event = document.createEvent('Event');
            event.initEvent(type, true, false);
        }
        else {
            event = new Event(type, {
                bubbles: true,
                cancelable: false
            });
        }
        nodeElement.dispatchEvent(event);
    };
    BigJsonViewerDom.prototype.openKey = function (nodeElement, key) {
        return __awaiter(this, void 0, void 0, function () {
            var node, children, index, stubIndex, stub, stubIndex, stub, childNodeElement;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        node = nodeElement.jsonNode;
                        children = null;
                        index = -1;
                        if (!(node.type === 'object')) return [3 /*break*/, 6];
                        return [4 /*yield*/, this.getKeyIndex(node.path, key)];
                    case 1:
                        index = _a.sent();
                        if (index === -1) {
                            return [2 /*return*/, null];
                        }
                        return [4 /*yield*/, nodeElement.openNode()];
                    case 2:
                        _a.sent();
                        if (!(node.length > this.options.objectNodesLimit)) return [3 /*break*/, 5];
                        stubIndex = Math.floor(index / this.options.objectNodesLimit);
                        stub = nodeElement.childrenElement.children[stubIndex];
                        if (!stub) return [3 /*break*/, 4];
                        return [4 /*yield*/, stub.openNode()];
                    case 3:
                        _a.sent();
                        index -= stubIndex * this.options.objectNodesLimit;
                        children = stub.childrenElement.children;
                        _a.label = 4;
                    case 4: return [3 /*break*/, 6];
                    case 5:
                        children = nodeElement.childrenElement.children;
                        _a.label = 6;
                    case 6:
                        if (!(node.type === 'array')) return [3 /*break*/, 11];
                        index = parseInt(key);
                        if (isNaN(index) || index >= node.length || index < 0) {
                            return [2 /*return*/, null];
                        }
                        return [4 /*yield*/, nodeElement.openNode()];
                    case 7:
                        _a.sent();
                        if (!(node.length > this.options.arrayNodesLimit)) return [3 /*break*/, 10];
                        stubIndex = Math.floor(index / this.options.arrayNodesLimit);
                        stub = nodeElement.childrenElement.children[stubIndex];
                        if (!stub) return [3 /*break*/, 9];
                        return [4 /*yield*/, stub.openNode()];
                    case 8:
                        _a.sent();
                        index -= stubIndex * this.options.arrayNodesLimit;
                        children = stub.childrenElement.children;
                        _a.label = 9;
                    case 9: return [3 /*break*/, 11];
                    case 10:
                        children = nodeElement.childrenElement.children;
                        _a.label = 11;
                    case 11:
                        if (children && index >= 0 && index < children.length) {
                            childNodeElement = children[index];
                            if (!childNodeElement.jsonNode) {
                                return [2 /*return*/, null];
                            }
                            return [2 /*return*/, childNodeElement];
                        }
                        return [2 /*return*/, null];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.openPath = function (nodeElement, path, dispatchEvent) {
        if (dispatchEvent === void 0) { dispatchEvent = false; }
        return __awaiter(this, void 0, void 0, function () {
            var element, i;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!!path.length) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.openNode(nodeElement, dispatchEvent)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, nodeElement];
                    case 2:
                        element = nodeElement;
                        i = 0;
                        _a.label = 3;
                    case 3:
                        if (!(i < path.length)) return [3 /*break*/, 7];
                        if (!element) {
                            return [2 /*return*/, null];
                        }
                        return [4 /*yield*/, this.openKey(element, path[i])];
                    case 4:
                        element = _a.sent();
                        if (!element) return [3 /*break*/, 6];
                        return [4 /*yield*/, element.openNode()];
                    case 5:
                        _a.sent();
                        _a.label = 6;
                    case 6:
                        i++;
                        return [3 /*break*/, 3];
                    case 7:
                        if (dispatchEvent) {
                            this.dispatchNodeEvent('openedNodes', nodeElement);
                        }
                        return [2 /*return*/, element];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.openAll = function (nodeElement, maxDepth, paginated, dispatchEvent) {
        if (dispatchEvent === void 0) { dispatchEvent = false; }
        return __awaiter(this, void 0, void 0, function () {
            var opened, newMaxDepth, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, nodeElement.openNode()];
                    case 1:
                        _b.sent();
                        opened = 1;
                        if (maxDepth <= 1 || !nodeElement.childrenElement) {
                            return [2 /*return*/, opened];
                        }
                        newMaxDepth = maxDepth === Infinity ? Infinity : maxDepth - 1;
                        _a = opened;
                        return [4 /*yield*/, this.openAllChildren(nodeElement.childrenElement.children, newMaxDepth, paginated)];
                    case 2:
                        opened = _a + _b.sent();
                        if (dispatchEvent) {
                            this.dispatchNodeEvent('openedNodes', nodeElement);
                        }
                        return [2 /*return*/, opened];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.openAllChildren = function (children, maxDepth, paginated) {
        return __awaiter(this, void 0, void 0, function () {
            var opened, i, child, _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        opened = 0;
                        i = 0;
                        _c.label = 1;
                    case 1:
                        if (!(i < children.length)) return [3 /*break*/, 8];
                        child = children[i];
                        if (!child.jsonNode) return [3 /*break*/, 3];
                        // is a node
                        _a = opened;
                        return [4 /*yield*/, child.openAll(maxDepth, paginated)];
                    case 2:
                        // is a node
                        opened = _a + _c.sent();
                        return [3 /*break*/, 7];
                    case 3:
                        if (!child.openNode) return [3 /*break*/, 7];
                        // is a stub
                        if (paginated === 'none') {
                            return [2 /*return*/, opened];
                        }
                        return [4 /*yield*/, child.openNode()];
                    case 4:
                        _c.sent();
                        if (!child.childrenElement) return [3 /*break*/, 6];
                        _b = opened;
                        return [4 /*yield*/, this.openAllChildren(child.childrenElement.children, maxDepth, paginated)];
                    case 5:
                        opened = _b + _c.sent();
                        _c.label = 6;
                    case 6:
                        if (paginated === 'first') {
                            return [2 /*return*/, opened];
                        }
                        _c.label = 7;
                    case 7:
                        i++;
                        return [3 /*break*/, 1];
                    case 8: return [2 /*return*/, opened];
                }
            });
        });
    };
    /**
     * Returns the pagination limit, if the node should have
     */
    BigJsonViewerDom.prototype.getPaginationLimit = function (node) {
        if (node.type === 'array' && node.length > this.options.arrayNodesLimit) {
            return this.options.arrayNodesLimit;
        }
        if (node.type === 'object' && node.length > this.options.objectNodesLimit) {
            return this.options.objectNodesLimit;
        }
        return 0;
    };
    BigJsonViewerDom.prototype.getVisibleChildren = function (children) {
        var result = [];
        for (var i = 0; i < children.length; i++) {
            var child = children[i];
            if (child.jsonNode) {
                // is a node
                result.push(child);
            }
            else if (child.openNode &&
                child.isNodeOpen() &&
                child.childrenElement) {
                // is a stub
                result.push.apply(result, this.getVisibleChildren(child.childrenElement.children));
            }
        }
        return result;
    };
    BigJsonViewerDom.prototype.getPaginatedNodeChildren = function (nodeElement) {
        return __awaiter(this, void 0, void 0, function () {
            var node, element, limit, start, nodes;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        node = nodeElement.jsonNode;
                        element = document.createElement('div');
                        element.classList.add('json-node-children');
                        limit = this.getPaginationLimit(node);
                        if (!limit) return [3 /*break*/, 1];
                        for (start = 0; start < node.length; start += limit) {
                            element.appendChild(this.getPaginationStub(node, start, limit));
                        }
                        return [3 /*break*/, 3];
                    case 1: return [4 /*yield*/, this.getChildNodes(node.path, 0, limit)];
                    case 2:
                        nodes = _a.sent();
                        this.addChildNodes(nodes, element, node.type === 'array' ? this.options.collapseSameValue : Infinity);
                        _a.label = 3;
                    case 3: return [2 /*return*/, element];
                }
            });
        });
    };
    BigJsonViewerDom.prototype.getPaginationStub = function (node, start, limit) {
        var _this = this;
        var stubElement = document.createElement('div');
        stubElement.classList.add('json-node-stub');
        var anchor = document.createElement('a');
        anchor.href = 'javascript:';
        anchor.classList.add('json-node-stub-toggler');
        stubElement.headerElement = anchor;
        this.generateAccessor(anchor);
        var end = Math.min(node.length, start + limit) - 1;
        var label = document.createElement('span');
        label.classList.add('json-node-label');
        label.appendChild(document.createTextNode('[' + start + ' ... ' + end + ']'));
        anchor.appendChild(label);
        stubElement.appendChild(anchor);
        anchor.addEventListener('click', function (e) { return __awaiter(_this, void 0, void 0, function () {
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        e.preventDefault();
                        if (!stubElement.isNodeOpen()) return [3 /*break*/, 1];
                        this.closePaginationStub(stubElement, true);
                        return [3 /*break*/, 3];
                    case 1:
                        _a = this.openPaginationStub;
                        _b = [stubElement,
                            node];
                        return [4 /*yield*/, this.getChildNodes(node.path, start, limit)];
                    case 2:
                        _a.apply(this, _b.concat([_c.sent(),
                            true]));
                        _c.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        }); });
        stubElement.isNodeOpen = function () {
            return anchor.classList.contains('json-node-open');
        };
        stubElement.openNode = function () { return __awaiter(_this, void 0, void 0, function () {
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        if (!!stubElement.isNodeOpen()) return [3 /*break*/, 3];
                        _a = this.openPaginationStub;
                        _b = [stubElement,
                            node];
                        return [4 /*yield*/, this.getChildNodes(node.path, start, limit)];
                    case 1: return [4 /*yield*/, _a.apply(this, _b.concat([_c.sent()]))];
                    case 2:
                        _c.sent();
                        return [2 /*return*/, true];
                    case 3: return [2 /*return*/, false];
                }
            });
        }); };
        stubElement.closeNode = function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (stubElement.isNodeOpen()) {
                    this.closePaginationStub(stubElement);
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, false];
            });
        }); };
        stubElement.toggleNode = function () {
            if (stubElement.isNodeOpen()) {
                return stubElement.closeNode();
            }
            else {
                return stubElement.openNode();
            }
        };
        return stubElement;
    };
    BigJsonViewerDom.prototype.closePaginationStub = function (stubElement, dispatchEvent) {
        if (dispatchEvent === void 0) { dispatchEvent = false; }
        if (stubElement.childrenElement) {
            stubElement.headerElement.classList.remove('json-node-open');
            stubElement.removeChild(stubElement.childrenElement);
            stubElement.childrenElement = null;
            if (dispatchEvent) {
                this.dispatchNodeEvent('closeStub', stubElement);
            }
        }
    };
    BigJsonViewerDom.prototype.openPaginationStub = function (stubElement, node, nodes, dispatchEvent) {
        if (dispatchEvent === void 0) { dispatchEvent = false; }
        stubElement.headerElement.classList.add('json-node-open');
        var children = document.createElement('div');
        children.classList.add('json-node-children');
        stubElement.childrenElement = children;
        this.addChildNodes(nodes, children, node.type === 'array' ? this.options.collapseSameValue : Infinity);
        stubElement.appendChild(children);
        if (dispatchEvent) {
            this.dispatchNodeEvent('openStub', stubElement);
        }
    };
    BigJsonViewerDom.prototype.addChildNodes = function (nodes, parent, collapseSameValue) {
        var _this = this;
        var lastValue;
        var sameValueCount = 0;
        nodes.forEach(function (node, i) {
            if (node.type !== 'object' &&
                node.type !== 'array' &&
                lastValue === node.value) {
                sameValueCount++;
                if (sameValueCount >= collapseSameValue) {
                    return;
                }
            }
            else if (sameValueCount >= collapseSameValue) {
                parent.appendChild(_this.getCollapseIndicator(sameValueCount));
                parent.appendChild(_this.getNodeElement(nodes[i - 1]));
                sameValueCount = 0;
            }
            else {
                sameValueCount = 0;
            }
            parent.appendChild(_this.getNodeElement(node));
            lastValue = node.value;
        });
        if (sameValueCount >= collapseSameValue) {
            parent.appendChild(this.getCollapseIndicator(sameValueCount - collapseSameValue));
            parent.appendChild(this.getNodeElement(nodes[nodes.length - 1]));
        }
    };
    BigJsonViewerDom.prototype.getCollapseIndicator = function (count) {
        var element = document.createElement('div');
        element.classList.add('json-node-collapse');
        element.appendChild(document.createTextNode('... [' + count + '] ...'));
        return element;
    };
    BigJsonViewerDom.prototype.getNodeHeader = function (node) {
        var element = document.createElement('div');
        element.classList.add('json-node-header');
        element.classList.add('json-node-' + node.type);
        var keyHighlightPattern = this.currentArea === 'all' || this.currentArea === 'keys'
            ? this.currentPattern
            : null;
        var valueHighlightPattern = this.currentArea === 'all' || this.currentArea === 'values'
            ? this.currentPattern
            : null;
        if (node.type === 'object' || node.type === 'array') {
            var anchor = document.createElement('a');
            anchor.classList.add('json-node-toggler');
            anchor.href = 'javascript:';
            if (node.length) {
                this.attachClickToggleListener(anchor);
                this.generateAccessor(anchor);
            }
            this.generateLabel(anchor, node, keyHighlightPattern);
            this.generateTypeInfo(anchor, node);
            element.appendChild(anchor);
        }
        else {
            this.generateLabel(element, node, keyHighlightPattern);
            this.generateValue(element, node, valueHighlightPattern);
            this.generateTypeInfo(element, node);
        }
        this.generateLinks(element, node);
        return element;
    };
    BigJsonViewerDom.prototype.generateAccessor = function (parent) {
        var span = document.createElement('span');
        span.classList.add('json-node-accessor');
        parent.appendChild(span);
    };
    BigJsonViewerDom.prototype.generateTypeInfo = function (parent, node) {
        var typeInfo = document.createElement('span');
        typeInfo.classList.add('json-node-type');
        if (node.type === 'object') {
            typeInfo.appendChild(document.createTextNode('Object(' + node.length + ')'));
        }
        else if (node.type === 'array') {
            typeInfo.appendChild(document.createTextNode('Array[' + node.length + ']'));
        }
        else {
            typeInfo.appendChild(document.createTextNode(node.type));
        }
        parent.appendChild(typeInfo);
    };
    BigJsonViewerDom.prototype.generateLabel = function (parent, node, highlightPattern) {
        if (!node.path.length) {
            return;
        }
        var label = document.createElement('span');
        label.classList.add('json-node-label');
        if (this.options.labelAsPath && node.path.length > 1) {
            var prefix = document.createElement('span');
            prefix.classList.add('json-node-label-prefix');
            prefix.appendChild(document.createTextNode(node.path.slice(0, node.path.length - 1).join('.') + '.'));
            label.appendChild(prefix);
        }
        label.appendChild(this.getHighlightedText(node.path[node.path.length - 1], highlightPattern));
        parent.appendChild(label);
        parent.appendChild(document.createTextNode(': '));
    };
    BigJsonViewerDom.prototype.generateValue = function (parent, node, highlightPattern) {
        var valueElement = document.createElement('span');
        valueElement.classList.add('json-node-value');
        valueElement.appendChild(this.getHighlightedText(JSON.stringify(node.value), highlightPattern));
        parent.appendChild(valueElement);
    };
    BigJsonViewerDom.prototype.getLabelNode = function (label) {
        if (label instanceof Node) {
            return label;
        }
        return document.createTextNode(label);
    };
    BigJsonViewerDom.prototype.generateLinks = function (parent, node) {
        var _this = this;
        if (this.isOpenableNode(node) && this.options.linkLabelExpandAll) {
            var link = parent.appendChild(document.createElement('a'));
            link.classList.add('json-node-link');
            link.href = 'javascript:';
            link.appendChild(this.getLabelNode(this.options.linkLabelExpandAll));
            link.addEventListener('click', function (e) {
                e.preventDefault();
                var nodeElement = _this.findNodeElement(parent);
                if (nodeElement && _this.isOpenableNode(nodeElement.jsonNode)) {
                    _this.openAll(nodeElement, Infinity, 'first', true);
                }
            });
        }
        if (node.path.length && this.options.linkLabelCopyPath) {
            var link = parent.appendChild(document.createElement('a'));
            link.classList.add('json-node-link');
            link.href = 'javascript:';
            link.appendChild(this.getLabelNode(this.options.linkLabelCopyPath));
            link.addEventListener('click', function (e) {
                e.preventDefault();
                var input = document.createElement('input');
                input.type = 'text';
                input.value = node.path.join('.');
                var nodeElement = _this.findNodeElement(parent);
                _this.dispatchNodeEvent('copyPath', nodeElement);
                parent.appendChild(input);
                input.select();
                try {
                    if (!document.execCommand('copy')) {
                        console.warn('Unable to copy path to clipboard');
                    }
                }
                catch (e) {
                    console.error('Unable to copy path to clipboard', e);
                }
                parent.removeChild(input);
            });
        }
        if (typeof this.options.addLinksHook === 'function') {
            for (var _i = 0, _a = this.options.addLinksHook(node); _i < _a.length; _i++) {
                var element = _a[_i];
                parent.appendChild(element);
            }
        }
    };
    BigJsonViewerDom.prototype.findNodeElement = function (el) {
        while (el && !el['jsonNode']) {
            el = el.parentElement;
        }
        return el;
    };
    return BigJsonViewerDom;
}());
exports.BigJsonViewerDom = BigJsonViewerDom;
//# sourceMappingURL=big-json-viewer-dom.js.map