"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var json_node_search_1 = require("./parser/json-node-search");
var buffer_json_parser_1 = require("./parser/buffer-json-parser");
var js_parser_1 = require("./parser/js-parser");
var BigJsonViewerService = /** @class */ (function () {
    function BigJsonViewerService() {
    }
    BigJsonViewerService.prototype.initWithData = function (data) {
        this.rootNode = new buffer_json_parser_1.BufferJsonParser(data).getRootNodeInfo();
        return this.getRenderInfo(this.rootNode);
    };
    BigJsonViewerService.prototype.initWithJs = function (data) {
        this.rootNode = new js_parser_1.JsParser(data).getRootNodeInfo();
        return this.getRenderInfo(this.rootNode);
    };
    BigJsonViewerService.prototype.getNodes = function (path, start, limit) {
        var _this = this;
        var node = this.rootNode.getByPath(path);
        if (node && node.type === 'object') {
            return node.getObjectNodes(start, limit).map(function (n) { return _this.getRenderInfo(n); });
        }
        if (node && node.type === 'array') {
            return node.getArrayNodes(start, limit).map(function (n) { return _this.getRenderInfo(n); });
        }
        return null;
    };
    BigJsonViewerService.prototype.getKeyIndex = function (path, key) {
        var node = this.rootNode.getByPath(path);
        if (!node) {
            return -1;
        }
        var keys = node.getObjectKeys();
        return keys.indexOf(key);
    };
    BigJsonViewerService.prototype.search = function (pattern, searchArea) {
        return json_node_search_1.searchJsonNodes(this.rootNode, pattern, searchArea);
    };
    BigJsonViewerService.prototype.getRenderInfo = function (node) {
        var info = {
            type: node.type,
            length: node.length,
            path: node.path,
            openable: this.isOpenableNode(node)
        };
        if (!info.openable) {
            info.value = node.getValue();
        }
        return info;
    };
    BigJsonViewerService.prototype.isOpenableNode = function (node) {
        return (node.type === 'array' || node.type === 'object') && !!node.length;
    };
    return BigJsonViewerService;
}());
exports.BigJsonViewerService = BigJsonViewerService;
//# sourceMappingURL=big-json-viewer-service.js.map