"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var WorkerClient = /** @class */ (function () {
    function WorkerClient(worker) {
        this.worker = worker;
        this.requestIndex = 0;
        this.requestCallbacks = {};
    }
    WorkerClient.prototype.initWorker = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.worker.onmessage = function (msg) {
                var data = msg.data;
                if (data._init === true) {
                    _this.initialized = true;
                    resolve(true);
                    return;
                }
                if (data.resultId && _this.requestCallbacks[data.resultId]) {
                    var callb = _this.requestCallbacks[data.resultId];
                    delete _this.requestCallbacks[data.resultId];
                    callb(data);
                }
            };
            _this.worker.onerror = function (e) {
                if (!_this.initialized) {
                    reject(e);
                }
                else {
                    console.error('Worker error', e);
                }
            };
            _this.worker.postMessage({ _init: true });
        });
    };
    WorkerClient.prototype.call = function (handler) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return this.callWorker.apply(this, [handler, undefined].concat(args));
    };
    WorkerClient.prototype.callWorker = function (handler, transfers) {
        var _this = this;
        if (transfers === void 0) { transfers = undefined; }
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        return new Promise(function (resolve, reject) {
            var resultId = ++_this.requestIndex;
            _this.requestCallbacks[resultId] = function (data) {
                if (data.error !== undefined) {
                    reject(data.error);
                    return;
                }
                resolve(data.result);
            };
            _this.worker.postMessage({
                handler: handler,
                args: args,
                resultId: resultId
            }, transfers);
        });
    };
    WorkerClient.prototype.destroy = function () {
        this.worker.terminate();
        this.worker = null;
        this.requestCallbacks = null;
    };
    return WorkerClient;
}());
exports.WorkerClient = WorkerClient;
var WorkerClientMock = /** @class */ (function () {
    function WorkerClientMock(provider) {
        this.provider = provider;
    }
    WorkerClientMock.prototype.call = function (handler) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return this.callWorker.apply(this, [handler, undefined].concat(args));
    };
    WorkerClientMock.prototype.callWorker = function (handler, transfers) {
        var _this = this;
        if (transfers === void 0) { transfers = undefined; }
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        return new Promise(function (resolve) {
            resolve(_this.provider[handler].apply(_this.provider, args));
        });
    };
    WorkerClientMock.prototype.destroy = function () {
        this.provider = null;
    };
    return WorkerClientMock;
}());
exports.WorkerClientMock = WorkerClientMock;
//# sourceMappingURL=worker-client.js.map