"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function initProvider(impl, scope) {
    if (scope === void 0) { scope = self; }
    scope.onmessage = function (msg) {
        var data = msg.data;
        if (data._init) {
            scope.postMessage({ _init: true });
            return;
        }
        if (data.handler && impl[data.handler]) {
            try {
                var result = impl[data.handler].apply(impl, data.args);
                if (data.resultId) {
                    scope.postMessage({
                        resultId: data.resultId,
                        result: result
                    });
                }
            }
            catch (e) {
                if (data.resultId) {
                    scope.postMessage({
                        resultId: data.resultId,
                        error: e.toString()
                    });
                }
            }
        }
    };
}
exports.initProvider = initProvider;
//# sourceMappingURL=worker-provider.js.map