import { JsonNodeInfo, NodeType } from './json-node-info';
export interface ParseContext {
    path: string[];
    start?: number;
    limit?: number;
    objectKey?: string;
    objectKeys?: string[];
    objectNodes?: BufferJsonNodeInfo[];
    arrayNodes?: BufferJsonNodeInfo[];
    value?: string | number | boolean;
    nodeInfo?: BufferJsonNodeInfo;
}
export declare class BufferJsonNodeInfo implements JsonNodeInfo {
    type: NodeType;
    path: string[];
    length?: number;
    chars: number;
    private parser;
    private index;
    constructor(parser: BufferJsonParser, index: number, path: string[]);
    /**
     * Returns the list of keys in case of an object for the defined range
     * @param {number} start
     * @param {number} limit
     */
    getObjectKeys(start?: number, limit?: number): string[];
    /**
     * Return the NodeInfo at the defined position.
     * Use the index from getObjectKeys
     * @param index
     */
    getByIndex(index: number): BufferJsonNodeInfo;
    /**
     * Return the NodeInfo for the specified key
     * Use the index from getObjectKeys
     * @param key
     */
    getByKey(key: string): BufferJsonNodeInfo;
    /**
     * Find the information for a given path
     * @param {string[]} path
     */
    getByPath(path: string[]): BufferJsonNodeInfo;
    /**
     * Returns a list with the NodeInfo objects for the defined range
     * @param {number} start
     * @param {number} limit
     */
    getObjectNodes(start?: number, limit?: number): BufferJsonNodeInfo[];
    /**
     * Returns a list of NodeInfo for the defined range
     * @param {number} start
     * @param {number} limit
     */
    getArrayNodes(start?: number, limit?: number): BufferJsonNodeInfo[];
    /**
     * Get the natively parsed value
     */
    getValue(): any;
}
/**
 * Parses meta data about a JSON structure in an ArrayBuffer.
 */
export declare class BufferJsonParser {
    data: Uint16Array;
    constructor(data: ArrayBuffer | string);
    getRootNodeInfo(): BufferJsonNodeInfo;
    parseValue(start: number, ctx?: ParseContext, throwUnknown?: boolean): number;
    parseObject(start: number, ctx?: ParseContext): number;
    parseArray(start: number, ctx?: ParseContext): number;
    parseString(start: number, ctx?: ParseContext): number;
    parseNumber(start: number, ctx?: ParseContext): number;
    private parseDigits;
    parseToken(start: any, chars: any, ctx?: ParseContext): number;
    parseNative(start: any, end: any): any;
    private skipIgnored;
}
