import { JsonNodeInfo, NodeType } from './json-node-info';
export declare class JsJsonNodeInfo implements JsonNodeInfo {
    type: NodeType;
    path: string[];
    length?: number;
    private readonly ref;
    constructor(ref: any, path: string[]);
    /**
     * Returns the list of keys in case of an object for the defined range
     * @param {number} start
     * @param {number} limit
     */
    getObjectKeys(start?: number, limit?: number): string[];
    /**
     * Return the NodeInfo at the defined position.
     * Use the index from getObjectKeys
     * @param index
     */
    getByIndex(index: number): JsJsonNodeInfo;
    /**
     * Return the NodeInfo for the specified key
     * Use the index from getObjectKeys
     * @param key
     */
    getByKey(key: string): JsJsonNodeInfo;
    /**
     * Find the information for a given path
     * @param {string[]} path
     */
    getByPath(path: string[]): JsJsonNodeInfo;
    /**
     * Returns a list with the NodeInfo objects for the defined range
     * @param {number} start
     * @param {number} limit
     */
    getObjectNodes(start?: number, limit?: number): JsJsonNodeInfo[];
    /**
     * Returns a list of NodeInfo for the defined range
     * @param {number} start
     * @param {number} limit
     */
    getArrayNodes(start?: number, limit?: number): JsJsonNodeInfo[];
    /**
     * Get the natively parsed value
     */
    getValue(): any;
}
export declare class JsParser {
    data: any;
    constructor(data: any);
    getRootNodeInfo(): JsJsonNodeInfo;
}
