"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// search only in values
function searchJsonNodes(node, pattern, searchArea) {
    if (searchArea === void 0) { searchArea = 'all'; }
    pattern = ensureGlobal(pattern);
    var results = [];
    if (node.path.length && (searchArea === 'all' || searchArea === 'keys')) {
        forEachMatchFromString(pattern, node.path[node.path.length - 1], function (index, length) {
            results.push({ path: node.path, key: index, length: length });
        });
    }
    if (node.type === 'object') {
        node.getObjectNodes().forEach(function (subNode) {
            results.push.apply(results, searchJsonNodes(subNode, pattern, searchArea));
        });
    }
    else if (node.type === 'array') {
        node.getArrayNodes().forEach(function (subNode) {
            results.push.apply(results, searchJsonNodes(subNode, pattern, searchArea));
        });
    }
    else if (searchArea === 'all' || searchArea === 'values') {
        forEachMatchFromString(pattern, String(node.getValue()), function (index, length) {
            results.push({ path: node.path, value: index, length: length });
        });
    }
    return results;
}
exports.searchJsonNodes = searchJsonNodes;
function forEachMatchFromString(pattern, subject, callback) {
    pattern = ensureGlobal(pattern);
    pattern.lastIndex = 0;
    var match = null;
    while ((match = pattern.exec(subject)) !== null) {
        callback(match.index, match[0].length);
    }
    pattern.lastIndex = 0;
}
exports.forEachMatchFromString = forEachMatchFromString;
function ensureGlobal(pattern) {
    if (!pattern.global) {
        var flags = 'g' + (pattern.ignoreCase ? 'i' : '') + (pattern.multiline ? 'm' : '');
        return new RegExp(pattern.source, flags);
    }
    return pattern;
}
//# sourceMappingURL=json-node-search.js.map