/**
 * Copyright (c) 2017 ~ present NAVER Corp.
 * billboard.js project is licensed under the MIT license
 */
/**
 * Modules exports for Axis based chart
 */
// Chart
import apiAxis from "../../Chart/api/axis";
import apiCategory from "../../Chart/api/category";
import apiFlow from "../../Chart/api/flow";
import apiGrid from "../../Chart/api/grid";
import apiGroup from "../../Chart/api/group";
import apiRegion from "../../Chart/api/regions";
import apiX from "../../Chart/api/x";

// ChartInternal
import axis from "../../ChartInternal/Axis/Axis";
import eventrect from "../../ChartInternal/interactions/eventrect";
import flow from "../../ChartInternal/interactions/flow";

import clip from "../../ChartInternal/internals/clip";
import grid from "../../ChartInternal/internals/grid";
import region from "../../ChartInternal/internals/region";
import sizeAxis from "../../ChartInternal/internals/size.axis";

// Axis based options
import optAxis from "../Options/axis/axis";
import optGrid from "../Options/common/grid";
import optDataAxis from "../Options/data/axis";

export const api = [
	apiAxis,
	apiCategory,
	apiFlow,
	apiGrid,
	apiGroup,
	apiRegion,
	apiX
];

export const internal = {
	axis,
	clip,
	eventrect,
	flow,
	grid,
	region,
	sizeAxis
};

export const options = {
	optDataAxis,
	optAxis,
	optGrid
};
