/*!
 * Copyright (c) 2017 ~ present NAVER Corp.
 * billboard.js project is licensed under the MIT license
 *
 * billboard.js, JavaScript chart library
 * https://naver.github.io/billboard.js/
 *
 * @version 3.3.3
 */
!function(t,e){if("object"==typeof exports&&"object"==typeof module)module.exports=e(require("d3-axis"),require("d3-brush"),require("d3-drag"),require("d3-dsv"),require("d3-ease"),require("d3-interpolate"),require("d3-scale"),require("d3-selection"),require("d3-shape"),require("d3-time-format"),require("d3-transition"),require("d3-zoom"));else if("function"==typeof define&&define.amd)define(["d3-axis","d3-brush","d3-drag","d3-dsv","d3-ease","d3-interpolate","d3-scale","d3-selection","d3-shape","d3-time-format","d3-transition","d3-zoom"],e);else{var i="object"==typeof exports?e(require("d3-axis"),require("d3-brush"),require("d3-drag"),require("d3-dsv"),require("d3-ease"),require("d3-interpolate"),require("d3-scale"),require("d3-selection"),require("d3-shape"),require("d3-time-format"),require("d3-transition"),require("d3-zoom")):e(t.d3,t.d3,t.d3,t.d3,t.d3,t.d3,t.d3,t.d3,t.d3,t.d3,t.d3,t.d3);for(var n in i)("object"==typeof exports?exports:t)[n]=i[n]}}(this,(function(t,e,i,n,a,r,s,o,l,c,u,d){return function(){"use strict";var h=[,,function(t){t.exports=o},function(t){t.exports=e},function(t){t.exports=c},function(t){t.exports=n},function(t){t.exports=s},function(t){t.exports=i},function(t){t.exports=u},function(t){t.exports=l},function(e){e.exports=t},function(t){t.exports=a},function(t){t.exports=r},function(t){t.exports=d}],g={};function f(t){var e=g[t];if(void 0!==e)return e.exports;var i=g[t]={exports:{}};return h[t](i,i.exports,f),i.exports}f.d=function(t,e){for(var i in e)f.o(e,i)&&!f.o(t,i)&&Object.defineProperty(t,i,{enumerable:!0,get:e[i]})},f.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},f.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})};var p={};return function(){f.r(p),f.d(p,{bb:function(){return On},default:function(){return On}});var t={};f.r(t),f.d(t,{area:function(){return Zi},areaLineRange:function(){return qi},areaSpline:function(){return Ki},areaSplineRange:function(){return Ji},areaStep:function(){return Qi},bar:function(){return ln},bubble:function(){return cn},candlestick:function(){return un},donut:function(){return an},gauge:function(){return rn},line:function(){return tn},pie:function(){return sn},radar:function(){return on},scatter:function(){return dn},spline:function(){return en},step:function(){return nn}});var e={};f.r(e),f.d(e,{selection:function(){return Sn},subchart:function(){return Cn},zoom:function(){return En}});var i=f(4),n=f(2),a="object"==typeof globalThis&&null!==globalThis&&globalThis.Object===Object&&globalThis||"object"==typeof global&&null!==global&&global.Object===Object&&global||"object"==typeof self&&null!==self&&self.Object===Object&&self||Function("return this")();a.requestIdleCallback=a.requestIdleCallback||function(t){return setTimeout(t,1)},a.cancelIdleCallback=a.cancelIdleCallback||function(t){return clearTimeout(t)};var r=null==a?void 0:a.document,s={AREA:"area",AREA_LINE_RANGE:"area-line-range",AREA_SPLINE:"area-spline",AREA_SPLINE_RANGE:"area-spline-range",AREA_STEP:"area-step",BAR:"bar",BUBBLE:"bubble",CANDLESTICK:"candlestick",DONUT:"donut",GAUGE:"gauge",LINE:"line",PIE:"pie",RADAR:"radar",SCATTER:"scatter",SPLINE:"spline",STEP:"step"},o={AREA:"initArea",AREA_LINE_RANGE:"initArea",AREA_SPLINE:"initArea",AREA_SPLINE_RANGE:"initArea",AREA_STEP:"initArea",BAR:"initBar",BUBBLE:"initCircle",CANDLESTICK:"initCandlestick",DONUT:"initArc",GAUGE:"initArc",LINE:"initLine",PIE:"initArc",RADAR:"initCircle",SCATTER:"initCircle",SPLINE:"initLine",STEP:"initLine"},l={Area:[s.AREA,s.AREA_SPLINE,s.AREA_SPLINE_RANGE,s.AREA_LINE_RANGE,s.AREA_STEP],AreaRange:[s.AREA_SPLINE_RANGE,s.AREA_LINE_RANGE],Arc:[s.PIE,s.DONUT,s.GAUGE,s.RADAR],Line:[s.LINE,s.SPLINE,s.AREA,s.AREA_SPLINE,s.AREA_SPLINE_RANGE,s.AREA_LINE_RANGE,s.STEP,s.AREA_STEP],Step:[s.STEP,s.AREA_STEP],Spline:[s.SPLINE,s.AREA_SPLINE,s.AREA_SPLINE_RANGE]};function c(t,e,i){return e in t?Object.defineProperty(t,e,{value:i,enumerable:!0,configurable:!0,writable:!0}):t[e]=i,t}var u=f(3);function d(t,e){var i=Object.keys(t);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(t);e&&(n=n.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),i.push.apply(i,n)}return i}function h(t){for(var e,i=1;i<arguments.length;i++)e=null!=arguments[i]?arguments[i]:{},i%2?d(Object(e),!0).forEach((function(i){c(t,i,e[i])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(e)):d(Object(e)).forEach((function(i){Object.defineProperty(t,i,Object.getOwnPropertyDescriptor(e,i))}));return t}var g=function(t){return t||0===t},v=function(t){return"function"==typeof t},x=function(t){return"string"==typeof t},_=function(t){return"number"==typeof t},m=function(t){return void 0===t},y=function(t){return void 0!==t},b=function(t){return"boolean"==typeof t},T=function(t){return 10*Math.ceil(t/10)},w=function(t){return Math.ceil(t)+.5},A=function(t){return t[1]-t[0]},k=function(t){return"object"==typeof t},S=function(t){return m(t)||null===t||x(t)&&0===t.length||k(t)&&!(t instanceof Date)&&0===Object.keys(t).length||_(t)&&isNaN(t)},C=function(t){return!S(t)},E=function(t){return Array.isArray(t)},R=function(t){return t&&!(null!=t&&t.nodeType)&&k(t)&&!E(t)};function O(t,e,i){return y(t[e])?t[e]:i}function L(t,e){for(var i=v(t),n=arguments.length,a=Array(n>2?n-2:0),r=2;r<n;r++)a[r-2]=arguments[r];return i&&t.call.apply(t,[e].concat(a)),i}function D(t,e){var i=0,n=function(){for(var t=arguments.length,n=Array(t),a=0;a<t;a++)n[a]=arguments[a];--i||e.apply.apply(e,[this].concat(n))};"duration"in t?t.each((function(){return++i})).on("end",n):(++i,t.call(n))}function I(t){return x(t)?t.replace(/</g,"&lt;").replace(/>/g,"&gt;"):t}function P(t,e,i,n){if(void 0===i&&(i=[-1,1]),void 0===n&&(n=!1),t&&x(e))if(-1===e.indexOf("\n"))t.text(e);else{var a=[t.text(),e].map((function(t){return t.replace(/[\s\n]/g,"")}));if(a[0]!==a[1]){var r=e.split("\n"),s=n?r.length-1:1;t.html(""),r.forEach((function(e,n){t.append("tspan").attr("x",0).attr("dy",(0===n?i[0]*s:i[1])+"em").text(e)}))}}}function z(t){var e=t.getBBox(),i=e.x,n=e.y,a=e.width,r=e.height;return[{x:i,y:n+r},{x:i,y:n},{x:i+a,y:n},{x:i+a,y:n+r}]}function M(t,e){var i,a=t&&(null==(i=t.touches||t.sourceEvent&&t.sourceEvent.touches)?void 0:i[0]);return(0,n.pointer)(a||t,e).map((function(t){return isNaN(t)?0:t}))}function X(t){var e,i=t.event,n=t.$el,a=n.subchart.main||n.main;return i&&"brush"===i.type?e=i.selection:a&&(e=a.select(".bb-brush").node())&&(e=(0,u.brushSelection)(e)),e}function $(t){return!("rect"in t)||"rect"in t&&t.hasAttribute("width")&&t.rect.width!==+t.getAttribute("width")?t.rect=t.getBoundingClientRect():t.rect}function F(t,e,i){void 0===t&&(t=!0),void 0===e&&(e=0),void 0===i&&(i=1e4);var n=Math.floor(Math.random()*(i-e)+e);return t?n+"":n}function B(t,e,i,n,a){if(i>n)return-1;var r=Math.floor((i+n)/2),s=t[r],o=s.x,l=s.w,c=void 0===l?0:l;return a&&(o=t[r].y,c=t[r].h),e>=o&&e<=o+c?r:e<o?B(t,e,i,r-1,a):B(t,e,r+1,n,a)}function N(t){var e=X(t);return!e||e[0]===e[1]}function Y(t,e){for(var i in void 0===t&&(t={}),E(e)&&e.forEach((function(e){return Y(t,e)})),e)/^\d+$/.test(i)||i in t||(t[i]=e[i]);return t}var G=function(t){return t.charAt(0).toUpperCase()+t.slice(1)};var j=function(t){return[].slice.call(t)};function V(t){var e=t?t.transform:null,i=e&&e.baseVal;return i&&i.numberOfItems?i.getItem(0).matrix:{a:0,b:0,c:0,d:0,e:0,f:0}}function H(t){var e=t[0]instanceof Date,i=(e?t.map(Number):t).filter((function(t,e,i){return i.indexOf(t)===e}));return e?i.map((function(t){return new Date(t)})):i}function W(t){return t&&t.length?t.reduce((function(t,e){return t.concat(e)})):[]}function U(t){for(var e=arguments.length,i=Array(e>1?e-1:0),n=1;n<e;n++)i[n-1]=arguments[n];if(!i.length||1===i.length&&!i[0])return t;var a=i.shift();return R(t)&&R(a)&&Object.keys(a).forEach((function(e){var i=a[e];R(i)?(t[e]||(t[e]={}),t[e]=U(t[e],i)):t[e]=E(i)?i.concat():i})),U.apply(void 0,[t].concat(i))}function Z(t,e){var i;return void 0===e&&(e=!0),t[0]instanceof Date?i=e?function(t,e){return t-e}:function(t,e){return e-t}:e&&!t.every(isNaN)?i=function(t,e){return t-e}:e||(i=function(t,e){return(t>e?-1:t<e&&1)||t===e&&0}),t.concat().sort(i)}function q(t,e){var i=e.filter((function(t){return C(t)}));return i.length?_(i[0])?i=Math[t].apply(Math,i):i[0]instanceof Date&&(i=Z(i,"min"===t)[0]):i=void 0,i}var K=function(t,e,i){void 0===i&&(i=1);for(var n=[],a=0|Math.max(0,Math.ceil((e-t)/i)),r=t;r<a;r++)n.push(t+r*i);return n},J={mouse:function(){try{return new MouseEvent("t"),function(t,e,i){void 0===i&&(i={bubbles:!1,cancelable:!1,screenX:0,screenY:0,clientX:0,clientY:0}),t.dispatchEvent(new MouseEvent(e,i))}}catch(t){return function(t,e,i){void 0===i&&(i={bubbles:!1,cancelable:!1,screenX:0,screenY:0,clientX:0,clientY:0});var n=r.createEvent("MouseEvent");n.initMouseEvent(e,i.bubbles,i.cancelable,a,0,i.screenX,i.screenY,i.clientX,i.clientY,!1,!1,!1,!1,0,null),t.dispatchEvent(n)}}}(),touch:function(t,e,i){var n=new Touch(U({identifier:Date.now(),target:t,radiusX:2.5,radiusY:2.5,rotationAngle:10,force:.5},i));t.dispatchEvent(new TouchEvent(e,{cancelable:!0,bubbles:!0,shiftKey:!0,touches:[n],targetTouches:[],changedTouches:[n]}))}};function Q(t,e){var i=t;for(var n in e)i=i.replace(new RegExp("{="+n+"}","g"),e[n]);return i}function tt(t){var e;if(t instanceof Date)e=t;else if(x(t)){var i=this.config;e=this.format.dataTime(i.data_xFormat)(t)}else _(t)&&!isNaN(t)&&(e=new Date(+t));return e&&!isNaN(+e)||console&&console.error&&console.error("Failed to parse x '"+t+"' to Date object"),e}function et(){return!r.hidden}function it(t){var e,i=t,n=i.config,r="";if(S(n.data_type||n.data_types)&&!i[o.LINE])r="line";else for(var l in o){var c=s[l];if(i.hasType(c)&&!i[o[l]]){r=c;break}}r&&function(t,e){var i,n="[billboard.js]";(null==(i=a.console)?void 0:i.error)&&(console.error("❌ "+n+" "+t,"background:red;color:white;display:block;font-size:15px",e),console.info("%cℹ️","font-size:15px","https://github.com/naver/billboard.js/wiki/CHANGELOG-v2#modularization-by-its-functionality"));throw Error(n+" "+t.replace(/\%c([a-z-]+)/i,"'$1' ")+" "+e)}("Please, make sure if %c"+(void 0===e&&(e="-"),r.split(e).map((function(t,e){return e?t.charAt(0).toUpperCase()+t.slice(1).toLowerCase():t.toLowerCase()})).join("")),"module has been imported and specified correctly.")}function nt(t,e){var i=Object.keys(t);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(t);e&&(n=n.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),i.push.apply(i,n)}return i}function at(t){for(var e,i=1;i<arguments.length;i++)e=null!=arguments[i]?arguments[i]:{},i%2?nt(Object(e),!0).forEach((function(i){c(t,i,e[i])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(e)):nt(Object(e)).forEach((function(i){Object.defineProperty(t,i,Object.getOwnPropertyDescriptor(e,i))}));return t}var rt={button:"bb-button",chart:"bb-chart",empty:"bb-empty",main:"bb-main",target:"bb-target",EXPANDED:"_expanded_"},st={arc:"bb-arc",arcLabelLine:"bb-arc-label-line",arcs:"bb-arcs",chartArc:"bb-chart-arc",chartArcs:"bb-chart-arcs",chartArcsBackground:"bb-chart-arcs-background",chartArcsTitle:"bb-chart-arcs-title"},ot={area:"bb-area",areas:"bb-areas"},lt={axis:"bb-axis",axisX:"bb-axis-x",axisXLabel:"bb-axis-x-label",axisY:"bb-axis-y",axisY2:"bb-axis-y2",axisY2Label:"bb-axis-y2-label",axisYLabel:"bb-axis-y-label"},ct={bar:"bb-bar",bars:"bb-bars",chartBar:"bb-chart-bar",chartBars:"bb-chart-bars"},ut={candlestick:"bb-candlestick",candlesticks:"bb-candlesticks",chartCandlestick:"bb-chart-candlestick",chartCandlesticks:"bb-chart-candlesticks",valueDown:"bb-value-down",valueUp:"bb-value-up"},dt={chartCircles:"bb-chart-circles",circle:"bb-circle",circles:"bb-circles"},ht={colorPattern:"bb-color-pattern",colorScale:"bb-colorscale"},gt={dragarea:"bb-dragarea",INCLUDED:"_included_"},ft={chartArcsGaugeMax:"bb-chart-arcs-gauge-max",chartArcsGaugeMin:"bb-chart-arcs-gauge-min",chartArcsGaugeUnit:"bb-chart-arcs-gauge-unit",chartArcsGaugeTitle:"bb-chart-arcs-gauge-title",gaugeValue:"bb-gauge-value"},pt={legend:"bb-legend",legendBackground:"bb-legend-background",legendItem:"bb-legend-item",legendItemEvent:"bb-legend-item-event",legendItemHidden:"bb-legend-item-hidden",legendItemPoint:"bb-legend-item-point",legendItemTile:"bb-legend-item-tile"},vt={chartLine:"bb-chart-line",chartLines:"bb-chart-lines",line:"bb-line",lines:"bb-lines"},xt={eventRect:"bb-event-rect",eventRects:"bb-event-rects",eventRectsMultiple:"bb-event-rects-multiple",eventRectsSingle:"bb-event-rects-single"},_t={focused:"bb-focused",defocused:"bb-defocused",legendItemFocused:"bb-legend-item-focused",xgridFocus:"bb-xgrid-focus",ygridFocus:"bb-ygrid-focus"},mt={grid:"bb-grid",gridLines:"bb-grid-lines",xgrid:"bb-xgrid",xgridLine:"bb-xgrid-line",xgridLines:"bb-xgrid-lines",xgrids:"bb-xgrids",ygrid:"bb-ygrid",ygridLine:"bb-ygrid-line",ygridLines:"bb-ygrid-lines",ygrids:"bb-ygrids"},yt={chartRadar:"bb-chart-radar",chartRadars:"bb-chart-radars",level:"bb-level",levels:"bb-levels"},bt={region:"bb-region",regions:"bb-regions"},Tt={selectedCircle:"bb-selected-circle",selectedCircles:"bb-selected-circles",SELECTED:"_selected_"},wt={shape:"bb-shape",shapes:"bb-shapes"},At={brush:"bb-brush",subchart:"bb-subchart"},kt={chartText:"bb-chart-text",chartTexts:"bb-chart-texts",text:"bb-text",texts:"bb-texts",title:"bb-title",TextOverlapping:"text-overlapping"},St={tooltip:"bb-tooltip",tooltipContainer:"bb-tooltip-container",tooltipName:"bb-tooltip-name"},Ct={buttonZoomReset:"bb-zoom-reset",zoomBrush:"bb-zoom-brush"},Et=at(at(at(at(at(at(at(at(at(at(at(at(at(at(at(at(at(at(at(at(at(at(at({},rt),st),ot),lt),ct),ut),dt),ht),gt),ft),pt),vt),xt),_t),mt),yt),bt),Tt),wt),At),kt),St),Ct),Rt={element:function(){return{chart:null,main:null,svg:null,axis:{x:null,y:null,y2:null,subX:null},defs:null,tooltip:null,legend:null,title:null,subchart:{main:null,bar:null,line:null,area:null},arcs:null,bar:null,candlestick:null,line:null,area:null,circle:null,radar:null,text:null,grid:{main:null,x:null,y:null},gridLines:{main:null,x:null,y:null},region:{main:null,list:null},eventRect:null,zoomResetBtn:null}},state:function(){return{width:0,width2:0,height:0,height2:0,margin:{top:0,bottom:0,left:0,right:0},margin2:{top:0,bottom:0,left:0,right:0},margin3:{top:0,bottom:0,left:0,right:0},arcWidth:0,arcHeight:0,xAxisHeight:0,hasAxis:!1,hasRadar:!1,current:{width:0,height:0,dataMax:0,maxTickWidths:{x:{size:0,ticks:[],clipPath:0,domain:""},y:{size:0,domain:""},y2:{size:0,domain:""}},types:[]},isLegendRight:!1,isLegendInset:!1,isLegendTop:!1,isLegendLeft:!1,legendStep:0,legendItemWidth:0,legendItemHeight:0,legendHasRendered:!1,eventReceiver:{currentIdx:-1,rect:{},data:[],coords:[]},axis:{x:{padding:{left:0,right:0},tickCount:0}},rotatedPadding:{left:30,right:0,top:5},withoutFadeIn:{},inputType:"",datetimeId:"",clip:{id:"",idXAxis:"",idYAxis:"",idXAxisTickTexts:"",idGrid:"",idSubchart:"",path:"",pathXAxis:"",pathYAxis:"",pathXAxisTickTexts:"",pathGrid:""},event:null,dragStart:null,dragging:!1,flowing:!1,cancelClick:!1,mouseover:!1,rendered:!1,transiting:!1,redrawing:!1,resizing:!1,toggling:!1,zooming:!1,hasNegativeValue:!1,hasPositiveValue:!0,orgAreaOpacity:"0.2",hiddenTargetIds:[],hiddenLegendIds:[],focusedTargetIds:[],defocusedTargetIds:[],radius:0,innerRadius:0,outerRadius:void 0,innerRadiusRatio:0,gaugeArcWidth:0,radiusExpanded:0,xgridAttr:{x1:null,x2:null,y1:null,y2:null}}}},Ot=function(){function t(){var t=this;Object.keys(Rt).forEach((function(e){t[e]=new Rt[e]}))}return t.prototype.getStore=function(t){return this[t]},t}(),Lt={bindto:"#chart",background:{},clipPath:!0,svg_classname:void 0,size_width:void 0,size_height:void 0,padding:!0,padding_left:void 0,padding_right:void 0,padding_top:void 0,padding_bottom:void 0,resize_auto:!0,onover:void 0,onout:void 0,onresize:void 0,onresized:void 0,onbeforeinit:void 0,oninit:void 0,onafterinit:void 0,onrendered:void 0,transition_duration:250,plugins:[],render:{},regions:[]},Dt={data_x:void 0,data_idConverter:function(t){return t},data_names:{},data_classes:{},data_type:void 0,data_types:{},data_order:"desc",data_groups:[],data_color:void 0,data_colors:{},data_labels:{},data_labels_backgroundColors:void 0,data_labels_colors:void 0,data_labels_position:{},data_hide:!1,data_filter:void 0,data_onclick:function(){},data_onover:function(){},data_onout:function(){},data_onshown:void 0,data_onhidden:void 0,data_onmin:void 0,data_onmax:void 0,data_url:void 0,data_headers:void 0,data_json:void 0,data_rows:void 0,data_columns:void 0,data_mimeType:"csv",data_keys:void 0,data_empty_label_text:""},It={color_pattern:[],color_tiles:void 0,color_threshold:{},color_onover:void 0},Pt={interaction_enabled:!0,interaction_brighten:!0,interaction_inputType_mouse:!0,interaction_inputType_touch:{}},zt={legend_show:!0,legend_hide:!1,legend_contents_bindto:void 0,legend_contents_template:void 0,legend_position:"bottom",legend_inset_anchor:"top-left",legend_inset_x:10,legend_inset_y:0,legend_inset_step:void 0,legend_item_onclick:void 0,legend_item_onover:void 0,legend_item_onout:void 0,legend_equally:!1,legend_padding:0,legend_item_tile_width:10,legend_item_tile_height:10,legend_usePoint:!1},Mt={title_text:void 0,title_padding:{top:0,right:0,bottom:0,left:0},title_position:"center"},Xt={tooltip_show:!0,tooltip_doNotHide:!1,tooltip_grouped:!0,tooltip_format_title:void 0,tooltip_format_name:void 0,tooltip_format_value:void 0,tooltip_position:void 0,tooltip_contents:{},tooltip_init_show:!1,tooltip_init_x:0,tooltip_init_position:{top:"0px",left:"50px"},tooltip_linked:!1,tooltip_linked_name:"",tooltip_onshow:function(){},tooltip_onhide:function(){},tooltip_onshown:function(){},tooltip_onhidden:function(){},tooltip_order:null};function $t(t,e){var i=Object.keys(t);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(t);e&&(n=n.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),i.push.apply(i,n)}return i}function Ft(t){for(var e,i=1;i<arguments.length;i++)e=null!=arguments[i]?arguments[i]:{},i%2?$t(Object(e),!0).forEach((function(i){c(t,i,e[i])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(e)):$t(Object(e)).forEach((function(i){Object.defineProperty(t,i,Object.getOwnPropertyDescriptor(e,i))}));return t}var Bt=function(){function t(){return function(){for(var t=function(e){if(R(e)&&e.constructor){var i=new e.constructor;for(var n in e)i[n]=t(e[n]);return i}return e},e=arguments.length,i=Array(e),n=0;n<e;n++)i[n]=arguments[n];return i.map((function(e){return t(e)})).reduce((function(t,e){return h(h({},t),e)}))}(Lt,Dt,It,Pt,zt,Mt,Xt,t.data)}return t.setOptions=function(t){this.data=t.reduce((function(t,e){return Ft(Ft({},t),e)}),this.data)},t}();Bt.data={};var Nt="$baseLength",Yt="__colorPattern__",Gt="$dataMinMax",jt="$dataTotalSum",Vt="$totalPerIndex",Ht="legendItemTextBox",Wt="$radarPoints",Ut="setOverOut",Zt="callOverOutForTouch",qt="textRect",Kt=function(){function t(){this.cache={}}var e=t.prototype;return e.add=function(t,e,i){return void 0===i&&(i=!1),this.cache[t]=i?this.cloneTarget(e):e,this.cache[t]},e.remove=function(t){var e=this;j(t).forEach((function(t){return delete e.cache[t]}))},e.get=function(t,e){if(void 0===e&&(e=!1),e){for(var i,n=[],a=0;i=t[a];a++)i in this.cache&&n.push(this.cloneTarget(this.cache[i]));return n}var r=this.cache[t];return g(r)?r:null},e.reset=function(t){for(var e in this.cache)(t||/^\$/.test(e))&&(this.cache[e]=null)},e.cloneTarget=function(t){return{id:t.id,id_org:t.id_org,values:t.values.map((function(t){return{x:t.x,value:t.value,id:t.id}}))}},t}(),Jt=a.setTimeout,Qt=a.clearTimeout;function te(){var t=[],e=function(e,i){var n;!function e(){for(var a,r=0,s=0;a=t[s];s++)if(!0===a||null!=a.empty&&a.empty())r++;else try{a.transition()}catch(t){r++}n&&Qt(n),r===t.length?null==i||i():n=Jt(e,50)}()};return e.add=function(e){E(e)?t=t.concat(e):t.push(e)},e}var ee=f(5),ie={convertData:function(t,e){var i;if(t.bindto?(i={},["url","mimeType","headers","keys","json","keys","rows","columns"].forEach((function(e){var n="data_"+e;n in t&&(i[e]=t[n])}))):i=t,i.url&&e)this.convertUrlToData(i.url,i.mimeType,i.headers,i.keys,e);else if(i.json)i=this.convertJsonToData(i.json,i.keys);else if(i.rows)i=this.convertRowsToData(i.rows);else if(i.columns)i=this.convertColumnsToData(i.columns);else if(t.bindto)throw Error("url or json or rows or columns is required.");return E(i)&&i},convertUrlToData:function(t,e,i,n,a){var r=this;void 0===e&&(e="csv");var s=new XMLHttpRequest;s.open("GET",t),i&&Object.keys(i).forEach((function(t){s.setRequestHeader(t,i[t])})),s.onreadystatechange=function(){if(4===s.readyState){if(200!==s.status)throw new Error(t+": Something went wrong loading!");var i=s.responseText;i&&a.call(r,r["convert"+G(e)+"ToData"]("json"===e?JSON.parse(i):i,n))}},s.send()},convertCsvTsvToData:function(t,e){var i,n=t.rows(e);return 1===n.length?(i=[{}],n[0].forEach((function(t){i[0][t]=null}))):i=t.parse(e),i},convertCsvToData:function(t){return this.convertCsvTsvToData({rows:ee.csvParseRows,parse:ee.csvParse},t)},convertTsvToData:function(t){return this.convertCsvTsvToData({rows:ee.tsvParseRows,parse:ee.tsvParse},t)},convertJsonToData:function(t,e){var i,n,a=this,r=this.config,s=[];if(E(t)){var o=e||r.data_keys;o.x?(i=o.value.concat(o.x),r.data_x=o.x):i=o.value,s.push(i),t.forEach((function(t){var e=i.map((function(e){var i=a.findValueInJson(t,e);return m(i)&&(i=null),i}));s.push(e)})),n=this.convertRowsToData(s)}else Object.keys(t).forEach((function(e){var i=t[e].concat();i.unshift(e),s.push(i)})),n=this.convertColumnsToData(s);return n},findValueInJson:function(t,e){if(void 0!==t[e])return t[e];var i=e.replace(/\[(\w+)\]/g,".$1").replace(/^\./,"").split("."),n=t;return i.some((function(t){return!(n=n&&t in n?n[t]:void 0)})),n},convertRowsToData:function(t){var e=t[0],i=[];return t.forEach((function(t,n){if(n>0){var a={};t.forEach((function(t,i){if(m(t))throw new Error("Source data is missing a component at ("+n+", "+i+")!");a[e[i]]=t})),i.push(a)}})),i},convertColumnsToData:function(t){var e=[];return t.forEach((function(t,i){var n=t[0];t.forEach((function(t,a){if(a>0){if(m(e[a-1])&&(e[a-1]={}),m(t))throw new Error("Source data is missing a component at ("+i+", "+a+")!");e[a-1][n]=t}}))})),e},convertDataToTargets:function(t,e){var i=this,n=this,a=n.axis,r=n.config,s=n.state,o=!1,l=!1,c=!1;a&&(o=a.isCategorized(),l=a.isTimeSeries(),c=a.isCustomX());var u,d=Object.keys(t[0]||{}),h=d.length?d.filter(n.isNotX,n):[],f=d.length?d.filter(n.isX,n):[];h.forEach((function(a){var s=i.getXKey(a);c||l?f.indexOf(s)>=0?u=(e&&n.data.xs[a]||[]).concat(t.map((function(t){return t[s]})).filter(g).map((function(t,e){return n.generateTargetX(t,a,e)}))):r.data_x?u=i.getOtherTargetXs():C(r.data_xs)&&(u=n.getXValuesOfXKey(s,n.data.targets)):u=t.map((function(t,e){return e})),u&&(i.data.xs[a]=u)})),h.forEach((function(t){if(!i.data.xs[t])throw new Error('x is not defined for id = "'+t+'".')}));var p=h.map((function(e,i){var a=r.data_idConverter.bind(n.api)(e),l=n.getXKey(e),u=c&&o,d=u&&t.map((function(t){return t.x})).every((function(t){return r.axis_x_categories.indexOf(t)>-1})),h=t.__append__,g=null===l&&h?n.api.data.values(e).length:0;return{id:a,id_org:e,values:t.map((function(t,o){var c,f=t[l],p=t[e];return p=null===p||isNaN(p)||R(p)?E(p)||R(p)?p:null:+p,!u&&!s.hasRadar||0!==i||m(f)?c=n.generateTargetX(f,e,g+o):(d||0!==i||0!==o||h||(r.axis_x_categories=[]),-1===(c=r.axis_x_categories.indexOf(f))&&(c=r.axis_x_categories.length,r.axis_x_categories.push(f))),(m(p)||n.data.xs[e].length<=o)&&(c=void 0),{x:c,value:p,id:a}})).filter((function(t){return y(t.x)}))}}));return p.forEach((function(t){r.data_xSort&&(t.values=t.values.sort((function(t,e){return(t.x||0===t.x?t.x:1/0)-(e.x||0===e.x?e.x:1/0)}))),t.values.forEach((function(t,e){return t.index=e})),n.data.xs[t.id].sort((function(t,e){return t-e}))})),s.hasNegativeValue=n.hasNegativeValueInTargets(p),s.hasPositiveValue=n.hasPositiveValueInTargets(p),r.data_type&&n.setTargetType(n.mapToIds(p).filter((function(t){return!(t in r.data_types)})),r.data_type),p.forEach((function(t){return n.cache.add(t.id_org,t,!0)})),p}},ne={isX:function(t){var e,i,n,a=this.config,r=a.data_x&&t===a.data_x,s=C(a.data_xs)&&(e=a.data_xs,i=t,n=!1,Object.keys(e).forEach((function(t){return e[t]===i&&(n=!0)})),n);return r||s},isNotX:function(t){return!this.isX(t)},isStackNormalized:function(){var t=this.config;return!(!t.data_stack_normalize||!t.data_groups.length)},isGrouped:function(t){var e=this.config.data_groups;return t?e.some((function(e){return e.indexOf(t)>=0&&e.length>1})):e.length>0},getXKey:function(t){var e=this.config;return e.data_x?e.data_x:C(e.data_xs)?e.data_xs[t]:null},getXValuesOfXKey:function(t,e){var i,n=this;return(e&&C(e)?n.mapToIds(e):[]).forEach((function(e){n.getXKey(e)===t&&(i=n.data.xs[e])})),i},getIndexByX:function(t,e){return e?e.indexOf(x(t)?t:+t):(this.filterByX(this.data.targets,t)[0]||{index:null}).index},getXValue:function(t,e){var i=this;return t in i.data.xs&&i.data.xs[t]&&g(i.data.xs[t][e])?i.data.xs[t][e]:e},getOtherTargetXs:function(){var t=Object.keys(this.data.xs);return t.length?this.data.xs[t[0]]:null},getOtherTargetX:function(t){var e=this.getOtherTargetXs();return e&&t<e.length?e[t]:null},addXs:function(t){var e=this.config;Object.keys(t).forEach((function(i){e.data_xs[i]=t[i]}))},isMultipleX:function(){return C(this.config.data_xs)||!this.config.data_xSort||this.hasType("bubble")||this.hasType("scatter")},addName:function(t){var e,i=this.config;return t&&(e=i.data_names[t.id],t.name=void 0!==e?e:t.id),t},getAllValuesOnIndex:function(t,e){void 0===e&&(e=!1);var i=this,n=i.filterTargetsToShow(i.data.targets).map((function(e){return i.addName(i.getValueOnIndex(e.values,t))}));return e&&(n=n.filter((function(t){return t&&"value"in t&&g(t.value)}))),n},getValueOnIndex:function(t,e){var i=t.filter((function(t){return t.index===e}));return i.length?i[0]:null},updateTargetX:function(t,e){var i=this;t.forEach((function(t){t.values.forEach((function(n,a){n.x=i.generateTargetX(e[a],t.id,a)})),i.data.xs[t.id]=e}))},updateTargetXs:function(t,e){var i=this;t.forEach((function(t){e[t.id]&&i.updateTargetX([t],e[t.id])}))},generateTargetX:function(t,e,i){var n,a,r,s,o=this,l=o.axis,c=null!=(n=l)&&n.isCategorized()?i:t||i;if(null!=(a=l)&&a.isTimeSeries()){var u=tt.bind(o);c=u(t||o.getXValue(e,i))}else null==(r=l)||!r.isCustomX()||null!=(s=l)&&s.isCategorized()||(c=g(t)?+t:o.getXValue(e,i));return c},updateXs:function(t){t.length&&(this.axis.xs=t.map((function(t){return t.x})))},getPrevX:function(t){var e=this.axis.xs[t-1];return y(e)?e:null},getNextX:function(t){var e=this.axis.xs[t+1];return y(e)?e:null},getBaseValue:function(t){var e=this,i=e.state.hasAxis,n=t.value;return n&&i&&(e.isAreaRangeType(t)?n=e.getRangedData(t,"mid"):e.isBubbleZType(t)&&(n=e.getBubbleZData(n,"y"))),n},getMinMaxValue:function(t){var e,i,n=this.getBaseValue.bind(this);return(t||this.data.targets.map((function(t){return t.values}))).forEach((function(t,a){var r=t.map(n).filter(_);e=Math.min.apply(Math,[a?e:1/0].concat(r)),i=Math.max.apply(Math,[a?i:-1/0].concat(r))})),{min:e,max:i}},getMinMaxData:function(){var t=this,e=Gt,i=t.cache.get(e);if(!i){var n=t.data.targets.map((function(t){return t.values})),a=t.getMinMaxValue(n),r=[],s=[];n.forEach((function(e){var i=t.getFilteredDataByValue(e,a.min),n=t.getFilteredDataByValue(e,a.max);i.length&&(r=r.concat(i)),n.length&&(s=s.concat(n))})),t.cache.add(e,i={min:r,max:s})}return i},getTotalPerIndex:function(){var t=this,e=Vt,i=t.cache.get(e);return t.isStackNormalized()&&!i&&(i=[],t.data.targets.forEach((function(t){t.values.forEach((function(t,e){i[e]||(i[e]=0),i[e]+=_(t.value)?t.value:0}))}))),i},getTotalDataSum:function(t){var e=this,i=jt,n=e.cache.get(i);if(!_(n)){var a=W(e.data.targets.map((function(t){return t.values}))).map((function(t){return t.value})).reduce((function(t,e){return t+e}));e.cache.add(i,n=a)}return t&&(n-=e.getHiddenTotalDataSum()),n},getHiddenTotalDataSum:function(){var t=this.api,e=this.state.hiddenTargetIds,i=0;return e.length&&(i=t.data.values.bind(t)(e).reduce((function(t,e){return t+e}))),i},getFilteredDataByValue:function(t,e){var i=this;return t.filter((function(t){return i.getBaseValue(t)===e}))},getMaxDataCount:function(){return Math.max.apply(Math,this.data.targets.map((function(t){return t.values.length})))},getMaxDataCountTarget:function(){var t=this.filterTargetsToShow()||[],e=t.length;return e>1?t=Z(H(t=t.map((function(t){return t.values})).reduce((function(t,e){return t.concat(e)})).map((function(t){return t.x})))).map((function(t,e){return{x:t,index:e}})):e&&(t=t[0].values),t},mapToIds:function(t){return t.map((function(t){return t.id}))},mapToTargetIds:function(t){return t?E(t)?t.concat():[t]:this.mapToIds(this.data.targets)},hasTarget:function(t,e){for(var i,n=this.mapToIds(t),a=0;i=n[a];a++)if(i===e)return!0;return!1},isTargetToShow:function(t){return this.state.hiddenTargetIds.indexOf(t)<0},isLegendToShow:function(t){return this.state.hiddenLegendIds.indexOf(t)<0},filterTargetsToShow:function(t){var e=this;return(t||e.data.targets).filter((function(t){return e.isTargetToShow(t.id)}))},mapTargetsToUniqueXs:function(t){var e,i=this.axis,n=[];null!=t&&t.length&&(n=H(W(t.map((function(t){return t.values.map((function(t){return+t.x}))})))),n=null!=(e=i)&&e.isTimeSeries()?n.map((function(t){return new Date(+t)})):n.map(Number));return Z(n)},addTargetIds:function(t,e){var i=this.state;(E(e)?e:[e]).forEach((function(e){i[t].indexOf(e)<0&&i[t].push(e)}))},removeTargetIds:function(t,e){var i=this.state;(E(e)?e:[e]).forEach((function(e){var n=i[t].indexOf(e);n>=0&&i[t].splice(n,1)}))},addHiddenTargetIds:function(t){this.addTargetIds("hiddenTargetIds",t)},removeHiddenTargetIds:function(t){this.removeTargetIds("hiddenTargetIds",t)},addHiddenLegendIds:function(t){this.addTargetIds("hiddenLegendIds",t)},removeHiddenLegendIds:function(t){this.removeTargetIds("hiddenLegendIds",t)},getValuesAsIdKeyed:function(t){var e=this,i=e.state.hasAxis,n={},a=e.isMultipleX(),r=a?e.mapTargetsToUniqueXs(t).map((function(t){return x(t)?t:+t})):null;return t.forEach((function(t){var s=[];t.values.filter((function(t){var e=t.value;return g(e)||null===e})).forEach((function(t){var n=t.value;null!==n&&e.isCandlestickType(t)&&(n=E(n)?n.slice(0,4):[n.open,n.high,n.low,n.close]),E(n)?s.push.apply(s,n):R(n)&&"high"in n?s.push.apply(s,Object.values(n)):e.isBubbleZType(t)?s.push(i&&e.getBubbleZData(n,"y")):a?s[e.getIndexByX(t.x,r)]=n:s.push(n)})),n[t.id]=s})),n},checkValueInTargets:function(t,e){for(var i,n=Object.keys(t),a=0;a<n.length;a++){i=t[n[a]].values;for(var r=0;r<i.length;r++)if(e(i[r].value))return!0}return!1},hasMultiTargets:function(){return this.filterTargetsToShow().length>1},hasNegativeValueInTargets:function(t){return this.checkValueInTargets(t,(function(t){return t<0}))},hasPositiveValueInTargets:function(t){return this.checkValueInTargets(t,(function(t){return t>0}))},orderTargets:function(t){var e=[].concat(t),i=this.getSortCompareFn();return i&&e.sort(i),e},getSortCompareFn:function(t){void 0===t&&(t=!1);var e,i=this.config.data_order,n=/asc/i.test(i),a=/desc/i.test(i);if(n||a){var r=function(t,e){return t+Math.abs(e.value)};e=function(e,i){var a="values"in e?e.values.reduce(r,0):e.value,s="values"in i?i.values.reduce(r,0):i.value;return t?n?a-s:s-a:n?s-a:a-s}}else v(i)&&(e=i.bind(this.api));return e||null},filterByX:function(t,e){return W(t.map((function(t){return t.values}))).filter((function(t){return t.x-e==0}))},filterRemoveNull:function(t){var e=this;return t.filter((function(t){return g(e.getBaseValue(t))}))},filterByXDomain:function(t,e){return t.map((function(t){return{id:t.id,id_org:t.id_org,values:t.values.filter((function(t){return e[0]<=t.x&&t.x<=e[1]}))}}))},hasDataLabel:function(){var t=this.config.data_labels;return b(t)&&t||k(t)&&C(t)},getDataIndexFromEvent:function(t){var e=this.config,i=this.state,n=i.inputType,a=i.eventReceiver,r=a.coords,s=a.rect,o=e.axis_rotated,l="touch"===n&&t.changedTouches?t.changedTouches[0]:t;return B(r,o?l.clientY-s.top:l.clientX-s.left,0,r.length-1,o)},getDataLabelLength:function(t,e,i){var n=this,a=[0,0];return n.$el.chart.select("svg").selectAll(".dummy").data([t,e]).enter().append("text").text((function(t){return n.dataLabelFormat(t.id)(t)})).each((function(t,e){a[e]=1.3*this.getBoundingClientRect()[i]})).remove(),a},isNoneArc:function(t){return this.hasTarget(this.data.targets,t.id)},isArc:function(t){return"data"in t&&this.hasTarget(this.data.targets,t.data.id)},findSameXOfValues:function(t,e){var i,n=t[e].x,a=[];for(i=e-1;i>=0&&n===t[i].x;i--)a.push(t[i]);for(i=e;i<t.length&&n===t[i].x;i++)a.push(t[i]);return a},findClosestFromTargets:function(t,e){var i=this,n=t.map((function(t){return i.findClosest(t.values,e)}));return i.findClosest(n,e)},findClosest:function(t,e){var i,n=this,a=n.config,r=n.$el.main,s=t.filter((function(t){return t&&g(t.value)})),o=a.point_sensitivity;return s.filter((function(t){return n.isBarType(t.id)||n.isCandlestickType(t.id)})).forEach((function(t){var e=n.isBarType(t.id)?"."+ct.chartBar+"."+rt.target+n.getTargetSelectorSuffix(t.id)+" ."+ct.bar+"-"+t.index:"."+ut.chartCandlestick+"."+rt.target+n.getTargetSelectorSuffix(t.id)+" ."+ut.candlestick+"-"+t.index+" path";!i&&n.isWithinBar(r.select(e).node())&&(i=t)})),s.filter((function(t){return!n.isBarType(t.id)&&!n.isCandlestickType(t.id)})).forEach((function(t){var a=n.dist(t,e);a<o&&(o=a,i=t)})),i},dist:function(t,e){var i=this,n=i.config.axis_rotated,a=i.scale,r=n?1:0,s=n?0:1,o=i.circleY(t,t.index),l=(a.zoom||a.x)(t.x);return Math.sqrt(Math.pow(l-e[r],2)+Math.pow(o-e[s],2))},convertValuesToStep:function(t){var e=this.axis,i=this.config.line_step_type,n=!!e&&e.isCategorized(),a=E(t)?t.concat():[t];if(!n&&!/step\-(after|before)/.test(i))return t;var r=a[0],s=a[a.length-1],o=r.id,l=r.x;return a.unshift({x:--l,value:r.value,id:o}),n&&"step-after"===i&&a.unshift({x:--l,value:r.value,id:o}),l=s.x,a.push({x:++l,value:s.value,id:o}),n&&"step-before"===i&&a.push({x:++l,value:s.value,id:o}),a},convertValuesToRange:function(t){var e=E(t)?t.concat():[t],i=[];return e.forEach((function(t){var e=t.x,n=t.id;i.push({x:e,id:n,value:t.value[0]}),i.push({x:e,id:n,value:t.value[2]})})),i},updateDataAttributes:function(t,e){var i=this.config["data_"+t];return m(e)||(Object.keys(e).forEach((function(t){i[t]=e[t]})),this.redraw({withLegend:!0})),i},getRangedData:function(t,e,i){void 0===e&&(e=""),void 0===i&&(i="areaRange");var n=null==t?void 0:t.value;if(E(n)){var a={areaRange:["high","mid","low"],candlestick:["open","high","low","close","volume"]}[i].indexOf(e);return a>=0&&n?n[a]:void 0}return n?n[e]:n},getRatio:function(t,e,i){void 0===i&&(i=!1);var n=this,a=n.config,r=n.state,s=n.api,o=0;if(e&&s.data.shown().length)if(o=e.ratio||e.value,"arc"===t)if(n.pie.padAngle()())o=e.value/n.getTotalDataSum(!0);else{var l=a.gauge_fullCircle?n.getArcLength():-2*n.getStartAngle(),c=n.hasType("gauge")?l:2*Math.PI;o=(e.endAngle-e.startAngle)/c}else if("index"===t){var u=s.data.values.bind(s),d=this.getTotalPerIndex();if(r.hiddenTargetIds.length){var h=u(r.hiddenTargetIds,!1);h.length&&(h=h.reduce((function(t,e){return t.map((function(t,i){return(_(t)?t:0)+e[i]}))})),d=d.map((function(t,e){return t-h[e]})))}e.ratio=_(e.value)&&d&&d[e.index]>0?e.value/d[e.index]:0,o=e.ratio}else if("radar"===t)o=parseFloat(Math.max(e.value,0)+"")/r.current.dataMax*a.radar_size_ratio;else if("bar"===t){var g=n.getYScaleById.bind(n)(e.id).domain().reduce((function(t,e){return e-t}));o=0===g?0:Math.abs(e.value)/g}return i&&o?100*o:o},updateDataIndexByX:function(t){var e=t.reduce((function(t,e,i){return t[+e.x]=i,t}),{});this.data.targets.forEach((function(t){t.values.forEach((function(t,i){var n=e[+t.x];void 0===n&&(n=i),t.index=n}))}))},isBubbleZType:function(t){return this.isBubbleType(t)&&(R(t.value)&&("z"in t.value||"y"in t.value)||E(t.value)&&2===t.value.length)},isBarRangeType:function(t){var e=t.value;return this.isBarType(t)&&E(e)&&2===e.length&&e.every((function(t){return _(t)}))},getDataById:function(t){var e,i=this.cache.get(t)||this.api.data(t);return null!=(e=null==i?void 0:i[0])?e:i}},ae={load:function(t,e){var i,n=this,a=e.append,r=t;r&&(e.filter&&(r=r.filter(e.filter)),(e.type||e.types)&&r.forEach((function(t){var i,a=(null==(i=e.types)?void 0:i[t.id])||e.type;n.setTargetType(t.id,a)})),n.data.targets.forEach((function(t){for(var e=0;e<r.length;e++)if(t.id===r[e].id){t.values=a?t.values.concat(r[e].values):r[e].values,r.splice(e,1);break}})),n.data.targets=n.data.targets.concat(r)),n.updateTargets(n.data.targets),n.redraw({withUpdateOrgXDomain:!0,withUpdateXDomain:!0,withLegend:!0}),n.updateTypesElements(),null==(i=e.done)||i.call(n.api)},loadFromArgs:function(t){var e=this;if(e.config){e.cache.reset();var i=t.data||e.convertData(t,(function(i){return e.load(e.convertDataToTargets(i),t)}));t.append&&(i.__append__=!0),i&&e.load(e.convertDataToTargets(i),t)}},unload:function(t,e){var i=this,n=i.state,a=i.$el,r=i.$T,s=e,o=t;(i.cache.reset(),s||(s=function(){}),(o=o.filter((function(t){return i.hasTarget(i.data.targets,t)})))&&0!==o.length)?(r(a.svg.selectAll(o.map((function(t){return i.selectorTarget(t)})))).style("opacity","0").remove().call(D,s),o.forEach((function(t){n.withoutFadeIn[t]=!1,a.legend&&a.legend.selectAll("."+pt.legendItem+i.getTargetSelectorSuffix(t)).remove(),i.data.targets=i.data.targets.filter((function(e){return e.id!==t}))})),i.updateTypesElements()):s()}},re=f(7),se={selectRectForSingle:function(t,e,i){var a=this,r=a.config,s=a.$el.main,o=r.data_selection_enabled,l=r.data_selection_grouped,c=r.data_selection_isselectable,u=r.tooltip_grouped,d=a.getAllValuesOnIndex(i);u&&(a.showTooltip(d,t),null==a.showGridFocus||a.showGridFocus(d),!o||l)||s.selectAll("."+wt.shape+"-"+i).each((function(){(0,n.select)(this).classed(rt.EXPANDED,!0),o&&e.style("cursor",l?"pointer":null),u||(null==a.hideGridFocus||a.hideGridFocus(),a.hideTooltip(),l||a.setExpand(i))})).filter((function(t){return a.isWithinShape(this,t)})).call((function(n){var r,s=n.data();o&&(l||null!=(r=c)&&r.bind(a.api)(s))&&e.style("cursor","pointer"),u||(a.showTooltip(s,t),null==a.showGridFocus||a.showGridFocus(s),null==a.unexpandCircles||a.unexpandCircles(),n.each((function(t){return a.setExpand(i,t.id)})))}))},setExpand:function(t,e,i){var n=this,a=n.config;n.$el.circle&&a.point_focus_expand_enabled&&n.expandCircles(t,e,i),n.expandBarTypeShapes(!0,t,e,i)},expandBarTypeShapes:function(t,e,i,n){void 0===t&&(t=!0);var a=this;["bar","candlestick"].filter((function(t){return a.$el[t]})).forEach((function(r){n&&a.$el[r].classed(rt.EXPANDED,!1),a.getShapeByIndex(r,e,i).classed(rt.EXPANDED,t)}))},setOverOut:function(t,e){var i=this,a=i.config,r=i.state.hasRadar,s=i.$el.main,o=R(e);if(o||-1!==e){var l=a[t?"data_onover":"data_onout"].bind(i.api);if(a.color_onover&&i.setOverColor(t,e,o),o)l(e,s.select("."+st.arc+i.getTargetSelectorSuffix(e.id)).node());else if(a.tooltip_grouped)t&&(a.point_focus_only&&r?i.showCircleFocus(i.getAllValuesOnIndex(e,!0)):i.setExpand(e,null,!0)),i.isMultipleX()||s.selectAll("."+wt.shape+"-"+e).each((function(t){l(t,this)}));else{var c=i.cache.get(Ut)||[],u=s.selectAll("."+wt.shape+"-"+e).filter((function(t){return i.isWithinShape(this,t)}));u.each((function(t){var e=this;(0===c.length||c.every((function(t){return t!==e})))&&(l(t,this),c.push(this))})),c.length>0&&u.empty()&&(l=a.data_onout.bind(i.api),c.forEach((function(t){return l((0,n.select)(t).datum(),t)})),c=[]),i.cache.add(Ut,c)}}},callOverOutForTouch:function(t){var e=this,i=e.cache.get(Zt);(R(t)&&i?t.id!==i.id:t!==i)&&((i||_(i))&&e.setOverOut(!1,i),(t||_(t))&&e.setOverOut(!0,t),e.cache.add(Zt,t))},getDraggableSelection:function(){var t=this,e=t.config,i=t.state;return e.interaction_enabled&&e.data_selection_draggable&&t.drag?(0,re.drag)().on("drag",(function(e){i.event=e,t.drag(M(e,this))})).on("start",(function(e){i.event=e,t.dragstart(M(e,this))})).on("end",(function(e){i.event=e,t.dragend()})):function(){}},dispatchEvent:function(t,e,i){var n=this,a=n.config,r=n.state,s=r.eventReceiver,o=r.hasAxis,l=r.hasRadar,c=n.$el,u=c.eventRect,d=c.arcs,h=c.radar,g=n.isMultipleX(),f=(l?h.axes.select("."+lt.axis+"-"+e+" text"):u||d.selectAll("."+rt.target+" path").filter((function(t,i){return i===e}))).node(),p=f.getBoundingClientRect(),v=p.width,x=p.left,_=p.top;if(o&&!l&&!g){var m=s.coords[e];v=m.w,x+=m.x,_+=m.y}var y=x+(i?i[0]:0)+(g||a.axis_rotated?0:v/2),b=_+(i?i[1]:0);J[/^(mouse|click)/.test(t)?"mouse":"touch"](f,t,{screenX:y,screenY:b,clientX:y,clientY:b})},setDragStatus:function(t){this.state.dragging=t},unbindZoomEvent:function(){var t,e,i=this.$el,n=i.eventRect,a=i.zoomResetBtn;null==(t=n)||t.on(".zoom wheel.zoom .drag",null),null==(e=a)||e.on("click",null).style("display","none")},unbindAllEvents:function(){var t,e,i,n,a=this,r=a.$el,s=r.arcs,o=r.eventRect,l=r.legend,c=r.region,u=r.svg,d=a.brush;[u,o,null==(t=c)?void 0:t.list,null==(e=d)?void 0:e.getSelection(),null==(i=s)?void 0:i.selectAll("path"),null==(n=l)?void 0:n.selectAll("g")].forEach((function(t){return null==t?void 0:t.on("wheel click mouseover mousemove mouseout touchstart touchmove touchend touchstart.eventRect touchmove.eventRect touchend.eventRect .brush .drag .zoom wheel.zoom dblclick.zoom",null)})),null==a.unbindZoomEvent||a.unbindZoomEvent()}},oe={generateClass:function(t,e){return" "+t+" "+(t+this.getTargetSelectorSuffix(e))},getClass:function(t,e){var i=this,n=/s$/.test(t),a=/^(area|arc|line)s?$/.test(t),r=n?"id":"index";return function(s){var o=s.data||s;return((e?i.generateClass(Et[n?"shapes":"shape"],o[r]):"")+i.generateClass(Et[t],o[a?"id":r])).trim()}},getChartClass:function(t){var e=this;return function(i){return Et["chart"+t]+e.classTarget((i.data?i.data:i).id)}},generateExtraLineClass:function(){var t=this.config.line_classes||[],e=[];return function(i){var n,a=i.id||(null==(n=i.data)?void 0:n.id)||i;return e.indexOf(a)<0&&e.push(a),t[e.indexOf(a)%t.length]}},classRegion:function(t,e){return this.generateClass(Et.region,e)+" "+("class"in t?t.class:"")},classTarget:function(t){var e=this.config.data_classes[t],i="";return e&&(i=" "+Et.target+"-"+e),this.generateClass(Et.target,t)+i},classFocus:function(t){return this.classFocused(t)+this.classDefocused(t)},classFocused:function(t){return" "+(this.state.focusedTargetIds.indexOf(t.id)>=0?Et.focused:"")},classDefocused:function(t){return" "+(this.state.defocusedTargetIds.indexOf(t.id)>=0?Et.defocused:"")},getTargetSelectorSuffix:function(t){return(t||0===t?"-"+t:"").replace(/([\s?!@#$%^&*()_=+,.<>'":;\[\]\/|~`{}\\])/g,"-")},selectorTarget:function(t,e){var i=e||"",n=this.getTargetSelectorSuffix(t);return i+"."+(Et.target+n)+", "+i+"."+(Et.circles+n)},selectorTargets:function(t,e){var i=this,n=t||[];return n.length?n.map((function(t){return i.selectorTarget(t,e)})):null},selectorLegend:function(t){return"."+(Et.legendItem+this.getTargetSelectorSuffix(t))},selectorLegends:function(t){var e=this;return null!=t&&t.length?t.map((function(t){return e.selectorLegend(t)})):null}},le=f(6),ce=["#1f77b4","#ff7f0e","#2ca02c","#d62728","#9467bd","#8c564b","#e377c2","#7f7f7f","#bcbd22","#17becf"],ue={getColorFromCss:function(){var t=Yt,e=r.body,i=e[t];if(!i){var n=r.createElement("span");n.className=ht.colorPattern,n.style.display="none",e.appendChild(n);var s=a.getComputedStyle(n).backgroundImage;n.parentNode.removeChild(n),s.indexOf(";")>-1&&(i=s.replace(/url[^#]*|["'()]|(\s|%20)/g,"").split(";").map((function(t){return t.trim().replace(/[\"'\s]/g,"")})).filter(Boolean),e[t]=i)}return i},generateColor:function(){var t=this,e=t.config,i=e.data_colors,a=e.data_color,r=[],s=C(e.color_pattern)?e.color_pattern:(0,le.scaleOrdinal)(t.getColorFromCss()||ce).range(),o=s;if(v(e.color_tiles)){var l=e.color_tiles.bind(t.api)(),c=s.map((function(e,i){var a=e.replace(/[#\(\)\s,]/g,""),r=t.state.datetimeId+"-pattern-"+a+"-"+i;return function(t,e,i){var a=(0,n.select)(t.cloneNode(!0));return a.attr("id",i).insert("rect",":first-child").attr("width",a.attr("width")).attr("height",a.attr("height")).style("fill",e),{id:i,node:a.node()}}(l[i%l.length],e,r)}));s=c.map((function(t){return"url(#"+t.id+")"})),t.patterns=c}return function(n){var l,c,u=n.id||(null==(l=n.data)?void 0:l.id)||n,d=t.isTypeOf(u,["line","spline","step"])||!e.data_types[u];return v(i[u])?c=i[u].bind(t.api)(n):i[u]?c=i[u]:(r.indexOf(u)<0&&r.push(u),c=d?o[r.indexOf(u)%o.length]:s[r.indexOf(u)%s.length],i[u]=c),v(a)?a.bind(t.api)(c,n):c}},generateLevelColor:function(){var t=this.config,e=t.color_pattern,i=t.color_threshold,n="value"===i.unit,a=i.max||100,r=i.values&&i.values.length?i.values:[];return C(i)?function(t){for(var i=n?t:100*t/a,s=e[e.length-1],o=0,l=r.length;o<l;o++)if(i<=r[o]){s=e[o];break}return s}:null},generateDataLabelBackgroundColorFilter:function(){var t=this,e=t.$el,i=t.config,n=t.state,a=i.data_labels_backgroundColors;if(a){var r=[];x(a)?r.push(""):R(a)&&(r=Object.keys(a)),r.forEach((function(i){var r=n.datetimeId+"-labels-bg"+t.getTargetSelectorSuffix(i);e.defs.append("filter").attr("x","0").attr("y","0").attr("width","1").attr("height","1").attr("id",r).html('<feFlood flood-color="'+(""===i?a:a[i])+'" /><feComposite in="SourceGraphic"/>')}))}},setOverColor:function(t,e){var i=this,n=i.config,a=i.$el.main,r=n.color_onover,s=t?r:i.color;R(s)?s=function(t){var e=t.id;return e in r?r[e]:i.color(e)}:x(s)?s=function(){return r}:v(r)&&(s=s.bind(i.api)),a.selectAll(R(e)?"."+st.arc+i.getTargetSelectorSuffix(e.id):"."+wt.shape+"-"+e).style("fill",s)}},de={getYDomainMinMax:function(t,e){var i=this,n=i.axis,a=i.config,r="min"===e,s=a.data_groups,o=i.mapToIds(t),l=i.getValuesAsIdKeyed(t);if(s.length>0){var c=i["has"+(r?"Negative":"Positive")+"ValueInTargets"](t);s.forEach((function(t){var e=t.filter((function(t){return o.indexOf(t)>=0}));if(e.length){var i=e[0],a=n.getId(i);c&&l[i]&&(l[i]=l[i].map((function(t){return(r?t<0:t>0)?t:0}))),e.filter((function(t,e){return e>0})).forEach((function(t){if(l[t]){var e=n.getId(t);l[t].forEach((function(t,n){var s=+t;e!==a||c&&(r?s>0:s<0)||(l[i][n]+=s)}))}}))}}))}return q(e,Object.keys(l).map((function(t){return q(e,l[t])})))},isHiddenTargetWithYDomain:function(t){var e=this;return e.state.hiddenTargetIds.some((function(i){return e.axis.getId(i)===t}))},getYDomain:function(t,e,i){var n,a=this,r=a.axis,o=a.config,c=a.scale,u="axis_"+e;if(a.isStackNormalized())return[0,100];var d=(null==(n=c)?void 0:n[e])&&"log"===c[e].type,h=t.filter((function(t){return r.getId(t.id)===e})),f=i?a.filterByXDomain(h,i):h;if(0===f.length)return a.isHiddenTargetWithYDomain(e)?c[e].domain():"y2"===e?c.y.domain():a.getYDomain(t,"y2",i);var p=o[u+"_min"],v=o[u+"_max"],x=o[u+"_center"],_=o[u+"_inverted"],m=a.hasDataLabel()&&o.axis_rotated,b=a.hasDataLabel()&&!o.axis_rotated,T=a.getYDomainMinMax(f,"min"),w=a.getYDomainMinMax(f,"max"),k=[s.BAR,s.BUBBLE,s.SCATTER].concat(l.Line).some((function(t){var e=t.indexOf("area")>-1?"area":t;return a.hasType(t,f,!0)&&o[e+"_zerobased"]}));T=g(p)?p:g(v)?T<v?T:v-10:T,w=g(v)?v:g(p)?p<w?w:p+10:w,isNaN(T)&&(T=0),isNaN(w)&&(w=T),T===w&&(T<0?w=0:T=0);var S=T>=0&&w>=0,E=T<=0&&w<=0;(g(p)&&S||g(v)&&E)&&(k=!1),k&&(S&&(T=0),E&&(w=0));var R=Math.abs(w-T),O={top:.1*R,bottom:.1*R};if(y(x)){var L=Math.max(Math.abs(T),Math.abs(w));w=x+L,T=x-L}if(m){var D=A(c.y.range()),I=a.getDataLabelLength(T,w,"width").map((function(t){return t/D}));["bottom","top"].forEach((function(t,e){O[t]+=R*(I[e]/(1-I[0]-I[1]))}))}else if(b){var P=a.getDataLabelLength(T,w,"height");["bottom","top"].forEach((function(t,e){O[t]+=a.convertPixelToScale("y",P[e],R)}))}O=a.getResettedPadding(O);var z=o[u+"_padding"];C(z)&&["bottom","top"].forEach((function(t){O[t]=r.getPadding(z,t,O[t],R)})),k&&(S&&(O.bottom=T),E&&(O.top=-w));var M=d?[T,w].map((function(t){return t<0?0:t})):[T-O.bottom,w+O.top];return _?M.reverse():M},getXDomainMinMax:function(t,e){var i,n=this.config["axis_x_"+e],a=q(e,t.map((function(t){return q(e,t.values.map((function(t){return t.x})))}))),r=R(n)?n.value:n;return r=y(r)&&null!=(i=this.axis)&&i.isTimeSeries()?tt.bind(this)(r):r,R(n)&&n.fit&&("min"===e&&r<a||"max"===e&&r>a)&&(r=void 0),y(r)?r:a},getXDomainPadding:function(t,e){var i,n=this,a=n.axis,r=n.config.axis_x_padding,s=a.isTimeSeries()&&e,o=A(t);if(a.isCategorized()||s)i=0;else if(n.hasType("bar")){var l=n.getMaxDataCount();i=l>1?o/(l-1)/2:.5}else i=n.getResettedPadding(.01*o);var c=_(r)?{left:r,right:r}:r,u=c.left,d=void 0===u?i:u,h=c.right,g=void 0===h?i:h;if("px"===r.unit){var f=Math.abs(o+.2*o);d=a.getPadding(r,"left",i,f),g=a.getPadding(r,"right",i,f)}else{var p=o+d+g;if(s&&p){var v=o/e/p;d=d/p/v,g=g/p/v}}return{left:d,right:g}},getXDomain:function(t){var e=this,i=e.axis,n=e.scale.x,a=[e.getXDomainMinMax(t,"min"),e.getXDomainMinMax(t,"max")],r=a[0],s=void 0===r?0:r,o=a[1],l=void 0===o?0:o;if("log"!==n.type){var c=i.isCategorized(),u=i.isTimeSeries(),d=e.getXDomainPadding(a),h=a[0],g=a[1];h-g!=0||c||(u?(h=new Date(.5*h.getTime()),g=new Date(1.5*g.getTime())):(h=0===h?1:.5*h,g=0===g?-1:1.5*g)),(h||0===h)&&(s=u?new Date(h.getTime()-d.left):h-d.left),(g||0===g)&&(l=u?new Date(g.getTime()+d.right):g+d.right)}return[s,l]},updateXDomain:function(t,e,i,n,a){var r,s=this,o=s.config,l=s.org,c=s.scale,u=c.x,d=c.subX,h=o.zoom_enabled;i&&(u.domain(a||Z(s.getXDomain(t))),l.xDomain=u.domain(),h&&s.zoom.updateScaleExtent(),d.domain(u.domain()),null==(r=s.brush)||r.scale(d));if(e){var g=a||!s.brush||N(s)?l.xDomain:X(s).map(d.invert);u.domain(g),h&&s.zoom.updateScaleExtent()}return n&&u.domain(s.trimXDomain(u.orgDomain())),u.domain()},trimXDomain:function(t){var e=this.getZoomDomain(),i=e[0],n=e[1];return t[0]<=i&&(t[1]=+t[1]+(i-t[0]),t[0]=i),n<=t[1]&&(t[0]=+t[0]-(t[1]-n),t[1]=n),t},getZoomDomain:function(){var t=this.config,e=this.org.xDomain,i=e[0],n=e[1];return y(t.zoom_x_min)&&(i=q("min",[i,t.zoom_x_min])),y(t.zoom_x_max)&&(n=q("max",[n,t.zoom_x_max])),[i,n]},convertPixelToScale:function(t,e,i){var n=this.config,a=this.state,r=n.axis_rotated;return i*(e/a["x"===t?r?"height":"width":r?"width":"height"])}};function he(t,e,i){var n=t.config,a="axis_"+e+"_tick_format";return(n[a]?n[a]:t.defaultValueFormat)(i)}var ge={yFormat:function(t){return he(this,"y",t)},y2Format:function(t){return he(this,"y2",t)},getDefaultValueFormat:function(){var t=this,e=t.defaultArcValueFormat,i=t.yFormat,n=t.y2Format,a=t.hasArcType(null,["gauge","radar"]);return function(r,s,o){return(a?e:t.axis&&"y2"===t.axis.getId(o)?n:i).call(t,r,s)}},defaultValueFormat:function(t){return g(t)?+t:""},defaultArcValueFormat:function(t,e){return(100*e).toFixed(1)+"%"},dataLabelFormat:function(t){var e=this.config.data_labels,i=function(t){return g(t)?+t:""},n=i;return v(e.format)?n=e.format:k(e.format)&&(n=e.format[t]?!0===e.format[t]?i:e.format[t]:function(){return""}),n.bind(this.api)}},fe={initLegend:function(){var t=this,e=t.config,i=t.$el;t.legendItemTextBox={},t.state.legendHasRendered=!1,e.legend_show?(e.legend_contents_bindto||(i.legend=t.$el.svg.append("g").classed(pt.legend,!0).attr("transform",t.getTranslate("legend"))),t.updateLegend()):t.state.hiddenLegendIds=t.mapToIds(t.data.targets)},updateLegend:function(t,e,i){var n=this,a=n.config,r=n.state,s=n.scale,o=n.$el,l=e||{withTransform:!1,withTransitionForTransform:!1,withTransition:!1};l.withTransition=O(l,"withTransition",!0),l.withTransitionForTransform=O(l,"withTransitionForTransform",!0),a.legend_contents_bindto&&a.legend_contents_template?n.updateLegendTemplate():n.updateLegendElement(t||n.mapToIds(n.data.targets),l,i),o.legend.selectAll("."+pt.legendItem).classed(pt.legendItemHidden,(function(t){var e=!n.isTargetToShow(t);return e&&(this.style.opacity=null),e})),n.updateScales(!1,!s.zoom),n.updateSvgSize(),n.transformAll(l.withTransitionForTransform,i),r.legendHasRendered=!0},updateLegendTemplate:function(){var t=this,e=t.config,i=t.$el,a=(0,n.select)(e.legend_contents_bindto),r=e.legend_contents_template;if(!a.empty()){var s=t.mapToIds(t.data.targets),o=[],l="";s.forEach((function(e){var i=v(r)?r.bind(t.api)(e,t.color(e),t.api.data(e)[0].values):Q(r,{COLOR:t.color(e),TITLE:e});i&&(o.push(e),l+=i)}));var c=a.html(l).selectAll((function(){return this.childNodes})).data(o);t.setLegendItem(c),i.legend=a}},updateSizeForLegend:function(t){var e=this,i=e.config,n=e.state,a=n.isLegendTop,r=n.isLegendLeft,s=n.isLegendRight,o=n.isLegendInset,l=n.current,c=t.width,u=t.height,d={top:a?e.getCurrentPaddingTop()+i.legend_inset_y+5.5:l.height-u-e.getCurrentPaddingBottom()-i.legend_inset_y,left:r?e.getCurrentPaddingLeft()+i.legend_inset_x+.5:l.width-c-e.getCurrentPaddingRight()-i.legend_inset_x+.5};e.state.margin3={top:s?0:o?d.top:l.height-u,right:NaN,bottom:0,left:s?l.width-c:o?d.left:0}},transformLegend:function(t){var e=this,i=e.$el.legend;(0,e.$T)(i,t).attr("transform",e.getTranslate("legend"))},updateLegendStep:function(t){this.state.legendStep=t},updateLegendItemWidth:function(t){this.state.legendItemWidth=t},updateLegendItemHeight:function(t){this.state.legendItemHeight=t},updateLegendItemColor:function(t,e){var i=this.$el.legend;i&&i.select("."+pt.legendItem+"-"+t+" line").style("stroke",e)},getLegendWidth:function(){var t=this.state,e=t.current.width,i=t.isLegendRight,n=t.isLegendInset,a=t.legendItemWidth,r=t.legendStep;return this.config.legend_show?i||n?a*(r+1):e:0},getLegendHeight:function(){var t=this.state,e=t.current,i=t.isLegendRight,n=t.legendItemHeight,a=t.legendStep;return this.config.legend_show?i?e.height:Math.max(20,n)*(a+1):0},opacityForUnfocusedLegend:function(t){return t.classed(pt.legendItemHidden)?null:"0.3"},toggleFocusLegend:function(t,e){var i=this,a=i.$el.legend,r=i.$T,s=i.mapToTargetIds(t);a&&r(a.selectAll("."+pt.legendItem).filter((function(t){return s.indexOf(t)>=0})).classed(_t.legendItemFocused,e)).style("opacity",(function(){return e?null:i.opacityForUnfocusedLegend.call(i,(0,n.select)(this))}))},revertLegend:function(){var t=this.$el.legend,e=this.$T;t&&e(t.selectAll("."+pt.legendItem).classed(_t.legendItemFocused,!1)).style("opacity",null)},showLegend:function(t){var e=this,i=e.config,n=e.$el,a=e.$T;i.legend_show||(i.legend_show=!0,n.legend?n.legend.style("visibility",null):e.initLegend(),e.state.legendHasRendered||e.updateLegend()),e.removeHiddenLegendIds(t),a(n.legend.selectAll(e.selectorLegends(t)).style("visibility",null)).style("opacity",null)},hideLegend:function(t){var e=this,i=e.config,n=e.$el.legend;i.legend_show&&S(t)&&(i.legend_show=!1,n.style("visibility","hidden")),e.addHiddenLegendIds(t),n.selectAll(e.selectorLegends(t)).style("opacity","0").style("visibility","hidden")},getLegendItemTextBox:function(t,e){var i,n=this,a=n.cache,r=n.state,s=Ht;return t&&((i=!r.redrawing&&a.get(s)||{})[t]||(i[t]=n.getTextRect(e,pt.legendItem),a.add(s,i)),i=i[t]),i},setLegendItem:function(t){var e=this,i=e.api,a=e.config,r=e.state,s="touch"===r.inputType,o=e.hasType("gauge");t.attr("class",(function(t){var i=(0,n.select)(this);return(!i.empty()&&i.attr("class")||"")+e.generateClass(pt.legendItem,t)})).style("visibility",(function(t){return e.isLegendToShow(t)?null:"hidden"})),a.interaction_enabled&&(t.style("cursor","pointer").on("click",(function(t,r){L(a.legend_item_onclick,i,r)||(t.altKey?(i.hide(),i.show(r)):(i.toggle(r),(0,n.select)(this).classed(_t.legendItemFocused,!1))),s&&e.hideTooltip()})),s||t.on("mouseout",(function(t,r){L(a.legend_item_onout,i,r)||((0,n.select)(this).classed(_t.legendItemFocused,!1),o&&e.undoMarkOverlapped(e,"."+ft.gaugeValue),e.api.revert())})).on("mouseover",(function(t,s){L(a.legend_item_onover,i,s)||((0,n.select)(this).classed(_t.legendItemFocused,!0),o&&e.markOverlapped(s,e,"."+ft.gaugeValue),!r.transiting&&e.isTargetToShow(s)&&i.focus(s))})))},updateLegendElement:function(t,e){var i,a,s,o=this,l=o.config,c=o.state,u=o.$el.legend,d=o.$T,h=l.legend_item_tile_width+5,g=0,f=0,p=0,v={},x={},_={},m=[0],b={},T=0,w=c.isLegendRight||c.isLegendInset,A=t.filter((function(t){return!y(l.data_names[t])||null!==l.data_names[t]})),k=e.withTransition,S=function(t,e,i){var n,a=i===A.length-1,r=o.getLegendItemTextBox(e,t),s=r.width+h+(a&&!w?0:10)+l.legend_padding,u=r.height+4,d=w?u:s,y=w?o.getLegendHeight():o.getLegendWidth(),k=function(t,e){e||(n=(y-p-d)/2)<10&&(n=(y-d)/2,p=0,T++),b[t]=T,m[T]=c.isLegendInset?10:n,v[t]=p,p+=d};if(0===i&&(p=0,T=0,g=0,f=0),l.legend_show&&!o.isLegendToShow(e))return x[e]=0,_[e]=0,b[e]=0,void(v[e]=0);x[e]=s,_[e]=u,(!g||s>=g)&&(g=s),(!f||u>=f)&&(f=u);var S=w?f:g;l.legend_equally?(Object.keys(x).forEach((function(t){return x[t]=g})),Object.keys(_).forEach((function(t){return _[t]=f})),(n=(y-S*A.length)/2)<10?(p=0,T=0,A.forEach((function(t){return k(t)}))):k(e,!0)):k(e)};c.isLegendInset&&(T=l.legend_inset_step?l.legend_inset_step:A.length,o.updateLegendStep(T)),c.isLegendRight?(i=function(t){return g*b[t]},a=function(t){return m[b[t]]+v[t]}):c.isLegendInset?(i=function(t){return g*b[t]+10},a=function(t){return m[b[t]]+v[t]}):(i=function(t){return m[b[t]]+v[t]},a=function(t){return f*b[t]});var E=function(t,e){return i(t,e)+4+l.legend_item_tile_width},R=function(t,e){return i(t,e)},O=function(t,e){return i(t,e)-2},L=function(t,e){return i(t,e)-2+l.legend_item_tile_width},D=function(t,e){return a(t,e)+9},I=function(t,e){return a(t,e)-5},P=function(t,e){return a(t,e)+4},z=-200,M=u.selectAll("."+pt.legendItem).data(A).enter().append("g");o.setLegendItem(M),M.append("text").text((function(t){return y(l.data_names[t])?l.data_names[t]:t})).each((function(t,e){S(this,t,e)})).style("pointer-events","none").attr("x",w?E:z).attr("y",w?z:D),M.append("rect").attr("class",pt.legendItemEvent).style("fill-opacity","0").attr("x",w?R:z).attr("y",w?z:I);var X=function(t){var e=o.getDataById(t);return o.levelColor?o.levelColor(e.values[0].value):o.color(e)},$=l.legend_usePoint;if($){var F=[];M.append((function(t){var e=C(l.point_pattern)?l.point_pattern:[l.point_type];-1===F.indexOf(t)&&F.push(t);var i=e[F.indexOf(t)%e.length];return"rectangle"===i&&(i="rect"),r.createElementNS(n.namespaces.svg,"hasValidPointType"in o&&o.hasValidPointType(i)?i:"use")})).attr("class",pt.legendItemPoint).style("fill",X).style("pointer-events","none").attr("href",(function(t,e,i){var n=i[e].nodeName.toLowerCase(),a=o.getTargetSelectorSuffix(t);return"use"===n?"#"+c.datetimeId+"-point"+a:void 0}))}else M.append("line").attr("class",pt.legendItemTile).style("stroke",X).style("pointer-events","none").attr("x1",w?O:z).attr("y1",w?z:P).attr("x2",w?L:z).attr("y2",w?z:P).attr("stroke-width",l.legend_item_tile_height);(s=u.select("."+pt.legendBackground+" rect"),c.isLegendInset&&g>0&&0===s.size()&&(s=u.insert("g","."+pt.legendItem).attr("class",pt.legendBackground).append("rect")),d(u.selectAll("text").data(A).text((function(t){return y(l.data_names[t])?l.data_names[t]:t})).each((function(t,e){S(this,t,e)})),k).attr("x",E).attr("y",D),d(u.selectAll("rect."+pt.legendItemEvent).data(A),k).attr("width",(function(t){return x[t]})).attr("height",(function(t){return _[t]})).attr("x",R).attr("y",I),$)?d(u.selectAll("."+pt.legendItemPoint).data(A),k).each((function(){var t,e,i,a=this.nodeName.toLowerCase(),r=l.point_r,s="x",o="y",c=2,u=2.5;if("circle"===a){var d=.2*r;s="cx",o="cy",t=r+d,c=2*r,u=-d}else if("rect"===a){var h=2.5*r;e=h,i=h,u=3}(0,n.select)(this).attr(s,(function(t){return O(t)+c})).attr(o,(function(t){return P(t)-u})).attr("r",t).attr("width",e).attr("height",i)})):d(u.selectAll("line."+pt.legendItemTile).data(A),k).style("stroke",X).attr("x1",O).attr("y1",P).attr("x2",L).attr("y2",P);s&&d(s,k).attr("height",o.getLegendHeight()-12).attr("width",g*(T+1)+10),o.updateLegendItemWidth(g),o.updateLegendItemHeight(f),o.updateLegendStep(T)}},pe=f(8),ve={redraw:function(t){var e;void 0===t&&(t={});var i=this,n=i.config,a=i.state,r=i.$el,s=r.main;a.redrawing=!0;var o=i.filterTargetsToShow(i.data.targets),l=t,c=l.flow,u=l.initializing,d=i.getWithOption(t),h=d.Transition?n.transition_duration:0,g=d.TransitionForExit?h:0,f=d.TransitionForAxis?h:0,p=null==(e=i.axis)?void 0:e.generateTransitions(f);i.updateSizes(u),d.Legend&&n.legend_show?(t.withTransition=!!h,i.updateLegend(i.mapToIds(i.data.targets),t,p)):d.Dimension&&i.updateDimension(!0),i.hasArcType()&&!a.hasRadar||i.updateCircleY&&(i.circleY=i.updateCircleY()),a.hasAxis?(i.axis.redrawAxis(o,d,p,c,u),n.data_empty_label_text&&s.select("text."+kt.text+"."+rt.empty).attr("x",a.width/2).attr("y",a.height/2).text(n.data_empty_label_text).style("display",o.length?"none":null),i.hasGrid()&&i.updateGrid(),n.regions.length&&i.updateRegion(),["bar","candlestick","line","area"].forEach((function(t){var e=G(t);(/^(line|area)$/.test(t)&&i.hasTypeOf(e)||i.hasType(t))&&i["update"+e](d.TransitionForExit)})),r.text&&s.selectAll("."+Tt.selectedCircles).filter(i.isBarType.bind(i)).selectAll("circle").remove(),n.interaction_enabled&&!c&&d.EventRect&&(i.redrawEventRect(),null==i.bindZoomEvent||i.bindZoomEvent())):(r.arcs&&i.redrawArc(h,g,d.Transform),r.radar&&i.redrawRadar()),a.resizing||!i.hasPointType()&&!a.hasRadar||i.updateCircle(),i.hasDataLabel()&&!i.hasArcType(null,["radar"])&&i.updateText(),null==i.redrawTitle||i.redrawTitle(),u&&i.updateTypesElements(),i.generateRedrawList(o,c,h,d.Subchart),i.callPluginHook("$redraw",t,h)},generateRedrawList:function(t,e,i,n){var a=this,r=a.config,s=a.state,o=a.getDrawShape();s.hasAxis&&r.subchart_show&&a.redrawSubchart(n,i,o);var l=e&&a.generateFlow({targets:t,flow:e,duration:e.duration,shape:o,xv:a.xv.bind(a)}),c=(i||l)&&et(),u=a.getRedrawList(o,e,l,c),d=function(){l&&l(),s.redrawing=!1,L(r.onrendered,a.api)};if(d)if(c&&u.length){var h=te();(0,pe.transition)().duration(i).each((function(){u.reduce((function(t,e){return t.concat(e)}),[]).forEach((function(t){return h.add(t)}))})).call(h,d)}else s.transiting||d();a.mapToIds(a.data.targets).forEach((function(t){s.withoutFadeIn[t]=!0}))},getRedrawList:function(t,e,i,n){var a=this,r=a.config,s=a.state,o=s.hasAxis,l=s.hasRadar,c=a.$el.grid,u=t.pos,d=u.cx,h=u.cy,g=u.xForText,f=u.yForText,p=[];return o&&((r.grid_x_lines.length||r.grid_y_lines.length)&&p.push(a.redrawGrid(n)),r.regions.length&&p.push(a.redrawRegion(n)),Object.keys(t.type).forEach((function(e){var i=G(e),r=t.type[e];(/^(area|line)$/.test(e)&&a.hasTypeOf(i)||a.hasType(e))&&p.push(a["redraw"+i](r,n))})),!e&&c.main&&p.push(a.updateGridFocus())),a.hasArcType()&&!l||C(r.data_labels)&&!1!==r.data_labels&&p.push(a.redrawText(g,f,e,n)),!a.hasPointType()&&!l||r.point_focus_only||a.redrawCircle&&p.push(a.redrawCircle(d,h,n,i)),p},updateAndRedraw:function(t){void 0===t&&(t={});var e,i=this,n=i.config,a=i.state;t.withTransition=O(t,"withTransition",!0),t.withTransform=O(t,"withTransform",!1),t.withLegend=O(t,"withLegend",!1),t.withUpdateXDomain=!0,t.withUpdateOrgXDomain=!0,t.withTransitionForExit=!1,t.withTransitionForTransform=O(t,"withTransitionForTransform",t.withTransition),t.withLegend&&n.legend_show||(a.hasAxis&&(e=i.axis.generateTransitions(t.withTransitionForAxis?n.transition_duration:0)),i.updateScales(),i.updateSvgSize(),i.transformAll(t.withTransitionForTransform,e)),i.redraw(t,e)},redrawWithoutRescale:function(){this.redraw({withY:!1,withDimension:!1,withLegend:!1,withSubchart:!1,withEventRect:!1,withTransitionForAxis:!1})}};function xe(t,e,i){void 0===t&&(t="linear"),void 0===e&&(e=0),void 0===i&&(i=1);var n={linear:le.scaleLinear,log:le.scaleSymlog,_log:le.scaleLog,time:le.scaleTime,utc:le.scaleUtc}[t]();return n.type=t,/_?log/.test(t)&&n.clamp(!0),n.range([e,i])}var _e={getXScale:function(t,e,i,n){var a=this,r=a.scale.zoom||xe(a.axis.getAxisType("x"),t,e);return a.getCustomizedScale(i?r.domain(i):r,n)},getYScale:function(t,e,i,n){var a=xe(this.axis.getAxisType(t),e,i);return n&&a.domain(n),a},getYScaleById:function(t,e){void 0===e&&(e=!1);var i="y2"===this.axis.getId(t),n=e?i?"subY2":"subY":i?"y2":"y";return this.scale[n]},getCustomizedScale:function(t,e){var i=this,n=e||function(){return i.axis.x.tickOffset()},a=function(e,i){var a=t(e)+n();return i?a:Math.ceil(a)};for(var r in t)a[r]=t[r];return a.orgDomain=function(){return t.domain()},a.orgScale=function(){return t},i.axis.isCategorized()&&(a.domain=function(e){var i=e;return arguments.length?(t.domain(i),a):[(i=this.orgDomain())[0],i[1]+1]}),a},updateScales:function(t,e){void 0===e&&(e=!0);var i=this,n=i.axis,a=i.config,r=i.format,s=i.org,o=i.scale,l=i.state,c=l.width,u=l.height,d=l.width2,h=l.height2;if(l.hasAxis){var g,f=a.axis_rotated,p=i.getResettedPadding(1),v={x:f?p:0,y:f?0:u,subX:f?1:0,subY:f?0:h},x={x:f?u:c,y:f?c:p,subX:f?u:c,subY:f?d:1},_=e&&(null==(g=o.x)?void 0:g.orgDomain()),m=e&&s.xDomain;o.x=i.getXScale(v.x,x.x,_,(function(){return n.x.tickOffset()})),o.subX=i.getXScale(v.x,x.x,m,(function(t){return t%1?0:n.subX.tickOffset()})),r.xAxisTick=n.getXAxisTickFormat(),r.subXAxisTick=n.getXAxisTickFormat(!0),n.setAxis("x",o.x,a.axis_x_tick_outer,t),a.subchart_show&&n.setAxis("subX",o.subX,a.axis_x_tick_outer,t),o.y=i.getYScale("y",v.y,x.y,o.y?o.y.domain():a.axis_y_default),o.subY=i.getYScale("y",v.subY,x.subY,o.subY?o.subY.domain():a.axis_y_default),n.setAxis("y",o.y,a.axis_y_tick_outer,t),a.axis_y2_show&&(o.y2=i.getYScale("y2",v.y,x.y,o.y2?o.y2.domain():a.axis_y2_default),o.subY2=i.getYScale("y2",v.subY,x.subY,o.subY2?o.subY2.domain():a.axis_y2_default),n.setAxis("y2",o.y2,a.axis_y2_tick_outer,t))}else null==i.updateArc||i.updateArc()},xx:function(t){var e=this.config,i=this.scale,n=i.x,a=i.zoom,r=e.zoom_enabled&&a?a:n;return t?r(g(t.x)?t.x:t):null},xv:function(t){var e=this,i=e.axis,n=e.config,a=e.scale,r=a.x,s=a.zoom,o=n.zoom_enabled&&s?s:r,l=e.getBaseValue(t);return i.isTimeSeries()?l=tt.call(e,l):i.isCategorized()&&x(l)&&(l=n.axis_x_categories.indexOf(l)),Math.ceil(o(l))},yv:function(t){var e=this.scale,i=e.y,n=e.y2,a=t.axis&&"y2"===t.axis?n:i;return Math.ceil(a(this.getBaseValue(t)))},subxx:function(t){return t?this.scale.subX(t.x):null}},me=f(9),ye={getDrawShape:function(){var t=this,e=t.config.axis_rotated,i=t.state.hasRadar,n={type:{},indices:{},pos:{}};if(["bar","candlestick","line","area"].forEach((function(e){var i=G(/^(bubble|scatter)$/.test(e)?"line":e);if(t.hasType(e)||t.hasTypeOf(i)||"line"===e&&(t.hasType("bubble")||t.hasType("scatter"))){var a=t.getShapeIndices(t["is"+i+"Type"]),r=t["generateDraw"+i];n.indices[e]=a,n.type[e]=r?r.bind(t)(a,!1):void 0}})),!t.hasArcType()||i){var a=i?t.radarCircleX:e?t.circleY:t.circleX,r=i?t.radarCircleY:e?t.circleX:t.circleY;n.pos={xForText:t.generateXYForText(n.indices,!0),yForText:t.generateXYForText(n.indices,!1),cx:(a||function(){}).bind(t),cy:(r||function(){}).bind(t)}}return n},getShapeIndices:function(t){var e=this,i=e.config,n=i.data_xs,a=C(n),r={},s=a?{}:0;return a&&H(Object.keys(n).map((function(t){return n[t]}))).forEach((function(t){s[t]=0,r[t]={}})),e.filterTargetsToShow(e.data.targets.filter(t,e)).forEach((function(t){for(var e,a=(t.id in n?n[t.id]:""),o=a?r[a]:r,l=0;e=i.data_groups[l];l++)if(!(e.indexOf(t.id)<0))for(var c,u=0;c=e[u];u++)if(c in o){o[t.id]=o[c];break}m(o[t.id])&&(o[t.id]=a?s[a]++:s++,o.__max__=(a?s[a]:s)-1)})),r},getIndices:function(t,e){var i=this,n=i.config,a=n.data_xs,r=n.bar_indices_removeNull,s=e.id,o=e.index;if(i.isBarType(s)&&r){var l={};return i.getAllValuesOnIndex(o,!0).forEach((function(t,e){l[t.id]=e,l.__max__=e})),l}return C(a)?t[a[s]]:t},getIndicesMax:function(t){return C(this.config.data_xs)?Object.keys(t).map((function(e){return t[e].__max__||0})).reduce((function(t,e){return t+e})):t.__max__},getShapeX:function(t,e,i){var n=this,a=n.config,r=n.scale,s=i?r.subX:r.zoom||r.x,o=a.bar_padding,l=function(t,e){return t+e},c=k(t)&&(t._$total.length?t._$total.reduce(l)/2:0);return function(i){var a=n.getIndices(e,i,"getShapeX"),r=i.id in a?a[i.id]:0,u=(a.__max__||0)+1,d=0;if(C(i.x)){var h=s(i.x,!0);d=c?h-(t[i.id]||t._$width)+t._$total.slice(0,r+1).reduce(l)-c:h-(_(t)?t:t._$width)*(u/2-r)}return t&&d&&u>1&&o&&(r&&(d+=o*r),u>2?d-=(u-1)*o/2:2===u&&(d-=o/2)),d}},getShapeY:function(t){var e=this,i=e.isStackNormalized();return function(n){var a=n.value;return _(n)?a=n:i?a=e.getRatio("index",n,!0):e.isBubbleZType(n)?a=e.getBubbleZData(n.value,"y"):e.isBarRangeType(n)&&(a=a[1]),e.getYScaleById(n.id,t)(a)}},getShapeYMin:function(t){var e=this,i=e.axis.getId(t),n=e.scale[i].domain()[0],a=e.config["axis_"+i+"_inverted"];return!e.isGrouped(t)&&!a&&n>0?n:0},getShapeOffsetData:function(t){var e=this,i=e.orderTargets(e.filterTargetsToShow(e.data.targets.filter(t,e))),n=e.isStackNormalized(),a=i.map((function(t){var i=t.values,a={};e.isStepType(t)&&(i=e.convertValuesToStep(i));var r=i.reduce((function(t,i){var r=+i.x;return t[r]=i,a[r]=n?e.getRatio("index",i,!0):i.value,t}),{});return{id:t.id,rowValues:i,rowValueMapByXValue:r,values:a}}));return{indexMapByTargetId:i.reduce((function(t,e,i){return t[e.id]=i,t}),{}),shapeOffsetTargets:a}},getShapeOffset:function(t,e,i){var n=this,a=n.getShapeOffsetData(t),r=a.shapeOffsetTargets,s=a.indexMapByTargetId;return function(t,a){var o=t.id,l=t.value,c=t.x,u=n.getIndices(e,t),d=n.getYScaleById(o,i);if(n.isBarRangeType(t))return d(l[0]);var h=d(n.getShapeYMin(o)),g=+c,f=h;return r.filter((function(t){return t.id!==o})).forEach((function(t){var e=t.id,i=t.rowValueMapByXValue,n=t.rowValues,r=t.values;if(u[e]===u[o]&&s[e]<s[o]){var c,p=n[a];p&&+p.x===g||(p=i[g]),(null==(c=p)?void 0:c.value)*l>=0&&_(r[g])&&(f+=d(r[g])-h)}})),f}},getBarW:function(t,e,i){var n=this,a=n.config,r=n.org,s=n.scale,o=n.getMaxDataCount(),l="bar"===t&&a.data_groups.length,c=t+"_width",u=s.zoom&&!n.axis.isCategorized()?r.xDomain.map((function(t){return s.zoom(t)})).reduce((function(t,e){return Math.abs(t)+e}))/o:e.tickInterval(o),d=function(t){var e=t?a[c][t]:a[c],n=t?e.ratio:a[c+"_ratio"],r=t?e.max:a[c+"_max"],s=_(e)?e:i?u*n/i:0;return r&&s>r?r:s},h=d();return!l&&k(a[c])&&(h={_$width:h,_$total:[]},n.filterTargetsToShow(n.data.targets).forEach((function(t){a[c][t.id]&&(h[t.id]=d(t.id),h._$total.push(h[t.id]||h._$width))}))),h},getShapeByIndex:function(t,e,i){var n=this.$el,a=g(e)?"-"+e:"",r=n[t];return r=r&&!r.empty()?r.filter((function(t){return!i||t.id===i})).filter((function(t){return!g(e)||t.index===e})):(i?n.main.selectAll("."+Et[t+"s"]+this.getTargetSelectorSuffix(i)):n.main).selectAll("."+Et[t]+a)},isWithinShape:function(t,e){var i,a=this,r=(0,n.select)(t);return a.isTargetToShow(e.id)?null!=a.hasValidPointType&&a.hasValidPointType(t.nodeName)?i=a.isStepType(e)?a.isWithinStep(t,a.getYScaleById(e.id)(e.value)):a.isWithinCircle(t,a.isBubbleType(e)?1.5*a.pointSelectR(e):0):"path"===t.nodeName&&(i=!r.classed(Et.bar)||a.isWithinBar(t)):i=!1,i},getInterpolate:function(t){var e=this.getInterpolateType(t);return{basis:me.curveBasis,"basis-closed":me.curveBasisClosed,"basis-open":me.curveBasisOpen,bundle:me.curveBundle,cardinal:me.curveCardinal,"cardinal-closed":me.curveCardinalClosed,"cardinal-open":me.curveCardinalOpen,"catmull-rom":me.curveCatmullRom,"catmull-rom-closed":me.curveCatmullRomClosed,"catmull-rom-open":me.curveCatmullRomOpen,"monotone-x":me.curveMonotoneX,"monotone-y":me.curveMonotoneY,natural:me.curveNatural,"linear-closed":me.curveLinearClosed,linear:me.curveLinear,step:me.curveStep,"step-after":me.curveStepAfter,"step-before":me.curveStepBefore}[e]},getInterpolateType:function(t){var e=this,i=e.config,n=i.spline_interpolation_type,a=e.isInterpolationType(n)?n:"cardinal";return e.isSplineType(t)?a:e.isStepType(t)?i.line_step_type:"linear"},isWithinBar:function(t){var e=M(this.state.event,t),i=z(t),n=i[0],a=i[1],r=Math.min(n.x,a.x),s=Math.min(n.y,a.y),o=this.config.bar_sensitivity,l=t.getBBox(),c=l.width,u=l.height;return r-o<e[0]&&e[0]<r+c+o&&s-o<e[1]&&e[1]<s+u+o}},be={setContainerSize:function(){var t=this,e=t.state;e.current.width=t.getCurrentWidth(),e.current.height=t.getCurrentHeight()},getCurrentWidth:function(){return this.config.size_width||this.getParentWidth()},getCurrentHeight:function(){var t=this,e=t.config,i=e.size_height||t.getParentHeight();return i>0?i:320/(t.hasType("gauge")&&!e.gauge_fullCircle?2:1)},getCurrentPaddingTop:function(){var t=this,e=t.config,i=t.state.hasAxis,n=t.$el,a=i?e.axis_y2_axes.length:0,r=g(e.padding_top)?e.padding_top:0;return n.title&&n.title.node()&&(r+=t.getTitlePadding()),a&&e.axis_rotated&&(r+=t.getHorizontalAxisHeight("y2")*a),r},getCurrentPaddingBottom:function(){var t=this,e=t.config,i=t.state.hasAxis,n=e.axis_rotated?"y":"x",a=i?e["axis_"+n+"_axes"].length:0;return(g(e.padding_bottom)?e.padding_bottom:0)+(a?t.getHorizontalAxisHeight(n)*a:0)},getCurrentPaddingLeft:function(t){var e=this,i=e.config,n=e.state.hasAxis,a=i.axis_rotated,r=a?"x":"y",s=n?i["axis_"+r+"_axes"].length:0,o=n?e.getAxisWidthByAxisId(r,t):0;return(g(i.padding_left)?i.padding_left:n&&a?i.axis_x_show?Math.max(T(o),40):1:!n||i.axis_y_show&&!i.axis_y_inner?T(o):e.axis.getAxisLabelPosition("y").isOuter?30:1)+o*s},getCurrentPaddingRight:function(t){void 0===t&&(t=!1);var e=this,i=e.config,n=e.state.hasAxis,a=e.state.isLegendRight?e.getLegendWidth()+20:0,r=n?i.axis_y2_axes.length:0,s=n?e.getAxisWidthByAxisId("y2"):0,o=t?e.axis.getXAxisTickTextY2Overflow(10):0;return(g(i.padding_right)?i.padding_right+1:e.axis&&i.axis_rotated?10+a:!e.axis||i.axis_y2_show&&!i.axis_y2_inner?Math.max(T(s)+a,o):Math.max(2+a+(e.axis.getAxisLabelPosition("y2").isOuter?20:0),o))+s*r},getParentRectValue:function(t){for(var e="offset"+G(t),i=this.$el.chart.node(),n=0;n<30&&i&&"BODY"!==i.tagName;){try{n=i.getBoundingClientRect()[t]}catch(t){e in i&&(n=i[e])}i=i.parentNode}var a=r.body[e];return n>a&&(n=a),n},getParentWidth:function(){return this.getParentRectValue("width")},getParentHeight:function(){var t=this.$el.chart.style("height"),e=0;return t&&(e=/px$/.test(t)?parseInt(t,10):this.getParentRectValue("height")),e},getSvgLeft:function(t){var e=this,i=e.config,n=e.$el,a=i.axis_rotated||!i.axis_rotated&&!i.axis_y_inner,r=i.axis_rotated?lt.axisX:lt.axisY,s=n.main.select("."+r).node(),o=s&&a?s.getBoundingClientRect():{right:0},l=n.chart.node().getBoundingClientRect(),c=e.hasArcType(),u=o.right-l.left-(c?0:e.getCurrentPaddingLeft(t));return u>0?u:0},updateDimension:function(t){var e,i=this,n=i.config,a=i.state.hasAxis,r=i.$el;a&&!t&&i.axis.x&&n.axis_rotated&&(null==(e=i.axis.subX)||e.create(r.axis.subX));i.updateScales(t),i.updateSvgSize(),i.transformAll(!1)},updateSvgSize:function(){var t=this,e=t.state,i=e.clip,n=e.current,a=e.hasAxis,r=e.width,s=e.height,o=t.$el.svg;if(o.attr("width",n.width).attr("height",n.height),a){var l=o.select("."+At.brush+" .overlay"),c={width:0,height:0};l.size()&&(c.width=+l.attr("width"),c.height=+l.attr("height")),o.selectAll(["#"+i.id,"#"+i.idGrid]).select("rect").attr("width",r).attr("height",s),o.select("#"+i.idXAxis).select("rect").call(t.setXAxisClipPath.bind(t)),o.select("#"+i.idYAxis).select("rect").call(t.setYAxisClipPath.bind(t)),i.idSubchart&&o.select("#"+i.idSubchart).select("rect").attr("width",r).attr("height",c.height)}},getResettedPadding:function(t){var e=this.config,i=_(t),n=i?0:{};return!1===e.padding?i||Object.keys(t).forEach((function(i){n[i]=S(e.data_labels)||!1===e.data_labels||"top"!==i?0:t[i]})):n=t,n},updateSizes:function(t){var e=this,i=e.config,n=e.state,a=e.$el.legend,r=i.axis_rotated,s=e.hasArcType();t||e.setContainerSize();var o={width:a?e.getLegendWidth():0,height:a?e.getLegendHeight():0};!s&&i.axis_x_show&&i.axis_x_tick_autorotate&&e.updateXAxisTickClip();var l=n.isLegendRight||n.isLegendInset?0:o.height,c=r||s?0:e.getHorizontalAxisHeight("x"),u=i.subchart_axis_x_show&&i.subchart_axis_x_tick_text_show?c:30,d=i.subchart_show&&!s?i.subchart_size_height+u:0;n.margin=!s&&r?{top:e.getHorizontalAxisHeight("y2")+e.getCurrentPaddingTop(),right:s?0:e.getCurrentPaddingRight(!0),bottom:e.getHorizontalAxisHeight("y")+l+e.getCurrentPaddingBottom(),left:d+(s?0:e.getCurrentPaddingLeft())}:{top:4+e.getCurrentPaddingTop(),right:s?0:e.getCurrentPaddingRight(!0),bottom:c+d+l+e.getCurrentPaddingBottom(),left:s?0:e.getCurrentPaddingLeft()},n.margin=e.getResettedPadding(n.margin),n.margin2=r?{top:n.margin.top,right:NaN,bottom:20+l,left:e.state.rotatedPadding.left}:{top:n.current.height-d-l,right:NaN,bottom:u+l,left:n.margin.left},n.margin3={top:0,right:NaN,bottom:0,left:0},null==e.updateSizeForLegend||e.updateSizeForLegend(o),n.width=n.current.width-n.margin.left-n.margin.right,n.height=n.current.height-n.margin.top-n.margin.bottom,n.width<0&&(n.width=0),n.height<0&&(n.height=0),n.width2=r?n.margin.left-n.rotatedPadding.left-n.rotatedPadding.right:n.width,n.height2=r?n.height:n.current.height-n.margin2.top-n.margin2.bottom,n.width2<0&&(n.width2=0),n.height2<0&&(n.height2=0);var h=e.hasType("gauge"),g=i.legend_show&&n.isLegendRight;n.arcWidth=n.width-(g?o.width+10:0),n.arcHeight=n.height-(g&&!h?0:10),h&&!i.gauge_fullCircle&&(n.arcHeight+=n.height-e.getPaddingBottomForGauge()),null==e.updateRadius||e.updateRadius(),n.isLegendRight&&s&&(n.margin3.left=n.arcWidth/2+1.1*n.radiusExpanded)}},Te={opacityForText:function(t){var e=this;return e.isBarType(t)&&!e.meetsLabelThreshold(Math.abs(e.getRatio("bar",t)),"bar")?"0":e.hasDataLabel?null:"0"},initText:function(){this.$el.main.select("."+rt.chart).append("g").attr("class",kt.chartTexts)},updateTargetsForText:function(t){var e=this,i=e.getChartClass("Text"),n=e.getClass("texts","id"),a=e.classFocus.bind(e);e.$el.main.select("."+kt.chartTexts).selectAll("."+kt.chartText).data(t).attr("class",(function(t){return i(t)+a(t)})).enter().append("g").style("opacity","0").attr("class",i).style("pointer-events","none").append("g").attr("class",n)},updateText:function(){var t=this,e=t.$el,i=t.$T,a=t.config,r=t.getClass("text","index"),s=e.main.selectAll("."+kt.texts).selectAll("."+kt.text).data(t.labelishData.bind(t));i(s.exit()).style("fill-opacity","0").remove(),e.text=s.enter().append("text").merge(s).attr("class",r).attr("text-anchor",(function(e){var i=e.value<0;if(t.isCandlestickType(e)){var n=t.getCandlestickData(e);i=!(null!=n&&n._isUp)}return a.axis_rotated?i?"end":"start":"middle"})).style("fill",t.updateTextColor.bind(t)).style("fill-opacity","0").each((function(e,i,a){var r=(0,n.select)(this),s=e.value;if(t.isBubbleZType(e))s=t.getBubbleZData(s,"z");else if(t.isCandlestickType(e)){var o=t.getCandlestickData(e);o&&(s=o.close)}s=t.dataLabelFormat(e.id)(s,e.id,i,a),_(s)?this.textContent=s:P(r,s)}))},updateTextColor:function(t){var e,i=this,n=i.config,a=n.data_labels_colors,r=i.isArcType(t)&&!i.isRadarType(t)?null:i.color(t);if(x(a))e=a;else if(R(a)){e=a[(t.data||t).id]}else v(a)&&(e=a.bind(i.api)(r,t));if(i.isCandlestickType(t)&&!v(a)){var s=i.getCandlestickData(t);if(null==s||!s._isUp){var o=n.candlestick_color_down;e=R(o)?o[t.id]:o}}return e||r},updateTextBacgroundColor:function(t){var e=this,i=e.$el,n=e.config.data_labels_backgroundColors,a="";if(x(n)||R(n)){var r=x(n)?"":e.getTargetSelectorSuffix("id"in t?t.id:t.data.id),s=i.defs.select(["filter[id*='labels-bg","']"].join(r));s.size()&&(a="url(#"+s.attr("id")+")")}return a||null},redrawText:function(t,e,i,n){var a=this,r=a.$T,s=F(!0);return a.$el.text.style("fill",a.updateTextColor.bind(a)).attr("filter",a.updateTextBacgroundColor.bind(a)).style("fill-opacity",i?0:a.opacityForText.bind(a)).each((function(i,a){var o=r(this,!(!n||!this.getAttribute("x")),s),l=t.bind(this)(i,a),c=e.bind(this)(i,a);this.childElementCount?o.attr("transform","translate("+l+" "+c+")"):o.attr("x",l).attr("y",c)})),!0},getTextRect:function(t,e){var i=this,a=t.node?t.node():t;/text/i.test(a.tagName)||(a=a.querySelector("text"));var r=a.textContent,s=qt+"-"+r.replace(/\W/g,"_"),o=i.cache.get(s);return o||(i.$el.svg.append("text").style("visibility","hidden").style("font",(0,n.select)(a).style("font")).classed(e,!0).text(r).call((function(t){o=$(t.node())})).remove(),i.cache.add(s,o)),o},generateXYForText:function(t,e){var i=this,n=Object.keys(t),a={},r=e?i.getXForText:i.getYForText;return i.hasType("radar")&&n.push("radar"),n.forEach((function(e){a[e]=i["generateGet"+G(e)+"Points"](t[e],!1)})),function(t,e){var n=(i.isAreaType(t)?"area":i.isBarType(t)&&"bar")||i.isCandlestickType(t)&&"candlestick"||i.isRadarType(t)&&"radar"||"line";return r.call(i,a[n](t,e),t,this)}},getCenteredTextPos:function(t,e,i){var n=this.config,a=n.axis_rotated;if(n.data_labels.centered&&this.isBarType(t)){var r=$(i),s=t.value>=0;if(a){var o=(s?e[1][1]-e[0][1]:e[0][1]-e[1][1])/2+r.width/2;return s?-o-3:o+2}var l=(s?e[0][1]-e[1][1]:e[1][1]-e[0][1])/2+r.height/2;return s?l:-l-2}return 0},getTextPos:function(t,e){var i=this.config.data_labels_position;return(t in i?i[t]:i)[e]||0},getXForText:function(t,e,i){var n,a=this,r=a.config,s=a.state,o=r.axis_rotated,l=t[0][0];if(a.isCandlestickType(e))o?l=null!=(n=a.getCandlestickData(e))&&n._isUp?t[2][2]+4:t[2][1]-4:l+=(t[1][0]-l)/2;else if(o){var c=a.isBarType(e)?4:6;l=t[2][1]+c*(e.value<0?-1:1)}else l=a.hasType("bar")?(t[2][0]+t[0][0])/2:l;if(null===e.value)if(l>s.width){var u=$(i).width;l=s.width-u}else l<0&&(l=4);return o&&(l+=a.getCenteredTextPos(e,t,i)),l+a.getTextPos(e.id,"x")},getYForText:function(t,e,i){var n,a=this,r=a.config,s=a.state,o=r.axis_rotated,l=r.point_r,c=$(i),u=e.value,d=3;if(a.isCandlestickType(e))u=a.getCandlestickData(e),o?(n=t[0][0],n+=(t[1][0]-n)/2+d):n=u&&u._isUp?t[2][2]-d:t[2][1]+4*d;else if(o)n=(t[0][0]+t[2][0]+.6*c.height)/2;else if(n=t[2][1],_(l)&&l>5&&(a.isLineType(e)||a.isScatterType(e))&&(d+=r.point_r/2.3),u<0||0===u&&!s.hasPositiveValue&&s.hasNegativeValue)n+=c.height+(a.isBarType(e)?-d:d);else{var h=2*-d;a.isBarType(e)?h=-d:a.isBubbleType(e)&&(h=d),n+=h}if(null===e.value&&!o){var g=c.height;n<g?n=g:n>s.height&&(n=s.height-4)}return o||(n+=a.getCenteredTextPos(e,t,i)),n+a.getTextPos(e.id,"y")},markOverlapped:function(t,e,i){var a=e.$el.arcs.selectAll(i),r=a.filter((function(e){return e.data.id!==t})),s=a.filter((function(e){return e.data.id===t})),o=V(s.node()),l=function(t,e){return Math.sqrt(Math.pow(t,2)+Math.pow(e,2))};s.node()&&r.each((function(){var t=V(this),e=(0,n.select)(this),i=l(o.e,o.f)>l(t.e,t.f)?s:e,a=Math.ceil(Math.abs(o.e-t.e))<Math.ceil(i.node().getComputedTextLength()),r=Math.ceil(Math.abs(o.f-t.f))<parseInt(s.style("font-size"),10);e.classed(kt.TextOverlapping,a&&r)}))},undoMarkOverlapped:function(t,e){t.$el.arcs.selectAll(e).each((function(){(0,n.selectAll)([this,this.previousSibling]).classed(kt.TextOverlapping,!1)}))},meetsLabelThreshold:function(t,e){void 0===t&&(t=0);return t>=(this.config[e+"_label_threshold"]||0)}};function we(t,e){void 0===t&&(t="left");var i=_(e);return t.indexOf("center")>-1?i?e/2:"middle":t.indexOf("right")>-1?i?e:"end":i?0:"start"}var Ae={initTitle:function(){var t=this.config,e=this.$el;t.title_text&&(e.title=e.svg.append("g"),P(e.title.append("text").style("text-anchor",we(t.title_position)).attr("class",kt.title),t.title_text,[.3,1.5]))},redrawTitle:function(){var t=this,e=t.config,i=t.state.current,n=t.$el.title;if(n){var a=t.yForTitle.call(t);/g/i.test(n.node().tagName)?n.attr("transform","translate("+we(e.title_position,i.width)+", "+a+")"):n.attr("x",t.xForTitle.call(t)).attr("y",a)}},xForTitle:function(){var t,e=this,i=e.config,n=e.state.current,a=i.title_position||"left",r=e.getTextRect(e.$el.title,kt.title).width;return/(right|center)/.test(a)?(t=n.width-r,a.indexOf("right")>=0?t=n.width-r-i.title_padding.right:a.indexOf("center")>=0&&(t=(n.width-r)/2)):t=i.title_padding.left||0,t},yForTitle:function(){var t=this;return(t.config.title_padding.top||0)+t.getTextRect(t.$el.title,kt.title).height},getTitlePadding:function(){return this.yForTitle()+(this.config.title_padding.bottom||0)}},ke={initTooltip:function(){var t=this,e=t.config,i=t.$el;i.tooltip=(0,n.select)(e.tooltip_contents.bindto),i.tooltip.empty()&&(i.tooltip=i.chart.append("div").attr("class",St.tooltipContainer).style("position","absolute").style("pointer-events","none").style("display","none")),t.bindTooltipResizePos()},initShowTooltip:function(){var t=this,e=t.config,i=t.$el,n=t.state,a=n.hasAxis,r=n.hasRadar;if(e.tooltip_init_show){var s,o,l=!(a&&r);if(null!=(s=t.axis)&&s.isTimeSeries()&&x(e.tooltip_init_x)){var c,u,d=t.data.targets[0];for(e.tooltip_init_x=tt.call(t,e.tooltip_init_x),c=0;(u=d.values[c])&&u.x-e.tooltip_init_x!=0;c++);e.tooltip_init_x=c}var h=t.data.targets.map((function(i){var n=l?0:e.tooltip_init_x;return t.addName(i.values[n])}));l&&(h=[h[e.tooltip_init_x]]),i.tooltip.html(t.getTooltipHTML(h,null==(o=t.axis)?void 0:o.getXAxisTickFormat(),t.getDefaultValueFormat(),t.color)),e.tooltip_contents.bindto||i.tooltip.style("top",e.tooltip_init_position.top).style("left",e.tooltip_init_position.left).style("display",null)}},getTooltipHTML:function(){var t=this,e=t.api,i=t.config;return v(i.tooltip_contents)?i.tooltip_contents.bind(e).apply(void 0,arguments):t.getTooltipContent.apply(t,arguments)},getTooltipContent:function(t,e,i,n){var a=this,r=a.api,s=a.config,o=a.state,l=["title","name","value"].map((function(t){var e=s["tooltip_format_"+t];return v(e)?e.bind(r):e})),c=l[0],u=l[1],d=l[2];c=c||e,u=u||function(t){return t},d=d||(a.isStackNormalized()?function(t,e){return(100*e).toFixed(2)+"%"}:i);var h=s.tooltip_order,f=function(t){return a.axis&&a.isBubbleZType(t)?a.getBubbleZData(t.value,"z"):a.getBaseValue(t)},p=a.levelColor?function(t){return a.levelColor(t.value)}:function(t){return n(t)},x=s.tooltip_contents,_=x.template,y=a.mapToTargetIds();if(null===h&&s.data_groups.length){var b=a.orderTargets(a.data.targets).map((function(t){return t.id})).reverse();t.sort((function(t,e){var i=t?t.value:null,n=e?e.value:null;return i>0&&n>0&&(i=t.id?b.indexOf(t.id):null,n=e.id?b.indexOf(e.id):null),i-n}))}else/^(asc|desc)$/.test(h)?t.sort((function(t,e){var i=t?f(t):null,n=e?f(e):null;return"asc"===h?i-n:n-i})):v(h)&&t.sort(h.bind(r));var T,w,A,k,S,C=a.getTooltipContentTemplate(_),E=t.length;for(S=0;S<E;S++)if((w=t[S])&&(f(w)||0===f(w))){if(m(T)){var O=(o.hasAxis||o.hasRadar)&&I(c?c(w.x):w.x);T=Q(C[0],{CLASS_TOOLTIP:St.tooltip,TITLE:g(O)?_?O:'<tr><th colspan="2">'+O+"</th></tr>":""})}if(!w.ratio&&a.$el.arcs&&(w.ratio=a.getRatio("arc",a.$el.arcs.select("path."+st.arc+"-"+w.id).data()[0])),A=[w.ratio,w.id,w.index,t],k=I(d.apply(void 0,[f(w)].concat(A))),a.isAreaRangeType(w)){var L=["high","low"].map((function(t){return I(d.apply(void 0,[a.getRangedData(w,t)].concat(A)))})),D=L[0],P=L[1];k="<b>Mid:</b> "+k+" <b>High:</b> "+D+" <b>Low:</b> "+P}else if(a.isCandlestickType(w)){var z=["open","high","low","close","volume"].map((function(t){return I(d.apply(void 0,[a.getRangedData(w,t,"candlestick")].concat(A)))})),M=z[0],X=z[1],$=z[2],F=z[3],B=z[4];k="<b>Open:</b> "+M+" <b>High:</b> "+X+" <b>Low:</b> "+$+" <b>Close:</b> "+F+(B?" <b>Volume:</b> "+B:"")}else if(a.isBarRangeType(w)){var N=w.value,Y=N[0],G=N[1];k=d(Y)+" ~ "+d(G)}if(void 0!==k){var j=function(){if(null===w.name)return"continue";var t=I(u.apply(void 0,[w.name].concat(A))),e=p(w),i={CLASS_TOOLTIP_NAME:St.tooltipName+a.getTargetSelectorSuffix(w.id),COLOR:_||!a.patterns?e:'<svg><rect style="fill:'+e+'" width="10" height="10"></rect></svg>',NAME:t,VALUE:k};if(_&&R(x.text)){var n=y.indexOf(w.id);Object.keys(x.text).forEach((function(t){i[t]=x.text[t][n]}))}T+=Q(C[1],i)}();if("continue"===j)continue}}return T+"</table>"},getTooltipContentTemplate:function(t){return(t||'<table class="{=CLASS_TOOLTIP}"><tbody>\n\t\t\t\t{=TITLE}\n\t\t\t\t{{<tr class="{=CLASS_TOOLTIP_NAME}">\n\t\t\t\t\t<td class="name">'+(this.patterns?"{=COLOR}":'<span style="background-color:{=COLOR}"></span>')+'{=NAME}</td>\n\t\t\t\t\t<td class="value">{=VALUE}</td>\n\t\t\t\t</tr>}}\n\t\t\t</tbody></table>').replace(/(\r?\n|\t)/g,"").split(/{{(.*)}}/)},tooltipPosition:function(t,e,i,n){var a=this,r=a.config,s=a.scale,o=a.state,l=o.width,c=o.height,u=o.current,d=o.isLegendRight,h=o.inputType,g=o.event,f=a.hasType("gauge")&&!r.gauge_fullCircle,p=a.getSvgLeft(!0),v=p+u.width-a.getCurrentPaddingRight(),x=a.getCurrentPaddingLeft(!0),_=M(g,n),m=_[0],y=_[1];if(a.hasArcType()){"touch"===h||a.hasType("radar")||(y+=f?c:c/2,m+=(l-(d?a.getLegendWidth():0))/2)}else{var b=s.x(t[0].x);r.axis_rotated?(y=b+20,m+=p+100,v-=p):(y-=5,m=p+x+20+(a.scale.zoom?m:b))}m+e+15>v&&(m-=e+x),y+i>u.height&&(y-=f?3*i:i+30);var T={top:y,left:m};return Object.keys(T).forEach((function(t){T[t]<0&&(T[t]=0)})),T},showTooltip:function(t,e){var i=this,n=i.config,a=i.scale,r=i.state,s=i.$el.tooltip,o=n.tooltip_contents.bindto,l=t.filter((function(t){return t&&g(i.getBaseValue(t))}));if(s&&0!==l.length&&n.tooltip_show){var c=s.datum(),u=c||{},d=u.width,h=void 0===d?0:d,f=u.height,p=void 0===f?0:f,v=JSON.stringify(t);if(!c||c.current!==v){var x=t.concat().sort()[0].index;L(n.tooltip_onshow,i.api,t),s.html(i.getTooltipHTML(t,i.axis?i.axis.getXAxisTickFormat():i.categoryName.bind(i),i.getDefaultValueFormat(),i.color)).style("display",null).style("visibility",null).datum(c={index:x,current:v,width:h=s.property("offsetWidth"),height:p=s.property("offsetHeight")}),L(n.tooltip_onshown,i.api,t),i._handleLinkedCharts(!0,x)}if(!o){var _,m,y=(null==(_=n.tooltip_position)?void 0:_.bind(i.api))||i.tooltipPosition.bind(i),b=M(r.event,e),T={x:b[0],y:b[1]},w=null==(m=t.filter(Boolean))?void 0:m.shift();a.x&&w&&"x"in w&&(T.xAxis=a.x(w.x));var A=y(l,h,p,e,T);["top","left"].forEach((function(t){var e=A[t];s.style(t,e+"px"),"left"!==t||c.xPosInPercent||(c.xPosInPercent=e/r.current.width*100)}))}}},bindTooltipResizePos:function(){var t=this,e=t.resizeFunction,i=t.state,n=t.$el.tooltip;e.add((function(){if("block"===n.style("display")){var t=i.current,e=n.datum(),a=e.width,r=e.xPosInPercent,s=t.width/100*r,o=t.width-(s+a);o<0&&(s+=o),n.style("left",s+"px")}}))},hideTooltip:function(t){var e=this,i=e.api,n=e.config,a=e.$el.tooltip;if(a&&"none"!==a.style("display")&&(!n.tooltip_doNotHide||t)){var r=JSON.parse(a.datum().current);L(n.tooltip_onhide,i,r),a.style("display","none").style("visibility","hidden").datum(null),L(n.tooltip_onhidden,i,r)}},_handleLinkedCharts:function(t,e){var i,n=this,a=n.charts,s=n.config;if(null!=(i=n.state.event)&&i.isTrusted&&s.tooltip_linked&&a.length>1){var o=s.tooltip_linked_name;a.filter((function(t){return t!==n.api})).forEach((function(i){var n=i.internal,a=n.config,s=n.$el,l=a.tooltip_linked,c=a.tooltip_linked_name,u=r.body.contains(s.chart.node());if(l&&o===c&&u){var d=s.tooltip.data()[0],h=e!==(null==d?void 0:d.index);try{i.tooltip[t&&h?"show":"hide"]({index:e})}catch(t){}}}))}}},Se={getTranslate:function(t,e){void 0===e&&(e=0);var i,n,a=this,r=a.config,s=a.state,o=r.axis_rotated,l=0;if(e&&/^(x|y2?)$/.test(t)&&(l=a.getAxisSize(t)*e),"main"===t)i=w(s.margin.left),n=w(s.margin.top);else if("context"===t)i=w(s.margin2.left),n=w(s.margin2.top);else if("legend"===t)i=s.margin3.left,n=s.margin3.top;else if("x"===t)i=o?-l:0,n=o?0:s.height+l;else if("y"===t)i=o?0:-l,n=o?s.height+l:0;else if("y2"===t)i=o?0:s.width+l,n=o?1-l:0;else if("subX"===t)i=0,n=o?0:s.height2;else if("arc"===t)i=s.arcWidth/2,n=s.arcHeight/2;else if("radar"===t){var c=a.getRadarSize()[0];i=s.width/2-c,n=w(s.margin.top)}return"translate("+i+", "+n+")"},transformMain:function(t,e){var i=this,n=i.$el.main,a=i.$T,r=null!=e&&e.axisX?e.axisX:a(n.select("."+lt.axisX),t),s=null!=e&&e.axisY?e.axisY:a(n.select("."+lt.axisY),t),o=null!=e&&e.axisY2?e.axisY2:a(n.select("."+lt.axisY2),t);a(n,t).attr("transform",i.getTranslate("main")),r.attr("transform",i.getTranslate("x")),s.attr("transform",i.getTranslate("y")),o.attr("transform",i.getTranslate("y2")),n.select("."+st.chartArcs).attr("transform",i.getTranslate("arc"))},transformAll:function(t,e){var i=this,n=i.config,a=i.state.hasAxis,r=i.$el;i.transformMain(t,e),a&&n.subchart_show&&i.transformContext(t,e),r.legend&&i.transformLegend(t)}},Ce={setTargetType:function(t,e){var i=this,n=i.config,a=i.state.withoutFadeIn;i.mapToTargetIds(t).forEach((function(t){a[t]=e===n.data_types[t],n.data_types[t]=e})),t||(n.data_type=e)},updateTypesElements:function(){var t=this,e=t.state.current;Object.keys(s).forEach((function(i){var n=s[i],a=t.hasType(n,null,!0),r=e.types.indexOf(n);-1===r&&a?e.types.push(n):r>-1&&!a&&e.types.splice(r,1)})),t.setChartElements()},hasType:function(t,e,i){var n,a;void 0===i&&(i=!1);var r=this,s=r.config,o=r.state.current,l=s.data_types,c=e||r.data.targets,u=!1;return!i&&(null==(n=o.types)?void 0:n.indexOf(t))>-1?u=!0:null!=(a=c)&&a.length?c.forEach((function(e){var i=l[e.id];(i===t||!i&&"line"===t)&&(u=!0)})):Object.keys(l).length?Object.keys(l).forEach((function(e){l[e]===t&&(u=!0)})):u=s.data_type===t,u},hasTypeOf:function(t,e,i){var n=this;return void 0===i&&(i=[]),t in l&&!l[t].filter((function(t){return-1===i.indexOf(t)})).every((function(t){return!n.hasType(t,e)}))},isTypeOf:function(t,e){var i=x(t)?t:t.id,n=this.config.data_types[i]||this.config.data_type;return E(e)?e.indexOf(n)>=0:n===e},hasPointType:function(){var t=this;return t.hasTypeOf("Line")||t.hasType("bubble")||t.hasType("scatter")},hasArcType:function(t,e){return this.hasTypeOf("Arc",t,e)},hasMultiArcGauge:function(){return this.hasType("gauge")&&"multi"===this.config.gauge_type},isLineType:function(t){var e=x(t)?t:t.id;return!this.config.data_types[e]||this.isTypeOf(e,l.Line)},isStepType:function(t){return this.isTypeOf(t,l.Step)},isSplineType:function(t){return this.isTypeOf(t,l.Spline)},isAreaType:function(t){return this.isTypeOf(t,l.Area)},isAreaRangeType:function(t){return this.isTypeOf(t,l.AreaRange)},isBarType:function(t){return this.isTypeOf(t,"bar")},isBubbleType:function(t){return this.isTypeOf(t,"bubble")},isCandlestickType:function(t){return this.isTypeOf(t,"candlestick")},isScatterType:function(t){return this.isTypeOf(t,"scatter")},isPieType:function(t){return this.isTypeOf(t,"pie")},isGaugeType:function(t){return this.isTypeOf(t,"gauge")},isDonutType:function(t){return this.isTypeOf(t,"donut")},isRadarType:function(t){return this.isTypeOf(t,"radar")},isArcType:function(t){return this.isPieType(t)||this.isDonutType(t)||this.isGaugeType(t)||this.isRadarType(t)},isCirclePoint:function(t){var e=this.config,i=e.point_pattern;return"circle"===(null==t?void 0:t.tagName)||"circle"===e.point_type&&(!i||E(i)&&0===i.length)},lineData:function(t){return this.isLineType(t)?[t]:[]},arcData:function(t){return this.isArcType(t.data)?[t]:[]},labelishData:function(t){return this.isBarType(t)||this.isLineType(t)||this.isScatterType(t)||this.isBubbleType(t)||this.isCandlestickType(t)||this.isRadarType(t)?t.values.filter((function(t){return _(t.value)||!!t.value})):[]},barLineBubbleData:function(t){return this.isBarType(t)||this.isLineType(t)||this.isBubbleType(t)?t.values:[]},isInterpolationType:function(t){return["basis","basis-closed","basis-open","bundle","cardinal","cardinal-closed","cardinal-open","catmull-rom","catmull-rom-closed","catmull-rom-open","linear","linear-closed","monotone-x","monotone-y","natural"].indexOf(t)>=0}},Ee=function(){function t(t){this.api=void 0,this.config=void 0,this.cache=void 0,this.$el=void 0,this.state=void 0,this.charts=void 0,this.data={xs:{},targets:[]},this.axis=void 0,this.scale={x:null,y:null,y2:null,subX:null,subY:null,subY2:null,zoom:null},this.org={xScale:null,xDomain:null},this.color=void 0,this.patterns=void 0,this.levelColor=void 0,this.point=void 0,this.brush=void 0,this.format={extraLineClasses:null,xAxisTick:null,dataTime:null,defaultAxisTime:null,axisTime:null};var e=this;e.api=t,e.config=new Bt,e.cache=new Kt;var i=new Ot;e.$el=i.getStore("element"),e.state=i.getStore("state"),e.$T=e.$T.bind(e)}var e=t.prototype;return e.$T=function(t,e,i){var a=this.config,r=this.state,s=a.transition_duration,o=a.subchart_show,l=t;l&&("tagName"in l&&(l=(0,n.select)(l)),l=(!1!==e&&s||e)&&(!r.zooming||r.dragging)&&!r.resizing&&r.rendered&&!o?l.transition(i).duration(s):l);return l},e.beforeInit=function(){var t=this;t.callPluginHook("$beforeInit"),L(t.config.onbeforeinit,t.api)},e.afterInit=function(){var t=this;t.callPluginHook("$afterInit"),L(t.config.onafterinit,t.api)},e.init=function(){var t=this,e=t.config,i=t.state,a=t.$el;it(t),i.hasAxis=!t.hasArcType(),i.hasRadar=!i.hasAxis&&t.hasType("radar"),!1===e.padding&&(e.axis_x_show=!1,e.axis_y_show=!1,e.axis_y2_show=!1,e.subchart_show=!1),t.initParams();var s={element:e.bindto,classname:"bb"};R(e.bindto)&&(s.element=e.bindto.element||"#chart",s.classname=e.bindto.classname||s.classname),a.chart=v(s.element.node)?e.bindto.element:(0,n.select)(s.element||[]),a.chart.empty()&&(a.chart=(0,n.select)(r.body.appendChild(r.createElement("div")))),a.chart.html("").classed(s.classname,!0).style("position","relative"),t.initToRender()},e.initToRender=function(t){var e=this,i=e.config,n=e.state,r=e.$el.chart,s=function(){return"none"===r.style("display")||"hidden"===r.style("visibility")},o=i.render.lazy||s(),l=a.MutationObserver;if(o&&l&&!1!==i.render.observe&&!t&&new l((function(t,i){s()||(i.disconnect(),n.rendered||e.initToRender(!0))})).observe(r.node(),{attributes:!0,attributeFilter:["class","style"]}),!o||t){var c=e.convertData(i,e.initWithData);c&&e.initWithData(c),e.afterInit()}},e.initParams=function(){var t=this,e=t,n=e.config,s=e.format,o=e.state,l=n.axis_rotated;if(o.datetimeId="bb-"+ +new Date*F(),t.color=t.generateColor(),t.levelColor=t.generateLevelColor(),t.hasPointType()&&(t.point=t.generatePoint()),o.hasAxis){t.initClip(),s.extraLineClasses=t.generateExtraLineClass(),s.dataTime=n.data_xLocaltime?i.timeParse:i.utcParse,s.axisTime=n.axis_x_localtime?i.timeFormat:i.utcFormat;var c=t.config.zoom_enabled&&"drag"===t.config.zoom_type;s.defaultAxisTime=function(e){var i=t.scale,n=i.x,a=i.zoom,r=c?a:a&&n.orgDomain().toString()!==a.domain().toString(),o=(e.getMilliseconds()?".%L":e.getSeconds()&&".:%S")||e.getMinutes()&&"%I:%M"||e.getHours()&&"%I %p"||1!==e.getDate()&&"%b %d"||r&&1===e.getDate()&&"%b'%y"||e.getMonth()&&"%-m/%-d"||"%Y";return s.axisTime(o)(e)}}o.isLegendRight="right"===n.legend_position,o.isLegendInset="inset"===n.legend_position,o.isLegendTop="top-left"===n.legend_inset_anchor||"top-right"===n.legend_inset_anchor,o.isLegendLeft="top-left"===n.legend_inset_anchor||"bottom-left"===n.legend_inset_anchor,o.rotatedPadding.top=t.getResettedPadding(o.rotatedPadding.top),o.rotatedPadding.right=l&&!n.axis_x_show?0:30,o.inputType=function(t,e){var i=!1;if(e)if(a.navigator&&"maxTouchPoints"in a.navigator)i=a.navigator.maxTouchPoints>0;else if("ontouchmove"in a||a.DocumentTouch&&r instanceof a.DocumentTouch)i=!0;else{var n=a.matchMedia&&matchMedia("(pointer:coarse)");n&&"(pointer:coarse)"===n.media&&(i=!!n.matches)}return(t&&!i&&"onmouseover"in a?"mouse":i&&"touch")||null}(n.interaction_inputType_mouse,n.interaction_inputType_touch)},e.initWithData=function(t){var e=this,i=e.config,n=e.scale,a=e.state,r=e.$el,s=e.org,o=a.hasAxis,l=i.interaction_enabled;o&&(e.axis=e.getAxisInstance(),i.zoom_enabled&&e.initZoom()),e.data.xs={},e.data.targets=e.convertDataToTargets(t),i.data_filter&&(e.data.targets=e.data.targets.filter(i.data_filter.bind(e.api))),i.data_hide&&e.addHiddenTargetIds(!0===i.data_hide?e.mapToIds(e.data.targets):i.data_hide),i.legend_hide&&e.addHiddenLegendIds(!0===i.legend_hide?e.mapToIds(e.data.targets):i.legend_hide),e.updateSizes(),e.updateScales(!0);var c=n.x,u=n.y,d=n.y2,h=n.subX,g=n.subY,f=n.subY2;if(c&&(c.domain(Z(e.getXDomain(e.data.targets))),h.domain(c.domain()),s.xDomain=c.domain()),u&&(u.domain(e.getYDomain(e.data.targets,"y")),g.domain(u.domain())),d&&(d.domain(e.getYDomain(e.data.targets,"y2")),f&&f.domain(d.domain())),r.svg=r.chart.append("svg").style("overflow","hidden").style("display","block"),l&&a.inputType){var p="touch"===a.inputType;r.svg.on(p?"touchstart":"mouseenter",(function(){return L(i.onover,e.api)})).on(p?"touchend":"mouseleave",(function(){return L(i.onout,e.api)}))}i.svg_classname&&r.svg.attr("class",i.svg_classname);var x=v(i.color_tiles)&&e.patterns;(o||x||i.data_labels_backgroundColors)&&(r.defs=r.svg.append("defs"),o&&["id","idXAxis","idYAxis","idGrid"].forEach((function(t){e.appendClip(r.defs,a.clip[t])})),e.generateDataLabelBackgroundColorFilter(),x&&e.patterns.forEach((function(t){return r.defs.append((function(){return t.node}))}))),e.updateSvgSize(),e.bindResize();var _,m=r.svg.append("g").classed(rt.main,!0).attr("transform",e.getTranslate("main"));(r.main=m,i.subchart_show&&e.initSubchart(),i.tooltip_show&&e.initTooltip(),i.title_text&&e.initTitle(),i.legend_show&&e.initLegend(),i.data_empty_label_text&&m.append("text").attr("class",kt.text+" "+rt.empty).attr("text-anchor","middle").attr("dominant-baseline","middle"),o&&(i.regions.length&&e.initRegion(),i.clipPath||e.axis.init()),m.append("g").attr("class",rt.chart).attr("clip-path",a.clip.path),e.callPluginHook("$init"),o)&&(l&&(null==e.initEventRect||e.initEventRect()),e.initGrid(),i.clipPath&&(null==(_=e.axis)||_.init()));if(e.initChartElements(),e.updateTargets(e.data.targets),e.updateDimension(),L(i.oninit,e.api),e.setBackground(),e.redraw({withTransition:!1,withTransform:!0,withUpdateXDomain:!0,withUpdateOrgXDomain:!0,withTransitionForAxis:!1,initializing:!0}),i.data_onmin||i.data_onmax){var y=e.getMinMaxData();L(i.data_onmin,e.api,y.min),L(i.data_onmax,e.api,y.max)}i.tooltip_show&&e.initShowTooltip(),a.rendered=!0},e.initChartElements=function(){var t=this,e=t.state,i=e.hasAxis,n=e.hasRadar,a=[];i?["bar","bubble","candlestick","line"].forEach((function(e){var i=G(e);("line"===e&&t.hasTypeOf(i)||t.hasType(e))&&a.push(i)})):(n||a.push("Arc","Pie"),t.hasType("gauge")?a.push("Gauge"):n&&a.push("Radar")),a.forEach((function(e){t["init"+e]()})),C(t.config.data_labels)&&!t.hasArcType(null,["radar"])&&t.initText()},e.setChartElements=function(){var t=this.$el,e=t.chart,i=t.svg,n=t.defs,a=t.main,r=t.tooltip,s=t.legend,o=t.title,l=t.grid,c=t.arcs,u=t.circle,d=t.bar,h=t.candlestick,g=t.line,f=t.area,p=t.text;this.api.$={chart:e,svg:i,defs:n,main:a,tooltip:r,legend:s,title:o,grid:l,arc:c,circles:u,bar:{bars:d},candlestick:h,line:{lines:g,areas:f},text:{texts:p}}},e.setBackground=function(){var t=this,e=t.config.background,i=t.state,n=t.$el.svg;if(C(e)){var a=n.select("g").insert(e.imgUrl?"image":"rect",":first-child");e.imgUrl?a.attr("href",e.imgUrl):e.color&&a.style("fill",e.color).attr("clip-path",i.clip.path),a.attr("class",e.class||null).attr("width","100%").attr("height","100%")}},e.updateTargets=function(t){var e=this,i=e.state,n=i.hasAxis,a=i.hasRadar;e.updateTargetsForText(t),n?(["bar","candlestick","line"].forEach((function(i){var n=G(i);("line"===i&&e.hasTypeOf(n)||e.hasType(i))&&e["updateTargetsFor"+n](t.filter(e["is"+n+"Type"].bind(e)))})),e.updateTargetsForSubchart&&e.updateTargetsForSubchart(t)):e.hasArcType(t)&&(a?e.updateTargetsForRadar(t.filter(e.isRadarType.bind(e))):e.updateTargetsForArc(t.filter(e.isArcType.bind(e)))),(e.hasType("bubble")||e.hasType("scatter"))&&(null==e.updateTargetForCircle||e.updateTargetForCircle()),e.showTargets()},e.showTargets=function(){var t=this,e=t.$el.svg;(0,t.$T)(e.selectAll("."+rt.target).filter((function(e){return t.isTargetToShow(e.id)}))).style("opacity",null)},e.getWithOption=function(t){var e={Dimension:!0,EventRect:!0,Legend:!1,Subchart:!0,Transform:!1,Transition:!0,TrimXDomain:!0,UpdateXAxis:"UpdateXDomain",UpdateXDomain:!1,UpdateOrgXDomain:!1,TransitionForExit:"Transition",TransitionForAxis:"Transition",Y:!0};return Object.keys(e).forEach((function(i){var n=e[i];x(n)&&(n=e[n]),e[i]=O(t,"with"+i,n)})),e},e.initialOpacity=function(t){var e=this.state.withoutFadeIn;return null!==this.getBaseValue(t)&&e[t.id]?null:"0"},e.bindResize=function(){var t,e,i,n=this,r=n.config,s=n.state,o=(e=[],(i=function(){i.clear(),t=Jt((function(){e.forEach((function(t){return t()}))}),200)}).clear=function(){t&&(Qt(t),t=null)},i.add=function(t){return e.push(t)},i.remove=function(t){return e.splice(e.indexOf(t),1)},i),l=[];l.push((function(){return L(r.onresize,n,n.api)})),r.resize_auto&&l.push((function(){s.resizing=!0,n.api.flush(!1)})),l.push((function(){L(r.onresized,n,n.api),s.resizing=!1})),l.forEach((function(t){return o.add(t)})),n.resizeFunction=o,a.addEventListener("resize",n.resizeFunction=o)},e.callPluginHook=function(t){for(var e=this,i=arguments.length,n=Array(i>1?i-1:0),a=1;a<i;a++)n[a-1]=arguments[a];this.config.plugins.forEach((function(i){"$beforeInit"===t&&(i.$$=e,e.api.plugins.push(i)),i[t].apply(i,n)}))},t}();function Re(t){var e,i,n,a=this.config,r=function(){var t=i.shift();return t&&e&&k(e)&&t in e?(e=e[t],r()):t?void 0:e};Object.keys(a).forEach((function(s){e=t,i=s.split("_"),n=r(),y(n)&&(a[s]=n)}))}Y(Ee.prototype,[ie,ne,ae,{categoryName:function(t){var e=this.config.axis_x_categories;return t<(null==e?void 0:e.length)?e[t]:t}},oe,ue,de,se,ge,fe,ve,_e,ye,be,Te,Ae,ke,Se,Ce]);var Oe={resize:function(t){var e=this.internal,i=e.config,n=e.state;n.rendered&&(i.size_width=t?t.width:null,i.size_height=t?t.height:null,n.resizing=!0,this.flush(!1),e.resizeFunction())},flush:function(t){var e=this.internal,i=e.state,n=e.$el.zoomResetBtn;if(i.rendered){var a,r,s;if(i.resizing)null==(r=e.brush)||r.updateResize();else null==(s=e.axis)||s.setOrient();null==(a=n)||a.style("display","none"),e.scale.zoom=null,t?e.redraw({withTransform:!0,withUpdateXDomain:!0,withUpdateOrgXDomain:!0,withLegend:!0}):e.updateAndRedraw({withLegend:!0,withTransition:!1,withTransitionForTransform:!1}),!i.resizing&&e.brush&&(e.brush.getSelection().call(e.brush.move),e.unselectRect())}else e.initToRender(!0)},destroy:function(){var t=this,e=this.internal,i=e.$el,n=i.chart,r=i.svg;if(C(e))for(var s in e.callPluginHook("$willDestroy"),e.charts.splice(e.charts.indexOf(this),1),e.unbindAllEvents(),r.select("*").interrupt(),e.resizeFunction.clear(),a.removeEventListener("resize",e.resizeFunction),n.classed("bb",!1).style("position",null).selectChildren().remove(),Object.keys(this).forEach((function(i){"internal"===i&&Object.keys(e).forEach((function(t){e[t]=null})),t[i]=null,delete t[i]})),this)this[s]=function(){};return null},config:function(t,e,i){var n,a=this.internal.config,r=null==t?void 0:t.replace(/\./g,"_");return r in a&&(y(e)?(a[r]=e,n=e,i&&this.flush()):n=a[r]),n}};function Le(t){var e=this.internal.data.targets;if(!m(t)){var i=E(t)?t:[t];return e.filter((function(t){return i.some((function(e){return e===t.id}))}))}return e}Y(Le,{shown:function(t){return this.internal.filterTargetsToShow(this.data(t))},values:function(t,e){void 0===e&&(e=!0);var i=null;if(t){var n=this.data(t);E(n)&&(i=[],n.forEach((function(t){var n=t.values.map((function(t){return t.value}));e?i=i.concat(n):i.push(n)})))}return i},names:function(t){return this.internal.updateDataAttributes("names",t)},colors:function(t){return this.internal.updateDataAttributes("colors",t)},axes:function(t){return this.internal.updateDataAttributes("axes",t)},min:function(){return this.internal.getMinMaxData().min},max:function(){return this.internal.getMinMaxData().max}});function De(t,e,i){var a,s,o=e||i,l=o.width,c=o.height,u=new XMLSerializer,d=t.cloneNode(!0),h=(a=j(r.styleSheets),s=[],a.forEach((function(t){try{t.cssRules&&t.cssRules.length&&(s=s.concat(j(t.cssRules)))}catch(e){console.error("Error while reading rules from "+t.href+": "+e.toString())}})),s).filter((function(t){return t.cssText})).map((function(t){return t.cssText}));d.setAttribute("xmlns",n.namespaces.xhtml);var g=u.serializeToString(d),f=r.createElement("style");f.appendChild(r.createTextNode(h.join("\n")));var p=u.serializeToString(f),v=('<svg xmlns="'+n.namespaces.svg+'" width="'+l+'" height="'+c+'" \n\t\tviewBox="0 0 '+i.width+" "+i.height+'" \n\t\tpreserveAspectRatio="'+(!1===(null==e?void 0:e.preserveAspectRatio)?"none":"xMinYMid meet")+'">\n\t\t\t<foreignObject width="100%" height="100%">\n\t\t\t\t'+p+"\n\t\t\t\t"+g.replace(/(url\()[^#]+/g,"$1")+"\n\t\t\t</foreignObject></svg>").replace("/\n/g","%0A");return"data:image/svg+xml;base64,"+btoa(encodeURIComponent(v).replace(/%([0-9A-F]{2})/g,(function(t,e){return String.fromCharCode(+("0x"+e))})))}var Ie={export:function(t,e){var i=this,n=this.internal,a=n.state,s=n.$el.chart,o=a.current,l=o.width,c=o.height,u=U({width:l,height:c,preserveAspectRatio:!0,mimeType:"image/png"},t),d=De(s.node(),u,{width:l,height:c});if(e&&v(e)){var h=new Image;h.crossOrigin="Anonymous",h.onload=function(){var t=r.createElement("canvas"),n=t.getContext("2d");t.width=u.width||l,t.height=u.height||c,n.drawImage(h,0,0),e.bind(i)(t.toDataURL(u.mimeType))},h.src=d}return d}};function Pe(t,e,i){var n=this,a=this.internal,r=a.mapToTargetIds(e),s=a.state.hiddenTargetIds.map((function(t){return r.indexOf(t)>-1&&t})).filter(Boolean);a.state.toggling=!0,a[(t?"remove":"add")+"HiddenTargetIds"](r);var o=a.$el.svg.selectAll(a.selectorTargets(r)),l=t?null:"0";t&&s.length&&(o.style("display",null),L(a.config.data_onshown,this,s)),a.$T(o).style("opacity",l,"important").call(D,(function(){t||0!==s.length||(o.style("display","none"),L(a.config.data_onhidden,n,r)),o.style("opacity",l)})),i.withLegend&&a[(t?"show":"hide")+"Legend"](r),a.redraw({withUpdateOrgXDomain:!0,withUpdateXDomain:!0,withLegend:!0}),a.state.toggling=!1}var ze={show:function(t,e){void 0===e&&(e={}),Pe.call(this,!0,t,e)},hide:function(t,e){void 0===e&&(e={}),Pe.call(this,!1,t,e)},toggle:function(t,e){var i=this;void 0===e&&(e={});var n=this.internal,a={show:[],hide:[]};n.mapToTargetIds(t).forEach((function(t){return a[n.isTargetToShow(t)?"hide":"show"].push(t)})),a.show.length&&this.show(a.show,e),a.hide.length&&setTimeout((function(){return i.hide(a.hide,e)}),0)}},Me={show:function(t){var e,i,n=this.internal,a=n.config,r=n.state.inputType;if(t.mouse&&(i=t.mouse),t.data){var s=t.data,o=n.getYScaleById(s.id)(s.value);n.isMultipleX()?i=[n.scale.x(s.x),o]:(a.tooltip_grouped||(i=[0,o]),e=g(s.index)?s.index:n.getIndexByX(s.x))}else y(t.x)?e=n.getIndexByX(t.x):y(t.index)&&(e=t.index);("mouse"===r?["mouseover","mousemove"]:["touchstart"]).forEach((function(t){n.dispatchEvent(t,e,i)}))},hide:function(){var t=this.internal,e=t.state.inputType,i=t.$el.tooltip,n=null==i?void 0:i.datum();if(n){var a=JSON.parse(n.current)[0].index;("mouse"===e?["mouseout"]:["touchend"]).forEach((function(e){t.dispatchEvent(e,a)}))}"touch"===e&&t.callOverOutForTouch(),t.hideTooltip(!0),t.hideGridFocus(),null==t.unexpandCircles||t.unexpandCircles(),t.expandBarTypeShapes(!1)}},Xe=function t(e){this.plugins=[],this.internal=void 0;var i=new Ee(this);this.internal=i,function t(e,i,n){Object.keys(e).forEach((function(a){var r=v(e[a]),s=i!==n,o=C(e[a]),l=o&&Object.keys(e[a]).length>0;i[a]=r&&(!s&&l||s)?e[a].bind(n):o&&!r?{}:e[a],l&&t(e[a],i[a],n)}))}(t.prototype,this,this),Re.call(i,e),i.beforeInit(),i.init()};function $e(t,e,i){var n=t.config,a="axis_y_"+e,r="axis_y2_"+e;y(i)&&(k(i)?(g(i.x)&&(n["axis_x_"+e]=i.x),g(i.y)&&(n[a]=i.y),g(i.y2)&&(n[r]=i.y2)):(n[a]=i,n[r]=i),t.redraw({withUpdateOrgXDomain:!0,withUpdateXDomain:!0}))}function Fe(t,e){var i=t.config;return{x:i["axis_x_"+e],y:i["axis_y_"+e],y2:i["axis_y2_"+e]}}Y(Xe.prototype,[Oe,{color:function(t){return this.internal.color(t)}},{data:Le},Ie,{focus:function(t){var e=this.internal,i=e.state,n=e.mapToTargetIds(t),a=e.$el.svg.selectAll(e.selectorTargets(n.filter(e.isTargetToShow,e)));this.revert(),this.defocus(),a.classed(_t.focused,!0).classed(_t.defocused,!1),e.hasArcType()&&!i.hasRadar&&(e.expandArc(n),e.hasType("gauge")&&e.markOverlapped(t,e,"."+ft.gaugeValue)),e.toggleFocusLegend(n,!0),i.focusedTargetIds=n,i.defocusedTargetIds=i.defocusedTargetIds.filter((function(t){return n.indexOf(t)<0}))},defocus:function(t){var e=this.internal,i=e.state,n=e.mapToTargetIds(t);e.$el.svg.selectAll(e.selectorTargets(n.filter(e.isTargetToShow,e))).classed(_t.focused,!1).classed(_t.defocused,!0),e.hasArcType()&&(e.unexpandArc(n),e.hasType("gauge")&&e.undoMarkOverlapped(e,"."+ft.gaugeValue)),e.toggleFocusLegend(n,!1),i.focusedTargetIds=i.focusedTargetIds.filter((function(t){return n.indexOf(t)<0})),i.defocusedTargetIds=n},revert:function(t){var e=this.internal,i=e.config,a=e.state,r=e.$el,s=e.mapToTargetIds(t);r.svg.selectAll(e.selectorTargets(s)).classed(_t.focused,!1).classed(_t.defocused,!1),e.hasArcType()&&e.unexpandArc(s),i.legend_show&&(e.showLegend(s.filter(e.isLegendToShow.bind(e))),r.legend.selectAll(e.selectorLegends(s)).filter((function(){return(0,n.select)(this).classed(_t.legendItemFocused)})).classed(_t.legendItemFocused,!1)),a.focusedTargetIds=[],a.defocusedTargetIds=[]}},{legend:{show:function(t){var e=this.internal;e.showLegend(e.mapToTargetIds(t)),e.updateAndRedraw({withLegend:!0})},hide:function(t){var e=this.internal;e.hideLegend(e.mapToTargetIds(t)),e.updateAndRedraw({withLegend:!0})}}},{load:function(t){var e=this.internal,i=e.config;t.xs&&e.addXs(t.xs),"names"in t&&this.data.names(t.names),"classes"in t&&Object.keys(t.classes).forEach((function(e){i.data_classes[e]=t.classes[e]})),"categories"in t&&e.axis.isCategorized()&&(i.axis_x_categories=t.categories),"axes"in t&&Object.keys(t.axes).forEach((function(e){i.data_axes[e]=t.axes[e]})),"colors"in t&&Object.keys(t.colors).forEach((function(e){i.data_colors[e]=t.colors[e]})),"unload"in t&&!1!==t.unload?e.unload(e.mapToTargetIds(!0===t.unload?null:t.unload),(function(){a.requestIdleCallback((function(){return e.loadFromArgs(t)}))})):e.loadFromArgs(t)},unload:function(t){var e=this,i=this.internal,n=t||{};E(n)?n={ids:n}:x(n)&&(n={ids:[n]});var a=i.mapToTargetIds(n.ids);i.unload(a,(function(){i.redraw({withUpdateOrgXDomain:!0,withUpdateXDomain:!0,withLegend:!0}),i.cache.remove(a),n.done&&n.done.call(e)}))}},ze,{tooltip:Me}]);var Be={labels:function(t){var e,i=this.internal;return t&&(Object.keys(t).forEach((function(e){i.axis.setLabelText(e,t[e])})),i.axis.updateLabels()),["x","y","y2"].forEach((function(t){var n=i.axis.getLabelText(t);n&&(e||(e={}),e[t]=n)})),e},min:function(t){var e=this.internal;return g(t)?$e(e,"min",t):Fe(e,"min")},max:function(t){var e=this.internal;return arguments.length?$e(e,"max",t):Fe(e,"max")},range:function(t){var e=this.axis;if(!arguments.length)return{max:e.max(),min:e.min()};y(t.max)&&e.max(t.max),y(t.min)&&e.min(t.min)}},Ne={axis:Be};function Ye(t){var e=this.internal,i=e.config;return t?(i.grid_x_lines=t,e.redrawWithoutRescale(),i.grid_x_lines):i.grid_x_lines}Y(Ye,{add:function(t){return this.xgrids(this.internal.config.grid_x_lines.concat(t||[]))},remove:function(t){this.internal.removeGridLines(t,!0)}});var Ge={xgrids:Ye};function je(t){var e=this.internal,i=e.config;return t?(i.grid_y_lines=t,e.redrawWithoutRescale(),i.grid_y_lines):i.grid_y_lines}Y(je,{add:function(t){return this.ygrids(this.internal.config.grid_y_lines.concat(t||[]))},remove:function(t){this.internal.removeGridLines(t,!1)}});var Ve={ygrids:je},He={groups:function(t){var e=this.internal,i=e.config;return m(t)||(i.data_groups=t,e.redraw()),i.data_groups}};function We(t){var e=this.internal,i=e.config;return t?(i.regions=t,e.redrawWithoutRescale(),t):i.regions}Y(We,{add:function(t){var e=this.internal,i=e.config;return t?(i.regions=i.regions.concat(t),e.redrawWithoutRescale(),i.regions):i.regions},remove:function(t){var e=this.internal,i=e.config,n=e.$T,a=t||{},r=O(a,"classes",[bt.region]),s=e.$el.main.select("."+bt.regions).selectAll(r.map((function(t){return"."+t})));return n(s).style("opacity","0").remove(),s=i.regions,Object.keys(a).length?(s=s.filter((function(t){var e=!1;return!t.class||(t.class.split(" ").forEach((function(t){r.indexOf(t)>=0&&(e=!0)})),!e)})),i.regions=s):i.regions=[],s}});var Ue={regions:We},Ze={x:function(t){var e=this.internal,i=e.axis,n=e.data,a=i.isCustomX()&&i.isCategorized();return E(t)&&(a?this.categories(t):(e.updateTargetX(n.targets,t),e.redraw({withUpdateOrgXDomain:!0,withUpdateXDomain:!0}))),a?this.categories():n.xs},xs:function(t){var e=this.internal;return R(t)&&(e.updateTargetXs(e.data.targets,t),e.redraw({withUpdateOrgXDomain:!0,withUpdateXDomain:!0})),e.data.xs}},qe={flow:function(t){var e,i,n,a,r=this.internal,s=0,o=0;if((t.json||t.rows||t.columns)&&(e=r.convertData(t)),!r.state.redrawing&&e&&et()){var l=[],c=r.getMaxDataCount(),u=r.convertDataToTargets(e,!0),d=r.axis.isTimeSeries();r.data.targets.forEach((function(t){for(var e=!1,i=0;i<u.length;i++)if(t.id===u[i].id){e=!0,t.values[t.values.length-1]&&(o=t.values[t.values.length-1].index+1),s=u[i].values.length;for(var n=0;n<s;n++)u[i].values[n].index=o+n,d||(u[i].values[n].x=o+n);t.values=t.values.concat(u[i].values),u.splice(i,1);break}e||l.push(t.id)})),r.data.targets.forEach((function(t){for(var e=0;e<l.length;e++)if(t.id===l[e]){o=t.values[t.values.length-1].index+1;for(var i=0;i<s;i++)t.values.push({id:t.id,index:o+i,x:d?r.getOtherTargetX(o+i):o+i,value:null})}})),r.data.targets.length&&u.forEach((function(t){for(var e=[],i=r.data.targets[0].values[0].index;i<o;i++)e.push({id:t.id,index:i,x:d?r.getOtherTargetX(i):i,value:null});t.values.forEach((function(t){t.index+=o,d||(t.x+=o)})),t.values=e.concat(t.values)})),r.data.targets=r.data.targets.concat(u);var h=r.data.targets[0],f=h.values[0];y(t.to)?(s=0,a=d?tt.call(r,t.to):t.to,h.values.forEach((function(t){t.x<a&&s++}))):y(t.length)&&(s=t.length),c?1===c&&d&&(n=(h.values[h.values.length-1].x-f.x)/2,i=[new Date(+f.x-n),new Date(+f.x+n)]):(n=d?h.values.length>1?h.values[h.values.length-1].x-f.x:f.x-r.getXDomain(r.data.targets)[0]:1,i=[f.x-n,f.x]),i&&r.updateXDomain(null,!0,!0,!1,i),r.updateTargets(r.data.targets),r.redraw({flow:{index:f.index,length:s,duration:g(t.duration)?t.duration:r.config.transition_duration,done:t.done,orgDataCount:c},withLegend:!0,withTransition:c>1,withTrimXDomain:!1,withUpdateXAxis:!0})}}},Ke=f(10),Je=function(){function t(t){this.owner=void 0,this.config=void 0,this.scale=void 0;var e=xe(),i=t.config,n=t.params;this.owner=t,this.config=i,this.scale=e,!i.noTransition&&n.config.transition_duration||(i.withoutTransition=!0),i.range=this.scaleExtent((n.orgXScale||e).range())}t.getSizeFor1Char=function(t){var e={w:5.5,h:11.5};return t.empty()||t.select("text").text("0").call((function(t){try{var i=t.node().getBBox(),n=i.width,a=i.height;n&&a&&(e.w=n,e.h=a)}catch(t){}finally{t.text("")}})),this.getSizeFor1Char=function(){return e},e};var e=t.prototype;return e.getTickTransformSetter=function(t){var e=this.config,i="x"===t?function(t){return"translate("+(t+e.tickOffset)+",0)"}:function(t){return"translate(0,"+t+")"};return function(t,e){t.attr("transform",(function(t){return i(Math.ceil(e(t)))}))}},e.scaleExtent=function(t){var e=t[0],i=t[t.length-1];return e<i?[e,i]:[i,e]},e.generateTicks=function(t,e){var i=this.owner.params.tickStepSize,n=t.domain(),a=n[0],r=n[1],s=[];if(e&&i)for(var o=Math.round(a);o<=r;)s.push(o),o+=i;else if(t.ticks){var l=this.config.tickArguments;if("log"!==t.type||l)s=t.ticks.apply(t,this.config.tickArguments||[]);else{var c=xe("_log").domain([a>0?a:1,r]).range(t.range());s=c.ticks();for(var u=r.toFixed().length;s.length>15;u--)s=c.ticks(u);s.splice(0,1,a),s.splice(s.length-1,1,r)}s=s.map((function(t){return x(t)&&_(t)&&!isNaN(t)&&Math.round(10*t)/10||t}))}else{for(var d=Math.ceil(a);d<r;d++)s.push(d);s.length>0&&s[0]>0&&s.unshift(s[0]-(s[1]-s[0]))}return s},e.copyScale=function(){var t=this.scale.copy();return t.domain().length||t.domain(this.scale.domain()),t.type=this.scale.type,t},e.textFormatted=function(t){var e=this.config.tickFormat,i=/\d+\.\d+0{5,}\d$/.test(t)?+(t+"").replace(/0+\d$/,""):t,n=e?e(i):i;return y(n)?n:""},e.transitionise=function(t){var e=this.config,i=t;if(e.withoutTransition)i=t.interrupt();else if(e.transition||!this.owner.params.noTransition)try{i=t.transition(e.transition)}catch(t){}return i},t}(),Qe=function(){function t(t){void 0===t&&(t={}),this.helper=void 0,this.config=void 0,this.params=void 0,this.g=void 0;var e={innerTickSize:6,outerTickSize:t.outerTick?6:0,orient:"bottom",range:[],tickArguments:null,tickCentered:null,tickCulling:!0,tickFormat:null,tickLength:9,tickOffset:0,tickPadding:3,tickValues:null,transition:null,noTransition:t.noTransition};e.tickLength=Math.max(e.innerTickSize,0)+e.tickPadding,this.config=e,this.params=t,this.helper=new Je(this)}var e=t.prototype;return e.create=function(t){var e=this,i=this.config,a=this.helper,r=this.params,s=a.scale,o=i.orient,l=this.splitTickText.bind(this),c=/^(left|right)$/.test(o),u=/^(top|bottom)$/.test(o),d=a.getTickTransformSetter(u?"x":"y"),h=d===a.axisX?"y":"x",g=/^(top|left)$/.test(o)?-1:1,f=r.tickTextRotate;this.config.range=s.rangeExtent?s.rangeExtent():a.scaleExtent((r.orgXScale||s).range());var p,v=i,x=v.innerTickSize,m=v.tickLength,y=v.range,b=r.id,T=b&&/^(x|y|y2)$/.test(b)?r.config["axis_"+b+"_tick_text_position"]:{x:0,y:0},w="subX"===b?"subchart_axis_x":"axis_"+b,A=r.config[w+"_show"],k=!!A&&r.config[w+"_tick_show"],S=!!A&&r.config[w+"_tick_text_show"];t.each((function(){var t=(0,n.select)(this),v=this.__chart__||s,b=a.copyScale();p=t,this.__chart__=b,i.tickOffset=r.isCategory?Math.ceil((b(1)-b(0))/2):0;var w=t.selectAll(".domain").data([0]);if(w.enter().append("path").attr("class","domain").merge(w).attr("d",(function(){var t=i.outerTickSize*g;return u?"M"+y[0]+","+t+"V0H"+y[1]+"V"+t:"M"+t+","+y[0]+"H0V"+y[1]+"H"+t})),k||S){var A=i.tickValues||a.generateTicks(b,c),C=t.selectAll(".tick").data(A,b),R=C.enter().insert("g",".domain").attr("class","tick"),O=C.exit().remove();C=R.merge(C),k&&R.append("line"),S&&R.append("text");var L=Je.getSizeFor1Char(C),D=[],I=C.select("text").selectAll("tspan").data((function(t,e){var i=r.tickMultiline?l(t,b,A,c,L.w):E(a.textFormatted(t))?a.textFormatted(t).concat():[a.textFormatted(t)];return D[e]=i.length,i.map((function(t){return{index:e,splitted:t}}))}));I.exit().remove(),(I=I.enter().append("tspan").merge(I).text((function(t){return t.splitted}))).attr("x",u?0:m*g).attr("dx",function(){var t=0;return/(top|bottom)/.test(o)&&f&&(t=8*Math.sin(Math.PI*(f/180))*("top"===o?-1:1)),t+(T.x||0)}()).attr("dy",(function(t,e){var i=0;return"top"!==o&&(i=L.h,0===e&&(i=c?-((D[t.index]-1)*(L.h/2)-3):0===T.y?".71em":0)),_(i)&&T.y?i+T.y:i||".71em"}));var P=C.select("line"),z=C.select("text");if(R.select("line").attr(h+"2",x*g),R.select("text").attr(h,m*g),e.setTickLineTextPosition(P,z),r.tickTitle){var M=z.select("title");(M.empty()?z.append("title"):M).text((function(t){return r.tickTitle[t]}))}if(b.bandwidth){var X=b,$=X.bandwidth()/2;b=v=function(t){return X(t)+$}}else v.bandwidth?v=b:d(O,b);C=r.owner.state.flowing?a.transitionise(C):r.owner.$T(C),d(R,v),d(C.style("opacity",null),b)}})),this.g=p},e.getTickXY=function(){var t=this.config,e={x:0,y:0};return this.params.isCategory&&(e.x=t.tickCentered?0:t.tickOffset,e.y=t.tickCentered?t.tickOffset:0),e},e.getTickSize=function(t){var e=this.helper.scale,i=this.config,n=i,a=n.innerTickSize,r=n.range,s=e(t)+(i.tickCentered?0:i.tickOffset);return r[0]<s&&s<r[1]?a:0},e.setTickLineTextPosition=function(t,e){var i=this.getTickXY(),n=this.config,a=n.innerTickSize,r=n.orient,s=n.tickLength,o=n.tickOffset,l=this.params.tickTextRotate,c=function(t){var e=["start","end"];return"top"===r&&e.reverse(),t?e[t>0?0:1]:"middle"},u=function(t){return t?"rotate("+t+")":null},d=function(t){return t?11.5-2.5*(t/("bottom"===r?15:23))*(t>0?1:-1):s};switch(r){case"bottom":t.attr("x1",i.x).attr("x2",i.x).attr("y2",this.getTickSize.bind(this)),e.attr("x",0).attr("y",d(l)).style("text-anchor",c(l)).attr("transform",u(l));break;case"top":t.attr("x2",0).attr("y2",-a),e.attr("x",0).attr("y",2*-d(l)).style("text-anchor",c(l)).attr("transform",u(l));break;case"left":t.attr("x2",-a).attr("y1",i.y).attr("y2",i.y),e.attr("x",-s).attr("y",o).style("text-anchor","end");break;case"right":t.attr("x2",a).attr("y2",0),e.attr("x",s).attr("y",0).style("text-anchor","start")}},e.splitTickText=function(t,e,i,n,a){var r=this.params,s=this.helper.textFormatted(t),o=x(s)&&s.indexOf("\n")>-1?s.split("\n"):[];if(o.length)return o;if(E(s))return s;var l=r.tickWidth;return(!l||l<=0)&&(l=n?95:r.isCategory?Math.ceil(e(i[1])-e(i[0]))-12:110),function t(e,i){for(var n,r,s,o=1;o<i.length;o++)if(" "===i.charAt(o)&&(r=o),n=i.substr(0,o+1),s=a*n.length,l<s)return t(e.concat(i.substr(0,r||o)),i.slice(r?r+1:o));return e.concat(i)}(o,s+"")},e.scale=function(t){return arguments.length?(this.helper.scale=t,this):this.helper.scale},e.orient=function(t){return arguments.length?(this.config.orient=t in{top:1,right:1,bottom:1,left:1}?t+"":"bottom",this):this.config.orient},e.tickFormat=function(t){var e=this.config;return arguments.length?(e.tickFormat=t,this):e.tickFormat},e.tickCentered=function(t){var e=this.config;return arguments.length?(e.tickCentered=t,this):e.tickCentered},e.tickOffset=function(){return this.config.tickOffset},e.tickInterval=function(t){var e,i=this,n=this.config,a=n.outerTickSize,r=n.tickOffset,s=n.tickValues;if(this.params.isCategory)e=2*r;else{e=(this.g.select("path.domain").node().getTotalLength()-2*a)/(t||this.g.selectAll("line").size());var o=s?s.map((function(t,e,n){var a=e+1;return a<n.length?i.helper.scale(n[a])-i.helper.scale(t):null})).filter(Boolean):[];e=Math.min.apply(Math,o.concat([e]))}return e===1/0?0:e},e.ticks=function(){for(var t=this.config,e=arguments.length,i=Array(e),n=0;n<e;n++)i[n]=arguments[n];return i.length?(t.tickArguments=j(i),this):t.tickArguments},e.tickCulling=function(t){var e=this.config;return arguments.length?(e.tickCulling=t,this):e.tickCulling},e.tickValues=function(t){var e=this,i=this.config;if(v(t))i.tickValues=function(){return t(e.helper.scale.domain())};else{if(!arguments.length)return i.tickValues;i.tickValues=t}return this},e.setTransition=function(t){return this.config.transition=t,this},t}(),ti={getAxisInstance:function(){return this.axis||new ei(this)}},ei=function(){function t(t){this.owner=void 0,this.x=void 0,this.subX=void 0,this.y=void 0,this.y2=void 0,this.axesList={},this.tick={x:null,y:null,y2:null},this.xs=[],this.orient={x:"bottom",y:"left",y2:"right",subX:"bottom"},this.owner=t,this.setOrient()}var e=t.prototype;return e.getAxisClassName=function(t){return lt.axis+" "+lt["axis"+G(t)]},e.isHorizontal=function(t,e){var i=t.config.axis_rotated;return e?i:!i},e.isCategorized=function(){var t=this.owner,e=t.config,i=t.state;return e.axis_x_type.indexOf("category")>=0||i.hasRadar},e.isCustomX=function(){var t=this.owner.config;return!this.isTimeSeries()&&(t.data_x||C(t.data_xs))},e.isTimeSeries=function(t){return void 0===t&&(t="x"),"timeseries"===this.owner.config["axis_"+t+"_type"]},e.isLog=function(t){return void 0===t&&(t="x"),"log"===this.owner.config["axis_"+t+"_type"]},e.isTimeSeriesY=function(){return this.isTimeSeries("y")},e.getAxisType=function(t){void 0===t&&(t="x");var e="linear";return this.isTimeSeries(t)?e=this.owner.config.axis_x_localtime?"time":"utc":this.isLog(t)&&(e="log"),e},e.init=function(){var t=this,e=this.owner,i=e.config,n=e.$el,a=n.main,r=n.axis,s=e.state.clip,o=i.axis_rotated,l=["x","y"];i.axis_y2_show&&l.push("y2"),l.forEach((function(n){var l=t.getAxisClassName(n),c=lt["axis"+n.toUpperCase()+"Label"];r[n]=a.append("g").attr("class",l).attr("clip-path",(function(){var t=null;return"x"===n?t=s.pathXAxis:"y"===n&&(t=s.pathYAxis),t})).attr("transform",e.getTranslate(n)).style("visibility",i["axis_"+n+"_show"]?null:"hidden"),r[n].append("text").attr("class",c).attr("transform",["rotate(-90)",null]["x"===n?+!o:+o]).style("text-anchor",(function(){return t.textAnchorForAxisLabel(n)})),t.generateAxes(n)}))},e.setOrient=function(){var t=this.owner.config,e=t.axis_rotated,i=t.axis_y_inner,n=t.axis_y2_inner;this.orient={x:e?"left":"bottom",y:e?i?"top":"bottom":i?"right":"left",y2:e?n?"bottom":"top":n?"left":"right",subX:e?"left":"bottom"}},e.generateAxes=function(t){var e,i=this.owner,n=i.config,a=[],r=n["axis_"+t+"_axes"],s=n.axis_rotated;"x"===t?e=s?Ke.axisLeft:Ke.axisBottom:"y"===t?e=s?Ke.axisBottom:Ke.axisLeft:"y2"===t&&(e=s?Ke.axisTop:Ke.axisRight),r.length&&r.forEach((function(n){var r=n.tick||{},s=i.scale[t].copy();n.domain&&s.domain(n.domain),a.push(e(s).ticks(r.count).tickFormat(v(r.format)?r.format.bind(i.api):function(t){return t}).tickValues(r.values).tickSizeOuter(!1===r.outer?0:6))})),this.axesList[t]=a},e.updateAxes=function(){var t=this,e=this.owner,i=e.config,n=e.$el.main,a=e.$T;Object.keys(this.axesList).forEach((function(r){var s=i["axis_"+r+"_axes"],o=e.scale[r].copy(),l=o.range();t.axesList[r].forEach((function(c,u){var d=c.scale().range();l.every((function(t,e){return t===d[e]}))||c.scale().range(l);var h=t.getAxisClassName(r)+"-"+(u+1),g=n.select("."+h.replace(/\s/,"."));g.empty()?g=n.append("g").attr("class",h).style("visibility",i["axis_"+r+"_show"]?null:"hidden").call(c):(s[u].domain&&o.domain(s[u].domain),a(g).call(c.scale(o))),g.attr("transform",e.getTranslate(r,u+1))}))}))},e.setAxis=function(t,e,i,n){var a=this.owner;"subX"!==t&&(this.tick[t]=this.getTickValues(t)),this[t]=this.getAxis(t,e,i,!("x"!==t||!(a.scale.zoom||a.config.subchart_show||a.state.resizing))||n)},e.getAxis=function(t,e,i,n,a){var r,s=this.owner,o=s.config,l=/^(x|subX)$/.test(t),c=l?"x":t,u=l&&this.isCategorized(),d=this.orient[t],h=a?0:s.getAxisTickRotate(c);if(l)r="subX"===t?s.format.subXAxisTick:s.format.xAxisTick;else{var g=o["axis_"+t+"_tick_format"];v(g)&&(r=g.bind(s.api))}var f=this.tick[c],p=U({outerTick:i,noTransition:n,config:o,id:t,tickTextRotate:h,owner:s},l&&{isCategory:u,tickMultiline:o.axis_x_tick_multiline,tickWidth:o.axis_x_tick_width,tickTitle:u&&o.axis_x_tick_tooltip&&s.api.categories(),orgXScale:s.scale.x});l||(p.tickStepSize=o["axis_"+c+"_tick_stepSize"]);var x=new Qe(p).scale(l&&s.scale.zoom||e).orient(d);if(l&&this.isTimeSeries()&&f&&!v(f)){var _=tt.bind(s);f=f.map((function(t){return _(t)}))}else!l&&this.isTimeSeriesY()&&(x.ticks(o.axis_y_tick_time_value),f=null);f&&x.tickValues(f),x.tickFormat(r||!l&&s.isStackNormalized()&&function(t){return t+"%"}),u&&(x.tickCentered(o.axis_x_tick_centered),S(o.axis_x_tick_culling)&&(o.axis_x_tick_culling=!1));var m=o["axis_"+c+"_tick_count"];return m&&x.ticks(m),x},e.updateXAxisTickValues=function(t,e){var i,n=this.owner,a=n.config,r=a.axis_x_tick_fit,s=a.axis_x_tick_count;if((r||s&&r)&&(i=n.mapTargetsToUniqueXs(t),this.isCategorized()&&s>i.length&&(s=i.length),i=this.generateTickValues(i,s,this.isTimeSeries())),e)e.tickValues(i);else if(this.x){var o;this.x.tickValues(i),null==(o=this.subX)||o.tickValues(i)}return i},e.getId=function(t){var e=this.owner,i=e.config,n=e.scale,a=i.data_axes[t];return a&&n[a]||(a="y"),a},e.getXAxisTickFormat=function(t){var e,i=this.owner,n=i.config,a=i.format,r=t&&n.subchart_axis_x_tick_format||n.axis_x_tick_format,s=this.isTimeSeries(),o=this.isCategorized();return r?v(r)?e=r.bind(i.api):s&&(e=function(t){return t?a.axisTime(r)(t):""}):e=s?a.defaultAxisTime:o?i.categoryName:function(t){return t<0?t.toFixed(0):t},v(e)?function(t){return e.apply(i,o?[t,i.categoryName(t)]:[t])}:e},e.getTickValues=function(t){var e=this.owner,i=e.config["axis_"+t+"_tick_values"],n=e[t+"Axis"];return(v(i)?i.call(e.api):i)||(n?n.tickValues():void 0)},e.getLabelOptionByAxisId=function(t){return this.owner.config["axis_"+t+"_label"]},e.getLabelText=function(t){var e=this.getLabelOptionByAxisId(t);return x(e)?e:e?e.text:null},e.setLabelText=function(t,e){var i=this.owner.config,n=this.getLabelOptionByAxisId(t);x(n)?i["axis_"+t+"_label"]=e:n&&(n.text=e)},e.getLabelPosition=function(t,e){var i=this.owner.config.axis_rotated,n=this.getLabelOptionByAxisId(t),a=k(n)&&n.position?n.position:e[+!i],r=function(t){return!!~a.indexOf(t)};return{isInner:r("inner"),isOuter:r("outer"),isLeft:r("left"),isCenter:r("center"),isRight:r("right"),isTop:r("top"),isMiddle:r("middle"),isBottom:r("bottom")}},e.getAxisLabelPosition=function(t){return this.getLabelPosition(t,"x"===t?["inner-top","inner-right"]:["inner-right","inner-top"])},e.getLabelPositionById=function(t){return this.getAxisLabelPosition(t)},e.xForAxisLabel=function(t){var e=this.owner,i=e.state,n=i.width,a=i.height,r=this.getAxisLabelPosition(t),s=r.isMiddle?-a/2:0;return this.isHorizontal(e,"x"!==t)?s=r.isLeft?0:r.isCenter?n/2:n:r.isBottom&&(s=-a),s},e.dxForAxisLabel=function(t){var e=this.owner,i=this.getAxisLabelPosition(t),n=i.isBottom?"0.5em":"0";return this.isHorizontal(e,"x"!==t)?n=i.isLeft?"0.5em":i.isRight?"-0.5em":"0":i.isTop&&(n="-0.5em"),n},e.textAnchorForAxisLabel=function(t){var e=this.owner,i=this.getAxisLabelPosition(t),n=i.isMiddle?"middle":"end";return this.isHorizontal(e,"x"!==t)?n=i.isLeft?"start":i.isCenter?"middle":"end":i.isBottom&&(n="start"),n},e.dyForAxisLabel=function(t){var e,i=this.owner,n=i.config,a=n.axis_rotated,r=this.getAxisLabelPosition(t).isInner,s=n["axis_"+t+"_tick_rotate"]?i.getHorizontalAxisHeight(t):0,o=this.getMaxTickWidth(t);if("x"===t){var l=n.axis_x_height;e=a?r?"1.2em":-25-o:r?"-0.5em":l?l-10:s?s-10:"3em"}else e={y:["-0.5em",10,"3em","1.2em",10],y2:["1.2em",-20,"-2.2em","-0.5em",15]}[t],e=a?r?e[0]:s?s*("y2"===t?-1:1)-e[1]:e[2]:r?e[3]:(e[4]+(n["axis_"+t+"_inner"]?0:o+e[4]))*("y"===t?-1:1);return e},e.getMaxTickWidth=function(t,e){var i=this.owner,n=i.config,a=i.state.current,r=i.$el,s=r.svg,o=r.chart,l=a.maxTickWidths[t],c=0;if(e||!n["axis_"+t+"_show"]||0===i.filterTargetsToShow().length)return l.size;if(s){var u=/^y2?$/.test(t),d=i.filterTargetsToShow(i.data.targets),h=i.scale[t].copy().domain(i["get"+(u?"Y":"X")+"Domain"](d,t)),g=h.domain(),f=g[0]===g[1]&&g.every((function(t){return t>0})),p=E(l.domain)&&l.domain[0]===l.domain[1]&&l.domain.every((function(t){return t>0}));if(f||p)return l.size;l.domain=g,u||l.ticks.splice(0);var v=this.getAxis(t,h,!1,!1,!0),x=n["axis_"+t+"_tick_count"];!n["axis_"+t+"_tick_values"]&&x&&v.tickValues(this.generateTickValues(g,x,u?this.isTimeSeriesY():this.isTimeSeries())),u||this.updateXAxisTickValues(d,v);var _=o.append("svg").style("visibility","hidden").style("position","fixed").style("top","0").style("left","0");v.create(_),_.selectAll("text").each((function(t,e){var i=this.getBoundingClientRect().width;c=Math.max(c,i),u||(l.ticks[e]=i)})),_.remove()}return c>0&&(l.size=c),l.size},e.getXAxisTickTextY2Overflow=function(t){var e=this.owner,i=e.axis,n=e.config,a=e.state,r=e.getAxisTickRotate("x");if((i.isCategorized()||i.isTimeSeries())&&n.axis_x_tick_fit&&!n.axis_x_tick_culling&&!n.axis_x_tick_multiline&&r>0&&r<90){var s=a.current.width-e.getCurrentPaddingLeft(),o=this.getXAxisTickMaxOverflow(r,s-t),l=Math.max(0,o)+t;return Math.min(l,s/2)}return 0},e.getXAxisTickMaxOverflow=function(t,e){for(var i=this.owner,n=i.axis,a=i.config,r=i.state,s=n.isTimeSeries(),o=r.current.maxTickWidths.x.ticks,l=o.length,c=r.axis.x.padding,u=c.left,d=c.right,h=0,g=l-(s&&a.axis_x_tick_fit?.5:0),f=0;f<l;f++){var p=f+1,v=Math.cos(Math.PI*t/180)*o[f],x=p-(s?1:.5)+u;if(!(x<=0)){var _=(e-v)/x;h=Math.max(h,v-_/2-((g-p)*_+d*_))}}var m=i.filterTargetsToShow(i.data.targets),y=0;if(!s&&a.axis_x_tick_count<=m.length&&m[0].values.length){var b=xe(i.axis.getAxisType("x"),0,e-h).domain([-1*u,i.getXDomainMax(i.data.targets)+1+d]);y=Math.ceil((b(1)-b(0))/2)}return h+y},e.updateLabels=function(t){var e=this,i=this.owner,n=i.$el.main,a=i.$T,r={x:n.select("."+lt.axisX+" ."+lt.axisXLabel),y:n.select("."+lt.axisY+" ."+lt.axisYLabel),y2:n.select("."+lt.axisY2+" ."+lt.axisY2Label)};Object.keys(r).filter((function(t){return!r[t].empty()})).forEach((function(i){var n=r[i];a(n,t).attr("x",(function(){return e.xForAxisLabel(i)})).attr("dx",(function(){return e.dxForAxisLabel(i)})).attr("dy",(function(){return e.dyForAxisLabel(i)})).text((function(){return e.getLabelText(i)}))}))},e.getPadding=function(t,e,i,n){var a=_(t)?t:t[e];return g(a)?this.owner.convertPixelToScale(/(bottom|top)/.test(e)?"y":"x",a,n):i},e.generateTickValues=function(t,e,i){var n=t;if(e){var a=v(e)?e():e;if(1===a)n=[t[0]];else if(2===a)n=[t[0],t[t.length-1]];else if(a>2){var r,s=this.isCategorized(),o=a-2,l=t[0],c=t[t.length-1];n=[l];for(var u=0;u<o;u++)r=+l+(c-l)/(o+1)*(u+1),n.push(i?new Date(r):s?Math.round(r):r);n.push(c)}}return i||(n=n.sort((function(t,e){return t-e}))),n},e.generateTransitions=function(t){var e=this.owner,i=e.$el.axis,n=e.$T,a=["x","y","y2","subX"].map((function(e){return n(i[e],t)}));return{axisX:a[0],axisY:a[1],axisY2:a[2],axisSubX:a[3]}},e.redraw=function(t,e,i){var n=this,a=this.owner,r=a.config,s=a.$el,o=e?"0":null;["x","y","y2","subX"].forEach((function(e){var a=n[e],l=s.axis[e];a&&l&&(i||r.transition_duration||(a.config.withoutTransition=!0),l.style("opacity",o),a.create(t["axis"+G(e)]))})),this.updateAxes()},e.redrawAxis=function(t,e,i,n,a){var r,s,o,l=this,c=this.owner,u=c.config,d=c.scale,h=c.$el,g=!!d.zoom;if(!g&&this.isCategorized()&&0===t.length&&d.x.domain([0,h.axis.x.selectAll(".tick").size()]),d.x&&t.length)g||c.updateXDomain(t,e.UpdateXDomain,e.UpdateOrgXDomain,e.TrimXDomain),u.axis_x_tick_values||this.updateXAxisTickValues(t);else if(this.x){var f;this.x.tickValues([]),null==(f=this.subX)||f.tickValues([])}(u.zoom_rescale&&!n&&(r=d.x.orgDomain()),["y","y2"].forEach((function(e){var i="axis_"+e+"_",n=d[e];if(u[i+"show"]&&n){var a=u[i+"tick_values"],s=u[i+"tick_count"];if(n.domain(c.getYDomain(t,e,r)),!a&&s){var o=c.axis[e],h=n.domain();o.tickValues(l.generateTickValues(h,h.every((function(t){return 0===t}))?1:s,l.isTimeSeriesY()))}}})),this.redraw(i,c.hasArcType(),a),this.updateLabels(e.Transition),(e.UpdateXDomain||e.UpdateXAxis||e.Y)&&t.length&&this.setCulling(),e.Y)&&(null==(s=d.subY)||s.domain(c.getYDomain(t,"y")),null==(o=d.subY2)||o.domain(c.getYDomain(t,"y2")))},e.setCulling=function(){var t=this.owner,e=t.config,i=t.state,n=i.clip,a=i.current,r=t.$el;["subX","x","y","y2"].forEach((function(t){var i=r.axis[t],s="axis_"+("subX"===t?"x":t)+"_tick_culling",o=e[s];if(i&&o){var l,c=i.selectAll(".tick"),u=Z(c.data()),d=u.length,h=e[s+"_max"],g=e[s+"_lines"];if(d){for(var f=1;f<d;f++)if(d/f<h){l=f;break}c.each((function(t){if(u.indexOf(t)%l){var e=g?this.querySelector("text"):this;e&&(e.style.display="none")}}))}else c.style("display",null);if("x"===t){var p=a.maxTickWidths.x.clipPath?n.pathXAxisTickTexts:null;r.svg.selectAll("."+lt.axisX+" .tick text").attr("clip-path",p)}}}))},t}(),ii={initEventRect:function(){this.$el.main.select("."+rt.chart).append("g").attr("class",xt.eventRects).style("fill-opacity","0")},redrawEventRect:function(){var t=this,e=t.config,i=t.state,n=t.$el,a=t.isMultipleX();if(n.eventRect)t.updateEventRect(n.eventRect,!0);else{var r=t.$el.main.select("."+xt.eventRects).style("cursor",e.zoom_enabled&&"drag"!==e.zoom_type?e.axis_rotated?"ns-resize":"ew-resize":null).classed(xt.eventRectsMultiple,a).classed(xt.eventRectsSingle,!a).selectAll("."+xt.eventRect).data([0]).enter().append("rect");t.updateEventRect(r),a?t.generateEventRectsForMultipleXs(r):t.generateEventRectsForSingleX(r),r.call(t.getDraggableSelection()),n.eventRect=r,"touch"!==t.state.inputType||n.svg.on("touchstart.eventRect")||t.hasArcType()||t.bindTouchOnEventRect(a)}if(!a){var s=t.getMaxDataCountTarget();t.updateDataIndexByX(s),t.updateXs(s),null==t.updatePointClass||t.updatePointClass(!0),i.eventReceiver.data=s}t.updateEventRectData()},bindTouchOnEventRect:function(t){var e,i=this,n=i.config,a=i.state,r=i.$el,s=r.eventRect,o=r.svg,l=function(){i.unselectRect(),i.callOverOutForTouch()},c=n.interaction_inputType_touch.preventDefault,u=b(c)&&c||!1,d=!isNaN(c)&&c||null;s.on("touchstart",(function(t){a.event=t,i.updateEventRect()})).on("touchstart.eventRect touchmove.eventRect",(function(r){if(a.event=r,!s.empty()&&s.classed(xt.eventRect)){if(a.dragging||a.flowing||i.hasArcType()||r.touches.length>1)return;!function(t){var i=t.type,a=t.changedTouches[0]["client"+(n.axis_rotated?"Y":"X")];"touchstart"===i?u?t.preventDefault():null!==d&&(e=a):"touchmove"===i&&(u||!0===e||null!==d&&Math.abs(e-a)>=d)&&(e=!0,t.preventDefault())}(r),function(e){if(t)i.selectRectForMultipleXs(e);else{var n=i.getDataIndexFromEvent(a.event);i.callOverOutForTouch(n),-1===n?i.unselectRect():i.selectRectForSingle(e,s,n)}}(s.node())}else l()}),!0).on("touchend.eventRect",(function(t){a.event=t,!s.empty()&&s.classed(xt.eventRect)&&(i.hasArcType()||!i.toggleShape||a.cancelClick)&&a.cancelClick&&(a.cancelClick=!1)}),!0),o.on("touchstart",(function(t){a.event=t;var e=t.target;e&&e!==s.node()&&l()}))},updateEventRect:function(t,e){void 0===e&&(e=!1);var i=this.state,n=this.$el,a=i,r=a.eventReceiver,s=a.width,o=a.height,l=a.rendered,c=a.resizing,u=t||n.eventRect;(!l||c||e)&&(u.attr("x",0).attr("y",0).attr("width",s).attr("height",o),l||u.attr("class",xt.eventRect)),r&&(r.rect=u.node().getBoundingClientRect())},updateEventRectData:function(){var t,e,i,n,a=this,r=a.config,s=a.scale,o=a.state,l=s.zoom||s.x,c=r.axis_rotated;if(a.isMultipleX())t=0,e=0,i=o.width,n=o.height;else{var u,d;if(a.axis.isCategorized())u=a.getEventRectWidth(),d=function(t){return l(t.x)-u/2};else{var h=function(t){var e=t.index;return{prev:a.getPrevX(e),next:a.getNextX(e)}};u=function(t){var e=h(t),i=l.domain();return null===e.prev&&null===e.next?c?o.height:o.width:(Object.keys(e).forEach((function(t,n){var a;e[t]=null!=(a=e[t])?a:i[n]})),Math.max(0,(l(e.next)-l(e.prev))/2))},d=function(t){var e=h(t),i=t.x;return null===e.prev&&null===e.next?0:(null===e.prev&&(e.prev=l.domain()[0]),(l(i)+l(e.prev))/2)}}t=c?0:d,e=c?d:0,i=c?o.width:u,n=c?u:o.height}var g=o.eventReceiver,f=function(t,e){return v(t)?t(e):t};g.coords.splice(g.data.length),g.data.forEach((function(a,r){g.coords[r]={x:f(t,a),y:f(e,a),w:f(i,a),h:f(n,a)}}))},selectRectForMultipleXs:function(t){var e=this,i=e.config,n=e.state,a=e.filterTargetsToShow(e.data.targets);if(!n.dragging&&!e.hasArcType(a)){var r=M(n.event,t),s=e.findClosestFromTargets(a,r);if(!n.mouseover||s&&s.id===n.mouseover.id||(i.data_onout.call(e.api,n.mouseover),n.mouseover=void 0),s){var o=(e.isBubbleType(s)||e.isScatterType(s)||!i.tooltip_grouped?[s]:e.filterByX(a,s.x)).map((function(t){return e.addName(t)}));e.showTooltip(o,t),e.setExpand(s.index,s.id,!0),e.showGridFocus(o),(e.isBarType(s.id)||e.dist(s,r)<i.point_sensitivity)&&(e.$el.svg.select("."+xt.eventRect).style("cursor","pointer"),n.mouseover||(i.data_onover.call(e.api,s),n.mouseover=s))}else e.unselectRect()}},unselectRect:function(){var t=this,e=t.config,i=t.$el,n=i.circle,a=i.tooltip;t.$el.svg.select("."+xt.eventRect).style("cursor",null),t.hideGridFocus(),a&&(t.hideTooltip(),t._handleLinkedCharts(!1)),n&&!e.point_focus_only&&t.unexpandCircles(),t.expandBarTypeShapes(!1)},generateEventRectsForSingleX:function(t){var e=this,i=e.config,n=e.state,a=n.eventReceiver,r=t.style("cursor",i.data_selection_enabled&&i.data_selection_grouped?"pointer":null).on("click",(function(t){n.event=t;var i=a,r=i.currentIdx,s=i.data[-1===r?e.getDataIndexFromEvent(t):r];e.clickHandlerForSingleX.bind(this)(s,e)}));if("mouse"===n.inputType){r.on("mouseover",(function(t){n.event=t,e.updateEventRect()})).on("mousemove",(function(t){var s=function(t){var i=t?e.getDataIndexFromEvent(t):a.currentIdx;return i>-1?a.data[i]:null}(t);if(n.event=t,s){var o=s.index,l=i.line_step_type;if(i.line_step_tooltipMatch&&e.hasType("step")&&/^step\-(before|after)$/.test(l)){var c=e.scale.zoom||e.scale.x,u=e.axis.xs[o],d=c.invert(M(t,this)[0]);"step-after"===l&&d<u?o-=1:"step-before"===l&&d>u&&(o+=1)}n.dragging||n.flowing||e.hasArcType()||i.tooltip_grouped&&o===a.currentIdx||(o!==a.currentIdx&&(e.setOverOut(!1,a.currentIdx),a.currentIdx=o),-1===o?e.unselectRect():e.selectRectForSingle(this,r,o),e.setOverOut(-1!==o,o))}})).on("mouseout",(function(t){n.event=t,i&&!e.hasArcType()&&-1!==a.currentIdx&&(e.unselectRect(),e.setOverOut(!1,a.currentIdx),a.currentIdx=-1)}))}return r},clickHandlerForSingleX:function(t,e){var i=e,n=i.config,a=i.state,r=i.$el.main;if(!t||i.hasArcType()||a.cancelClick)a.cancelClick&&(a.cancelClick=!1);else{var s=t.index;r.selectAll("."+wt.shape+"-"+s).each((function(t){(n.data_selection_grouped||i.isWithinShape(this,t))&&(null==i.toggleShape||i.toggleShape(this,t,s),n.data_onclick.bind(i.api)(t,this))}))}},generateEventRectsForMultipleXs:function(t){var e=this,i=e.state;t.on("click",(function(t){i.event=t,e.clickHandlerForMultipleXS.bind(this)(e)})),"mouse"===i.inputType&&t.on("mouseover mousemove",(function(t){i.event=t,e.selectRectForMultipleXs(this)})).on("mouseout",(function(t){i.event=t,e.config&&!e.hasArcType()&&e.unselectRect()}))},clickHandlerForMultipleXS:function(t){var e=t,i=e.config,n=e.state,a=e.filterTargetsToShow(e.data.targets);if(!e.hasArcType(a)){var r=M(n.event,this),s=e.findClosestFromTargets(a,r);s&&(e.isBarType(s.id)||e.dist(s,r)<i.point_sensitivity)&&e.$el.main.selectAll("."+wt.shapes+e.getTargetSelectorSuffix(s.id)).selectAll("."+wt.shape+"-"+s.index).each((function(){(i.data_selection_grouped||e.isWithinShape(this,s))&&(null==e.toggleShape||e.toggleShape(this,s,s.index),i.data_onclick.bind(e.api)(s,this))}))}}},ni=f(11),ai={generateFlow:function(t){var e=this,i=e.data,n=e.state,a=e.$el;return function(){var r=t.flow.length;n.flowing=!0,i.targets.forEach((function(t){t.values.splice(0,r)})),e.updateXGrid&&e.updateXGrid(!0);var s={};["axis.x","grid.x","gridLines.x","region.list","text","bar","line","area","circle"].forEach((function(t){var e,i=t.split("."),n=a[i[0]];n&&i.length>1&&(n=n[i[1]]),null!=(e=n)&&e.size()&&(s[t]=n)})),e.hideGridFocus(),e.setFlowList(s,t)}},setFlowList:function(t,e){var i,n=this,a=e.flow,r=e.targets,s=a,o=s.duration,l=void 0===o?e.duration:o,c=s.index,u=s.length,d=s.orgDataCount,h=n.getFlowTransform(r,d,c,u),g=te();g.add(Object.keys(t).map((function(e){return i=t[e].transition().ease(ni.easeLinear).duration(l),i="axis.x"===e?i.call((function(t){n.axis.x.setTransition(t).create(t)})):"region.list"===e?i.filter(n.isRegionOnX).attr("transform",h):i.attr("transform",h)}))),i.call(g,(function(){n.cleanUpFlow(t,e)}))},cleanUpFlow:function(t,e){var i=this,n=i.config,a=i.state,r=i.$el.svg,s=n.axis_rotated,o=e.flow,l=e.shape,c=e.xv,u=l.pos,d=u.cx,h=u.cy,g=u.xForText,f=u.yForText,p=o,v=p.done,x=void 0===v?function(){}:v,_=p.length;_&&(["circle","text","shape","eventRect"].forEach((function(t){for(var e=[],i=0;i<_;i++)e.push("."+Et[t]+"-"+i);r.selectAll("."+Et[t+"s"]).selectAll(e).remove()})),r.select("."+Et.xgrid).remove()),Object.keys(t).forEach((function(e){var r=t[e];if("axis.x"!==e&&r.attr("transform",null),"grid.x"===e)r.attr(a.xgridAttr);else if("gridLines.x"===e)r.attr("x1",s?0:c).attr("x2",s?a.width:c);else if("gridLines.x"===e)r.select("line").attr("x1",s?0:c).attr("x2",s?a.width:c),r.select("text").attr("x",s?a.width:0).attr("y",c);else if(/^(area|bar|line)$/.test(e))r.attr("d",l.type[e]);else if("text"===e)r.attr("x",g).attr("y",f).style("fill-opacity",i.opacityForText.bind(i));else if("circle"===e)if(i.isCirclePoint())r.attr("cx",d).attr("cy",h);else{r.attr("x",(function(t){return d(t)-n.point_r})).attr("y",(function(t){return h(t)-n.point_r})).attr("cx",d).attr("cy",h)}else"region.list"===e&&r.select("rect").filter(i.isRegionOnX).attr("x",i.regionX.bind(i)).attr("width",i.regionWidth.bind(i))})),n.interaction_enabled&&i.redrawEventRect(),x.call(i.api),a.flowing=!1},getFlowTransform:function(t,e,i,n){var a,r,s,o=this,l=o.data,c=o.scale.x,u=l.targets[0].values,d=o.getValueOnIndex(u,i),h=o.getValueOnIndex(u,i+n),g=c.domain(),f=o.updateXDomain(t,!0,!0);return e?s=1===e||(null==(a=d)?void 0:a.x)===(null==(r=h)?void 0:r.x)||o.axis.isTimeSeries()?c(g[0])-c(f[0]):c(d.x)-c(h.x):1!==u.length?s=c(g[0])-c(f[0]):o.axis.isTimeSeries()?(d=o.getValueOnIndex(u,0),h=o.getValueOnIndex(u,u.length-1),s=c(d.x)-c(h.x)):s=A(f)/2,"translate("+s+",0) scale("+A(g)/A(f)+",1)"}},ri={initClip:function(){var t=this,e=t.state.clip;e.id=t.state.datetimeId+"-clip",e.idXAxis=e.id+"-xaxis",e.idYAxis=e.id+"-yaxis",e.idGrid=e.id+"-grid",e.path=t.getClipPath(e.id),e.pathXAxis=t.getClipPath(e.idXAxis),e.pathYAxis=t.getClipPath(e.idYAxis),e.pathGrid=t.getClipPath(e.idGrid)},getClipPath:function(t){var e=this.config;return!e.clipPath&&/-clip$/.test(t)||!e.axis_x_clipPath&&/-clip-xaxis$/.test(t)||!e.axis_y_clipPath&&/-clip-yaxis$/.test(t)?null:"url("+(!!a.navigator&&a.navigator.appVersion.toLowerCase().indexOf("msie 9.")>=0?"":r.URL.split("#")[0])+"#"+t+")"},appendClip:function(t,e){e&&t.append("clipPath").attr("id",e).append("rect")},setXAxisClipPath:function(t){var e=this.config,i=this.state,n=i.margin,a=i.width,r=i.height,s=e.axis_rotated,o=Math.max(30,n.left)-(s?0:20),l=s?-(1+o):-(o-1),c=-Math.max(15,n.top),u=s?n.left+20:a+10+o,d=(s?n.top+r+10:n.bottom)+20;t.attr("x",l).attr("y",c).attr("width",u).attr("height",d)},setYAxisClipPath:function(t){var e=this.config,i=this.state,n=i.margin,a=i.width,r=i.height,s=e.axis_rotated,o=Math.max(30,n.left)-(s?20:0),l=e.axis_y_inner,c=l?-1:s?-(1+o):-(o-1),u=-(s?20:n.top),d=(s?a+15+o:n.left+20)+(l?20:0),h=(s?n.bottom:n.top+r)+10;t.attr("x",c).attr("y",u).attr("width",d).attr("height",h)},updateXAxisTickClip:function(){var t=this,e=t.config,i=t.state,n=i.clip,a=i.xAxisHeight,r=t.$el.defs,s=t.getHorizontalAxisHeight("x");if(r&&!n.idXAxisTickTexts){var o=n.id+"-xaxisticktexts";t.appendClip(r,o),n.pathXAxisTickTexts=t.getClipPath(n.idXAxisTickTexts),n.idXAxisTickTexts=o}!e.axis_x_tick_multiline&&t.getAxisTickRotate("x")&&s!==a&&(t.setXAxisTickClipWidth(),t.setXAxisTickTextClipPathWidth()),t.state.xAxisHeight=s},setXAxisTickClipWidth:function(){var t=this,e=t.config,i=t.state.current.maxTickWidths,n=t.getAxisTickRotate("x");if(!e.axis_x_tick_multiline&&n){var a=Math.sin(Math.PI/180*Math.abs(n));i.x.clipPath=(t.getHorizontalAxisHeight("x")-20)/a}else i.x.clipPath=null},setXAxisTickTextClipPathWidth:function(){var t=this.state,e=t.clip,i=t.current,n=this.$el.svg;n&&n.select("#"+e.idXAxisTickTexts+" rect").attr("width",i.maxTickWidths.x.clipPath).attr("height",30)}},si=function(t){return g(t.position)||"end"},oi=function(t){return"start"===t.position?4:"middle"===t.position?0:-4};function li(t,e,i){return function(n){var a=t?0:e;return"start"===n.position?a=t?-i:0:"middle"===n.position&&(a=(t?-i:e)/2),a}}function ci(t,e){"grid"===e&&t.each((function(){var t=(0,n.select)(this);["x1","x2","y1","y2"].forEach((function(e){return t.attr(e,Math.ceil(+t.attr(e)))}))}))}var ui={hasGrid:function(){var t=this.config;return["x","y"].some((function(e){return t["grid_"+e+"_show"]||t["grid_"+e+"_lines"].length}))},initGrid:function(){var t=this;t.hasGrid()&&t.initGridLines(),t.initFocusGrid()},initGridLines:function(){var t=this,e=t.config,i=t.state.clip,a=t.$el;(e.grid_x_lines.length||e.grid_y_lines.length)&&(a.gridLines.main=a.main.insert("g","."+rt.chart+(e.grid_lines_front?" + *":"")).attr("clip-path",i.pathGrid).attr("class",mt.grid+" "+mt.gridLines),a.gridLines.main.append("g").attr("class",mt.xgridLines),a.gridLines.main.append("g").attr("class",mt.ygridLines),a.gridLines.x=(0,n.selectAll)([]))},updateXGrid:function(t){var e=this,i=e.config,a=e.scale,r=e.state,s=e.$el,o=s.main,l=s.grid,c=i.axis_rotated,u=e.generateGridData(i.grid_x_type,a.x),d=e.axis.isCategorized()?e.axis.x.tickOffset():0,h=function(t){return(a.zoom||a.x)(t)+d*(c?-1:1)};r.xgridAttr=c?{x1:0,x2:r.width,y1:h,y2:h}:{x1:h,x2:h,y1:0,y2:r.height},l.x=o.select("."+mt.xgrids).selectAll("."+mt.xgrid).data(u),l.x.exit().remove(),l.x=l.x.enter().append("line").attr("class",mt.xgrid).merge(l.x),t||l.x.each((function(){var t=(0,n.select)(this);Object.keys(r.xgridAttr).forEach((function(e){t.attr(e,r.xgridAttr[e]).style("opacity",(function(){return t.attr(c?"y1":"x1")===(c?r.height:0)?"0":null}))}))}))},updateYGrid:function(){var t=this,e=t.config,i=t.state,n=t.$el,a=n.grid,r=n.main,s=e.axis_rotated,o=t.axis.y.tickValues()||t.scale.y.ticks(e.grid_y_ticks),l=function(e){return Math.ceil(t.scale.y(e))};a.y=r.select("."+mt.ygrids).selectAll("."+mt.ygrid).data(o),a.y.exit().remove(),a.y=a.y.enter().append("line").attr("class",mt.ygrid).merge(a.y),a.y.attr("x1",s?l:0).attr("x2",s?l:i.width).attr("y1",s?0:l).attr("y2",s?i.height:l),ci(a.y,"grid")},updateGrid:function(){var t=this,e=t.$el,i=e.grid;e.gridLines.main||t.initGridLines(),i.main.style("visibility",t.hasArcType()?"hidden":null),t.hideGridFocus(),t.updateXGridLines(),t.updateYGridLines()},updateXGridLines:function(){var t=this,e=t.config,i=t.$el,n=i.gridLines,a=i.main,r=t.$T,s=e.axis_rotated;e.grid_x_show&&t.updateXGrid();var o=a.select("."+mt.xgridLines).selectAll("."+mt.xgridLine).data(e.grid_x_lines);r(o.exit()).style("opacity","0").remove();var l=o.enter().append("g");l.append("line").style("opacity","0"),l.append("text").attr("transform",s?"":"rotate(-90)").attr("dy",-5).style("opacity","0"),r((o=l.merge(o)).attr("class",(function(t){return(mt.xgridLine+" "+(t.class||"")).trim()})).select("text").attr("text-anchor",si).attr("dx",oi)).text((function(t){return t.text})).style("opacity",null),n.x=o},updateYGridLines:function(){var t=this,e=t.config,i=t.state,n=i.width,a=i.height,r=t.$el,s=t.$T,o=e.axis_rotated;e.grid_y_show&&t.updateYGrid();var l=r.main.select("."+mt.ygridLines).selectAll("."+mt.ygridLine).data(e.grid_y_lines);s(l.exit()).style("opacity","0").remove();var c=l.enter().append("g");c.append("line").style("opacity","0"),c.append("text").attr("transform",o?"rotate(-90)":"").style("opacity","0"),l=c.merge(l);var u=t.yv.bind(t);s(l.attr("class",(function(t){return(mt.ygridLine+" "+(t.class||"")).trim()})).select("line")).attr("x1",o?u:0).attr("x2",o?u:n).attr("y1",o?0:u).attr("y2",o?a:u).style("opacity",null),s(l.select("text").attr("text-anchor",si).attr("dx",oi)).attr("dy",-5).attr("x",li(o,n,a)).attr("y",u).text((function(t){return t.text})).style("opacity",null),r.gridLines.y=l},redrawGrid:function(t){var e=this,i=e.config.axis_rotated,n=e.state,a=n.width,r=n.height,s=e.$el.gridLines,o=e.$T,l=e.xv.bind(e),c=s.x.select("line"),u=s.x.select("text");return c=o(c,t).attr("x1",i?0:l).attr("x2",i?a:l).attr("y1",i?l:0).attr("y2",i?l:r),u=o(u,t).attr("x",li(!i,a,r)).attr("y",l).text((function(t){return t.text})),[c.style("opacity",null),u.style("opacity",null)]},initFocusGrid:function(){var t=this,e=t.config,i=t.state.clip,n=t.$el,a=e.grid_front,r="."+(a&&n.gridLines.main?mt.gridLines:rt.chart)+(a?" + *":""),s=n.main.insert("g",r).attr("clip-path",i.pathGrid).attr("class",mt.grid);n.grid.main=s,e.grid_x_show&&s.append("g").attr("class",mt.xgrids),e.grid_y_show&&s.append("g").attr("class",mt.ygrids),e.interaction_enabled&&e.grid_focus_show&&(s.append("g").attr("class",_t.xgridFocus).append("line").attr("class",_t.xgridFocus),e.grid_focus_y&&!e.tooltip_grouped&&s.append("g").attr("class",_t.ygridFocus).append("line").attr("class",_t.ygridFocus))},showGridFocus:function(t){var e=this,i=e.config,a=e.state,r=a.width,s=a.height,o=i.axis_rotated,l=e.$el.main.selectAll("line."+_t.xgridFocus+", line."+_t.ygridFocus),c=(t||[l.datum()]).filter((function(t){return t&&g(e.getBaseValue(t))}));if(i.tooltip_show&&0!==c.length&&!e.hasType("bubble")&&!e.hasArcType()){var u=i.grid_focus_edge&&!i.tooltip_grouped,d=e.xx.bind(e);l.style("visibility",null).data(c.concat(c)).each((function(t){var i,a=(0,n.select)(this),l={x:d(t),y:e.getYScaleById(t.id)(t.value)};if(a.classed(_t.xgridFocus))i=o?[null,l.x,u?l.y:r,l.x]:[l.x,u?l.y:null,l.x,s];else{var c="y2"===e.axis.getId(t.id);i=o?[l.y,u&&!c?l.x:null,l.y,u&&c?l.x:s]:[u&&c?l.x:null,l.y,u&&!c?l.x:r,l.y]}["x1","y1","x2","y2"].forEach((function(t,e){return a.attr(t,i[e])}))})),ci(l,"grid"),null==e.showCircleFocus||e.showCircleFocus(t)}},hideGridFocus:function(){var t=this,e=t.state,i=e.inputType,n=e.resizing,a=t.$el.main;"mouse"!==i&&n||(a.selectAll("line."+_t.xgridFocus+", line."+_t.ygridFocus).style("visibility","hidden"),null==t.hideCircleFocus||t.hideCircleFocus())},updateGridFocus:function(){var t=this,e=t.state,i=e.inputType,n=e.width,a=e.height,r=e.resizing,s=t.$el.grid.main.select("line."+_t.xgridFocus);if("touch"===i)s.empty()?r&&(null==t.showCircleFocus||t.showCircleFocus()):t.showGridFocus();else{var o=t.config.axis_rotated;s.attr("x1",o?0:-10).attr("x2",o?n:-10).attr("y1",o?-10:0).attr("y2",o?-10:a)}return!0},generateGridData:function(t,e){var i=this.$el.main.select("."+lt.axisX).selectAll(".tick").size(),n=[];if("year"===t)for(var a=this.getXDomain().map((function(t){return t.getFullYear()})),r=a[0],s=a[1],o=r;o<=s;o++)n.push(new Date(o+"-01-01 00:00:00"));else(n=e.ticks(10)).length>i&&(n=n.filter((function(t){return(t+"").indexOf(".")<0})));return n},getGridFilterToRemove:function(t){return t?function(e){var i=!1;return(E(t)?t.concat():[t]).forEach((function(t){("value"in t&&e.value===t.value||"class"in t&&e.class===t.class)&&(i=!0)})),i}:function(){return!0}},removeGridLines:function(t,e){var i=this,n=i.config,a=i.$T,r=i.getGridFilterToRemove(t),s=e?mt.xgridLines:mt.ygridLines,o=e?mt.xgridLine:mt.ygridLine;a(i.$el.main.select("."+s).selectAll("."+o).filter(r)).style("opacity","0").remove();var l="grid_"+(e?"x":"y")+"_lines";n[l]=n[l].filter((function(t){return!r(t)}))}},di={initRegion:function(){var t=this.$el;t.region.main=t.main.insert("g",":first-child").attr("clip-path",this.state.clip.path).attr("class",bt.regions)},updateRegion:function(){var t=this,e=t.config,i=t.$el.region,n=t.$T;i.main||t.initRegion(),i.main.style("visibility",t.hasArcType()?"hidden":null);var a=i.main.selectAll("."+bt.region).data(e.regions);n(a.exit()).style("opacity","0").remove(),(a=a.enter().append("g").merge(a).attr("class",t.classRegion.bind(t))).append("rect").style("fill-opacity","0"),i.list=a},redrawRegion:function(t){var e=this,i=e.$el.region,a=e.$T,r=i.list.select("rect");return[(r=a(r,t).attr("x",e.regionX.bind(e)).attr("y",e.regionY.bind(e)).attr("width",e.regionWidth.bind(e)).attr("height",e.regionHeight.bind(e))).style("fill-opacity",(function(t){return g(t.opacity)?t.opacity:null})).on("end",(function(){(0,n.select)(this.parentNode).selectAll("rect:not([x])").remove()}))]},getRegionXY:function(t,e){var i=this,n=i.config,a=i.scale,r=n.axis_rotated,s="x"===t,o="start",l=0;return"y"===e.axis||"y2"===e.axis?(s||(o="end"),(s?r:!r)&&o in e&&(l=(0,a[e.axis])(e[o]))):(s?!r:r)&&o in e&&(l=(a.zoom||a.x)(i.axis.isTimeSeries()?tt.call(i,e[o]):e[o])),l},regionX:function(t){return this.getRegionXY("x",t)},regionY:function(t){return this.getRegionXY("y",t)},getRegionSize:function(t,e){var i=this,n=i.config,a=i.scale,r=i.state,s=n.axis_rotated,o="width"===t,l=i[o?"regionX":"regionY"](e),c="end",u=r[t];return"y"===e.axis||"y2"===e.axis?(o||(c="start"),(o?s:!s)&&c in e&&(u=(0,a[e.axis])(e[c]))):(o?!s:s)&&c in e&&(u=(a.zoom||a.x)(i.axis.isTimeSeries()?tt.call(i,e[c]):e[c])),u<l?0:u-l},regionWidth:function(t){return this.getRegionSize("width",t)},regionHeight:function(t){return this.getRegionSize("height",t)},isRegionOnX:function(t){return!t.axis||"x"===t.axis}},hi={getAxisSize:function(t){var e=this,i=e.config.axis_rotated;return i&&"x"===t||!i&&/y2?/.test(t)?e.getAxisWidthByAxisId(t,!0):e.getHorizontalAxisHeight(t)},getAxisWidthByAxisId:function(t,e){var i=this;if(i.axis){var n,a=null==(n=i.axis)?void 0:n.getLabelPositionById(t);return i.axis.getMaxTickWidth(t,e)+(a.isInner?20:40)}return 40},getHorizontalAxisHeight:function(t){var e=this,i=e.config,n=e.state,a=n.current,r=n.rotatedPadding,s=n.isLegendRight,o=n.isLegendInset,l=i.axis_rotated,c=30;if("x"===t&&!i.axis_x_show)return 8;if("x"===t&&i.axis_x_height)return i.axis_x_height;if("y"===t&&!i.axis_y_show)return!i.legend_show||s||o?1:10;if("y2"===t&&!i.axis_y2_show)return r.top;var u=e.getAxisTickRotate(t);return("x"===t&&!l||/y2?/.test(t)&&l)&&u&&(c=30+e.axis.getMaxTickWidth(t)*Math.cos(Math.PI*(90-Math.abs(u))/180),!i.axis_x_tick_multiline&&a.height&&c>a.height/2&&(c=a.height/2)),c+(e.axis.getLabelPositionById(t).isInner?0:10)+("y2"!==t||l?0:-10)},getEventRectWidth:function(){return Math.max(0,this.axis.x.tickInterval())},getAxisTickRotate:function(t){var e=this,i=e.axis,n=e.config,a=e.state,r=e.$el,s=n["axis_"+t+"_tick_rotate"];if("x"===t){var o=i.isCategorized()||i.isTimeSeries();if(n.axis_x_tick_fit&&o){var l=n.axis_x_tick_count,c=a.current.maxTickWidths.x.ticks.length,u=0;if(l?u=l>c?c:l:c&&(u=c),u!==a.axis.x.tickCount){var d=e.data.targets;a.axis.x.padding=e.getXDomainPadding([e.getXDomainMinMax(d,"min"),e.getXDomainMinMax(d,"max")],u)}a.axis.x.tickCount=u}r.svg&&n.axis_x_tick_fit&&!n.axis_x_tick_multiline&&!n.axis_x_tick_culling&&n.axis_x_tick_autorotate&&o&&(s=e.needToRotateXAxisTickTexts()?n.axis_x_tick_rotate:0)}return s},needToRotateXAxisTickTexts:function(){var t=this,e=t.state,i=e.axis,n=e.current.width-t.getCurrentPaddingLeft(!1)-t.getCurrentPaddingRight(),a=i.x.tickCount+i.x.padding.left+i.x.padding.right;return t.axis.getMaxTickWidth("x")>(a?n/a:0)}},gi={axis_y_clipPath:!0,axis_y_show:!0,axis_y_type:"indexed",axis_y_max:void 0,axis_y_min:void 0,axis_y_inverted:!1,axis_y_center:void 0,axis_y_inner:!1,axis_y_label:{},axis_y_tick_format:void 0,axis_y_tick_culling:!1,axis_y_tick_culling_max:5,axis_y_tick_culling_lines:!0,axis_y_tick_outer:!0,axis_y_tick_values:null,axis_y_tick_rotate:0,axis_y_tick_count:void 0,axis_y_tick_show:!0,axis_y_tick_stepSize:null,axis_y_tick_text_show:!0,axis_y_tick_text_position:{x:0,y:0},axis_y_tick_time_value:void 0,axis_y_padding:{},axis_y_default:void 0,axis_y_axes:[]},fi={axis_y2_show:!1,axis_y2_type:"indexed",axis_y2_max:void 0,axis_y2_min:void 0,axis_y2_inverted:!1,axis_y2_center:void 0,axis_y2_inner:!1,axis_y2_label:{},axis_y2_tick_format:void 0,axis_y2_tick_culling:!1,axis_y2_tick_culling_max:5,axis_y2_tick_culling_lines:!0,axis_y2_tick_outer:!0,axis_y2_tick_values:null,axis_y2_tick_rotate:0,axis_y2_tick_count:void 0,axis_y2_tick_show:!0,axis_y2_tick_stepSize:null,axis_y2_tick_text_show:!0,axis_y2_tick_text_position:{x:0,y:0},axis_y2_padding:{},axis_y2_default:void 0,axis_y2_axes:[]};function pi(t,e){var i=Object.keys(t);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(t);e&&(n=n.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),i.push.apply(i,n)}return i}function vi(t){for(var e,i=1;i<arguments.length;i++)e=null!=arguments[i]?arguments[i]:{},i%2?pi(Object(e),!0).forEach((function(i){c(t,i,e[i])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(e)):pi(Object(e)).forEach((function(i){Object.defineProperty(t,i,Object.getOwnPropertyDescriptor(e,i))}));return t}var xi=vi(vi(vi({axis_rotated:!1},{axis_x_clipPath:!0,axis_x_show:!0,axis_x_type:"indexed",axis_x_localtime:!0,axis_x_categories:[],axis_x_tick_centered:!1,axis_x_tick_format:void 0,axis_x_tick_culling:{},axis_x_tick_culling_max:10,axis_x_tick_culling_lines:!0,axis_x_tick_count:void 0,axis_x_tick_show:!0,axis_x_tick_text_show:!0,axis_x_tick_text_position:{x:0,y:0},axis_x_tick_fit:!0,axis_x_tick_values:null,axis_x_tick_autorotate:!1,axis_x_tick_rotate:0,axis_x_tick_outer:!0,axis_x_tick_multiline:!0,axis_x_tick_width:null,axis_x_tick_tooltip:!1,axis_x_max:void 0,axis_x_min:void 0,axis_x_padding:{},axis_x_height:void 0,axis_x_extent:void 0,axis_x_label:{},axis_x_axes:[]}),gi),fi),_i=[Ne,{category:function(t,e){var i=this.internal,n=i.config;return arguments.length>1&&(n.axis_x_categories[t]=e,i.redraw()),n.axis_x_categories[t]},categories:function(t){var e=this.internal,i=e.config;return arguments.length?(i.axis_x_categories=t,e.redraw(),i.axis_x_categories):i.axis_x_categories}},Ge,Ve,qe,He,Ue,Ze],mi=[ti,ri,ii,ai,ui,di,hi],yi=[{data_xs:{},data_xFormat:"%Y-%m-%d",data_xLocaltime:!0,data_xSort:!0,data_axes:{},data_regions:{},data_stack_normalize:!1},xi,{grid_x_show:!1,grid_x_type:"tick",grid_x_lines:[],grid_y_show:!1,grid_y_lines:[],grid_y_ticks:10,grid_focus_edge:!1,grid_focus_show:!0,grid_focus_y:!1,grid_front:!1,grid_lines_front:!0}],bi=f(12),Ti={initPie:function(){var t=this,e=t.config,i=e.data_type,n=e.pie_padding,a=e[i+"_startingAngle"]||0,r=(t.hasType("pie")&&n?.01*n:e[i+"_padAngle"])||0;t.pie=(0,me.pie)().startAngle(a).endAngle(a+2*Math.PI).padAngle(r).value((function(t){return t.values.reduce((function(t,e){return t+e.value}),0)})).sort(t.getSortCompareFn.bind(t)(!0))},updateRadius:function(){var t=this,e=t.config,i=t.state,n=e.pie_padding,a=e.gauge_width||e.donut_width,r=t.filterTargetsToShow(t.data.targets).length*e.gauge_arcs_minWidth;i.radiusExpanded=Math.min(i.arcWidth,i.arcHeight)/2*(t.hasMultiArcGauge()?.85:1),i.radius=.95*i.radiusExpanded,i.innerRadiusRatio=a?(i.radius-a)/i.radius:.6,i.gaugeArcWidth=a||(r<=i.radius-i.innerRadius?i.radius-i.innerRadius:r<=i.radius?r:i.radius);var s=e.pie_innerRadius||(n?n*(i.innerRadiusRatio+.1):0);i.outerRadius=e.pie_outerRadius,i.innerRadius=t.hasType("donut")||t.hasType("gauge")?i.radius*i.innerRadiusRatio:s},getRadius:function(t){var e=null==t?void 0:t.data,i=this.state,n=i.innerRadius,a=i.outerRadius;return!_(n)&&e&&(n=n[e.id]||0),R(a)&&e&&e.id in a?a=a[e.id]:_(a)||(a=this.state.radius),{innerRadius:n,outerRadius:a}},updateArc:function(){var t=this;t.updateRadius(),t.svgArc=t.getSvgArc(),t.svgArcExpanded=t.getSvgArcExpanded()},getArcLength:function(){var t=3.6*this.config.gauge_arcLength,e=t/360*2;return t<-360?e=-2:t>360&&(e=2),e*Math.PI},getStartAngle:function(){var t=this.config,e=t.gauge_fullCircle,i=-1*Math.PI/2,n=Math.PI/2,a=t.gauge_startingAngle;return!e&&a<=i?a=i:!e&&a>=n?a=n:(a>Math.PI||a<-1*Math.PI)&&(a=Math.PI),a},updateAngle:function(t){var e=this,i=e.config,n=e.state,a=e.pie,r=t,s=!1;if(!i)return null;var o=e.getStartAngle(),l=i.gauge_fullCircle?e.getArcLength():-2*o;if(r.data&&e.isGaugeType(r.data)&&!e.hasMultiArcGauge()){var c=i,u=c.gauge_min,d=c.gauge_max,h=e.getTotalDataSum(n.rendered);a=a.startAngle(o).endAngle(l*((h-u)/(d-u))+o)}if(a(e.filterTargetsToShow()).forEach((function(t,e){s||t.data.id!==r.data.id||(s=!0,(r=t).index=e)})),isNaN(r.startAngle)&&(r.startAngle=0),isNaN(r.endAngle)&&(r.endAngle=r.startAngle),r.data&&e.hasMultiArcGauge()){var g=i.gauge_min,f=i.gauge_max,p=r.value<g?0:r.value<f?r.value-g:f-g;r.startAngle=o,r.endAngle=o+l/(f-g)*p}return s?r:null},getSvgArc:function(){var t=this,e=t.state,i=e.gaugeArcWidth/t.filterTargetsToShow(t.data.targets).length,n=t.hasMultiArcGauge(),a=(0,me.arc)().innerRadius((function(a){var r=t.getRadius(a).innerRadius;return n?e.radius-i*(a.index+1):_(r)?r:0})).outerRadius((function(a){var r=t.getRadius(a).outerRadius;return n?e.radius-i*a.index:r})),r=function(e,i){var n="M 0 0";if(e.value||e.data){var r=!i&&t.updateAngle(e);i?n=a(e):r&&(n=a(r))}return n};return r.centroid=a.centroid,r},getSvgArcExpanded:function(t){var e=this,i=e.state,n=t||1,a=i.gaugeArcWidth/e.filterTargetsToShow(e.data.targets).length,r=e.hasMultiArcGauge(),s=Math.min(i.radiusExpanded*n-i.radius,.8*a-100*(1-n)),o=(0,me.arc)().innerRadius((function(t){return r?i.radius-a*(t.index+1):e.getRadius(t).innerRadius})).outerRadius((function(t){var o;if(r)o=i.radius-a*t.index+s;else{var l=e.getRadius(t).outerRadius,c=i.radiusExpanded;i.radius!==l&&(c-=Math.abs(i.radius-l)),o=c*n}return o}));return function(t){var i=e.updateAngle(t);return i?o(i):"M 0 0"}},getArc:function(t,e,i){return i||this.isArcType(t.data)?this.svgArc(t,e):"M 0 0"},transformForArcLabel:function(t){var e=this,i=e.config,n=e.state.radiusExpanded,a=e.updateAngle(t),r="";if(a)if(e.hasMultiArcGauge()){var s=Math.sin(a.endAngle-Math.PI/2);r="translate("+(c=Math.cos(a.endAngle-Math.PI/2)*(n+25))+","+(u=s*(n+15-Math.abs(10*s))+3)+")"}else if(!e.hasType("gauge")||e.data.targets.length>1){var o=e.getRadius(t).outerRadius,l=this.svgArc.centroid(a).map((function(t){return isNaN(t)?0:t})),c=l[0],u=l[1],d=Math.sqrt(c*c+u*u),h=e.hasType("donut")&&i.donut_label_ratio||e.hasType("pie")&&i.pie_label_ratio;r="translate("+c*(h=h?v(h)?h.bind(e.api)(t,o,d):h:o&&(d?(36/o>.375?1.175-36/o:.8)*o/d:0))+","+u*h+")"}return r},convertToArcData:function(t){return this.addName({id:t.data?t.data.id:t.id,value:t.value,ratio:this.getRatio("arc",t),index:t.index})},textForArcLabel:function(t){var e=this,i=e.hasType("gauge");e.shouldShowArcLabel()&&t.style("fill",e.updateTextColor.bind(e)).attr("filter",e.updateTextBacgroundColor.bind(e)).each((function(t){var a=(0,n.select)(this),r=e.updateAngle(t),s=e.getRatio("arc",r);if(e.meetsLabelThreshold(s,(e.hasType("donut")?"donut":e.hasType("gauge")&&"gauge")||e.hasType("pie")&&"pie")){var o=(r||t).value;P(a,(e.getArcLabelFormat()||e.defaultArcValueFormat)(o,s,t.data.id).toString(),[-1,1],i)}else a.text("")}))},expandArc:function(t){var e=this,i=e.state.transiting,a=e.$el;if(i)var r=setInterval((function(){i||(clearInterval(r),a.legend.selectAll("."+_t.legendItemFocused).size()>0&&e.expandArc(t))}),10);else{var s=e.mapToTargetIds(t);a.svg.selectAll(e.selectorTargets(s,"."+st.chartArc)).each((function(t){if(e.shouldExpand(t.data.id)){var i=e.getExpandConfig(t.data.id,"duration"),a=e.getSvgArcExpanded(e.getExpandConfig(t.data.id,"rate"));(0,n.select)(this).selectAll("path").transition().duration(i).attr("d",e.svgArcExpanded).transition().duration(2*i).attr("d",a)}}))}},unexpandArc:function(t){var e=this,i=e.state.transiting,n=e.$el.svg;if(!i){var a=e.mapToTargetIds(t);n.selectAll(e.selectorTargets(a,"."+st.chartArc)).selectAll("path").transition().duration((function(t){return e.getExpandConfig(t.data.id,"duration")})).attr("d",e.svgArc),n.selectAll(""+st.arc).style("opacity",null)}},getExpandConfig:function(t,e){var i,n=this,a=n.config;return n.isDonutType(t)?i="donut":n.isGaugeType(t)?i="gauge":n.isPieType(t)&&(i="pie"),i?a[i+"_expand_"+e]:{duration:50,rate:.98}[e]},shouldExpand:function(t){var e=this,i=e.config;return e.isDonutType(t)&&i.donut_expand||e.isGaugeType(t)&&i.gauge_expand||e.isPieType(t)&&i.pie_expand},shouldShowArcLabel:function(){var t=this,e=t.config;return["pie","donut","gauge"].some((function(i){return t.hasType(i)&&e[i+"_label_show"]}))},getArcLabelFormat:function(){var t=this,e=t.config,i=e.pie_label_format;return t.hasType("gauge")?i=e.gauge_label_format:t.hasType("donut")&&(i=e.donut_label_format),v(i)?i.bind(t.api):i},getArcTitle:function(){var t=this,e=t.hasType("donut")?"donut":t.hasType("gauge")&&"gauge";return e?t.config[e+"_title"]:""},updateTargetsForArc:function(t){var e=this,i=e.$el,n=e.hasType("gauge"),a=e.getChartClass("Arc"),r=e.getClass("arcs",!0),s=e.classFocus.bind(e),o=i.main.select("."+st.chartArcs),l=o.selectAll("."+st.chartArc).data(e.pie(t)).attr("class",(function(t){return a(t)+s(t.data)})),c=l.enter().append("g").attr("class",a);c.append("g").attr("class",r).merge(l),c.append("text").attr("dy",n&&!e.hasMultiTargets()?"-.1em":".35em").style("opacity","0").style("text-anchor","middle").style("pointer-events","none"),i.text=o.selectAll("."+rt.target+" text")},initArc:function(){var t=this,e=t.$el;e.arcs=e.main.select("."+rt.chart).append("g").attr("class",st.chartArcs).attr("transform",t.getTranslate("arc")),t.setArcTitle()},setArcTitle:function(){var t=this,e=t.getArcTitle(),i=t.hasType("gauge");if(e){var n=t.$el.arcs.append("text").attr("class",i?ft.chartArcsGaugeTitle:st.chartArcsTitle).style("text-anchor","middle");i&&n.attr("dy","-0.3em"),P(n,e,i?void 0:[-.6,1.35],!0)}},redrawArc:function(t,e,i){var a=this,r=a.config,s=a.state,o=a.$el.main,l=r.interaction_enabled,c=l&&r.data_selection_isselectable,u=o.selectAll("."+st.arcs).selectAll("."+st.arc).data(a.arcData.bind(a));u.exit().transition().duration(e).style("opacity","0").remove(),u=u.enter().append("path").attr("class",a.getClass("arc",!0)).style("fill",(function(t){return a.color(t.data)})).style("cursor",(function(t){var e;return null!=(e=c)&&null!=e.bind&&e.bind(a.api)(t)?"pointer":null})).style("opacity","0").each((function(t){a.isGaugeType(t.data)&&(t.startAngle=r.gauge_startingAngle,t.endAngle=r.gauge_startingAngle),this._current=t})).merge(u),a.hasType("gauge")&&(a.updateGaugeMax(),a.hasMultiArcGauge()&&a.redrawMultiArcGauge()),u.attr("transform",(function(t){return!a.isGaugeType(t.data)&&i?"scale(0)":""})).style("opacity",(function(t){return t===this._current?"0":null})).each((function(){s.transiting=!0})).transition().duration(t).attrTween("d",(function(t){var e=a.updateAngle(t);if(!e)return function(){return"M 0 0"};isNaN(this._current.startAngle)&&(this._current.startAngle=0),isNaN(this._current.endAngle)&&(this._current.endAngle=this._current.startAngle);var i=(0,bi.interpolate)(this._current,e);return this._current=i(0),function(e){var n=i(e);return n.data=t.data,a.getArc(n,!0)}})).attr("transform",i?"scale(1)":"").style("fill",(function(t){var e;return a.levelColor?(e=a.levelColor(t.data.values[0].value),r.data_colors[t.data.id]=e):e=a.color(t.data),e})).style("opacity",null).call(D,(function(){if(a.levelColor){var t=(0,n.select)(this),e=t.datum();a.updateLegendItemColor(e.data.id,t.style("fill"))}s.transiting=!1,L(r.onrendered,a.api)})),l&&a.bindArcEvent(u),a.hasType("gauge")&&a.redrawBackgroundArcs(),a.redrawArcText(t)},redrawBackgroundArcs:function(){var t=this,e=t.config,i=t.state,n=t.hasMultiArcGauge(),a=e.gauge_fullCircle,r=t.getStartAngle(),s=a?r+t.getArcLength():-1*r,o=t.$el.arcs.select((n?"g":"")+"."+st.chartArcsBackground);if(n){var l=0;(o=o.selectAll("path."+st.chartArcsBackground).data(t.data.targets)).enter().append("path").attr("class",(function(t,e){return st.chartArcsBackground+" "+st.chartArcsBackground+"-"+e})).merge(o).style("fill",e.gauge_background||null).attr("d",(function(n){var a=n.id;if(i.hiddenTargetIds.indexOf(a)>=0)return"M 0 0";var o={data:[{value:e.gauge_max}],startAngle:r,endAngle:s,index:l++};return t.getArc(o,!0,!0)})),o.exit().remove()}else o.attr("d",(function(){var i={data:[{value:e.gauge_max}],startAngle:r,endAngle:s};return t.getArc(i,!0,!0)}))},bindArcEvent:function(t){var e=this,i=e.config,a=e.state,s="touch"===a.inputType,o="mouse"===a.inputType;function l(t,i,n){e.expandArc(n),e.api.focus(n),e.toggleFocusLegend(n,!0),e.showTooltip([i],t)}function c(t){var i=(null==t?void 0:t.id)||void 0;e.unexpandArc(i),e.api.revert(),e.revertLegend(),e.hideTooltip()}if(t.on("click",(function(t,n,a){var r,s=e.updateAngle(n);s&&(r=e.convertToArcData(s),null==e.toggleShape||e.toggleShape(this,r,a),i.data_onclick.bind(e.api)(r,this))})),o&&t.on("mouseover",(function(t,i){var n;if(!a.transiting){a.event=t;var r=e.updateAngle(i),s=r?e.convertToArcData(r):null;l(this,s,(null==(n=s)?void 0:n.id)||void 0),e.setOverOut(!0,s)}})).on("mouseout",(function(t,i){if(!a.transiting){a.event=t;var n=e.updateAngle(i),r=n?e.convertToArcData(n):null;c(),e.setOverOut(!1,r)}})).on("mousemove",(function(t,i){var n=e.updateAngle(i),r=n?e.convertToArcData(n):null;a.event=t,e.showTooltip([r],this)})),s&&e.hasArcType()&&!e.radars){e.$el.svg.on("touchstart touchmove",(function(t){var i,s;if(!a.transiting){a.event=t;var o=function(t){var e=t.changedTouches[0];return(0,n.select)(r.elementFromPoint(e.clientX,e.clientY))}(t),u=o.datum(),d=null!=(i=u)&&i.data&&u.data.id?e.updateAngle(u):null,h=d?e.convertToArcData(d):null,g=(null==(s=h)?void 0:s.id)||void 0;e.callOverOutForTouch(h),m(g)?c():l(this,h,g)}}))}},redrawArcText:function(t){var e,i=this,n=i.config,a=i.state,r=i.$el,s=r.main,o=r.arcs,l=i.hasType("gauge"),c=i.hasMultiArcGauge();if(l&&1===i.data.targets.length&&n.gauge_title||(e=s.selectAll("."+st.chartArc).select("text").style("opacity","0").attr("class",(function(t){return i.isGaugeType(t.data)?ft.gaugeValue:null})).call(i.textForArcLabel.bind(i)).attr("transform",i.transformForArcLabel.bind(i)).style("font-size",(function(t){return i.isGaugeType(t.data)&&1===i.data.targets.length&&!c?Math.round(a.radius/5)+"px":null})).transition().duration(t).style("opacity",(function(t){return i.isTargetToShow(t.data.id)&&i.isArcType(t.data)?null:"0"})),c&&e.attr("dy","-.1em")),s.select("."+st.chartArcsTitle).style("opacity",i.hasType("donut")||l?null:"0"),l){var u,d=n.gauge_fullCircle;d&&(null==(u=e)||u.attr("dy",""+(c?0:Math.round(a.radius/14)))),n.gauge_label_show&&(o.select("."+ft.chartArcsGaugeUnit).attr("dy",(d?1.5:.75)+"em").text(n.gauge_units),o.select("."+ft.chartArcsGaugeMin).attr("dx",-1*(a.innerRadius+(a.radius-a.innerRadius)/(d?1:2))+"px").attr("dy","1.2em").text(i.textForGaugeMinMax(n.gauge_min,!1)),d||o.select("."+ft.chartArcsGaugeMax).attr("dx",a.innerRadius+(a.radius-a.innerRadius)/2+"px").attr("dy","1.2em").text(i.textForGaugeMinMax(n.gauge_max,!0)))}}},wi={initArea:function(t){var e=this.config;t.insert("g","."+(e.area_front?dt.circles:vt.lines)).attr("class",this.getClass("areas",!0))},updateAreaGradient:function(){var t=this,e=t.config,i=t.state.datetimeId,n=t.$el.defs;t.data.targets.forEach((function(a){var r=i+"-areaGradient"+t.getTargetSelectorSuffix(a.id);if(t.isAreaType(a)&&n.select("#"+r).empty()){var s=t.color(a),o=e.area_linearGradient,l=o.x,c=void 0===l?[0,0]:l,u=o.y,d=void 0===u?[0,1]:u,h=o.stops,g=void 0===h?[[0,s,1],[1,s,0]]:h,f=n.append("linearGradient").attr("id",""+r).attr("x1",c[0]).attr("x2",c[1]).attr("y1",d[0]).attr("y2",d[1]);g.forEach((function(e){var i=v(e[1])?e[1].bind(t.api)(a.id):e[1];f.append("stop").attr("offset",e[0]).attr("stop-color",i||s).attr("stop-opacity",e[2])}))}}))},updateAreaColor:function(t){var e=this;return e.config.area_linearGradient?"url(#"+e.state.datetimeId+"-areaGradient"+e.getTargetSelectorSuffix(t.id)+")":e.color(t)},updateArea:function(t,e){void 0===e&&(e=!1);var i=this,a=i.config,r=i.state,s=i.$el,o=i.$T,l=e?s.subchart:s;a.area_linearGradient&&i.updateAreaGradient();var c=l.main.selectAll("."+ot.areas).selectAll("."+ot.area).data(i.lineData.bind(i));o(c.exit(),t).style("opacity","0").remove(),l.area=c.enter().append("path").attr("class",i.getClass("area",!0)).style("fill",i.updateAreaColor.bind(i)).style("opacity",(function(){return r.orgAreaOpacity=(0,n.select)(this).style("opacity"),"0"})).merge(c),c.style("opacity",r.orgAreaOpacity)},redrawArea:function(t,e,i){void 0===i&&(i=!1);var n=this,a=(i?this.$el.subchart:this.$el).area,r=n.state.orgAreaOpacity;return[n.$T(a,e,F()).attr("d",t).style("fill",n.updateAreaColor.bind(n)).style("opacity",(function(t){return(n.isAreaRangeType(t)?r/1.75:r)+""}))]},generateDrawArea:function(t,e){var i=this,n=i.config,a=n.line_connectNull,r=n.axis_rotated,s=i.generateGetAreaPoints(t,e),o=i.getYScaleById.bind(i),l=function(t){return(e?i.subxx:i.xx).call(i,t)},c=function(t,n){return i.isGrouped(t.id)?s(t,n)[0][1]:o(t.id,e)(i.isAreaRangeType(t)?i.getRangedData(t,"high"):i.getShapeYMin(t.id))},u=function(t,n){return i.isGrouped(t.id)?s(t,n)[1][1]:o(t.id,e)(i.isAreaRangeType(t)?i.getRangedData(t,"low"):t.value)};return function(t){var e,s=a?i.filterRemoveNull(t.values):t.values,o=0,d=0;if(i.isAreaType(t)){var h=(0,me.area)();h=r?h.y(l).x0(c).x1(u):h.x(l).y0(n.area_above?0:c).y1(u),a||(h=h.defined((function(t){return null!==i.getBaseValue(t)}))),i.isStepType(t)&&(s=i.convertValuesToStep(s)),e=h.curve(i.getCurve(t))(s)}else s[0]&&(o=i.scale.x(s[0].x),d=i.getYScaleById(t.id)(s[0].value)),e=r?"M "+d+" "+o:"M "+o+" "+d;return e||"M 0 0"}},generateGetAreaPoints:function(t,e){var i=this,n=i.config,a=i.getShapeX(0,t,e),r=i.getShapeY(!!e),s=i.getShapeOffset(i.isAreaType,t,e),o=i.getYScaleById.bind(i);return function(t,l){var c=o.call(i,t.id,e)(i.getShapeYMin(t.id)),u=s(t,l)||c,d=a(t),h=r(t);return n.axis_rotated&&(t.value>0&&h<c||t.value<0&&c<h)&&(h=c),[[d,u],[d,h-(c-u)],[d,h-(c-u)],[d,u]]}}},Ai={initBar:function(){var t=this.$el,e=this.config,i=this.state.clip;t.bar=t.main.select("."+rt.chart).insert("g",":first-child").attr("class",ct.chartBars),!1===e.clipPath&&(e.bar_radius||e.bar_radius_ratio)&&t.bar.attr("clip-path",i.pathXAxis.replace(/#[^)]*/,"#"+i.id))},updateTargetsForBar:function(t){var e=this,i=e.config,n=e.$el,a=e.getChartClass("Bar"),r=e.getClass("bars",!0),s=e.classFocus.bind(e),o=i.interaction_enabled&&i.data_selection_isselectable;n.bar||e.initBar(),e.$el.main.select("."+ct.chartBars).selectAll("."+ct.chartBar).data(t.filter((function(t){return t.values.some((function(t){return _(t.value)||e.isBarRangeType(t)}))}))).attr("class",(function(t){return a(t)+s(t)})).enter().append("g").attr("class",a).style("opacity","0").style("pointer-events","none").append("g").attr("class",r).style("cursor",(function(t){var i;return null!=(i=o)&&null!=i.bind&&i.bind(e.api)(t)?"pointer":null}))},updateBar:function(t,e){void 0===e&&(e=!1);var i=this,n=i.$el,a=i.$T,r=e?n.subchart:n,s=i.getClass("bar",!0),o=i.initialOpacity.bind(i),l=r.main.selectAll("."+ct.bars).selectAll("."+ct.bar).data(i.labelishData.bind(i));a(l.exit(),t).style("opacity","0").remove(),r.bar=l.enter().append("path").attr("class",s).style("fill",i.color).merge(l).style("opacity",o)},redrawBar:function(t,e,i){void 0===i&&(i=!1);var n=this,a=(i?n.$el.subchart:n.$el).bar;return[n.$T(a,e,F()).attr("d",(function(e){return(_(e.value)||n.isBarRangeType(e))&&t(e)})).style("fill",this.color).style("opacity",null)]},generateDrawBar:function(t,e){var i=this,n=i.config,a=i.generateGetBarPoints(t,e),r=n.axis_rotated,s=n.bar_radius,o=n.bar_radius_ratio,l=_(s)&&s>0?function(){return s}:_(o)?function(t){return t*o}:null;return function(t,e){var n=a(t,e),s=+r,o=+!s,c=t.value<0,u=["",""],d=0,h=i.isGrouped(t.id),g=0!==t.value&&l,f=!(!g||!h)&&i.isStackingRadiusData(t);if(g&&(!h||f)){var p=r?o:s,v=n[2][p]-n[0][p],x="a"+(d=l(v))+","+d+" "+(c?"1 0 0":"0 0 1")+" ";u[+!r]=""+x+d+","+d,u[+r]=""+x+[-d,d][r?"sort":"reverse"](),c&&u.reverse()}var _=r?"H"+(n[1][s]-d)+" "+u[0]+"V"+(n[2][o]-d)+" "+u[1]+"H"+n[3][s]:"V"+(n[1][o]+(c?-d:d))+" "+u[0]+"H"+(n[2][s]-d)+" "+u[1]+"V"+n[3][o];return"M"+n[0][s]+","+n[0][o]+_+"z"}},isStackingRadiusData:function(t){var e=this,i=e.config,n=e.data,a=t.id,r=t.index,s=t.value,o=i.data_groups.find((function(t){return t.indexOf(a)>-1})),l=e.orderTargets(e.filterTargetsToShow(n.targets.filter(e.isBarType,e))).filter((function(t){return o.indexOf(t.id)>-1})).map((function(t){return t.values.filter((function(t){return t.index===r&&(s>0?t.value>0:t.value<0)}))[0]})).filter(Boolean).map((function(t){return t.id}));return 0!==s&&l.indexOf(a)===l.length-1},generateGetBarPoints:function(t,e){var i=this,n=i.config,a=e?i.axis.subX:i.axis.x,r=i.getIndicesMax(t)+1,s=i.getBarW("bar",a,r),o=i.getShapeX(s,t,!!e),l=i.getShapeY(!!e),c=i.getShapeOffset(i.isBarType,t,!!e),u=i.getYScaleById.bind(i);return function(t,a){var r=u.call(i,t.id,e)(i.getShapeYMin(t.id)),d=c(t,a)||r,h=_(s)?s:s[t.id]||s._$width,g=o(t),f=l(t);n.axis_rotated&&(t.value>0&&f<r||t.value<0&&r<f)&&(f=r),i.isBarRangeType(t)||(f-=r-d);var p=g+h;return[[g,d],[g,f],[p,f],[p,d]]}}};function ki(t,e){var i=Object.keys(t);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(t);e&&(n=n.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),i.push.apply(i,n)}return i}var Si={initCandlestick:function(){var t=this.$el;t.candlestick=t.main.select("."+rt.chart).append("g").attr("class",ut.chartCandlesticks)},updateTargetsForCandlestick:function(t){var e=this,i=e.$el,n=e.getChartClass("Candlestick"),a=e.classFocus.bind(e);i.candlestick||e.initCandlestick(),e.$el.main.select("."+ut.chartCandlesticks).selectAll("."+ut.chartCandlestick).data(t).attr("class",(function(t){return n(t)+a(t)})).enter().append("g").attr("class",n).style("pointer-events","none")},updateCandlestick:function(t,e){void 0===e&&(e=!1);var i=this,n=i.$el,a=i.$T,r=e?n.subchart:n,s=i.getClass("candlestick",!0),o=i.initialOpacity.bind(i),l=r.main.selectAll("."+ut.chartCandlestick).selectAll("."+ut.candlestick).data(i.labelishData.bind(i));a(l.exit(),t).style("opacity","0").remove();var c=l.enter().filter((function(t){return t.value})).append("g").attr("class",s);c.append("line"),c.append("path"),r.candlestick||(r.candlestick={}),r.candlestick=l.merge(c).style("opacity",o)},generateDrawCandlestick:function(t,e){var i=this,n=i.config,a=i.generateGetCandlestickPoints(t,e),r=n.axis_rotated,s=n.candlestick_color_down;return function(t,e,n){var o,l=a(t,e),c=null==(o=i.getCandlestickData(t))?void 0:o._isUp,u=+r;n.classed&&n.classed(ut[c?"valueUp":"valueDown"],!0);var d=r?"H"+l[1][1]+" V"+l[1][0]+" H"+l[0][1]:"V"+l[1][1]+" H"+l[1][0]+" V"+l[0][1];n.select("path").attr("d","M"+l[0][u]+","+l[0][+!u]+d+"z").style("fill",(function(t){return(c?i.color(t):R(s)?s[t.id]:s)||i.color(t)}));var h=n.select("line"),g=r?{x1:l[2][1],x2:l[2][2],y1:l[2][0],y2:l[2][0]}:{x1:l[2][0],x2:l[2][0],y1:l[2][1],y2:l[2][2]};for(var f in g)h.attr(f,g[f])}},generateGetCandlestickPoints:function(t,e){void 0===e&&(e=!1);var i=this,n=i.config,a=e?i.axis.subX:i.axis.x,r=i.getIndicesMax(t)+1,s=i.getBarW("candlestick",a,r),o=i.getShapeX(s,t,!!e),l=i.getShapeY(!!e),c=i.getShapeOffset(i.isBarType,t,!!e),u=i.getYScaleById.bind(i);return function(t,a){var r,d=u.call(i,t.id,e)(i.getShapeYMin(t.id)),h=c(t,a)||d,g=_(s)?s:s[t.id]||s._$width,f=i.getCandlestickData(t);if(f){var p={start:o(t),end:0};p.end=p.start+g;var v={start:l(f.open),end:l(f.close)},x={x:p.start+g/2,high:l(f.high),low:l(f.low)};n.axis_rotated&&(t.value>0&&v.start<d||t.value<0&&d<v.start)&&(v.start=d),v.start-=d-h,r=[[p.start,v.start],[p.end,v.end],[x.x,x.low,x.high]]}else r=[[0,0],[0,0],[0,0,0]];return r}},redrawCandlestick:function(t,e,i){void 0===i&&(i=!1);var a=this.$el,r=this.$T,s=(i?a.subchart:a).candlestick,o=F(!0);return[s.each((function(i,a){var s=r((0,n.select)(this),e,o);t(i,a,s)})).style("opacity",null)]},getCandlestickData:function(t){var e,i=t.value;if(E(i)){var n=i[0],a=i[1],r=i[2],s=i[3],o=i[4],l=void 0!==o&&o;e={open:n,high:a,low:r,close:s},!1!==l&&(e.volume=l)}else R(i)&&(e=function(t){for(var e,i=1;i<arguments.length;i++)e=null!=arguments[i]?arguments[i]:{},i%2?ki(Object(e),!0).forEach((function(i){c(t,i,e[i])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(e)):ki(Object(e)).forEach((function(i){Object.defineProperty(t,i,Object.getOwnPropertyDescriptor(e,i))}));return t}({},i));return e&&(e._isUp=e.close>=e.open),e||null}},Ci={initGauge:function(){var t=this,e=t.config,i=t.$el.arcs,n=function(t){i.append("text").attr("class",t).style("text-anchor","middle").style("pointer-events","none")};if(t.hasType("gauge")){var a=t.hasMultiArcGauge();i.append(a?"g":"path").attr("class",st.chartArcsBackground).style("fill",!a&&e.gauge_background||null),e.gauge_units&&n(ft.chartArcsGaugeUnit),e.gauge_label_show&&(n(ft.chartArcsGaugeMin),e.gauge_fullCircle||n(ft.chartArcsGaugeMax))}},updateGaugeMax:function(){var t=this,e=t.config,i=t.state,n=t.hasMultiArcGauge()?t.getMinMaxData().max[0].value:t.getTotalDataSum(i.rendered);n+e.gauge_min*(e.gauge_min>0?-1:1)>e.gauge_max&&(e.gauge_max=n-e.gauge_min)},redrawMultiArcGauge:function(){var t=this,e=t.config,i=t.state,a=t.$el,r=t.state.hiddenTargetIds,s=a.main.selectAll("."+st.arcs).selectAll("."+st.arcLabelLine).data(t.arcData.bind(t));s.enter().append("rect").attr("class",(function(t){return st.arcLabelLine+" "+rt.target+" "+rt.target+"-"+t.data.id})).merge(s).style("fill",(function(e){return t.levelColor?t.levelColor(e.data.values[0].value):t.color(e.data)})).style("display",e.gauge_label_show?null:"none").each((function(e){var a=0,s=0,o=0,l="";if(r.indexOf(e.data.id)<0){var c=t.updateAngle(e),u=i.gaugeArcWidth/t.filterTargetsToShow(t.data.targets).length*(c.index+1),d=c.endAngle-Math.PI/2,h=i.radius-u,g=d-(0===h?0:1/h);a=i.radiusExpanded-i.radius+u,s=Math.cos(g)*h,o=Math.sin(g)*h,l="rotate("+180*d/Math.PI+", "+s+", "+o+")"}(0,n.select)(this).attr("x",s).attr("y",o).attr("width",a).attr("height",2).attr("transform",l).style("stroke-dasharray","0, "+(a+2)+", 0")}))},textForGaugeMinMax:function(t,e){var i=this.config.gauge_label_extents;return v(i)?i.bind(this.api)(t,e):t},getGaugeLabelHeight:function(){var t=this.config;return this.config.gauge_label_show&&!t.gauge_fullCircle?20:0},getPaddingBottomForGauge:function(){return this.getGaugeLabelHeight()*(this.config.gauge_label_show?2:2.5)}},Ei={initBubble:function(){var t=this.config;this.hasType("bubble")&&(t.point_show=!0,t.point_type="circle",t.point_sensitivity=25)},getBaseLength:function(){var t=this,e=t.state,i=e.width,n=e.height,a=Nt,r=t.cache.get(a);return r||t.cache.add(a,r=q("min",[i,n])),r},getBubbleR:function(t){var e=this,i=e.config.bubble_maxR;v(i)?i=i.bind(e.api)(t):_(i)||(i=e.getBaseLength()/(2*e.getMaxDataCount())+12);var n=q("max",e.getMinMaxData().max.map((function(t){return e.isBubbleZType(t)?e.getBubbleZData(t.value,"y"):R(t.value)?t.value.mid:t.value}))),a=i*i*Math.PI,r=(e.isBubbleZType(t)?e.getBubbleZData(t.value,"z"):t.value)*(a/n);return Math.sqrt(r/Math.PI)},getBubbleZData:function(t,e){return R(t)?t[e]:t["y"===e?0:1]}},Ri={initLine:function(){var t=this.$el;t.line=t.main.select("."+rt.chart).append("g").attr("class",vt.chartLines)},updateTargetsForLine:function(t){var e=this,i=e.$el,n=i.area,a=i.line,r=i.main,s=e.getChartClass("Line"),o=e.getClass("lines",!0),l=e.classFocus.bind(e);a||e.initLine();var c=t.filter((function(t){return!(e.isScatterType(t)||e.isBubbleType(t))})),u=r.select("."+vt.chartLines).selectAll("."+vt.chartLine).data(c).attr("class",(function(t){return s(t)+l(t)})),d=u.enter().append("g").attr("class",s).style("opacity","0").style("pointer-events","none");d.append("g").attr("class",o),e.hasTypeOf("Area")&&e.initArea(!n&&d.empty()?u:d),e.updateTargetForCircle(c,d)},updateLine:function(t,e){void 0===e&&(e=!1);var i=this,n=i.format.extraLineClasses,a=i.$el,r=i.$T,s=e?a.subchart:a,o=s.main.selectAll("."+vt.lines).selectAll("."+vt.line).data(i.lineData.bind(i));r(o.exit(),t).style("opacity","0").remove(),s.line=o.enter().append("path").attr("class",(function(t){return i.getClass("line",!0)(t)+" "+(n(t)||"")})).style("stroke",i.color).merge(o).style("opacity",i.initialOpacity.bind(i)).style("shape-rendering",(function(t){return i.isStepType(t)?"crispEdges":""})).attr("transform",null)},redrawLine:function(t,e,i){void 0===i&&(i=!1);var n=this.$el;return[(0,this.$T)((i?n.subchart:n).line,e,F()).attr("d",t).style("stroke",this.color).style("opacity",null)]},getCurve:function(t){var e=this;return e.config.axis_rotated&&e.isStepType(t)?function(i){var n=e.getInterpolate(t)(i);return n.orgPoint=n.point,n.pointRotated=function(t,e){1===this._point&&(this._point=2);var i=this._y*(1-this._t)+e*this._t;this._context.lineTo(this._x,i),this._context.lineTo(t,i),this._x=t,this._y=e},n.point=function(t,e){0===this._point?this.orgPoint(t,e):this.pointRotated(t,e)},n}:e.getInterpolate(t)},generateDrawLine:function(t,e){var i=this,n=i.config,a=i.scale,r=n.line_connectNull,s=n.axis_rotated,o=i.generateGetLinePoints(t,e),l=i.getYScaleById.bind(i),c=function(t){return(e?i.subxx:i.xx).call(i,t)},u=function(t,n){return i.isGrouped(t.id)?o(t,n)[0][1]:l(t.id,e)(i.getBaseValue(t))},d=(0,me.line)();d=s?d.x(u).y(c):d.x(c).y(u),r||(d=d.defined((function(t){return null!==i.getBaseValue(t)})));var h=e?a.subX:a.x;return function(t){var o,c=l(t.id,e),u=r?i.filterRemoveNull(t.values):t.values,g=0,f=0;if(i.isLineType(t)){var p=n.data_regions[t.id];p?o=i.lineWithRegions(u,a.zoom||h,c,p):(i.isStepType(t)&&(u=i.convertValuesToStep(u)),o=d.curve(i.getCurve(t))(u))}else u[0]&&(g=h(u[0].x),f=c(u[0].value)),o=s?"M "+f+" "+g:"M "+g+" "+f;return o||"M 0 0"}},lineWithRegions:function(t,e,i,n){var a,r,s,o,l=this,c=l.config.axis_rotated,u=l.axis.isTimeSeries(),d=l.axis.isCategorized()?.5:0,h=[],f=function(t,e){for(var i,n=0;i=e[n];n++)if(i.start<t&&t<=i.end)return i.style;return!1};if(y(n))for(var p,v=function(t,e){return m(t)?e:u?tt.call(l,t):t},x=0;p=n[x];x++){var _=v(p.start,t[0].x),b=v(p.end,t[t.length-1].x),T=p.style||{dasharray:"2 2"};h[x]={start:_,end:b,style:T}}for(var w,A=c?function(t){return i(t.value)}:function(t){return e(t.x)},k=c?function(t){return e(t.x)}:function(t){return i(t.value)},S=function(t){return"M"+t[0][0]+","+t[0][1]+"L"+t[1][0]+","+t[1][1]},C=u?function(t,n,a,o){var l=t.x.getTime(),u=n.x-t.x,d=new Date(l+u*a),h=new Date(l+u*(a+o)),g=c?[[i(r(a)),e(d)],[i(r(a+s)),e(h)]]:[[e(d),i(r(a))],[e(h),i(r(a+s))]];return S(g)}:function(t,n,s,o){var l=c?[[i(r(s),!0),e(a(s))],[i(r(s+o),!0),e(a(s+o))]]:[[e(a(s),!0),i(r(s))],[e(a(s+o),!0),i(r(s+o))]];return S(l)},E={x:l.axis.getAxisType("x"),y:l.axis.getAxisType("y")},R="",O=0;w=t[O];O++){var L=t[O-1],D=L&&g(L.value);T=f(w.x,h);if(g(w.value))if(!m(h)&&T&&D){if(D){try{T=T.dasharray.split(" ")}catch(t){T="2 2".split(" ")}a=xe(E.x,L.x+d,w.x+d),r=xe(E.y,L.value,w.value);var I=e(w.x)-e(L.x),P=i(w.value)-i(L.value),z=Math.sqrt(Math.pow(I,2)+Math.pow(P,2));o=(s=T[0]/z)*T[1];for(var M=s;M<=1;M+=o)R+=C(L,w,M,s),M+o>=1&&(R+=C(L,w,1,0))}}else R+=(O&&D?"L":"M")+A(w)+","+k(w)}return R},isWithinStep:function(t,e){return Math.abs(e-M(this.state.event,t)[1])<30},shouldDrawPointsForLine:function(t){var e=this.config.line_point;return!0===e||E(e)&&-1!==e.indexOf(t.id)}},Oi=function(){return F()},Li={hasValidPointType:function(t){return/^(circle|rect(angle)?|polygon|ellipse|use)$/i.test(t||this.config.point_type)},hasValidPointDrawMethods:function(t){var e=t||this.config.point_type;return k(e)&&v(e.create)&&v(e.update)},initialOpacityForCircle:function(t){var e=this.config,i=this.state.withoutFadeIn,n=e.point_opacity;return m(n)&&(n=null!==this.getBaseValue(t)&&i[t.id]?this.opacityForCircle(t):"0"),n},opacityForCircle:function(t){var e=this.config,i=e.point_opacity;return m(i)&&(i=e.point_show&&!e.point_focus_only?null:"0",i=g(this.getBaseValue(t))?this.isBubbleType(t)||this.isScatterType(t)?"0.5":i:"0"),i},initCircle:function(){var t=this,e=t.$el.main;t.point=t.generatePoint(),(t.hasType("bubble")||t.hasType("scatter"))&&e.select("."+dt.chartCircles).empty()&&e.select("."+rt.chart).append("g").attr("class",dt.chartCircles)},updateTargetForCircle:function(t,e){var i=this,n=this,a=n.config,r=n.data,s=n.$el,o=a.interaction_enabled&&a.data_selection_enabled,l=o&&a.data_selection_isselectable,c=n.getClass("circles",!0);if(a.point_show){s.circle||n.initCircle();var u=t,d=e;if(!u){u=r.targets.filter((function(t){return i.isScatterType(t)||i.isBubbleType(t)}));var h=s.main.select("."+dt.chartCircles).style("pointer-events","none").selectAll("."+dt.circles).data(u).attr("class",c);h.exit().remove(),d=h.enter()}o&&d.append("g").attr("class",(function(t){return n.generateClass(Tt.selectedCircles,t.id)})),d.append("g").attr("class",c).style("cursor",(function(t){return v(l)&&l(t)?"pointer":null})),o&&u.forEach((function(t){s.main.selectAll("."+Tt.selectedCircles+n.getTargetSelectorSuffix(t.id)).selectAll(""+Tt.selectedCircle).each((function(e){e.value=t.values[e.index].value}))}))}},updateCircle:function(t){void 0===t&&(t=!1);var e=this,i=e.config,n=e.state,a=e.$el,r=i.point_focus_only,s=t?a.subchart:a;if(i.point_show&&!n.toggling){var o=s.main.selectAll("."+dt.circles).selectAll("."+dt.circle).data((function(t){return e.isLineType(t)&&e.shouldDrawPointsForLine(t)||e.isBubbleType(t)||e.isRadarType(t)||e.isScatterType(t)?r?[t.values[0]]:t.values:[]}));o.exit().remove(),o.enter().filter(Boolean).append(e.point("create",this,e.pointR.bind(e),e.color)),s.circle=s.main.selectAll("."+dt.circles+" ."+dt.circle).style("stroke",e.color).style("opacity",e.initialOpacityForCircle.bind(e))}},redrawCircle:function(t,e,i,n,a){void 0===a&&(a=!1);var r=this,s=r.state.rendered,o=r.$el,l=r.$T,c=a?o.subchart:o,u=c.main.selectAll("."+Tt.selectedCircle);if(!r.config.point_show)return[];var d=r.point("update",r,t,e,r.color,i,n,u),h=r.isCirclePoint()?"c":"",g=F(),f=r.opacityForCircle.bind(r),p=[];return c.circle.each((function(t){var e=d.bind(this)(t);e=l(e,i||!s,g).style("opacity",f),p.push(e)})),[p,l(u,i).attr(h+"x",t).attr(h+"y",e)]},showCircleFocus:function(t){var e=this,i=e.config,a=e.state,r=a.hasRadar,s=a.resizing,o=a.toggling,l=a.transiting,c=e.$el.circle;if(!1===l&&i.point_focus_only&&c){var u=(r?e.radarCircleX:e.circleX).bind(e),d=(r?e.radarCircleY:e.circleY).bind(e),h=o||m(t),f=e.point("update",e,u,d,e.color,!s&&h);t&&(c=c.filter((function(e){var i=t.filter((function(t){return t.id===e.id}));return!!i.length&&(0,n.select)(this).datum(i[0])}))),c.attr("class",this.updatePointClass.bind(this)).style("opacity",null).each((function(t){var i=t.id,n=t.index,a=t.value,r="hidden";g(a)&&(f.bind(this)(t),e.expandCircles(n,i),r=""),this.style.visibility=r}))}},hideCircleFocus:function(){var t=this,e=t.config,i=t.$el.circle;e.point_focus_only&&i&&(t.unexpandCircles(),i.style("visibility","hidden"))},circleX:function(t){return this.xx(t)},updateCircleY:function(t){void 0===t&&(t=!1);var e=this,i=e.generateGetLinePoints(e.getShapeIndices(e.isLineType),t);return function(n,a){var r=n.id;return e.isGrouped(r)?i(n,a)[0][1]:e.getYScaleById(r,t)(e.getBaseValue(n))}},expandCircles:function(t,e,i){var a=this,r=a.pointExpandedR.bind(a);i&&a.unexpandCircles();var s=a.getShapeByIndex("circle",t,e).classed(rt.EXPANDED,!0),o=r(s)/a.config.point_r,l=1-o;a.isCirclePoint()?s.attr("r",r):s.each((function(){var t=(0,n.select)(this);if("circle"===this.tagName)t.attr("r",r);else{var e=this.getBBox(),i=e.width,a=e.height,s=l*(+t.attr("x")+i/2),c=l*(+t.attr("y")+a/2);t.attr("transform","translate("+s+" "+c+") scale("+o+")")}}))},unexpandCircles:function(t){var e=this,i=e.pointR.bind(e),a=e.getShapeByIndex("circle",t).filter((function(){return(0,n.select)(this).classed(rt.EXPANDED)})).classed(rt.EXPANDED,!1);a.attr("r",i),e.isCirclePoint()||a.attr("transform","scale("+i(a)/e.config.point_r+")")},pointR:function(t){var e=this,i=e.config.point_r,n=i;return e.isBubbleType(t)?n=e.getBubbleR(t):v(i)&&(n=i.bind(e.api)(t)),n},pointExpandedR:function(t){var e=this,i=e.config,n=e.isBubbleType(t)?1.15:1.75;return i.point_focus_expand_enabled?i.point_focus_expand_r||e.pointR(t)*n:e.pointR(t)},pointSelectR:function(t){var e=this.config.point_select_r;return v(e)?e(t):e||4*this.pointR(t)},isWithinCircle:function(t,e){var i=M(this.state.event,t),a=(0,n.select)(t),r=this.isCirclePoint(t)?"c":"",s=+a.attr(r+"x"),o=+a.attr(r+"y");if(!s&&!o&&1===t.nodeType){var l=$(t);s=l.x,o=l.y}return Math.sqrt(Math.pow(s-i[0],2)+Math.pow(o-i[1],2))<(e||this.config.point_sensitivity)},insertPointInfoDefs:function(t,e){var i,a=function(t,e){for(var i,n=t.attributes,a=0;i=n[a];a++)i=i.name,e.setAttribute(i,t.getAttribute(i))},s=(new DOMParser).parseFromString(t,"image/svg+xml").documentElement,o=r.createElementNS(n.namespaces.svg,s.nodeName.toLowerCase());if(o.id=e,o.style.fill="inherit",o.style.stroke="inherit",a(s,o),null!=(i=s.childNodes)&&i.length){var l=(0,n.select)(o);"innerHTML"in o?l.html(s.innerHTML):j(s.childNodes).forEach((function(t){a(t,l.append(t.tagName).node())}))}this.$el.defs.node().appendChild(o)},pointFromDefs:function(t){return this.$el.defs.select("#"+t)},updatePointClass:function(t){var e=this,i=e.$el.circle,n=!1;return(R(t)||i)&&(n=!0===t?i.each((function(t){var i=e.getClass("circle",!0)(t);this.getAttribute("class").indexOf(rt.EXPANDED)>-1&&(i+=" "+rt.EXPANDED),this.setAttribute("class",i)})):e.getClass("circle",!0)(t)),n},generateGetLinePoints:function(t,e){var i=this,n=i.config,a=i.getShapeX(0,t,e),r=i.getShapeY(e),s=i.getShapeOffset(i.isLineType,t,e),o=i.getYScaleById.bind(i);return function(t,l){var c=o.call(i,t.id,e)(i.getShapeYMin(t.id)),u=s(t,l)||c,d=a(t),h=r(t);n.axis_rotated&&(t.value>0&&h<c||t.value<0&&c<h)&&(h=c);var g=[d,h-(c-u)];return[g,g,g,g]}},generatePoint:function(){var t=this,e=t.config,i=t.state.datetimeId,a=[],r=C(e.point_pattern)?e.point_pattern:[e.point_type];return function(e,s){for(var o=arguments.length,l=Array(o>2?o-2:0),c=2;c<o;c++)l[c-2]=arguments[c];return function(o){var c,u=t.getTargetSelectorSuffix(o.id||(null==(c=o.data)?void 0:c.id)||o),d=(0,n.select)(this);a.indexOf(u)<0&&a.push(u);var h=r[a.indexOf(u)%r.length];if(t.hasValidPointType(h))h=t[h];else if(!t.hasValidPointDrawMethods(h)){var g=i+"-point"+u;if(t.pointFromDefs(g).size()<1&&t.insertPointInfoDefs(h,g),"create"===e)return t.custom.create.bind(s).apply(void 0,[d,g].concat(l));if("update"===e)return t.custom.update.bind(s).apply(void 0,[d].concat(l))}return h[e].bind(s).apply(void 0,[d].concat(l))}}},custom:{create:function(t,e,i,n){return t.append("use").attr("xlink:href","#"+e).attr("class",this.updatePointClass.bind(this)).style("fill",n).node()},update:function(t,e,i,n,a,r,s){var o=t.node().getBBox(),l=o.width,c=o.height,u=function(t){return g(t.value)?e(t)-l/2:0},d=t;return a&&(r&&d.attr("x",u),d=this.$T(d,a,Oi()),s&&this.$T(s,a,Oi())),d.attr("x",u).attr("y",(function(t){return g(t.value)?i(t)-c/2:0})).style("fill",n)}},circle:{create:function(t,e,i){return t.append("circle").attr("class",this.updatePointClass.bind(this)).attr("r",e).style("fill",i).node()},update:function(t,e,i,n,a,r,s){var o=this,l=t;return o.hasType("bubble")&&l.attr("r",o.pointR.bind(o)),a&&(r&&l.attr("cx",e),l.attr("cx")&&(l=o.$T(l,a,Oi())),s&&o.$T(l,a,Oi())),l.attr("cx",e).attr("cy",i).style("fill",n)}},rectangle:{create:function(t,e,i){var n=function(t){return 2*e(t)};return t.append("rect").attr("class",this.updatePointClass.bind(this)).attr("width",n).attr("height",n).style("fill",i).node()},update:function(t,e,i,n,a,r,s){var o=this,l=o.config.point_r,c=function(t){return e(t)-l},u=t;return a&&(r&&u.attr("x",c),u=o.$T(u,a,Oi()),s&&o.$T(s,a,Oi())),u.attr("x",c).attr("y",(function(t){return i(t)-l})).style("fill",n)}}};var Di=Wt,Ii={initRadar:function(){var t=this,e=t.config,i=t.state.current,n=t.$el;t.hasType("radar")&&(n.radar=n.main.select("."+rt.chart).append("g").attr("class",yt.chartRadars),n.radar.levels=n.radar.append("g").attr("class",yt.levels),n.radar.axes=n.radar.append("g").attr("class",lt.axis),n.radar.shapes=n.radar.append("g").attr("class",wt.shapes),i.dataMax=e.radar_axis_max||t.getMinMaxData().max[0].value)},getRadarSize:function(){var t=this.config,e=this.state,i=e.arcWidth,n=e.arcHeight,a=t.axis_x_categories.length<4?-20:10,r=(Math.min(i,n)-a)/2;return[r,r]},updateTargetsForRadar:function(t){var e=this.config;S(e.axis_x_categories)&&(e.axis_x_categories=K(0,q("max",t.map((function(t){return t.values.length}))))),this.generateRadarPoints()},getRadarPosition:function(t,e,i,n){var a=this.config,r=this.getRadarSize(),s=r[0],o=r[1],l=a.axis_x_categories.length,c=a.radar_direction_clockwise,u=j(t).map((function(r){return function(t,e,i,n,a,r){var s=t&&n>0?i-n:n,o=2*Math.PI;return a*(1-r*("x"===e?Math.sin:Math.cos)(s*o/i))}(c,r,l,e,y(i)?i:"x"===t?s:o,_(n)?n:a.radar_size_ratio)}));return 1===u.length?u[0]:u},generateRadarPoints:function(){var t=this,e=t.data.targets,i=t.getRadarSize(),n=i[0],a=i[1],r=t.cache.get(Di)||{},s=r._size;(!s||s.width!==n&&s.height!==a)&&(e.forEach((function(e){r[e.id]=e.values.map((function(e,i){return t.getRadarPosition(["x","y"],i,void 0,t.getRatio("radar",e))}))})),r._size={width:n,height:a},t.cache.add(Di,r))},redrawRadar:function(){var t=this,e=t.$el,i=e.radar,n=e.main,a=t.getTranslate("radar");a&&(i.attr("transform",a),n.select("."+kt.chartTexts).attr("transform",a),t.generateRadarPoints(),t.updateRadarLevel(),t.updateRadarAxes(),t.updateRadarShape())},generateGetRadarPoints:function(){var t=this.cache.get(Di);return function(e,i){var n=t[e.id][i];return[n,n,n,n]}},updateRadarLevel:function(){var t=this,e=t.config,i=t.state,n=t.$el.radar,a=t.getRadarSize(),r=a[0],s=a[1],o=e.radar_level_depth,l=e.axis_x_categories.length,c=e.radar_level_text_show,u=n.levels,d=K(0,o),h=e.radar_size_ratio*Math.min(r,s),g=d.map((function(t){return h*((t+1)/o)})),f=(e.radar_level_text_format||function(){}).bind(t.api),p=d.map((function(e){var i=g[e];return K(0,l).map((function(e){return t.getRadarPosition(["x","y"],e,i,1).join(",")})).join(" ")})),v=u.selectAll("."+yt.level).data(d);v.exit().remove();var x=v.enter().append("g").attr("class",(function(t,e){return yt.level+" "+yt.level+"-"+e}));x.append("polygon").style("visibility",e.radar_level_show?null:"hidden"),c&&(u.select("text").empty()&&u.append("text").attr("dx","-.5em").attr("dy","-.7em").style("text-anchor","end").text((function(){return f(0)})),x.append("text").attr("dx","-.5em").style("text-anchor","end").text((function(t){return f(i.current.dataMax/d.length*(t+1))}))),x.merge(v).attr("transform",(function(t){return"translate("+(r-g[t])+", "+(s-g[t])+")"})).selectAll("polygon").attr("points",(function(t){return p[t]})),c&&u.selectAll("text").attr("x",(function(t){return m(t)?r:p[t].split(",")[0]})).attr("y",(function(t){return m(t)?s:0}))},updateRadarAxes:function(){var t=this,e=t.config,i=t.$el.radar,a=t.getRadarSize(),r=a[0],s=a[1],o=e.axis_x_categories,l=i.axes.selectAll("g").data(o);l.exit().remove();var c=l.enter().append("g").attr("class",(function(t,e){return lt.axis+"-"+e}));if(e.radar_axis_line_show&&c.append("line"),e.radar_axis_text_show&&c.append("text"),l=c.merge(l),e.radar_axis_line_show&&l.select("line").attr("x1",r).attr("y1",s).attr("x2",(function(e,i){return t.getRadarPosition("x",i)})).attr("y2",(function(e,i){return t.getRadarPosition("y",i)})),e.radar_axis_text_show){var u=e.radar_axis_text_position,d=u.x,h=void 0===d?0:d,g=u.y,f=void 0===g?0:g;l.select("text").style("text-anchor","middle").attr("dy",".5em").call((function(t){t.each((function(t){P((0,n.select)(this),t+"",[-.6,1.2])}))})).datum((function(t,e){return{index:e}})).attr("transform",(function(e){m(this.width)&&(this.width=this.getBoundingClientRect().width/2);var i=t.getRadarPosition("x",e.index,void 0,1),n=Math.round(t.getRadarPosition("y",e.index,void 0,1));return i>r?i+=this.width+h:Math.round(i)<r&&(i-=this.width+h),n>s?(n/2===s&&"tspan"===this.firstChild.tagName&&this.firstChild.setAttribute("dy","0em"),n+=f):n<s&&(n-=f),"translate("+i+" "+n+")"}))}t.bindEvent()},bindEvent:function(){var t=this,e=t.config,i=t.state,a=t.$el,r=a.radar,s=a.svg,o=e.point_focus_only,l=i,c=l.inputType,u=l.transiting;if(e.interaction_enabled){var d="mouse"===c,h=function(t){var e=t.target;/tspan/i.test(e.tagName)&&(e=e.parentNode);var i=(0,n.select)(e).datum();return i&&1===Object.keys(i).length?i.index:void 0},g=function(e){i.event=e;var n=h(e),a=m(n);(d||a)&&(t.hideTooltip(),o?t.hideCircleFocus():t.unexpandCircles(),d?t.setOverOut(!1,n):a&&t.callOverOutForTouch())};r.axes.selectAll("text").on(d?"mouseover ":"touchstart",(function(e){if(!u){i.event=e;var n=h(e);t.selectRectForSingle(s.node(),null,n),d?t.setOverOut(!0,n):t.callOverOutForTouch(n)}})).on("mouseout",d?g:null),d||s.on("touchstart",g)}},updateRadarShape:function(){var t=this,e=t.data.targets.filter((function(e){return t.isRadarType(e)})),i=t.cache.get(Di),n=t.$el.radar.shapes.selectAll("polygon").data(e),a=n.enter().append("g").attr("class",t.getChartClass("Radar"));t.$T(n.exit()).remove(),a.append("polygon").merge(n).style("fill",t.color).style("stroke",t.color).attr("points",(function(t){return i[t.id].join(" ")})),t.updateTargetForCircle(e,a)},radarCircleX:function(t){return this.cache.get(Di)[t.id][t.index][0]},radarCircleY:function(t){return this.cache.get(Di)[t.id][t.index][1]}},Pi={point_show:!0,point_r:2.5,point_sensitivity:10,point_focus_expand_enabled:!0,point_focus_expand_r:void 0,point_focus_only:!1,point_opacity:void 0,point_pattern:[],point_select_r:void 0,point_type:"circle"},zi={area_above:!1,area_front:!0,area_linearGradient:!1,area_zerobased:!0},Mi={bar_label_threshold:0,bar_indices_removeNull:!1,bar_padding:0,bar_radius:void 0,bar_radius_ratio:void 0,bar_sensitivity:2,bar_width:void 0,bar_width_ratio:.6,bar_width_max:void 0,bar_zerobased:!0},Xi={bubble_maxR:35,bubble_zerobased:!1},$i={candlestick_width:void 0,candlestick_width_ratio:.6,candlestick_width_max:void 0,candlestick_color_down:"red"},Fi={line_connectNull:!1,line_step_type:"step",line_step_tooltipMatch:!1,line_zerobased:!1,line_classes:void 0,line_point:!0},Bi={scatter_zerobased:!1},Ni={spline_interpolation_type:"cardinal"},Yi={donut_label_show:!0,donut_label_format:void 0,donut_label_threshold:.05,donut_label_ratio:void 0,donut_width:void 0,donut_title:"",donut_expand:{},donut_expand_rate:.98,donut_expand_duration:50,donut_padAngle:0,donut_startingAngle:0},Gi={gauge_background:"",gauge_fullCircle:!1,gauge_label_show:!0,gauge_label_format:void 0,gauge_label_extents:void 0,gauge_label_threshold:0,gauge_min:0,gauge_max:100,gauge_type:"single",gauge_startingAngle:-1*Math.PI/2,gauge_arcLength:100,gauge_title:"",gauge_units:void 0,gauge_width:void 0,gauge_arcs_minWidth:5,gauge_expand:{},gauge_expand_rate:.98,gauge_expand_duration:50},ji={pie_label_show:!0,pie_label_format:void 0,pie_label_threshold:.05,pie_label_ratio:void 0,pie_expand:{},pie_expand_rate:.98,pie_expand_duration:50,pie_innerRadius:0,pie_outerRadius:void 0,pie_padAngle:0,pie_padding:0,pie_startingAngle:0},Vi={radar_axis_max:void 0,radar_axis_line_show:!0,radar_axis_text_show:!0,radar_axis_text_position:{},radar_level_depth:3,radar_level_show:!0,radar_level_text_format:function(t){return t%1==0?t:t.toFixed(2)},radar_level_text_show:!0,radar_size_ratio:.87,radar_direction_clockwise:!1};function Hi(t,e){Y(Ee.prototype,mi.concat(t)),Y(Xe.prototype,_i),Bt.setOptions(yi.concat(e||[]))}function Wi(t,e){Hi([Li,Ri].concat(t||[])),Bt.setOptions([Pi,Fi].concat(e||[]))}function Ui(t,e){Y(Ee.prototype,[Ti].concat(t||[])),Bt.setOptions(e)}var Zi=function(){return Wi(wi,[zi]),(Zi=function(){return s.AREA})()},qi=function(){return Wi(wi,[zi]),(qi=function(){return s.AREA_LINE_RANGE})()},Ki=function(){return Wi(wi,[zi,Ni]),(Ki=function(){return s.AREA_SPLINE})()},Ji=function(){return Wi(wi,[zi,Ni]),(Ji=function(){return s.AREA_SPLINE_RANGE})()},Qi=function(){return Wi(wi,[zi]),(Qi=function(){return s.AREA_STEP})()},tn=function(){return Wi(),(tn=function(){return s.LINE})()},en=function(){return Wi(void 0,[Ni]),(en=function(){return s.SPLINE})()},nn=function(){return Wi(),(nn=function(){return s.STEP})()},an=function(){return Ui(void 0,[Yi]),(an=function(){return s.DONUT})()},rn=function(){return Ui([Ci],[Gi]),(rn=function(){return s.GAUGE})()},sn=function(){return Ui(void 0,[ji]),(sn=function(){return s.PIE})()},on=function(){return Ui([Li,Ii],[Pi,Vi]),(on=function(){return s.RADAR})()},ln=function(){return Hi([Ai],Mi),(ln=function(){return s.BAR})()},cn=function(){return Hi([Li,Ei],[Xi,Pi]),(cn=function(){return s.BUBBLE})()},un=function(){return Hi([Si],[$i]),(un=function(){return s.CANDLESTICK})()},dn=function(){return Hi([Li],[Pi,Bi]),(dn=function(){return s.SCATTER})()},hn={selected:function(t){var e=this.internal,i=[];return e.$el.main.selectAll("."+(wt.shapes+e.getTargetSelectorSuffix(t))).selectAll("."+wt.shape).filter((function(){return(0,n.select)(this).classed(Tt.SELECTED)})).each((function(t){return i.push(t)})),i},select:function(t,e,i){var a=this.internal,r=a.config,s=a.$el;r.data_selection_enabled&&s.main.selectAll("."+wt.shapes).selectAll("."+wt.shape).each((function(s,o){var l=(0,n.select)(this),c=s.data?s.data.id:s.id,u=a.getToggle(this,s).bind(a),d=r.data_selection_grouped||!t||t.indexOf(c)>=0,h=!e||e.indexOf(o)>=0,g=l.classed(Tt.SELECTED);l.classed(vt.line)||l.classed(ot.area)||(d&&h?r.data_selection_isselectable.bind(a.api)(s)&&!g&&u(!0,l.classed(Tt.SELECTED,!0),s,o):y(i)&&i&&g&&u(!1,l.classed(Tt.SELECTED,!1),s,o))}))},unselect:function(t,e){var i=this.internal,a=i.config,r=i.$el;a.data_selection_enabled&&r.main.selectAll("."+wt.shapes).selectAll("."+wt.shape).each((function(r,s){var o=(0,n.select)(this),l=r.data?r.data.id:r.id,c=i.getToggle(this,r).bind(i),u=a.data_selection_grouped||!t||t.indexOf(l)>=0,d=!e||e.indexOf(s)>=0,h=o.classed(Tt.SELECTED);o.classed(vt.line)||o.classed(ot.area)||u&&d&&a.data_selection_isselectable.bind(i.api)(r)&&h&&c(!1,o.classed(Tt.SELECTED,!1),r,s)}))}},gn={subchart:{show:function(){var t=this.internal,e=t.$el.subchart,i=t.config,n=i.subchart_show;if(!n){var a,r;t.unbindZoomEvent(),i.subchart_show=!n,e.main||t.initSubchart();var s,o=e.main.selectAll("."+rt.target);if(t.data.targets.length!==o.size())t.updateSizes(),t.updateTargetsForSubchart(t.data.targets),o=null==(s=e.main)?void 0:s.selectAll("."+rt.target);null==(a=o)||a.style("opacity",null),null==(r=e.main)||r.style("display",null),this.resize()}},hide:function(){var t,e=this.internal,i=e.$el.subchart.main,n=e.config;n.subchart_show&&"none"!==(null==(t=i)?void 0:t.style("display"))&&(n.subchart_show=!1,i.style("display","none"),this.resize())},toggle:function(){var t=this.internal.config;this.subchart[t.subchart_show?"hide":"show"]()}}},fn=f(13);var pn=function(t){var e=this.internal,i=e.$el,n=e.axis,a=e.config,r=e.org,s=e.scale,o=a.axis_rotated,l=n.isCategorized(),c=t;if(a.zoom_enabled&&c){if(n.isTimeSeries()&&(c=c.map((function(t){return tt.bind(e)(t)}))),function(t,e,i){var n=i[0],a=i[1];return t.every((function(i,r){return(0===r?i>=n:i<=a)&&!t.every((function(t,i){return t===e[i]}))}))}(c,e.getZoomDomain(!0),e.getZoomDomain())){if(l&&(c=c.map((function(t,e){return+t+(0===e?0:1)}))),e.api.tooltip.hide(),a.subchart_show){var u=s.zoom||s.x;e.brush.getSelection().call(e.brush.move,c.map(u))}else{var d,h=l?s.x.orgScale():r.xScale||s.x,g=[-h(c[0]),0],f=(d=fn.zoomIdentity.scale(h.range()[1]/(h(c[1])-h(c[0])))).translate.apply(d,o?g.reverse():g);i.eventRect.call(e.zoom.transform,f)}e.setZoomResetButton()}}else c=s.zoom?s.zoom.domain():s.x.orgDomain();return c};Y(pn,{enable:function(t){var e=this.internal,i=e.config;/^(drag|wheel)$/.test(t)&&(i.zoom_type=t),i.zoom_enabled=!!t,e.zoom?!1===t&&e.bindZoomEvent(!1):(e.initZoom(),e.bindZoomEvent()),e.updateAndRedraw()},max:function(t){var e=this.internal,i=e.config,n=e.org.xDomain;return(0===t||t)&&(i.zoom_x_max=q("max",[n[1],t])),i.zoom_x_max},min:function(t){var e=this.internal,i=e.config,n=e.org.xDomain;return(0===t||t)&&(i.zoom_x_min=q("min",[n[0],t])),i.zoom_x_min},range:function(t){var e=this.zoom;if(R(t)){var i=t.min,n=t.max;y(i)&&e.min(i),y(n)&&e.max(n)}return{min:e.min(),max:e.max()}}});var vn={zoom:pn,unzoom:function(){var t,e=this.internal,i=e.config,n=e.$el,a=n.eventRect,r=n.zoomResetBtn;e.scale.zoom&&(i.subchart_show?e.brush.getSelection().call(e.brush.move,null):e.zoom.updateTransformScale(fn.zoomIdentity),e.updateZoom(!0),null==(t=r)||t.style("display","none"),(0,fn.zoomTransform)(a.node())!==fn.zoomIdentity&&e.zoom.transform(a,fn.zoomIdentity))}},xn={drag:function(t){var e=this,i=e.config,a=e.state,r=e.$el.main,s=i.data_selection_grouped,o=i.interaction_enabled&&i.data_selection_isselectable;if(!e.hasArcType()&&i.data_selection_enabled&&(!i.zoom_enabled||e.zoom.altDomain)&&i.data_selection_multiple){var l=a.dragStart||[0,0],c=l[0],u=l[1],d=t[0],h=t[1],g=Math.min(c,d),f=Math.max(c,d),p=s?a.margin.top:Math.min(u,h),v=s?a.height:Math.max(u,h);r.select("."+gt.dragarea).attr("x",g).attr("y",p).attr("width",f-g).attr("height",v-p),r.selectAll("."+wt.shapes).selectAll("."+wt.shape).filter((function(t){var i;return null==(i=o)?void 0:i.bind(e.api)(t)})).each((function(t,i){var a,r=(0,n.select)(this),s=r.classed(Tt.SELECTED),o=r.classed(gt.INCLUDED),l=!1;if(r.classed(dt.circle)){var c=1*+r.attr("cx"),u=1*+r.attr("cy");a=e.togglePoint,l=g<c&&c<f&&p<u&&u<v}else{if(!r.classed(ct.bar))return;var d=function(t){var e=t.getBoundingClientRect(),i=e.width,n=e.height,a=z(t);return{x:a[0].x,y:Math.min(a[0].y,a[1].y),width:i,height:n}}(this),h=d.x,x=(u=d.y,d.width),_=d.height;a=e.togglePath,l=!(f<h||h+x<g||v<u||u+_<p)}l^o&&(r.classed(gt.INCLUDED,!o),r.classed(Tt.SELECTED,!s),a.call(e,!s,r,t,i))}))}},dragstart:function(t){var e=this,i=e.config,n=e.state,a=e.$el.main;!e.hasArcType()&&i.data_selection_enabled&&(n.dragStart=t,a.select("."+rt.chart).append("rect").attr("class",gt.dragarea).style("opacity","0.1"),e.setDragStatus(!0))},dragend:function(){var t=this,e=t.config,i=t.$el.main,n=t.$T;!t.hasArcType()&&e.data_selection_enabled&&(n(i.select("."+gt.dragarea)).style("opacity","0").remove(),i.selectAll("."+wt.shape).classed(gt.INCLUDED,!1),t.setDragStatus(!1))}};function _n(t,e){var i=Object.keys(t);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(t);e&&(n=n.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),i.push.apply(i,n)}return i}function mn(t){for(var e,i=1;i<arguments.length;i++)e=null!=arguments[i]?arguments[i]:{},i%2?_n(Object(e),!0).forEach((function(i){c(t,i,e[i])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(e)):_n(Object(e)).forEach((function(i){Object.defineProperty(t,i,Object.getOwnPropertyDescriptor(e,i))}));return t}var yn=mn(mn({},xn),{},{selectPoint:function(t,e,i){var n=this,a=n.config,r=n.$el.main,s=n.$T,o=a.axis_rotated,l=(o?n.circleY:n.circleX).bind(n),c=(o?n.circleX:n.circleY).bind(n),u=n.pointSelectR.bind(n);L(a.data_onselected,n.api,e,t.node()),s(r.select("."+Tt.selectedCircles+n.getTargetSelectorSuffix(e.id)).selectAll("."+Tt.selectedCircle+"-"+i).data([e]).enter().append("circle").attr("class",(function(){return n.generateClass(Tt.selectedCircle,i)})).attr("cx",l).attr("cy",c).attr("stroke",n.color).attr("r",(function(t){return 1.4*n.pointSelectR(t)}))).attr("r",u)},unselectPoint:function(t,e,i){var n=this,a=n.config,r=n.$el.main,s=n.$T;L(a.data_onunselected,n.api,e,t.node()),s(r.select("."+Tt.selectedCircles+n.getTargetSelectorSuffix(e.id)).selectAll("."+Tt.selectedCircle+"-"+i)).attr("r",0).remove()},togglePoint:function(t,e,i,n){this[(t?"":"un")+"selectPoint"](e,i,n)},selectPath:function(t,e){var i=this.config;L(i.data_onselected,this.api,e,t.node()),i.interaction_brighten&&t.style("filter","brightness(1.25)")},unselectPath:function(t,e){var i=this.config;L(i.data_onunselected,this.api,e,t.node()),i.interaction_brighten&&t.style("filter",null)},togglePath:function(t,e,i,n){this[(t?"":"un")+"selectPath"](e,i,n)},getToggle:function(t,e){var i=this;return"path"===t.nodeName?i.togglePath:i.isStepType(e)?function(){}:i.togglePoint},toggleShape:function(t,e,i){var a=this,r=a.config,s=a.$el.main;if(r.data_selection_enabled&&r.data_selection_isselectable.bind(a.api)(e)){var o,l=(0,n.select)(t),c=l.classed(Tt.SELECTED),u=a.getToggle(t,e).bind(a);if(!r.data_selection_multiple){var d="."+wt.shapes;r.data_selection_grouped&&(d+=a.getTargetSelectorSuffix(e.id)),s.selectAll(d).selectAll("."+wt.shape).each((function(t,e){var i=(0,n.select)(this);i.classed(Tt.SELECTED)&&(o=i,u(!1,i.classed(Tt.SELECTED,!1),t,e))}))}o&&o.node()===l.node()||(l.classed(Tt.SELECTED,!c),u(!c,l,e,i))}}}),bn={initBrush:function(){var t,e,i=this,a=i.config,r=i.scale,s=i.$el.subchart,o=a.axis_rotated;i.brush=(o?(0,u.brushY)():(0,u.brushX)()).handleSize(5);i.brush.on("start brush end",(function(e){var n=e.selection,a=e.target,s=e.type;"start"===s&&"touch"===i.state.inputType&&i.hideTooltip(),/(start|brush)/.test(s)&&i.redrawForBrush(),"end"===s&&(t=r.x.orgDomain()),null!=a&&a.handle&&(null===n?i.brush.handle.attr("display","none"):i.brush.handle.attr("display",null).attr("transform",(function(t,e){return"translate("+(o?[33,n[e]-(0===e?30:24)]:[n[e],3])+")"})))})),i.brush.updateResize=function(){var i=this;e&&clearTimeout(e),e=setTimeout((function(){var e=i.getSelection();t&&(0,u.brushSelection)(e.node())&&i.move(e,t.map(r.subX.orgScale()))}),0)},i.brush.update=function(){var t;0===this.extent()()[1].filter((function(t){return isNaN(t)})).length&&(null==(t=s.main)||t.select("."+Et.brush).call(this));return this},i.brush.scale=function(t){var e,n,r=a.subchart_size_height||(e=i.$el.svg.select("."+Et.brush+" .overlay"),n={width:0,height:0},e.size()&&(n.width=+e.attr("width"),n.height=+e.attr("height")),n[o?"width":"height"]),s=i.getExtent();!s&&t.range?s=[[0,0],[t.range()[1],r]]:E(s)&&(s=s.map((function(t,e){return[t,e>0?r:e]}))),o&&s[1].reverse(),this.extent(s),this.update()},i.brush.getSelection=function(){return s.main?s.main.select("."+Et.brush):(0,n.select)([])}},initSubchart:function(){var t=this,e=t.config,i=t.state,n=i.clip,a=i.hasAxis,r=t.$el,s=r.defs,o=r.svg,l=r.subchart,c=r.axis;if(a){var u=e.subchart_show?null:"hidden",d=n.id+"-subchart",h=t.getClipPath(d);n.idSubchart=d,t.appendClip(s,d),t.initBrush(),l.main=o.append("g").classed(Et.subchart,!0).attr("transform",t.getTranslate("context"));var g=l.main;g.style("visibility",u),g.append("g").attr("clip-path",h).attr("class",Et.chart),["bar","line","bubble","candlestick","scatter"].forEach((function(e){var i=G(/^(bubble|scatter)$/.test(e)?"circle":e);if(t.hasType(e)||t.hasTypeOf(i)){var n=g.select("."+Et.chart),a=Et["chart"+i+"s"];n.select("."+a).empty()&&n.append("g").attr("class",a)}}));var f=g.append("g").attr("clip-path",h).attr("class",Et.brush).call(t.brush);e.subchart_showHandle&&t.addBrushHandle(f),c.subX=g.append("g").attr("class",Et.axisX).attr("transform",t.getTranslate("subX")).attr("clip-path",e.axis_rotated?"":n.pathXAxis).style("visibility",e.subchart_axis_x_show?u:"hidden")}},addBrushHandle:function(t){var e=this.config,i=e.axis_rotated,n=e.subchart_init_range,a="handle--custom",r=i?["M 5.2491724,29.749209 a 6,6 0 0 0 -5.50000003,-6.5 H -5.7508276 a 6,6 0 0 0 -6.0000004,6.5 z m -5.00000003,-2 H -6.7508276 m 6.99999997,-2 H -6.7508276Z","M 5.2491724,23.249172 a 6,-6 0 0 1 -5.50000003,6.5 H -5.7508276 a 6,-6 0 0 1 -6.0000004,-6.5 z m -5.00000003,2 H -6.7508276 m 6.99999997,2 H -6.7508276Z"]:["M 0 18 A 6 6 0 0 0 -6.5 23.5 V 29 A 6 6 0 0 0 0 35 Z M -2 23 V 30 M -4 23 V 30Z","M 0 18 A 6 6 0 0 1 6.5 23.5 V 29 A 6 6 0 0 1 0 35 Z M 2 23 V 30 M 4 23 V 30Z"];this.brush.handle=t.selectAll(".handle--custom").data(i?[{type:"n"},{type:"s"}]:[{type:"w"},{type:"e"}]).enter().append("path").attr("class",a).attr("cursor",(i?"ns":"ew")+"-resize").attr("d",(function(t){return r[+/[se]/.test(t.type)]})).attr("display",n?null:"none")},updateTargetsForSubchart:function(t){var e=this,i=e.config,n=e.state,a=e.$el.subchart.main;i.subchart_show&&(["bar","line","bubble","candlestick","scatter"].filter((function(t){return e.hasType(t)||e.hasTypeOf(G(t))})).forEach((function(i){var n=/^(bubble|scatter)$/.test(i),r=G(n?"circle":i),s=e.getChartClass(r,!0),o=e.getClass(n?"circles":i+"s",!0),l=a.select("."+Et["chart"+r+"s"]);if(n){var c=l.selectAll("."+Et.circles).data(t.filter(e["is"+G(i)+"Type"].bind(e))).attr("class",o);c.exit().remove(),c.enter().append("g").attr("class",o)}else{var u=l.selectAll("."+Et["chart"+r]).attr("class",s).data(t.filter(e["is"+r+"Type"].bind(e))),d=u.enter().append("g").style("opacity","0").attr("class",s).append("g").attr("class",o);u.exit().remove(),"line"===i&&e.hasTypeOf("Area")&&d.append("g").attr("class",e.getClass("areas",!0))}})),a.selectAll("."+Et.brush+" rect").attr(i.axis_rotated?"width":"height",i.axis_rotated?n.width2:n.height2))},redrawSubchart:function(t,e,i){var n,a=this,r=a.config,s=a.$el.subchart.main,o=a.state,l=!!e;if((s.style("visibility",r.subchart_show?null:"hidden"),r.subchart_show)&&("zoom"===(null==(n=o.event)?void 0:n.type)&&a.brush.update(),t)){var c=r.subchart_init_range;if(N(a)||a.brush.update(),Object.keys(i.type).forEach((function(t){var e=G(t),n=a["generateDraw"+e](i.indices[t],!0);a["update"+e](l,!0),a["redraw"+e](n,l,!0)})),a.hasType("bubble")||a.hasType("scatter")){var u=i.pos.cx,d=a.updateCircleY(!0);a.updateCircle(!0),a.redrawCircle(u,d,l,void 0,!0)}!o.rendered&&c&&a.brush.move(a.brush.getSelection(),c.map(a.scale.x))}},redrawForBrush:function(){var t=this,e=t.config,i=e.subchart_onbrush,n=e.zoom_rescale,a=t.scale;t.redraw({withTransition:!1,withY:n,withSubchart:!1,withUpdateXDomain:!0,withDimension:!1}),i.bind(t.api)(a.x.orgDomain())},transformContext:function(t,e){var i=this,n=i.$el.subchart,a=i.$T,r=null!=e&&e.axisSubX?e.axisSubX:a(n.main.select("."+Et.axisX),t);n.main.attr("transform",i.getTranslate("context")),r.attr("transform",i.getTranslate("subX"))},getExtent:function(){var t=this,e=t.config,i=t.scale,n=e.axis_x_extent;if(n)if(v(n))n=n.bind(t.api)(t.getXDomain(t.data.targets),i.subX);else if(t.axis.isTimeSeries()&&n.every(isNaN)){var a=tt.bind(t);n=n.map((function(t){return i.subX(a(t))}))}return n}},Tn={initZoom:function(){var t=this;t.scale.zoom=null,t.generateZoom(),t.initZoomBehaviour()},bindZoomEvent:function(t){void 0===t&&(t=!0);var e=this,i=e.config;i.zoom_enabled&&t?i.subchart_show||e.bindZoomOnEventRect():!1===t&&(e.api.unzoom(),e.unbindZoomEvent())},generateZoom:function(){var t=this,e=t.config,i=t.org,n=t.scale,a=(0,fn.zoom)().duration(0).on("start",t.onZoomStart.bind(t)).on("zoom",t.onZoom.bind(t)).on("end",t.onZoomEnd.bind(t));a.orgScaleExtent=function(){var i=e.zoom_extent||[1,10];return[i[0],Math.max(t.getMaxDataCount()/i[1],i[1])]},a.updateScaleExtent=function(){var e=A(t.scale.x.orgDomain())/A(t.getZoomDomain()),i=this.orgScaleExtent();return this.scaleExtent([i[0]*e,i[1]*e]),this},a.updateTransformScale=function(a){var r;null==(r=i.xScale)||r.range(n.x.range());var s=a[e.axis_rotated?"rescaleY":"rescaleX"](i.xScale||n.x),o=t.trimXDomain(s.domain()),l=e.zoom_rescale;s.domain(o,i.xDomain),t.state.xTickOffset||(t.state.xTickOffset=t.axis.x.tickOffset()),n.zoom=t.getCustomizedScale(s),t.axis.x.scale(n.zoom),l&&(i.xScale||(i.xScale=n.x.copy()),n.x.domain(o))},a.getDomain=function(){var e=n[n.zoom?"zoom":"subX"].domain();return t.axis.isCategorized()&&(e[1]-=2),e},t.zoom=a},onZoomStart:function(t){var e=this,i=t.sourceEvent;i&&(e.zoom.startEvent=i,e.state.zooming=!0,L(e.config.zoom_onzoomstart,e.api,t))},onZoom:function(t){var e,i,n,a,r=this,s=r.config,o=r.scale,l=r.state,c=r.org,u=t.sourceEvent,d=(null==t?void 0:t.transform)===fn.zoomIdentity;if(!(!s.zoom_enabled||0===r.filterTargetsToShow(r.data.targets).length||!o.zoom&&(null==(e=u)?void 0:e.type.indexOf("touch"))>-1&&1===(null==(i=u)?void 0:i.touches.length))){t.sourceEvent&&(l.zooming=!0);var h="mousemove"===(null==(n=u)?void 0:n.type),g=(null==(a=u)?void 0:a.wheelDelta)<0,f=t.transform;!h&&g&&o.x.domain().every((function(t,e){return t!==c.xDomain[e]}))&&o.x.domain(c.xDomain),r.zoom.updateTransformScale(f);var p=s.transition_duration>0&&!s.subchart_show&&(l.dragging||d||!t.sourceEvent);r.redraw({withTransition:p,withY:s.zoom_rescale,withSubchart:!1,withEventRect:!1,withDimension:!1}),r.state.cancelClick=h,d||L(s.zoom_onzoom,r.api,r.zoom.getDomain())}},onZoomEnd:function(t){var e,i,n,a=this,r=a.config,s=a.state,o=a.zoom.startEvent,l=null==t?void 0:t.sourceEvent,c=(null==t?void 0:t.transform)===fn.zoomIdentity;(null==(e=o)?void 0:e.type.indexOf("touch"))>-1&&(o=o.changedTouches[0],l=null==(i=l)||null==(n=i.changedTouches)?void 0:n[0]);"drag"===r.zoom_type&&l&&o.clientX===l.clientX&&o.clientY===l.clientY||(a.redrawEventRect(),a.updateZoom(),s.zooming=!1,!c&&(l||s.dragging)&&L(r.zoom_onzoomend,a.api,a.zoom.getDomain()))},updateZoom:function(t){var e=this,i=e.scale,n=i.subX,a=i.x,r=i.zoom;if(r){var s=r.domain(),o=n.domain(),l=(s[0]<=o[0]||s[0]-.015<=o[0])&&(o[1]<=s[1]||o[1]<=s[1]-.015);(t||l)&&(e.axis.x.scale(n),a.domain(n.orgDomain()),e.scale.zoom=null)}},bindZoomOnEventRect:function(){var t=this,e=t.config,i=t.$el.eventRect,n="drag"===e.zoom_type?t.zoomBehaviour:t.zoom;t.$el.svg.on("wheel",(function(){})),i.call(n).on("dblclick.zoom",null)},initZoomBehaviour:function(){var t,e=this,i=e.config,n=e.state,a=i.axis_rotated,r=0,s=0,o={axis:a?"y":"x",attr:a?"height":"width",index:a?1:0};e.zoomBehaviour=(0,re.drag)().clickDistance(4).on("start",(function(i){n.event=i,e.setDragStatus(!0),e.unselectRect(),t||(t=e.$el.main.append("rect").attr("clip-path",n.clip.path).attr("class",Ct.zoomBrush).attr("width",a?n.width:0).attr("height",a?0:n.height)),r=M(i,this)[o.index],s=r,t.attr(o.axis,r).attr(o.attr,0),e.onZoomStart(i)})).on("drag",(function(e){s=M(e,this)[o.index],t.attr(o.axis,Math.min(r,s)).attr(o.attr,Math.abs(s-r))})).on("end",(function(i){var a=e.scale.zoom||e.scale.x;if(n.event=i,t.attr(o.axis,0).attr(o.attr,0),r>s){var l=[s,r];r=l[0],s=l[1]}r<0&&(s+=Math.abs(r),r=0),r!==s&&e.api.zoom([r,s].map((function(t){return a.invert(t)}))),e.setDragStatus(!1)}))},setZoomResetButton:function(){var t=this,e=t.config,i=t.$el,n=e.zoom_resetButton;n&&"drag"===e.zoom_type&&(i.zoomResetBtn?i.zoomResetBtn.style("display",null):i.zoomResetBtn=t.$el.chart.append("div").classed(rt.button,!0).append("span").on("click",(function(){v(n.onclick)&&n.onclick.bind(t.api)(this),t.api.unzoom()})).classed(Ct.buttonZoomReset,!0).text(n.text||"Reset Zoom"))}},wn={data_selection_enabled:!1,data_selection_grouped:!1,data_selection_isselectable:function(){return!0},data_selection_multiple:!0,data_selection_draggable:!1,data_onselected:function(){},data_onunselected:function(){}},An={subchart_show:!1,subchart_showHandle:!1,subchart_size_height:60,subchart_axis_x_show:!0,subchart_axis_x_tick_show:!0,subchart_axis_x_tick_format:void 0,subchart_axis_x_tick_text_show:!0,subchart_init_range:void 0,subchart_onbrush:function(){}},kn={zoom_enabled:!1,zoom_type:"wheel",zoom_extent:void 0,zoom_privileged:!1,zoom_rescale:!1,zoom_onzoom:void 0,zoom_onzoomstart:void 0,zoom_onzoomend:void 0,zoom_resetButton:!0,zoom_x_min:void 0,zoom_x_max:void 0},Sn=function(){return Y(Ee.prototype,yn),Y(Xe.prototype,hn),Bt.setOptions([wn]),(Sn=function(){return!0})()},Cn=function(){return Y(Ee.prototype,bn),Y(Xe.prototype,gn),Bt.setOptions([An]),(Cn=function(){return!0})()},En=function(){return Y(Ee.prototype,Tn),Y(Xe.prototype,vn),Bt.setOptions([kn]),(En=function(){return!0})()},Rn={},On={version:"3.3.3",generate:function(t){var e=U({},Rn,t),i=new Xe(e);return i.internal.charts=this.instance,this.instance.push(i),i},defaults:function(t){return R(t)&&(Rn=t),Rn},instance:[],plugin:{}};Object.keys(t).forEach((function(e){return t[e]()})),Object.keys(e).forEach((function(t){return e[t]()}))}(),p}()}));