/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { BlockSvg } from '../../block_svg.js';
import type { Connection } from '../../connection.js';
import type { BlockStyle } from '../../theme.js';
import { PathObject as BasePathObject } from '../common/path_object.js';
import type { ConstantProvider } from './constants.js';
/**
 * An object that handles creating and setting each of the SVG elements
 * used by the renderer.
 */
export declare class PathObject extends BasePathObject {
    /** The selected path of the block. */
    private svgPathSelected_;
    /** The outline paths on the block. */
    private readonly outlines;
    /**
     * A set used to determine which outlines were used during a draw pass.  The
     * set is initialized with a reference to all the outlines in
     * `this.outlines`. Every time we use an outline during the draw pass, the
     * reference is removed from this set.
     */
    private remainingOutlines;
    /**
     * The type of block's output connection shape.  This is set when a block
     * with an output connection is drawn.
     */
    outputShapeType: number | null;
    constants: ConstantProvider;
    /**
     * @param root The root SVG element.
     * @param style The style object to use for colouring.
     * @param constants The renderer's constants.
     */
    constructor(root: SVGElement, style: BlockStyle, constants: ConstantProvider);
    setPath(pathString: string): void;
    applyColour(block: BlockSvg): void;
    flipRTL(): void;
    updateSelected(enable: boolean): void;
    updateReplacementFade(enable: boolean): void;
    updateShapeForInputHighlight(conn: Connection, enable: boolean): void;
    /**
     * Method that's called when the drawer is about to draw the block.
     */
    beginDrawing(): void;
    /**
     * Method that's called when the drawer is done drawing.
     */
    endDrawing(): void;
    /**
     * Set the path generated by the renderer for an outline path on the
     * respective outline path SVG element.
     *
     * @param name The input name.
     * @param pathString The path.
     */
    setOutlinePath(name: string, pathString: string): void;
    /**
     * Create's an outline path for the specified input.
     *
     * @param name The input name.
     * @returns The SVG outline path.
     */
    private getOutlinePath_;
    /**
     * Remove an outline path that is associated with the specified input.
     *
     * @param name The input name.
     */
    private removeOutlinePath_;
}
//# sourceMappingURL=path_object.d.ts.map