/*
 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 - http://www.apache.org/licenses/LICENSE-2.0
 */
"use strict";
function areEqual(date1, date2) {
    if (date1 == null && date2 == null) {
        return true;
    }
    else if (date1 == null || date2 == null) {
        return false;
    }
    else {
        return date1.getTime() === date2.getTime();
    }
}
exports.areEqual = areEqual;
function areSameDay(date1, date2) {
    return date1 != null
        && date2 != null
        && date1.getDate() === date2.getDate()
        && date1.getMonth() === date2.getMonth()
        && date1.getFullYear() === date2.getFullYear();
}
exports.areSameDay = areSameDay;
function areSameMonth(date1, date2) {
    return date1 != null
        && date2 != null
        && date1.getMonth() === date2.getMonth()
        && date1.getFullYear() === date2.getFullYear();
}
exports.areSameMonth = areSameMonth;
function areSameTime(date1, date2) {
    return date1 != null
        && date2 != null
        && date1.getHours() === date2.getHours()
        && date1.getMinutes() === date2.getMinutes()
        && date1.getSeconds() === date2.getSeconds()
        && date1.getMilliseconds() === date2.getMilliseconds();
}
exports.areSameTime = areSameTime;
function clone(d) {
    return new Date(d.getTime());
}
exports.clone = clone;
function isDayInRange(date, dateRange, exclusive) {
    if (exclusive === void 0) { exclusive = false; }
    if (date == null) {
        return false;
    }
    var day = clone(date);
    var start = clone(dateRange[0]);
    var end = clone(dateRange[1]);
    day.setHours(0, 0, 0, 0);
    start.setHours(0, 0, 0, 0);
    end.setHours(0, 0, 0, 0);
    return start <= day && day <= end
        && (!exclusive
            || !areSameDay(start, day) && !areSameDay(day, end));
}
exports.isDayInRange = isDayInRange;
function isDayRangeInRange(innerRange, outerRange) {
    return (innerRange[0] == null || isDayInRange(innerRange[0], outerRange))
        && (innerRange[1] == null || isDayInRange(innerRange[1], outerRange));
}
exports.isDayRangeInRange = isDayRangeInRange;
function isMonthInRange(date, dateRange) {
    if (date == null) {
        return false;
    }
    var day = clone(date);
    var start = clone(dateRange[0]);
    var end = clone(dateRange[1]);
    day.setDate(1);
    start.setDate(1);
    end.setDate(1);
    day.setHours(0, 0, 0, 0);
    start.setHours(0, 0, 0, 0);
    end.setHours(0, 0, 0, 0);
    return start <= day && day <= end;
}
exports.isMonthInRange = isMonthInRange;
/**
 * @returns a Date at the exact time-wise midpoint between startDate and endDate
 */
function getDateBetween(dateRange) {
    var start = dateRange[0].getTime();
    var end = dateRange[1].getTime();
    var middle = start + (end - start) * 0.5;
    return new Date(middle);
}
exports.getDateBetween = getDateBetween;
function getDateTime(date, time) {
    return new Date(date.getFullYear(), date.getMonth(), date.getDate(), time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds());
}
exports.getDateTime = getDateTime;

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9jb21tb24vZGF0ZVV0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7R0FHRzs7QUFJSCxrQkFBeUIsS0FBVyxFQUFFLEtBQVc7SUFDN0MsRUFBRSxDQUFDLENBQUMsS0FBSyxJQUFJLElBQUksSUFBSSxLQUFLLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQztRQUNqQyxNQUFNLENBQUMsSUFBSSxDQUFDO0lBQ2hCLENBQUM7SUFBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsS0FBSyxJQUFJLElBQUksSUFBSSxLQUFLLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQztRQUN4QyxNQUFNLENBQUMsS0FBSyxDQUFDO0lBQ2pCLENBQUM7SUFBQyxJQUFJLENBQUMsQ0FBQztRQUNKLE1BQU0sQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLEtBQUssS0FBSyxDQUFDLE9BQU8sRUFBRSxDQUFDO0lBQy9DLENBQUM7QUFDTCxDQUFDO0FBUmUsZ0JBQVEsV0FRdkIsQ0FBQTtBQUVELG9CQUEyQixLQUFXLEVBQUUsS0FBVztJQUMvQyxNQUFNLENBQUMsS0FBSyxJQUFJLElBQUk7V0FDYixLQUFLLElBQUksSUFBSTtXQUNiLEtBQUssQ0FBQyxPQUFPLEVBQUUsS0FBSyxLQUFLLENBQUMsT0FBTyxFQUFFO1dBQ25DLEtBQUssQ0FBQyxRQUFRLEVBQUUsS0FBSyxLQUFLLENBQUMsUUFBUSxFQUFFO1dBQ3JDLEtBQUssQ0FBQyxXQUFXLEVBQUUsS0FBSyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7QUFDdkQsQ0FBQztBQU5lLGtCQUFVLGFBTXpCLENBQUE7QUFFRCxzQkFBNkIsS0FBVyxFQUFFLEtBQVc7SUFDakQsTUFBTSxDQUFDLEtBQUssSUFBSSxJQUFJO1dBQ2IsS0FBSyxJQUFJLElBQUk7V0FDYixLQUFLLENBQUMsUUFBUSxFQUFFLEtBQUssS0FBSyxDQUFDLFFBQVEsRUFBRTtXQUNyQyxLQUFLLENBQUMsV0FBVyxFQUFFLEtBQUssS0FBSyxDQUFDLFdBQVcsRUFBRSxDQUFDO0FBQ3ZELENBQUM7QUFMZSxvQkFBWSxlQUszQixDQUFBO0FBRUQscUJBQTRCLEtBQVcsRUFBRSxLQUFXO0lBQ2hELE1BQU0sQ0FBQyxLQUFLLElBQUksSUFBSTtXQUNiLEtBQUssSUFBSSxJQUFJO1dBQ2IsS0FBSyxDQUFDLFFBQVEsRUFBRSxLQUFLLEtBQUssQ0FBQyxRQUFRLEVBQUU7V0FDckMsS0FBSyxDQUFDLFVBQVUsRUFBRSxLQUFLLEtBQUssQ0FBQyxVQUFVLEVBQUU7V0FDekMsS0FBSyxDQUFDLFVBQVUsRUFBRSxLQUFLLEtBQUssQ0FBQyxVQUFVLEVBQUU7V0FDekMsS0FBSyxDQUFDLGVBQWUsRUFBRSxLQUFLLEtBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQztBQUMvRCxDQUFDO0FBUGUsbUJBQVcsY0FPMUIsQ0FBQTtBQUVELGVBQXNCLENBQU87SUFDekIsTUFBTSxDQUFDLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDO0FBQ2pDLENBQUM7QUFGZSxhQUFLLFFBRXBCLENBQUE7QUFFRCxzQkFBNkIsSUFBVSxFQUFFLFNBQW9CLEVBQUUsU0FBaUI7SUFBakIseUJBQWlCLEdBQWpCLGlCQUFpQjtJQUM1RSxFQUFFLENBQUMsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQztRQUNmLE1BQU0sQ0FBQyxLQUFLLENBQUM7SUFDakIsQ0FBQztJQUVELElBQU0sR0FBRyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN4QixJQUFNLEtBQUssR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbEMsSUFBTSxHQUFHLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBRWhDLEdBQUcsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDekIsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUMzQixHQUFHLENBQUMsUUFBUSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBRXpCLE1BQU0sQ0FBQyxLQUFLLElBQUksR0FBRyxJQUFJLEdBQUcsSUFBSSxHQUFHO1dBQzFCLENBQUMsQ0FBQyxTQUFTO2VBQ1AsQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQyxDQUFDO0FBQ2pFLENBQUM7QUFoQmUsb0JBQVksZUFnQjNCLENBQUE7QUFFRCwyQkFBa0MsVUFBcUIsRUFBRSxVQUFxQjtJQUMxRSxNQUFNLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksSUFBSSxJQUFJLFlBQVksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEVBQUUsVUFBVSxDQUFDLENBQUM7V0FDbEUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksSUFBSSxJQUFJLFlBQVksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEVBQUUsVUFBVSxDQUFDLENBQUMsQ0FBQztBQUM5RSxDQUFDO0FBSGUseUJBQWlCLG9CQUdoQyxDQUFBO0FBRUQsd0JBQStCLElBQVUsRUFBRSxTQUFvQjtJQUMzRCxFQUFFLENBQUMsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQztRQUNmLE1BQU0sQ0FBQyxLQUFLLENBQUM7SUFDakIsQ0FBQztJQUVELElBQU0sR0FBRyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN4QixJQUFNLEtBQUssR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbEMsSUFBTSxHQUFHLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBRWhDLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDZixLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2pCLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDZixHQUFHLENBQUMsUUFBUSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ3pCLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDM0IsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUV6QixNQUFNLENBQUMsS0FBSyxJQUFJLEdBQUcsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDO0FBQ3RDLENBQUM7QUFqQmUsc0JBQWMsaUJBaUI3QixDQUFBO0FBRUQ7O0dBRUc7QUFDSCx3QkFBK0IsU0FBb0I7SUFDL0MsSUFBTSxLQUFLLEdBQUcsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDO0lBQ3JDLElBQU0sR0FBRyxHQUFHLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUNuQyxJQUFNLE1BQU0sR0FBRyxLQUFLLEdBQUcsQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsR0FBRyxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztBQUM1QixDQUFDO0FBTGUsc0JBQWMsaUJBSzdCLENBQUE7QUFFRCxxQkFBNEIsSUFBVSxFQUFFLElBQVU7SUFDOUMsTUFBTSxDQUFDLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsRUFBRSxJQUFJLENBQUMsUUFBUSxFQUFFLEVBQUUsSUFBSSxDQUFDLE9BQU8sRUFBRSxFQUM1RCxJQUFJLENBQUMsUUFBUSxFQUFFLEVBQUUsSUFBSSxDQUFDLFVBQVUsRUFBRSxFQUFFLElBQUksQ0FBQyxVQUFVLEVBQUUsRUFBRSxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUMsQ0FBQztBQUMxRixDQUFDO0FBSGUsbUJBQVcsY0FHMUIsQ0FBQSIsImZpbGUiOiJjb21tb24vZGF0ZVV0aWxzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCAyMDE1IFBhbGFudGlyIFRlY2hub2xvZ2llcywgSW5jLiBBbGwgcmlnaHRzIHJlc2VydmVkLlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAtIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICovXG5cbmV4cG9ydCB0eXBlIERhdGVSYW5nZSA9IFtEYXRlLCBEYXRlXTtcblxuZXhwb3J0IGZ1bmN0aW9uIGFyZUVxdWFsKGRhdGUxOiBEYXRlLCBkYXRlMjogRGF0ZSkge1xuICAgIGlmIChkYXRlMSA9PSBudWxsICYmIGRhdGUyID09IG51bGwpIHtcbiAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgfSBlbHNlIGlmIChkYXRlMSA9PSBudWxsIHx8IGRhdGUyID09IG51bGwpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybiBkYXRlMS5nZXRUaW1lKCkgPT09IGRhdGUyLmdldFRpbWUoKTtcbiAgICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBhcmVTYW1lRGF5KGRhdGUxOiBEYXRlLCBkYXRlMjogRGF0ZSkge1xuICAgIHJldHVybiBkYXRlMSAhPSBudWxsXG4gICAgICAgICYmIGRhdGUyICE9IG51bGxcbiAgICAgICAgJiYgZGF0ZTEuZ2V0RGF0ZSgpID09PSBkYXRlMi5nZXREYXRlKClcbiAgICAgICAgJiYgZGF0ZTEuZ2V0TW9udGgoKSA9PT0gZGF0ZTIuZ2V0TW9udGgoKVxuICAgICAgICAmJiBkYXRlMS5nZXRGdWxsWWVhcigpID09PSBkYXRlMi5nZXRGdWxsWWVhcigpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXJlU2FtZU1vbnRoKGRhdGUxOiBEYXRlLCBkYXRlMjogRGF0ZSkge1xuICAgIHJldHVybiBkYXRlMSAhPSBudWxsXG4gICAgICAgICYmIGRhdGUyICE9IG51bGxcbiAgICAgICAgJiYgZGF0ZTEuZ2V0TW9udGgoKSA9PT0gZGF0ZTIuZ2V0TW9udGgoKVxuICAgICAgICAmJiBkYXRlMS5nZXRGdWxsWWVhcigpID09PSBkYXRlMi5nZXRGdWxsWWVhcigpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXJlU2FtZVRpbWUoZGF0ZTE6IERhdGUsIGRhdGUyOiBEYXRlKSB7XG4gICAgcmV0dXJuIGRhdGUxICE9IG51bGxcbiAgICAgICAgJiYgZGF0ZTIgIT0gbnVsbFxuICAgICAgICAmJiBkYXRlMS5nZXRIb3VycygpID09PSBkYXRlMi5nZXRIb3VycygpXG4gICAgICAgICYmIGRhdGUxLmdldE1pbnV0ZXMoKSA9PT0gZGF0ZTIuZ2V0TWludXRlcygpXG4gICAgICAgICYmIGRhdGUxLmdldFNlY29uZHMoKSA9PT0gZGF0ZTIuZ2V0U2Vjb25kcygpXG4gICAgICAgICYmIGRhdGUxLmdldE1pbGxpc2Vjb25kcygpID09PSBkYXRlMi5nZXRNaWxsaXNlY29uZHMoKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNsb25lKGQ6IERhdGUpIHtcbiAgICByZXR1cm4gbmV3IERhdGUoZC5nZXRUaW1lKCkpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNEYXlJblJhbmdlKGRhdGU6IERhdGUsIGRhdGVSYW5nZTogRGF0ZVJhbmdlLCBleGNsdXNpdmUgPSBmYWxzZSkge1xuICAgIGlmIChkYXRlID09IG51bGwpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cblxuICAgIGNvbnN0IGRheSA9IGNsb25lKGRhdGUpO1xuICAgIGNvbnN0IHN0YXJ0ID0gY2xvbmUoZGF0ZVJhbmdlWzBdKTtcbiAgICBjb25zdCBlbmQgPSBjbG9uZShkYXRlUmFuZ2VbMV0pO1xuXG4gICAgZGF5LnNldEhvdXJzKDAsIDAsIDAsIDApO1xuICAgIHN0YXJ0LnNldEhvdXJzKDAsIDAsIDAsIDApO1xuICAgIGVuZC5zZXRIb3VycygwLCAwLCAwLCAwKTtcblxuICAgIHJldHVybiBzdGFydCA8PSBkYXkgJiYgZGF5IDw9IGVuZFxuICAgICAgICAmJiAoIWV4Y2x1c2l2ZVxuICAgICAgICAgICAgfHwgIWFyZVNhbWVEYXkoc3RhcnQsIGRheSkgJiYgIWFyZVNhbWVEYXkoZGF5LCBlbmQpKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzRGF5UmFuZ2VJblJhbmdlKGlubmVyUmFuZ2U6IERhdGVSYW5nZSwgb3V0ZXJSYW5nZTogRGF0ZVJhbmdlKSB7XG4gICAgcmV0dXJuIChpbm5lclJhbmdlWzBdID09IG51bGwgfHwgaXNEYXlJblJhbmdlKGlubmVyUmFuZ2VbMF0sIG91dGVyUmFuZ2UpKVxuICAgICAgICAmJiAoaW5uZXJSYW5nZVsxXSA9PSBudWxsIHx8IGlzRGF5SW5SYW5nZShpbm5lclJhbmdlWzFdLCBvdXRlclJhbmdlKSk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc01vbnRoSW5SYW5nZShkYXRlOiBEYXRlLCBkYXRlUmFuZ2U6IERhdGVSYW5nZSkge1xuICAgIGlmIChkYXRlID09IG51bGwpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cblxuICAgIGNvbnN0IGRheSA9IGNsb25lKGRhdGUpO1xuICAgIGNvbnN0IHN0YXJ0ID0gY2xvbmUoZGF0ZVJhbmdlWzBdKTtcbiAgICBjb25zdCBlbmQgPSBjbG9uZShkYXRlUmFuZ2VbMV0pO1xuXG4gICAgZGF5LnNldERhdGUoMSk7XG4gICAgc3RhcnQuc2V0RGF0ZSgxKTtcbiAgICBlbmQuc2V0RGF0ZSgxKTtcbiAgICBkYXkuc2V0SG91cnMoMCwgMCwgMCwgMCk7XG4gICAgc3RhcnQuc2V0SG91cnMoMCwgMCwgMCwgMCk7XG4gICAgZW5kLnNldEhvdXJzKDAsIDAsIDAsIDApO1xuXG4gICAgcmV0dXJuIHN0YXJ0IDw9IGRheSAmJiBkYXkgPD0gZW5kO1xufVxuXG4vKipcbiAqIEByZXR1cm5zIGEgRGF0ZSBhdCB0aGUgZXhhY3QgdGltZS13aXNlIG1pZHBvaW50IGJldHdlZW4gc3RhcnREYXRlIGFuZCBlbmREYXRlXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBnZXREYXRlQmV0d2VlbihkYXRlUmFuZ2U6IERhdGVSYW5nZSkge1xuICAgIGNvbnN0IHN0YXJ0ID0gZGF0ZVJhbmdlWzBdLmdldFRpbWUoKTtcbiAgICBjb25zdCBlbmQgPSBkYXRlUmFuZ2VbMV0uZ2V0VGltZSgpO1xuICAgIGNvbnN0IG1pZGRsZSA9IHN0YXJ0ICsgKGVuZCAtIHN0YXJ0KSAqIDAuNTtcbiAgICByZXR1cm4gbmV3IERhdGUobWlkZGxlKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldERhdGVUaW1lKGRhdGU6IERhdGUsIHRpbWU6IERhdGUpIHtcbiAgICByZXR1cm4gbmV3IERhdGUoZGF0ZS5nZXRGdWxsWWVhcigpLCBkYXRlLmdldE1vbnRoKCksIGRhdGUuZ2V0RGF0ZSgpLFxuICAgICAgICAgICB0aW1lLmdldEhvdXJzKCksIHRpbWUuZ2V0TWludXRlcygpLCB0aW1lLmdldFNlY29uZHMoKSwgdGltZS5nZXRNaWxsaXNlY29uZHMoKSk7XG59XG4iXSwic291cmNlUm9vdCI6Ii9zb3VyY2UvIn0=
